/*
* Copyright (c) 2010 Sasken Communication Technologies Ltd.
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the "{License}"
* which accompanies  this distribution, and is available
* at the URL "{LicenseUrl}".
*
* Initial Contributors:
* Chandradeep Gandhi, Sasken Communication Technologies Ltd - Initial contribution
*
* Contributors:
*
* Description:
* Interface spefication for music related services
*
*/

#ifndef SMFMUSIC_H
#define SMFMUSIC_H

class SmfProvider; //basic Smf service Provider info
class SmfMusicRating;//rating value from 0..31 - services would map accordingly
class SmfMusicProfile; //user profile containing music usage and interest info, extends SmfContact
class SmfTracknfo; //id, title, album, artist, genre, tag, director,release year, rating, comment info
class SmfMusicFingerPrint; //generation is not in scope of smf

class SmfMusicModel;

/**
  * basic music service ("org.symbian.smf.music.service")
  */
class SmfMusicService : public SmfProvider
{
  Q_OBJECT;

public:
  // Seeing as this is a plug-in implementation, these will realistically
  // be generated by SMF factory of some kind
  SmfMusicService(QObject* parent = 0);
  ~SmfMusicService();

public:
  virtual SmfMusicProfile userinfo() = 0; // get self profile information
  virtual QList<SmfMusicProfile> searchUser(SmfVenue venue) = 0; // search information about other service users
  virtual SmfMusicModel model() = 0; // maybe we can make a QItemModel-derived model?

slots:


signals:

};

/**
* provides service ("org.symbian.smf.music.search")
*/
class SmfMusicSearch : public SmfProvider
{
  Q_OBJECT;

public:
  // Seeing as this is a plug-in implementation, these will realistically
  // be generated by SMF factory of some kind
  SmfMusicSearch(QObject* parent = 0);
  ~SmfMusicSearch();

public:
  // Get the track listing - might be made asynchrnous later
  virtual QList<SmfTrackInfo> recommendations(SmfTrackInfo track) = 0; // basic list of track objects
  virtual QList<SmfTrackInfo> tracks(SmfTrackInfo track) = 0; // basic list of track objects
  virtual QList<SmfTrackInfo> trackInfo(SmfMusicFingerPrint signature) = 0; // search by fingerprint object
  virtual QList<SmfProvider> stores(SmfTrackInfo track) = 0; // search information about where to buy this song from

slots:
  virtual int postCurrentPlaying(SmfTrackInfo track) = 0;
  //virtual int postRating(SmfTrackInfo track, SmfMusicRating rate) = 0;
  //virtual int postComments(SmfTrackInfo track, SmfComment comment) = 0;

signal:

}

class SmfPlaylist;//remote playlist
/**
 * provides service ("org.symbian.smf.music.playlist")
 *
 * Interface to a remote playlist service. This class
 * provides some basic functionality to allow applications
 * to interact with playlists in some music related service provider (e.g. last.fm).
 *
 * Note that branding information for the particular service implementation
 * is available from base-class functions. See also:
 * SmfProvider::serviceName(), SmfProvider::serviceIcon()
 *
 * All of the functionality described here should be implemented by a service
 * specific plug-in object.
 *
 */
class SmfPlaylistService : public SmfProvider
{
  Q_OBJECT;

public:
  // Seeing as this is a plug-in implementation, these will realistically
  // be generated by SMF factory of some kind
  SmfPlaylistService(QObject* parent = 0);
  ~SmfPlaylistService();

public:
  // Get the playist listing - might be made asynchrnous later
  virtual QList<SmfPlaylist> playlists() = 0; // basic list of playlist objects for the logged-in user
  virtual QList<SmfPlaylist> playlistsOf(SmfMusicProfile user) = 0; // basic list of playlist objects for other user


slots:
  // Upload currently playing song, etc - slots can connect to UI controls more easily
  virtual int addToPlaylist(SmfPlaylist plst, QList<SmfTrackInfo> tracks) = 0;
  virtual int postCurrentPlayingPlaylist(SmfPlaylist plst) = 0;


signals:
 //signals remote updation of playlist
  virtual int playlistUpdated(void) = 0;
};



class SmfEvent;//musical events
class SmfVenue;//popular venues
/**
* provides service ("org.symbian.smf.music.events")
*/
class SmfMusicEvents : public SmfProvider
{
  Q_OBJECT;

public:
  // Seeing as this is a plug-in implementation, these will realistically
  // be generated by SMF factory of some kind
  SmfMusicEvents(QObject* parent = 0);
  ~SmfMusicEvents();

public:
  virtual QList<SmfEvents> events(QContactGeolocation location) = 0; // basic list of events objects
  virtual QList<SmfVenue> venues(QContactGeolocation location) = 0; // basic list of venue objects
  virtual QList<SmfEvents> events(SmfVenue venue) = 0; // basic list of events objects

slot:
 //update your event
 virtual void postEvents(QList<SmfEvents> events); //might not be supported by all service provider

signal:
 virtual void eventsupdated(void);
};




class SmfSubtitleSearchFilter;//language, frame rate, duration, release year
/**
* provides service ("org.symbian.smf.music.lyrics")
*/
class SmfLyricsService : public SmfProvider
{
  Q_OBJECT;

public:
  // Seeing as this is a plug-in implementation, these will realistically
  // be generated by SMF factory of some kind
  SmfLyricsService(QObject* parent = 0);
  ~SmfLyricsService();

public:
  // Get the lyrics listing - might be made asynchrnous later
  virtual QList<SmfLyrics> lyrics(SmfTrackInfo track) = 0; //texts without time information
  virtual QList<SmfSubtitle> subtitles(SmfTrackInfo track, SmfSubtitleSearchFilter filter) = 0; // texts with time information


slots:


signals:

};


#endif // SMFMUSIC_H

