/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

// It contains common definitions for the client and customisation API.
// It should not be modified manually.

#ifndef SKINLAYOUT_CDL_COMMON_H
#define SKINLAYOUT_CDL_COMMON_H


#include <AknLayout2Def.h>


namespace SkinLayout
{
#include "skinlayout.cdl.common.hrh"

// These constants are defined by the CDL interface: SkinLayout
_LIT(KCdlName, "SkinLayout");
const TInt KCdlInterfaceUidValue = _CDL_SkinLayout_KCdlInterfaceUidValue;
const TUid KCdlInterfaceUid = { KCdlInterfaceUidValue };
const TInt KCdlInterfaceMajorVersion = 1;
const TInt KCdlInterfaceMinorVersion = 0;
const TUint KCdlInterfaceFlags = KCdlFlagRomOnly;

// These are the API ids used in this interface.
enum TApiId
	{
	EApiId_xInput_field_skin_placing__find_list__Line_1,
	EApiId_xInput_field_skin_placing__find_list__Line_2,
	EApiId_xInput_field_skin_placing__find_list__Line_3,
	EApiId_xInput_field_skin_placing__find_list__Line_4,
	EApiId_xInput_field_skin_placing__find_list__Line_5,
	EApiId_xInput_field_skin_placing__find_list__Line_6,
	EApiId_xInput_field_skin_placing__find_list__Line_7,
	EApiId_xInput_field_skin_placing__find_list__Line_8,
	EApiId_xInput_field_skin_placing__find_list__Line_9,
	EApiId_xInput_field_skin_placing__find_list__Limits,
	EApiId_xInput_field_skin_placing__find_list_,
	EApiId_Screen_background_skin_placing_Line_1,
	EApiId_Area_background_skin_placing_Line_1,
	EApiId_Area_background_skin_placing_Line_2,
	EApiId_Area_background_skin_placing_Line_3,
	EApiId_Pane_background_skin_naming_Line_1,
	EApiId_Navi_pane_background_stripe_skin_placing_Line_1,
	EApiId_Navi_pane_background_stripe_skin_placing_Line_2,
	EApiId_Volume_level_skin_placing_Line_1,
	EApiId_Volume_level_skin_placing_Line_2,
	EApiId_Volume_level_skin_placing_Limits,
	EApiId_Volume_level_skin_placing,
	EApiId_Volume_area_values_Line_1,
	EApiId_Volume_area_values_Line_2,
	EApiId_Volume_area_values_Line_3,
	EApiId_Volume_area_values_Line_4,
	EApiId_Volume_area_values_Line_5,
	EApiId_Volume_area_values_Line_6,
	EApiId_Volume_area_values_Line_7,
	EApiId_Volume_area_values_Line_8,
	EApiId_Volume_area_values_Line_9,
	EApiId_Volume_area_values_Line_10,
	EApiId_Volume_area_values_Line_11,
	EApiId_Volume_area_values_Limits,
	EApiId_Volume_area_values,
	EApiId_Column_background_and_list_slice_skin_placing_Line_1,
	EApiId_Column_background_and_list_slice_skin_placing_Line_2,
	EApiId_Column_background_and_list_slice_skin_placing_Line_3,
	EApiId_Column_background_and_list_slice_skin_placing_Line_4,
	EApiId_Column_background_and_list_slice_skin_placing_Line_5,
	EApiId_Column_background_and_list_slice_skin_placing_Line_6,
	EApiId_Column_background_and_list_slice_skin_placing_Line_7,
	EApiId_Column_background_and_list_slice_skin_placing_Limits,
	EApiId_Column_background_and_list_slice_skin_placing,
	EApiId_Setting_list_item_skin_elements__value_background__Line_1,
	EApiId_Setting_list_item_skin_elements__value_background__Line_2,
	EApiId_Setting_list_item_skin_elements__value_background__Line_3,
	EApiId_Setting_list_item_skin_elements__value_background__Line_4,
	EApiId_Setting_list_item_skin_elements__value_background__Line_5,
	EApiId_Setting_list_item_skin_elements__value_background__Line_6,
	EApiId_Setting_list_item_skin_elements__value_background__Line_7,
	EApiId_Setting_list_item_skin_elements__value_background__Line_8,
	EApiId_Setting_list_item_skin_elements__value_background__Line_9,
	EApiId_Setting_list_item_skin_elements__value_background__Limits,
	EApiId_Setting_list_item_skin_elements__value_background_,
	EApiId_Setting_list_item_skin_placing__volume__Line_1,
	EApiId_Setting_list_item_skin_placing__volume__Line_2,
	EApiId_Setting_list_item_skin_placing__volume__Limits,
	EApiId_Setting_list_item_skin_placing__volume_,
	EApiId_Settings_volume_area_values_Line_1,
	EApiId_Settings_volume_area_values_Line_2,
	EApiId_Settings_volume_area_values_Line_3,
	EApiId_Settings_volume_area_values_Line_4,
	EApiId_Settings_volume_area_values_Line_5,
	EApiId_Settings_volume_area_values_Line_6,
	EApiId_Settings_volume_area_values_Line_7,
	EApiId_Settings_volume_area_values_Line_8,
	EApiId_Settings_volume_area_values_Line_9,
	EApiId_Settings_volume_area_values_Line_10,
	EApiId_Settings_volume_area_values_Line_11,
	EApiId_Settings_volume_area_values_Limits,
	EApiId_Settings_volume_area_values,
	EApiId_List_highlight_skin_placing__general__Line_1,
	EApiId_List_highlight_skin_placing__general__Line_2,
	EApiId_List_highlight_skin_placing__general__Line_3,
	EApiId_List_highlight_skin_placing__general__Line_4,
	EApiId_List_highlight_skin_placing__general__Line_5,
	EApiId_List_highlight_skin_placing__general__Line_6,
	EApiId_List_highlight_skin_placing__general__Line_7,
	EApiId_List_highlight_skin_placing__general__Line_8,
	EApiId_List_highlight_skin_placing__general__Line_9,
	EApiId_List_highlight_skin_placing__general__SUB_TABLE_0_Limits,
	EApiId_List_highlight_skin_placing__general__SUB_TABLE_0,
	EApiId_List_highlight_skin_placing__general__SUB_TABLE_1_Limits,
	EApiId_List_highlight_skin_placing__general__SUB_TABLE_1,
	EApiId_List_highlight_skin_placing__settings__Line_1,
	EApiId_List_highlight_skin_placing__settings__Line_2,
	EApiId_List_highlight_skin_placing__settings__Line_3,
	EApiId_List_highlight_skin_placing__settings__Line_4,
	EApiId_List_highlight_skin_placing__settings__Line_5,
	EApiId_List_highlight_skin_placing__settings__Line_6,
	EApiId_List_highlight_skin_placing__settings__Line_7,
	EApiId_List_highlight_skin_placing__settings__Line_8,
	EApiId_List_highlight_skin_placing__settings__Line_9,
	EApiId_List_highlight_skin_placing__settings__Limits,
	EApiId_List_highlight_skin_placing__settings_,
	EApiId_List_highlight_skin_placing__apps_specific__Line_1,
	EApiId_List_highlight_skin_placing__apps_specific__Line_2,
	EApiId_List_highlight_skin_placing__apps_specific__Line_3,
	EApiId_List_highlight_skin_placing__apps_specific__Line_4,
	EApiId_List_highlight_skin_placing__apps_specific__Line_5,
	EApiId_List_highlight_skin_placing__apps_specific__Line_6,
	EApiId_List_highlight_skin_placing__apps_specific__Line_7,
	EApiId_List_highlight_skin_placing__apps_specific__Line_8,
	EApiId_List_highlight_skin_placing__apps_specific__Line_9,
	EApiId_List_highlight_skin_placing__apps_specific__SUB_TABLE_0_Limits,
	EApiId_List_highlight_skin_placing__apps_specific__SUB_TABLE_0,
	EApiId_List_highlight_skin_placing__apps_specific__SUB_TABLE_1_Limits,
	EApiId_List_highlight_skin_placing__apps_specific__SUB_TABLE_1,
	EApiId_List_highlight_skin_placing__popup_specific__Line_1,
	EApiId_List_highlight_skin_placing__popup_specific__Line_2,
	EApiId_List_highlight_skin_placing__popup_specific__Line_3,
	EApiId_List_highlight_skin_placing__popup_specific__Line_4,
	EApiId_List_highlight_skin_placing__popup_specific__Line_5,
	EApiId_List_highlight_skin_placing__popup_specific__Line_6,
	EApiId_List_highlight_skin_placing__popup_specific__Line_7,
	EApiId_List_highlight_skin_placing__popup_specific__Line_8,
	EApiId_List_highlight_skin_placing__popup_specific__Line_9,
	EApiId_List_highlight_skin_placing__popup_specific__SUB_TABLE_0_Limits,
	EApiId_List_highlight_skin_placing__popup_specific__SUB_TABLE_0,
	EApiId_List_highlight_skin_placing__popup_specific__SUB_TABLE_1_Limits,
	EApiId_List_highlight_skin_placing__popup_specific__SUB_TABLE_1,
	EApiId_List_highlight_skin_placing__popup_windows__Line_1,
	EApiId_List_highlight_skin_placing__popup_windows__Line_2,
	EApiId_List_highlight_skin_placing__popup_windows__Line_3,
	EApiId_List_highlight_skin_placing__popup_windows__Line_4,
	EApiId_List_highlight_skin_placing__popup_windows__Line_5,
	EApiId_List_highlight_skin_placing__popup_windows__Line_6,
	EApiId_List_highlight_skin_placing__popup_windows__Line_7,
	EApiId_List_highlight_skin_placing__popup_windows__Line_8,
	EApiId_List_highlight_skin_placing__popup_windows__Line_9,
	EApiId_List_highlight_skin_placing__popup_windows__SUB_TABLE_0_Limits,
	EApiId_List_highlight_skin_placing__popup_windows__SUB_TABLE_0,
	EApiId_List_highlight_skin_placing__popup_windows__SUB_TABLE_1_Limits,
	EApiId_List_highlight_skin_placing__popup_windows__SUB_TABLE_1,
	EApiId_Highlight_skin_placing__grid__Line_1,
	EApiId_Highlight_skin_placing__grid__Line_2,
	EApiId_Highlight_skin_placing__grid__Line_3,
	EApiId_Highlight_skin_placing__grid__Line_4,
	EApiId_Highlight_skin_placing__grid__Line_5,
	EApiId_Highlight_skin_placing__grid__Line_6,
	EApiId_Highlight_skin_placing__grid__Line_7,
	EApiId_Highlight_skin_placing__grid__Line_8,
	EApiId_Highlight_skin_placing__grid__Line_9,
	EApiId_Highlight_skin_placing__grid__SUB_TABLE_0_Limits,
	EApiId_Highlight_skin_placing__grid__SUB_TABLE_0,
	EApiId_Highlight_skin_placing__grid__SUB_TABLE_1_Limits,
	EApiId_Highlight_skin_placing__grid__SUB_TABLE_1,
	EApiId_Highlight_skin_placing__form_popup_field__Line_1,
	EApiId_Highlight_skin_placing__form_popup_field__Line_2,
	EApiId_Highlight_skin_placing__form_popup_field__Line_3,
	EApiId_Highlight_skin_placing__form_popup_field__Line_4,
	EApiId_Highlight_skin_placing__form_popup_field__Line_5,
	EApiId_Highlight_skin_placing__form_popup_field__Line_6,
	EApiId_Highlight_skin_placing__form_popup_field__Line_7,
	EApiId_Highlight_skin_placing__form_popup_field__Line_8,
	EApiId_Highlight_skin_placing__form_popup_field__Line_9,
	EApiId_Highlight_skin_placing__form_popup_field__SUB_TABLE_0_Limits,
	EApiId_Highlight_skin_placing__form_popup_field__SUB_TABLE_0,
	EApiId_Highlight_skin_placing__form_popup_field__SUB_TABLE_1_Limits,
	EApiId_Highlight_skin_placing__form_popup_field__SUB_TABLE_1,
	EApiId_xFind_pop_up_window_elements_Line_1,
	EApiId_xFind_pop_up_window_elements_Line_2,
	EApiId_xFind_pop_up_window_elements_Line_3,
	EApiId_xFind_pop_up_window_elements_Limits,
	EApiId_xFind_pop_up_window_elements,
	EApiId_Input_field_skin_placing__general__Line_1,
	EApiId_Input_field_skin_placing__general__Line_2,
	EApiId_Input_field_skin_placing__general__Line_3,
	EApiId_Input_field_skin_placing__general__Line_4,
	EApiId_Input_field_skin_placing__general__Line_5,
	EApiId_Input_field_skin_placing__general__Line_6,
	EApiId_Input_field_skin_placing__general__Line_7,
	EApiId_Input_field_skin_placing__general__Line_8,
	EApiId_Input_field_skin_placing__general__Line_9,
	EApiId_Input_field_skin_placing__general__Limits,
	EApiId_Input_field_skin_placing__general_,
	EApiId_Edited_settings_item_skin_placing__background_highlight__Line_1,
	EApiId_Edited_settings_item_skin_placing__background_highlight__Line_2,
	EApiId_Edited_settings_item_skin_placing__background_highlight__Line_3,
	EApiId_Edited_settings_item_skin_placing__background_highlight__Line_4,
	EApiId_Edited_settings_item_skin_placing__background_highlight__Line_5,
	EApiId_Edited_settings_item_skin_placing__background_highlight__Line_6,
	EApiId_Edited_settings_item_skin_placing__background_highlight__Line_7,
	EApiId_Edited_settings_item_skin_placing__background_highlight__Line_8,
	EApiId_Edited_settings_item_skin_placing__background_highlight__Line_9,
	EApiId_Edited_settings_item_skin_placing__background_highlight__Limits,
	EApiId_Edited_settings_item_skin_placing__background_highlight_,
	EApiId_Edited_settings_item_skin_placing__value_background__Line_1,
	EApiId_Edited_settings_item_skin_placing__value_background__Line_2,
	EApiId_Edited_settings_item_skin_placing__value_background__Line_3,
	EApiId_Edited_settings_item_skin_placing__value_background__Line_4,
	EApiId_Edited_settings_item_skin_placing__value_background__Line_5,
	EApiId_Edited_settings_item_skin_placing__value_background__Line_6,
	EApiId_Edited_settings_item_skin_placing__value_background__Line_7,
	EApiId_Edited_settings_item_skin_placing__value_background__Line_8,
	EApiId_Edited_settings_item_skin_placing__value_background__Line_9,
	EApiId_Edited_settings_item_skin_placing__value_background__SUB_TABLE_0_Limits,
	EApiId_Edited_settings_item_skin_placing__value_background__SUB_TABLE_0,
	EApiId_Edited_settings_item_skin_placing__value_background__SUB_TABLE_1_Limits,
	EApiId_Edited_settings_item_skin_placing__value_background__SUB_TABLE_1,
	EApiId_Edited_settings_item_skin_placing__input__Line_1,
	EApiId_Edited_settings_item_skin_placing__input__Line_2,
	EApiId_Edited_settings_item_skin_placing__input__Line_3,
	EApiId_Edited_settings_item_skin_placing__input__Line_4,
	EApiId_Edited_settings_item_skin_placing__input__Line_5,
	EApiId_Edited_settings_item_skin_placing__input__Line_6,
	EApiId_Edited_settings_item_skin_placing__input__Line_7,
	EApiId_Edited_settings_item_skin_placing__input__Line_8,
	EApiId_Edited_settings_item_skin_placing__input__Line_9,
	EApiId_Edited_settings_item_skin_placing__input__SUB_TABLE_0_Limits,
	EApiId_Edited_settings_item_skin_placing__input__SUB_TABLE_0,
	EApiId_Edited_settings_item_skin_placing__input__SUB_TABLE_1_Limits,
	EApiId_Edited_settings_item_skin_placing__input__SUB_TABLE_1,
	EApiId_Setting_volume_skin_placing_Line_1,
	EApiId_Setting_volume_skin_placing_Line_2,
	EApiId_Setting_volume_skin_placing_Limits,
	EApiId_Setting_volume_skin_placing,
	EApiId_Settings_volume_area_values_dup_Line_1,
	EApiId_Settings_volume_area_values_dup_Line_2,
	EApiId_Settings_volume_area_values_dup_Line_3,
	EApiId_Settings_volume_area_values_dup_Line_4,
	EApiId_Settings_volume_area_values_dup_Line_5,
	EApiId_Settings_volume_area_values_dup_Line_6,
	EApiId_Settings_volume_area_values_dup_Line_7,
	EApiId_Settings_volume_area_values_dup_Line_8,
	EApiId_Settings_volume_area_values_dup_Line_9,
	EApiId_Settings_volume_area_values_dup_Line_10,
	EApiId_Settings_volume_area_values_dup_Line_11,
	EApiId_Settings_volume_area_values_dup_Limits,
	EApiId_Settings_volume_area_values_dup,
	EApiId_Popup_windows_skin_placing__dimming__Line_1,
	EApiId_Popup_windows_skin_placing__background_slice__Line_1,
	EApiId_Popup_windows_skin_placing__background_slice__Line_2,
	EApiId_Popup_windows_skin_placing__frame_general__Line_1,
	EApiId_Popup_windows_skin_placing__frame_general__Line_2,
	EApiId_Popup_windows_skin_placing__frame_general__Line_3,
	EApiId_Popup_windows_skin_placing__frame_general__Line_4,
	EApiId_Popup_windows_skin_placing__frame_general__Line_5,
	EApiId_Popup_windows_skin_placing__frame_general__Line_6,
	EApiId_Popup_windows_skin_placing__frame_general__Line_7,
	EApiId_Popup_windows_skin_placing__frame_general__Line_8,
	EApiId_Popup_windows_skin_placing__frame_general__Line_9,
	EApiId_Popup_windows_skin_placing__frame_general__SUB_TABLE_0_Limits,
	EApiId_Popup_windows_skin_placing__frame_general__SUB_TABLE_0,
	EApiId_Popup_windows_skin_placing__frame_general__SUB_TABLE_1_Limits,
	EApiId_Popup_windows_skin_placing__frame_general__SUB_TABLE_1,
	EApiId_Submenu_skin_placing_Line_1,
	EApiId_Submenu_skin_placing_Line_2,
	EApiId_Submenu_skin_placing_Line_3,
	EApiId_Submenu_skin_placing_Line_4,
	EApiId_Submenu_skin_placing_Line_5,
	EApiId_Submenu_skin_placing_Line_6,
	EApiId_Submenu_skin_placing_Line_7,
	EApiId_Submenu_skin_placing_Line_8,
	EApiId_Submenu_skin_placing_Line_9,
	EApiId_Submenu_skin_placing_SUB_TABLE_0_Limits,
	EApiId_Submenu_skin_placing_SUB_TABLE_0,
	EApiId_Submenu_skin_placing_SUB_TABLE_1_Limits,
	EApiId_Submenu_skin_placing_SUB_TABLE_1,
	EApiId_Slice_skin_placing__fastapps__Line_1,
	EApiId_Fast_application_swapping_skin_placing_Line_1,
	EApiId_Fast_application_swapping_skin_placing_Line_2,
	EApiId_Fast_application_swapping_skin_placing_Line_3,
	EApiId_Fast_application_swapping_skin_placing_Line_4,
	EApiId_Fast_application_swapping_skin_placing_Line_5,
	EApiId_Fast_application_swapping_skin_placing_Line_6,
	EApiId_Fast_application_swapping_skin_placing_Line_7,
	EApiId_Fast_application_swapping_skin_placing_Line_8,
	EApiId_Fast_application_swapping_skin_placing_Line_9,
	EApiId_Fast_application_swapping_skin_placing_Line_10,
	EApiId_Fast_application_swapping_skin_placing_SUB_TABLE_0_Limits,
	EApiId_Fast_application_swapping_skin_placing_SUB_TABLE_0,
	EApiId_Fast_application_swapping_skin_placing_SUB_TABLE_1_Limits,
	EApiId_Fast_application_swapping_skin_placing_SUB_TABLE_1,
	EApiId_wallpaper_pane,
	EApiId_Changes_to_existing_elements__idle_wallpaper__Line_2,
	EApiId_Idle_clock_skin_placing___analogue__Line_1,
	EApiId_Idle_clock_skin_placing___analogue__Line_2,
	EApiId_Idle_clock_skin_placing___analogue__Line_3,
	EApiId_Idle_clock_skin_placing___analogue__Line_4,
	EApiId_Idle_clock_skin_placing___analogue__Line_5,
	EApiId_Idle_clock_skin_placing___analogue__Limits,
	EApiId_Idle_clock_skin_placing___analogue_,
	EApiId_Idle_clock_skin_placing___digital__Line_1,
	EApiId_Idle_clock_skin_placing___digital__Line_2,
	EApiId_Idle_clock_skin_placing___digital__Line_3,
	EApiId_Idle_clock_skin_placing___digital__SUB_TABLE_0_Limits,
	EApiId_Idle_clock_skin_placing___digital__SUB_TABLE_0,
	EApiId_Power_save_state_skin_placing_Line_1,
	EApiId_Calendar_skin_elements__general__dup_Line_1,
	EApiId_Calendar_skin_elements__general__dup_Line_2,
	EApiId_Calendar_skin_elements__general__dup_Line_3,
	EApiId_Calendar_skin_elements__general__dup_Line_4,
	EApiId_Calendar_skin_elements__general__dup_Line_5,
	EApiId_Calendar_skin_elements__general__dup_Line_6,
	EApiId_Calendar_skin_elements__general__dup_Line_7,
	EApiId_Calendar_skin_elements__general__dup_Line_8,
	EApiId_Calendar_skin_elements__general__dup_Line_9,
	EApiId_Calendar_skin_elements__general__dup_Limits,
	EApiId_Calendar_skin_elements__general__dup,
	EApiId_Slice_skin_placing__pinb__Line_1,
	EApiId_Favorites_skin_placing_Line_1,
	EApiId_Favorites_skin_placing_Line_2,
	EApiId_Favorites_skin_placing_Line_3,
	EApiId_Favorites_skin_placing_Line_4,
	EApiId_Favorites_skin_placing_Line_5,
	EApiId_Favorites_skin_placing_Line_6,
	EApiId_Favorites_skin_placing_Line_7,
	EApiId_Favorites_skin_placing_Line_8,
	EApiId_Favorites_skin_placing_Line_9,
	EApiId_Favorites_skin_placing_Line_10,
	EApiId_Favorites_skin_placing_Limits,
	EApiId_Favorites_skin_placing,
	EApiId_Screen_saver_skin_placing_Line_1,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__Line_1,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_1,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_2,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_3,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_4,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_5,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_6,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_7,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_8,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_9,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_10,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_11,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_12,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_13,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_14,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_15,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_16,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_17,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_18,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Limits,
	EApiId_Colour_palette_preview_screen_element_placing__main_area__dup,
	EApiId_Chinese_FEP_pop_up_window_lines_Line_1,
	EApiId_Chinese_FEP_pop_up_window_lines_Line_2,
	EApiId_Scaling_on_background_images__general__Line_1,
	EApiId_Scaling_on_status_area_background__general__Line_1,
	EApiId_Scaling_on_status_area_background__idle__Line_1,
	EApiId_Scaling_on_navi_pane_background_images_Line_1,
	EApiId_Scaling_on_tab_graphics_Line_1,
	EApiId_Scaling_on_setting_list_volume_skin_elements_Line_1,
	EApiId_Scaling_on_setting_volume_skin_Line_1,
	EApiId_Scaling_on_setting_volume_skin_sizes_Line_1,
	EApiId_Scaling_on_pop_up_windows_skin_placing__dimming__Line_1,
	EApiId_Scaling_on_ending_graphics_for_fast_application_swapping_window_Line_1,
	EApiId_Scaling_on_power_save_state_skin_element_size_Line_1,
	EApiId_Scaling_on_screensaver_skin_size_Line_1,
	EApiId_Notepad_skin_element_placing_Line_1,
	EApiId_Notepad_skin_element_placing_Line_2,
	EApiId_Notepad_skin_element_placing_Line_3,
	EApiId_Notepad_skin_element_placing_Line_4,
	EApiId_Notepad_skin_element_placing_Line_5,
	EApiId_Notepad_skin_element_placing_Line_6,
	EApiId_Notepad_skin_element_placing_Line_7,
	EApiId_Notepad_skin_element_placing_Line_8,
	EApiId_Notepad_skin_element_placing_Line_9,
	EApiId_Notepad_skin_element_placing_Limits,
	EApiId_Notepad_skin_element_placing,
	EApiId_Calculator_paper_skin_element_placing_Line_1,
	EApiId_Calculator_paper_skin_element_placing_Line_2,
	EApiId_Calculator_paper_skin_element_placing_Line_3,
	EApiId_Calculator_paper_skin_element_placing_Line_4,
	EApiId_Calculator_paper_skin_element_placing_Line_5,
	EApiId_Calculator_paper_skin_element_placing_Line_6,
	EApiId_Calculator_paper_skin_element_placing_Line_7,
	EApiId_Calculator_paper_skin_element_placing_Line_8,
	EApiId_Calculator_paper_skin_element_placing_Line_9,
	EApiId_Calculator_paper_skin_element_placing_Limits,
	EApiId_Calculator_paper_skin_element_placing,
	EApiId_Calculator_glass_element_placing_Line_1,
	EApiId_Calculator_glass_element_placing_Line_2,
	EApiId_Calculator_glass_element_placing_Line_3,
	EApiId_Calculator_glass_element_placing_Limits,
	EApiId_Calculator_glass_element_placing,
	EApiId_Scalingon_background_images__general__Line_1,
	EApiId_Scalingon_background_images__general__Line_2,
	EApiId_Scalingon_background_images__general__Limits,
	EApiId_Scalingon_background_images__general_,
	EApiId_Scaling_on_status_area_background__general__Line_2,
	EApiId_Scaling_on_status_area_background__general__Limits,
	EApiId_Scaling_on_status_area_background__general_,
	EApiId_Scaling_on_status_area_background__idle__Line_2,
	EApiId_Scaling_on_status_area_background__idle__Limits,
	EApiId_Scaling_on_status_area_background__idle_,
	EApiId_Scalingon_navipane_background_images_Line_1,
	EApiId_Scalingon_navipane_background_images_Line_2,
	EApiId_Scalingon_navipane_background_images_Limits,
	EApiId_Scalingon_navipane_background_images,
	EApiId_Scalingon_tab_graphics_Line_1,
	EApiId_Scalingon_tab_graphics_Line_2,
	EApiId_Scalingon_tab_graphics_Limits,
	EApiId_Scalingon_tab_graphics,
	EApiId_Scalinon_volume_area_values_Line_1,
	EApiId_Scalinon_volume_area_values_Line_2,
	EApiId_Scalinon_volume_area_values_Line_3,
	EApiId_Scalinon_volume_area_values_Line_4,
	EApiId_Scalinon_volume_area_values_Line_5,
	EApiId_Scalinon_volume_area_values_Line_6,
	EApiId_Scalinon_volume_area_values_Line_7,
	EApiId_Scalinon_volume_area_values_Line_8,
	EApiId_Scalinon_volume_area_values_Line_9,
	EApiId_Scalinon_volume_area_values_Line_10,
	EApiId_Scalinon_volume_area_values_Line_11,
	EApiId_Scalinon_volume_area_values_Limits,
	EApiId_Scalinon_volume_area_values,
	EApiId_Scalingon_setting_list_item_skin_elements__value_background__Line_1,
	EApiId_Scalingon_setting_list_item_skin_elements__value_background__Line_2,
	EApiId_Scalingon_setting_list_item_skin_elements__value_background__Line_3,
	EApiId_Scalingon_setting_list_item_skin_elements__value_background__Line_4,
	EApiId_Scalingon_setting_list_item_skin_elements__value_background__Line_5,
	EApiId_Scalingon_setting_list_item_skin_elements__value_background__Line_6,
	EApiId_Scalingon_setting_list_item_skin_elements__value_background__Line_7,
	EApiId_Scalingon_setting_list_item_skin_elements__value_background__Line_8,
	EApiId_Scalingon_setting_list_item_skin_elements__value_background__Line_9,
	EApiId_Scalingon_setting_list_item_skin_elements__value_background__Limits,
	EApiId_Scalingon_setting_list_item_skin_elements__value_background_,
	EApiId_Scalingon_setting_list_volume_skin_elements_Line_1,
	EApiId_Scalingon_setting_list_volume_skin_elements_Line_2,
	EApiId_Scalingon_setting_list_volume_skin_elements_Limits,
	EApiId_Scalingon_setting_list_volume_skin_elements,
	EApiId_Scalingon_setting_list_item_skin_placing_Line_1,
	EApiId_Scalingon_setting_list_item_skin_placing_Line_2,
	EApiId_Scalingon_setting_list_item_skin_placing_Limits,
	EApiId_Scalingon_setting_list_item_skin_placing,
	EApiId_Scaling_on_list_highlight_skin_placing__general__Line_1,
	EApiId_Scaling_on_list_highlight_skin_placing__general__Line_2,
	EApiId_Scaling_on_list_highlight_skin_placing__general__Line_3,
	EApiId_Scaling_on_list_highlight_skin_placing__general__Line_4,
	EApiId_Scaling_on_list_highlight_skin_placing__general__Line_5,
	EApiId_Scaling_on_list_highlight_skin_placing__general__Line_6,
	EApiId_Scaling_on_list_highlight_skin_placing__general__Line_7,
	EApiId_Scaling_on_list_highlight_skin_placing__general__Line_8,
	EApiId_Scaling_on_list_highlight_skin_placing__general__Line_9,
	EApiId_Scaling_on_list_highlight_skin_placing__general__SUB_TABLE_0_Limits,
	EApiId_Scaling_on_list_highlight_skin_placing__general__SUB_TABLE_0,
	EApiId_Scaling_on_list_highlight_skin_placing__general__SUB_TABLE_1_Limits,
	EApiId_Scaling_on_list_highlight_skin_placing__general__SUB_TABLE_1,
	EApiId_Scaling_on_list_highlight_skin_placing__settings__Line_1,
	EApiId_Scaling_on_list_highlight_skin_placing__settings__Line_2,
	EApiId_Scaling_on_list_highlight_skin_placing__settings__Line_3,
	EApiId_Scaling_on_list_highlight_skin_placing__settings__Line_4,
	EApiId_Scaling_on_list_highlight_skin_placing__settings__Line_5,
	EApiId_Scaling_on_list_highlight_skin_placing__settings__Line_6,
	EApiId_Scaling_on_list_highlight_skin_placing__settings__Line_7,
	EApiId_Scaling_on_list_highlight_skin_placing__settings__Line_8,
	EApiId_Scaling_on_list_highlight_skin_placing__settings__Line_9,
	EApiId_Scaling_on_list_highlight_skin_placing__settings__Limits,
	EApiId_Scaling_on_list_highlight_skin_placing__settings_,
	EApiId_Scalingon_edited_settings_item_skin_placing__background_highlight__Line_1,
	EApiId_Scalingon_edited_settings_item_skin_placing__background_highlight__Line_2,
	EApiId_Scalingon_edited_settings_item_skin_placing__background_highlight__Line_3,
	EApiId_Scalingon_edited_settings_item_skin_placing__background_highlight__Line_4,
	EApiId_Scalingon_edited_settings_item_skin_placing__background_highlight__Line_5,
	EApiId_Scalingon_edited_settings_item_skin_placing__background_highlight__Line_6,
	EApiId_Scalingon_edited_settings_item_skin_placing__background_highlight__Line_7,
	EApiId_Scalingon_edited_settings_item_skin_placing__background_highlight__Line_8,
	EApiId_Scalingon_edited_settings_item_skin_placing__background_highlight__Line_9,
	EApiId_Scalingon_edited_settings_item_skin_placing__background_highlight__Limits,
	EApiId_Scalingon_edited_settings_item_skin_placing__background_highlight_,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_1,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_2,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_3,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_4,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_5,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_6,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_7,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_8,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_9,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_0_Limits,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_0,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_1_Limits,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_1,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_2_Limits,
	EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_2,
	EApiId_Scalingon_setting_volume_skin_Line_1,
	EApiId_Scalingon_setting_volume_skin_Line_2,
	EApiId_Scalingon_setting_volume_skin_Limits,
	EApiId_Scalingon_setting_volume_skin,
	EApiId_Scaling_on_setting_volume_skin_sizes_Line_2,
	EApiId_Scaling_on_setting_volume_skin_sizes_Limits,
	EApiId_Scaling_on_setting_volume_skin_sizes,
	EApiId_Scalingon_pop_up_windows_skin_placing__dimming__Line_1,
	EApiId_Scalingon_pop_up_windows_skin_placing__dimming__Line_2,
	EApiId_Scalingon_pop_up_windows_skin_placing__dimming__Limits,
	EApiId_Scalingon_pop_up_windows_skin_placing__dimming_,
	EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__Line_1,
	EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__Line_2,
	EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__Line_3,
	EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__Line_4,
	EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__Line_5,
	EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__Line_6,
	EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__Line_7,
	EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__Line_8,
	EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__Line_9,
	EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__SUB_TABLE_0_Limits,
	EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__SUB_TABLE_0,
	EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__SUB_TABLE_1_Limits,
	EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__SUB_TABLE_1,
	EApiId_Scaling_on_ending_graphics_for_fast_application_swappingwindow_Line_1,
	EApiId_Scaling_on_ending_graphics_for_fast_application_swappingwindow_Line_2,
	EApiId_Scaling_on_ending_graphics_for_fast_application_swappingwindow_Limits,
	EApiId_Scaling_on_ending_graphics_for_fast_application_swappingwindow,
	EApiId_Scaling_on_power_save_state_skin_element_size_Line_2,
	EApiId_Scaling_on_power_save_state_skin_element_size_Limits,
	EApiId_Scaling_on_power_save_state_skin_element_size,
	EApiId_Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_1,
	EApiId_Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_2,
	EApiId_Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_3,
	EApiId_Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_4,
	EApiId_Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_5,
	EApiId_Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_6,
	EApiId_Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_7,
	EApiId_Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_8,
	EApiId_Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_9,
	EApiId_Scaling_on_calendar_skin_element_placing_and_size__dayweek__Limits,
	EApiId_Scaling_on_calendar_skin_element_placing_and_size__dayweek_,
	EApiId_Scalingon_calendar_skin_element_placing_and_size__month__Line_1,
	EApiId_Scalingon_calendar_skin_element_placing_and_size__month__Line_2,
	EApiId_Scalingon_calendar_skin_element_placing_and_size__month__Line_3,
	EApiId_Scalingon_calendar_skin_element_placing_and_size__month__Line_4,
	EApiId_Scalingon_calendar_skin_element_placing_and_size__month__Line_5,
	EApiId_Scalingon_calendar_skin_element_placing_and_size__month__Line_6,
	EApiId_Scalingon_calendar_skin_element_placing_and_size__month__Line_7,
	EApiId_Scalingon_calendar_skin_element_placing_and_size__month__Line_8,
	EApiId_Scalingon_calendar_skin_element_placing_and_size__month__Line_9,
	EApiId_Scalingon_calendar_skin_element_placing_and_size__month__Limits,
	EApiId_Scalingon_calendar_skin_element_placing_and_size__month_,
	EApiId_Scaling_on_favourites_skin_sizes_and_placing_Line_1,
	EApiId_Scaling_on_favourites_skin_sizes_and_placing_Line_2,
	EApiId_Scaling_on_favourites_skin_sizes_and_placing_Line_3,
	EApiId_Scaling_on_favourites_skin_sizes_and_placing_Line_4,
	EApiId_Scaling_on_favourites_skin_sizes_and_placing_Line_5,
	EApiId_Scaling_on_favourites_skin_sizes_and_placing_Line_6,
	EApiId_Scaling_on_favourites_skin_sizes_and_placing_Line_7,
	EApiId_Scaling_on_favourites_skin_sizes_and_placing_Line_8,
	EApiId_Scaling_on_favourites_skin_sizes_and_placing_Line_9,
	EApiId_Scaling_on_favourites_skin_sizes_and_placing_Line_10,
	EApiId_Scaling_on_favourites_skin_sizes_and_placing_Limits,
	EApiId_Scaling_on_favourites_skin_sizes_and_placing,
	E_TApiId_TableSize
	};

// This is the CDL interface definition for this interface
const SCdlInterface KCdlInterface =
	{
	KCdlCompilerMajorVersion,
	KCdlCompilerMinorVersion,
	LIT_AS_DESC_PTR(KCdlName),
	{ KCdlInterfaceUidValue },
	KCdlInterfaceMajorVersion,
	KCdlInterfaceMinorVersion,
	KCdlInterfaceFlags,
	E_TApiId_TableSize
	};

// These typedefs define the types for function APIs
typedef TAknWindowLineLayout (TxInput_field_skin_placing__find_list__Line_1_sig)();
typedef TAknWindowLineLayout (TxInput_field_skin_placing__find_list__Line_2_sig)();
typedef TAknWindowLineLayout (TxInput_field_skin_placing__find_list__Line_3_sig)();
typedef TAknWindowLineLayout (TxInput_field_skin_placing__find_list__Line_4_sig)();
typedef TAknWindowLineLayout (TxInput_field_skin_placing__find_list__Line_5_sig)();
typedef TAknWindowLineLayout (TxInput_field_skin_placing__find_list__Line_6_sig)();
typedef TAknWindowLineLayout (TxInput_field_skin_placing__find_list__Line_7_sig)();
typedef TAknWindowLineLayout (TxInput_field_skin_placing__find_list__Line_8_sig)();
typedef TAknWindowLineLayout (TxInput_field_skin_placing__find_list__Line_9_sig)();
typedef TAknLayoutTableLimits (TxInput_field_skin_placing__find_list__Limits_sig)();
typedef TAknWindowLineLayout (TxInput_field_skin_placing__find_list__sig)(TInt);
typedef TAknWindowLineLayout (TScreen_background_skin_placing_Line_1_sig)();
typedef TAknWindowLineLayout (TArea_background_skin_placing_Line_1_sig)();
typedef TAknWindowLineLayout (TArea_background_skin_placing_Line_2_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TArea_background_skin_placing_Line_3_sig)();
typedef TAknWindowLineLayout (TPane_background_skin_naming_Line_1_sig)();
typedef TAknWindowLineLayout (TNavi_pane_background_stripe_skin_placing_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TNavi_pane_background_stripe_skin_placing_Line_2_sig)();
typedef TAknWindowLineLayout (TVolume_level_skin_placing_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_level_skin_placing_Line_2_sig)(TInt);
typedef TAknLayoutTableLimits (TVolume_level_skin_placing_Limits_sig)();
typedef TAknWindowLineLayout (TVolume_level_skin_placing_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TVolume_area_values_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_area_values_Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_area_values_Line_3_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_area_values_Line_4_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_area_values_Line_5_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_area_values_Line_6_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_area_values_Line_7_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_area_values_Line_8_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_area_values_Line_9_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_area_values_Line_10_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_area_values_Line_11_sig)(TInt);
typedef TAknLayoutTableLimits (TVolume_area_values_Limits_sig)();
typedef TAknWindowLineLayout (TVolume_area_values_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TColumn_background_and_list_slice_skin_placing_Line_1_sig)();
typedef TAknWindowLineLayout (TColumn_background_and_list_slice_skin_placing_Line_2_sig)();
typedef TAknWindowLineLayout (TColumn_background_and_list_slice_skin_placing_Line_3_sig)();
typedef TAknWindowLineLayout (TColumn_background_and_list_slice_skin_placing_Line_4_sig)();
typedef TAknWindowLineLayout (TColumn_background_and_list_slice_skin_placing_Line_5_sig)();
typedef TAknWindowLineLayout (TColumn_background_and_list_slice_skin_placing_Line_6_sig)();
typedef TAknWindowLineLayout (TColumn_background_and_list_slice_skin_placing_Line_7_sig)();
typedef TAknLayoutTableLimits (TColumn_background_and_list_slice_skin_placing_Limits_sig)();
typedef TAknWindowLineLayout (TColumn_background_and_list_slice_skin_placing_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_list_item_skin_elements__value_background__Line_1_sig)();
typedef TAknWindowLineLayout (TSetting_list_item_skin_elements__value_background__Line_2_sig)();
typedef TAknWindowLineLayout (TSetting_list_item_skin_elements__value_background__Line_3_sig)();
typedef TAknWindowLineLayout (TSetting_list_item_skin_elements__value_background__Line_4_sig)();
typedef TAknWindowLineLayout (TSetting_list_item_skin_elements__value_background__Line_5_sig)();
typedef TAknWindowLineLayout (TSetting_list_item_skin_elements__value_background__Line_6_sig)();
typedef TAknWindowLineLayout (TSetting_list_item_skin_elements__value_background__Line_7_sig)();
typedef TAknWindowLineLayout (TSetting_list_item_skin_elements__value_background__Line_8_sig)();
typedef TAknWindowLineLayout (TSetting_list_item_skin_elements__value_background__Line_9_sig)();
typedef TAknLayoutTableLimits (TSetting_list_item_skin_elements__value_background__Limits_sig)();
typedef TAknWindowLineLayout (TSetting_list_item_skin_elements__value_background__sig)(TInt);
typedef TAknWindowLineLayout (TSetting_list_item_skin_placing__volume__Line_1_sig)();
typedef TAknWindowLineLayout (TSetting_list_item_skin_placing__volume__Line_2_sig)();
typedef TAknLayoutTableLimits (TSetting_list_item_skin_placing__volume__Limits_sig)();
typedef TAknWindowLineLayout (TSetting_list_item_skin_placing__volume__sig)(TInt);
typedef TAknWindowLineLayout (TSettings_volume_area_values_Line_1_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_Line_2_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_Line_3_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_Line_4_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_Line_5_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_Line_6_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_Line_7_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_Line_8_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_Line_9_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_Line_10_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_Line_11_sig)();
typedef TAknLayoutTableLimits (TSettings_volume_area_values_Limits_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_sig)(TInt);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__general__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__general__Line_2_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__general__Line_3_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__general__Line_4_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__general__Line_5_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__general__Line_6_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__general__Line_7_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__general__Line_8_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__general__Line_9_sig)(const TRect&);
typedef TAknLayoutTableLimits (TList_highlight_skin_placing__general__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__general__SUB_TABLE_0_sig)(TInt);
typedef TAknLayoutTableLimits (TList_highlight_skin_placing__general__SUB_TABLE_1_Limits_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__general__SUB_TABLE_1_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__settings__Line_1_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__settings__Line_2_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__settings__Line_3_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__settings__Line_4_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__settings__Line_5_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__settings__Line_6_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__settings__Line_7_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__settings__Line_8_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__settings__Line_9_sig)();
typedef TAknLayoutTableLimits (TList_highlight_skin_placing__settings__Limits_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__settings__sig)(TInt);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__apps_specific__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__apps_specific__Line_2_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__apps_specific__Line_3_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__apps_specific__Line_4_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__apps_specific__Line_5_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__apps_specific__Line_6_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__apps_specific__Line_7_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__apps_specific__Line_8_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__apps_specific__Line_9_sig)(const TRect&);
typedef TAknLayoutTableLimits (TList_highlight_skin_placing__apps_specific__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__apps_specific__SUB_TABLE_0_sig)(TInt);
typedef TAknLayoutTableLimits (TList_highlight_skin_placing__apps_specific__SUB_TABLE_1_Limits_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__apps_specific__SUB_TABLE_1_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_specific__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_specific__Line_2_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_specific__Line_3_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_specific__Line_4_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_specific__Line_5_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_specific__Line_6_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_specific__Line_7_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_specific__Line_8_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_specific__Line_9_sig)(const TRect&);
typedef TAknLayoutTableLimits (TList_highlight_skin_placing__popup_specific__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_specific__SUB_TABLE_0_sig)(TInt);
typedef TAknLayoutTableLimits (TList_highlight_skin_placing__popup_specific__SUB_TABLE_1_Limits_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_specific__SUB_TABLE_1_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_windows__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_windows__Line_2_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_windows__Line_3_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_windows__Line_4_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_windows__Line_5_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_windows__Line_6_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_windows__Line_7_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_windows__Line_8_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_windows__Line_9_sig)(const TRect&);
typedef TAknLayoutTableLimits (TList_highlight_skin_placing__popup_windows__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_windows__SUB_TABLE_0_sig)(TInt);
typedef TAknLayoutTableLimits (TList_highlight_skin_placing__popup_windows__SUB_TABLE_1_Limits_sig)();
typedef TAknWindowLineLayout (TList_highlight_skin_placing__popup_windows__SUB_TABLE_1_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (THighlight_skin_placing__grid__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (THighlight_skin_placing__grid__Line_2_sig)();
typedef TAknWindowLineLayout (THighlight_skin_placing__grid__Line_3_sig)();
typedef TAknWindowLineLayout (THighlight_skin_placing__grid__Line_4_sig)();
typedef TAknWindowLineLayout (THighlight_skin_placing__grid__Line_5_sig)();
typedef TAknWindowLineLayout (THighlight_skin_placing__grid__Line_6_sig)(const TRect&);
typedef TAknWindowLineLayout (THighlight_skin_placing__grid__Line_7_sig)(const TRect&);
typedef TAknWindowLineLayout (THighlight_skin_placing__grid__Line_8_sig)(const TRect&);
typedef TAknWindowLineLayout (THighlight_skin_placing__grid__Line_9_sig)(const TRect&);
typedef TAknLayoutTableLimits (THighlight_skin_placing__grid__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (THighlight_skin_placing__grid__SUB_TABLE_0_sig)(TInt);
typedef TAknLayoutTableLimits (THighlight_skin_placing__grid__SUB_TABLE_1_Limits_sig)();
typedef TAknWindowLineLayout (THighlight_skin_placing__grid__SUB_TABLE_1_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (THighlight_skin_placing__form_popup_field__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (THighlight_skin_placing__form_popup_field__Line_2_sig)();
typedef TAknWindowLineLayout (THighlight_skin_placing__form_popup_field__Line_3_sig)();
typedef TAknWindowLineLayout (THighlight_skin_placing__form_popup_field__Line_4_sig)();
typedef TAknWindowLineLayout (THighlight_skin_placing__form_popup_field__Line_5_sig)();
typedef TAknWindowLineLayout (THighlight_skin_placing__form_popup_field__Line_6_sig)(const TRect&);
typedef TAknWindowLineLayout (THighlight_skin_placing__form_popup_field__Line_7_sig)(const TRect&);
typedef TAknWindowLineLayout (THighlight_skin_placing__form_popup_field__Line_8_sig)(const TRect&);
typedef TAknWindowLineLayout (THighlight_skin_placing__form_popup_field__Line_9_sig)(const TRect&);
typedef TAknLayoutTableLimits (THighlight_skin_placing__form_popup_field__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (THighlight_skin_placing__form_popup_field__SUB_TABLE_0_sig)(TInt);
typedef TAknLayoutTableLimits (THighlight_skin_placing__form_popup_field__SUB_TABLE_1_Limits_sig)();
typedef TAknWindowLineLayout (THighlight_skin_placing__form_popup_field__SUB_TABLE_1_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TxFind_pop_up_window_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TxFind_pop_up_window_elements_Line_2_sig)();
typedef TAknWindowLineLayout (TxFind_pop_up_window_elements_Line_3_sig)();
typedef TAknLayoutTableLimits (TxFind_pop_up_window_elements_Limits_sig)();
typedef TAknWindowLineLayout (TxFind_pop_up_window_elements_sig)(TInt);
typedef TAknWindowLineLayout (TInput_field_skin_placing__general__Line_1_sig)();
typedef TAknWindowLineLayout (TInput_field_skin_placing__general__Line_2_sig)();
typedef TAknWindowLineLayout (TInput_field_skin_placing__general__Line_3_sig)();
typedef TAknWindowLineLayout (TInput_field_skin_placing__general__Line_4_sig)();
typedef TAknWindowLineLayout (TInput_field_skin_placing__general__Line_5_sig)();
typedef TAknWindowLineLayout (TInput_field_skin_placing__general__Line_6_sig)();
typedef TAknWindowLineLayout (TInput_field_skin_placing__general__Line_7_sig)();
typedef TAknWindowLineLayout (TInput_field_skin_placing__general__Line_8_sig)();
typedef TAknWindowLineLayout (TInput_field_skin_placing__general__Line_9_sig)();
typedef TAknLayoutTableLimits (TInput_field_skin_placing__general__Limits_sig)();
typedef TAknWindowLineLayout (TInput_field_skin_placing__general__sig)(TInt);
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__background_highlight__Line_1_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__background_highlight__Line_2_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__background_highlight__Line_3_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__background_highlight__Line_4_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__background_highlight__Line_5_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__background_highlight__Line_6_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__background_highlight__Line_7_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__background_highlight__Line_8_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__background_highlight__Line_9_sig)();
typedef TAknLayoutTableLimits (TEdited_settings_item_skin_placing__background_highlight__Limits_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__background_highlight__sig)(TInt);
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__value_background__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__value_background__Line_2_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__value_background__Line_3_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__value_background__Line_4_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__value_background__Line_5_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__value_background__Line_6_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__value_background__Line_7_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__value_background__Line_8_sig)(const TRect&);
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__value_background__Line_9_sig)(const TRect&);
typedef TAknLayoutTableLimits (TEdited_settings_item_skin_placing__value_background__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__value_background__SUB_TABLE_0_sig)(TInt);
typedef TAknLayoutTableLimits (TEdited_settings_item_skin_placing__value_background__SUB_TABLE_1_Limits_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__value_background__SUB_TABLE_1_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__input__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__input__Line_2_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__input__Line_3_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__input__Line_4_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__input__Line_5_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__input__Line_6_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__input__Line_7_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__input__Line_8_sig)(const TRect&);
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__input__Line_9_sig)(const TRect&);
typedef TAknLayoutTableLimits (TEdited_settings_item_skin_placing__input__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__input__SUB_TABLE_0_sig)(TInt);
typedef TAknLayoutTableLimits (TEdited_settings_item_skin_placing__input__SUB_TABLE_1_Limits_sig)();
typedef TAknWindowLineLayout (TEdited_settings_item_skin_placing__input__SUB_TABLE_1_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TSetting_volume_skin_placing_Line_1_sig)();
typedef TAknWindowLineLayout (TSetting_volume_skin_placing_Line_2_sig)();
typedef TAknLayoutTableLimits (TSetting_volume_skin_placing_Limits_sig)();
typedef TAknWindowLineLayout (TSetting_volume_skin_placing_sig)(TInt);
typedef TAknWindowLineLayout (TSettings_volume_area_values_dup_Line_1_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_dup_Line_2_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_dup_Line_3_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_dup_Line_4_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_dup_Line_5_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_dup_Line_6_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_dup_Line_7_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_dup_Line_8_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_dup_Line_9_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_dup_Line_10_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_dup_Line_11_sig)();
typedef TAknLayoutTableLimits (TSettings_volume_area_values_dup_Limits_sig)();
typedef TAknWindowLineLayout (TSettings_volume_area_values_dup_sig)(TInt);
typedef TAknWindowLineLayout (TPopup_windows_skin_placing__dimming__Line_1_sig)();
typedef TAknWindowLineLayout (TPopup_windows_skin_placing__background_slice__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TPopup_windows_skin_placing__background_slice__Line_2_sig)();
typedef TAknWindowLineLayout (TPopup_windows_skin_placing__frame_general__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TPopup_windows_skin_placing__frame_general__Line_2_sig)();
typedef TAknWindowLineLayout (TPopup_windows_skin_placing__frame_general__Line_3_sig)();
typedef TAknWindowLineLayout (TPopup_windows_skin_placing__frame_general__Line_4_sig)();
typedef TAknWindowLineLayout (TPopup_windows_skin_placing__frame_general__Line_5_sig)();
typedef TAknWindowLineLayout (TPopup_windows_skin_placing__frame_general__Line_6_sig)();
typedef TAknWindowLineLayout (TPopup_windows_skin_placing__frame_general__Line_7_sig)();
typedef TAknWindowLineLayout (TPopup_windows_skin_placing__frame_general__Line_8_sig)(const TRect&);
typedef TAknWindowLineLayout (TPopup_windows_skin_placing__frame_general__Line_9_sig)(const TRect&);
typedef TAknLayoutTableLimits (TPopup_windows_skin_placing__frame_general__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TPopup_windows_skin_placing__frame_general__SUB_TABLE_0_sig)(TInt);
typedef TAknLayoutTableLimits (TPopup_windows_skin_placing__frame_general__SUB_TABLE_1_Limits_sig)();
typedef TAknWindowLineLayout (TPopup_windows_skin_placing__frame_general__SUB_TABLE_1_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TSubmenu_skin_placing_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TSubmenu_skin_placing_Line_2_sig)();
typedef TAknWindowLineLayout (TSubmenu_skin_placing_Line_3_sig)();
typedef TAknWindowLineLayout (TSubmenu_skin_placing_Line_4_sig)();
typedef TAknWindowLineLayout (TSubmenu_skin_placing_Line_5_sig)();
typedef TAknWindowLineLayout (TSubmenu_skin_placing_Line_6_sig)(const TRect&);
typedef TAknWindowLineLayout (TSubmenu_skin_placing_Line_7_sig)(const TRect&);
typedef TAknWindowLineLayout (TSubmenu_skin_placing_Line_8_sig)(const TRect&);
typedef TAknWindowLineLayout (TSubmenu_skin_placing_Line_9_sig)(const TRect&);
typedef TAknLayoutTableLimits (TSubmenu_skin_placing_SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TSubmenu_skin_placing_SUB_TABLE_0_sig)(TInt);
typedef TAknLayoutTableLimits (TSubmenu_skin_placing_SUB_TABLE_1_Limits_sig)();
typedef TAknWindowLineLayout (TSubmenu_skin_placing_SUB_TABLE_1_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TSlice_skin_placing__fastapps__Line_1_sig)();
typedef TAknWindowLineLayout (TFast_application_swapping_skin_placing_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TFast_application_swapping_skin_placing_Line_2_sig)();
typedef TAknWindowLineLayout (TFast_application_swapping_skin_placing_Line_3_sig)();
typedef TAknWindowLineLayout (TFast_application_swapping_skin_placing_Line_4_sig)();
typedef TAknWindowLineLayout (TFast_application_swapping_skin_placing_Line_5_sig)();
typedef TAknWindowLineLayout (TFast_application_swapping_skin_placing_Line_6_sig)();
typedef TAknWindowLineLayout (TFast_application_swapping_skin_placing_Line_7_sig)();
typedef TAknWindowLineLayout (TFast_application_swapping_skin_placing_Line_8_sig)(const TRect&);
typedef TAknWindowLineLayout (TFast_application_swapping_skin_placing_Line_9_sig)(const TRect&);
typedef TAknWindowLineLayout (TFast_application_swapping_skin_placing_Line_10_sig)(const TRect&);
typedef TAknLayoutTableLimits (TFast_application_swapping_skin_placing_SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TFast_application_swapping_skin_placing_SUB_TABLE_0_sig)(TInt);
typedef TAknLayoutTableLimits (TFast_application_swapping_skin_placing_SUB_TABLE_1_Limits_sig)();
typedef TAknWindowLineLayout (TFast_application_swapping_skin_placing_SUB_TABLE_1_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (Twallpaper_pane_sig)();
typedef TAknWindowLineLayout (TChanges_to_existing_elements__idle_wallpaper__Line_2_sig)(const TRect&, TInt, TInt);
typedef TAknWindowLineLayout (TIdle_clock_skin_placing___analogue__Line_1_sig)();
typedef TAknWindowLineLayout (TIdle_clock_skin_placing___analogue__Line_2_sig)();
typedef TAknWindowLineLayout (TIdle_clock_skin_placing___analogue__Line_3_sig)();
typedef TAknWindowLineLayout (TIdle_clock_skin_placing___analogue__Line_4_sig)();
typedef TAknWindowLineLayout (TIdle_clock_skin_placing___analogue__Line_5_sig)();
typedef TAknLayoutTableLimits (TIdle_clock_skin_placing___analogue__Limits_sig)();
typedef TAknWindowLineLayout (TIdle_clock_skin_placing___analogue__sig)(TInt);
typedef TAknWindowLineLayout (TIdle_clock_skin_placing___digital__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TIdle_clock_skin_placing___digital__Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TIdle_clock_skin_placing___digital__Line_3_sig)(const TRect&);
typedef TAknLayoutTableLimits (TIdle_clock_skin_placing___digital__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TIdle_clock_skin_placing___digital__SUB_TABLE_0_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TPower_save_state_skin_placing_Line_1_sig)();
typedef TAknWindowLineLayout (TCalendar_skin_elements__general__dup_Line_1_sig)();
typedef TAknWindowLineLayout (TCalendar_skin_elements__general__dup_Line_2_sig)();
typedef TAknWindowLineLayout (TCalendar_skin_elements__general__dup_Line_3_sig)();
typedef TAknWindowLineLayout (TCalendar_skin_elements__general__dup_Line_4_sig)();
typedef TAknWindowLineLayout (TCalendar_skin_elements__general__dup_Line_5_sig)();
typedef TAknWindowLineLayout (TCalendar_skin_elements__general__dup_Line_6_sig)();
typedef TAknWindowLineLayout (TCalendar_skin_elements__general__dup_Line_7_sig)();
typedef TAknWindowLineLayout (TCalendar_skin_elements__general__dup_Line_8_sig)();
typedef TAknWindowLineLayout (TCalendar_skin_elements__general__dup_Line_9_sig)();
typedef TAknLayoutTableLimits (TCalendar_skin_elements__general__dup_Limits_sig)();
typedef TAknWindowLineLayout (TCalendar_skin_elements__general__dup_sig)(TInt);
typedef TAknWindowLineLayout (TSlice_skin_placing__pinb__Line_1_sig)();
typedef TAknWindowLineLayout (TFavorites_skin_placing_Line_1_sig)();
typedef TAknWindowLineLayout (TFavorites_skin_placing_Line_2_sig)();
typedef TAknWindowLineLayout (TFavorites_skin_placing_Line_3_sig)();
typedef TAknWindowLineLayout (TFavorites_skin_placing_Line_4_sig)();
typedef TAknWindowLineLayout (TFavorites_skin_placing_Line_5_sig)();
typedef TAknWindowLineLayout (TFavorites_skin_placing_Line_6_sig)();
typedef TAknWindowLineLayout (TFavorites_skin_placing_Line_7_sig)();
typedef TAknWindowLineLayout (TFavorites_skin_placing_Line_8_sig)();
typedef TAknWindowLineLayout (TFavorites_skin_placing_Line_9_sig)();
typedef TAknWindowLineLayout (TFavorites_skin_placing_Line_10_sig)();
typedef TAknLayoutTableLimits (TFavorites_skin_placing_Limits_sig)();
typedef TAknWindowLineLayout (TFavorites_skin_placing_sig)(TInt);
typedef TAknWindowLineLayout (TScreen_saver_skin_placing_Line_1_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__Line_1_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_1_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_2_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_3_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_4_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_5_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_6_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_7_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_8_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_9_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_10_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_11_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_12_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_13_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_14_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_15_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_16_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_17_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_Line_18_sig)();
typedef TAknLayoutTableLimits (TColour_palette_preview_screen_element_placing__main_area__dup_Limits_sig)();
typedef TAknWindowLineLayout (TColour_palette_preview_screen_element_placing__main_area__dup_sig)(TInt);
typedef TAknWindowLineLayout (TChinese_FEP_pop_up_window_lines_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TChinese_FEP_pop_up_window_lines_Line_2_sig)();
typedef TAknWindowLineLayout (TScaling_on_background_images__general__Line_1_sig)();
typedef TAknWindowLineLayout (TScaling_on_status_area_background__general__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TScaling_on_status_area_background__idle__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TScaling_on_navi_pane_background_images_Line_1_sig)();
typedef TAknWindowLineLayout (TScaling_on_tab_graphics_Line_1_sig)();
typedef TAknWindowLineLayout (TScaling_on_setting_list_volume_skin_elements_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TScaling_on_setting_volume_skin_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TScaling_on_setting_volume_skin_sizes_Line_1_sig)();
typedef TAknWindowLineLayout (TScaling_on_pop_up_windows_skin_placing__dimming__Line_1_sig)();
typedef TAknWindowLineLayout (TScaling_on_ending_graphics_for_fast_application_swapping_window_Line_1_sig)();
typedef TAknWindowLineLayout (TScaling_on_power_save_state_skin_element_size_Line_1_sig)();
typedef TAknWindowLineLayout (TScaling_on_screensaver_skin_size_Line_1_sig)();
typedef TAknWindowLineLayout (TNotepad_skin_element_placing_Line_1_sig)();
typedef TAknWindowLineLayout (TNotepad_skin_element_placing_Line_2_sig)();
typedef TAknWindowLineLayout (TNotepad_skin_element_placing_Line_3_sig)();
typedef TAknWindowLineLayout (TNotepad_skin_element_placing_Line_4_sig)();
typedef TAknWindowLineLayout (TNotepad_skin_element_placing_Line_5_sig)();
typedef TAknWindowLineLayout (TNotepad_skin_element_placing_Line_6_sig)();
typedef TAknWindowLineLayout (TNotepad_skin_element_placing_Line_7_sig)();
typedef TAknWindowLineLayout (TNotepad_skin_element_placing_Line_8_sig)();
typedef TAknWindowLineLayout (TNotepad_skin_element_placing_Line_9_sig)();
typedef TAknLayoutTableLimits (TNotepad_skin_element_placing_Limits_sig)();
typedef TAknWindowLineLayout (TNotepad_skin_element_placing_sig)(TInt);
typedef TAknWindowLineLayout (TCalculator_paper_skin_element_placing_Line_1_sig)();
typedef TAknWindowLineLayout (TCalculator_paper_skin_element_placing_Line_2_sig)();
typedef TAknWindowLineLayout (TCalculator_paper_skin_element_placing_Line_3_sig)();
typedef TAknWindowLineLayout (TCalculator_paper_skin_element_placing_Line_4_sig)();
typedef TAknWindowLineLayout (TCalculator_paper_skin_element_placing_Line_5_sig)();
typedef TAknWindowLineLayout (TCalculator_paper_skin_element_placing_Line_6_sig)();
typedef TAknWindowLineLayout (TCalculator_paper_skin_element_placing_Line_7_sig)();
typedef TAknWindowLineLayout (TCalculator_paper_skin_element_placing_Line_8_sig)();
typedef TAknWindowLineLayout (TCalculator_paper_skin_element_placing_Line_9_sig)();
typedef TAknLayoutTableLimits (TCalculator_paper_skin_element_placing_Limits_sig)();
typedef TAknWindowLineLayout (TCalculator_paper_skin_element_placing_sig)(TInt);
typedef TAknWindowLineLayout (TCalculator_glass_element_placing_Line_1_sig)();
typedef TAknWindowLineLayout (TCalculator_glass_element_placing_Line_2_sig)();
typedef TAknWindowLineLayout (TCalculator_glass_element_placing_Line_3_sig)();
typedef TAknLayoutTableLimits (TCalculator_glass_element_placing_Limits_sig)();
typedef TAknWindowLineLayout (TCalculator_glass_element_placing_sig)(TInt);
typedef TAknWindowLineLayout (TScalingon_background_images__general__Line_1_sig)();
typedef TAknWindowLineLayout (TScalingon_background_images__general__Line_2_sig)();
typedef TAknLayoutTableLimits (TScalingon_background_images__general__Limits_sig)();
typedef TAknWindowLineLayout (TScalingon_background_images__general__sig)(TInt);
typedef TAknWindowLineLayout (TScaling_on_status_area_background__general__Line_2_sig)(TInt);
typedef TAknLayoutTableLimits (TScaling_on_status_area_background__general__Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_status_area_background__general__sig)(TInt, TInt);
typedef TAknWindowLineLayout (TScaling_on_status_area_background__idle__Line_2_sig)(TInt);
typedef TAknLayoutTableLimits (TScaling_on_status_area_background__idle__Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_status_area_background__idle__sig)(TInt, TInt);
typedef TAknWindowLineLayout (TScalingon_navipane_background_images_Line_1_sig)();
typedef TAknWindowLineLayout (TScalingon_navipane_background_images_Line_2_sig)();
typedef TAknLayoutTableLimits (TScalingon_navipane_background_images_Limits_sig)();
typedef TAknWindowLineLayout (TScalingon_navipane_background_images_sig)(TInt);
typedef TAknWindowLineLayout (TScalingon_tab_graphics_Line_1_sig)();
typedef TAknWindowLineLayout (TScalingon_tab_graphics_Line_2_sig)();
typedef TAknLayoutTableLimits (TScalingon_tab_graphics_Limits_sig)();
typedef TAknWindowLineLayout (TScalingon_tab_graphics_sig)(TInt);
typedef TAknWindowLineLayout (TScalinon_volume_area_values_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TScalinon_volume_area_values_Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TScalinon_volume_area_values_Line_3_sig)(TInt);
typedef TAknWindowLineLayout (TScalinon_volume_area_values_Line_4_sig)(TInt);
typedef TAknWindowLineLayout (TScalinon_volume_area_values_Line_5_sig)(TInt);
typedef TAknWindowLineLayout (TScalinon_volume_area_values_Line_6_sig)(TInt);
typedef TAknWindowLineLayout (TScalinon_volume_area_values_Line_7_sig)(TInt);
typedef TAknWindowLineLayout (TScalinon_volume_area_values_Line_8_sig)(TInt);
typedef TAknWindowLineLayout (TScalinon_volume_area_values_Line_9_sig)(TInt);
typedef TAknWindowLineLayout (TScalinon_volume_area_values_Line_10_sig)(TInt);
typedef TAknWindowLineLayout (TScalinon_volume_area_values_Line_11_sig)(TInt);
typedef TAknLayoutTableLimits (TScalinon_volume_area_values_Limits_sig)();
typedef TAknWindowLineLayout (TScalinon_volume_area_values_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TScalingon_setting_list_item_skin_elements__value_background__Line_1_sig)();
typedef TAknWindowLineLayout (TScalingon_setting_list_item_skin_elements__value_background__Line_2_sig)();
typedef TAknWindowLineLayout (TScalingon_setting_list_item_skin_elements__value_background__Line_3_sig)();
typedef TAknWindowLineLayout (TScalingon_setting_list_item_skin_elements__value_background__Line_4_sig)();
typedef TAknWindowLineLayout (TScalingon_setting_list_item_skin_elements__value_background__Line_5_sig)();
typedef TAknWindowLineLayout (TScalingon_setting_list_item_skin_elements__value_background__Line_6_sig)();
typedef TAknWindowLineLayout (TScalingon_setting_list_item_skin_elements__value_background__Line_7_sig)();
typedef TAknWindowLineLayout (TScalingon_setting_list_item_skin_elements__value_background__Line_8_sig)();
typedef TAknWindowLineLayout (TScalingon_setting_list_item_skin_elements__value_background__Line_9_sig)();
typedef TAknLayoutTableLimits (TScalingon_setting_list_item_skin_elements__value_background__Limits_sig)();
typedef TAknWindowLineLayout (TScalingon_setting_list_item_skin_elements__value_background__sig)(TInt);
typedef TAknWindowLineLayout (TScalingon_setting_list_volume_skin_elements_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TScalingon_setting_list_volume_skin_elements_Line_2_sig)(TInt);
typedef TAknLayoutTableLimits (TScalingon_setting_list_volume_skin_elements_Limits_sig)();
typedef TAknWindowLineLayout (TScalingon_setting_list_volume_skin_elements_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TScalingon_setting_list_item_skin_placing_Line_1_sig)();
typedef TAknWindowLineLayout (TScalingon_setting_list_item_skin_placing_Line_2_sig)();
typedef TAknLayoutTableLimits (TScalingon_setting_list_item_skin_placing_Limits_sig)();
typedef TAknWindowLineLayout (TScalingon_setting_list_item_skin_placing_sig)(TInt);
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__general__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__general__Line_2_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__general__Line_3_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__general__Line_4_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__general__Line_5_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__general__Line_6_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__general__Line_7_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__general__Line_8_sig)(const TRect&);
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__general__Line_9_sig)(const TRect&);
typedef TAknLayoutTableLimits (TScaling_on_list_highlight_skin_placing__general__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__general__SUB_TABLE_0_sig)(TInt);
typedef TAknLayoutTableLimits (TScaling_on_list_highlight_skin_placing__general__SUB_TABLE_1_Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__general__SUB_TABLE_1_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__settings__Line_1_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__settings__Line_2_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__settings__Line_3_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__settings__Line_4_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__settings__Line_5_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__settings__Line_6_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__settings__Line_7_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__settings__Line_8_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__settings__Line_9_sig)();
typedef TAknLayoutTableLimits (TScaling_on_list_highlight_skin_placing__settings__Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_list_highlight_skin_placing__settings__sig)(TInt);
typedef TAknWindowLineLayout (TScalingon_edited_settings_item_skin_placing__background_highlight__Line_1_sig)();
typedef TAknWindowLineLayout (TScalingon_edited_settings_item_skin_placing__background_highlight__Line_2_sig)();
typedef TAknWindowLineLayout (TScalingon_edited_settings_item_skin_placing__background_highlight__Line_3_sig)();
typedef TAknWindowLineLayout (TScalingon_edited_settings_item_skin_placing__background_highlight__Line_4_sig)();
typedef TAknWindowLineLayout (TScalingon_edited_settings_item_skin_placing__background_highlight__Line_5_sig)();
typedef TAknWindowLineLayout (TScalingon_edited_settings_item_skin_placing__background_highlight__Line_6_sig)();
typedef TAknWindowLineLayout (TScalingon_edited_settings_item_skin_placing__background_highlight__Line_7_sig)();
typedef TAknWindowLineLayout (TScalingon_edited_settings_item_skin_placing__background_highlight__Line_8_sig)();
typedef TAknWindowLineLayout (TScalingon_edited_settings_item_skin_placing__background_highlight__Line_9_sig)();
typedef TAknLayoutTableLimits (TScalingon_edited_settings_item_skin_placing__background_highlight__Limits_sig)();
typedef TAknWindowLineLayout (TScalingon_edited_settings_item_skin_placing__background_highlight__sig)(TInt);
typedef TAknWindowLineLayout (TScaling_on_edited_settings_item_skin_placing__valuebackground__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TScaling_on_edited_settings_item_skin_placing__valuebackground__Line_2_sig)();
typedef TAknWindowLineLayout (TScaling_on_edited_settings_item_skin_placing__valuebackground__Line_3_sig)();
typedef TAknWindowLineLayout (TScaling_on_edited_settings_item_skin_placing__valuebackground__Line_4_sig)();
typedef TAknWindowLineLayout (TScaling_on_edited_settings_item_skin_placing__valuebackground__Line_5_sig)(TInt);
typedef TAknWindowLineLayout (TScaling_on_edited_settings_item_skin_placing__valuebackground__Line_6_sig)();
typedef TAknWindowLineLayout (TScaling_on_edited_settings_item_skin_placing__valuebackground__Line_7_sig)();
typedef TAknWindowLineLayout (TScaling_on_edited_settings_item_skin_placing__valuebackground__Line_8_sig)(const TRect&);
typedef TAknWindowLineLayout (TScaling_on_edited_settings_item_skin_placing__valuebackground__Line_9_sig)(const TRect&);
typedef TAknLayoutTableLimits (TScaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_0_sig)(TInt);
typedef TAknLayoutTableLimits (TScaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_1_Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_1_sig)(TInt);
typedef TAknLayoutTableLimits (TScaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_2_Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_2_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TScalingon_setting_volume_skin_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TScalingon_setting_volume_skin_Line_2_sig)(TInt);
typedef TAknLayoutTableLimits (TScalingon_setting_volume_skin_Limits_sig)();
typedef TAknWindowLineLayout (TScalingon_setting_volume_skin_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TScaling_on_setting_volume_skin_sizes_Line_2_sig)();
typedef TAknLayoutTableLimits (TScaling_on_setting_volume_skin_sizes_Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_setting_volume_skin_sizes_sig)(TInt);
typedef TAknWindowLineLayout (TScalingon_pop_up_windows_skin_placing__dimming__Line_1_sig)();
typedef TAknWindowLineLayout (TScalingon_pop_up_windows_skin_placing__dimming__Line_2_sig)();
typedef TAknLayoutTableLimits (TScalingon_pop_up_windows_skin_placing__dimming__Limits_sig)();
typedef TAknWindowLineLayout (TScalingon_pop_up_windows_skin_placing__dimming__sig)(TInt);
typedef TAknWindowLineLayout (TScaling_on_pop_up_windows_skin_placing__frame_general__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TScaling_on_pop_up_windows_skin_placing__frame_general__Line_2_sig)();
typedef TAknWindowLineLayout (TScaling_on_pop_up_windows_skin_placing__frame_general__Line_3_sig)();
typedef TAknWindowLineLayout (TScaling_on_pop_up_windows_skin_placing__frame_general__Line_4_sig)();
typedef TAknWindowLineLayout (TScaling_on_pop_up_windows_skin_placing__frame_general__Line_5_sig)();
typedef TAknWindowLineLayout (TScaling_on_pop_up_windows_skin_placing__frame_general__Line_6_sig)();
typedef TAknWindowLineLayout (TScaling_on_pop_up_windows_skin_placing__frame_general__Line_7_sig)();
typedef TAknWindowLineLayout (TScaling_on_pop_up_windows_skin_placing__frame_general__Line_8_sig)(const TRect&);
typedef TAknWindowLineLayout (TScaling_on_pop_up_windows_skin_placing__frame_general__Line_9_sig)(const TRect&);
typedef TAknLayoutTableLimits (TScaling_on_pop_up_windows_skin_placing__frame_general__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_pop_up_windows_skin_placing__frame_general__SUB_TABLE_0_sig)(TInt);
typedef TAknLayoutTableLimits (TScaling_on_pop_up_windows_skin_placing__frame_general__SUB_TABLE_1_Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_pop_up_windows_skin_placing__frame_general__SUB_TABLE_1_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TScaling_on_ending_graphics_for_fast_application_swappingwindow_Line_1_sig)();
typedef TAknWindowLineLayout (TScaling_on_ending_graphics_for_fast_application_swappingwindow_Line_2_sig)();
typedef TAknLayoutTableLimits (TScaling_on_ending_graphics_for_fast_application_swappingwindow_Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_ending_graphics_for_fast_application_swappingwindow_sig)(TInt);
typedef TAknWindowLineLayout (TScaling_on_power_save_state_skin_element_size_Line_2_sig)();
typedef TAknLayoutTableLimits (TScaling_on_power_save_state_skin_element_size_Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_power_save_state_skin_element_size_sig)(TInt);
typedef TAknWindowLineLayout (TScaling_on_calendar_skin_element_placing_and_size__dayweek__Line_1_sig)();
typedef TAknWindowLineLayout (TScaling_on_calendar_skin_element_placing_and_size__dayweek__Line_2_sig)();
typedef TAknWindowLineLayout (TScaling_on_calendar_skin_element_placing_and_size__dayweek__Line_3_sig)();
typedef TAknWindowLineLayout (TScaling_on_calendar_skin_element_placing_and_size__dayweek__Line_4_sig)();
typedef TAknWindowLineLayout (TScaling_on_calendar_skin_element_placing_and_size__dayweek__Line_5_sig)();
typedef TAknWindowLineLayout (TScaling_on_calendar_skin_element_placing_and_size__dayweek__Line_6_sig)();
typedef TAknWindowLineLayout (TScaling_on_calendar_skin_element_placing_and_size__dayweek__Line_7_sig)();
typedef TAknWindowLineLayout (TScaling_on_calendar_skin_element_placing_and_size__dayweek__Line_8_sig)();
typedef TAknWindowLineLayout (TScaling_on_calendar_skin_element_placing_and_size__dayweek__Line_9_sig)();
typedef TAknLayoutTableLimits (TScaling_on_calendar_skin_element_placing_and_size__dayweek__Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_calendar_skin_element_placing_and_size__dayweek__sig)(TInt);
typedef TAknWindowLineLayout (TScalingon_calendar_skin_element_placing_and_size__month__Line_1_sig)();
typedef TAknWindowLineLayout (TScalingon_calendar_skin_element_placing_and_size__month__Line_2_sig)();
typedef TAknWindowLineLayout (TScalingon_calendar_skin_element_placing_and_size__month__Line_3_sig)();
typedef TAknWindowLineLayout (TScalingon_calendar_skin_element_placing_and_size__month__Line_4_sig)();
typedef TAknWindowLineLayout (TScalingon_calendar_skin_element_placing_and_size__month__Line_5_sig)();
typedef TAknWindowLineLayout (TScalingon_calendar_skin_element_placing_and_size__month__Line_6_sig)();
typedef TAknWindowLineLayout (TScalingon_calendar_skin_element_placing_and_size__month__Line_7_sig)();
typedef TAknWindowLineLayout (TScalingon_calendar_skin_element_placing_and_size__month__Line_8_sig)();
typedef TAknWindowLineLayout (TScalingon_calendar_skin_element_placing_and_size__month__Line_9_sig)();
typedef TAknLayoutTableLimits (TScalingon_calendar_skin_element_placing_and_size__month__Limits_sig)();
typedef TAknWindowLineLayout (TScalingon_calendar_skin_element_placing_and_size__month__sig)(TInt);
typedef TAknWindowLineLayout (TScaling_on_favourites_skin_sizes_and_placing_Line_1_sig)();
typedef TAknWindowLineLayout (TScaling_on_favourites_skin_sizes_and_placing_Line_2_sig)();
typedef TAknWindowLineLayout (TScaling_on_favourites_skin_sizes_and_placing_Line_3_sig)();
typedef TAknWindowLineLayout (TScaling_on_favourites_skin_sizes_and_placing_Line_4_sig)();
typedef TAknWindowLineLayout (TScaling_on_favourites_skin_sizes_and_placing_Line_5_sig)();
typedef TAknWindowLineLayout (TScaling_on_favourites_skin_sizes_and_placing_Line_6_sig)();
typedef TAknWindowLineLayout (TScaling_on_favourites_skin_sizes_and_placing_Line_7_sig)();
typedef TAknWindowLineLayout (TScaling_on_favourites_skin_sizes_and_placing_Line_8_sig)();
typedef TAknWindowLineLayout (TScaling_on_favourites_skin_sizes_and_placing_Line_9_sig)();
typedef TAknWindowLineLayout (TScaling_on_favourites_skin_sizes_and_placing_Line_10_sig)();
typedef TAknLayoutTableLimits (TScaling_on_favourites_skin_sizes_and_placing_Limits_sig)();
typedef TAknWindowLineLayout (TScaling_on_favourites_skin_sizes_and_placing_sig)(TInt);

} // end of namespace SkinLayout

#endif // SKINLAYOUT_CDL_COMMON_H
