/*
* Copyright (c) 2002-2004 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/



// This header file contains the customisation implementation identity for Adaptation_Layer_SkinLayout
// It was generated by hand, not by layout compiler.
// This file may be manually modified.
// This customisation implements the interface defined in AppLayout.cdl

// ___Instructions___
// 1. use Adaptation_Layer_AknLayout_Elaf as an example
// 2. fill in the implementations for the global methods (see section "Adaptation Layer Implementation" below")
// 3. do not modify KDataLookup
// 4. then remove the "NULL, //" from the lines in KCdlImpl at the BOTTOM of this file
//
// Notes:
// - if there is NULL in the bottom table, then the implementation in other CDL instance will be used (the ones generated from LAY files)
// - ensure that the instances are in the packs in the correct order in packages.mk (with adaptation layer after LAY file instances)


#include "adaptation_layer_skinlayout.h"
#include "AknLayout2AdaptationDecode.h"
#include "aknlayoutscalable_avkon.cdl.h"
#include "aknlayoutscalable_apps.cdl.h"
#include "layoutmetadata.cdl.h"
#include "aknlayout.cdl.h"

//
// panic
//

enum TAdaptation_Layer_AknSkinLayout_Panic
	{
	EParamsOutsideKnownRange,
    ELayoutLineMissing
    };

void Panic(TAdaptation_Layer_AknSkinLayout_Panic aCode)
	{
	_LIT(KLayoutPanic, "Layout: App Elaf Adaptation Layer panic");
	User::Panic(KLayoutPanic, aCode);
	}


namespace Adaptation_Layer_SkinLayout
{

extern const TUint KDataLookup[SkinLayout::E_TApiId_TableSize];

//
// Helper Methods
//

TAknWindowLineLayout WindowLine0f() { return AknLayoutAdaptationDecode::WindowLine0f(KDataLookup); }
TAknLayoutTableLimits Limits() { return AknLayoutAdaptationDecode::TableLimits(KDataLookup); }
TAknWindowLineLayout WindowTable0f(TInt aLineIndex) { return AknLayoutAdaptationDecode::WindowTable0f(KDataLookup, aLineIndex); }
TAknWindowLineLayout WindowLine2f(TInt aParam0,TInt aParam1) { return AknLayoutAdaptationDecode::WindowLine2f(KDataLookup, aParam0, aParam1); }
TAknWindowLineLayout WindowLine1f(TInt aParam0) { return AknLayoutAdaptationDecode::WindowLine1f(KDataLookup, aParam0); }
TAknWindowLineLayout WindowTable1f(TInt aLineIndex, TInt aParam0) { return AknLayoutAdaptationDecode::WindowTable1f(KDataLookup, aLineIndex, aParam0); }
TAknWindowLineLayout WindowLine0t(const TRect& aParentRect) { return AknLayoutAdaptationDecode::WindowLine0t(KDataLookup, aParentRect); }
TAknWindowLineLayout WindowTable0t(TInt aLineIndex, const TRect& aParentRect) { return AknLayoutAdaptationDecode::WindowTable0t(KDataLookup, aLineIndex, aParentRect); }
TAknWindowLineLayout WindowLine2t(const TRect& aParentRect,TInt aParam0,TInt aParam1) { return AknLayoutAdaptationDecode::WindowLine2t(KDataLookup, aParentRect, aParam0, aParam1); }

inline TAknWindowComponentLayout DoCompose(TAknWindowComponentLayout aLine1, TAknWindowComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::Compose(aLine1, aLine2); 
    }

inline TAknTextComponentLayout DoComposeText(TAknWindowComponentLayout aLine1, TAknTextComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::ComposeText(aLine1, aLine2); 
    }

inline TAknWindowComponentLayout DoIntersect(TAknWindowComponentLayout aLine, TAknWindowComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::Intersect(aLine, aLine2);
    }

inline TAknWindowComponentLayout DoMinus(TAknWindowComponentLayout aLine, TAknWindowComponentLayout aParentDiff)
    {
    return TAknWindowComponentLayout::Minus(aLine, aParentDiff);
    }

// 
//  Common functions
//

TAknWindowLineLayout 
    Setting_list_item_skin_elements__value_background__Line_Split(
    TInt aIndex );
TAknWindowLineLayout List_highlight_skin_placing__general__Line_Split( 
    TInt aIndex );
TAknWindowLineLayout List_highlight_skin_placing__settings__Line_Split(
    TInt aIndex );
TAknWindowLineLayout List_highlight_skin_placing__apps_specific__Line_Split(
    TInt aIndex );
TAknWindowLineLayout List_highlight_skin_placing__popup_specific__Line_Split(
    TInt aIndex );
TAknWindowLineLayout List_highlight_skin_placing__popup_windows__Line_Split(
    TInt aIndex );
TAknWindowLineLayout Highlight_skin_placing__grid__Line_Split(
    TInt aIndex );
TAknWindowLineLayout Highlight_skin_placing__form_popup_field__Line_Split(
    TInt aIndex );
TAknWindowLineLayout Input_field_skin_placing__general__Line_Split(
    TInt aIndex );
TAknWindowLineLayout 
    Edited_settings_item_skin_placing__background_highlight__Line_Split(
    TInt aIndex );
TAknWindowLineLayout 
    Edited_settings_item_skin_placing__value_background__Line_Split(
    TInt aIndex );
TAknWindowLineLayout Edited_settings_item_skin_placing__input__Line_Split(
    TInt aIndex );
TAknWindowLineLayout Popup_windows_skin_placing__frame_general__Line_Split( 
    TInt aIndex );
TAknWindowLineLayout Submenu_skin_placing_Line_Split(
    TInt aIndex );
TAknWindowLineLayout Fast_application_swapping_skin_placing_Line_Split(
    TInt aIndex );
TAknWindowLineLayout Calendar_skin_elements__general__dup_Line_Split(
    TInt aIndex );
TAknWindowLineLayout Favorites_skin_placing_Line_Split(
    TInt aIndex );
TAknWindowLineLayout Notepad_skin_element_placing_Line_Split(
    TInt aIndex );
TAknWindowLineLayout Calculator_paper_skin_element_placing_Line_Split(
    TInt aIndex );
TAknWindowLineLayout Dummy_screen_layout();

//
// Adaptation Layer Implementation
//


// THIS IS AN EXAMPLE API, ALL APIs SET TO USE THIS DUMMY METHOD
TAknWindowLineLayout xInput_field_skin_placing__find_list__Line_n_dummy_implementation()
    {
    TAknWindowLineLayout line = AknLayoutScalable_Avkon::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }

// THIS IS AN EXAMPLE API, NO NEED TO IMPLEMENT ADAPTATION LAYER
//TAknWindowLineLayout xInput_field_skin_placing__find_list__Line_1()
//    {
      // NOT IMPLEMENTED
//    }

// THIS IS AN EXAMPLE API, NO NEED TO IMPLEMENT ADAPTATION LAYER
//TAknWindowLineLayout xInput_field_skin_placing__find_list__Line_2()
//    {
      // NOT IMPLEMENTED
//    }


// THIS IS AN EXAMPLE API, NO NEED TO IMPLEMENT ADAPTATION LAYER
//TAknWindowLineLayout xInput_field_skin_placing__find_list__Line_3()
//    {
      // NOT IMPLEMENTED
//    }


// THIS IS AN EXAMPLE API, NO NEED TO IMPLEMENT ADAPTATION LAYER
//TAknWindowLineLayout xInput_field_skin_placing__find_list__Line_4()
//    {
      // NOT IMPLEMENTED
//    }


// THIS IS AN EXAMPLE API, NO NEED TO IMPLEMENT ADAPTATION LAYER
//TAknWindowLineLayout xInput_field_skin_placing__find_list__Line_5()
//    {
      // NOT IMPLEMENTED
//    }


// THIS IS AN EXAMPLE API, NO NEED TO IMPLEMENT ADAPTATION LAYER
//TAknWindowLineLayout xInput_field_skin_placing__find_list__Line_6()
//    {
      // NOT IMPLEMENTED
//    }


// THIS IS AN EXAMPLE API, NO NEED TO IMPLEMENT ADAPTATION LAYER
//TAknWindowLineLayout xInput_field_skin_placing__find_list__Line_7()
//    {
      // NOT IMPLEMENTED
//    }


// THIS IS AN EXAMPLE API, NO NEED TO IMPLEMENT ADAPTATION LAYER
//TAknWindowLineLayout xInput_field_skin_placing__find_list__Line_8()
//    {
      // NOT IMPLEMENTED
//    }


// THIS IS AN EXAMPLE API, NO NEED TO IMPLEMENT ADAPTATION LAYER
//TAknWindowLineLayout xInput_field_skin_placing__find_list__Line_9()
//    {
      // NOT IMPLEMENTED
//    }

TAknWindowLineLayout Dummy_screen_layout()
	{
	// This is a dummy API used by functions which are not used and thus not implemented.
	TAknWindowLineLayout line = AknLayoutScalable_Avkon::Screen().LayoutLine();
    return line;
	}

TAknWindowLineLayout Screen_background_skin_placing_Line_1()
    {
    // Not in the LAF - expected to match to this one.
    return AknLayout::application_window( TRect() );   
    }

TAknWindowLineLayout Area_background_skin_placing_Line_1()
    {
    // Not in the LAF - expected to match to this one.
    return AknLayout::status_pane( TRect(), 0 );
    }

TAknWindowLineLayout Area_background_skin_placing_Line_2(
        TInt aIndex_t, TInt aIndex_H)
    {
    // aIndex_t = 0, aIndex_H = 0 -> main pane with statuspane
    // aIndex_t = 1, aIndex_H = 1 -> main pane without statuspane

    // other -> not valid
    TInt common1 = 0;
    TInt index_t = 0;

    if ( !aIndex_t && !aIndex_H )
        {
        // status pane on, control pane on (classic)
        common1 = 0;
        index_t = 1;
        }
    if ( aIndex_t && aIndex_H )
        {
        // status pane off, control pane on
        common1 = 0;
        index_t = 0;
        }

    // this should match with AknLayout::main_pane
    return AknLayout::main_pane( TRect(), common1, index_t, 1 );
    }

TAknWindowLineLayout Area_background_skin_placing_Line_3()
    {
    // control pane
    return AknLayout::control_pane( TRect() );
    }


TAknWindowLineLayout Pane_background_skin_naming_Line_1()
    {
    // Not in the LAF, but the following should suffice. 
    // (maximum size defined by parent)
    return AknLayoutScalable_Avkon::bg_popup_window_pane( 0 ).LayoutLine();
    }

TAknWindowLineLayout Navi_pane_background_stripe_skin_placing_Line_1(
        TInt /*aCommon1*/ )
    {
    return AknLayoutScalable_Avkon::status_pane_g1( 0 ).LayoutLine();
    }

TAknWindowLineLayout Navi_pane_background_stripe_skin_placing_Line_2()
    {
    return AknLayoutScalable_Avkon::status_pane_g1( 0 ).LayoutLine();
    }

TAknWindowLineLayout Volume_level_skin_placing_Line_1(TInt /*aIndex_l*/)
    {
    // Derivation: 
    //   qgn_cp_volume_on -> navi_pane
    //   volume_small_pane -> navi_navi_volume_pane 
    //   -> navi_navi_pane -> navi_pane

    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::navi_navi_pane();
    TAknWindowComponentLayout l2 = 
        AknLayoutScalable_Avkon::navi_navi_volume_pane();
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::volume_small_pane();
    
    return DoCompose( l1, DoCompose( l2, l3 ) ).LayoutLine();
    }

TAknWindowLineLayout Volume_level_skin_placing_Line_2(TInt aIndex_l)
    {
    return Volume_level_skin_placing_Line_1( aIndex_l );
    }

TAknWindowLineLayout Volume_area_values_Line_1(TInt /*aIndex_l*/)
    {
    // NOT SUPPORTED.
	return Dummy_screen_layout();
    }

TAknWindowLineLayout Volume_area_values_Line_2(TInt /*aIndex_l*/)
    {
    // NOT SUPPORTED.
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Volume_area_values_Line_3(TInt /*aIndex_l*/)
    {
    // NOT SUPPORTED.
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Volume_area_values_Line_4(TInt /*aIndex_l*/)
    {
    // NOT SUPPORTED.
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Volume_area_values_Line_5(TInt /*aIndex_l*/)
    {
    // NOT SUPPORTED.
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Volume_area_values_Line_6(TInt /*aIndex_l*/)
    {
    // NOT SUPPORTED.
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Volume_area_values_Line_7(TInt /*aIndex_l*/)
    {
    // NOT SUPPORTED.
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Volume_area_values_Line_8(TInt /*aIndex_l*/)
    {
    // NOT SUPPORTED.
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Volume_area_values_Line_9(TInt /*aIndex_l*/)
    {
    // NOT SUPPORTED.
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Volume_area_values_Line_10(TInt /*aIndex_l*/)
    {
    // NOT SUPPORTED.
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Volume_area_values_Line_11(TInt /*aIndex_l*/)
    {
    // NOT SUPPORTED.
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Column_background_and_list_slice_skin_placing_Line_1()
    {
    // ** USED **

    // Derivations:
    //   qsn_bg_column_0 -> main_pane
    //   qsn_bg_column_0 = bg_list_pane_g1 -> bg_list_pane -> main_pane.

    // Any value should be ok for bg_list_pane().
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_list_pane( 0 );
    TAknWindowComponentLayout l2 = 
        AknLayoutScalable_Avkon::bg_list_pane_g1( 0 );
    
    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Column_background_and_list_slice_skin_placing_Line_2()
    {
    // ** USED **
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_list_pane( 0 );
    TAknWindowComponentLayout l2 = 
        AknLayoutScalable_Avkon::bg_list_pane_g1( 1 );
    
    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Column_background_and_list_slice_skin_placing_Line_3()
    {
    // ** USED **
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_list_pane( 0 );
    TAknWindowComponentLayout l2 = 
        AknLayoutScalable_Avkon::bg_list_pane_g1( 2 );
        
    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Column_background_and_list_slice_skin_placing_Line_4()
    {
    // ** USED **
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_list_pane( 0 );
    TAknWindowComponentLayout l2 = 
        AknLayoutScalable_Avkon::bg_list_pane_g2( 0 );
    
    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Column_background_and_list_slice_skin_placing_Line_5()
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_list_pane( 0 );
    TAknWindowComponentLayout l2 = 
        AknLayoutScalable_Avkon::bg_list_pane_g2( 1 );
    
    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Column_background_and_list_slice_skin_placing_Line_6()
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_list_pane( 0 );
    TAknWindowComponentLayout l2 = 
        AknLayoutScalable_Avkon::bg_list_pane_g2( 2 );
    
    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Column_background_and_list_slice_skin_placing_Line_7()
    {
    // ** USED **

    // Derivation:
    //     qsn_bg_slice_list_<ref> -> main_pane
    //     bg_list_pane_g5 -> bg_list_pane -> main_pane.

    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_list_pane( 0 );
    TAknWindowComponentLayout l2 = 
        AknLayoutScalable_Avkon::bg_list_pane_g5( 0 );
    
    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Setting_list_item_skin_elements__value_background__Line_1()
    {
    // Derivation:
    //     qsn_fr_set_opt_foc_center -> list_setting_pane
    //     set_opt_bg_pane_g1 -> bg_set_opt_pane 
    //     -> set_value_pane_cp -> list_setting_pane

    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane_cp( 0 );
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::bg_set_opt_pane( 0 );
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::set_opt_bg_pane_g1();
    
    return DoCompose( l1, DoCompose( l2, l3 ) ).LayoutLine();
    }

TAknWindowLineLayout Setting_list_item_skin_elements__value_background__Line_Split(
        TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane_cp( 0 );
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::bg_set_opt_pane( 0 );
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::set_opt_bg_pane_g1();

    TAknWindowComponentLayout l4 = 
        TAknWindowComponentLayout::Split( 
            l3,
            aIndex );
    return DoCompose( l1, DoCompose( l2, l4 ) ).LayoutLine();
    }

TAknWindowLineLayout Setting_list_item_skin_elements__value_background__Line_2()
    {
    // ** USED **
    return Setting_list_item_skin_elements__value_background__Line_Split( 0 );
    }

TAknWindowLineLayout Setting_list_item_skin_elements__value_background__Line_3()
    {
    return Setting_list_item_skin_elements__value_background__Line_Split( 2 );
    }

TAknWindowLineLayout Setting_list_item_skin_elements__value_background__Line_4()
    {
    return Setting_list_item_skin_elements__value_background__Line_Split( 6 );
    }

TAknWindowLineLayout Setting_list_item_skin_elements__value_background__Line_5()
    {
    // ** USED **
    return Setting_list_item_skin_elements__value_background__Line_Split( 8 );
    }

TAknWindowLineLayout Setting_list_item_skin_elements__value_background__Line_6()
    {
    return Setting_list_item_skin_elements__value_background__Line_Split( 1 );
    }

TAknWindowLineLayout Setting_list_item_skin_elements__value_background__Line_7()
    {
    return Setting_list_item_skin_elements__value_background__Line_Split( 7 );
    }

TAknWindowLineLayout Setting_list_item_skin_elements__value_background__Line_8()
    {
    return Setting_list_item_skin_elements__value_background__Line_Split( 3 );
    }

TAknWindowLineLayout Setting_list_item_skin_elements__value_background__Line_9()
    {
    return Setting_list_item_skin_elements__value_background__Line_Split( 5 );
    }

TAknWindowLineLayout Setting_list_item_skin_placing__volume__Line_1()
    {
    // Derivation:
    //     qsn_cp_set_list_volume_off -> list_setting_pane
    //     volume_small_pane_cp -> set_value_pane_cp -> list_setting_pane
    
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane_cp( 0 );
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_small_pane_cp();
    
    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Setting_list_item_skin_placing__volume__Line_2()
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane_cp( 0 );
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_small_pane_cp();
    
    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Settings_volume_area_values_Line_1()
    {
    // Each bar is different bitmap in new LAF -> not in the LAF.
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_Line_3()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_Line_4()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_Line_5()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_Line_6()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_Line_7()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_Line_8()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_Line_9()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_Line_10()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_Line_11()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout List_highlight_skin_placing__general__Line_Split( 
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::list_highlight_pane_cp1();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_highlight_pane_g1_cp1();
    TAknWindowComponentLayout l3 = TAknWindowComponentLayout::Split( l2, aIndex );

    return DoCompose( l1, l3 ).LayoutLine();
    }

TAknWindowLineLayout List_highlight_skin_placing__general__Line_1(
        const TRect& /*aParentRect*/ )
    {
    // ** USED **
    // Derivation: 
    //     qsn_fr_list_center -> list_single_pane
    //     list_highlight_pane_g1_cp1 -> list_highlight_pane_cp1 -> list_single_pane

    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::list_highlight_pane_cp1();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_highlight_pane_g1_cp1();

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout List_highlight_skin_placing__general__Line_2()
    {
    // ** USED **
    return List_highlight_skin_placing__general__Line_Split( 0 );
    }

TAknWindowLineLayout List_highlight_skin_placing__general__Line_3()
    {
    return List_highlight_skin_placing__general__Line_Split( 2 );
    }

TAknWindowLineLayout List_highlight_skin_placing__general__Line_4()
    {
    return List_highlight_skin_placing__general__Line_Split( 6 );
    }

TAknWindowLineLayout List_highlight_skin_placing__general__Line_5()
    {
    // ** USED **
    return List_highlight_skin_placing__general__Line_Split( 8 );
    }

TAknWindowLineLayout List_highlight_skin_placing__general__Line_6()
    {
    return List_highlight_skin_placing__general__Line_Split( 1 );
    }

TAknWindowLineLayout List_highlight_skin_placing__general__Line_7()
    {
    return List_highlight_skin_placing__general__Line_Split( 7 );
    }

TAknWindowLineLayout List_highlight_skin_placing__general__Line_8(
        const TRect& /*aParentRect*/ )
    {
    return List_highlight_skin_placing__general__Line_Split( 3 );
    }

TAknWindowLineLayout List_highlight_skin_placing__general__Line_9(
        const TRect& /*aParentRect*/ )
    {
    return List_highlight_skin_placing__general__Line_Split( 5 );
    }

TAknWindowLineLayout List_highlight_skin_placing__settings__Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::list_highlight_pane_cp1();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_highlight_pane_g1_cp1();
    TAknWindowComponentLayout l3 = TAknWindowComponentLayout::Split( l2, aIndex );

    return DoCompose( l1, l3 ).LayoutLine();
    }

TAknWindowLineLayout List_highlight_skin_placing__settings__Line_1()
    {
    // Derivation:
    //    qsn_fr_list_center -> list_setting_number_pane 
    //      -> set_value_pane -> list_setting_number_pane

    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::list_highlight_pane_cp1();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_highlight_pane_g1_cp1();   

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout List_highlight_skin_placing__settings__Line_2()
    {
    // ** USED **
    return List_highlight_skin_placing__settings__Line_Split( 0 );
    }

TAknWindowLineLayout List_highlight_skin_placing__settings__Line_3()
    {
    return List_highlight_skin_placing__settings__Line_Split( 2 );
    }

TAknWindowLineLayout List_highlight_skin_placing__settings__Line_4()
    {
    return List_highlight_skin_placing__settings__Line_Split( 6 );
    }

TAknWindowLineLayout List_highlight_skin_placing__settings__Line_5()
    {
    // ** USED **
    return List_highlight_skin_placing__settings__Line_Split( 8 );
    }

TAknWindowLineLayout List_highlight_skin_placing__settings__Line_6()
    {
    return List_highlight_skin_placing__settings__Line_Split( 1 );
    }

TAknWindowLineLayout List_highlight_skin_placing__settings__Line_7()
    {
    return List_highlight_skin_placing__settings__Line_Split( 7 );
    }

TAknWindowLineLayout List_highlight_skin_placing__settings__Line_8()
    {
    return List_highlight_skin_placing__settings__Line_Split( 3 );
    }

TAknWindowLineLayout List_highlight_skin_placing__settings__Line_9()
    {
    return List_highlight_skin_placing__settings__Line_Split( 5 );
    }

TAknWindowLineLayout List_highlight_skin_placing__apps_specific__Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::list_highlight_pane_cp02();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_highlight_pane_g1_cp1(); 
    TAknWindowComponentLayout l3 = TAknWindowComponentLayout::Split( l2, aIndex );

    return DoCompose( l1, l3 ).LayoutLine();
    }

TAknWindowLineLayout List_highlight_skin_placing__apps_specific__Line_1(
        const TRect& /*aParentRect*/)
    {
    // ** USED **
    // Derivation:
    //    qsn_fr_list_center -> list_pinb_item_pane
    //    list_highlight_pane_g1_cp1 -> list_highlight_pane_cp02 -> list_pinb_item_pane

    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::list_highlight_pane_cp02();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_highlight_pane_g1_cp1();   

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout List_highlight_skin_placing__apps_specific__Line_2()
    {
    // ** USED **
    return List_highlight_skin_placing__apps_specific__Line_Split( 0 );
    }


TAknWindowLineLayout List_highlight_skin_placing__apps_specific__Line_3()
    {
    return List_highlight_skin_placing__apps_specific__Line_Split( 2 );
    }

TAknWindowLineLayout List_highlight_skin_placing__apps_specific__Line_4()
    {
    return List_highlight_skin_placing__apps_specific__Line_Split( 6 );
    }

TAknWindowLineLayout List_highlight_skin_placing__apps_specific__Line_5()
    {
    // ** USED **
    return List_highlight_skin_placing__apps_specific__Line_Split( 8 );
    }

TAknWindowLineLayout List_highlight_skin_placing__apps_specific__Line_6(
        const TRect& /*aParentRect*/)
    {
    return List_highlight_skin_placing__apps_specific__Line_Split( 1 );
    }

TAknWindowLineLayout List_highlight_skin_placing__apps_specific__Line_7(
        const TRect& /*aParentRect*/)
    {
    return List_highlight_skin_placing__apps_specific__Line_Split( 7 );
    }

TAknWindowLineLayout List_highlight_skin_placing__apps_specific__Line_8(
        const TRect& /*aParentRect*/)
    {
    return List_highlight_skin_placing__apps_specific__Line_Split( 3 );
    }

TAknWindowLineLayout List_highlight_skin_placing__apps_specific__Line_9(
        const TRect& /*aParentRect*/)
    {
    return List_highlight_skin_placing__apps_specific__Line_Split( 5 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_specific__Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::list_highlight_pane_cp1();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_highlight_pane_g1_cp1();
    TAknWindowComponentLayout l3 = TAknWindowComponentLayout::Split( l2, aIndex );

    return DoCompose( l1, l3 ).LayoutLine();
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_specific__Line_1(
        const TRect& /*aParentRect*/)
    {
    // Derivation through list_single_pane_cp2.
    
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::list_highlight_pane_cp1();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_highlight_pane_g1_cp1();   

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_specific__Line_2()
    {
    return List_highlight_skin_placing__popup_specific__Line_Split( 0 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_specific__Line_3()
    {
    return List_highlight_skin_placing__popup_specific__Line_Split( 2 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_specific__Line_4()
    {
    return List_highlight_skin_placing__popup_specific__Line_Split( 6 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_specific__Line_5()
    {
    return List_highlight_skin_placing__popup_specific__Line_Split( 8 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_specific__Line_6(
        const TRect& /*aParentRect*/)
    {
    return List_highlight_skin_placing__popup_specific__Line_Split( 1 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_specific__Line_7(
        const TRect& /*aParentRect*/)
    {
    return List_highlight_skin_placing__popup_specific__Line_Split( 7 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_specific__Line_8(
        const TRect& /*aParentRect*/)
    {
    return List_highlight_skin_placing__popup_specific__Line_Split( 3 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_specific__Line_9(
        const TRect& /*aParentRect*/)
    {
    return List_highlight_skin_placing__popup_specific__Line_Split( 5 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_windows__Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::list_highlight_pane_cp1();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_highlight_pane_g1_cp1();
    TAknWindowComponentLayout l3 = TAknWindowComponentLayout::Split( l2, aIndex );

    return DoCompose( l1, l3 ).LayoutLine();
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_windows__Line_1(
        const TRect& /*aParentRect*/)
    {
    // Derivation:
    //     list_single_popup_menu_pane -> qsn_fr_list_center
    //     apparently replaced by normal lists in LAF - popup_menu_window -> 
    //        listscroll_menu_pane -> list_menu_pane -> list_single_pane_cp2

    // Derivation for lists: 
    //     qsn_fr_list_center -> list_single_pane
    //     list_highlight_pane_g1_cp1 -> list_highlight_pane_cp1 -> list_single_pane

    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::list_highlight_pane_cp1();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_highlight_pane_g1_cp1();

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_windows__Line_2()
    {
    // ** USED **
    return List_highlight_skin_placing__popup_windows__Line_Split( 0 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_windows__Line_3()
    {
    return List_highlight_skin_placing__popup_windows__Line_Split( 2 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_windows__Line_4()
    {
    return List_highlight_skin_placing__popup_windows__Line_Split( 6 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_windows__Line_5()
    {
    // ** USED **
    return List_highlight_skin_placing__popup_windows__Line_Split( 8 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_windows__Line_6(
        const TRect& /*aParentRect*/)
    {
    return List_highlight_skin_placing__popup_windows__Line_Split( 1 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_windows__Line_7(
        const TRect& /*aParentRect*/)
    {
    return List_highlight_skin_placing__popup_windows__Line_Split( 7 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_windows__Line_8(
        const TRect& /*aParentRect*/)
    {
    return List_highlight_skin_placing__popup_windows__Line_Split( 3 );
    }

TAknWindowLineLayout List_highlight_skin_placing__popup_windows__Line_9(
        const TRect& /*aParentRect*/)
    {
    return List_highlight_skin_placing__popup_windows__Line_Split( 5 );
    }

TAknWindowLineLayout Highlight_skin_placing__grid__Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::grid_highlight_pane( 0 );
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::cell_highlight_pane_g1(); 
    TAknWindowComponentLayout l3 = TAknWindowComponentLayout::Split( l2, aIndex );

    return DoCompose( l1, l3 ).LayoutLine();
    }

TAknWindowLineLayout Highlight_skin_placing__grid__Line_1(
        const TRect& /*aParentRect*/)
    {
    // ** USED **
    // Derivation:
    //    qsn_fr_grid_center -> cell_app_pane
    //    cell_highlight_pane_g1 = qsn_fr_grid_center -> grid_highlight_pane -> cell_app_pane_cp2

    // grid_highlight_pane  - options 0 & 1 do not have grid_highlight_pane. Assuming that indexing
    // goes based on variant.
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::grid_highlight_pane( 0 );
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::cell_highlight_pane_g1();   

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Highlight_skin_placing__grid__Line_2()
    {
    // ** USED **
    return Highlight_skin_placing__grid__Line_Split( 0 );
    }

TAknWindowLineLayout Highlight_skin_placing__grid__Line_3()
    {
    return Highlight_skin_placing__grid__Line_Split( 2 );
    }

TAknWindowLineLayout Highlight_skin_placing__grid__Line_4()
    {
    return Highlight_skin_placing__grid__Line_Split( 6 );
    }

TAknWindowLineLayout Highlight_skin_placing__grid__Line_5()
    {
    // ** USED **
    return Highlight_skin_placing__grid__Line_Split( 8 );
    }

TAknWindowLineLayout Highlight_skin_placing__grid__Line_6(
        const TRect& /*aParentRect*/)
    {
    return Highlight_skin_placing__grid__Line_Split( 1 );
    }

TAknWindowLineLayout Highlight_skin_placing__grid__Line_7(
        const TRect& /*aParentRect*/)
    {
    return Highlight_skin_placing__grid__Line_Split( 7 );
    }

TAknWindowLineLayout Highlight_skin_placing__grid__Line_8(
        const TRect& /*aParentRect*/)
    {
    return Highlight_skin_placing__grid__Line_Split( 3 );
    }

TAknWindowLineLayout Highlight_skin_placing__grid__Line_9(
        const TRect& /*aParentRect*/)
    {
    return Highlight_skin_placing__grid__Line_Split( 5 );
    }

TAknWindowLineLayout Highlight_skin_placing__form_popup_field__Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::list_form_pane(0);
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_form_graphic_pane( 0 ); 
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_highlight_pane_cp5( 0 );
    TAknWindowComponentLayout l4 = AknLayoutScalable_Avkon::list_highlight_pane_g1_cp1();
    TAknWindowComponentLayout l5 = TAknWindowComponentLayout::Split( l4, aIndex );

    return DoCompose( DoCompose( l1, l2 ), DoCompose( l3, l5 ) ).LayoutLine();
    }

TAknWindowLineLayout Highlight_skin_placing__form_popup_field__Line_1(
        const TRect& /*aParentRect*/)
    {
    // Derivation:
    // qsn_fr_list_center -> form_field_popup_pane
    // list_highlight_pane_g1_cp1 = qsn_fr_list_center = -> list_highlight_pane_cp5 -> 
    //     list_form_graphic_pane -> list_form_pane -> form_field_popup_pane

    // Note: according to LAF list_form_graphic_pane should not take parameter

    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::list_form_pane(0);
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_form_graphic_pane( 0 ); 
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_highlight_pane_cp5( 0 );
    TAknWindowComponentLayout l4 = AknLayoutScalable_Avkon::list_highlight_pane_g1_cp1();

    return DoCompose( DoCompose( l1, l2 ), DoCompose( l3, l4 ) ).LayoutLine();
    }

TAknWindowLineLayout Highlight_skin_placing__form_popup_field__Line_2()
    {
    return Highlight_skin_placing__form_popup_field__Line_Split( 0 );
    }

TAknWindowLineLayout Highlight_skin_placing__form_popup_field__Line_3()
    {
    return Highlight_skin_placing__form_popup_field__Line_Split( 2 );
    }

TAknWindowLineLayout Highlight_skin_placing__form_popup_field__Line_4()
    {
    return Highlight_skin_placing__form_popup_field__Line_Split( 6 );
    }

TAknWindowLineLayout Highlight_skin_placing__form_popup_field__Line_5()
    {
    return Highlight_skin_placing__form_popup_field__Line_Split( 8 );
    }

TAknWindowLineLayout Highlight_skin_placing__form_popup_field__Line_6(
        const TRect& /*aParentRect*/)
    {
    return Highlight_skin_placing__form_popup_field__Line_Split( 1 );
    }

TAknWindowLineLayout Highlight_skin_placing__form_popup_field__Line_7(
        const TRect& /*aParentRect*/)
    {
    return Highlight_skin_placing__form_popup_field__Line_Split( 7 );
    }

TAknWindowLineLayout Highlight_skin_placing__form_popup_field__Line_8(
        const TRect& /*aParentRect*/)
    {
    return Highlight_skin_placing__form_popup_field__Line_Split( 3 );
    }

TAknWindowLineLayout Highlight_skin_placing__form_popup_field__Line_9(
        const TRect& /*aParentRect*/)
    {
    return Highlight_skin_placing__form_popup_field__Line_Split( 5 );
    }

TAknWindowLineLayout xFind_pop_up_window_elements_Line_1()
    {
    // Not in the LAF. (not used)
    return Dummy_screen_layout();
    }

TAknWindowLineLayout xFind_pop_up_window_elements_Line_2()
    {
    // Not in the LAF. (not used)
    return Dummy_screen_layout();
    }

TAknWindowLineLayout xFind_pop_up_window_elements_Line_3()
    {
    // Not in the LAF. (not used)
    return Dummy_screen_layout();
    }
    
TAknWindowLineLayout Input_field_skin_placing__general__Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = 
        AknLayoutScalable_Avkon::input_focus_pane_g1();
    TAknWindowComponentLayout l2 = TAknWindowComponentLayout::Split( l1, aIndex );
    return l2.LayoutLine();
    }

TAknWindowLineLayout Input_field_skin_placing__general__Line_1()
    {
    // Derivation:
    //    qsn_fr_input_center -> Outline frame rectangle
    //    input_focus_pane_g1 = qsn_fr_input_center -> input_focus_pane

    return AknLayoutScalable_Avkon::input_focus_pane_g1().LayoutLine();
    }

TAknWindowLineLayout Input_field_skin_placing__general__Line_2()
    {
    // ** USED **
    return Input_field_skin_placing__general__Line_Split( 0 );
    }

TAknWindowLineLayout Input_field_skin_placing__general__Line_3()
    {
    // ** USED **
    return Input_field_skin_placing__general__Line_Split( 2 );
    }

TAknWindowLineLayout Input_field_skin_placing__general__Line_4()
    {
    // ** USED **
    return Input_field_skin_placing__general__Line_Split( 6 );
    }

TAknWindowLineLayout Input_field_skin_placing__general__Line_5()
    {
    // ** USED **
    return Input_field_skin_placing__general__Line_Split( 8 );
    }

TAknWindowLineLayout Input_field_skin_placing__general__Line_6()
    {
    // ** USED **
    return Input_field_skin_placing__general__Line_Split( 1 );
    }

TAknWindowLineLayout Input_field_skin_placing__general__Line_7()
    {
    // ** USED **
    return Input_field_skin_placing__general__Line_Split( 7 );
    }

TAknWindowLineLayout Input_field_skin_placing__general__Line_8()
    {
    return Input_field_skin_placing__general__Line_Split( 3 );
    }

TAknWindowLineLayout Input_field_skin_placing__general__Line_9()
    {
    return Input_field_skin_placing__general__Line_Split( 5 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__background_highlight__Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_set_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::set_content_pane(); 
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_highlight_pane_cp2();
    TAknWindowComponentLayout l4 = AknLayoutScalable_Avkon::list_highlight_pane_g1_cp1();
    TAknWindowComponentLayout l5 = TAknWindowComponentLayout::Split( l4, aIndex );

    return DoCompose( DoCompose( l1, l2 ), DoCompose( l3, l5 ) ).LayoutLine();
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__background_highlight__Line_1()
    {
    // Derivation:
    //   qsn_fr_list_center -> main_pane
    //   list_highlight_pane_g1_cp1 -> list_highlight_pane_cp2 -> set_content_pane 
    //       -> listscroll_set_pane -> main_pane
    
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_set_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::set_content_pane(); 
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_highlight_pane_cp2();
    TAknWindowComponentLayout l4 = AknLayoutScalable_Avkon::list_highlight_pane_g1_cp1();

    return DoCompose( DoCompose( l1, l2 ), DoCompose( l3, l4 ) ).LayoutLine();
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__background_highlight__Line_2()
    {
    // ** USED **
    return Edited_settings_item_skin_placing__background_highlight__Line_Split( 0 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__background_highlight__Line_3()
    {
    return Edited_settings_item_skin_placing__background_highlight__Line_Split( 2 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__background_highlight__Line_4()
    {
    return Edited_settings_item_skin_placing__background_highlight__Line_Split( 6 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__background_highlight__Line_5()
    {
    // ** USED **
    return Edited_settings_item_skin_placing__background_highlight__Line_Split( 8 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__background_highlight__Line_6()
    {
    return Edited_settings_item_skin_placing__background_highlight__Line_Split( 1 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__background_highlight__Line_7()
    {
    return Edited_settings_item_skin_placing__background_highlight__Line_Split( 7 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__background_highlight__Line_8()
    {
    return Edited_settings_item_skin_placing__background_highlight__Line_Split( 3 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__background_highlight__Line_9()
    {
    return Edited_settings_item_skin_placing__background_highlight__Line_Split( 5 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__value_background__Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_set_opt_pane_cp();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::set_opt_bg_pane_g1();
    TAknWindowComponentLayout l3 = TAknWindowComponentLayout::Split( l2, aIndex );
    return DoCompose( l1, l3 ).LayoutLine();
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__value_background__Line_1(
        const TRect& /*aParentRect*/)
    {
    // Derivation:
    //    qsn_fr_set_opt_center -> setting_slider_pane
    //    qsn_fr_set_opt_center = bg_set_opt_pane_cp -> bg_set_opt_pane_cp -> setting_slider_pane

    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_set_opt_pane_cp();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::set_opt_bg_pane_g1();

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__value_background__Line_2()
    {
    // ** USED **
    return Edited_settings_item_skin_placing__value_background__Line_Split( 0 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__value_background__Line_3()
    {
    return Edited_settings_item_skin_placing__value_background__Line_Split( 2 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__value_background__Line_4()
    {
    return Edited_settings_item_skin_placing__value_background__Line_Split( 6 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__value_background__Line_5()
    {
    // ** USED **
    return Edited_settings_item_skin_placing__value_background__Line_Split( 8 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__value_background__Line_6()
    {
    return Edited_settings_item_skin_placing__value_background__Line_Split( 1 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__value_background__Line_7()
    {
    return Edited_settings_item_skin_placing__value_background__Line_Split( 7 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__value_background__Line_8(
        const TRect& /*aParentRect*/)
    {
    return Edited_settings_item_skin_placing__value_background__Line_Split( 3 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__value_background__Line_9(
        const TRect& /*aParentRect*/)
    {
    return Edited_settings_item_skin_placing__value_background__Line_Split( 5 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__input__Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::input_focus_pane_cp1();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::input_focus_pane_g1();
    TAknWindowComponentLayout l3 = TAknWindowComponentLayout::Split( l2, aIndex );

    return DoCompose( l1, l3 ).LayoutLine();
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__input__Line_1(
        const TRect& /*aParentRect*/)
    {
    // Derivation:
    //    qsn_fr_input_center -> setting_code_pane
    //    input_focus_pane_g1 -> input_focus_pane -> setting_code_pane

    // Note: setting_text_pane & setting_code_pane parents are input_focus_pane_cp1 and 
    // input_focus_pane_cp2. Layout information equals, so input_focus_pane_cp1 is used.
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::input_focus_pane_cp1();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::input_focus_pane_g1();

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__input__Line_2()
    {
    // ** USED **
    return Edited_settings_item_skin_placing__input__Line_Split( 0 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__input__Line_3()
    {
    return Edited_settings_item_skin_placing__input__Line_Split( 2 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__input__Line_4()
    {
    return Edited_settings_item_skin_placing__input__Line_Split( 6 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__input__Line_5()
    {
    // ** USED **
    return Edited_settings_item_skin_placing__input__Line_Split( 8 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__input__Line_6()
    {
    return Edited_settings_item_skin_placing__input__Line_Split( 1 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__input__Line_7()
    {
    return Edited_settings_item_skin_placing__input__Line_Split( 7 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__input__Line_8(
        const TRect& /*aParentRect*/)
    {
    return Edited_settings_item_skin_placing__input__Line_Split( 3 );
    }

TAknWindowLineLayout Edited_settings_item_skin_placing__input__Line_9(
        const TRect& /*aParentRect*/)
    {
    return Edited_settings_item_skin_placing__input__Line_Split( 5 );
    }

TAknWindowLineLayout Setting_volume_skin_placing_Line_1()
    {
    // Volume handled differently in the new LAF. Each bitmap separately.
	// NOT USED
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Setting_volume_skin_placing_Line_2()
    {
    // Derivation:
    //    Level 1 -> setting_volume_pane
    //    volume_set_pane_g1 -> volume_set_pane -> setting_volume_pane
	// NOT USED
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_dup_Line_1()
    {
    // NOT SUPPORTED (not used)
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_dup_Line_2()
    {
    // NOT SUPPORTED (not used)
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_dup_Line_3()
    {
    // NOT SUPPORTED (not used)
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_dup_Line_4()
    {
    // NOT SUPPORTED (not used)
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_dup_Line_5()
    {
    // NOT SUPPORTED (not used)
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_dup_Line_6()
    {
    // NOT SUPPORTED (not used)
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_dup_Line_7()
    {
    // NOT SUPPORTED (not used)
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_dup_Line_8()
    {
    // NOT SUPPORTED (not used)
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_dup_Line_9()
    {
    // NOT SUPPORTED (not used)
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_dup_Line_10()
    {
    // NOT SUPPORTED (not used)
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Settings_volume_area_values_dup_Line_11()
    {
    // NOT SUPPORTED (not used)
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Popup_windows_skin_placing__dimming__Line_1()
    {
    return Area_background_skin_placing_Line_2( 1, 1 ); // main pane without status pane.
    }

TAknWindowLineLayout Popup_windows_skin_placing__background_slice__Line_1(
        const TRect& /*aParentRect*/)
    {
    // ** USED **
    // Not specified in LAF.    
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Popup_windows_skin_placing__background_slice__Line_2()
    {
    // ** USED **

    // Not sure if correct.
    
    // Derivation:
    //     qsn_bg_popup_background -> Various pop-up windows
    //     bg_list_pane_g5 ->

    return AknLayoutScalable_Avkon::bg_list_pane_g5( 0 ).LayoutLine();
    }

TAknWindowLineLayout Popup_windows_skin_placing__frame_general__Line_Split( 
    TInt aIndex )
    {
    TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation();
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_popup_window_pane( 0 );
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::bg_popup_window_pane_g1(varietyIndex);
    TAknWindowComponentLayout l3 = TAknWindowComponentLayout::Split( l2, aIndex );

    return DoCompose( l1, l3 ).LayoutLine();
    }

TAknWindowLineLayout Popup_windows_skin_placing__frame_general__Line_1(
        const TRect& /*aParentRect*/)
    {
    // ** USED **
    // Derivation:
    //   qsn_fr_popup_center -> Various pop-up window panes
    //   bg_popup_window_pane_g1 -> bg_popup_window_pane -> popup_window_general

    TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation();
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_popup_window_pane( 0 );
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::bg_popup_window_pane_g1(varietyIndex);

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Popup_windows_skin_placing__frame_general__Line_2()
    {
    // ** USED **
    return Popup_windows_skin_placing__frame_general__Line_Split( 0 );
    }

TAknWindowLineLayout Popup_windows_skin_placing__frame_general__Line_3()
    {
    return Popup_windows_skin_placing__frame_general__Line_Split( 2 );
    }

TAknWindowLineLayout Popup_windows_skin_placing__frame_general__Line_4()
    {
    return Popup_windows_skin_placing__frame_general__Line_Split( 6 );
    }

TAknWindowLineLayout Popup_windows_skin_placing__frame_general__Line_5()
    {
    // ** USED **
    return Popup_windows_skin_placing__frame_general__Line_Split( 8 );
    }

TAknWindowLineLayout Popup_windows_skin_placing__frame_general__Line_6()
    {
    return Popup_windows_skin_placing__frame_general__Line_Split( 1 );
    }

TAknWindowLineLayout Popup_windows_skin_placing__frame_general__Line_7()
    {
    return Popup_windows_skin_placing__frame_general__Line_Split( 7 );
    }

TAknWindowLineLayout Popup_windows_skin_placing__frame_general__Line_8(
        const TRect& /*aParentRect*/)
    {
    return Popup_windows_skin_placing__frame_general__Line_Split( 3 );
    }

TAknWindowLineLayout Popup_windows_skin_placing__frame_general__Line_9(
        const TRect& /*aParentRect*/)
    {
    return Popup_windows_skin_placing__frame_general__Line_Split( 5 );
    }

TAknWindowLineLayout Submenu_skin_placing_Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_popup_sub_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::bg_popup_sub_pane_g1();
    TAknWindowComponentLayout l3 = TAknWindowComponentLayout::Split( l2, aIndex );

    return DoCompose( l1, l3 ).LayoutLine();
    }

TAknWindowLineLayout Submenu_skin_placing_Line_1(
        const TRect& /*aParentRect*/)
    {
    // Derivation: 
    //     qsn_fr_popup_center_submenu -> popup_submenu_window
    //     bg_popup_sub_pane_g1 -> bg_popup_sub_pane -> popup_sub_window_general
    
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_popup_sub_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::bg_popup_sub_pane_g1();

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Submenu_skin_placing_Line_2()
    {
    // ** USED **
    return Submenu_skin_placing_Line_Split( 0 );
    }

TAknWindowLineLayout Submenu_skin_placing_Line_3()
    {
    return Submenu_skin_placing_Line_Split( 2 );
    }

TAknWindowLineLayout Submenu_skin_placing_Line_4()
    {
    return Submenu_skin_placing_Line_Split( 6 );
    }

TAknWindowLineLayout Submenu_skin_placing_Line_5()
    {
    // ** USED **
    return Submenu_skin_placing_Line_Split( 8 );
    }

TAknWindowLineLayout Submenu_skin_placing_Line_6(
        const TRect& /*aParentRect*/)
    {
    return Submenu_skin_placing_Line_Split( 1 );
    }

TAknWindowLineLayout Submenu_skin_placing_Line_7(
        const TRect& /*aParentRect*/)
    {
    return Submenu_skin_placing_Line_Split( 7 );
    }

TAknWindowLineLayout Submenu_skin_placing_Line_8(
        const TRect& /*aParentRect*/)
    {
    return Submenu_skin_placing_Line_Split( 3 );
    }


TAknWindowLineLayout Submenu_skin_placing_Line_9(
        const TRect& /*aParentRect*/)
    {
    return Submenu_skin_placing_Line_Split( 5 );
    }

TAknWindowLineLayout Slice_skin_placing__fastapps__Line_1()
    {
    // ** USED **
    TAknWindowLineLayout line = AknLayoutScalable_Avkon::bg_popup_window_pane_g10(0).LayoutLine();
    return line;
    }

TAknWindowLineLayout Fast_application_swapping_skin_placing_Line_Split(
    TInt aIndex )
    {
    TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation();
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_popup_window_pane_cp13(0);
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::bg_popup_window_pane_g1(varietyIndex);
    TAknWindowComponentLayout l3 = TAknWindowComponentLayout::Split( l2, aIndex );

    return DoCompose( l1, l3 ).LayoutLine();
    }

TAknWindowLineLayout Fast_application_swapping_skin_placing_Line_1(
        const TRect& /*aParentRect*/)
    {
    // ** USED **
    TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation();
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::bg_popup_window_pane_cp13(0);
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::bg_popup_window_pane_g1(varietyIndex);

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Fast_application_swapping_skin_placing_Line_2()
    {
    // ** USED **
    return Fast_application_swapping_skin_placing_Line_Split( 0 );
    }

TAknWindowLineLayout Fast_application_swapping_skin_placing_Line_3()
    {
    // ** USED **
    return Fast_application_swapping_skin_placing_Line_Split( 2 );
    }

TAknWindowLineLayout Fast_application_swapping_skin_placing_Line_4()
    {
    // ** USED **
    return Fast_application_swapping_skin_placing_Line_Split( 6 );
    }

TAknWindowLineLayout Fast_application_swapping_skin_placing_Line_5()
    {
    // ** USED **
    return Fast_application_swapping_skin_placing_Line_Split( 8 );
    }

TAknWindowLineLayout Fast_application_swapping_skin_placing_Line_6()
    {
    // ** USED **
    return Fast_application_swapping_skin_placing_Line_Split( 1 );
    }

TAknWindowLineLayout Fast_application_swapping_skin_placing_Line_7()
    {
    // ** USED **
    return Fast_application_swapping_skin_placing_Line_Split( 7 );
    }

TAknWindowLineLayout Fast_application_swapping_skin_placing_Line_8(
        const TRect& /*aParentRect*/)
    {
    // ** USED **
    return Fast_application_swapping_skin_placing_Line_Split( 3 );
    }

TAknWindowLineLayout Fast_application_swapping_skin_placing_Line_9(
        const TRect& /*aParentRect*/)
    {
    // ** USED **
    return Fast_application_swapping_skin_placing_Line_Split( 5 );
    }

TAknWindowLineLayout Fast_application_swapping_skin_placing_Line_10(
        const TRect& /*aParentRect*/)
    {
    // Not defined in the new LAF (well, not really defined in the old either)
	// NOT USED
    return Dummy_screen_layout();
    }

TAknWindowLineLayout wallpaper_pane()
    {
    return AknLayout::wallpaper_pane();
    }

TAknWindowLineLayout Changes_to_existing_elements__idle_wallpaper__Line_2(
        const TRect& aParentRect, TInt aIndex_t, TInt aIndex_H )
    {
    return AknLayout::Soft_indicator_pane_elements_Line_1( aParentRect, aIndex_t, aIndex_H );
    }

TAknWindowLineLayout Idle_clock_skin_placing___analogue__Line_1()
    {
    // ** USED **

    // Note: Mismatch between rows in LAF & functions.

    // Derivation:
    //     qsn_cp_clock_analogue_face_1 -> context_pane
    //     popup_clock_analogue_window_g1 -> popup_clock_analogue_window -> context_pane

    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::popup_clock_analogue_window();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Apps::popup_clock_analogue_window_g1();

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Idle_clock_skin_placing___analogue__Line_2()
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::popup_clock_analogue_window();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Apps::popup_clock_analogue_window_g2();

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Idle_clock_skin_placing___analogue__Line_3()
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::popup_clock_analogue_window();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Apps::popup_clock_analogue_window_g3();

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Idle_clock_skin_placing___analogue__Line_4()
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::popup_clock_analogue_window();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Apps::popup_clock_analogue_window_g4();

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Idle_clock_skin_placing___analogue__Line_5()
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::popup_clock_analogue_window();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Apps::popup_clock_analogue_window_g5();

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Idle_clock_skin_placing___digital__Line_1(
        TInt aIndex_l )
    {
    // ** USED **

    // Mismatch between LAF & LayoutTool specifications..

    // Derivation: 
    //     qsn_cp_clock_digital_* -> context_pane
    //     clock_digital_number_pane_g1 -> clock_digital_number_pane_g* -> 
    //         popup_clock_digital_window -> context_pane

	// MurrayR 9/2/05: fixed digital clock digit ordering bug by swapping
	// calls to _cp02 and _cp03.

    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::popup_clock_digital_window();

    TAknWindowComponentLayout l2;
    switch ( aIndex_l )
        {
        case 0:
            l2 = AknLayoutScalable_Apps::clock_digital_number_pane( 0 );
            break;

        case 1:
            l2 = AknLayoutScalable_Apps::clock_digital_number_pane_cp03( 0 );
            break;

        case 2:
            l2 = AknLayoutScalable_Apps::clock_digital_number_pane_cp02( 0 );
            break;

        case 3:
        default:
            l2 = AknLayoutScalable_Apps::clock_digital_number_pane_cp04( 0 );
            break;
        }

    TAknWindowComponentLayout l3 = AknLayoutScalable_Apps::clock_digital_number_pane_g1();
    return DoCompose( l1, DoCompose( l2, l3 ) ).LayoutLine();
    }

TAknWindowLineLayout Idle_clock_skin_placing___digital__Line_2(
        TInt aIndex_l ) 
    {
    return Idle_clock_skin_placing___digital__Line_1( aIndex_l );
    }

TAknWindowLineLayout Idle_clock_skin_placing___digital__Line_3(
        const TRect& /*aParentRect*/ )
    {
    // ** USED ** 
    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::popup_clock_digital_window();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Apps::clock_digital_separator_pane( 0 );
    TAknWindowComponentLayout l3 = AknLayoutScalable_Apps::clock_digital_separator_pane_g1();

    return DoCompose( l1, DoCompose( l2, l3 ) ).LayoutLine();
    }

TAknWindowLineLayout Power_save_state_skin_placing_Line_1()
    {
    // Derivation:
    //     qsn_bg_powersave -> power_save_pane
    //     power_save_pane_g1 -> power_save_pane
    
    return AknLayoutScalable_Avkon::power_save_pane_g1(0).LayoutLine();
    }

TAknWindowLineLayout Calendar_skin_elements__general__dup_Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::main_cale_day_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Apps::listscroll_cale_day_pane();
    TAknWindowComponentLayout l3 = AknLayoutScalable_Apps::bg_cale_pane();
    TAknWindowComponentLayout l4 = AknLayoutScalable_Apps::cale_bg_pane_g1();
    TAknWindowComponentLayout l5 = TAknWindowComponentLayout::Split( l4, aIndex );

    return DoCompose( l1, DoCompose( l2, DoCompose( l3, l5 ) ) ).LayoutLine();
    }

TAknWindowLineLayout Calendar_skin_elements__general__dup_Line_1()
    {
    // ** USED **
    
    // Derivation:
    //    qsn_fr_cale_center_* -> main_pane
    //    main_pane -> main_cale_day_pane -> listscroll_cale_day_pane
    //      -> bg_cale_pane -> cale_bg_pane_g1
    
    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::main_cale_day_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Apps::listscroll_cale_day_pane();
    TAknWindowComponentLayout l3 = AknLayoutScalable_Apps::bg_cale_pane();
    TAknWindowComponentLayout l4 = AknLayoutScalable_Apps::cale_bg_pane_g1();

    return DoCompose( l1, DoCompose( l2, DoCompose( l3, l4 ) ) ).LayoutLine();
    }

TAknWindowLineLayout Calendar_skin_elements__general__dup_Line_2()
    {
    // ** USED **
    return Calendar_skin_elements__general__dup_Line_Split( 0 );
    }

TAknWindowLineLayout Calendar_skin_elements__general__dup_Line_3()
    {
    return Calendar_skin_elements__general__dup_Line_Split( 2 );
    }

TAknWindowLineLayout Calendar_skin_elements__general__dup_Line_4()
    {
    return Calendar_skin_elements__general__dup_Line_Split( 6 );
    }

TAknWindowLineLayout Calendar_skin_elements__general__dup_Line_5()
    {
    // ** USED **
    return Calendar_skin_elements__general__dup_Line_Split( 8 );
    }

TAknWindowLineLayout Calendar_skin_elements__general__dup_Line_6()
    {
    return Calendar_skin_elements__general__dup_Line_Split( 1 );
    }

TAknWindowLineLayout Calendar_skin_elements__general__dup_Line_7()
    {
    return Calendar_skin_elements__general__dup_Line_Split( 7 );
    }

TAknWindowLineLayout Calendar_skin_elements__general__dup_Line_8()
    {
    return Calendar_skin_elements__general__dup_Line_Split( 3 );
    }

TAknWindowLineLayout Calendar_skin_elements__general__dup_Line_9()
    {
    return Calendar_skin_elements__general__dup_Line_Split( 5 );
    }

TAknWindowLineLayout Slice_skin_placing__pinb__Line_1()
    {
    // Derivation:
    //     qsn_bg_slice_pinb -> main_pane
    //     pinb_bg_pane_g10 -> bg_pinb_pane -> main_pinb_pane -> main_pane

    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::main_pinb_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Apps::bg_pinb_pane( 0 );
    TAknWindowComponentLayout l3 = AknLayoutScalable_Apps::pinb_bg_pane_g10();
    
    return DoCompose( l1, DoCompose( l2, l3 ) ).LayoutLine();
    }

TAknWindowLineLayout Favorites_skin_placing_Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::main_pinb_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Apps::bg_pinb_pane( 0 );
    TAknWindowComponentLayout l3 = AknLayoutScalable_Apps::pinb_bg_pane_g1();
    TAknWindowComponentLayout l4 = TAknWindowComponentLayout::Split( l3, aIndex );

    return DoCompose( l1, DoCompose( l2, l4 ) ).LayoutLine();
    }

TAknWindowLineLayout Favorites_skin_placing_Line_1()
    {
    // Derivation:
    //     qsn_fr_pinb_center_wp -> main_pane
    //     pinb_bg_pane_g1 -> bg_pinb_pane -> main_pinb_pane -> main_pane

    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::main_pinb_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Apps::bg_pinb_pane( 0 );
    TAknWindowComponentLayout l3 = AknLayoutScalable_Apps::pinb_bg_pane_g1();

    return DoCompose( l1, DoCompose( l2, l3 ) ).LayoutLine();
    }

TAknWindowLineLayout Favorites_skin_placing_Line_2()
    {
    // transparency not specified in the new LAF - Is this same as Line_1
    return Favorites_skin_placing_Line_1();
    }

TAknWindowLineLayout Favorites_skin_placing_Line_3()
    {
    return Favorites_skin_placing_Line_Split( 0 );
    }

TAknWindowLineLayout Favorites_skin_placing_Line_4()
    {
    return Favorites_skin_placing_Line_Split( 2 );
    }

TAknWindowLineLayout Favorites_skin_placing_Line_5()
    {
    return Favorites_skin_placing_Line_Split( 6 );
    }

TAknWindowLineLayout Favorites_skin_placing_Line_6()
    {
    return Favorites_skin_placing_Line_Split( 8 );
    }

TAknWindowLineLayout Favorites_skin_placing_Line_7()
    {
    return Favorites_skin_placing_Line_Split( 1 );
    }

TAknWindowLineLayout Favorites_skin_placing_Line_8()
    {
    return Favorites_skin_placing_Line_Split( 7 );
    }

TAknWindowLineLayout Favorites_skin_placing_Line_9()
    {
    return Favorites_skin_placing_Line_Split( 3 );
    }

TAknWindowLineLayout Favorites_skin_placing_Line_10()
    {
    return Favorites_skin_placing_Line_Split( 5 );
    }

TAknWindowLineLayout Screen_saver_skin_placing_Line_1()
    {
    // Same as application_window.
    return AknLayout::application_window( TRect() );
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__Line_1(
        TInt /*aIndex_l*/, TInt /*aIndex_t*/ )
    {
    // Not in the LAF (not used)
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_3()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_4()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_5()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_6()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_7()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_8()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_9()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_10()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_11()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_12()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_13()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_14()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_15()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_16()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_17()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Colour_palette_preview_screen_element_placing__main_area__dup_Line_18()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Chinese_FEP_pop_up_window_lines_Line_1(
        TInt /*aPaneLayout*/ )
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Chinese_FEP_pop_up_window_lines_Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_background_images__general__Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_status_area_background__general__Line_1(
        TInt /*aCommon1*/ )
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_status_area_background__idle__Line_1(
        TInt /*aCommon1*/ )
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_navi_pane_background_images_Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_tab_graphics_Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_setting_list_volume_skin_elements_Line_1(
        TInt /*aCommon1*/ )
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_setting_volume_skin_Line_1(
        TInt /*aCommon1*/ )
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_setting_volume_skin_sizes_Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_pop_up_windows_skin_placing__dimming__Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_ending_graphics_for_fast_application_swapping_window_Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_power_save_state_skin_element_size_Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_screensaver_skin_size_Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Notepad_skin_element_placing_Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::bg_notes_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Apps::notes_bg_pane_g1();
    TAknWindowComponentLayout l3 = TAknWindowComponentLayout::Split( l2, aIndex );

    return DoCompose( l1, l3 ).LayoutLine();
    }

TAknWindowLineLayout Notepad_skin_element_placing_Line_1()
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::bg_notes_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Apps::notes_bg_pane_g1();

    return DoCompose( l1, l2 ).LayoutLine();
    }

TAknWindowLineLayout Notepad_skin_element_placing_Line_2()
    {
    return Notepad_skin_element_placing_Line_Split( 0 );
    }

TAknWindowLineLayout Notepad_skin_element_placing_Line_3()
    {
    return Notepad_skin_element_placing_Line_Split( 2 );
    }

TAknWindowLineLayout Notepad_skin_element_placing_Line_4()
    {
    return Notepad_skin_element_placing_Line_Split( 6 );
    }

TAknWindowLineLayout Notepad_skin_element_placing_Line_5()
    {
    return Notepad_skin_element_placing_Line_Split( 8 );
    }

TAknWindowLineLayout Notepad_skin_element_placing_Line_6()
    {
    return Notepad_skin_element_placing_Line_Split( 1 );
    }

TAknWindowLineLayout Notepad_skin_element_placing_Line_7()
    {
    return Notepad_skin_element_placing_Line_Split( 7 );
    }

TAknWindowLineLayout Notepad_skin_element_placing_Line_8()
    {
    return Notepad_skin_element_placing_Line_Split( 3 );
    }

TAknWindowLineLayout Notepad_skin_element_placing_Line_9()
    {
    return Notepad_skin_element_placing_Line_Split( 5 );
    }

TAknWindowLineLayout Calculator_paper_skin_element_placing_Line_Split(
    TInt aIndex )
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::bg_calc_paper_pane_g1();
    return TAknWindowComponentLayout::Split( l1, aIndex ).LayoutLine();
    }

TAknWindowLineLayout Calculator_paper_skin_element_placing_Line_1()
    {
    return AknLayoutScalable_Apps::bg_calc_paper_pane_g1().LayoutLine();
    }

TAknWindowLineLayout Calculator_paper_skin_element_placing_Line_2()
    {
    return Calculator_paper_skin_element_placing_Line_Split( 0 );
    }

TAknWindowLineLayout Calculator_paper_skin_element_placing_Line_3()
    {
    return Calculator_paper_skin_element_placing_Line_Split( 2 );
    }

TAknWindowLineLayout Calculator_paper_skin_element_placing_Line_4()
    {
    return Calculator_paper_skin_element_placing_Line_Split( 6 );
    }

TAknWindowLineLayout Calculator_paper_skin_element_placing_Line_5()
    {
    return Calculator_paper_skin_element_placing_Line_Split( 8 );
    }

TAknWindowLineLayout Calculator_paper_skin_element_placing_Line_6()
    {
    return Calculator_paper_skin_element_placing_Line_Split( 1 );
    }

TAknWindowLineLayout Calculator_paper_skin_element_placing_Line_7()
    {
    return Calculator_paper_skin_element_placing_Line_Split( 7 );
    }

TAknWindowLineLayout Calculator_paper_skin_element_placing_Line_8()
    {
    return Calculator_paper_skin_element_placing_Line_Split( 3 );
    }

TAknWindowLineLayout Calculator_paper_skin_element_placing_Line_9()
    {
    return Calculator_paper_skin_element_placing_Line_Split( 5 );
    }

TAknWindowLineLayout Calculator_glass_element_placing_Line_1()
    {
    return AknLayoutScalable_Apps::bg_calc_display_pane_g2().LayoutLine();
    }

TAknWindowLineLayout Calculator_glass_element_placing_Line_2()
    {
    return AknLayoutScalable_Apps::bg_calc_display_pane_g1().LayoutLine();
    }

TAknWindowLineLayout Calculator_glass_element_placing_Line_3()
    {
    return AknLayoutScalable_Apps::bg_calc_display_pane_g3().LayoutLine();
    }

TAknWindowLineLayout Scalingon_background_images__general__Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_background_images__general__Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_status_area_background__general__Line_2(TInt /*aCommon1*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_status_area_background__idle__Line_2(TInt /*aCommon1*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_navipane_background_images_Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_navipane_background_images_Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_tab_graphics_Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_tab_graphics_Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalinon_volume_area_values_Line_1(TInt /*aIndex_l*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalinon_volume_area_values_Line_2(TInt /*aIndex_l*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalinon_volume_area_values_Line_3(TInt /*aIndex_l*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalinon_volume_area_values_Line_4(TInt /*aIndex_l*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalinon_volume_area_values_Line_5(TInt /*aIndex_l*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalinon_volume_area_values_Line_6(TInt /*aIndex_l*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalinon_volume_area_values_Line_7(TInt /*aIndex_l*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalinon_volume_area_values_Line_8(TInt /*aIndex_l*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalinon_volume_area_values_Line_9(TInt /*aIndex_l*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalinon_volume_area_values_Line_10(TInt /*aIndex_l*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalinon_volume_area_values_Line_11(TInt /*aIndex_l*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_list_item_skin_elements__value_background__Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_list_item_skin_elements__value_background__Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_list_item_skin_elements__value_background__Line_3()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_list_item_skin_elements__value_background__Line_4()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_list_item_skin_elements__value_background__Line_5()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_list_item_skin_elements__value_background__Line_6()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_list_item_skin_elements__value_background__Line_7()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_list_item_skin_elements__value_background__Line_8()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_list_item_skin_elements__value_background__Line_9()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_list_volume_skin_elements_Line_1(TInt /*aCommon1*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_list_volume_skin_elements_Line_2(TInt /*aCommon1*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_list_item_skin_placing_Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_list_item_skin_placing_Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__general__Line_1(const TRect& /*aParentRect*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__general__Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__general__Line_3()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__general__Line_4()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__general__Line_5()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__general__Line_6()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__general__Line_7()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__general__Line_8(const TRect& /*aParentRect*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__general__Line_9(const TRect& /*aParentRect*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__settings__Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__settings__Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__settings__Line_3()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__settings__Line_4()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__settings__Line_5()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__settings__Line_6()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__settings__Line_7()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__settings__Line_8()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_list_highlight_skin_placing__settings__Line_9()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_edited_settings_item_skin_placing__background_highlight__Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_edited_settings_item_skin_placing__background_highlight__Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_edited_settings_item_skin_placing__background_highlight__Line_3()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_edited_settings_item_skin_placing__background_highlight__Line_4()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_edited_settings_item_skin_placing__background_highlight__Line_5()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_edited_settings_item_skin_placing__background_highlight__Line_6()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_edited_settings_item_skin_placing__background_highlight__Line_7()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_edited_settings_item_skin_placing__background_highlight__Line_8()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_edited_settings_item_skin_placing__background_highlight__Line_9()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_1(const TRect& /*aParentRect*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_3()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_4()
    {
   	return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_5(TInt /*aIndex_r*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_6()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_7()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_8(const TRect& /*aParentRect*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_9(const TRect& /*aParentRect*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_volume_skin_Line_1(TInt /*aCommon1*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_setting_volume_skin_Line_2(TInt /*aCommon1*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_setting_volume_skin_sizes_Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_pop_up_windows_skin_placing__dimming__Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_pop_up_windows_skin_placing__dimming__Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_pop_up_windows_skin_placing__frame_general__Line_1(const TRect& /*aParentRect*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_pop_up_windows_skin_placing__frame_general__Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_pop_up_windows_skin_placing__frame_general__Line_3()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_pop_up_windows_skin_placing__frame_general__Line_4()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_pop_up_windows_skin_placing__frame_general__Line_5()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_pop_up_windows_skin_placing__frame_general__Line_6()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_pop_up_windows_skin_placing__frame_general__Line_7()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_pop_up_windows_skin_placing__frame_general__Line_8(const TRect& /*aParentRect*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_pop_up_windows_skin_placing__frame_general__Line_9(const TRect& /*aParentRect*/)
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_ending_graphics_for_fast_application_swappingwindow_Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_ending_graphics_for_fast_application_swappingwindow_Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_power_save_state_skin_element_size_Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_3()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_4()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_5()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_6()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_7()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_8()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_9()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_calendar_skin_element_placing_and_size__month__Line_1()
    {
   	return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_calendar_skin_element_placing_and_size__month__Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_calendar_skin_element_placing_and_size__month__Line_3()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_calendar_skin_element_placing_and_size__month__Line_4()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_calendar_skin_element_placing_and_size__month__Line_5()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_calendar_skin_element_placing_and_size__month__Line_6()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_calendar_skin_element_placing_and_size__month__Line_7()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_calendar_skin_element_placing_and_size__month__Line_8()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scalingon_calendar_skin_element_placing_and_size__month__Line_9()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_favourites_skin_sizes_and_placing_Line_1()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_favourites_skin_sizes_and_placing_Line_2()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_favourites_skin_sizes_and_placing_Line_3()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_favourites_skin_sizes_and_placing_Line_4()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_favourites_skin_sizes_and_placing_Line_5()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_favourites_skin_sizes_and_placing_Line_6()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_favourites_skin_sizes_and_placing_Line_7()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_favourites_skin_sizes_and_placing_Line_8()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_favourites_skin_sizes_and_placing_Line_9()
    {
    return Dummy_screen_layout();
    }

TAknWindowLineLayout Scaling_on_favourites_skin_sizes_and_placing_Line_10()
    {
    return Dummy_screen_layout();
    }


//
// Lookup Table
// This is needed for multiline texts and table decoding
// Do not modify
//

const TUint KDataLookup[SkinLayout::E_TApiId_TableSize] =
	{
(TUint)&xInput_field_skin_placing__find_list__Line_n_dummy_implementation,

(TUint)&xInput_field_skin_placing__find_list__Line_n_dummy_implementation,

(TUint)&xInput_field_skin_placing__find_list__Line_n_dummy_implementation,

(TUint)&xInput_field_skin_placing__find_list__Line_n_dummy_implementation,

(TUint)&xInput_field_skin_placing__find_list__Line_n_dummy_implementation,

(TUint)&xInput_field_skin_placing__find_list__Line_n_dummy_implementation,

(TUint)&xInput_field_skin_placing__find_list__Line_n_dummy_implementation,

(TUint)&xInput_field_skin_placing__find_list__Line_n_dummy_implementation,

(TUint)&xInput_field_skin_placing__find_list__Line_n_dummy_implementation,

0x0008,

(TUint16)SkinLayout::EApiId_xInput_field_skin_placing__find_list__Line_1,

(TUint)&Screen_background_skin_placing_Line_1,

(TUint)&Area_background_skin_placing_Line_1,

(TUint)&Area_background_skin_placing_Line_2,

(TUint)&Area_background_skin_placing_Line_3,

(TUint)&Pane_background_skin_naming_Line_1,

(TUint)&Navi_pane_background_stripe_skin_placing_Line_1,

(TUint)&Navi_pane_background_stripe_skin_placing_Line_2,

(TUint)&Volume_level_skin_placing_Line_1,

(TUint)&Volume_level_skin_placing_Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Volume_level_skin_placing_Line_1,

(TUint)&Volume_area_values_Line_1,

(TUint)&Volume_area_values_Line_2,

(TUint)&Volume_area_values_Line_3,

(TUint)&Volume_area_values_Line_4,

(TUint)&Volume_area_values_Line_5,

(TUint)&Volume_area_values_Line_6,

(TUint)&Volume_area_values_Line_7,

(TUint)&Volume_area_values_Line_8,

(TUint)&Volume_area_values_Line_9,

(TUint)&Volume_area_values_Line_10,

(TUint)&Volume_area_values_Line_11,

0x000a,

(TUint16)SkinLayout::EApiId_Volume_area_values_Line_1,

(TUint)&Column_background_and_list_slice_skin_placing_Line_1,

(TUint)&Column_background_and_list_slice_skin_placing_Line_2,

(TUint)&Column_background_and_list_slice_skin_placing_Line_3,

(TUint)&Column_background_and_list_slice_skin_placing_Line_4,

(TUint)&Column_background_and_list_slice_skin_placing_Line_5,

(TUint)&Column_background_and_list_slice_skin_placing_Line_6,

(TUint)&Column_background_and_list_slice_skin_placing_Line_7,

0x0006,

(TUint16)SkinLayout::EApiId_Column_background_and_list_slice_skin_placing_Line_1,

(TUint)&Setting_list_item_skin_elements__value_background__Line_1,

(TUint)&Setting_list_item_skin_elements__value_background__Line_2,

(TUint)&Setting_list_item_skin_elements__value_background__Line_3,

(TUint)&Setting_list_item_skin_elements__value_background__Line_4,

(TUint)&Setting_list_item_skin_elements__value_background__Line_5,

(TUint)&Setting_list_item_skin_elements__value_background__Line_6,

(TUint)&Setting_list_item_skin_elements__value_background__Line_7,

(TUint)&Setting_list_item_skin_elements__value_background__Line_8,

(TUint)&Setting_list_item_skin_elements__value_background__Line_9,

0x0008,

(TUint16)SkinLayout::EApiId_Setting_list_item_skin_elements__value_background__Line_1,

(TUint)&Setting_list_item_skin_placing__volume__Line_1,

(TUint)&Setting_list_item_skin_placing__volume__Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Setting_list_item_skin_placing__volume__Line_1,

(TUint)&Settings_volume_area_values_Line_1,

(TUint)&Settings_volume_area_values_Line_2,

(TUint)&Settings_volume_area_values_Line_3,

(TUint)&Settings_volume_area_values_Line_4,

(TUint)&Settings_volume_area_values_Line_5,

(TUint)&Settings_volume_area_values_Line_6,

(TUint)&Settings_volume_area_values_Line_7,

(TUint)&Settings_volume_area_values_Line_8,

(TUint)&Settings_volume_area_values_Line_9,

(TUint)&Settings_volume_area_values_Line_10,

(TUint)&Settings_volume_area_values_Line_11,

0x000a,

(TUint16)SkinLayout::EApiId_Settings_volume_area_values_Line_1,

(TUint)&List_highlight_skin_placing__general__Line_1,

(TUint)&List_highlight_skin_placing__general__Line_2,

(TUint)&List_highlight_skin_placing__general__Line_3,

(TUint)&List_highlight_skin_placing__general__Line_4,

(TUint)&List_highlight_skin_placing__general__Line_5,

(TUint)&List_highlight_skin_placing__general__Line_6,

(TUint)&List_highlight_skin_placing__general__Line_7,

(TUint)&List_highlight_skin_placing__general__Line_8,

(TUint)&List_highlight_skin_placing__general__Line_9,

0x0106,

(TUint16)SkinLayout::EApiId_List_highlight_skin_placing__general__Line_1,

0x0708,

(TUint16)SkinLayout::EApiId_List_highlight_skin_placing__general__Line_1,

(TUint)&List_highlight_skin_placing__settings__Line_1,

(TUint)&List_highlight_skin_placing__settings__Line_2,

(TUint)&List_highlight_skin_placing__settings__Line_3,

(TUint)&List_highlight_skin_placing__settings__Line_4,

(TUint)&List_highlight_skin_placing__settings__Line_5,

(TUint)&List_highlight_skin_placing__settings__Line_6,

(TUint)&List_highlight_skin_placing__settings__Line_7,

(TUint)&List_highlight_skin_placing__settings__Line_8,

(TUint)&List_highlight_skin_placing__settings__Line_9,

0x0008,

(TUint16)SkinLayout::EApiId_List_highlight_skin_placing__settings__Line_1,

(TUint)&List_highlight_skin_placing__apps_specific__Line_1,

(TUint)&List_highlight_skin_placing__apps_specific__Line_2,

(TUint)&List_highlight_skin_placing__apps_specific__Line_3,

(TUint)&List_highlight_skin_placing__apps_specific__Line_4,

(TUint)&List_highlight_skin_placing__apps_specific__Line_5,

(TUint)&List_highlight_skin_placing__apps_specific__Line_6,

(TUint)&List_highlight_skin_placing__apps_specific__Line_7,

(TUint)&List_highlight_skin_placing__apps_specific__Line_8,

(TUint)&List_highlight_skin_placing__apps_specific__Line_9,

0x0104,

(TUint16)SkinLayout::EApiId_List_highlight_skin_placing__apps_specific__Line_1,

0x0508,

(TUint16)SkinLayout::EApiId_List_highlight_skin_placing__apps_specific__Line_1,

(TUint)&List_highlight_skin_placing__popup_specific__Line_1,

(TUint)&List_highlight_skin_placing__popup_specific__Line_2,

(TUint)&List_highlight_skin_placing__popup_specific__Line_3,

(TUint)&List_highlight_skin_placing__popup_specific__Line_4,

(TUint)&List_highlight_skin_placing__popup_specific__Line_5,

(TUint)&List_highlight_skin_placing__popup_specific__Line_6,

(TUint)&List_highlight_skin_placing__popup_specific__Line_7,

(TUint)&List_highlight_skin_placing__popup_specific__Line_8,

(TUint)&List_highlight_skin_placing__popup_specific__Line_9,

0x0104,

(TUint16)SkinLayout::EApiId_List_highlight_skin_placing__popup_specific__Line_1,

0x0508,

(TUint16)SkinLayout::EApiId_List_highlight_skin_placing__popup_specific__Line_1,

(TUint)&List_highlight_skin_placing__popup_windows__Line_1,

(TUint)&List_highlight_skin_placing__popup_windows__Line_2,

(TUint)&List_highlight_skin_placing__popup_windows__Line_3,

(TUint)&List_highlight_skin_placing__popup_windows__Line_4,

(TUint)&List_highlight_skin_placing__popup_windows__Line_5,

(TUint)&List_highlight_skin_placing__popup_windows__Line_6,

(TUint)&List_highlight_skin_placing__popup_windows__Line_7,

(TUint)&List_highlight_skin_placing__popup_windows__Line_8,

(TUint)&List_highlight_skin_placing__popup_windows__Line_9,

0x0104,

(TUint16)SkinLayout::EApiId_List_highlight_skin_placing__popup_windows__Line_1,

0x0508,

(TUint16)SkinLayout::EApiId_List_highlight_skin_placing__popup_windows__Line_1,

(TUint)&Highlight_skin_placing__grid__Line_1,

(TUint)&Highlight_skin_placing__grid__Line_2,

(TUint)&Highlight_skin_placing__grid__Line_3,

(TUint)&Highlight_skin_placing__grid__Line_4,

(TUint)&Highlight_skin_placing__grid__Line_5,

(TUint)&Highlight_skin_placing__grid__Line_6,

(TUint)&Highlight_skin_placing__grid__Line_7,

(TUint)&Highlight_skin_placing__grid__Line_8,

(TUint)&Highlight_skin_placing__grid__Line_9,

0x0104,

(TUint16)SkinLayout::EApiId_Highlight_skin_placing__grid__Line_1,

0x0508,

(TUint16)SkinLayout::EApiId_Highlight_skin_placing__grid__Line_1,

(TUint)&Highlight_skin_placing__form_popup_field__Line_1,

(TUint)&Highlight_skin_placing__form_popup_field__Line_2,

(TUint)&Highlight_skin_placing__form_popup_field__Line_3,

(TUint)&Highlight_skin_placing__form_popup_field__Line_4,

(TUint)&Highlight_skin_placing__form_popup_field__Line_5,

(TUint)&Highlight_skin_placing__form_popup_field__Line_6,

(TUint)&Highlight_skin_placing__form_popup_field__Line_7,

(TUint)&Highlight_skin_placing__form_popup_field__Line_8,

(TUint)&Highlight_skin_placing__form_popup_field__Line_9,

0x0104,

(TUint16)SkinLayout::EApiId_Highlight_skin_placing__form_popup_field__Line_1,

0x0508,

(TUint16)SkinLayout::EApiId_Highlight_skin_placing__form_popup_field__Line_1,

(TUint)&xFind_pop_up_window_elements_Line_1,

(TUint)&xFind_pop_up_window_elements_Line_2,

(TUint)&xFind_pop_up_window_elements_Line_3,

0x0002,

(TUint16)SkinLayout::EApiId_xFind_pop_up_window_elements_Line_1,

(TUint)&Input_field_skin_placing__general__Line_1,

(TUint)&Input_field_skin_placing__general__Line_2,

(TUint)&Input_field_skin_placing__general__Line_3,

(TUint)&Input_field_skin_placing__general__Line_4,

(TUint)&Input_field_skin_placing__general__Line_5,

(TUint)&Input_field_skin_placing__general__Line_6,

(TUint)&Input_field_skin_placing__general__Line_7,

(TUint)&Input_field_skin_placing__general__Line_8,

(TUint)&Input_field_skin_placing__general__Line_9,

0x0008,

(TUint16)SkinLayout::EApiId_Input_field_skin_placing__general__Line_1,

(TUint)&Edited_settings_item_skin_placing__background_highlight__Line_1,

(TUint)&Edited_settings_item_skin_placing__background_highlight__Line_2,

(TUint)&Edited_settings_item_skin_placing__background_highlight__Line_3,

(TUint)&Edited_settings_item_skin_placing__background_highlight__Line_4,

(TUint)&Edited_settings_item_skin_placing__background_highlight__Line_5,

(TUint)&Edited_settings_item_skin_placing__background_highlight__Line_6,

(TUint)&Edited_settings_item_skin_placing__background_highlight__Line_7,

(TUint)&Edited_settings_item_skin_placing__background_highlight__Line_8,

(TUint)&Edited_settings_item_skin_placing__background_highlight__Line_9,

0x0008,

(TUint16)SkinLayout::EApiId_Edited_settings_item_skin_placing__background_highlight__Line_1,

(TUint)&Edited_settings_item_skin_placing__value_background__Line_1,

(TUint)&Edited_settings_item_skin_placing__value_background__Line_2,

(TUint)&Edited_settings_item_skin_placing__value_background__Line_3,

(TUint)&Edited_settings_item_skin_placing__value_background__Line_4,

(TUint)&Edited_settings_item_skin_placing__value_background__Line_5,

(TUint)&Edited_settings_item_skin_placing__value_background__Line_6,

(TUint)&Edited_settings_item_skin_placing__value_background__Line_7,

(TUint)&Edited_settings_item_skin_placing__value_background__Line_8,

(TUint)&Edited_settings_item_skin_placing__value_background__Line_9,

0x0106,

(TUint16)SkinLayout::EApiId_Edited_settings_item_skin_placing__value_background__Line_1,

0x0708,

(TUint16)SkinLayout::EApiId_Edited_settings_item_skin_placing__value_background__Line_1,

(TUint)&Edited_settings_item_skin_placing__input__Line_1,

(TUint)&Edited_settings_item_skin_placing__input__Line_2,

(TUint)&Edited_settings_item_skin_placing__input__Line_3,

(TUint)&Edited_settings_item_skin_placing__input__Line_4,

(TUint)&Edited_settings_item_skin_placing__input__Line_5,

(TUint)&Edited_settings_item_skin_placing__input__Line_6,

(TUint)&Edited_settings_item_skin_placing__input__Line_7,

(TUint)&Edited_settings_item_skin_placing__input__Line_8,

(TUint)&Edited_settings_item_skin_placing__input__Line_9,

0x0106,

(TUint16)SkinLayout::EApiId_Edited_settings_item_skin_placing__input__Line_1,

0x0708,

(TUint16)SkinLayout::EApiId_Edited_settings_item_skin_placing__input__Line_1,

(TUint)&Setting_volume_skin_placing_Line_1,

(TUint)&Setting_volume_skin_placing_Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Setting_volume_skin_placing_Line_1,

(TUint)&Settings_volume_area_values_dup_Line_1,

(TUint)&Settings_volume_area_values_dup_Line_2,

(TUint)&Settings_volume_area_values_dup_Line_3,

(TUint)&Settings_volume_area_values_dup_Line_4,

(TUint)&Settings_volume_area_values_dup_Line_5,

(TUint)&Settings_volume_area_values_dup_Line_6,

(TUint)&Settings_volume_area_values_dup_Line_7,

(TUint)&Settings_volume_area_values_dup_Line_8,

(TUint)&Settings_volume_area_values_dup_Line_9,

(TUint)&Settings_volume_area_values_dup_Line_10,

(TUint)&Settings_volume_area_values_dup_Line_11,

0x000a,

(TUint16)SkinLayout::EApiId_Settings_volume_area_values_dup_Line_1,

(TUint)&Popup_windows_skin_placing__dimming__Line_1,

(TUint)&Popup_windows_skin_placing__background_slice__Line_1,

(TUint)&Popup_windows_skin_placing__background_slice__Line_2,

(TUint)&Popup_windows_skin_placing__frame_general__Line_1,

(TUint)&Popup_windows_skin_placing__frame_general__Line_2,

(TUint)&Popup_windows_skin_placing__frame_general__Line_3,

(TUint)&Popup_windows_skin_placing__frame_general__Line_4,

(TUint)&Popup_windows_skin_placing__frame_general__Line_5,

(TUint)&Popup_windows_skin_placing__frame_general__Line_6,

(TUint)&Popup_windows_skin_placing__frame_general__Line_7,

(TUint)&Popup_windows_skin_placing__frame_general__Line_8,

(TUint)&Popup_windows_skin_placing__frame_general__Line_9,

0x0106,

(TUint16)SkinLayout::EApiId_Popup_windows_skin_placing__frame_general__Line_1,

0x0708,

(TUint16)SkinLayout::EApiId_Popup_windows_skin_placing__frame_general__Line_1,

(TUint)&Submenu_skin_placing_Line_1,

(TUint)&Submenu_skin_placing_Line_2,

(TUint)&Submenu_skin_placing_Line_3,

(TUint)&Submenu_skin_placing_Line_4,

(TUint)&Submenu_skin_placing_Line_5,

(TUint)&Submenu_skin_placing_Line_6,

(TUint)&Submenu_skin_placing_Line_7,

(TUint)&Submenu_skin_placing_Line_8,

(TUint)&Submenu_skin_placing_Line_9,

0x0104,

(TUint16)SkinLayout::EApiId_Submenu_skin_placing_Line_1,

0x0508,

(TUint16)SkinLayout::EApiId_Submenu_skin_placing_Line_1,

(TUint)&Slice_skin_placing__fastapps__Line_1,

(TUint)&Fast_application_swapping_skin_placing_Line_1,

(TUint)&Fast_application_swapping_skin_placing_Line_2,

(TUint)&Fast_application_swapping_skin_placing_Line_3,

(TUint)&Fast_application_swapping_skin_placing_Line_4,

(TUint)&Fast_application_swapping_skin_placing_Line_5,

(TUint)&Fast_application_swapping_skin_placing_Line_6,

(TUint)&Fast_application_swapping_skin_placing_Line_7,

(TUint)&Fast_application_swapping_skin_placing_Line_8,

(TUint)&Fast_application_swapping_skin_placing_Line_9,

(TUint)&Fast_application_swapping_skin_placing_Line_10,

0x0106,

(TUint16)SkinLayout::EApiId_Fast_application_swapping_skin_placing_Line_1,

0x0709,

(TUint16)SkinLayout::EApiId_Fast_application_swapping_skin_placing_Line_1,

(TUint)&wallpaper_pane,

(TUint)&Changes_to_existing_elements__idle_wallpaper__Line_2,

(TUint)&Idle_clock_skin_placing___analogue__Line_1,

(TUint)&Idle_clock_skin_placing___analogue__Line_2,

(TUint)&Idle_clock_skin_placing___analogue__Line_3,

(TUint)&Idle_clock_skin_placing___analogue__Line_4,

(TUint)&Idle_clock_skin_placing___analogue__Line_5,

0x0004,

(TUint16)SkinLayout::EApiId_Idle_clock_skin_placing___analogue__Line_1,

(TUint)&Idle_clock_skin_placing___digital__Line_1,

(TUint)&Idle_clock_skin_placing___digital__Line_2,

(TUint)&Idle_clock_skin_placing___digital__Line_3,

0x0001,

(TUint16)SkinLayout::EApiId_Idle_clock_skin_placing___digital__Line_1,

(TUint)&Power_save_state_skin_placing_Line_1,

(TUint)&Calendar_skin_elements__general__dup_Line_1,

(TUint)&Calendar_skin_elements__general__dup_Line_2,

(TUint)&Calendar_skin_elements__general__dup_Line_3,

(TUint)&Calendar_skin_elements__general__dup_Line_4,

(TUint)&Calendar_skin_elements__general__dup_Line_5,

(TUint)&Calendar_skin_elements__general__dup_Line_6,

(TUint)&Calendar_skin_elements__general__dup_Line_7,

(TUint)&Calendar_skin_elements__general__dup_Line_8,

(TUint)&Calendar_skin_elements__general__dup_Line_9,

0x0008,

(TUint16)SkinLayout::EApiId_Calendar_skin_elements__general__dup_Line_1,

(TUint)&Slice_skin_placing__pinb__Line_1,

(TUint)&Favorites_skin_placing_Line_1,

(TUint)&Favorites_skin_placing_Line_2,

(TUint)&Favorites_skin_placing_Line_3,

(TUint)&Favorites_skin_placing_Line_4,

(TUint)&Favorites_skin_placing_Line_5,

(TUint)&Favorites_skin_placing_Line_6,

(TUint)&Favorites_skin_placing_Line_7,

(TUint)&Favorites_skin_placing_Line_8,

(TUint)&Favorites_skin_placing_Line_9,

(TUint)&Favorites_skin_placing_Line_10,

0x0009,

(TUint16)SkinLayout::EApiId_Favorites_skin_placing_Line_1,

(TUint)&Screen_saver_skin_placing_Line_1,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__Line_1,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_1,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_2,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_3,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_4,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_5,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_6,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_7,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_8,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_9,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_10,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_11,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_12,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_13,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_14,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_15,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_16,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_17,

(TUint)&Colour_palette_preview_screen_element_placing__main_area__dup_Line_18,

0x0011,

(TUint16)SkinLayout::EApiId_Colour_palette_preview_screen_element_placing__main_area__dup_Line_1,

(TUint)&Chinese_FEP_pop_up_window_lines_Line_1,

(TUint)&Chinese_FEP_pop_up_window_lines_Line_2,

(TUint)&Scaling_on_background_images__general__Line_1,

(TUint)&Scaling_on_status_area_background__general__Line_1,

(TUint)&Scaling_on_status_area_background__idle__Line_1,

(TUint)&Scaling_on_navi_pane_background_images_Line_1,

(TUint)&Scaling_on_tab_graphics_Line_1,

(TUint)&Scaling_on_setting_list_volume_skin_elements_Line_1,

(TUint)&Scaling_on_setting_volume_skin_Line_1,

(TUint)&Scaling_on_setting_volume_skin_sizes_Line_1,

(TUint)&Scaling_on_pop_up_windows_skin_placing__dimming__Line_1,

(TUint)&Scaling_on_ending_graphics_for_fast_application_swapping_window_Line_1,

(TUint)&Scaling_on_power_save_state_skin_element_size_Line_1,

(TUint)&Scaling_on_screensaver_skin_size_Line_1,

(TUint)&Notepad_skin_element_placing_Line_1,

(TUint)&Notepad_skin_element_placing_Line_2,

(TUint)&Notepad_skin_element_placing_Line_3,

(TUint)&Notepad_skin_element_placing_Line_4,

(TUint)&Notepad_skin_element_placing_Line_5,

(TUint)&Notepad_skin_element_placing_Line_6,

(TUint)&Notepad_skin_element_placing_Line_7,

(TUint)&Notepad_skin_element_placing_Line_8,

(TUint)&Notepad_skin_element_placing_Line_9,

0x0008,

(TUint16)SkinLayout::EApiId_Notepad_skin_element_placing_Line_1,

(TUint)&Calculator_paper_skin_element_placing_Line_1,

(TUint)&Calculator_paper_skin_element_placing_Line_2,

(TUint)&Calculator_paper_skin_element_placing_Line_3,

(TUint)&Calculator_paper_skin_element_placing_Line_4,

(TUint)&Calculator_paper_skin_element_placing_Line_5,

(TUint)&Calculator_paper_skin_element_placing_Line_6,

(TUint)&Calculator_paper_skin_element_placing_Line_7,

(TUint)&Calculator_paper_skin_element_placing_Line_8,

(TUint)&Calculator_paper_skin_element_placing_Line_9,

0x0008,

(TUint16)SkinLayout::EApiId_Calculator_paper_skin_element_placing_Line_1,

(TUint)&Calculator_glass_element_placing_Line_1,

(TUint)&Calculator_glass_element_placing_Line_2,

(TUint)&Calculator_glass_element_placing_Line_3,

0x0002,

(TUint16)SkinLayout::EApiId_Calculator_glass_element_placing_Line_1,

(TUint)&Scalingon_background_images__general__Line_1,

(TUint)&Scalingon_background_images__general__Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Scalingon_background_images__general__Line_1,

(TUint)&Scaling_on_status_area_background__general__Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Scaling_on_status_area_background__general__Line_1,

(TUint)&Scaling_on_status_area_background__idle__Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Scaling_on_status_area_background__idle__Line_1,

(TUint)&Scalingon_navipane_background_images_Line_1,

(TUint)&Scalingon_navipane_background_images_Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Scalingon_navipane_background_images_Line_1,

(TUint)&Scalingon_tab_graphics_Line_1,

(TUint)&Scalingon_tab_graphics_Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Scalingon_tab_graphics_Line_1,

(TUint)&Scalinon_volume_area_values_Line_1,

(TUint)&Scalinon_volume_area_values_Line_2,

(TUint)&Scalinon_volume_area_values_Line_3,

(TUint)&Scalinon_volume_area_values_Line_4,

(TUint)&Scalinon_volume_area_values_Line_5,

(TUint)&Scalinon_volume_area_values_Line_6,

(TUint)&Scalinon_volume_area_values_Line_7,

(TUint)&Scalinon_volume_area_values_Line_8,

(TUint)&Scalinon_volume_area_values_Line_9,

(TUint)&Scalinon_volume_area_values_Line_10,

(TUint)&Scalinon_volume_area_values_Line_11,

0x000a,

(TUint16)SkinLayout::EApiId_Scalinon_volume_area_values_Line_1,

(TUint)&Scalingon_setting_list_item_skin_elements__value_background__Line_1,

(TUint)&Scalingon_setting_list_item_skin_elements__value_background__Line_2,

(TUint)&Scalingon_setting_list_item_skin_elements__value_background__Line_3,

(TUint)&Scalingon_setting_list_item_skin_elements__value_background__Line_4,

(TUint)&Scalingon_setting_list_item_skin_elements__value_background__Line_5,

(TUint)&Scalingon_setting_list_item_skin_elements__value_background__Line_6,

(TUint)&Scalingon_setting_list_item_skin_elements__value_background__Line_7,

(TUint)&Scalingon_setting_list_item_skin_elements__value_background__Line_8,

(TUint)&Scalingon_setting_list_item_skin_elements__value_background__Line_9,

0x0008,

(TUint16)SkinLayout::EApiId_Scalingon_setting_list_item_skin_elements__value_background__Line_1,

(TUint)&Scalingon_setting_list_volume_skin_elements_Line_1,

(TUint)&Scalingon_setting_list_volume_skin_elements_Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Scalingon_setting_list_volume_skin_elements_Line_1,

(TUint)&Scalingon_setting_list_item_skin_placing_Line_1,

(TUint)&Scalingon_setting_list_item_skin_placing_Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Scalingon_setting_list_item_skin_placing_Line_1,

(TUint)&Scaling_on_list_highlight_skin_placing__general__Line_1,

(TUint)&Scaling_on_list_highlight_skin_placing__general__Line_2,

(TUint)&Scaling_on_list_highlight_skin_placing__general__Line_3,

(TUint)&Scaling_on_list_highlight_skin_placing__general__Line_4,

(TUint)&Scaling_on_list_highlight_skin_placing__general__Line_5,

(TUint)&Scaling_on_list_highlight_skin_placing__general__Line_6,

(TUint)&Scaling_on_list_highlight_skin_placing__general__Line_7,

(TUint)&Scaling_on_list_highlight_skin_placing__general__Line_8,

(TUint)&Scaling_on_list_highlight_skin_placing__general__Line_9,

0x0106,

(TUint16)SkinLayout::EApiId_Scaling_on_list_highlight_skin_placing__general__Line_1,

0x0708,

(TUint16)SkinLayout::EApiId_Scaling_on_list_highlight_skin_placing__general__Line_1,

(TUint)&Scaling_on_list_highlight_skin_placing__settings__Line_1,

(TUint)&Scaling_on_list_highlight_skin_placing__settings__Line_2,

(TUint)&Scaling_on_list_highlight_skin_placing__settings__Line_3,

(TUint)&Scaling_on_list_highlight_skin_placing__settings__Line_4,

(TUint)&Scaling_on_list_highlight_skin_placing__settings__Line_5,

(TUint)&Scaling_on_list_highlight_skin_placing__settings__Line_6,

(TUint)&Scaling_on_list_highlight_skin_placing__settings__Line_7,

(TUint)&Scaling_on_list_highlight_skin_placing__settings__Line_8,

(TUint)&Scaling_on_list_highlight_skin_placing__settings__Line_9,

0x0008,

(TUint16)SkinLayout::EApiId_Scaling_on_list_highlight_skin_placing__settings__Line_1,

(TUint)&Scalingon_edited_settings_item_skin_placing__background_highlight__Line_1,

(TUint)&Scalingon_edited_settings_item_skin_placing__background_highlight__Line_2,

(TUint)&Scalingon_edited_settings_item_skin_placing__background_highlight__Line_3,

(TUint)&Scalingon_edited_settings_item_skin_placing__background_highlight__Line_4,

(TUint)&Scalingon_edited_settings_item_skin_placing__background_highlight__Line_5,

(TUint)&Scalingon_edited_settings_item_skin_placing__background_highlight__Line_6,

(TUint)&Scalingon_edited_settings_item_skin_placing__background_highlight__Line_7,

(TUint)&Scalingon_edited_settings_item_skin_placing__background_highlight__Line_8,

(TUint)&Scalingon_edited_settings_item_skin_placing__background_highlight__Line_9,

0x0008,

(TUint16)SkinLayout::EApiId_Scalingon_edited_settings_item_skin_placing__background_highlight__Line_1,

(TUint)&Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_1,

(TUint)&Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_2,

(TUint)&Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_3,

(TUint)&Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_4,

(TUint)&Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_5,

(TUint)&Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_6,

(TUint)&Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_7,

(TUint)&Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_8,

(TUint)&Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_9,

0x0103,

(TUint16)SkinLayout::EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_1,

0x0506,

(TUint16)SkinLayout::EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_1,

0x0708,

(TUint16)SkinLayout::EApiId_Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_1,

(TUint)&Scalingon_setting_volume_skin_Line_1,

(TUint)&Scalingon_setting_volume_skin_Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Scalingon_setting_volume_skin_Line_1,

(TUint)&Scaling_on_setting_volume_skin_sizes_Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Scaling_on_setting_volume_skin_sizes_Line_1,

(TUint)&Scalingon_pop_up_windows_skin_placing__dimming__Line_1,

(TUint)&Scalingon_pop_up_windows_skin_placing__dimming__Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Scalingon_pop_up_windows_skin_placing__dimming__Line_1,

(TUint)&Scaling_on_pop_up_windows_skin_placing__frame_general__Line_1,

(TUint)&Scaling_on_pop_up_windows_skin_placing__frame_general__Line_2,

(TUint)&Scaling_on_pop_up_windows_skin_placing__frame_general__Line_3,

(TUint)&Scaling_on_pop_up_windows_skin_placing__frame_general__Line_4,

(TUint)&Scaling_on_pop_up_windows_skin_placing__frame_general__Line_5,

(TUint)&Scaling_on_pop_up_windows_skin_placing__frame_general__Line_6,

(TUint)&Scaling_on_pop_up_windows_skin_placing__frame_general__Line_7,

(TUint)&Scaling_on_pop_up_windows_skin_placing__frame_general__Line_8,

(TUint)&Scaling_on_pop_up_windows_skin_placing__frame_general__Line_9,

0x0106,

(TUint16)SkinLayout::EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__Line_1,

0x0708,

(TUint16)SkinLayout::EApiId_Scaling_on_pop_up_windows_skin_placing__frame_general__Line_1,

(TUint)&Scaling_on_ending_graphics_for_fast_application_swappingwindow_Line_1,

(TUint)&Scaling_on_ending_graphics_for_fast_application_swappingwindow_Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Scaling_on_ending_graphics_for_fast_application_swappingwindow_Line_1,

(TUint)&Scaling_on_power_save_state_skin_element_size_Line_2,

0x0001,

(TUint16)SkinLayout::EApiId_Scaling_on_power_save_state_skin_element_size_Line_1,

(TUint)&Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_1,

(TUint)&Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_2,

(TUint)&Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_3,

(TUint)&Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_4,

(TUint)&Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_5,

(TUint)&Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_6,

(TUint)&Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_7,

(TUint)&Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_8,

(TUint)&Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_9,

0x0008,

(TUint16)SkinLayout::EApiId_Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_1,

(TUint)&Scalingon_calendar_skin_element_placing_and_size__month__Line_1,

(TUint)&Scalingon_calendar_skin_element_placing_and_size__month__Line_2,

(TUint)&Scalingon_calendar_skin_element_placing_and_size__month__Line_3,

(TUint)&Scalingon_calendar_skin_element_placing_and_size__month__Line_4,

(TUint)&Scalingon_calendar_skin_element_placing_and_size__month__Line_5,

(TUint)&Scalingon_calendar_skin_element_placing_and_size__month__Line_6,

(TUint)&Scalingon_calendar_skin_element_placing_and_size__month__Line_7,

(TUint)&Scalingon_calendar_skin_element_placing_and_size__month__Line_8,

(TUint)&Scalingon_calendar_skin_element_placing_and_size__month__Line_9,

0x0008,

(TUint16)SkinLayout::EApiId_Scalingon_calendar_skin_element_placing_and_size__month__Line_1,

(TUint)&Scaling_on_favourites_skin_sizes_and_placing_Line_1,

(TUint)&Scaling_on_favourites_skin_sizes_and_placing_Line_2,

(TUint)&Scaling_on_favourites_skin_sizes_and_placing_Line_3,

(TUint)&Scaling_on_favourites_skin_sizes_and_placing_Line_4,

(TUint)&Scaling_on_favourites_skin_sizes_and_placing_Line_5,

(TUint)&Scaling_on_favourites_skin_sizes_and_placing_Line_6,

(TUint)&Scaling_on_favourites_skin_sizes_and_placing_Line_7,

(TUint)&Scaling_on_favourites_skin_sizes_and_placing_Line_8,

(TUint)&Scaling_on_favourites_skin_sizes_and_placing_Line_9,

(TUint)&Scaling_on_favourites_skin_sizes_and_placing_Line_10,

0x0009,

(TUint16)SkinLayout::EApiId_Scaling_on_favourites_skin_sizes_and_placing_Line_1,
};

#define IMPL_OK(x) &x

#define DONE_BUT_DO_NOT_WORK(x) &x

#define NOT_USED(x) &x

//
// Implementation
// - if there is NULL in this table, then the implementation in other CDL instance will be used (the ones generated from LAY files)
//

const SkinLayout::SCdlImpl KCdlImpl = 
	{
	NOT_USED(xInput_field_skin_placing__find_list__Line_n_dummy_implementation), // &xInput_field_skin_placing__find_list__Line_1, //	&WindowLine0f,
	NOT_USED(xInput_field_skin_placing__find_list__Line_n_dummy_implementation), // &xInput_field_skin_placing__find_list__Line_2, //	&WindowLine0f,
	NOT_USED(xInput_field_skin_placing__find_list__Line_n_dummy_implementation), // &xInput_field_skin_placing__find_list__Line_3, //	&WindowLine0f,
	NOT_USED(xInput_field_skin_placing__find_list__Line_n_dummy_implementation), // &xInput_field_skin_placing__find_list__Line_4, //	&WindowLine0f,
	NOT_USED(xInput_field_skin_placing__find_list__Line_n_dummy_implementation), // &xInput_field_skin_placing__find_list__Line_5, //	&WindowLine0f,
	NOT_USED(xInput_field_skin_placing__find_list__Line_n_dummy_implementation), // &xInput_field_skin_placing__find_list__Line_6, //	&WindowLine0f,
	NOT_USED(xInput_field_skin_placing__find_list__Line_n_dummy_implementation), // &xInput_field_skin_placing__find_list__Line_7, //	&WindowLine0f,
	NOT_USED(xInput_field_skin_placing__find_list__Line_n_dummy_implementation), // &xInput_field_skin_placing__find_list__Line_8, //	&WindowLine0f,
	NOT_USED(xInput_field_skin_placing__find_list__Line_n_dummy_implementation), // &xInput_field_skin_placing__find_list__Line_9, //	&WindowLine0f,
	NOT_USED(Limits), 		 // &Input_field_skin_placing__find_list_Limits,
	NOT_USED(WindowTable0f), // &Input_field_skin_placing__find_list,
	IMPL_OK(Screen_background_skin_placing_Line_1), //	&WindowLine0f,
	IMPL_OK(Area_background_skin_placing_Line_1),   //	&WindowLine0f,
	IMPL_OK(Area_background_skin_placing_Line_2),   //	&WindowLine2f,
	IMPL_OK(Area_background_skin_placing_Line_3),   //	&WindowLine0f,
	IMPL_OK(Pane_background_skin_naming_Line_1),    //	&WindowLine0f,
	IMPL_OK(Navi_pane_background_stripe_skin_placing_Line_1), // &WindowLine1f,
	IMPL_OK(Navi_pane_background_stripe_skin_placing_Line_2), // &WindowLine0f,
	IMPL_OK(Volume_level_skin_placing_Line_1), 		//	&WindowLine1f,
	IMPL_OK(Volume_level_skin_placing_Line_2), 		//	&WindowLine1f,
	IMPL_OK(Limits), 								//	&Volume_level_skin_placing_Limits,
	IMPL_OK(WindowTable1f), 						//	&Volume_level_skin_placing,
	NOT_USED(Volume_area_values_Line_1), 			//	&WindowLine1f,
	NOT_USED(Volume_area_values_Line_2), 			//	&WindowLine1f,
	NOT_USED(Volume_area_values_Line_3), 			//	&WindowLine1f,
	NOT_USED(Volume_area_values_Line_4), 			//	&WindowLine1f,
	NOT_USED(Volume_area_values_Line_5), 			//	&WindowLine1f,
	NOT_USED(Volume_area_values_Line_6), 			//	&WindowLine1f,
	NOT_USED(Volume_area_values_Line_7), 			//	&WindowLine1f,
	NOT_USED(Volume_area_values_Line_8), 			//	&WindowLine1f,
	NOT_USED(Volume_area_values_Line_9), 			//	&WindowLine1f,
	NOT_USED(Volume_area_values_Line_10), 			//	&WindowLine1f,
	NOT_USED(Volume_area_values_Line_11), 			//	&WindowLine1f,
	NOT_USED(Limits), 								//  &Volume_area_values_Limits,
	NOT_USED(WindowTable1f),						//  &Volume_area_values
	IMPL_OK(Column_background_and_list_slice_skin_placing_Line_1), //	&WindowLine0f,
	IMPL_OK(Column_background_and_list_slice_skin_placing_Line_2), //	&WindowLine0f,
	IMPL_OK(Column_background_and_list_slice_skin_placing_Line_3), //	&WindowLine0f,
	IMPL_OK(Column_background_and_list_slice_skin_placing_Line_4), //	&WindowLine0f,
	IMPL_OK(Column_background_and_list_slice_skin_placing_Line_5), //	&WindowLine0f,
	IMPL_OK(Column_background_and_list_slice_skin_placing_Line_6), //	&WindowLine0f,
	IMPL_OK(Column_background_and_list_slice_skin_placing_Line_7), //	&WindowLine0f,
	IMPL_OK(Limits),		//  Column_background_and_list_slice_skin_placing_Limits,
	IMPL_OK(WindowTable0f), //  Column_background_and_list_slice_skin_placing,
	IMPL_OK(Setting_list_item_skin_elements__value_background__Line_1),  //	&WindowLine0f,
	IMPL_OK(Setting_list_item_skin_elements__value_background__Line_2),  //	&WindowLine0f,
	NOT_USED(Setting_list_item_skin_elements__value_background__Line_3), //	&WindowLine0f,
	NOT_USED(Setting_list_item_skin_elements__value_background__Line_4), //	&WindowLine0f,
	IMPL_OK(Setting_list_item_skin_elements__value_background__Line_5),  //	&WindowLine0f,
	NOT_USED(Setting_list_item_skin_elements__value_background__Line_6), //	&WindowLine0f,
	NOT_USED(Setting_list_item_skin_elements__value_background__Line_7), //	&WindowLine0f,
	NOT_USED(Setting_list_item_skin_elements__value_background__Line_8), //	&WindowLine0f,
	NOT_USED(Setting_list_item_skin_elements__value_background__Line_9), //	&WindowLine0f,
	IMPL_OK(Limits),        //	&Setting_list_item_skin_elements__value_background__Limits,
	IMPL_OK(WindowTable0f), //	&Setting_list_item_skin_elements__value_background_,
	IMPL_OK(Setting_list_item_skin_placing__volume__Line_1), //	&WindowLine0f,
	IMPL_OK(Setting_list_item_skin_placing__volume__Line_2), //	&WindowLine0f,
	IMPL_OK(Limits), //	&Setting_list_item_skin_placing__volume__Limits,
	IMPL_OK(WindowTable0f), //	&Setting_list_item_skin_placing__volume_,
	NOT_USED(Settings_volume_area_values_Line_1), 	//	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_Line_2), 	//	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_Line_3), 	//	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_Line_4), 	//	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_Line_5), 	//	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_Line_6), 	//	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_Line_7), 	//	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_Line_8), 	//	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_Line_9), 	//	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_Line_10), 	//	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_Line_11), 	//	&WindowLine0f,
	NOT_USED(Limits),         //	&Settings_volume_area_values_Limits,
	NOT_USED(WindowTable0f),  //	&Settings_volume_area_values,
	IMPL_OK(List_highlight_skin_placing__general__Line_1),  //	&WindowLine0t,
	IMPL_OK(List_highlight_skin_placing__general__Line_2),  //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__general__Line_3), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__general__Line_4), //	&WindowLine0f,
	IMPL_OK(List_highlight_skin_placing__general__Line_5),  //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__general__Line_6), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__general__Line_7), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__general__Line_8), //	&WindowLine0t,
	NOT_USED(List_highlight_skin_placing__general__Line_9), //	&WindowLine0t,
	IMPL_OK(Limits), 		//	&List_highlight_skin_placing__general__SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f), //	&List_highlight_skin_placing__general__SUB_TABLE_0,
	IMPL_OK(Limits), 		//	&List_highlight_skin_placing__general__SUB_TABLE_1_Limits,
	IMPL_OK(WindowTable0t), //  &List_highlight_skin_placing__general__SUB_TABLE_1,
	IMPL_OK(List_highlight_skin_placing__settings__Line_1),  //	&WindowLine0f,
	IMPL_OK(List_highlight_skin_placing__settings__Line_2),  //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__settings__Line_3), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__settings__Line_4), //	&WindowLine0f,
	IMPL_OK(List_highlight_skin_placing__settings__Line_5),  //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__settings__Line_6), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__settings__Line_7), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__settings__Line_8), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__settings__Line_9), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &List_highlight_skin_placing__settings__Limits,
	IMPL_OK(WindowTable0f), //  &List_highlight_skin_placing__settings_,
	IMPL_OK(List_highlight_skin_placing__apps_specific__Line_1),  //	&WindowLine0t,
	IMPL_OK(List_highlight_skin_placing__apps_specific__Line_2),  //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__apps_specific__Line_3), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__apps_specific__Line_4), //	&WindowLine0f,
	IMPL_OK(List_highlight_skin_placing__apps_specific__Line_5),  //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__apps_specific__Line_6), //	&WindowLine0t,
	NOT_USED(List_highlight_skin_placing__apps_specific__Line_7), //	&WindowLine0t,
	NOT_USED(List_highlight_skin_placing__apps_specific__Line_8), //	&WindowLine0t,
	NOT_USED(List_highlight_skin_placing__apps_specific__Line_9), //	&WindowLine0t,
	IMPL_OK(Limits), 		//  &List_highlight_skin_placing__apps_specific__SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f), //  &List_highlight_skin_placing__apps_specific__SUB_TABLE_0,
	IMPL_OK(Limits), 		//  &List_highlight_skin_placing__apps_specific__SUB_TABLE_1_Limits,
	IMPL_OK(WindowTable0t), //  &List_highlight_skin_placing__apps_specific__SUB_TABLE_1,
	NOT_USED(List_highlight_skin_placing__popup_specific__Line_1), //	&WindowLine0t,
	NOT_USED(List_highlight_skin_placing__popup_specific__Line_2), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__popup_specific__Line_3), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__popup_specific__Line_4), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__popup_specific__Line_5), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__popup_specific__Line_6), //	&WindowLine0t,
	NOT_USED(List_highlight_skin_placing__popup_specific__Line_7), //	&WindowLine0t,
	NOT_USED(List_highlight_skin_placing__popup_specific__Line_8), //	&WindowLine0t,
	NOT_USED(List_highlight_skin_placing__popup_specific__Line_9), //	&WindowLine0t,
	IMPL_OK(Limits), 		//  &List_highlight_skin_placing__popup_specific__SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f), //  &List_highlight_skin_placing__popup_specific__SUB_TABLE_0,
	IMPL_OK(Limits), 		//  &List_highlight_skin_placing__popup_specific__SUB_TABLE_1_Limits,
	IMPL_OK(WindowTable0t), //  &List_highlight_skin_placing__popup_specific__SUB_TABLE_1,
	NOT_USED(List_highlight_skin_placing__popup_windows__Line_1), //	&WindowLine0t,
	IMPL_OK(List_highlight_skin_placing__popup_windows__Line_2), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__popup_windows__Line_3), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__popup_windows__Line_4), //	&WindowLine0f,
	IMPL_OK(List_highlight_skin_placing__popup_windows__Line_5), //	&WindowLine0f,
	NOT_USED(List_highlight_skin_placing__popup_windows__Line_6), //	&WindowLine0t,
	NOT_USED(List_highlight_skin_placing__popup_windows__Line_7), //	&WindowLine0t,
	NOT_USED(List_highlight_skin_placing__popup_windows__Line_8), //	&WindowLine0t,
	NOT_USED(List_highlight_skin_placing__popup_windows__Line_9), //	&WindowLine0t,
	IMPL_OK(Limits), 		//  &List_highlight_skin_placing__popup_windows__SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f), //  &List_highlight_skin_placing__popup_windows__SUB_TABLE_0,
	IMPL_OK(Limits), 		//  &List_highlight_skin_placing__popup_windows__SUB_TABLE_1_Limits,
	IMPL_OK(WindowTable0t), //  &List_highlight_skin_placing__popup_windows__SUB_TABLE_1,
	IMPL_OK(Highlight_skin_placing__grid__Line_1),  //	&WindowLine0t,
	IMPL_OK(Highlight_skin_placing__grid__Line_2),  //	&WindowLine0f,
	NOT_USED(Highlight_skin_placing__grid__Line_3), //	&WindowLine0f,
	NOT_USED(Highlight_skin_placing__grid__Line_4), //	&WindowLine0f,
	IMPL_OK(Highlight_skin_placing__grid__Line_5),  //	&WindowLine0f,
	NOT_USED(Highlight_skin_placing__grid__Line_6), //	&WindowLine0t,
	NOT_USED(Highlight_skin_placing__grid__Line_7), //	&WindowLine0t,
	NOT_USED(Highlight_skin_placing__grid__Line_8), //	&WindowLine0t,
	NOT_USED(Highlight_skin_placing__grid__Line_9), //	&WindowLine0t,
	IMPL_OK(Limits), 		//  &Highlight_skin_placing__grid__SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f), //  &Highlight_skin_placing__grid__SUB_TABLE_0,
	IMPL_OK(Limits), 		//  &Highlight_skin_placing__grid__SUB_TABLE_1_Limits,
	IMPL_OK(WindowTable0t), //  &Highlight_skin_placing__grid__SUB_TABLE_1,
	NOT_USED(Highlight_skin_placing__form_popup_field__Line_1), //	&WindowLine0t,
	IMPL_OK(Highlight_skin_placing__form_popup_field__Line_2),  //	&WindowLine0f,
	NOT_USED(Highlight_skin_placing__form_popup_field__Line_3), //	&WindowLine0f,
	NOT_USED(Highlight_skin_placing__form_popup_field__Line_4), //	&WindowLine0f,
	NOT_USED(Highlight_skin_placing__form_popup_field__Line_5), //	&WindowLine0f,
	NOT_USED(Highlight_skin_placing__form_popup_field__Line_6), //	&WindowLine0t,
	NOT_USED(Highlight_skin_placing__form_popup_field__Line_7), //	&WindowLine0t,
	NOT_USED(Highlight_skin_placing__form_popup_field__Line_8), //	&WindowLine0t,
	NOT_USED(Highlight_skin_placing__form_popup_field__Line_9), //	&WindowLine0t,
	IMPL_OK(Limits), 		//  &Highlight_skin_placing__form_popup_field__SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f), //  &Highlight_skin_placing__form_popup_field__SUB_TABLE_0,
	IMPL_OK(Limits), 		//  &Highlight_skin_placing__form_popup_field__SUB_TABLE_1_Limits,
	IMPL_OK(WindowTable0t), //  &Highlight_skin_placing__form_popup_field__SUB_TABLE_1,
	NOT_USED(xFind_pop_up_window_elements_Line_1), //	&WindowLine0f,
	NOT_USED(xFind_pop_up_window_elements_Line_2), //	&WindowLine0f,
	NOT_USED(xFind_pop_up_window_elements_Line_3), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &xFind_pop_up_window_elements_Limits,
	IMPL_OK(WindowTable0f), //  &xFind_pop_up_window_elements,
	NOT_USED(Input_field_skin_placing__general__Line_1), //	&WindowLine0f,
	IMPL_OK(Input_field_skin_placing__general__Line_2),  //	&WindowLine0f,
	IMPL_OK(Input_field_skin_placing__general__Line_3),  //	&WindowLine0f,
	IMPL_OK(Input_field_skin_placing__general__Line_4),  //	&WindowLine0f,
	IMPL_OK(Input_field_skin_placing__general__Line_5),  //	&WindowLine0f,
	IMPL_OK(Input_field_skin_placing__general__Line_6),  //	&WindowLine0f,
	IMPL_OK(Input_field_skin_placing__general__Line_7),  //	&WindowLine0f,
	NOT_USED(Input_field_skin_placing__general__Line_8), //	&WindowLine0f,
	NOT_USED(Input_field_skin_placing__general__Line_9), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Input_field_skin_placing__general__Limits,
	IMPL_OK(WindowTable0f), //  &Input_field_skin_placing__general_,
	NOT_USED(Edited_settings_item_skin_placing__background_highlight__Line_1), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__background_highlight__Line_2), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__background_highlight__Line_3), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__background_highlight__Line_4), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__background_highlight__Line_5), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__background_highlight__Line_6), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__background_highlight__Line_7), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__background_highlight__Line_8), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__background_highlight__Line_9), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Edited_settings_item_skin_placing__background_highlight__Limits,
	IMPL_OK(WindowTable0f), //  &Edited_settings_item_skin_placing__background_highlight_,
	NOT_USED(Edited_settings_item_skin_placing__value_background__Line_1), //	&WindowLine0t,
	NOT_USED(Edited_settings_item_skin_placing__value_background__Line_2), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__value_background__Line_3), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__value_background__Line_4), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__value_background__Line_5), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__value_background__Line_6), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__value_background__Line_7), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__value_background__Line_8), //	&WindowLine0t,
	NOT_USED(Edited_settings_item_skin_placing__value_background__Line_9), //	&WindowLine0t,
	IMPL_OK(Limits), 		//  &Edited_settings_item_skin_placing__value_background__SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f), //  &Edited_settings_item_skin_placing__value_background__SUB_TABLE_0,
	IMPL_OK(Limits), 		//  &Edited_settings_item_skin_placing__value_background__SUB_TABLE_1_Limits,
	IMPL_OK(WindowTable0t), //  &Edited_settings_item_skin_placing__value_background__SUB_TABLE_1,
	NOT_USED(Edited_settings_item_skin_placing__input__Line_1), //	&WindowLine0t,
	NOT_USED(Edited_settings_item_skin_placing__input__Line_2), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__input__Line_3), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__input__Line_4), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__input__Line_5), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__input__Line_6), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__input__Line_7), //	&WindowLine0f,
	NOT_USED(Edited_settings_item_skin_placing__input__Line_8), //	&WindowLine0t,
	NOT_USED(Edited_settings_item_skin_placing__input__Line_9), //	&WindowLine0t,
	IMPL_OK(Limits), 		//  &Edited_settings_item_skin_placing__input__SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f), //  &Edited_settings_item_skin_placing__input__SUB_TABLE_0,
	IMPL_OK(Limits), 		//  &Edited_settings_item_skin_placing__input__SUB_TABLE_1_Limits,
	IMPL_OK(WindowTable0t), //  &Edited_settings_item_skin_placing__input__SUB_TABLE_1,
	NOT_USED(Setting_volume_skin_placing_Line_1), //	&WindowLine0f,
	NOT_USED(Setting_volume_skin_placing_Line_2), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Setting_volume_skin_placing_Limits,
	IMPL_OK(WindowTable0f), //  &Setting_volume_skin_placing,
	NOT_USED(Settings_volume_area_values_dup_Line_1), //	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_dup_Line_2), //	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_dup_Line_3), //	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_dup_Line_4), //	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_dup_Line_5), //	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_dup_Line_6), //	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_dup_Line_7), //	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_dup_Line_8), //	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_dup_Line_9), //	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_dup_Line_10), //	&WindowLine0f,
	NOT_USED(Settings_volume_area_values_dup_Line_11), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Settings_volume_area_values_dup_Limits,
	IMPL_OK(WindowTable0f), //  &Settings_volume_area_values_dup,
	NOT_USED(Popup_windows_skin_placing__dimming__Line_1), 		   //	&WindowLine0f,
	IMPL_OK(Popup_windows_skin_placing__background_slice__Line_1), //	&WindowLine0t,
	IMPL_OK(Popup_windows_skin_placing__background_slice__Line_2), //	&WindowLine0f,
	IMPL_OK(Popup_windows_skin_placing__frame_general__Line_1), //	&WindowLine0t,
	IMPL_OK(Popup_windows_skin_placing__frame_general__Line_2), //	&WindowLine0f,
	IMPL_OK(Popup_windows_skin_placing__frame_general__Line_3), //	&WindowLine0f,
	IMPL_OK(Popup_windows_skin_placing__frame_general__Line_4), //	&WindowLine0f,
	IMPL_OK(Popup_windows_skin_placing__frame_general__Line_5), //	&WindowLine0f,
	IMPL_OK(Popup_windows_skin_placing__frame_general__Line_6), //	&WindowLine0f,
	IMPL_OK(Popup_windows_skin_placing__frame_general__Line_7), //	&WindowLine0f,
	IMPL_OK(Popup_windows_skin_placing__frame_general__Line_8), //	&WindowLine0t,
	IMPL_OK(Popup_windows_skin_placing__frame_general__Line_9), //	&WindowLine0t,
	IMPL_OK(Limits), 		//  &Popup_windows_skin_placing__frame_general__SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f), //  &Popup_windows_skin_placing__frame_general__SUB_TABLE_0,
	IMPL_OK(Limits), 		//  &Popup_windows_skin_placing__frame_general__SUB_TABLE_1_Limits,
	IMPL_OK(WindowTable0t), //  &Popup_windows_skin_placing__frame_general__SUB_TABLE_1,
	NOT_USED(Submenu_skin_placing_Line_1), //	&WindowLine0t,
	IMPL_OK(Submenu_skin_placing_Line_2),  //	&WindowLine0f,
	NOT_USED(Submenu_skin_placing_Line_3), //	&WindowLine0f,
	NOT_USED(Submenu_skin_placing_Line_4), //	&WindowLine0f,
	IMPL_OK(Submenu_skin_placing_Line_5),  //	&WindowLine0f,
	NOT_USED(Submenu_skin_placing_Line_6), //	&WindowLine0t,
	NOT_USED(Submenu_skin_placing_Line_7), //	&WindowLine0t,
	NOT_USED(Submenu_skin_placing_Line_8), //	&WindowLine0t,
	NOT_USED(Submenu_skin_placing_Line_9), //	&WindowLine0t,
	IMPL_OK(Limits), 		//  &Submenu_skin_placing_SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f), //  &Submenu_skin_placing_SUB_TABLE_0,
	IMPL_OK(Limits), 		//  &Submenu_skin_placing_SUB_TABLE_1_Limits,
	IMPL_OK(WindowTable0t), //  &Submenu_skin_placing_SUB_TABLE_1,
	IMPL_OK(Slice_skin_placing__fastapps__Line_1), //	&WindowLine0f,
	NOT_USED(Fast_application_swapping_skin_placing_Line_1), //	&WindowLine0t,
	NOT_USED(Fast_application_swapping_skin_placing_Line_2), //	&WindowLine0f,
	NOT_USED(Fast_application_swapping_skin_placing_Line_3), //	&WindowLine0f,
	NOT_USED(Fast_application_swapping_skin_placing_Line_4), //	&WindowLine0f,
	NOT_USED(Fast_application_swapping_skin_placing_Line_5), //	&WindowLine0f,
	NOT_USED(Fast_application_swapping_skin_placing_Line_6), //	&WindowLine0f,
	NOT_USED(Fast_application_swapping_skin_placing_Line_7), //	&WindowLine0f,
	NOT_USED(Fast_application_swapping_skin_placing_Line_8), //	&WindowLine0t,
	NOT_USED(Fast_application_swapping_skin_placing_Line_9), //	&WindowLine0t,
	NOT_USED(Fast_application_swapping_skin_placing_Line_10), //	&WindowLine0t,
	IMPL_OK(Limits), 		 //  &Fast_application_swapping_skin_placing_SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f),  //  &Fast_application_swapping_skin_placing_SUB_TABLE_0,
	IMPL_OK(Limits), 		 //  &Fast_application_swapping_skin_placing_SUB_TABLE_1_Limits,
	IMPL_OK(WindowTable0t),  //  &Fast_application_swapping_skin_placing_SUB_TABLE_1,
	IMPL_OK(wallpaper_pane), //	 &WindowLine0f,
	NOT_USED(Changes_to_existing_elements__idle_wallpaper__Line_2), //	&WindowLine2t,
	NOT_USED(Idle_clock_skin_placing___analogue__Line_1), //	&WindowLine0f,
	NOT_USED(Idle_clock_skin_placing___analogue__Line_2), //	&WindowLine0f,
	NOT_USED(Idle_clock_skin_placing___analogue__Line_3), //	&WindowLine0f,
	NOT_USED(Idle_clock_skin_placing___analogue__Line_4), //	&WindowLine0f,
	NOT_USED(Idle_clock_skin_placing___analogue__Line_5), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Idle_clock_skin_placing___analogue__Limits,
	IMPL_OK(WindowTable0f), //  &Idle_clock_skin_placing___analogue_,
	IMPL_OK(Idle_clock_skin_placing___digital__Line_1), //	&WindowLine1f,
	NOT_USED(Idle_clock_skin_placing___digital__Line_2), //	&WindowLine1f,
	IMPL_OK(Idle_clock_skin_placing___digital__Line_3), //	&WindowLine0t,
	IMPL_OK(Limits), 		//  &Idle_clock_skin_placing___digital__SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable1f), //  &Idle_clock_skin_placing___digital__SUB_TABLE_0,
	NOT_USED(Power_save_state_skin_placing_Line_1), //	&WindowLine0f,
	NOT_USED(Calendar_skin_elements__general__dup_Line_1), //	&WindowLine0f,
	NOT_USED(Calendar_skin_elements__general__dup_Line_2), //	&WindowLine0f,
	NOT_USED(Calendar_skin_elements__general__dup_Line_3), //	&WindowLine0f,
	NOT_USED(Calendar_skin_elements__general__dup_Line_4), //	&WindowLine0f,
	NOT_USED(Calendar_skin_elements__general__dup_Line_5), //	&WindowLine0f,
	NOT_USED(Calendar_skin_elements__general__dup_Line_6), //	&WindowLine0f,
	NOT_USED(Calendar_skin_elements__general__dup_Line_7), //	&WindowLine0f,
	NOT_USED(Calendar_skin_elements__general__dup_Line_8), //	&WindowLine0f,
	NOT_USED(Calendar_skin_elements__general__dup_Line_9), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Calendar_skin_elements__general__dup_Limits,
	IMPL_OK(WindowTable0f), //  &Calendar_skin_elements__general__dup,
	NOT_USED(Slice_skin_placing__pinb__Line_1), //	&WindowLine0f,
	NOT_USED(Favorites_skin_placing_Line_1),    //	&WindowLine0f,
	NOT_USED(Favorites_skin_placing_Line_2),  	//	&WindowLine0f,
	NOT_USED(Favorites_skin_placing_Line_3),  	//	&WindowLine0f,
	NOT_USED(Favorites_skin_placing_Line_4),  	//	&WindowLine0f,
	NOT_USED(Favorites_skin_placing_Line_5),  	//	&WindowLine0f,
	NOT_USED(Favorites_skin_placing_Line_6),  	//	&WindowLine0f,
	NOT_USED(Favorites_skin_placing_Line_7),  	//	&WindowLine0f,
	NOT_USED(Favorites_skin_placing_Line_8),  	//	&WindowLine0f,
	NOT_USED(Favorites_skin_placing_Line_9),  	//	&WindowLine0f,
	NOT_USED(Favorites_skin_placing_Line_10), 	//	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Favorites_skin_placing_Limits,
	IMPL_OK(WindowTable0f), //  &Favorites_skin_placing,
	NOT_USED(Screen_saver_skin_placing_Line_1), //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__Line_1), 	    //	&WindowLine2f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_1),  //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_2),  //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_3),  //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_4),  //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_5),  //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_6),  //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_7),  //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_8),  //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_9),  //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_10), //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_11), //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_12), //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_13), //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_14), //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_15), //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_16), //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_17), //	&WindowLine0f,
	NOT_USED(Colour_palette_preview_screen_element_placing__main_area__dup_Line_18), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Colour_palette_preview_screen_element_placing__main_area__dup_Limits,
	IMPL_OK(WindowTable0f), //  &Colour_palette_preview_screen_element_placing__main_area__dup,
	NOT_USED(Chinese_FEP_pop_up_window_lines_Line_1), //	&WindowLine1f,
	NOT_USED(Chinese_FEP_pop_up_window_lines_Line_2), //	&WindowLine0f,
	NOT_USED(Scaling_on_background_images__general__Line_1), //	&WindowLine0f,
	NOT_USED(Scaling_on_status_area_background__general__Line_1), //	&WindowLine1f,
	NOT_USED(Scaling_on_status_area_background__idle__Line_1), //	&WindowLine1f,
	NOT_USED(Scaling_on_navi_pane_background_images_Line_1), //	&WindowLine0f,
	NOT_USED(Scaling_on_tab_graphics_Line_1), //	&WindowLine0f,
	NOT_USED(Scaling_on_setting_list_volume_skin_elements_Line_1), //	&WindowLine1f,
	NOT_USED(Scaling_on_setting_volume_skin_Line_1), //	&WindowLine1f,
	NOT_USED(Scaling_on_setting_volume_skin_sizes_Line_1), //	&WindowLine0f,
	NOT_USED(Scaling_on_pop_up_windows_skin_placing__dimming__Line_1), //	&WindowLine0f,
	NOT_USED(Scaling_on_ending_graphics_for_fast_application_swapping_window_Line_1), //	&WindowLine0f,
	NOT_USED(Scaling_on_power_save_state_skin_element_size_Line_1), //	&WindowLine0f,
	NOT_USED(Scaling_on_screensaver_skin_size_Line_1), //	&WindowLine0f,
	IMPL_OK(Notepad_skin_element_placing_Line_1), //	&WindowLine0f,
	IMPL_OK(Notepad_skin_element_placing_Line_2), //	&WindowLine0f,
	IMPL_OK(Notepad_skin_element_placing_Line_3), //	&WindowLine0f,
	NOT_USED(Notepad_skin_element_placing_Line_4), //	&WindowLine0f,
	IMPL_OK(Notepad_skin_element_placing_Line_5), //	&WindowLine0f,
	IMPL_OK(Notepad_skin_element_placing_Line_6), //	&WindowLine0f,
	NOT_USED(Notepad_skin_element_placing_Line_7), //	&WindowLine0f,
	NOT_USED(Notepad_skin_element_placing_Line_8), //	&WindowLine0f,
	NOT_USED(Notepad_skin_element_placing_Line_9), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Notepad_skin_element_placing_Limits,
	IMPL_OK(WindowTable0f), //  &Notepad_skin_element_placing,
	NOT_USED(Calculator_paper_skin_element_placing_Line_1), //	&WindowLine0f,
	NOT_USED(Calculator_paper_skin_element_placing_Line_2), //	&WindowLine0f,
	NOT_USED(Calculator_paper_skin_element_placing_Line_3), //	&WindowLine0f,
	NOT_USED(Calculator_paper_skin_element_placing_Line_4), //	&WindowLine0f,
	NOT_USED(Calculator_paper_skin_element_placing_Line_5), //	&WindowLine0f,
	NOT_USED(Calculator_paper_skin_element_placing_Line_6), //	&WindowLine0f,
	NOT_USED(Calculator_paper_skin_element_placing_Line_7), //	&WindowLine0f,
	NOT_USED(Calculator_paper_skin_element_placing_Line_8), //	&WindowLine0f,
	NOT_USED(Calculator_paper_skin_element_placing_Line_9), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Calculator_paper_skin_element_placing_Limits,
	IMPL_OK(WindowTable0f), //  &Calculator_paper_skin_element_placing,
	NOT_USED(Calculator_glass_element_placing_Line_1), //	&WindowLine0f,
	NOT_USED(Calculator_glass_element_placing_Line_2), //	&WindowLine0f,
	NOT_USED(Calculator_glass_element_placing_Line_3), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Calculator_glass_element_placing_Limits,
	IMPL_OK(WindowTable0f), //  &Calculator_glass_element_placing,
	NOT_USED(Scalingon_background_images__general__Line_1), //	&WindowLine0f,
	NOT_USED(Scalingon_background_images__general__Line_2), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Scalingon_background_images__general__Limits,
	IMPL_OK(WindowTable0f), //  &Scalingon_background_images__general_,
	NOT_USED(Scaling_on_status_area_background__general__Line_2), //	&WindowLine1f,
	IMPL_OK(Limits), 		//  &Scaling_on_status_area_background__general__Limits,
	IMPL_OK(WindowTable1f), //  &Scaling_on_status_area_background__general_,
	NOT_USED(Scaling_on_status_area_background__idle__Line_2), //	&WindowLine1f,
	IMPL_OK(Limits), 		//  &Scaling_on_status_area_background__idle__Limits,
	IMPL_OK(WindowTable1f), //  &Scaling_on_status_area_background__idle_,
	NOT_USED(Scalingon_navipane_background_images_Line_1), //	&WindowLine0f,
	NOT_USED(Scalingon_navipane_background_images_Line_2), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Scalingon_navipane_background_images_Limits,
	IMPL_OK(WindowTable0f), //  &Scalingon_navipane_background_images,
	NOT_USED(Scalingon_tab_graphics_Line_1), //	&WindowLine0f,
	NOT_USED(Scalingon_tab_graphics_Line_2), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Scalingon_tab_graphics_Limits,
	IMPL_OK(WindowTable0f), //  &Scalingon_tab_graphics,
	NOT_USED(Scalinon_volume_area_values_Line_1),  //	&WindowLine1f,
	NOT_USED(Scalinon_volume_area_values_Line_2),  //	&WindowLine1f,
	NOT_USED(Scalinon_volume_area_values_Line_3),  //	&WindowLine1f,
	NOT_USED(Scalinon_volume_area_values_Line_4),  //	&WindowLine1f,
	NOT_USED(Scalinon_volume_area_values_Line_5),  //	&WindowLine1f,
	NOT_USED(Scalinon_volume_area_values_Line_6),  //	&WindowLine1f,
	NOT_USED(Scalinon_volume_area_values_Line_7),  //	&WindowLine1f,
	NOT_USED(Scalinon_volume_area_values_Line_8),  //	&WindowLine1f,
	NOT_USED(Scalinon_volume_area_values_Line_9),  //	&WindowLine1f,
	NOT_USED(Scalinon_volume_area_values_Line_10), //	&WindowLine1f,
	NOT_USED(Scalinon_volume_area_values_Line_11), //	&WindowLine1f,
	IMPL_OK(Limits), 		//  &Scalinon_volume_area_values_Limits,
	IMPL_OK(WindowTable1f), //  &Scalinon_volume_area_values,
	NOT_USED(Scalingon_setting_list_item_skin_elements__value_background__Line_1), //	&WindowLine0f,
	NOT_USED(Scalingon_setting_list_item_skin_elements__value_background__Line_2), //	&WindowLine0f,
	NOT_USED(Scalingon_setting_list_item_skin_elements__value_background__Line_3), //	&WindowLine0f,
	NOT_USED(Scalingon_setting_list_item_skin_elements__value_background__Line_4), //	&WindowLine0f,
	NOT_USED(Scalingon_setting_list_item_skin_elements__value_background__Line_5), //	&WindowLine0f,
	NOT_USED(Scalingon_setting_list_item_skin_elements__value_background__Line_6), //	&WindowLine0f,
	NOT_USED(Scalingon_setting_list_item_skin_elements__value_background__Line_7), //	&WindowLine0f,
	NOT_USED(Scalingon_setting_list_item_skin_elements__value_background__Line_8), //	&WindowLine0f,
	NOT_USED(Scalingon_setting_list_item_skin_elements__value_background__Line_9), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Scalingon_setting_list_item_skin_elements__value_background__Limits,
	IMPL_OK(WindowTable0f), //  &Scalingon_setting_list_item_skin_elements__value_background_,
	NOT_USED(Scalingon_setting_list_volume_skin_elements_Line_1), //	&WindowLine1f,
	NOT_USED(Scalingon_setting_list_volume_skin_elements_Line_2), //	&WindowLine1f,
	IMPL_OK(Limits), 		//  &Scalingon_setting_list_volume_skin_elements_Limits,
	IMPL_OK(WindowTable1f), //  &Scalingon_setting_list_volume_skin_elements,
	NOT_USED(Scalingon_setting_list_item_skin_placing_Line_1), //	&WindowLine0f,
	NOT_USED(Scalingon_setting_list_item_skin_placing_Line_2), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Scalingon_setting_list_item_skin_placing_Limits,
	IMPL_OK(WindowTable0f), //  &Scalingon_setting_list_item_skin_placing,
	NOT_USED(Scaling_on_list_highlight_skin_placing__general__Line_1), //	&WindowLine0t,
	NOT_USED(Scaling_on_list_highlight_skin_placing__general__Line_2), //	&WindowLine0f,
	NOT_USED(Scaling_on_list_highlight_skin_placing__general__Line_3), //	&WindowLine0f,
	NOT_USED(Scaling_on_list_highlight_skin_placing__general__Line_4), //	&WindowLine0f,
	NOT_USED(Scaling_on_list_highlight_skin_placing__general__Line_5), //	&WindowLine0f,
	NOT_USED(Scaling_on_list_highlight_skin_placing__general__Line_6), //	&WindowLine0f,
	NOT_USED(Scaling_on_list_highlight_skin_placing__general__Line_7), //	&WindowLine0f,
	NOT_USED(Scaling_on_list_highlight_skin_placing__general__Line_8), //	&WindowLine0t,
	NOT_USED(Scaling_on_list_highlight_skin_placing__general__Line_9), //	&WindowLine0t,
	IMPL_OK(Limits), 		//  &Scaling_on_list_highlight_skin_placing__general__SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f), //  &Scaling_on_list_highlight_skin_placing__general__SUB_TABLE_0,
	IMPL_OK(Limits), 		//  &Scaling_on_list_highlight_skin_placing__general__SUB_TABLE_1_Limits,
	IMPL_OK(WindowTable0t), //  &Scaling_on_list_highlight_skin_placing__general__SUB_TABLE_1,
	NOT_USED(Scaling_on_list_highlight_skin_placing__settings__Line_1), //	&WindowLine0f,
	NOT_USED(Scaling_on_list_highlight_skin_placing__settings__Line_2), //	&WindowLine0f,
	NOT_USED(Scaling_on_list_highlight_skin_placing__settings__Line_3), //	&WindowLine0f,
	NOT_USED(Scaling_on_list_highlight_skin_placing__settings__Line_4), //	&WindowLine0f,
	NOT_USED(Scaling_on_list_highlight_skin_placing__settings__Line_5), //	&WindowLine0f,
	NOT_USED(Scaling_on_list_highlight_skin_placing__settings__Line_6), //	&WindowLine0f,
	NOT_USED(Scaling_on_list_highlight_skin_placing__settings__Line_7), //	&WindowLine0f,
	NOT_USED(Scaling_on_list_highlight_skin_placing__settings__Line_8), //	&WindowLine0f,
	NOT_USED(Scaling_on_list_highlight_skin_placing__settings__Line_9), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Scaling_on_list_highlight_skin_placing__settings__Limits,
	IMPL_OK(WindowTable0f), //  &Scaling_on_list_highlight_skin_placing__settings_,
	NOT_USED(Scalingon_edited_settings_item_skin_placing__background_highlight__Line_1), //	&WindowLine0f,
	NOT_USED(Scalingon_edited_settings_item_skin_placing__background_highlight__Line_2), //	&WindowLine0f,
	NOT_USED(Scalingon_edited_settings_item_skin_placing__background_highlight__Line_3), //	&WindowLine0f,
	NOT_USED(Scalingon_edited_settings_item_skin_placing__background_highlight__Line_4), //	&WindowLine0f,
	NOT_USED(Scalingon_edited_settings_item_skin_placing__background_highlight__Line_5), //	&WindowLine0f,
	NOT_USED(Scalingon_edited_settings_item_skin_placing__background_highlight__Line_6), //	&WindowLine0f,
	NOT_USED(Scalingon_edited_settings_item_skin_placing__background_highlight__Line_7), //	&WindowLine0f,
	NOT_USED(Scalingon_edited_settings_item_skin_placing__background_highlight__Line_8), //	&WindowLine0f,
	NOT_USED(Scalingon_edited_settings_item_skin_placing__background_highlight__Line_9), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Scalingon_edited_settings_item_skin_placing__background_highlight__Limits,
	IMPL_OK(WindowTable0f), //  &Scalingon_edited_settings_item_skin_placing__background_highlight_,
	NOT_USED(Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_1), //	&WindowLine0t,
	NOT_USED(Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_2), //	&WindowLine0f,
	NOT_USED(Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_3), //	&WindowLine0f,
	NOT_USED(Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_4), //	&WindowLine0f,
	NOT_USED(Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_5), //	&WindowLine1f,
	NOT_USED(Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_6), //	&WindowLine0f,
	NOT_USED(Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_7), //	&WindowLine0f,
	NOT_USED(Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_8), //	&WindowLine0t,
	NOT_USED(Scaling_on_edited_settings_item_skin_placing__valuebackground__Line_9), //	&WindowLine0t,
	IMPL_OK(Limits), 		//  &Scaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f), //  &Scaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_0,
	IMPL_OK(Limits), 		//  &Scaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_1_Limits,
	IMPL_OK(WindowTable0f), //  &Scaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_1,
	IMPL_OK(Limits), 		//  &Scaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_2_Limits,
	IMPL_OK(WindowTable0t), //  &Scaling_on_edited_settings_item_skin_placing__valuebackground__SUB_TABLE_2,
	NOT_USED(Scalingon_setting_volume_skin_Line_1), //	&WindowLine1f,
	NOT_USED(Scalingon_setting_volume_skin_Line_2), //	&WindowLine1f,
	IMPL_OK(Limits), 		//  &Scalingon_setting_volume_skin_Limits,
	IMPL_OK(WindowTable1f), //  &Scalingon_setting_volume_skin,
	NOT_USED(Scaling_on_setting_volume_skin_sizes_Line_2), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Scaling_on_setting_volume_skin_sizes_Limits,
	IMPL_OK(WindowTable0f), //  &Scaling_on_setting_volume_skin_sizes,
	NOT_USED(Scalingon_pop_up_windows_skin_placing__dimming__Line_1), //	&WindowLine0f,
	NOT_USED(Scalingon_pop_up_windows_skin_placing__dimming__Line_2), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Scalingon_pop_up_windows_skin_placing__dimming__Limits,
	IMPL_OK(WindowTable0f), //  &Scalingon_pop_up_windows_skin_placing__dimming_,
	NOT_USED(Scaling_on_pop_up_windows_skin_placing__frame_general__Line_1), //	&WindowLine0t,
	NOT_USED(Scaling_on_pop_up_windows_skin_placing__frame_general__Line_2), //	&WindowLine0f,
	NOT_USED(Scaling_on_pop_up_windows_skin_placing__frame_general__Line_3), //	&WindowLine0f,
	NOT_USED(Scaling_on_pop_up_windows_skin_placing__frame_general__Line_4), //	&WindowLine0f,
	NOT_USED(Scaling_on_pop_up_windows_skin_placing__frame_general__Line_5), //	&WindowLine0f,
	NOT_USED(Scaling_on_pop_up_windows_skin_placing__frame_general__Line_6), //	&WindowLine0f,
	NOT_USED(Scaling_on_pop_up_windows_skin_placing__frame_general__Line_7), //	&WindowLine0f,
	NOT_USED(Scaling_on_pop_up_windows_skin_placing__frame_general__Line_8), //	&WindowLine0t,
	NOT_USED(Scaling_on_pop_up_windows_skin_placing__frame_general__Line_9), //	&WindowLine0t,
	IMPL_OK(Limits), 		//  &Scaling_on_pop_up_windows_skin_placing__frame_general__SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f), //  &Scaling_on_pop_up_windows_skin_placing__frame_general__SUB_TABLE_0,
	IMPL_OK(Limits), 		//  &Scaling_on_pop_up_windows_skin_placing__frame_general__SUB_TABLE_1_Limits,
	IMPL_OK(WindowTable0t), //  &Scaling_on_pop_up_windows_skin_placing__frame_general__SUB_TABLE_1,
	NOT_USED(Scaling_on_ending_graphics_for_fast_application_swappingwindow_Line_1), //	&WindowLine0f,
	NOT_USED(Scaling_on_ending_graphics_for_fast_application_swappingwindow_Line_2), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Scaling_on_ending_graphics_for_fast_application_swappingwindow_Limits,
	IMPL_OK(WindowTable0f), //  &Scaling_on_ending_graphics_for_fast_application_swappingwindow,
	NOT_USED(Scaling_on_power_save_state_skin_element_size_Line_2), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Scaling_on_power_save_state_skin_element_size_Limits,
	IMPL_OK(WindowTable0f), //  &Scaling_on_power_save_state_skin_element_size,
	NOT_USED(Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_1), //	&WindowLine0f,
	NOT_USED(Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_2), //	&WindowLine0f,
	NOT_USED(Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_3), //	&WindowLine0f,
	NOT_USED(Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_4), //	&WindowLine0f,
	NOT_USED(Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_5), //	&WindowLine0f,
	NOT_USED(Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_6), //	&WindowLine0f,
	NOT_USED(Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_7), //	&WindowLine0f,
	NOT_USED(Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_8), //	&WindowLine0f,
	NOT_USED(Scaling_on_calendar_skin_element_placing_and_size__dayweek__Line_9), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Scaling_on_calendar_skin_element_placing_and_size__dayweek__Limits,
	IMPL_OK(WindowTable0f), //  &Scaling_on_calendar_skin_element_placing_and_size__dayweek_,
	NOT_USED(Scalingon_calendar_skin_element_placing_and_size__month__Line_1), //	&WindowLine0f,
	NOT_USED(Scalingon_calendar_skin_element_placing_and_size__month__Line_2), //	&WindowLine0f,
	NOT_USED(Scalingon_calendar_skin_element_placing_and_size__month__Line_3), //	&WindowLine0f,
	NOT_USED(Scalingon_calendar_skin_element_placing_and_size__month__Line_4), //	&WindowLine0f,
	NOT_USED(Scalingon_calendar_skin_element_placing_and_size__month__Line_5), //	&WindowLine0f,
	NOT_USED(Scalingon_calendar_skin_element_placing_and_size__month__Line_6), //	&WindowLine0f,
	NOT_USED(Scalingon_calendar_skin_element_placing_and_size__month__Line_7), //	&WindowLine0f,
	NOT_USED(Scalingon_calendar_skin_element_placing_and_size__month__Line_8), //	&WindowLine0f,
	NOT_USED(Scalingon_calendar_skin_element_placing_and_size__month__Line_9), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Scalingon_calendar_skin_element_placing_and_size__month__Limits,
	IMPL_OK(WindowTable0f), //  &Scalingon_calendar_skin_element_placing_and_size__month_,
	NOT_USED(Scaling_on_favourites_skin_sizes_and_placing_Line_1), //	&WindowLine0f,
	NOT_USED(Scaling_on_favourites_skin_sizes_and_placing_Line_2), //	&WindowLine0f,
	NOT_USED(Scaling_on_favourites_skin_sizes_and_placing_Line_3), //	&WindowLine0f,
	NOT_USED(Scaling_on_favourites_skin_sizes_and_placing_Line_4), //	&WindowLine0f,
	NOT_USED(Scaling_on_favourites_skin_sizes_and_placing_Line_5), //	&WindowLine0f,
	NOT_USED(Scaling_on_favourites_skin_sizes_and_placing_Line_6), //	&WindowLine0f,
	NOT_USED(Scaling_on_favourites_skin_sizes_and_placing_Line_7), //	&WindowLine0f,
	NOT_USED(Scaling_on_favourites_skin_sizes_and_placing_Line_8), //	&WindowLine0f,
	NOT_USED(Scaling_on_favourites_skin_sizes_and_placing_Line_9), //	&WindowLine0f,
	NOT_USED(Scaling_on_favourites_skin_sizes_and_placing_Line_10), //	&WindowLine0f,
	IMPL_OK(Limits), 		//  &Scaling_on_favourites_skin_sizes_and_placing_Limits,
	IMPL_OK(WindowTable0f), //  &Scaling_on_favourites_skin_sizes_and_placing,
	};

} // end of namespace SkinLayout

