/*
* Copyright (c) 2002-2004 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/



// This header file contains the customisation implementation identity for Adaptation_Layer_AppApacLayout
// It was generated by hand, not by layout compiler.
// This file may be manually modified.
// This customisation implements the interface defined in AppLayout.cdl

// ___Instructions___
// 1. use Adaptation_Layer_AknLayout_Elaf as an example
// 2. fill in the implementations for the global methods (see section "Adaptation Layer Implementation" below")
// 3. do not modify KDataLookup
// 4. then remove the "NULL, //" from the lines in KCdlImpl at the BOTTOM of this file
//
// Notes:
// - if there is NULL in the bottom table, then the implementation in other CDL instance will be used (the ones generated from LAY files)
// - ensure that the instances are in the packs in the correct order in packages.mk (with adaptation layer after LAY file instances)


#include "Adaptation_Layer_AppApacLayout.h"
#include "AknLayout2AdaptationDecode.h"
#include "AknLayoutScalable_Avkon.cdl.h"
#include "AknLayoutScalable_Apps.cdl.h"

//
// panic
//

enum TAdaptation_Layer_AppApacLayout_Panic
	{
	EParamsOutsideKnownRange,
    ELayoutLineMissing
    };

void Panic(TAdaptation_Layer_AppApacLayout_Panic aCode)
	{
	_LIT(KLayoutPanic, "Layout Avkon AppApac Adaptation Layer panic");
	User::Panic(KLayoutPanic, aCode);
	}

namespace Adaptation_Layer_AppApacLayout
{

extern const TUint KDataLookup[AppApacLayout::E_TApiId_TableSize];


//
// Helpers
//

TAknLayoutTableLimits Limits() { return AknLayoutAdaptationDecode::TableLimits(KDataLookup); }

TAknWindowLineLayout WindowLine0f() { return AknLayoutAdaptationDecode::WindowLine0f(KDataLookup); }
TAknWindowLineLayout WindowTable0f(TInt aLineIndex) { return AknLayoutAdaptationDecode::WindowTable0f(KDataLookup, aLineIndex); }
TAknWindowLineLayout WindowLine1f(TInt aParam0) { return AknLayoutAdaptationDecode::WindowLine1f(KDataLookup, aParam0); }

TAknTextLineLayout TextLine0f() { return AknLayoutAdaptationDecode::TextLine0f(KDataLookup); }
TAknTextLineLayout TextLine1f(TInt aParam0) { return AknLayoutAdaptationDecode::TextLine1f(KDataLookup, aParam0); }
TAknTextLineLayout TextLine2f(TInt aParam0,TInt aParam1) { return AknLayoutAdaptationDecode::TextLine2f(KDataLookup, aParam0, aParam1); }

TAknTextLineLayout TextTable1f(TInt aLineIndex, TInt aParam0) { return AknLayoutAdaptationDecode::TextTable1f(KDataLookup, aLineIndex, aParam0); }
TAknTextLineLayout TextTable0f(TInt aLineIndex) { return AknLayoutAdaptationDecode::TextTable0f(KDataLookup, aLineIndex); }

TAknMultiLineTextLayout MultiLineTextLine1f(TInt aParam0) { return AknLayoutAdaptationDecode::MultiLineTextLine1f(KDataLookup, aParam0); }
TAknMultiLineTextLayout MultiLineTextLine3f(TInt aParam0,TInt aParam1,TInt aParam2) { return AknLayoutAdaptationDecode::MultiLineTextLine3f(KDataLookup, aParam0, aParam1, aParam2); }

inline TAknWindowComponentLayout DoCompose(TAknWindowComponentLayout aLine1, TAknWindowComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::Compose(aLine1, aLine2); 
    }

inline TAknTextComponentLayout DoComposeText(TAknWindowComponentLayout aLine1, TAknTextComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::ComposeText(aLine1, aLine2); 
    }

inline TAknWindowComponentLayout DoIntersect(TAknWindowComponentLayout aLine, TAknWindowComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::Intersect(aLine, aLine2);
    }

inline TAknWindowComponentLayout DoMinus(TAknWindowComponentLayout aLine, TAknWindowComponentLayout aParentDiff)
    {
    return TAknWindowComponentLayout::Minus(aLine, aParentDiff);
    }


//
// This method returns empty TAknWindowLineLayout instance. (Filled with zeroes)
//
const TAknWindowLineLayoutImp KEmptyWindowLayout = {ELayoutEmpty,0,0,0,0,ELayoutEmpty,ELayoutEmpty};
inline const TAknWindowLineLayout& EmptyWindowLayout()
    {
    return *(TAknWindowLineLayout*)&KEmptyWindowLayout;
    }

//
// This method returns empty TAknTextLineLayout instance. (Filled with zeroes)
//
const TAknTextLineLayoutImp KEmptyTextLayout = {ELayoutEmpty,0,0,0,0,ELayoutEmpty,ELayoutEmpty,0,0};
inline const TAknTextLineLayout& EmptyTextLayout()
    {
    return *(TAknTextLineLayout*)&KEmptyTextLayout;
    }


//
// Adaptation Layer Implementation
//

// LAF Table : Real time view texts
// B={50, 90} C=215 Font=EApacPlain16_Scaled J=ELayoutAlignLeft W=230 l=114 r=8 
// Remark                    : City.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Real_time_view_texts_Line_1(TInt /*aIndex_B*/) 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// B={82, 112, 142, 172, 122, 152, 182} C=215 Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=218 l=128 r=8 
// Remark                    : Country. Week day. Date. Daylight saving.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Real_time_view_texts_Line_2(TInt /*aIndex_B*/) 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// B=84 C=219 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=86 l={10, 6}[aCommon1] r={256, 260}[aCommon1] 
// Remark                    : Digital clock shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Real_time_view_texts_Line_3(TInt /*aCommon1*/) 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// B=82 C=210 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=86 l={8, 4}[aCommon1] r={258, 262}[aCommon1] 
// Remark                    : Clock digits.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Real_time_view_texts_Line_4(TInt /*aCommon1*/) 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// B=108 C=210 Font=ELatinBold12_Scaled J=ELayoutAlignRight W=72 l=18 r=262 
// Remark                    : AMPM indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Real_time_view_texts_Line_5() 
    {
    // NOT USED
    return EmptyTextLayout();
    }


// LAF Table : Alarm clock view texts
// B=50 C=215 Font=EApacPlain16_Scaled J=ELayoutAlignLeft W=230 l=114 r=8 
// Remark                    : Current timetext.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 28%) : popup_clock_analogue_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Alarm_clock_view_texts_Line_1() 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// B=84 C=219 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=86 l={10, 6}[aCommon1] r={256, 260}[aCommon1] 
// Remark                    : Digital clock shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 28%) : popup_clock_analogue_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Alarm_clock_view_texts_Line_2(TInt /*aCommon1*/) 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// B=82 C=210 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=86 l={8, 4}[aCommon1] r={258, 262}[aCommon1] 
// Remark                    : Clock digits.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 28%) : popup_clock_analogue_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Alarm_clock_view_texts_Line_3(TInt /*aCommon1*/) 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// B=108 C=210 Font=EApacPlain12_Scaled J=ELayoutAlignRight W=72 l=18 r=262 
// Remark                    : A.m.p.m. indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 28%) : popup_clock_analogue_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Alarm_clock_view_texts_Line_4() 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// B=174 C=215 Font=EApacPlain16_Scaled J=ELayoutAlignLeft W=230 l=114 r=8 
// Remark                    : AlarmNo alarm-indication text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 28%) : popup_clock_analogue_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Alarm_clock_view_texts_Line_5() 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// B={206, 216} C=215 Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=218 l=128 r=8 
// Remark                    : Additional information.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 28%) : popup_clock_analogue_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Alarm_clock_view_texts_Line_6(TInt /*aIndex_B*/) 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// B=172 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=78 l=14 r=260 
// Remark                    : Alarm time.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 28%) : popup_clock_analogue_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Alarm_clock_view_texts_Line_7() 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// B=204 C= Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=72 l=20 r=260 
// Remark                    : A.m.p.m. indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 28%) : popup_clock_analogue_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Alarm_clock_view_texts_Line_8() 
    {
    // NOT USED
    return EmptyTextLayout();
    }


// LAF Table : Help text bolding
// B= C=215 Font=EApacPlain16_Scaled J= W= l= r= 
// Remark                    : Brackets used as text bolding effect
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : list_notes_text_pane_ParamLimits
// Scale parent match (  0%) : 
TAknTextLineLayout Help_text_bolding_Line_1() 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// B= C= Font=EApacPlain16_Scaled J= W=10 l= r= 
// Remark                    : 
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : list_notes_text_pane_ParamLimits
// Scale parent match (  0%) : 
TAknTextLineLayout Help_text_bolding_Line_2() 
    {
    // NOT USED
    return EmptyTextLayout();
    }


// LAF Table : Chinese Dictionary text
// B=42 C=215 Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=304 l=18 r=16 
// Remark                    : Search label text.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Chinese_Dictionary_text_Line_1() 
    {
    TAknTextComponentLayout layout = AknLayoutScalable_Apps::chi_dic_find_pane_t1();
    return layout.LayoutLine();
    }

// B=42 C=215 Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=304 l=18 r= 
// Remark                    : Input text.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Chinese_Dictionary_text_Line_2() 
    {
    TAknTextComponentLayout layout = AknLayoutScalable_Apps::find_chidic_pane_t1();
    return layout.LayoutLine();
    }

// B={92, 134, 176, 218, 260} C=215 Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=304 l=18 r= 
// Remark                    : Bilingual dictionary Show candidate state.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Chinese_Dictionary_text_Line_3(TInt /*aIndex_B*/) 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// B={92, 134, 176, 218, 260} C=215 Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=304 l=18 r= 
// Remark                    : Bilingual dictionary Show result state.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Chinese_Dictionary_text_Line_4(TInt /*aIndex_B*/) 
    {
    // NOT USED
    return EmptyTextLayout();
    }


// LAF Table : Chinese Dictionary elements and descendant panes
// C=221 H=274 W=344 b= l=6 r= t=6 
// Remark                    : Outline frame window.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Chinese_Dictionary_elements_and_descendant_panes_Line_1() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=215 H=276 W=346 b= l=2 r= t=2 
// Remark                    : Outline frame.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Chinese_Dictionary_elements_and_descendant_panes_Line_2() 
    {
    return AknLayoutScalable_Apps::bg_popup_sub_pane_cp03().LayoutLine();
    }

// C=0 H=272 W=342 b= l=4 r= t=4 
// Remark                    : Inside rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Chinese_Dictionary_elements_and_descendant_panes_Line_3() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=215 H=2 W=342 b= l=4 r= t=58 
// Remark                    : Horizontal line inside the frame.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Chinese_Dictionary_elements_and_descendant_panes_Line_4() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C= H=54 W=342 b= l=4 r= t=4 
// Remark                    : Find pane.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : chi_dic_find_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout chi_dic_find_pane() 
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_chi_dic_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::chi_dic_find_pane();
    return DoCompose(layout1, layout2).LayoutLine();
    }

// C= H=210 W=342 b= l=4 r= t=62 
// Remark                    : List pane.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : chi_dic_list_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout chi_dic_list_pane() 
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_chi_dic_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_chi_dic_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::chi_dic_list_pane(1);
    return DoCompose(layout1, DoCompose(layout2, layout3)).LayoutLine();
    }


// LAF Table : Incoming video call pop-up window texts
// B={52, 88}[aCommon1] C=215 Font=EApacPlain16_Scaled J=ELayoutAlignLeft W={262, 262, , 188, 176, 168, 160}[aCommon2] l={70, 70}[aCommon1] r={20, 20, , 94, 106, 114, 122}[aCommon2] 
// Remark                    : CLI and the text calling or Callif there is no CLI available. Two lines of text. Image width is 30. Image width is 36. Image width is 40. Image width is 44.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : popup_call_audio_conf_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Incoming_video_call_pop_up_window_texts_Line_1(TInt /*aCommon1*/, TInt /*aCommon2*/) 
    {
    // NOT USED
    return EmptyTextLayout();
    }


// LAF Table : First video call pop-up window texts
// B=38 C=0 Font=EApacPlain16_Scaled J=ELayoutAlignLeft W=262 l=70 r=20 
// Remark                    : CLI.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 48%) : popup_call_audio_first_window_t1_ParamLimits
// Scale parent match (  0%) : 
TAknTextLineLayout First_video_call_pop_up_window_texts_Line_1() 
    {
    // NOT USED
    return EmptyTextLayout();
    }


// LAF Table : Lunar Calendar information layout
// B=42 C=215 Font=EApacPlain16_Scaled J=ELayoutAlignLeft W=304 l=22 r=26 
// Remark                    : Heading text.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Lunar_Calendar_information_layout_Line_1() 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// B={94, 138, 182} C=215 Font=EApacPlain16_Scaled J=ELayoutAlignLeft W=304 l=22 r=26 
// Remark                    : Lunar Calendar information text.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Lunar_Calendar_information_layout_Line_2(TInt aIndex_B) 
    {
    TAknTextComponentLayout layout;
 	switch (aIndex_B)
 		{
    	case 0:
    		layout = AknLayoutScalable_Apps::popup_cale_lunar_info_window_t1();
    		break;
 		case 1:
 			layout = AknLayoutScalable_Apps::popup_cale_lunar_info_window_t2();
 			break;
 		case 2:
 			layout = AknLayoutScalable_Apps::popup_cale_lunar_info_window_t3();
 			break;
 		default:
 			layout = AknLayoutScalable_Apps::popup_cale_lunar_info_window_t1();
 			break;
 		}
 	return layout.LayoutLine();
    }

// B=234 C=215 Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=304 l=22 r=26 
// Remark                    : Solar Calendar information text.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Lunar_Calendar_information_layout_Line_3() 
    {
    return AknLayoutScalable_Apps::popup_cale_lunar_info_window_t4().LayoutLine();
    }

// C=215 H=2 W=318 b= l=14 r= t={206, 240} 
// Remark                    : Border lines.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Lunar_Calendar_Elements_Line_1(TInt aIndex_t) 
    {
    TAknWindowComponentLayout layout;
    if (aIndex_t == 0)
    	{
    	layout = AknLayoutScalable_Apps::popup_cale_lunar_info_window_g1();
    	}
    else
    	{
    	layout = AknLayoutScalable_Apps::popup_cale_lunar_info_window_g2();
    	}
    return layout.LayoutLine();
    }


// LAF Table : Chinese Dictionary find pane text
// B=40 C=215 Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=56 l=18 r=270 
// Remark                    : Search label text.
// Parent                    : chi_dic_find_pane
// Parent API                : chi_dic_find_pane
// Scale API match    ( 40%) : chi_dic_find_pane_t1
// Scale parent match (100%) : chi_dic_find_pane
TAknTextLineLayout Chinese_Dictionary_find_pane_text_Line_1() 
    {
    return AknLayoutScalable_Apps::chi_dic_find_pane_t1().LayoutLine();
    }

// B=40 C=215 Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=236 l=98 r=8 
// Remark                    : Chinese input text.
// Parent                    : chi_dic_find_pane
// Parent API                : chi_dic_find_pane
// Scale API match    ( 40%) : chi_dic_find_pane_t1
// Scale parent match (100%) : chi_dic_find_pane
TAknTextLineLayout Chinese_Dictionary_find_pane_text_Line_2() 
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::find_chidic_pane();
    TAknTextComponentLayout layout2 = AknLayoutScalable_Apps::find_chidic_pane_t1();
    return DoComposeText(layout1,layout2).LayoutLine();
    }

// B=38 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=236 l=98 r=8 
// Remark                    : Latin input text.
// Parent                    : chi_dic_find_pane
// Parent API                : chi_dic_find_pane
// Scale API match    ( 40%) : chi_dic_find_pane_t1
// Scale parent match (100%) : chi_dic_find_pane
TAknTextLineLayout Chinese_Dictionary_find_pane_text_Line_3() 
    {
    // NOT USED
    return EmptyTextLayout();
    }


// LAF Table : List pane text
// B=34 C=215 Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=316 l=16 r=10 
// Remark                    : Chinese text.
// Parent                    : list_chi_dic_pane
// Parent API                : list_chi_dic_pane
// Scale API match    ( 92%) : list_notes_text_pane_t1
// Scale parent match (100%) : list_chi_dic_pane
TAknTextLineLayout List_pane_text_Line_1() 
    {
    return AknLayoutScalable_Apps::list_chi_dic_pane_t1(0).LayoutLine();
    }

// B=30 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=316 l=16 r=10 
// Remark                    : Latin text.
// Parent                    : list_chi_dic_pane
// Parent API                : list_chi_dic_pane
// Scale API match    ( 92%) : list_notes_text_pane_t1
// Scale parent match (100%) : list_chi_dic_pane
TAknTextLineLayout List_pane_text_Line_2() 
    {
    return AknLayoutScalable_Apps::list_chi_dic_pane_t1(0).LayoutLine();
    }

// LAF Table : 
// C=222 H=36 W=334 b= l=6 r= t=6 
// Remark                    : Hightlight shadow.
// Parent                    : list_chi_dic_pane
// Parent API                : list_chi_dic_pane
// Scale API match    ( 52%) : list_highlight_pane_cp02
// Scale parent match (100%) : list_chi_dic_pane
TAknWindowLineLayout List_pane_highlight__chi_dic__Line_1() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=244 H=38 W=336 b= l=2 r= t=2 
// Remark                    : Hightlight.
// Parent                    : list_chi_dic_pane
// Parent API                : list_chi_dic_pane
// Scale API match    ( 52%) : list_highlight_pane_cp02
// Scale parent match (100%) : list_chi_dic_pane
TAknWindowLineLayout List_pane_highlight__chi_dic__Line_2() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }


// LAF Table : Chinese Dictionary find pane elements
// C=215 H=46 W=252 b= l=88 r= t=4 
// Remark                    : Outline frame.
// Parent                    : chi_dic_find_pane
// Parent API                : chi_dic_find_pane
// Scale API match    ( 33%) : chi_dic_find_pane_t1
// Scale parent match (100%) : chi_dic_find_pane
TAknWindowLineLayout Chinese_Dictionary_find_pane_elements_Line_1() 
    {
    return AknLayoutScalable_Apps::find_chidic_pane().LayoutLine();
    }

// C=221 H=42 W=2 b= l=90 r= t=6 
// Remark                    : Vertical shadow inside the find box frame.
// Parent                    : chi_dic_find_pane
// Parent API                : chi_dic_find_pane
// Scale API match    ( 33%) : chi_dic_find_pane_t1
// Scale parent match (100%) : chi_dic_find_pane
TAknWindowLineLayout Chinese_Dictionary_find_pane_elements_Line_2() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=221 H=2 W=246 b= l=92 r= t=6 
// Remark                    : Horizontal shadow inside the find box frame.
// Parent                    : chi_dic_find_pane
// Parent API                : chi_dic_find_pane
// Scale API match    ( 33%) : chi_dic_find_pane_t1
// Scale parent match (100%) : chi_dic_find_pane
TAknWindowLineLayout Chinese_Dictionary_find_pane_elements_Line_3() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }


// LAF Table : List pane placing (chi,dic)
// C= H=42 W=342 b= l=0 r= t={0, 42, 84, 126, 168}[aNumberOfLinesShown] 
// Remark                    : Translation list item.
// Parent                    : chi_dic_list_pane
// Parent API                : chi_dic_list_pane
// Scale API match    (100%) : list_chi_dic_pane
// Scale parent match (100%) : chi_dic_list_pane
TAknWindowLineLayout list_chi_dic_pane(TInt aNumberOfLinesShown) 
    {
    return AknLayoutScalable_Apps::list_chi_dic_pane( aNumberOfLinesShown ).LayoutLine();
    }


// LAF Table : Find pane elements (pinb)
// C= H=32 W=58 b= l=56 r= t=16 
// Remark                    : Search icons of find pane.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : find_pinb_pane_t_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Find_pane_elements__pinb__Line_5() 
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Apps::find_pinb_pane_g2(0);
    return layout.LayoutLine();
    }


//
// Lookup Table
// This is needed for multiline texts and table decoding
// Do not modify
//

const TUint KDataLookup[AppApacLayout::E_TApiId_TableSize] =
	{
(TUint)&Real_time_view_texts_Line_1,

0x0000,	// Multiline_Real_time_view_texts_Line_1

(TUint)&Real_time_view_texts_Line_2,

0x0000,	// Multiline_Real_time_view_texts_Line_2

(TUint)&Real_time_view_texts_Line_3,

(TUint)&Real_time_view_texts_Line_4,

(TUint)&Real_time_view_texts_Line_5,

0x0001,

(TUint)AppApacLayout::EApiId_Real_time_view_texts_Line_1,

0x0203,

(TUint)AppApacLayout::EApiId_Real_time_view_texts_Line_1,

(TUint)&Alarm_clock_view_texts_Line_1,

(TUint)&Alarm_clock_view_texts_Line_2,

(TUint)&Alarm_clock_view_texts_Line_3,

(TUint)&Alarm_clock_view_texts_Line_4,

(TUint)&Alarm_clock_view_texts_Line_5,

(TUint)&Alarm_clock_view_texts_Line_6,

0x0000,	// Multiline_Alarm_clock_view_texts_Line_6

(TUint)&Alarm_clock_view_texts_Line_7,

(TUint)&Alarm_clock_view_texts_Line_8,

0x0102,

(TUint)AppApacLayout::EApiId_Alarm_clock_view_texts_Line_1,

0x0304,

(TUint)AppApacLayout::EApiId_Alarm_clock_view_texts_Line_1,

0x0607,

(TUint)AppApacLayout::EApiId_Alarm_clock_view_texts_Line_1,

(TUint)&Help_text_bolding_Line_1,

(TUint)&Help_text_bolding_Line_2,

0x0001,

(TUint)AppApacLayout::EApiId_Help_text_bolding_Line_1,

(TUint)&Chinese_Dictionary_text_Line_1,

(TUint)&Chinese_Dictionary_text_Line_2,

(TUint)&Chinese_Dictionary_text_Line_3,

0x0000,	// Multiline_Chinese_Dictionary_text_Line_3

(TUint)&Chinese_Dictionary_text_Line_4,

0x0000,	// Multiline_Chinese_Dictionary_text_Line_4

0x0001,

(TUint)AppApacLayout::EApiId_Chinese_Dictionary_text_Line_1,

0x0203,

(TUint)AppApacLayout::EApiId_Chinese_Dictionary_text_Line_1,

(TUint)&Chinese_Dictionary_elements_and_descendant_panes_Line_1,

(TUint)&Chinese_Dictionary_elements_and_descendant_panes_Line_2,

(TUint)&Chinese_Dictionary_elements_and_descendant_panes_Line_3,

(TUint)&Chinese_Dictionary_elements_and_descendant_panes_Line_4,

(TUint)&chi_dic_find_pane,

(TUint)&chi_dic_list_pane,

0x0005,

(TUint)AppApacLayout::EApiId_Chinese_Dictionary_elements_and_descendant_panes_Line_1,

(TUint)&Incoming_video_call_pop_up_window_texts_Line_1,

0x0402,	// Multiline_Incoming_video_call_pop_up_window_texts_Line_1

(TUint)&First_video_call_pop_up_window_texts_Line_1,

(TUint)&Lunar_Calendar_information_layout_Line_1,

(TUint)&Lunar_Calendar_information_layout_Line_2,

0x0000,	// Multiline_Lunar_Calendar_information_layout_Line_2

(TUint)&Lunar_Calendar_information_layout_Line_3,

(TUint)&Lunar_Calendar_Elements_Line_1,

(TUint)&Chinese_Dictionary_find_pane_text_Line_1,

(TUint)&Chinese_Dictionary_find_pane_text_Line_2,

(TUint)&Chinese_Dictionary_find_pane_text_Line_3,

0x0002,

(TUint)AppApacLayout::EApiId_Chinese_Dictionary_find_pane_text_Line_1,

(TUint)&List_pane_text_Line_1,

(TUint)&List_pane_text_Line_2,

0x0001,

(TUint)AppApacLayout::EApiId_List_pane_text_Line_1,

(TUint)&List_pane_highlight__chi_dic__Line_1,

(TUint)&List_pane_highlight__chi_dic__Line_2,

0x0001,

(TUint)AppApacLayout::EApiId_List_pane_highlight__chi_dic__Line_1,

(TUint)&Chinese_Dictionary_find_pane_elements_Line_1,

(TUint)&Chinese_Dictionary_find_pane_elements_Line_2,

(TUint)&Chinese_Dictionary_find_pane_elements_Line_3,

0x0002,

(TUint)AppApacLayout::EApiId_Chinese_Dictionary_find_pane_elements_Line_1,

(TUint)&list_chi_dic_pane,

(TUint)&Find_pane_elements__pinb__Line_5,
};


#define IMPL_OK(api) &api
#define NOT_DONE(x) &x
#define NOT_NEEDED(x) &x

//
// Implementation
// - if there is NULL in this table, then the implementation in other CDL instance will be used (the ones generated from LAY files)
//
const AppApacLayout::SCdlImpl KCdlImpl = 
    {
    NOT_NEEDED(Real_time_view_texts_Line_1),//    &TextLine1f,
    NOT_NEEDED(MultiLineTextLine1f),
    NOT_NEEDED(Real_time_view_texts_Line_2),//    &TextLine1f,
    NOT_NEEDED(MultiLineTextLine1f),
    NOT_NEEDED(Real_time_view_texts_Line_3),//    &TextLine1f,
    NOT_NEEDED(Real_time_view_texts_Line_4),//    &TextLine1f,
    NOT_NEEDED(Real_time_view_texts_Line_5),//    &TextLine0f,
    NOT_NEEDED(Limits),
    NOT_NEEDED(TextTable1f),
    NOT_NEEDED(Limits),
    NOT_NEEDED(TextTable1f),
    NOT_NEEDED(Alarm_clock_view_texts_Line_1),//  &TextLine0f,
    NOT_NEEDED(Alarm_clock_view_texts_Line_2),//  &TextLine1f,
    NOT_NEEDED(Alarm_clock_view_texts_Line_3),//  &TextLine1f,
    NOT_NEEDED(Alarm_clock_view_texts_Line_4),//  &TextLine0f,
    NOT_NEEDED(Alarm_clock_view_texts_Line_5),//  &TextLine0f,
    NOT_NEEDED(Alarm_clock_view_texts_Line_6),//  &TextLine1f,
    NOT_NEEDED(MultiLineTextLine1f),
    NOT_NEEDED(Alarm_clock_view_texts_Line_7),//  &TextLine0f,
    NOT_NEEDED(Alarm_clock_view_texts_Line_8),//  &TextLine0f,
    NOT_NEEDED(Limits),
    NOT_NEEDED(TextTable1f),
    NOT_NEEDED(Limits),
    NOT_NEEDED(TextTable0f),
    NOT_NEEDED(Limits),
    NOT_NEEDED(TextTable0f),
    NOT_NEEDED(Help_text_bolding_Line_1),//   &TextLine0f,
    NOT_NEEDED(Help_text_bolding_Line_2),//   &TextLine0f,
    NOT_NEEDED(Limits),
    NOT_NEEDED(TextTable0f),
    IMPL_OK(Chinese_Dictionary_text_Line_1),// &TextLine0f,
    IMPL_OK(Chinese_Dictionary_text_Line_2),// &TextLine0f,
    NOT_NEEDED(Chinese_Dictionary_text_Line_3),// &TextLine1f,
    NOT_NEEDED(MultiLineTextLine1f),
    NOT_NEEDED(Chinese_Dictionary_text_Line_4),// &TextLine1f,
    NOT_NEEDED(MultiLineTextLine1f),
    NOT_NEEDED(Limits),
    NOT_NEEDED(TextTable0f),
    NOT_NEEDED(Limits),
    NOT_NEEDED(TextTable1f),
    NOT_NEEDED(Chinese_Dictionary_elements_and_descendant_panes_Line_1),//    &WindowLine0f,
    IMPL_OK(Chinese_Dictionary_elements_and_descendant_panes_Line_2),//    &WindowLine0f,
    NOT_NEEDED(Chinese_Dictionary_elements_and_descendant_panes_Line_3),//    &WindowLine0f,
    NOT_NEEDED(Chinese_Dictionary_elements_and_descendant_panes_Line_4),//    &WindowLine0f,
    IMPL_OK(chi_dic_find_pane),//  &WindowLine0f,
    IMPL_OK(chi_dic_list_pane),//  &WindowLine0f,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable0f),
    NOT_NEEDED(Incoming_video_call_pop_up_window_texts_Line_1),// &TextLine2f,
    NOT_NEEDED(MultiLineTextLine3f),
    NOT_NEEDED(First_video_call_pop_up_window_texts_Line_1),//    &TextLine0f,
    NOT_NEEDED(Lunar_Calendar_information_layout_Line_1),//   &TextLine0f,
    IMPL_OK(Lunar_Calendar_information_layout_Line_2),//   &TextLine1f,
    NOT_NEEDED(MultiLineTextLine1f),
    IMPL_OK(Lunar_Calendar_information_layout_Line_3),//   &TextLine0f,
    IMPL_OK(Lunar_Calendar_Elements_Line_1),// &WindowLine1f,
    IMPL_OK(Chinese_Dictionary_find_pane_text_Line_1),//   &TextLine0f,
    IMPL_OK(Chinese_Dictionary_find_pane_text_Line_2),//   &TextLine0f,
    NOT_NEEDED(Chinese_Dictionary_find_pane_text_Line_3),//   &TextLine0f,
    NOT_NEEDED(Limits),
    NOT_NEEDED(TextTable0f),
    IMPL_OK(List_pane_text_Line_1),//  &TextLine0f,
    IMPL_OK(List_pane_text_Line_2),//  &TextLine0f,
    IMPL_OK(Limits),
    IMPL_OK(TextTable0f),
    NOT_NEEDED(List_pane_highlight__chi_dic__Line_1),//   &WindowLine0f,
    NOT_NEEDED(List_pane_highlight__chi_dic__Line_2),//   &WindowLine0f,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable0f),
    IMPL_OK(Chinese_Dictionary_find_pane_elements_Line_1),//   &WindowLine0f,
    NOT_NEEDED(Chinese_Dictionary_find_pane_elements_Line_2),//   &WindowLine0f,
    NOT_NEEDED(Chinese_Dictionary_find_pane_elements_Line_3),//   &WindowLine0f,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable0f),
    IMPL_OK(list_chi_dic_pane),//  &WindowLine1f,
    IMPL_OK(Find_pane_elements__pinb__Line_5),//   &WindowLine0f,
    };

} // end of namespace Adaptation_Layer_AppApacLayout


