/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGTextElement.h"

#include <wtf/GetPtr.h>

#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "SVGElement.h"
#include "SVGTextElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGTextElementTableEntries[] =
{
    { "nearestViewportElement", JSSVGTextElement::NearestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "transform", JSSVGTextElement::TransformAttrNum, DontDelete|ReadOnly, 0, &JSSVGTextElementTableEntries[3] },
    { 0, 0, 0, 0, 0 },
    { "farthestViewportElement", JSSVGTextElement::FarthestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGTextElementTable = 
{
    2, 4, JSSVGTextElementTableEntries, 3
};

/* Hash table for prototype */

static const HashEntry JSSVGTextElementPrototypeTableEntries[] =
{
    { "getTransformToElement", JSSVGTextElement::GetTransformToElementFuncNum, DontDelete|Function, 1, 0 },
    { "getScreenCTM", JSSVGTextElement::GetScreenCTMFuncNum, DontDelete|Function, 0, 0 },
    { "getCTM", JSSVGTextElement::GetCTMFuncNum, DontDelete|Function, 0, 0 },
    { "getBBox", JSSVGTextElement::GetBBoxFuncNum, DontDelete|Function, 0, 0 }
};

static const HashTable JSSVGTextElementPrototypeTable = 
{
    2, 4, JSSVGTextElementPrototypeTableEntries, 4
};

const ClassInfo JSSVGTextElementPrototype::info = { "SVGTextElementPrototype", 0, &JSSVGTextElementPrototypeTable, 0 };

JSObject* JSSVGTextElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGTextElementPrototype>(exec, "[[JSSVGTextElement.prototype]]");
}

bool JSSVGTextElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGTextElementPrototypeFunction, JSObject>(exec, &JSSVGTextElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGTextElement::info = { "SVGTextElement", &JSSVGTextPositioningElement::info, &JSSVGTextElementTable, 0 };

JSSVGTextElement::JSSVGTextElement(ExecState* exec, SVGTextElement* impl)
    : JSSVGTextPositioningElement(exec, impl)
{
    setPrototype(JSSVGTextElementPrototype::self(exec));
}

bool JSSVGTextElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTextElement, JSSVGTextPositioningElement>(exec, &JSSVGTextElementTable, this, propertyName, slot);
}

JSValue* JSSVGTextElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TransformAttrNum: {
        SVGTextElement* imp = static_cast<SVGTextElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedTransformList>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedTransformList>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedTransformList>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case NearestViewportElementAttrNum: {
        SVGTextElement* imp = static_cast<SVGTextElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
    }
    case FarthestViewportElementAttrNum: {
        SVGTextElement* imp = static_cast<SVGTextElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
    }
    }
    return 0;
}

JSValue* JSSVGTextElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGTextElement::info))
      return throwError(exec, TypeError);

    SVGTextElement* imp = static_cast<SVGTextElement*>(static_cast<JSSVGTextElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGTextElement::GetBBoxFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatRect>(imp->getBBox()));
        return result;
    }
    case JSSVGTextElement::GetCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getCTM()));
        return result;
    }
    case JSSVGTextElement::GetScreenCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getScreenCTM()));
        return result;
    }
    case JSSVGTextElement::GetTransformToElementFuncNum: {
        ExceptionCode ec = 0;
        SVGElement* element = toSVGElement(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getTransformToElement(element, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
