/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLBaseFontElement.h"

#include <wtf/GetPtr.h>

#include "HTMLBaseFontElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLBaseFontElementTableEntries[] =
{
    { "size", JSHTMLBaseFontElement::SizeAttrNum, DontDelete, 0, 0 },
    { "color", JSHTMLBaseFontElement::ColorAttrNum, DontDelete, 0, &JSHTMLBaseFontElementTableEntries[4] },
    { 0, 0, 0, 0, 0 },
    { "face", JSHTMLBaseFontElement::FaceAttrNum, DontDelete, 0, 0 },
    { "constructor", JSHTMLBaseFontElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLBaseFontElementTable = 
{
    2, 5, JSHTMLBaseFontElementTableEntries, 4
};

/* Hash table for constructor */

static const HashEntry JSHTMLBaseFontElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLBaseFontElementConstructorTable = 
{
    2, 1, JSHTMLBaseFontElementConstructorTableEntries, 1
};

class JSHTMLBaseFontElementConstructor : public DOMObject {
public:
    JSHTMLBaseFontElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLBaseFontElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLBaseFontElementConstructor::info = { "HTMLBaseFontElementConstructor", 0, &JSHTMLBaseFontElementConstructorTable, 0 };

bool JSHTMLBaseFontElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBaseFontElementConstructor, DOMObject>(exec, &JSHTMLBaseFontElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLBaseFontElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLBaseFontElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLBaseFontElementPrototypeTable = 
{
    2, 1, JSHTMLBaseFontElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLBaseFontElementPrototype::info = { "HTMLBaseFontElementPrototype", 0, &JSHTMLBaseFontElementPrototypeTable, 0 };

JSObject* JSHTMLBaseFontElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLBaseFontElementPrototype>(exec, "[[JSHTMLBaseFontElement.prototype]]");
}

const ClassInfo JSHTMLBaseFontElement::info = { "HTMLBaseFontElement", &JSHTMLElement::info, &JSHTMLBaseFontElementTable, 0 };

JSHTMLBaseFontElement::JSHTMLBaseFontElement(ExecState* exec, HTMLBaseFontElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLBaseFontElementPrototype::self(exec));
}

bool JSHTMLBaseFontElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBaseFontElement, JSHTMLElement>(exec, &JSHTMLBaseFontElementTable, this, propertyName, slot);
}

JSValue* JSHTMLBaseFontElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ColorAttrNum: {
        HTMLBaseFontElement* imp = static_cast<HTMLBaseFontElement*>(impl());

        return jsString(imp->color());
    }
    case FaceAttrNum: {
        HTMLBaseFontElement* imp = static_cast<HTMLBaseFontElement*>(impl());

        return jsString(imp->face());
    }
    case SizeAttrNum: {
        HTMLBaseFontElement* imp = static_cast<HTMLBaseFontElement*>(impl());

        return jsNumber(imp->size());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLBaseFontElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLBaseFontElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLBaseFontElementTable, this);
}

void JSHTMLBaseFontElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case ColorAttrNum: {
        HTMLBaseFontElement* imp = static_cast<HTMLBaseFontElement*>(impl());

        imp->setColor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case FaceAttrNum: {
        HTMLBaseFontElement* imp = static_cast<HTMLBaseFontElement*>(impl());

        imp->setFace(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SizeAttrNum: {
        HTMLBaseFontElement* imp = static_cast<HTMLBaseFontElement*>(impl());

        imp->setSize(value->toInt32(exec));
        break;
    }
    }
}

JSValue* JSHTMLBaseFontElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLBaseFontElementConstructor>(exec, "[[HTMLBaseFontElement.constructor]]");
}

}
