/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGMatrix.h"

#include <wtf/GetPtr.h>

#include "JSSVGMatrix.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGMatrixTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "b", JSSVGMatrix::BAttrNum, DontDelete, 0, &JSSVGMatrixTableEntries[7] },
    { 0, 0, 0, 0, 0 },
    { "c", JSSVGMatrix::CAttrNum, DontDelete, 0, &JSSVGMatrixTableEntries[6] },
    { "f", JSSVGMatrix::FAttrNum, DontDelete, 0, 0 },
    { "a", JSSVGMatrix::AAttrNum, DontDelete, 0, 0 },
    { "d", JSSVGMatrix::DAttrNum, DontDelete, 0, 0 },
    { "e", JSSVGMatrix::EAttrNum, DontDelete, 0, 0 }
};

static const HashTable JSSVGMatrixTable = 
{
    2, 8, JSSVGMatrixTableEntries, 6
};

/* Hash table for prototype */

static const HashEntry JSSVGMatrixPrototypeTableEntries[] =
{
    { "skewX", JSSVGMatrix::SkewXFuncNum, DontDelete|Function, 1, 0 },
    { 0, 0, 0, 0, 0 },
    { "rotateFromVector", JSSVGMatrix::RotateFromVectorFuncNum, DontDelete|Function, 2, 0 },
    { 0, 0, 0, 0, 0 },
    { "flipX", JSSVGMatrix::FlipXFuncNum, DontDelete|Function, 0, 0 },
    { "multiply", JSSVGMatrix::MultiplyFuncNum, DontDelete|Function, 1, 0 },
    { 0, 0, 0, 0, 0 },
    { "inverse", JSSVGMatrix::InverseFuncNum, DontDelete|Function, 0, &JSSVGMatrixPrototypeTableEntries[11] },
    { "rotate", JSSVGMatrix::RotateFuncNum, DontDelete|Function, 1, 0 },
    { "scaleNonUniform", JSSVGMatrix::ScaleNonUniformFuncNum, DontDelete|Function, 2, &JSSVGMatrixPrototypeTableEntries[12] },
    { "scale", JSSVGMatrix::ScaleFuncNum, DontDelete|Function, 1, &JSSVGMatrixPrototypeTableEntries[13] },
    { "translate", JSSVGMatrix::TranslateFuncNum, DontDelete|Function, 2, 0 },
    { "flipY", JSSVGMatrix::FlipYFuncNum, DontDelete|Function, 0, 0 },
    { "skewY", JSSVGMatrix::SkewYFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSSVGMatrixPrototypeTable = 
{
    2, 14, JSSVGMatrixPrototypeTableEntries, 11
};

const ClassInfo JSSVGMatrixPrototype::info = { "SVGMatrixPrototype", 0, &JSSVGMatrixPrototypeTable, 0 };

JSObject* JSSVGMatrixPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGMatrixPrototype>(exec, "[[JSSVGMatrix.prototype]]");
}

bool JSSVGMatrixPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGMatrixPrototypeFunction, JSObject>(exec, &JSSVGMatrixPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGMatrix::info = { "SVGMatrix", 0, &JSSVGMatrixTable, 0 };

JSSVGMatrix::JSSVGMatrix(ExecState* exec, JSSVGPODTypeWrapper<AffineTransform>* impl)
    : m_impl(impl)
{
    setPrototype(JSSVGMatrixPrototype::self(exec));
}

JSSVGMatrix::~JSSVGMatrix()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSSVGMatrix::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGMatrix, KJS::DOMObject>(exec, &JSSVGMatrixTable, this, propertyName, slot);
}

JSValue* JSSVGMatrix::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AAttrNum: {
        AffineTransform& imp(*impl());

        return jsNumber(imp.a());
    }
    case BAttrNum: {
        AffineTransform& imp(*impl());

        return jsNumber(imp.b());
    }
    case CAttrNum: {
        AffineTransform& imp(*impl());

        return jsNumber(imp.c());
    }
    case DAttrNum: {
        AffineTransform& imp(*impl());

        return jsNumber(imp.d());
    }
    case EAttrNum: {
        AffineTransform& imp(*impl());

        return jsNumber(imp.e());
    }
    case FAttrNum: {
        AffineTransform& imp(*impl());

        return jsNumber(imp.f());
    }
    }
    return 0;
}

void JSSVGMatrix::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGMatrix, KJS::DOMObject>(exec, propertyName, value, attr, &JSSVGMatrixTable, this);
}

void JSSVGMatrix::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case AAttrNum: {
        AffineTransform& imp(*impl());

        imp.setA(value->toNumber(exec));
        m_impl->commitChange(exec);
        break;
    }
    case BAttrNum: {
        AffineTransform& imp(*impl());

        imp.setB(value->toNumber(exec));
        m_impl->commitChange(exec);
        break;
    }
    case CAttrNum: {
        AffineTransform& imp(*impl());

        imp.setC(value->toNumber(exec));
        m_impl->commitChange(exec);
        break;
    }
    case DAttrNum: {
        AffineTransform& imp(*impl());

        imp.setD(value->toNumber(exec));
        m_impl->commitChange(exec);
        break;
    }
    case EAttrNum: {
        AffineTransform& imp(*impl());

        imp.setE(value->toNumber(exec));
        m_impl->commitChange(exec);
        break;
    }
    case FAttrNum: {
        AffineTransform& imp(*impl());

        imp.setF(value->toNumber(exec));
        m_impl->commitChange(exec);
        break;
    }
    }
}

JSValue* JSSVGMatrixPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGMatrix::info))
      return throwError(exec, TypeError);

    JSSVGPODTypeWrapper<AffineTransform>* wrapper = static_cast<JSSVGMatrix*>(thisObj)->impl();
    AffineTransform& imp(*wrapper);

    switch (id) {
    case JSSVGMatrix::MultiplyFuncNum: {
        AffineTransform secondMatrix = toSVGMatrix(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp.multiply(secondMatrix)));
        wrapper->commitChange(exec);
        return result;
    }
    case JSSVGMatrix::InverseFuncNum: {
        return static_cast<JSSVGMatrix*>(thisObj)->inverse(exec, args);
    }
    case JSSVGMatrix::TranslateFuncNum: {
        double x = args[0]->toNumber(exec);
        double y = args[1]->toNumber(exec);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp.translate(x, y)));
        wrapper->commitChange(exec);
        return result;
    }
    case JSSVGMatrix::ScaleFuncNum: {
        double scaleFactor = args[0]->toNumber(exec);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp.scale(scaleFactor)));
        wrapper->commitChange(exec);
        return result;
    }
    case JSSVGMatrix::ScaleNonUniformFuncNum: {
        double scaleFactorX = args[0]->toNumber(exec);
        double scaleFactorY = args[1]->toNumber(exec);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp.scaleNonUniform(scaleFactorX, scaleFactorY)));
        wrapper->commitChange(exec);
        return result;
    }
    case JSSVGMatrix::RotateFuncNum: {
        double angle = args[0]->toNumber(exec);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp.rotate(angle)));
        wrapper->commitChange(exec);
        return result;
    }
    case JSSVGMatrix::RotateFromVectorFuncNum: {
        return static_cast<JSSVGMatrix*>(thisObj)->rotateFromVector(exec, args);
    }
    case JSSVGMatrix::FlipXFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp.flipX()));
        wrapper->commitChange(exec);
        return result;
    }
    case JSSVGMatrix::FlipYFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp.flipY()));
        wrapper->commitChange(exec);
        return result;
    }
    case JSSVGMatrix::SkewXFuncNum: {
        double angle = args[0]->toNumber(exec);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp.skewX(angle)));
        wrapper->commitChange(exec);
        return result;
    }
    case JSSVGMatrix::SkewYFuncNum: {
        double angle = args[0]->toNumber(exec);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp.skewY(angle)));
        wrapper->commitChange(exec);
        return result;
    }
    }
    return 0;
}
KJS::JSValue* toJS(KJS::ExecState* exec, JSSVGPODTypeWrapper<AffineTransform>* obj)
{
    return KJS::cacheDOMObject<JSSVGPODTypeWrapper<AffineTransform>, JSSVGMatrix>(exec, obj);
}
AffineTransform toSVGMatrix(KJS::JSValue* val)
{
    return val->isObject(&JSSVGMatrix::info) ? (AffineTransform) *static_cast<JSSVGMatrix*>(val)->impl() : AffineTransform();
}

}

#endif // ENABLE(SVG)
