/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCDATASection.h"

#include <wtf/GetPtr.h>

#include "CDATASection.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSCDATASectionTableEntries[] =
{
    { "constructor", JSCDATASection::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSCDATASectionTable = 
{
    2, 1, JSCDATASectionTableEntries, 1
};

/* Hash table for constructor */

static const HashEntry JSCDATASectionConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSCDATASectionConstructorTable = 
{
    2, 1, JSCDATASectionConstructorTableEntries, 1
};

class JSCDATASectionConstructor : public DOMObject {
public:
    JSCDATASectionConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSCDATASectionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCDATASectionConstructor::info = { "CDATASectionConstructor", 0, &JSCDATASectionConstructorTable, 0 };

bool JSCDATASectionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCDATASectionConstructor, DOMObject>(exec, &JSCDATASectionConstructorTable, this, propertyName, slot);
}

JSValue* JSCDATASectionConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSCDATASectionPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSCDATASectionPrototypeTable = 
{
    2, 1, JSCDATASectionPrototypeTableEntries, 1
};

const ClassInfo JSCDATASectionPrototype::info = { "CDATASectionPrototype", 0, &JSCDATASectionPrototypeTable, 0 };

JSObject* JSCDATASectionPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCDATASectionPrototype>(exec, "[[JSCDATASection.prototype]]");
}

const ClassInfo JSCDATASection::info = { "CDATASection", &JSText::info, &JSCDATASectionTable, 0 };

JSCDATASection::JSCDATASection(ExecState* exec, CDATASection* impl)
    : JSText(exec, impl)
{
    setPrototype(JSCDATASectionPrototype::self(exec));
}

bool JSCDATASection::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCDATASection, JSText>(exec, &JSCDATASectionTable, this, propertyName, slot);
}

JSValue* JSCDATASection::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSCDATASection::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCDATASectionConstructor>(exec, "[[CDATASection.constructor]]");
}

}
