/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLLegendElement.h"

#include <wtf/GetPtr.h>

#include "HTMLFormElement.h"
#include "HTMLLegendElement.h"
#include "JSHTMLFormElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLLegendElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "form", JSHTMLLegendElement::FormAttrNum, DontDelete|ReadOnly, 0, &JSHTMLLegendElementTableEntries[4] },
    { "accessKey", JSHTMLLegendElement::AccessKeyAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "align", JSHTMLLegendElement::AlignAttrNum, DontDelete, 0, &JSHTMLLegendElementTableEntries[5] },
    { "constructor", JSHTMLLegendElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLLegendElementTable = 
{
    2, 6, JSHTMLLegendElementTableEntries, 4
};

/* Hash table for constructor */

static const HashEntry JSHTMLLegendElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLLegendElementConstructorTable = 
{
    2, 1, JSHTMLLegendElementConstructorTableEntries, 1
};

class JSHTMLLegendElementConstructor : public DOMObject {
public:
    JSHTMLLegendElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLLegendElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLLegendElementConstructor::info = { "HTMLLegendElementConstructor", 0, &JSHTMLLegendElementConstructorTable, 0 };

bool JSHTMLLegendElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLegendElementConstructor, DOMObject>(exec, &JSHTMLLegendElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLLegendElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLLegendElementPrototypeTableEntries[] =
{
    { "focus", JSHTMLLegendElement::FocusFuncNum, DontDelete|Function, 0, 0 }
};

static const HashTable JSHTMLLegendElementPrototypeTable = 
{
    2, 1, JSHTMLLegendElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLLegendElementPrototype::info = { "HTMLLegendElementPrototype", 0, &JSHTMLLegendElementPrototypeTable, 0 };

JSObject* JSHTMLLegendElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLLegendElementPrototype>(exec, "[[JSHTMLLegendElement.prototype]]");
}

bool JSHTMLLegendElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSHTMLLegendElementPrototypeFunction, JSObject>(exec, &JSHTMLLegendElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLLegendElement::info = { "HTMLLegendElement", &JSHTMLElement::info, &JSHTMLLegendElementTable, 0 };

JSHTMLLegendElement::JSHTMLLegendElement(ExecState* exec, HTMLLegendElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLLegendElementPrototype::self(exec));
}

bool JSHTMLLegendElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLegendElement, JSHTMLElement>(exec, &JSHTMLLegendElementTable, this, propertyName, slot);
}

JSValue* JSHTMLLegendElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case FormAttrNum: {
        HTMLLegendElement* imp = static_cast<HTMLLegendElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->form()));
    }
    case AccessKeyAttrNum: {
        HTMLLegendElement* imp = static_cast<HTMLLegendElement*>(impl());

        return jsString(imp->accessKey());
    }
    case AlignAttrNum: {
        HTMLLegendElement* imp = static_cast<HTMLLegendElement*>(impl());

        return jsString(imp->align());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLLegendElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLLegendElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLLegendElementTable, this);
}

void JSHTMLLegendElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case AccessKeyAttrNum: {
        HTMLLegendElement* imp = static_cast<HTMLLegendElement*>(impl());

        imp->setAccessKey(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AlignAttrNum: {
        HTMLLegendElement* imp = static_cast<HTMLLegendElement*>(impl());

        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLLegendElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLLegendElementConstructor>(exec, "[[HTMLLegendElement.constructor]]");
}
JSValue* JSHTMLLegendElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLLegendElement::info))
      return throwError(exec, TypeError);

    HTMLLegendElement* imp = static_cast<HTMLLegendElement*>(static_cast<JSHTMLLegendElement*>(thisObj)->impl());

    switch (id) {
    case JSHTMLLegendElement::FocusFuncNum: {

        imp->focus();
        return jsUndefined();
    }
    }
    return 0;
}

}
