/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLOListElement.h"

#include <wtf/GetPtr.h>

#include "HTMLOListElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLOListElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "constructor", JSHTMLOListElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 },
    { "start", JSHTMLOListElement::StartAttrNum, DontDelete, 0, 0 },
    { "compact", JSHTMLOListElement::CompactAttrNum, DontDelete, 0, &JSHTMLOListElementTableEntries[4] },
    { "type", JSHTMLOListElement::TypeAttrNum, DontDelete, 0, 0 }
};

static const HashTable JSHTMLOListElementTable = 
{
    2, 5, JSHTMLOListElementTableEntries, 4
};

/* Hash table for constructor */

static const HashEntry JSHTMLOListElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLOListElementConstructorTable = 
{
    2, 1, JSHTMLOListElementConstructorTableEntries, 1
};

class JSHTMLOListElementConstructor : public DOMObject {
public:
    JSHTMLOListElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLOListElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLOListElementConstructor::info = { "HTMLOListElementConstructor", 0, &JSHTMLOListElementConstructorTable, 0 };

bool JSHTMLOListElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOListElementConstructor, DOMObject>(exec, &JSHTMLOListElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLOListElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLOListElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLOListElementPrototypeTable = 
{
    2, 1, JSHTMLOListElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLOListElementPrototype::info = { "HTMLOListElementPrototype", 0, &JSHTMLOListElementPrototypeTable, 0 };

JSObject* JSHTMLOListElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLOListElementPrototype>(exec, "[[JSHTMLOListElement.prototype]]");
}

const ClassInfo JSHTMLOListElement::info = { "HTMLOListElement", &JSHTMLElement::info, &JSHTMLOListElementTable, 0 };

JSHTMLOListElement::JSHTMLOListElement(ExecState* exec, HTMLOListElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLOListElementPrototype::self(exec));
}

bool JSHTMLOListElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOListElement, JSHTMLElement>(exec, &JSHTMLOListElementTable, this, propertyName, slot);
}

JSValue* JSHTMLOListElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CompactAttrNum: {
        HTMLOListElement* imp = static_cast<HTMLOListElement*>(impl());

        return jsBoolean(imp->compact());
    }
    case StartAttrNum: {
        HTMLOListElement* imp = static_cast<HTMLOListElement*>(impl());

        return jsNumber(imp->start());
    }
    case TypeAttrNum: {
        HTMLOListElement* imp = static_cast<HTMLOListElement*>(impl());

        return jsString(imp->type());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLOListElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLOListElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLOListElementTable, this);
}

void JSHTMLOListElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case CompactAttrNum: {
        HTMLOListElement* imp = static_cast<HTMLOListElement*>(impl());

        imp->setCompact(value->toBoolean(exec));
        break;
    }
    case StartAttrNum: {
        HTMLOListElement* imp = static_cast<HTMLOListElement*>(impl());

        imp->setStart(value->toInt32(exec));
        break;
    }
    case TypeAttrNum: {
        HTMLOListElement* imp = static_cast<HTMLOListElement*>(impl());

        imp->setType(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLOListElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLOListElementConstructor>(exec, "[[HTMLOListElement.constructor]]");
}

}
