/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGAnimatedPoints.h"

#include <wtf/GetPtr.h>

#include "JSSVGPointList.h"
#include "SVGAnimatedPoints.h"
#include "SVGPointList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGAnimatedPointsTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "points", JSSVGAnimatedPoints::PointsAttrNum, DontDelete|ReadOnly, 0, &JSSVGAnimatedPointsTableEntries[2] },
    { "animatedPoints", JSSVGAnimatedPoints::AnimatedPointsAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGAnimatedPointsTable = 
{
    2, 3, JSSVGAnimatedPointsTableEntries, 2
};

/* Hash table for prototype */

static const HashEntry JSSVGAnimatedPointsPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedPointsPrototypeTable = 
{
    2, 1, JSSVGAnimatedPointsPrototypeTableEntries, 1
};

const ClassInfo JSSVGAnimatedPointsPrototype::info = { "SVGAnimatedPointsPrototype", 0, &JSSVGAnimatedPointsPrototypeTable, 0 };

JSObject* JSSVGAnimatedPointsPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGAnimatedPointsPrototype>(exec, "[[JSSVGAnimatedPoints.prototype]]");
}

const ClassInfo JSSVGAnimatedPoints::info = { "SVGAnimatedPoints", 0, &JSSVGAnimatedPointsTable, 0 };

JSSVGAnimatedPoints::JSSVGAnimatedPoints(ExecState* exec, SVGAnimatedPoints* impl)
    : m_impl(impl)
{
    setPrototype(JSSVGAnimatedPointsPrototype::self(exec));
}

JSSVGAnimatedPoints::~JSSVGAnimatedPoints()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSSVGAnimatedPoints::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedPoints, KJS::DOMObject>(exec, &JSSVGAnimatedPointsTable, this, propertyName, slot);
}

JSValue* JSSVGAnimatedPoints::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case PointsAttrNum: {
        SVGAnimatedPoints* imp = static_cast<SVGAnimatedPoints*>(impl());

        return toJS(exec, WTF::getPtr(imp->points()));
    }
    case AnimatedPointsAttrNum: {
        SVGAnimatedPoints* imp = static_cast<SVGAnimatedPoints*>(impl());

        return toJS(exec, WTF::getPtr(imp->animatedPoints()));
    }
    }
    return 0;
}

KJS::JSValue* toJS(KJS::ExecState* exec, SVGAnimatedPoints* obj)
{
    return KJS::cacheDOMObject<SVGAnimatedPoints, JSSVGAnimatedPoints>(exec, obj);
}
SVGAnimatedPoints* toSVGAnimatedPoints(KJS::JSValue* val)
{
    return val->isObject(&JSSVGAnimatedPoints::info) ? static_cast<JSSVGAnimatedPoints*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
