/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGPoint.h"

#include <wtf/GetPtr.h>

#include "JSSVGMatrix.h"
#include "JSSVGPoint.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGPointTableEntries[] =
{
    { "y", JSSVGPoint::YAttrNum, DontDelete, 0, 0 },
    { "x", JSSVGPoint::XAttrNum, DontDelete, 0, 0 }
};

static const HashTable JSSVGPointTable = 
{
    2, 2, JSSVGPointTableEntries, 2
};

/* Hash table for prototype */

static const HashEntry JSSVGPointPrototypeTableEntries[] =
{
    { "matrixTransform", JSSVGPoint::MatrixTransformFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSSVGPointPrototypeTable = 
{
    2, 1, JSSVGPointPrototypeTableEntries, 1
};

const ClassInfo JSSVGPointPrototype::info = { "SVGPointPrototype", 0, &JSSVGPointPrototypeTable, 0 };

JSObject* JSSVGPointPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGPointPrototype>(exec, "[[JSSVGPoint.prototype]]");
}

bool JSSVGPointPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGPointPrototypeFunction, JSObject>(exec, &JSSVGPointPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGPoint::info = { "SVGPoint", 0, &JSSVGPointTable, 0 };

JSSVGPoint::JSSVGPoint(ExecState* exec, JSSVGPODTypeWrapper<FloatPoint>* impl)
    : m_impl(impl)
{
    setPrototype(JSSVGPointPrototype::self(exec));
}

JSSVGPoint::~JSSVGPoint()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSSVGPoint::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPoint, KJS::DOMObject>(exec, &JSSVGPointTable, this, propertyName, slot);
}

JSValue* JSSVGPoint::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case XAttrNum: {
        FloatPoint& imp(*impl());

        return jsNumber(imp.x());
    }
    case YAttrNum: {
        FloatPoint& imp(*impl());

        return jsNumber(imp.y());
    }
    }
    return 0;
}

void JSSVGPoint::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGPoint, KJS::DOMObject>(exec, propertyName, value, attr, &JSSVGPointTable, this);
}

void JSSVGPoint::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XAttrNum: {
        FloatPoint& imp(*impl());

        imp.setX(value->toFloat(exec));
        m_impl->commitChange(exec);
        break;
    }
    case YAttrNum: {
        FloatPoint& imp(*impl());

        imp.setY(value->toFloat(exec));
        m_impl->commitChange(exec);
        break;
    }
    }
}

JSValue* JSSVGPointPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGPoint::info))
      return throwError(exec, TypeError);

    JSSVGPODTypeWrapper<FloatPoint>* wrapper = static_cast<JSSVGPoint*>(thisObj)->impl();
    FloatPoint& imp(*wrapper);

    switch (id) {
    case JSSVGPoint::MatrixTransformFuncNum: {
        AffineTransform matrix = toSVGMatrix(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatPoint>(imp.matrixTransform(matrix)));
        wrapper->commitChange(exec);
        return result;
    }
    }
    return 0;
}
KJS::JSValue* toJS(KJS::ExecState* exec, JSSVGPODTypeWrapper<FloatPoint>* obj)
{
    return KJS::cacheDOMObject<JSSVGPODTypeWrapper<FloatPoint>, JSSVGPoint>(exec, obj);
}
FloatPoint toSVGPoint(KJS::JSValue* val)
{
    return val->isObject(&JSSVGPoint::info) ? (FloatPoint) *static_cast<JSSVGPoint*>(val)->impl() : FloatPoint();
}

}

#endif // ENABLE(SVG)
