/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDOMImplementation.h"

#include <wtf/GetPtr.h>

#include "CSSStyleSheet.h"
#include "DOMImplementation.h"
#include "Document.h"
#include "DocumentType.h"
#include "HTMLDocument.h"
#include "JSCSSStyleSheet.h"
#include "JSDocument.h"
#include "JSDocumentType.h"
#include "JSHTMLDocument.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSDOMImplementationTableEntries[] =
{
    { "constructor", JSDOMImplementation::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSDOMImplementationTable = 
{
    2, 1, JSDOMImplementationTableEntries, 1
};

/* Hash table for constructor */

static const HashEntry JSDOMImplementationConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSDOMImplementationConstructorTable = 
{
    2, 1, JSDOMImplementationConstructorTableEntries, 1
};

class JSDOMImplementationConstructor : public DOMObject {
public:
    JSDOMImplementationConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSDOMImplementationPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSDOMImplementationConstructor::info = { "DOMImplementationConstructor", 0, &JSDOMImplementationConstructorTable, 0 };

bool JSDOMImplementationConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMImplementationConstructor, DOMObject>(exec, &JSDOMImplementationConstructorTable, this, propertyName, slot);
}

JSValue* JSDOMImplementationConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSDOMImplementationPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "createDocumentType", JSDOMImplementation::CreateDocumentTypeFuncNum, DontDelete|Function, 3, &JSDOMImplementationPrototypeTableEntries[5] },
    { "hasFeature", JSDOMImplementation::HasFeatureFuncNum, DontDelete|Function, 2, &JSDOMImplementationPrototypeTableEntries[6] },
    { "createDocument", JSDOMImplementation::CreateDocumentFuncNum, DontDelete|Function, 3, 0 },
    { 0, 0, 0, 0, 0 },
    { "createCSSStyleSheet", JSDOMImplementation::CreateCSSStyleSheetFuncNum, DontDelete|Function, 2, 0 },
    { "createHTMLDocument", JSDOMImplementation::CreateHTMLDocumentFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSDOMImplementationPrototypeTable = 
{
    2, 7, JSDOMImplementationPrototypeTableEntries, 5
};

const ClassInfo JSDOMImplementationPrototype::info = { "DOMImplementationPrototype", 0, &JSDOMImplementationPrototypeTable, 0 };

JSObject* JSDOMImplementationPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDOMImplementationPrototype>(exec, "[[JSDOMImplementation.prototype]]");
}

bool JSDOMImplementationPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSDOMImplementationPrototypeFunction, JSObject>(exec, &JSDOMImplementationPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDOMImplementation::info = { "DOMImplementation", 0, &JSDOMImplementationTable, 0 };

JSDOMImplementation::JSDOMImplementation(ExecState* exec, DOMImplementation* impl)
    : m_impl(impl)
{
    setPrototype(JSDOMImplementationPrototype::self(exec));
}

JSDOMImplementation::~JSDOMImplementation()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSDOMImplementation::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMImplementation, KJS::DOMObject>(exec, &JSDOMImplementationTable, this, propertyName, slot);
}

JSValue* JSDOMImplementation::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSDOMImplementation::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDOMImplementationConstructor>(exec, "[[DOMImplementation.constructor]]");
}
JSValue* JSDOMImplementationPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDOMImplementation::info))
      return throwError(exec, TypeError);

    DOMImplementation* imp = static_cast<DOMImplementation*>(static_cast<JSDOMImplementation*>(thisObj)->impl());

    switch (id) {
    case JSDOMImplementation::HasFeatureFuncNum: {
        String feature = args[0]->toString(exec);
        String version = valueToStringWithNullCheck(exec, args[1]);


        KJS::JSValue* result = jsBoolean(imp->hasFeature(feature, version));
        return result;
    }
    case JSDOMImplementation::CreateDocumentTypeFuncNum: {
        ExceptionCode ec = 0;
        String qualifiedName = args[0]->toString(exec);
        String publicId = args[1]->toString(exec);
        String systemId = args[2]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createDocumentType(qualifiedName, publicId, systemId, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDOMImplementation::CreateDocumentFuncNum: {
        ExceptionCode ec = 0;
        String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
        String qualifiedName = valueToStringWithNullCheck(exec, args[1]);
        DocumentType* doctype = toDocumentType(args[2]);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createDocument(namespaceURI, qualifiedName, doctype, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDOMImplementation::CreateCSSStyleSheetFuncNum: {
        ExceptionCode ec = 0;
        String title = args[0]->toString(exec);
        String media = args[1]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createCSSStyleSheet(title, media, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDOMImplementation::CreateHTMLDocumentFuncNum: {
        String title = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createHTMLDocument(title)));
        return result;
    }
    }
    return 0;
}
KJS::JSValue* toJS(KJS::ExecState* exec, DOMImplementation* obj)
{
    return KJS::cacheDOMObject<DOMImplementation, JSDOMImplementation>(exec, obj);
}
DOMImplementation* toDOMImplementation(KJS::JSValue* val)
{
    return val->isObject(&JSDOMImplementation::info) ? static_cast<JSDOMImplementation*>(val)->impl() : 0;
}

}
