/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGMaskElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGStringList.h"
#include "PlatformString.h"
#include "SVGMaskElement.h"
#include "SVGStringList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGMaskElementTableEntries[] =
{
    { "systemLanguage", JSSVGMaskElement::SystemLanguageAttrNum, DontDelete|ReadOnly, 0, &JSSVGMaskElementTableEntries[14] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "requiredFeatures", JSSVGMaskElement::RequiredFeaturesAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "y", JSSVGMaskElement::YAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "x", JSSVGMaskElement::XAttrNum, DontDelete|ReadOnly, 0, &JSSVGMaskElementTableEntries[12] },
    { "className", JSSVGMaskElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "width", JSSVGMaskElement::WidthAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "xmlspace", JSSVGMaskElement::XmlspaceAttrNum, DontDelete, 0, &JSSVGMaskElementTableEntries[16] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "height", JSSVGMaskElement::HeightAttrNum, DontDelete|ReadOnly, 0, &JSSVGMaskElementTableEntries[13] },
    { "requiredExtensions", JSSVGMaskElement::RequiredExtensionsAttrNum, DontDelete|ReadOnly, 0, &JSSVGMaskElementTableEntries[15] },
    { "xmllang", JSSVGMaskElement::XmllangAttrNum, DontDelete, 0, 0 },
    { "externalResourcesRequired", JSSVGMaskElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "style", JSSVGMaskElement::StyleAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGMaskElementTable = 
{
    2, 17, JSSVGMaskElementTableEntries, 12
};

/* Hash table for prototype */

static const HashEntry JSSVGMaskElementPrototypeTableEntries[] =
{
    { "hasExtension", JSSVGMaskElement::HasExtensionFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSSVGMaskElementPrototypeTable = 
{
    2, 1, JSSVGMaskElementPrototypeTableEntries, 1
};

const ClassInfo JSSVGMaskElementPrototype::info = { "SVGMaskElementPrototype", 0, &JSSVGMaskElementPrototypeTable, 0 };

JSObject* JSSVGMaskElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGMaskElementPrototype>(exec, "[[JSSVGMaskElement.prototype]]");
}

bool JSSVGMaskElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGMaskElementPrototypeFunction, JSObject>(exec, &JSSVGMaskElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGMaskElement::info = { "SVGMaskElement", &JSSVGElement::info, &JSSVGMaskElementTable, 0 };

JSSVGMaskElement::JSSVGMaskElement(ExecState* exec, SVGMaskElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGMaskElementPrototype::self(exec));
}

bool JSSVGMaskElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGMaskElement, JSSVGElement>(exec, &JSSVGMaskElementTable, this, propertyName, slot);
}

JSValue* JSSVGMaskElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case XAttrNum: {
        SVGMaskElement* imp = static_cast<SVGMaskElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case YAttrNum: {
        SVGMaskElement* imp = static_cast<SVGMaskElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case WidthAttrNum: {
        SVGMaskElement* imp = static_cast<SVGMaskElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case HeightAttrNum: {
        SVGMaskElement* imp = static_cast<SVGMaskElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case RequiredFeaturesAttrNum: {
        SVGMaskElement* imp = static_cast<SVGMaskElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredFeatures()));
    }
    case RequiredExtensionsAttrNum: {
        SVGMaskElement* imp = static_cast<SVGMaskElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredExtensions()));
    }
    case SystemLanguageAttrNum: {
        SVGMaskElement* imp = static_cast<SVGMaskElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->systemLanguage()));
    }
    case XmllangAttrNum: {
        SVGMaskElement* imp = static_cast<SVGMaskElement*>(impl());

        return jsString(imp->xmllang());
    }
    case XmlspaceAttrNum: {
        SVGMaskElement* imp = static_cast<SVGMaskElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGMaskElement* imp = static_cast<SVGMaskElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ClassNameAttrNum: {
        SVGMaskElement* imp = static_cast<SVGMaskElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGMaskElement* imp = static_cast<SVGMaskElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    }
    return 0;
}

void JSSVGMaskElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGMaskElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGMaskElementTable, this);
}

void JSSVGMaskElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XmllangAttrNum: {
        SVGMaskElement* imp = static_cast<SVGMaskElement*>(impl());

        imp->setXmllang(value->toString(exec));
        break;
    }
    case XmlspaceAttrNum: {
        SVGMaskElement* imp = static_cast<SVGMaskElement*>(impl());

        imp->setXmlspace(value->toString(exec));
        break;
    }
    }
}

JSValue* JSSVGMaskElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGMaskElement::info))
      return throwError(exec, TypeError);

    SVGMaskElement* imp = static_cast<SVGMaskElement*>(static_cast<JSSVGMaskElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGMaskElement::HasExtensionFuncNum: {
        String extension = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasExtension(extension));
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
