/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG) && ENABLE(SVG_EXPERIMENTAL_FEATURES)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGForeignObjectElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "PlatformString.h"
#include "SVGElement.h"
#include "SVGForeignObjectElement.h"
#include "SVGStringList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGForeignObjectElementTableEntries[] =
{
    { "xmllang", JSSVGForeignObjectElement::XmllangAttrNum, DontDelete, 0, 0 },
    { "y", JSSVGForeignObjectElement::YAttrNum, DontDelete|ReadOnly, 0, &JSSVGForeignObjectElementTableEntries[15] },
    { "height", JSSVGForeignObjectElement::HeightAttrNum, DontDelete|ReadOnly, 0, &JSSVGForeignObjectElementTableEntries[18] },
    { 0, 0, 0, 0, 0 },
    { "transform", JSSVGForeignObjectElement::TransformAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "externalResourcesRequired", JSSVGForeignObjectElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "className", JSSVGForeignObjectElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, &JSSVGForeignObjectElementTableEntries[19] },
    { 0, 0, 0, 0, 0 },
    { "x", JSSVGForeignObjectElement::XAttrNum, DontDelete|ReadOnly, 0, &JSSVGForeignObjectElementTableEntries[16] },
    { "requiredFeatures", JSSVGForeignObjectElement::RequiredFeaturesAttrNum, DontDelete|ReadOnly, 0, &JSSVGForeignObjectElementTableEntries[17] },
    { 0, 0, 0, 0, 0 },
    { "style", JSSVGForeignObjectElement::StyleAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "farthestViewportElement", JSSVGForeignObjectElement::FarthestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "width", JSSVGForeignObjectElement::WidthAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "requiredExtensions", JSSVGForeignObjectElement::RequiredExtensionsAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "systemLanguage", JSSVGForeignObjectElement::SystemLanguageAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "xmlspace", JSSVGForeignObjectElement::XmlspaceAttrNum, DontDelete, 0, 0 },
    { "nearestViewportElement", JSSVGForeignObjectElement::NearestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGForeignObjectElementTable = 
{
    2, 20, JSSVGForeignObjectElementTableEntries, 15
};

/* Hash table for prototype */

static const HashEntry JSSVGForeignObjectElementPrototypeTableEntries[] =
{
    { "hasExtension", JSSVGForeignObjectElement::HasExtensionFuncNum, DontDelete|Function, 1, &JSSVGForeignObjectElementPrototypeTableEntries[6] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "getBBox", JSSVGForeignObjectElement::GetBBoxFuncNum, DontDelete|Function, 0, &JSSVGForeignObjectElementPrototypeTableEntries[5] },
    { "getTransformToElement", JSSVGForeignObjectElement::GetTransformToElementFuncNum, DontDelete|Function, 1, 0 },
    { "getCTM", JSSVGForeignObjectElement::GetCTMFuncNum, DontDelete|Function, 0, 0 },
    { "getScreenCTM", JSSVGForeignObjectElement::GetScreenCTMFuncNum, DontDelete|Function, 0, 0 }
};

static const HashTable JSSVGForeignObjectElementPrototypeTable = 
{
    2, 7, JSSVGForeignObjectElementPrototypeTableEntries, 5
};

const ClassInfo JSSVGForeignObjectElementPrototype::info = { "SVGForeignObjectElementPrototype", 0, &JSSVGForeignObjectElementPrototypeTable, 0 };

JSObject* JSSVGForeignObjectElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGForeignObjectElementPrototype>(exec, "[[JSSVGForeignObjectElement.prototype]]");
}

bool JSSVGForeignObjectElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGForeignObjectElementPrototypeFunction, JSObject>(exec, &JSSVGForeignObjectElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGForeignObjectElement::info = { "SVGForeignObjectElement", &JSSVGElement::info, &JSSVGForeignObjectElementTable, 0 };

JSSVGForeignObjectElement::JSSVGForeignObjectElement(ExecState* exec, SVGForeignObjectElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGForeignObjectElementPrototype::self(exec));
}

bool JSSVGForeignObjectElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGForeignObjectElement, JSSVGElement>(exec, &JSSVGForeignObjectElementTable, this, propertyName, slot);
}

JSValue* JSSVGForeignObjectElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case XAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case YAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case WidthAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case HeightAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case RequiredFeaturesAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredFeatures()));
    }
    case RequiredExtensionsAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredExtensions()));
    }
    case SystemLanguageAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->systemLanguage()));
    }
    case XmllangAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        return jsString(imp->xmllang());
    }
    case XmlspaceAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ClassNameAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case TransformAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedTransformList>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedTransformList>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedTransformList>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case NearestViewportElementAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
    }
    case FarthestViewportElementAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
    }
    }
    return 0;
}

void JSSVGForeignObjectElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGForeignObjectElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGForeignObjectElementTable, this);
}

void JSSVGForeignObjectElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XmllangAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        imp->setXmllang(value->toString(exec));
        break;
    }
    case XmlspaceAttrNum: {
        SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(impl());

        imp->setXmlspace(value->toString(exec));
        break;
    }
    }
}

JSValue* JSSVGForeignObjectElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGForeignObjectElement::info))
      return throwError(exec, TypeError);

    SVGForeignObjectElement* imp = static_cast<SVGForeignObjectElement*>(static_cast<JSSVGForeignObjectElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGForeignObjectElement::HasExtensionFuncNum: {
        String extension = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasExtension(extension));
        return result;
    }
    case JSSVGForeignObjectElement::GetBBoxFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatRect>(imp->getBBox()));
        return result;
    }
    case JSSVGForeignObjectElement::GetCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getCTM()));
        return result;
    }
    case JSSVGForeignObjectElement::GetScreenCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getScreenCTM()));
        return result;
    }
    case JSSVGForeignObjectElement::GetTransformToElementFuncNum: {
        ExceptionCode ec = 0;
        SVGElement* element = toSVGElement(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getTransformToElement(element, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG) && ENABLE(SVG_EXPERIMENTAL_FEATURES)
