/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSNotation.h"

#include <wtf/GetPtr.h>

#include "Notation.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSNotationTableEntries[] =
{
    { "publicId", JSNotation::PublicIdAttrNum, DontDelete|ReadOnly, 0, &JSNotationTableEntries[3] },
    { "systemId", JSNotation::SystemIdAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "constructor", JSNotation::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSNotationTable = 
{
    2, 4, JSNotationTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSNotationConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSNotationConstructorTable = 
{
    2, 1, JSNotationConstructorTableEntries, 1
};

class JSNotationConstructor : public DOMObject {
public:
    JSNotationConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSNotationPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSNotationConstructor::info = { "NotationConstructor", 0, &JSNotationConstructorTable, 0 };

bool JSNotationConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNotationConstructor, DOMObject>(exec, &JSNotationConstructorTable, this, propertyName, slot);
}

JSValue* JSNotationConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSNotationPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSNotationPrototypeTable = 
{
    2, 1, JSNotationPrototypeTableEntries, 1
};

const ClassInfo JSNotationPrototype::info = { "NotationPrototype", 0, &JSNotationPrototypeTable, 0 };

JSObject* JSNotationPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSNotationPrototype>(exec, "[[JSNotation.prototype]]");
}

const ClassInfo JSNotation::info = { "Notation", &JSNode::info, &JSNotationTable, 0 };

JSNotation::JSNotation(ExecState* exec, Notation* impl)
    : JSNode(exec, impl)
{
    setPrototype(JSNotationPrototype::self(exec));
}

bool JSNotation::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNotation, JSNode>(exec, &JSNotationTable, this, propertyName, slot);
}

JSValue* JSNotation::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case PublicIdAttrNum: {
        Notation* imp = static_cast<Notation*>(impl());

        return jsStringOrNull(imp->publicId());
    }
    case SystemIdAttrNum: {
        Notation* imp = static_cast<Notation*>(impl());

        return jsStringOrNull(imp->systemId());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSNotation::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSNotationConstructor>(exec, "[[Notation.constructor]]");
}

}
