/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGPathSeg.h"

#include <wtf/GetPtr.h>

#include "PlatformString.h"
#include "SVGPathSeg.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGPathSegTableEntries[] =
{
    { "constructor", JSSVGPathSeg::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 },
    { "pathSegType", JSSVGPathSeg::PathSegTypeAttrNum, DontDelete|ReadOnly, 0, &JSSVGPathSegTableEntries[3] },
    { 0, 0, 0, 0, 0 },
    { "pathSegTypeAsLetter", JSSVGPathSeg::PathSegTypeAsLetterAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGPathSegTable = 
{
    2, 4, JSSVGPathSegTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSSVGPathSegConstructorTableEntries[] =
{
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_ABS", SVGPathSeg::PATHSEG_CURVETO_CUBIC_SMOOTH_ABS, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_MOVETO_REL", SVGPathSeg::PATHSEG_MOVETO_REL, DontDelete|ReadOnly, 0, &JSSVGPathSegConstructorTableEntries[21] },
    { 0, 0, 0, 0, 0 },
    { "PATHSEG_LINETO_VERTICAL_REL", SVGPathSeg::PATHSEG_LINETO_VERTICAL_REL, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_CLOSEPATH", SVGPathSeg::PATHSEG_CLOSEPATH, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_ARC_ABS", SVGPathSeg::PATHSEG_ARC_ABS, DontDelete|ReadOnly, 0, &JSSVGPathSegConstructorTableEntries[23] },
    { "PATHSEG_CURVETO_CUBIC_ABS", SVGPathSeg::PATHSEG_CURVETO_CUBIC_ABS, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_LINETO_ABS", SVGPathSeg::PATHSEG_LINETO_ABS, DontDelete|ReadOnly, 0, &JSSVGPathSegConstructorTableEntries[22] },
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_REL", SVGPathSeg::PATHSEG_CURVETO_CUBIC_SMOOTH_REL, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "PATHSEG_CURVETO_CUBIC_REL", SVGPathSeg::PATHSEG_CURVETO_CUBIC_REL, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "PATHSEG_CURVETO_QUADRATIC_ABS", SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_ABS, DontDelete|ReadOnly, 0, &JSSVGPathSegConstructorTableEntries[24] },
    { "PATHSEG_UNKNOWN", SVGPathSeg::PATHSEG_UNKNOWN, DontDelete|ReadOnly, 0, &JSSVGPathSegConstructorTableEntries[20] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "PATHSEG_MOVETO_ABS", SVGPathSeg::PATHSEG_MOVETO_ABS, DontDelete|ReadOnly, 0, &JSSVGPathSegConstructorTableEntries[27] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "PATHSEG_LINETO_REL", SVGPathSeg::PATHSEG_LINETO_REL, DontDelete|ReadOnly, 0, &JSSVGPathSegConstructorTableEntries[25] },
    { "PATHSEG_CURVETO_QUADRATIC_REL", SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_REL, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_ARC_REL", SVGPathSeg::PATHSEG_ARC_REL, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_LINETO_HORIZONTAL_ABS", SVGPathSeg::PATHSEG_LINETO_HORIZONTAL_ABS, DontDelete|ReadOnly, 0, &JSSVGPathSegConstructorTableEntries[26] },
    { "PATHSEG_LINETO_HORIZONTAL_REL", SVGPathSeg::PATHSEG_LINETO_HORIZONTAL_REL, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_LINETO_VERTICAL_ABS", SVGPathSeg::PATHSEG_LINETO_VERTICAL_ABS, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS", SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL", SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGPathSegConstructorTable = 
{
    2, 28, JSSVGPathSegConstructorTableEntries, 20
};

class JSSVGPathSegConstructor : public DOMObject {
public:
    JSSVGPathSegConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSSVGPathSegPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSSVGPathSegConstructor::info = { "SVGPathSegConstructor", 0, &JSSVGPathSegConstructorTable, 0 };

bool JSSVGPathSegConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathSegConstructor, DOMObject>(exec, &JSSVGPathSegConstructorTable, this, propertyName, slot);
}

JSValue* JSSVGPathSegConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSSVGPathSegPrototypeTableEntries[] =
{
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_ABS", SVGPathSeg::PATHSEG_CURVETO_CUBIC_SMOOTH_ABS, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_MOVETO_REL", SVGPathSeg::PATHSEG_MOVETO_REL, DontDelete|ReadOnly, 0, &JSSVGPathSegPrototypeTableEntries[21] },
    { 0, 0, 0, 0, 0 },
    { "PATHSEG_LINETO_VERTICAL_REL", SVGPathSeg::PATHSEG_LINETO_VERTICAL_REL, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_CLOSEPATH", SVGPathSeg::PATHSEG_CLOSEPATH, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_ARC_ABS", SVGPathSeg::PATHSEG_ARC_ABS, DontDelete|ReadOnly, 0, &JSSVGPathSegPrototypeTableEntries[23] },
    { "PATHSEG_CURVETO_CUBIC_ABS", SVGPathSeg::PATHSEG_CURVETO_CUBIC_ABS, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_LINETO_ABS", SVGPathSeg::PATHSEG_LINETO_ABS, DontDelete|ReadOnly, 0, &JSSVGPathSegPrototypeTableEntries[22] },
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_REL", SVGPathSeg::PATHSEG_CURVETO_CUBIC_SMOOTH_REL, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "PATHSEG_CURVETO_CUBIC_REL", SVGPathSeg::PATHSEG_CURVETO_CUBIC_REL, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "PATHSEG_CURVETO_QUADRATIC_ABS", SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_ABS, DontDelete|ReadOnly, 0, &JSSVGPathSegPrototypeTableEntries[24] },
    { "PATHSEG_UNKNOWN", SVGPathSeg::PATHSEG_UNKNOWN, DontDelete|ReadOnly, 0, &JSSVGPathSegPrototypeTableEntries[20] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "PATHSEG_MOVETO_ABS", SVGPathSeg::PATHSEG_MOVETO_ABS, DontDelete|ReadOnly, 0, &JSSVGPathSegPrototypeTableEntries[27] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "PATHSEG_LINETO_REL", SVGPathSeg::PATHSEG_LINETO_REL, DontDelete|ReadOnly, 0, &JSSVGPathSegPrototypeTableEntries[25] },
    { "PATHSEG_CURVETO_QUADRATIC_REL", SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_REL, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_ARC_REL", SVGPathSeg::PATHSEG_ARC_REL, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_LINETO_HORIZONTAL_ABS", SVGPathSeg::PATHSEG_LINETO_HORIZONTAL_ABS, DontDelete|ReadOnly, 0, &JSSVGPathSegPrototypeTableEntries[26] },
    { "PATHSEG_LINETO_HORIZONTAL_REL", SVGPathSeg::PATHSEG_LINETO_HORIZONTAL_REL, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_LINETO_VERTICAL_ABS", SVGPathSeg::PATHSEG_LINETO_VERTICAL_ABS, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS", SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS, DontDelete|ReadOnly, 0, 0 },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL", SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGPathSegPrototypeTable = 
{
    2, 28, JSSVGPathSegPrototypeTableEntries, 20
};

const ClassInfo JSSVGPathSegPrototype::info = { "SVGPathSegPrototype", 0, &JSSVGPathSegPrototypeTable, 0 };

JSObject* JSSVGPathSegPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGPathSegPrototype>(exec, "[[JSSVGPathSeg.prototype]]");
}

bool JSSVGPathSegPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathSegPrototype, JSObject>(exec, &JSSVGPathSegPrototypeTable, this, propertyName, slot);
}

JSValue* JSSVGPathSegPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSSVGPathSeg::info = { "SVGPathSeg", 0, &JSSVGPathSegTable, 0 };

JSSVGPathSeg::JSSVGPathSeg(ExecState* exec, SVGPathSeg* impl)
    : m_impl(impl)
{
    setPrototype(JSSVGPathSegPrototype::self(exec));
}

JSSVGPathSeg::~JSSVGPathSeg()
{
    SVGDocumentExtensions::forgetGenericContext<SVGPathSeg>(m_impl.get());
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSSVGPathSeg::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathSeg, KJS::DOMObject>(exec, &JSSVGPathSegTable, this, propertyName, slot);
}

JSValue* JSSVGPathSeg::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case PathSegTypeAttrNum: {
        SVGPathSeg* imp = static_cast<SVGPathSeg*>(impl());

        return jsNumber(imp->pathSegType());
    }
    case PathSegTypeAsLetterAttrNum: {
        SVGPathSeg* imp = static_cast<SVGPathSeg*>(impl());

        return jsString(imp->pathSegTypeAsLetter());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSSVGPathSeg::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGPathSegConstructor>(exec, "[[SVGPathSeg.constructor]]");
}
SVGPathSeg* toSVGPathSeg(KJS::JSValue* val)
{
    return val->isObject(&JSSVGPathSeg::info) ? static_cast<JSSVGPathSeg*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
