/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGPaint.h"

#include <wtf/GetPtr.h>

#include "PlatformString.h"
#include "SVGPaint.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGPaintTableEntries[] =
{
    { "paintType", JSSVGPaint::PaintTypeAttrNum, DontDelete|ReadOnly, 0, &JSSVGPaintTableEntries[3] },
    { 0, 0, 0, 0, 0 },
    { "uri", JSSVGPaint::UriAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "constructor", JSSVGPaint::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSSVGPaintTable = 
{
    2, 4, JSSVGPaintTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSSVGPaintConstructorTableEntries[] =
{
    { "SVG_PAINTTYPE_URI_CURRENTCOLOR", SVGPaint::SVG_PAINTTYPE_URI_CURRENTCOLOR, DontDelete|ReadOnly, 0, 0 },
    { "SVG_PAINTTYPE_NONE", SVGPaint::SVG_PAINTTYPE_NONE, DontDelete|ReadOnly, 0, 0 },
    { "SVG_PAINTTYPE_RGBCOLOR", SVGPaint::SVG_PAINTTYPE_RGBCOLOR, DontDelete|ReadOnly, 0, &JSSVGPaintConstructorTableEntries[10] },
    { 0, 0, 0, 0, 0 },
    { "SVG_PAINTTYPE_RGBCOLOR_ICCCOLOR", SVGPaint::SVG_PAINTTYPE_RGBCOLOR_ICCCOLOR, DontDelete|ReadOnly, 0, 0 },
    { "SVG_PAINTTYPE_UNKNOWN", SVGPaint::SVG_PAINTTYPE_UNKNOWN, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "SVG_PAINTTYPE_URI_NONE", SVGPaint::SVG_PAINTTYPE_URI_NONE, DontDelete|ReadOnly, 0, 0 },
    { "SVG_PAINTTYPE_URI_RGBCOLOR", SVGPaint::SVG_PAINTTYPE_URI_RGBCOLOR, DontDelete|ReadOnly, 0, &JSSVGPaintConstructorTableEntries[11] },
    { "SVG_PAINTTYPE_URI_RGBCOLOR_ICCCOLOR", SVGPaint::SVG_PAINTTYPE_URI_RGBCOLOR_ICCCOLOR, DontDelete|ReadOnly, 0, 0 },
    { "SVG_PAINTTYPE_CURRENTCOLOR", SVGPaint::SVG_PAINTTYPE_CURRENTCOLOR, DontDelete|ReadOnly, 0, 0 },
    { "SVG_PAINTTYPE_URI", SVGPaint::SVG_PAINTTYPE_URI, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGPaintConstructorTable = 
{
    2, 12, JSSVGPaintConstructorTableEntries, 10
};

class JSSVGPaintConstructor : public DOMObject {
public:
    JSSVGPaintConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSSVGPaintPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSSVGPaintConstructor::info = { "SVGPaintConstructor", 0, &JSSVGPaintConstructorTable, 0 };

bool JSSVGPaintConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPaintConstructor, DOMObject>(exec, &JSSVGPaintConstructorTable, this, propertyName, slot);
}

JSValue* JSSVGPaintConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSSVGPaintPrototypeTableEntries[] =
{
    { "SVG_PAINTTYPE_URI_CURRENTCOLOR", SVGPaint::SVG_PAINTTYPE_URI_CURRENTCOLOR, DontDelete|ReadOnly, 0, 0 },
    { "SVG_PAINTTYPE_NONE", SVGPaint::SVG_PAINTTYPE_NONE, DontDelete|ReadOnly, 0, 0 },
    { "SVG_PAINTTYPE_CURRENTCOLOR", SVGPaint::SVG_PAINTTYPE_CURRENTCOLOR, DontDelete|ReadOnly, 0, 0 },
    { "setUri", JSSVGPaint::SetUriFuncNum, DontDelete|Function, 1, 0 },
    { "SVG_PAINTTYPE_RGBCOLOR_ICCCOLOR", SVGPaint::SVG_PAINTTYPE_RGBCOLOR_ICCCOLOR, DontDelete|ReadOnly, 0, &JSSVGPaintPrototypeTableEntries[13] },
    { 0, 0, 0, 0, 0 },
    { "SVG_PAINTTYPE_RGBCOLOR", SVGPaint::SVG_PAINTTYPE_RGBCOLOR, DontDelete|ReadOnly, 0, &JSSVGPaintPrototypeTableEntries[12] },
    { "SVG_PAINTTYPE_URI_RGBCOLOR_ICCCOLOR", SVGPaint::SVG_PAINTTYPE_URI_RGBCOLOR_ICCCOLOR, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "SVG_PAINTTYPE_UNKNOWN", SVGPaint::SVG_PAINTTYPE_UNKNOWN, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "SVG_PAINTTYPE_URI_NONE", SVGPaint::SVG_PAINTTYPE_URI_NONE, DontDelete|ReadOnly, 0, 0 },
    { "SVG_PAINTTYPE_URI_RGBCOLOR", SVGPaint::SVG_PAINTTYPE_URI_RGBCOLOR, DontDelete|ReadOnly, 0, 0 },
    { "SVG_PAINTTYPE_URI", SVGPaint::SVG_PAINTTYPE_URI, DontDelete|ReadOnly, 0, &JSSVGPaintPrototypeTableEntries[14] },
    { "setPaint", JSSVGPaint::SetPaintFuncNum, DontDelete|Function, 4, 0 }
};

static const HashTable JSSVGPaintPrototypeTable = 
{
    2, 15, JSSVGPaintPrototypeTableEntries, 12
};

const ClassInfo JSSVGPaintPrototype::info = { "SVGPaintPrototype", 0, &JSSVGPaintPrototypeTable, 0 };

JSObject* JSSVGPaintPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGPaintPrototype>(exec, "[[JSSVGPaint.prototype]]");
}

bool JSSVGPaintPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGPaintPrototypeFunction, JSSVGPaintPrototype, JSObject>(exec, &JSSVGPaintPrototypeTable, this, propertyName, slot);
}

JSValue* JSSVGPaintPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSSVGPaint::info = { "SVGPaint", &JSSVGColor::info, &JSSVGPaintTable, 0 };

JSSVGPaint::JSSVGPaint(ExecState* exec, SVGPaint* impl)
    : JSSVGColor(exec, impl)
{
    setPrototype(JSSVGPaintPrototype::self(exec));
}

bool JSSVGPaint::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPaint, JSSVGColor>(exec, &JSSVGPaintTable, this, propertyName, slot);
}

JSValue* JSSVGPaint::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case PaintTypeAttrNum: {
        SVGPaint* imp = static_cast<SVGPaint*>(impl());

        return jsNumber(imp->paintType());
    }
    case UriAttrNum: {
        SVGPaint* imp = static_cast<SVGPaint*>(impl());

        return jsString(imp->uri());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSSVGPaint::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGPaintConstructor>(exec, "[[SVGPaint.constructor]]");
}
JSValue* JSSVGPaintPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGPaint::info))
      return throwError(exec, TypeError);

    SVGPaint* imp = static_cast<SVGPaint*>(static_cast<JSSVGPaint*>(thisObj)->impl());

    switch (id) {
    case JSSVGPaint::SetUriFuncNum: {
        String uri = args[0]->toString(exec);

        imp->setUri(uri);
        return jsUndefined();
    }
    case JSSVGPaint::SetPaintFuncNum: {
        ExceptionCode ec = 0;
        SVGPaint::SVGPaintType paintType = static_cast<SVGPaint::SVGPaintType>(args[0]->toInt32(exec));
        String uri = args[1]->toString(exec);
        String rgbColor = args[2]->toString(exec);
        String iccColor = args[3]->toString(exec);

        imp->setPaint(paintType, uri, rgbColor, iccColor, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
