/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGCursorElement.h"

#include <wtf/GetPtr.h>

#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGStringList.h"
#include "SVGCursorElement.h"
#include "SVGStringList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGCursorElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "requiredFeatures", JSSVGCursorElement::RequiredFeaturesAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "x", JSSVGCursorElement::XAttrNum, DontDelete|ReadOnly, 0, &JSSVGCursorElementTableEntries[8] },
    { 0, 0, 0, 0, 0 },
    { "requiredExtensions", JSSVGCursorElement::RequiredExtensionsAttrNum, DontDelete|ReadOnly, 0, &JSSVGCursorElementTableEntries[7] },
    { "y", JSSVGCursorElement::YAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "href", JSSVGCursorElement::HrefAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "systemLanguage", JSSVGCursorElement::SystemLanguageAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "externalResourcesRequired", JSSVGCursorElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGCursorElementTable = 
{
    2, 9, JSSVGCursorElementTableEntries, 7
};

/* Hash table for prototype */

static const HashEntry JSSVGCursorElementPrototypeTableEntries[] =
{
    { "hasExtension", JSSVGCursorElement::HasExtensionFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSSVGCursorElementPrototypeTable = 
{
    2, 1, JSSVGCursorElementPrototypeTableEntries, 1
};

const ClassInfo JSSVGCursorElementPrototype::info = { "SVGCursorElementPrototype", 0, &JSSVGCursorElementPrototypeTable, 0 };

JSObject* JSSVGCursorElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGCursorElementPrototype>(exec, "[[JSSVGCursorElement.prototype]]");
}

bool JSSVGCursorElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGCursorElementPrototypeFunction, JSObject>(exec, &JSSVGCursorElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGCursorElement::info = { "SVGCursorElement", &JSSVGElement::info, &JSSVGCursorElementTable, 0 };

JSSVGCursorElement::JSSVGCursorElement(ExecState* exec, SVGCursorElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGCursorElementPrototype::self(exec));
}

bool JSSVGCursorElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGCursorElement, JSSVGElement>(exec, &JSSVGCursorElementTable, this, propertyName, slot);
}

JSValue* JSSVGCursorElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case XAttrNum: {
        SVGCursorElement* imp = static_cast<SVGCursorElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case YAttrNum: {
        SVGCursorElement* imp = static_cast<SVGCursorElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case HrefAttrNum: {
        SVGCursorElement* imp = static_cast<SVGCursorElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case RequiredFeaturesAttrNum: {
        SVGCursorElement* imp = static_cast<SVGCursorElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredFeatures()));
    }
    case RequiredExtensionsAttrNum: {
        SVGCursorElement* imp = static_cast<SVGCursorElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredExtensions()));
    }
    case SystemLanguageAttrNum: {
        SVGCursorElement* imp = static_cast<SVGCursorElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->systemLanguage()));
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGCursorElement* imp = static_cast<SVGCursorElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    }
    return 0;
}

JSValue* JSSVGCursorElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGCursorElement::info))
      return throwError(exec, TypeError);

    SVGCursorElement* imp = static_cast<SVGCursorElement*>(static_cast<JSSVGCursorElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGCursorElement::HasExtensionFuncNum: {
        String extension = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasExtension(extension));
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
