/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLHeadElement.h"

#include <wtf/GetPtr.h>

#include "HTMLHeadElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLHeadElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "profile", JSHTMLHeadElement::ProfileAttrNum, DontDelete, 0, &JSHTMLHeadElementTableEntries[2] },
    { "constructor", JSHTMLHeadElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLHeadElementTable = 
{
    2, 3, JSHTMLHeadElementTableEntries, 2
};

/* Hash table for constructor */

static const HashEntry JSHTMLHeadElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLHeadElementConstructorTable = 
{
    2, 1, JSHTMLHeadElementConstructorTableEntries, 1
};

class JSHTMLHeadElementConstructor : public DOMObject {
public:
    JSHTMLHeadElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLHeadElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLHeadElementConstructor::info = { "HTMLHeadElementConstructor", 0, &JSHTMLHeadElementConstructorTable, 0 };

bool JSHTMLHeadElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHeadElementConstructor, DOMObject>(exec, &JSHTMLHeadElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLHeadElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLHeadElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLHeadElementPrototypeTable = 
{
    2, 1, JSHTMLHeadElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLHeadElementPrototype::info = { "HTMLHeadElementPrototype", 0, &JSHTMLHeadElementPrototypeTable, 0 };

JSObject* JSHTMLHeadElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLHeadElementPrototype>(exec, "[[JSHTMLHeadElement.prototype]]");
}

const ClassInfo JSHTMLHeadElement::info = { "HTMLHeadElement", &JSHTMLElement::info, &JSHTMLHeadElementTable, 0 };

JSHTMLHeadElement::JSHTMLHeadElement(ExecState* exec, HTMLHeadElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLHeadElementPrototype::self(exec));
}

bool JSHTMLHeadElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHeadElement, JSHTMLElement>(exec, &JSHTMLHeadElementTable, this, propertyName, slot);
}

JSValue* JSHTMLHeadElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ProfileAttrNum: {
        HTMLHeadElement* imp = static_cast<HTMLHeadElement*>(impl());

        return jsString(imp->profile());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLHeadElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLHeadElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLHeadElementTable, this);
}

void JSHTMLHeadElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case ProfileAttrNum: {
        HTMLHeadElement* imp = static_cast<HTMLHeadElement*>(impl());

        imp->setProfile(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLHeadElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLHeadElementConstructor>(exec, "[[HTMLHeadElement.constructor]]");
}

}
