/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLParagraphElement.h"

#include <wtf/GetPtr.h>

#include "HTMLParagraphElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLParagraphElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "align", JSHTMLParagraphElement::AlignAttrNum, DontDelete, 0, &JSHTMLParagraphElementTableEntries[2] },
    { "constructor", JSHTMLParagraphElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLParagraphElementTable = 
{
    2, 3, JSHTMLParagraphElementTableEntries, 2
};

/* Hash table for constructor */

static const HashEntry JSHTMLParagraphElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLParagraphElementConstructorTable = 
{
    2, 1, JSHTMLParagraphElementConstructorTableEntries, 1
};

class JSHTMLParagraphElementConstructor : public DOMObject {
public:
    JSHTMLParagraphElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLParagraphElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLParagraphElementConstructor::info = { "HTMLParagraphElementConstructor", 0, &JSHTMLParagraphElementConstructorTable, 0 };

bool JSHTMLParagraphElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLParagraphElementConstructor, DOMObject>(exec, &JSHTMLParagraphElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLParagraphElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLParagraphElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLParagraphElementPrototypeTable = 
{
    2, 1, JSHTMLParagraphElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLParagraphElementPrototype::info = { "HTMLParagraphElementPrototype", 0, &JSHTMLParagraphElementPrototypeTable, 0 };

JSObject* JSHTMLParagraphElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLParagraphElementPrototype>(exec, "[[JSHTMLParagraphElement.prototype]]");
}

const ClassInfo JSHTMLParagraphElement::info = { "HTMLParagraphElement", &JSHTMLElement::info, &JSHTMLParagraphElementTable, 0 };

JSHTMLParagraphElement::JSHTMLParagraphElement(ExecState* exec, HTMLParagraphElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLParagraphElementPrototype::self(exec));
}

bool JSHTMLParagraphElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLParagraphElement, JSHTMLElement>(exec, &JSHTMLParagraphElementTable, this, propertyName, slot);
}

JSValue* JSHTMLParagraphElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AlignAttrNum: {
        HTMLParagraphElement* imp = static_cast<HTMLParagraphElement*>(impl());

        return jsString(imp->align());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLParagraphElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLParagraphElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLParagraphElementTable, this);
}

void JSHTMLParagraphElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case AlignAttrNum: {
        HTMLParagraphElement* imp = static_cast<HTMLParagraphElement*>(impl());

        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLParagraphElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLParagraphElementConstructor>(exec, "[[HTMLParagraphElement.constructor]]");
}

}
