/*
 * Copyright (C) 2005 Apple Computer, Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer. 
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#import <WebKit/WebKeyGenerator.h>

#import <JavaScriptCore/Assertions.h>
#import <WebKit/WebLocalizableStrings.h>
#import <WebKitSystemInterface.h>

@implementation WebKeyGenerator

+ (void)createSharedGenerator
{
    if (![self sharedGenerator]) {
        [[[self alloc] init] release];
    }
    ASSERT([[self sharedGenerator] isKindOfClass:self]);
}

- (void)dealloc
{
    [strengthMenuItemTitles release];
    [super dealloc];
}

- (NSArray *)strengthMenuItemTitles
{
    if (!strengthMenuItemTitles) {
        strengthMenuItemTitles = [[NSArray alloc] initWithObjects:
            UI_STRING("2048 (High Grade)", "Menu item title for KEYGEN pop-up menu"),
            UI_STRING("1024 (Medium Grade)", "Menu item title for KEYGEN pop-up menu"),
            UI_STRING("512 (Low Grade)", "Menu item title for KEYGEN pop-up menu"), nil];
    }
    return strengthMenuItemTitles;
}

- (NSString *)signedPublicKeyAndChallengeStringWithStrengthIndex:(unsigned)index challenge:(NSString *)challenge pageURL:(NSURL *)pageURL
{    
    // This switch statement must always be synced with the UI strings returned by strengthMenuItemTitles.
    UInt32 keySize;
    switch (index) {
        case 0:
            keySize = 2048;
            break;
        case 1:
            keySize = 1024;
            break;
        case 2:
            keySize = 512;
            break;
        default:
            return nil;
    }
    
    NSString *keyDescription = [NSString stringWithFormat:UI_STRING("Key from %@", "name of keychain key generated by the KEYGEN tag"), [pageURL host]];
    return [(NSString *)WKSignedPublicKeyAndChallengeString(keySize, (CFStringRef)challenge, (CFStringRef)keyDescription) autorelease];
}

- (WebCertificateParseResult)addCertificatesToKeychainFromData:(NSData *)data
{
    return WKAddCertificatesToKeychainFromData([data bytes], [data length]);
}

@end
