/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLLinkElement.h"

#include <wtf/GetPtr.h>

#include "HTMLLinkElement.h"
#include "JSStyleSheet.h"
#include "PlatformString.h"
#include "StyleSheet.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLLinkElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "constructor", JSHTMLLinkElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "charset", JSHTMLLinkElement::CharsetAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "disabled", JSHTMLLinkElement::DisabledAttrNum, DontDelete, 0, &JSHTMLLinkElementTableEntries[11] },
    { 0, 0, 0, 0, 0 },
    { "media", JSHTMLLinkElement::MediaAttrNum, DontDelete, 0, &JSHTMLLinkElementTableEntries[12] },
    { "hreflang", JSHTMLLinkElement::HreflangAttrNum, DontDelete, 0, &JSHTMLLinkElementTableEntries[13] },
    { "rel", JSHTMLLinkElement::RelAttrNum, DontDelete, 0, 0 },
    { "href", JSHTMLLinkElement::HrefAttrNum, DontDelete, 0, &JSHTMLLinkElementTableEntries[14] },
    { "rev", JSHTMLLinkElement::RevAttrNum, DontDelete, 0, 0 },
    { "target", JSHTMLLinkElement::TargetAttrNum, DontDelete, 0, 0 },
    { "type", JSHTMLLinkElement::TypeAttrNum, DontDelete, 0, &JSHTMLLinkElementTableEntries[15] },
    { "sheet", JSHTMLLinkElement::SheetAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLLinkElementTable = 
{
    2, 16, JSHTMLLinkElementTableEntries, 11
};

/* Hash table for constructor */

static const HashEntry JSHTMLLinkElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLLinkElementConstructorTable = 
{
    2, 1, JSHTMLLinkElementConstructorTableEntries, 1
};

class JSHTMLLinkElementConstructor : public DOMObject {
public:
    JSHTMLLinkElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLLinkElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLLinkElementConstructor::info = { "HTMLLinkElementConstructor", 0, &JSHTMLLinkElementConstructorTable, 0 };

bool JSHTMLLinkElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLinkElementConstructor, DOMObject>(exec, &JSHTMLLinkElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLLinkElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLLinkElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLLinkElementPrototypeTable = 
{
    2, 1, JSHTMLLinkElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLLinkElementPrototype::info = { "HTMLLinkElementPrototype", 0, &JSHTMLLinkElementPrototypeTable, 0 };

JSObject* JSHTMLLinkElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLLinkElementPrototype>(exec, "[[JSHTMLLinkElement.prototype]]");
}

const ClassInfo JSHTMLLinkElement::info = { "HTMLLinkElement", &JSHTMLElement::info, &JSHTMLLinkElementTable, 0 };

JSHTMLLinkElement::JSHTMLLinkElement(ExecState* exec, HTMLLinkElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLLinkElementPrototype::self(exec));
}

bool JSHTMLLinkElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLinkElement, JSHTMLElement>(exec, &JSHTMLLinkElementTable, this, propertyName, slot);
}

JSValue* JSHTMLLinkElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case DisabledAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        return jsBoolean(imp->disabled());
    }
    case CharsetAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        return jsString(imp->charset());
    }
    case HrefAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        return jsString(imp->href());
    }
    case HreflangAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        return jsString(imp->hreflang());
    }
    case MediaAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        return jsString(imp->media());
    }
    case RelAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        return jsString(imp->rel());
    }
    case RevAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        return jsString(imp->rev());
    }
    case TargetAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        return jsString(imp->target());
    }
    case TypeAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        return jsString(imp->type());
    }
    case SheetAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->sheet()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLLinkElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLLinkElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLLinkElementTable, this);
}

void JSHTMLLinkElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case DisabledAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        imp->setDisabled(value->toBoolean(exec));
        break;
    }
    case CharsetAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        imp->setCharset(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HrefAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        imp->setHref(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HreflangAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        imp->setHreflang(valueToStringWithNullCheck(exec, value));
        break;
    }
    case MediaAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        imp->setMedia(valueToStringWithNullCheck(exec, value));
        break;
    }
    case RelAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        imp->setRel(valueToStringWithNullCheck(exec, value));
        break;
    }
    case RevAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        imp->setRev(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TargetAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        imp->setTarget(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TypeAttrNum: {
        HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(impl());

        imp->setType(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLLinkElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLLinkElementConstructor>(exec, "[[HTMLLinkElement.constructor]]");
}

}
