/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSText.h"

#include <wtf/GetPtr.h>

#include "ExceptionCode.h"
#include "JSText.h"
#include "Text.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSTextTableEntries[] =
{
    { "constructor", JSText::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSTextTable = 
{
    2, 1, JSTextTableEntries, 1
};

/* Hash table for constructor */

static const HashEntry JSTextConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSTextConstructorTable = 
{
    2, 1, JSTextConstructorTableEntries, 1
};

class JSTextConstructor : public DOMObject {
public:
    JSTextConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSTextPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSTextConstructor::info = { "TextConstructor", 0, &JSTextConstructorTable, 0 };

bool JSTextConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTextConstructor, DOMObject>(exec, &JSTextConstructorTable, this, propertyName, slot);
}

JSValue* JSTextConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSTextPrototypeTableEntries[] =
{
    { "splitText", JSText::SplitTextFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSTextPrototypeTable = 
{
    2, 1, JSTextPrototypeTableEntries, 1
};

const ClassInfo JSTextPrototype::info = { "TextPrototype", 0, &JSTextPrototypeTable, 0 };

JSObject* JSTextPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSTextPrototype>(exec, "[[JSText.prototype]]");
}

bool JSTextPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSTextPrototypeFunction, JSObject>(exec, &JSTextPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSText::info = { "Text", &JSCharacterData::info, &JSTextTable, 0 };

JSText::JSText(ExecState* exec, Text* impl)
    : JSCharacterData(exec, impl)
{
    setPrototype(JSTextPrototype::self(exec));
}

bool JSText::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSText, JSCharacterData>(exec, &JSTextTable, this, propertyName, slot);
}

JSValue* JSText::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSText::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSTextConstructor>(exec, "[[Text.constructor]]");
}
JSValue* JSTextPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSText::info))
      return throwError(exec, TypeError);

    Text* imp = static_cast<Text*>(static_cast<JSText*>(thisObj)->impl());

    switch (id) {
    case JSText::SplitTextFuncNum: {
        ExceptionCode ec = 0;
        bool offsetOk;
        int offset = args[0]->toInt32(exec, offsetOk);
        if (!offsetOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }
        if (offset < 0) {
            setDOMException(exec, INDEX_SIZE_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->splitText(offset, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}

}
