/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGSVGElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "ExceptionCode.h"
#include "FloatRect.h"
#include "JSCSSStyleDeclaration.h"
#include "JSNodeList.h"
#include "JSSVGAngle.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGElement.h"
#include "JSSVGLength.h"
#include "JSSVGMatrix.h"
#include "JSSVGNumber.h"
#include "JSSVGPoint.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "JSSVGTransform.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "PlatformString.h"
#include "SVGAngle.h"
#include "SVGElement.h"
#include "SVGLength.h"
#include "SVGSVGElement.h"
#include "SVGStringList.h"
#include "SVGTransform.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGSVGElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "x", JSSVGSVGElement::XAttrNum, DontDelete|ReadOnly, 0, &JSSVGSVGElementTableEntries[28] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "screenPixelToMillimeterY", JSSVGSVGElement::ScreenPixelToMillimeterYAttrNum, DontDelete|ReadOnly, 0, &JSSVGSVGElementTableEntries[36] },
    { "viewBox", JSSVGSVGElement::ViewBoxAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "externalResourcesRequired", JSSVGSVGElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "requiredFeatures", JSSVGSVGElement::RequiredFeaturesAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "farthestViewportElement", JSSVGSVGElement::FarthestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "pixelUnitToMillimeterX", JSSVGSVGElement::PixelUnitToMillimeterXAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "pixelUnitToMillimeterY", JSSVGSVGElement::PixelUnitToMillimeterYAttrNum, DontDelete|ReadOnly, 0, &JSSVGSVGElementTableEntries[31] },
    { 0, 0, 0, 0, 0 },
    { "style", JSSVGSVGElement::StyleAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "nearestViewportElement", JSSVGSVGElement::NearestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "zoomAndPan", JSSVGSVGElement::ZoomAndPanAttrNum, DontDelete, 0, 0 },
    { "screenPixelToMillimeterX", JSSVGSVGElement::ScreenPixelToMillimeterXAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "contentStyleType", JSSVGSVGElement::ContentStyleTypeAttrNum, DontDelete, 0, &JSSVGSVGElementTableEntries[33] },
    { "y", JSSVGSVGElement::YAttrNum, DontDelete|ReadOnly, 0, &JSSVGSVGElementTableEntries[27] },
    { 0, 0, 0, 0, 0 },
    { "xmllang", JSSVGSVGElement::XmllangAttrNum, DontDelete, 0, 0 },
    { "viewport", JSSVGSVGElement::ViewportAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "currentTranslate", JSSVGSVGElement::CurrentTranslateAttrNum, DontDelete|ReadOnly, 0, &JSSVGSVGElementTableEntries[32] },
    { "width", JSSVGSVGElement::WidthAttrNum, DontDelete|ReadOnly, 0, &JSSVGSVGElementTableEntries[30] },
    { "height", JSSVGSVGElement::HeightAttrNum, DontDelete|ReadOnly, 0, &JSSVGSVGElementTableEntries[29] },
    { "contentScriptType", JSSVGSVGElement::ContentScriptTypeAttrNum, DontDelete, 0, &JSSVGSVGElementTableEntries[34] },
    { "useCurrentView", JSSVGSVGElement::UseCurrentViewAttrNum, DontDelete, 0, 0 },
    { "currentScale", JSSVGSVGElement::CurrentScaleAttrNum, DontDelete, 0, 0 },
    { "requiredExtensions", JSSVGSVGElement::RequiredExtensionsAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "systemLanguage", JSSVGSVGElement::SystemLanguageAttrNum, DontDelete|ReadOnly, 0, &JSSVGSVGElementTableEntries[35] },
    { "xmlspace", JSSVGSVGElement::XmlspaceAttrNum, DontDelete, 0, 0 },
    { "className", JSSVGSVGElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "preserveAspectRatio", JSSVGSVGElement::PreserveAspectRatioAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGSVGElementTable = 
{
    2, 37, JSSVGSVGElementTableEntries, 27
};

/* Hash table for prototype */

static const HashEntry JSSVGSVGElementPrototypeTableEntries[] =
{
    { "createSVGNumber", JSSVGSVGElement::CreateSVGNumberFuncNum, DontDelete|Function, 0, &JSSVGSVGElementPrototypeTableEntries[34] },
    { "SVG_ZOOMANDPAN_UNKNOWN", SVGSVGElement::SVG_ZOOMANDPAN_UNKNOWN, DontDelete|ReadOnly, 0, 0 },
    { "setCurrentTime", JSSVGSVGElement::SetCurrentTimeFuncNum, DontDelete|Function, 1, &JSSVGSVGElementPrototypeTableEntries[32] },
    { 0, 0, 0, 0, 0 },
    { "checkEnclosure", JSSVGSVGElement::CheckEnclosureFuncNum, DontDelete|Function, 2, &JSSVGSVGElementPrototypeTableEntries[33] },
    { "unpauseAnimations", JSSVGSVGElement::UnpauseAnimationsFuncNum, DontDelete|Function, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "createSVGPoint", JSSVGSVGElement::CreateSVGPointFuncNum, DontDelete|Function, 0, &JSSVGSVGElementPrototypeTableEntries[37] },
    { "animationsPaused", JSSVGSVGElement::AnimationsPausedFuncNum, DontDelete|Function, 0, &JSSVGSVGElementPrototypeTableEntries[31] },
    { 0, 0, 0, 0, 0 },
    { "createSVGLength", JSSVGSVGElement::CreateSVGLengthFuncNum, DontDelete|Function, 0, 0 },
    { "createSVGAngle", JSSVGSVGElement::CreateSVGAngleFuncNum, DontDelete|Function, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "SVG_ZOOMANDPAN_DISABLE", SVGSVGElement::SVG_ZOOMANDPAN_DISABLE, DontDelete|ReadOnly, 0, &JSSVGSVGElementPrototypeTableEntries[30] },
    { "getScreenCTM", JSSVGSVGElement::GetScreenCTMFuncNum, DontDelete|Function, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "pauseAnimations", JSSVGSVGElement::PauseAnimationsFuncNum, DontDelete|Function, 0, &JSSVGSVGElementPrototypeTableEntries[35] },
    { "deselectAll", JSSVGSVGElement::DeselectAllFuncNum, DontDelete|Function, 0, 0 },
    { "unsuspendRedraw", JSSVGSVGElement::UnsuspendRedrawFuncNum, DontDelete|Function, 1, 0 },
    { "SVG_ZOOMANDPAN_MAGNIFY", SVGSVGElement::SVG_ZOOMANDPAN_MAGNIFY, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "getEnclosureList", JSSVGSVGElement::GetEnclosureListFuncNum, DontDelete|Function, 2, 0 },
    { "getBBox", JSSVGSVGElement::GetBBoxFuncNum, DontDelete|Function, 0, 0 },
    { "unsuspendRedrawAll", JSSVGSVGElement::UnsuspendRedrawAllFuncNum, DontDelete|Function, 0, 0 },
    { "suspendRedraw", JSSVGSVGElement::SuspendRedrawFuncNum, DontDelete|Function, 1, &JSSVGSVGElementPrototypeTableEntries[36] },
    { 0, 0, 0, 0, 0 },
    { "getIntersectionList", JSSVGSVGElement::GetIntersectionListFuncNum, DontDelete|Function, 2, 0 },
    { "forceRedraw", JSSVGSVGElement::ForceRedrawFuncNum, DontDelete|Function, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "getCurrentTime", JSSVGSVGElement::GetCurrentTimeFuncNum, DontDelete|Function, 0, 0 },
    { "checkIntersection", JSSVGSVGElement::CheckIntersectionFuncNum, DontDelete|Function, 2, 0 },
    { "createSVGMatrix", JSSVGSVGElement::CreateSVGMatrixFuncNum, DontDelete|Function, 0, 0 },
    { "createSVGRect", JSSVGSVGElement::CreateSVGRectFuncNum, DontDelete|Function, 0, &JSSVGSVGElementPrototypeTableEntries[38] },
    { "createSVGTransform", JSSVGSVGElement::CreateSVGTransformFuncNum, DontDelete|Function, 0, 0 },
    { "createSVGTransformFromMatrix", JSSVGSVGElement::CreateSVGTransformFromMatrixFuncNum, DontDelete|Function, 1, 0 },
    { "hasExtension", JSSVGSVGElement::HasExtensionFuncNum, DontDelete|Function, 1, 0 },
    { "getCTM", JSSVGSVGElement::GetCTMFuncNum, DontDelete|Function, 0, 0 },
    { "getTransformToElement", JSSVGSVGElement::GetTransformToElementFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSSVGSVGElementPrototypeTable = 
{
    2, 39, JSSVGSVGElementPrototypeTableEntries, 30
};

const ClassInfo JSSVGSVGElementPrototype::info = { "SVGSVGElementPrototype", 0, &JSSVGSVGElementPrototypeTable, 0 };

JSObject* JSSVGSVGElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGSVGElementPrototype>(exec, "[[JSSVGSVGElement.prototype]]");
}

bool JSSVGSVGElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGSVGElementPrototypeFunction, JSSVGSVGElementPrototype, JSObject>(exec, &JSSVGSVGElementPrototypeTable, this, propertyName, slot);
}

JSValue* JSSVGSVGElementPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSSVGSVGElement::info = { "SVGSVGElement", &JSSVGElement::info, &JSSVGSVGElementTable, 0 };

JSSVGSVGElement::JSSVGSVGElement(ExecState* exec, SVGSVGElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGSVGElementPrototype::self(exec));
}

bool JSSVGSVGElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGSVGElement, JSSVGElement>(exec, &JSSVGSVGElementTable, this, propertyName, slot);
}

JSValue* JSSVGSVGElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case XAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case YAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case WidthAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case HeightAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ContentScriptTypeAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return jsString(imp->contentScriptType());
    }
    case ContentStyleTypeAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return jsString(imp->contentStyleType());
    }
    case ViewportAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return toJS(exec, new JSSVGPODTypeWrapper<FloatRect>(imp->viewport()));
    }
    case PixelUnitToMillimeterXAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return jsNumber(imp->pixelUnitToMillimeterX());
    }
    case PixelUnitToMillimeterYAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return jsNumber(imp->pixelUnitToMillimeterY());
    }
    case ScreenPixelToMillimeterXAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return jsNumber(imp->screenPixelToMillimeterX());
    }
    case ScreenPixelToMillimeterYAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return jsNumber(imp->screenPixelToMillimeterY());
    }
    case UseCurrentViewAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return jsBoolean(imp->useCurrentView());
    }
    case CurrentScaleAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return jsNumber(imp->currentScale());
    }
    case CurrentTranslateAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return toJS(exec, new JSSVGPODTypeWrapper<FloatPoint>(imp->currentTranslate()));
    }
    case RequiredFeaturesAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredFeatures()));
    }
    case RequiredExtensionsAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredExtensions()));
    }
    case SystemLanguageAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->systemLanguage()));
    }
    case XmllangAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return jsString(imp->xmllang());
    }
    case XmlspaceAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ClassNameAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case NearestViewportElementAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
    }
    case FarthestViewportElementAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
    }
    case ViewBoxAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedRect> obj = imp->viewBoxAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedRect>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedRect>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedRect>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case PreserveAspectRatioAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedPreserveAspectRatio> obj = imp->preserveAspectRatioAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedPreserveAspectRatio>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedPreserveAspectRatio>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedPreserveAspectRatio>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ZoomAndPanAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        return jsNumber(imp->zoomAndPan());
    }
    }
    return 0;
}

void JSSVGSVGElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGSVGElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGSVGElementTable, this);
}

void JSSVGSVGElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case ContentScriptTypeAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        imp->setContentScriptType(value->toString(exec));
        break;
    }
    case ContentStyleTypeAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        imp->setContentStyleType(value->toString(exec));
        break;
    }
    case UseCurrentViewAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        imp->setUseCurrentView(value->toBoolean(exec));
        break;
    }
    case CurrentScaleAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        imp->setCurrentScale(value->toFloat(exec));
        break;
    }
    case XmllangAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        imp->setXmllang(value->toString(exec));
        break;
    }
    case XmlspaceAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        imp->setXmlspace(value->toString(exec));
        break;
    }
    case ZoomAndPanAttrNum: {
        SVGSVGElement* imp = static_cast<SVGSVGElement*>(impl());

        imp->setZoomAndPan(value->toInt32(exec));
        break;
    }
    }
}

JSValue* JSSVGSVGElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGSVGElement::info))
      return throwError(exec, TypeError);

    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGSVGElement::SuspendRedrawFuncNum: {
        bool maxWaitMillisecondsOk;
        unsigned maxWaitMilliseconds = args[0]->toInt32(exec, maxWaitMillisecondsOk);
        if (!maxWaitMillisecondsOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = jsNumber(imp->suspendRedraw(maxWaitMilliseconds));
        return result;
    }
    case JSSVGSVGElement::UnsuspendRedrawFuncNum: {
        ExceptionCode ec = 0;
        bool suspendHandleIdOk;
        unsigned suspendHandleId = args[0]->toInt32(exec, suspendHandleIdOk);
        if (!suspendHandleIdOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }

        imp->unsuspendRedraw(suspendHandleId, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    case JSSVGSVGElement::UnsuspendRedrawAllFuncNum: {

        imp->unsuspendRedrawAll();
        return jsUndefined();
    }
    case JSSVGSVGElement::ForceRedrawFuncNum: {

        imp->forceRedraw();
        return jsUndefined();
    }
    case JSSVGSVGElement::PauseAnimationsFuncNum: {

        imp->pauseAnimations();
        return jsUndefined();
    }
    case JSSVGSVGElement::UnpauseAnimationsFuncNum: {

        imp->unpauseAnimations();
        return jsUndefined();
    }
    case JSSVGSVGElement::AnimationsPausedFuncNum: {


        KJS::JSValue* result = jsBoolean(imp->animationsPaused());
        return result;
    }
    case JSSVGSVGElement::GetCurrentTimeFuncNum: {


        KJS::JSValue* result = jsNumber(imp->getCurrentTime());
        return result;
    }
    case JSSVGSVGElement::SetCurrentTimeFuncNum: {
        float seconds = args[0]->toFloat(exec);

        imp->setCurrentTime(seconds);
        return jsUndefined();
    }
    case JSSVGSVGElement::GetIntersectionListFuncNum: {
        FloatRect rect = toSVGRect(args[0]);
        SVGElement* referenceElement = toSVGElement(args[1]);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getIntersectionList(rect, referenceElement)));
        return result;
    }
    case JSSVGSVGElement::GetEnclosureListFuncNum: {
        FloatRect rect = toSVGRect(args[0]);
        SVGElement* referenceElement = toSVGElement(args[1]);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getEnclosureList(rect, referenceElement)));
        return result;
    }
    case JSSVGSVGElement::CheckIntersectionFuncNum: {
        SVGElement* element = toSVGElement(args[0]);
        FloatRect rect = toSVGRect(args[1]);


        KJS::JSValue* result = jsBoolean(imp->checkIntersection(element, rect));
        return result;
    }
    case JSSVGSVGElement::CheckEnclosureFuncNum: {
        SVGElement* element = toSVGElement(args[0]);
        FloatRect rect = toSVGRect(args[1]);


        KJS::JSValue* result = jsBoolean(imp->checkEnclosure(element, rect));
        return result;
    }
    case JSSVGSVGElement::DeselectAllFuncNum: {

        imp->deselectAll();
        return jsUndefined();
    }
    case JSSVGSVGElement::CreateSVGNumberFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<double>(imp->createSVGNumber()));
        return result;
    }
    case JSSVGSVGElement::CreateSVGLengthFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<SVGLength>(imp->createSVGLength()));
        return result;
    }
    case JSSVGSVGElement::CreateSVGAngleFuncNum: {


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGAngle()));
        return result;
    }
    case JSSVGSVGElement::CreateSVGPointFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatPoint>(imp->createSVGPoint()));
        return result;
    }
    case JSSVGSVGElement::CreateSVGMatrixFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->createSVGMatrix()));
        return result;
    }
    case JSSVGSVGElement::CreateSVGRectFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatRect>(imp->createSVGRect()));
        return result;
    }
    case JSSVGSVGElement::CreateSVGTransformFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<SVGTransform>(imp->createSVGTransform()));
        return result;
    }
    case JSSVGSVGElement::CreateSVGTransformFromMatrixFuncNum: {
        AffineTransform matrix = toSVGMatrix(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<SVGTransform>(imp->createSVGTransformFromMatrix(matrix)));
        return result;
    }
    case JSSVGSVGElement::HasExtensionFuncNum: {
        String extension = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasExtension(extension));
        return result;
    }
    case JSSVGSVGElement::GetBBoxFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatRect>(imp->getBBox()));
        return result;
    }
    case JSSVGSVGElement::GetCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getCTM()));
        return result;
    }
    case JSSVGSVGElement::GetScreenCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getScreenCTM()));
        return result;
    }
    case JSSVGSVGElement::GetTransformToElementFuncNum: {
        ExceptionCode ec = 0;
        SVGElement* element = toSVGElement(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getTransformToElement(element, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
