/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGPolygonElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGPointList.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "PlatformString.h"
#include "SVGElement.h"
#include "SVGPointList.h"
#include "SVGPolygonElement.h"
#include "SVGStringList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGPolygonElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "transform", JSSVGPolygonElement::TransformAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "xmlspace", JSSVGPolygonElement::XmlspaceAttrNum, DontDelete, 0, 0 },
    { "requiredFeatures", JSSVGPolygonElement::RequiredFeaturesAttrNum, DontDelete|ReadOnly, 0, &JSSVGPolygonElementTableEntries[13] },
    { "farthestViewportElement", JSSVGPolygonElement::FarthestViewportElementAttrNum, DontDelete|ReadOnly, 0, &JSSVGPolygonElementTableEntries[16] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "style", JSSVGPolygonElement::StyleAttrNum, DontDelete|ReadOnly, 0, &JSSVGPolygonElementTableEntries[15] },
    { "systemLanguage", JSSVGPolygonElement::SystemLanguageAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "className", JSSVGPolygonElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "externalResourcesRequired", JSSVGPolygonElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "requiredExtensions", JSSVGPolygonElement::RequiredExtensionsAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "xmllang", JSSVGPolygonElement::XmllangAttrNum, DontDelete, 0, &JSSVGPolygonElementTableEntries[14] },
    { "nearestViewportElement", JSSVGPolygonElement::NearestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "points", JSSVGPolygonElement::PointsAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "animatedPoints", JSSVGPolygonElement::AnimatedPointsAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGPolygonElementTable = 
{
    2, 17, JSSVGPolygonElementTableEntries, 13
};

/* Hash table for prototype */

static const HashEntry JSSVGPolygonElementPrototypeTableEntries[] =
{
    { "hasExtension", JSSVGPolygonElement::HasExtensionFuncNum, DontDelete|Function, 1, &JSSVGPolygonElementPrototypeTableEntries[6] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "getBBox", JSSVGPolygonElement::GetBBoxFuncNum, DontDelete|Function, 0, &JSSVGPolygonElementPrototypeTableEntries[5] },
    { "getTransformToElement", JSSVGPolygonElement::GetTransformToElementFuncNum, DontDelete|Function, 1, 0 },
    { "getCTM", JSSVGPolygonElement::GetCTMFuncNum, DontDelete|Function, 0, 0 },
    { "getScreenCTM", JSSVGPolygonElement::GetScreenCTMFuncNum, DontDelete|Function, 0, 0 }
};

static const HashTable JSSVGPolygonElementPrototypeTable = 
{
    2, 7, JSSVGPolygonElementPrototypeTableEntries, 5
};

const ClassInfo JSSVGPolygonElementPrototype::info = { "SVGPolygonElementPrototype", 0, &JSSVGPolygonElementPrototypeTable, 0 };

JSObject* JSSVGPolygonElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGPolygonElementPrototype>(exec, "[[JSSVGPolygonElement.prototype]]");
}

bool JSSVGPolygonElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGPolygonElementPrototypeFunction, JSObject>(exec, &JSSVGPolygonElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGPolygonElement::info = { "SVGPolygonElement", &JSSVGElement::info, &JSSVGPolygonElementTable, 0 };

JSSVGPolygonElement::JSSVGPolygonElement(ExecState* exec, SVGPolygonElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGPolygonElementPrototype::self(exec));
}

bool JSSVGPolygonElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPolygonElement, JSSVGElement>(exec, &JSSVGPolygonElementTable, this, propertyName, slot);
}

JSValue* JSSVGPolygonElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case RequiredFeaturesAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredFeatures()));
    }
    case RequiredExtensionsAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredExtensions()));
    }
    case SystemLanguageAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->systemLanguage()));
    }
    case XmllangAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        return jsString(imp->xmllang());
    }
    case XmlspaceAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ClassNameAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case TransformAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedTransformList>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedTransformList>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedTransformList>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case NearestViewportElementAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
    }
    case FarthestViewportElementAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
    }
    case PointsAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->points()));
    }
    case AnimatedPointsAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->animatedPoints()));
    }
    }
    return 0;
}

void JSSVGPolygonElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGPolygonElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGPolygonElementTable, this);
}

void JSSVGPolygonElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XmllangAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        imp->setXmllang(value->toString(exec));
        break;
    }
    case XmlspaceAttrNum: {
        SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(impl());

        imp->setXmlspace(value->toString(exec));
        break;
    }
    }
}

JSValue* JSSVGPolygonElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGPolygonElement::info))
      return throwError(exec, TypeError);

    SVGPolygonElement* imp = static_cast<SVGPolygonElement*>(static_cast<JSSVGPolygonElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGPolygonElement::HasExtensionFuncNum: {
        String extension = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasExtension(extension));
        return result;
    }
    case JSSVGPolygonElement::GetBBoxFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatRect>(imp->getBBox()));
        return result;
    }
    case JSSVGPolygonElement::GetCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getCTM()));
        return result;
    }
    case JSSVGPolygonElement::GetScreenCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getScreenCTM()));
        return result;
    }
    case JSSVGPolygonElement::GetTransformToElementFuncNum: {
        ExceptionCode ec = 0;
        SVGElement* element = toSVGElement(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getTransformToElement(element, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
