/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGPathElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGPathSegArcAbs.h"
#include "JSSVGPathSegArcRel.h"
#include "JSSVGPathSegClosePath.h"
#include "JSSVGPathSegCurvetoCubicAbs.h"
#include "JSSVGPathSegCurvetoCubicRel.h"
#include "JSSVGPathSegCurvetoCubicSmoothAbs.h"
#include "JSSVGPathSegCurvetoCubicSmoothRel.h"
#include "JSSVGPathSegCurvetoQuadraticAbs.h"
#include "JSSVGPathSegCurvetoQuadraticRel.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothAbs.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothRel.h"
#include "JSSVGPathSegLinetoAbs.h"
#include "JSSVGPathSegLinetoHorizontalAbs.h"
#include "JSSVGPathSegLinetoHorizontalRel.h"
#include "JSSVGPathSegLinetoRel.h"
#include "JSSVGPathSegLinetoVerticalAbs.h"
#include "JSSVGPathSegLinetoVerticalRel.h"
#include "JSSVGPathSegList.h"
#include "JSSVGPathSegMovetoAbs.h"
#include "JSSVGPathSegMovetoRel.h"
#include "JSSVGPoint.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "PlatformString.h"
#include "SVGElement.h"
#include "SVGPathElement.h"
#include "SVGPathSegArc.h"
#include "SVGPathSegClosePath.h"
#include "SVGPathSegCurvetoCubic.h"
#include "SVGPathSegCurvetoCubicSmooth.h"
#include "SVGPathSegCurvetoQuadratic.h"
#include "SVGPathSegCurvetoQuadraticSmooth.h"
#include "SVGPathSegLineto.h"
#include "SVGPathSegLinetoHorizontal.h"
#include "SVGPathSegLinetoVertical.h"
#include "SVGPathSegList.h"
#include "SVGPathSegMoveto.h"
#include "SVGStringList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGPathElementTableEntries[] =
{
    { "systemLanguage", JSSVGPathElement::SystemLanguageAttrNum, DontDelete|ReadOnly, 0, &JSSVGPathElementTableEntries[16] },
    { "externalResourcesRequired", JSSVGPathElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "className", JSSVGPathElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "requiredFeatures", JSSVGPathElement::RequiredFeaturesAttrNum, DontDelete|ReadOnly, 0, &JSSVGPathElementTableEntries[17] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "farthestViewportElement", JSSVGPathElement::FarthestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "xmllang", JSSVGPathElement::XmllangAttrNum, DontDelete, 0, &JSSVGPathElementTableEntries[19] },
    { "requiredExtensions", JSSVGPathElement::RequiredExtensionsAttrNum, DontDelete|ReadOnly, 0, &JSSVGPathElementTableEntries[18] },
    { "pathLength", JSSVGPathElement::PathLengthAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "style", JSSVGPathElement::StyleAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "pathSegList", JSSVGPathElement::PathSegListAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "xmlspace", JSSVGPathElement::XmlspaceAttrNum, DontDelete, 0, 0 },
    { "transform", JSSVGPathElement::TransformAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "nearestViewportElement", JSSVGPathElement::NearestViewportElementAttrNum, DontDelete|ReadOnly, 0, &JSSVGPathElementTableEntries[20] },
    { "normalizedPathSegList", JSSVGPathElement::NormalizedPathSegListAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "animatedPathSegList", JSSVGPathElement::AnimatedPathSegListAttrNum, DontDelete|ReadOnly, 0, &JSSVGPathElementTableEntries[21] },
    { "animatedNormalizedPathSegList", JSSVGPathElement::AnimatedNormalizedPathSegListAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGPathElementTable = 
{
    2, 22, JSSVGPathElementTableEntries, 16
};

/* Hash table for prototype */

static const HashEntry JSSVGPathElementPrototypeTableEntries[] =
{
    { "createSVGPathSegArcAbs", JSSVGPathElement::CreateSVGPathSegArcAbsFuncNum, DontDelete|Function, 7, &JSSVGPathElementPrototypeTableEntries[32] },
    { 0, 0, 0, 0, 0 },
    { "createSVGPathSegCurvetoCubicAbs", JSSVGPathElement::CreateSVGPathSegCurvetoCubicAbsFuncNum, DontDelete|Function, 6, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "getCTM", JSSVGPathElement::GetCTMFuncNum, DontDelete|Function, 0, 0 },
    { "getScreenCTM", JSSVGPathElement::GetScreenCTMFuncNum, DontDelete|Function, 0, 0 },
    { "createSVGPathSegLinetoRel", JSSVGPathElement::CreateSVGPathSegLinetoRelFuncNum, DontDelete|Function, 2, 0 },
    { 0, 0, 0, 0, 0 },
    { "createSVGPathSegCurvetoQuadraticAbs", JSSVGPathElement::CreateSVGPathSegCurvetoQuadraticAbsFuncNum, DontDelete|Function, 4, 0 },
    { "getTransformToElement", JSSVGPathElement::GetTransformToElementFuncNum, DontDelete|Function, 1, 0 },
    { "getBBox", JSSVGPathElement::GetBBoxFuncNum, DontDelete|Function, 0, 0 },
    { "createSVGPathSegLinetoAbs", JSSVGPathElement::CreateSVGPathSegLinetoAbsFuncNum, DontDelete|Function, 2, 0 },
    { "createSVGPathSegLinetoHorizontalAbs", JSSVGPathElement::CreateSVGPathSegLinetoHorizontalAbsFuncNum, DontDelete|Function, 1, &JSSVGPathElementPrototypeTableEntries[28] },
    { 0, 0, 0, 0, 0 },
    { "createSVGPathSegClosePath", JSSVGPathElement::CreateSVGPathSegClosePathFuncNum, DontDelete|Function, 0, 0 },
    { "createSVGPathSegCurvetoQuadraticRel", JSSVGPathElement::CreateSVGPathSegCurvetoQuadraticRelFuncNum, DontDelete|Function, 4, &JSSVGPathElementPrototypeTableEntries[33] },
    { "createSVGPathSegCurvetoQuadraticSmoothRel", JSSVGPathElement::CreateSVGPathSegCurvetoQuadraticSmoothRelFuncNum, DontDelete|Function, 2, 0 },
    { "createSVGPathSegLinetoVerticalAbs", JSSVGPathElement::CreateSVGPathSegLinetoVerticalAbsFuncNum, DontDelete|Function, 1, 0 },
    { "createSVGPathSegArcRel", JSSVGPathElement::CreateSVGPathSegArcRelFuncNum, DontDelete|Function, 7, 0 },
    { "getTotalLength", JSSVGPathElement::GetTotalLengthFuncNum, DontDelete|Function, 0, &JSSVGPathElementPrototypeTableEntries[27] },
    { "createSVGPathSegMovetoRel", JSSVGPathElement::CreateSVGPathSegMovetoRelFuncNum, DontDelete|Function, 2, 0 },
    { 0, 0, 0, 0, 0 },
    { "createSVGPathSegMovetoAbs", JSSVGPathElement::CreateSVGPathSegMovetoAbsFuncNum, DontDelete|Function, 2, &JSSVGPathElementPrototypeTableEntries[30] },
    { "createSVGPathSegCurvetoCubicRel", JSSVGPathElement::CreateSVGPathSegCurvetoCubicRelFuncNum, DontDelete|Function, 6, 0 },
    { 0, 0, 0, 0, 0 },
    { "getPathSegAtLength", JSSVGPathElement::GetPathSegAtLengthFuncNum, DontDelete|Function, 1, &JSSVGPathElementPrototypeTableEntries[29] },
    { "getPointAtLength", JSSVGPathElement::GetPointAtLengthFuncNum, DontDelete|Function, 1, &JSSVGPathElementPrototypeTableEntries[31] },
    { "createSVGPathSegLinetoHorizontalRel", JSSVGPathElement::CreateSVGPathSegLinetoHorizontalRelFuncNum, DontDelete|Function, 1, 0 },
    { "createSVGPathSegLinetoVerticalRel", JSSVGPathElement::CreateSVGPathSegLinetoVerticalRelFuncNum, DontDelete|Function, 1, 0 },
    { "createSVGPathSegCurvetoCubicSmoothAbs", JSSVGPathElement::CreateSVGPathSegCurvetoCubicSmoothAbsFuncNum, DontDelete|Function, 4, 0 },
    { "createSVGPathSegCurvetoCubicSmoothRel", JSSVGPathElement::CreateSVGPathSegCurvetoCubicSmoothRelFuncNum, DontDelete|Function, 4, 0 },
    { "createSVGPathSegCurvetoQuadraticSmoothAbs", JSSVGPathElement::CreateSVGPathSegCurvetoQuadraticSmoothAbsFuncNum, DontDelete|Function, 2, 0 },
    { "hasExtension", JSSVGPathElement::HasExtensionFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSSVGPathElementPrototypeTable = 
{
    2, 34, JSSVGPathElementPrototypeTableEntries, 27
};

const ClassInfo JSSVGPathElementPrototype::info = { "SVGPathElementPrototype", 0, &JSSVGPathElementPrototypeTable, 0 };

JSObject* JSSVGPathElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGPathElementPrototype>(exec, "[[JSSVGPathElement.prototype]]");
}

bool JSSVGPathElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGPathElementPrototypeFunction, JSObject>(exec, &JSSVGPathElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGPathElement::info = { "SVGPathElement", &JSSVGElement::info, &JSSVGPathElementTable, 0 };

JSSVGPathElement::JSSVGPathElement(ExecState* exec, SVGPathElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGPathElementPrototype::self(exec));
}

bool JSSVGPathElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathElement, JSSVGElement>(exec, &JSSVGPathElementTable, this, propertyName, slot);
}

JSValue* JSSVGPathElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case PathLengthAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedNumber> obj = imp->pathLengthAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedNumber>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedNumber>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedNumber>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case RequiredFeaturesAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredFeatures()));
    }
    case RequiredExtensionsAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredExtensions()));
    }
    case SystemLanguageAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->systemLanguage()));
    }
    case XmllangAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        return jsString(imp->xmllang());
    }
    case XmlspaceAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ClassNameAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case TransformAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedTransformList>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedTransformList>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedTransformList>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case NearestViewportElementAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
    }
    case FarthestViewportElementAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
    }
    case PathSegListAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->pathSegList()));
    }
    case NormalizedPathSegListAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->normalizedPathSegList()));
    }
    case AnimatedPathSegListAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->animatedPathSegList()));
    }
    case AnimatedNormalizedPathSegListAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->animatedNormalizedPathSegList()));
    }
    }
    return 0;
}

void JSSVGPathElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGPathElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGPathElementTable, this);
}

void JSSVGPathElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XmllangAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        imp->setXmllang(value->toString(exec));
        break;
    }
    case XmlspaceAttrNum: {
        SVGPathElement* imp = static_cast<SVGPathElement*>(impl());

        imp->setXmlspace(value->toString(exec));
        break;
    }
    }
}

JSValue* JSSVGPathElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGPathElement::info))
      return throwError(exec, TypeError);

    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGPathElement::GetTotalLengthFuncNum: {


        KJS::JSValue* result = jsNumber(imp->getTotalLength());
        return result;
    }
    case JSSVGPathElement::GetPointAtLengthFuncNum: {
        float distance = args[0]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatPoint>(imp->getPointAtLength(distance)));
        return result;
    }
    case JSSVGPathElement::GetPathSegAtLengthFuncNum: {
        float distance = args[0]->toFloat(exec);


        KJS::JSValue* result = jsNumber(imp->getPathSegAtLength(distance));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegClosePathFuncNum: {


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegClosePath()));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegMovetoAbsFuncNum: {
        float x = args[0]->toFloat(exec);
        float y = args[1]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegMovetoAbs(x, y)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegMovetoRelFuncNum: {
        float x = args[0]->toFloat(exec);
        float y = args[1]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegMovetoRel(x, y)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegLinetoAbsFuncNum: {
        float x = args[0]->toFloat(exec);
        float y = args[1]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegLinetoAbs(x, y)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegLinetoRelFuncNum: {
        float x = args[0]->toFloat(exec);
        float y = args[1]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegLinetoRel(x, y)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegCurvetoCubicAbsFuncNum: {
        float x = args[0]->toFloat(exec);
        float y = args[1]->toFloat(exec);
        float x1 = args[2]->toFloat(exec);
        float y1 = args[3]->toFloat(exec);
        float x2 = args[4]->toFloat(exec);
        float y2 = args[5]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoCubicAbs(x, y, x1, y1, x2, y2)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegCurvetoCubicRelFuncNum: {
        float x = args[0]->toFloat(exec);
        float y = args[1]->toFloat(exec);
        float x1 = args[2]->toFloat(exec);
        float y1 = args[3]->toFloat(exec);
        float x2 = args[4]->toFloat(exec);
        float y2 = args[5]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoCubicRel(x, y, x1, y1, x2, y2)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegCurvetoQuadraticAbsFuncNum: {
        float x = args[0]->toFloat(exec);
        float y = args[1]->toFloat(exec);
        float x1 = args[2]->toFloat(exec);
        float y1 = args[3]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoQuadraticAbs(x, y, x1, y1)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegCurvetoQuadraticRelFuncNum: {
        float x = args[0]->toFloat(exec);
        float y = args[1]->toFloat(exec);
        float x1 = args[2]->toFloat(exec);
        float y1 = args[3]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoQuadraticRel(x, y, x1, y1)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegArcAbsFuncNum: {
        float x = args[0]->toFloat(exec);
        float y = args[1]->toFloat(exec);
        float r1 = args[2]->toFloat(exec);
        float r2 = args[3]->toFloat(exec);
        float angle = args[4]->toFloat(exec);
        bool largeArcFlag = args[5]->toBoolean(exec);
        bool sweepFlag = args[6]->toBoolean(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegArcAbs(x, y, r1, r2, angle, largeArcFlag, sweepFlag)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegArcRelFuncNum: {
        float x = args[0]->toFloat(exec);
        float y = args[1]->toFloat(exec);
        float r1 = args[2]->toFloat(exec);
        float r2 = args[3]->toFloat(exec);
        float angle = args[4]->toFloat(exec);
        bool largeArcFlag = args[5]->toBoolean(exec);
        bool sweepFlag = args[6]->toBoolean(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegArcRel(x, y, r1, r2, angle, largeArcFlag, sweepFlag)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegLinetoHorizontalAbsFuncNum: {
        float x = args[0]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegLinetoHorizontalAbs(x)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegLinetoHorizontalRelFuncNum: {
        float x = args[0]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegLinetoHorizontalRel(x)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegLinetoVerticalAbsFuncNum: {
        float y = args[0]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegLinetoVerticalAbs(y)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegLinetoVerticalRelFuncNum: {
        float y = args[0]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegLinetoVerticalRel(y)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegCurvetoCubicSmoothAbsFuncNum: {
        float x = args[0]->toFloat(exec);
        float y = args[1]->toFloat(exec);
        float x2 = args[2]->toFloat(exec);
        float y2 = args[3]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoCubicSmoothAbs(x, y, x2, y2)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegCurvetoCubicSmoothRelFuncNum: {
        float x = args[0]->toFloat(exec);
        float y = args[1]->toFloat(exec);
        float x2 = args[2]->toFloat(exec);
        float y2 = args[3]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoCubicSmoothRel(x, y, x2, y2)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegCurvetoQuadraticSmoothAbsFuncNum: {
        float x = args[0]->toFloat(exec);
        float y = args[1]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoQuadraticSmoothAbs(x, y)));
        return result;
    }
    case JSSVGPathElement::CreateSVGPathSegCurvetoQuadraticSmoothRelFuncNum: {
        float x = args[0]->toFloat(exec);
        float y = args[1]->toFloat(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoQuadraticSmoothRel(x, y)));
        return result;
    }
    case JSSVGPathElement::HasExtensionFuncNum: {
        String extension = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasExtension(extension));
        return result;
    }
    case JSSVGPathElement::GetBBoxFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatRect>(imp->getBBox()));
        return result;
    }
    case JSSVGPathElement::GetCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getCTM()));
        return result;
    }
    case JSSVGPathElement::GetScreenCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getScreenCTM()));
        return result;
    }
    case JSSVGPathElement::GetTransformToElementFuncNum: {
        ExceptionCode ec = 0;
        SVGElement* element = toSVGElement(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getTransformToElement(element, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
