/*
* Copyright (c) 2002-2005 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:    Header declaration
*
*/








#ifndef M_SEN_REMOTE_SERVICE_CONSUMER_H
#define M_SEN_REMOTE_SERVICE_CONSUMER_H


#include <e32base.h>
#include <e32des8.h>    // HBufC8
#include <SenServiceConnection.h>

//#include "MSenRemoteServiceSession.h"
//#include "MSenTransport.h"

// FORWARD DECLARE
class MSenRemoteServiceSession;
class MSenTransport;
class CSenIdentifier;
class CSenServiceSession;
class CSenChunk;
class MSenProperties;
class MSenMessageContext;
class CSenIdentityProvider;

// CLASS DECLARATION
class MSenRemoteServiceConsumer
    {
    public:
    
        // New functions
 
        /**
        * Getter to the ID of this service consumer. Actually this is a convenience
        * method which returns the value of the CSenIdentifier which is globally 
        * identifying this consumer. This helper is handy in cases where identifier
        * type is not relevant. In more complex, global junctions, Identitifier()
        * getter method should be called.
        * @return a descriptor which locally identifies this session. This is actually
        *         the value of CSenIdentifier, which is the unique identifier of this
        *         consumer.
        */       
        virtual const TDesC8& Id() const = 0;
 
        virtual TInt SetSessionL(MSenRemoteServiceSession& aServiceSession) = 0;

        /**
         * This callback will be called when a response message is received 
         * from (remote) service. The framework spesific overhead is removed
         * from the message, unless the application has indicated that it wants
         * to receive complete messages. This means that response could be only 
         * the message body OR complete message with header information. In SOAP
         * spesific services, it could be either SOAP Body or complete SOAP 
         * envelope. Also, in most cases, the string is actually XML.
         *
         * @param aMessage is the response from the service. Depending on client's
         * wishes, it might be complete message, or only a body of the original
         * message from which all framework spesific overhead has been removed.
         * @param aTxnId identifies what request is being responded. This transaction
         *        was originally generated by the transport layer.
         * @param aTranportProperties is optional argument, which may be NULL,
         *        or it could include some transport spesific information about the
         *        message. In case of HTTP transport, it could include the content 
         *        type of the response.
         * @param   aMessage - a String with the service specific part of the
         *          message.
         * @return KErrNone, if this consumer was able to successfully carry out
         *         and process this callback. Consumer should return an error otherwise,
         *         so that the service session (or even transport) will know that 
         *         problems occured during the delivery.
         */
        virtual TInt HandleMessageL(HBufC8* aMessage,
                                    const TInt aTxnId,
                                    MSenProperties* aResponseTransportProperties) = 0;

        /**
         * This callback will be called when an error response (marked as a fault)
         * is received from (remote) service. The framework spesific overhead is 
         * removed from the error, unless the application has indicated that it 
         * wants to receive complete messages. This means that response could be
         * only the fault part of message body OR complete error message with header
         * information. In SOAP spesific services, it could be either SOAP fault or 
         * complete SOAP envelope. In most cases, the error string is XML.
         *
         * @param aError is the error received from the service. Depending on client's
         * wishes, it might be complete error message, or only a body of the original
         * error from which all framework spesific overhead has been removed. In SOAP
         * based services, this means that it could be either complete SOAP Envelope
         * or just the SOAP fault extracted from the SOAP body.
         * @param aErrorCode is the code identifying the error type.
         * @param aTxnId identifies what request is being responded. This transaction
         *        was originally generated by the transport layer.
         * @param aTranportProperties is optional argument, which may be NULL,
         *        or it could include some transport spesific information about the
         *        message. In case of HTTP transport, it could include the content 
         *        type of the response.
         * @param   aMessage - a String with the service specific part of the
         *          message.
         * @return KErrNone, if this consumer was able to successfully carry out
         *         and process this callback. Consumer should return an error otherwise,
         *         so that the service session (or even transport) will know that 
         *         problems occured during the delivery.
         */
        virtual TInt HandleErrorL(HBufC8* aError,
                                  const TInt aErrorCode,
                                  const TInt aTxnId,
                                  MSenProperties* aResponseTransportProperties) = 0;

        /**
         * This method is called when service connection status changes.
         * The status constant (TInt) may be be spesified by the actual
         * ServiceInvocationFramework implementation. The following
         * status codes are possible for *any* service invocation 
         * framework (as defined in SenServiceConnection.h):
         *
         *   - KSenConnectionStatusNew     
         *   - KSenConnectionStatusReady   
         *
         * In addition, some web services frameworks might notify when
         * the service credentials get expired, by sending this status:
         *
         *   - KSenConnectionStatusExpired 
         *
         * @param   aStatus - a code expressing new status
         */
        virtual void SetStatusL(const TInt aStatus) = 0;


        /**
         * This method is offered for the use of service invocation frameworks
         * (SIFs) and typically for service sessions, which need handle transport
         * to pre-allocated transport instance.
         *
         * return   MSenTransport   the transport owned by remote client
         *
         */
        virtual MSenTransport& TransportL() = 0;

        /**
        * Getter for unique identifier of this service consumer, which
        * further provides theidentifier type and value.
        * @return CSenIdentifier object which identifies this consumer.
        */
        virtual CSenIdentifier& Identifier() const = 0;


        /**
        * Method for requesting a chunk behind a known, pending transaction
        * id. This method is typically called by MSenRemoteHostlet implementations,
        * when they wish to acquire handle to same RChunk -- encapsulated by CSenChunk
        * -- which was created by consumer who is sending a message to that hostlet.
        * This way, the copying of memory (payload of the message) can be avoided
        * inside Web Services Framework server process.
        * @param aTxnId is the id of known, pending transaction
        * @param aChunk is a ref-to-pointer, which will be set
        * to provide access to a chunk, if such can be find with
        * provided aTxnId
        * @return KErrNone, if successful: this means that aChunk != NULL.
        *         KErrNone, if chunk was not found; aChunk will be set to NULL.
        * Method leaves with some system-wide errorcode, if a fatal situation
        * is met during the search and validation of the chunk (transaction)
        * in question.
        */
        // INTERNAL NOTE: please be careful not to base your code on this method, as this will
        // be made obsolate (deprecated) when message context implementations are available
        virtual TInt ChunkByTxnIdL(TInt aTxnId, CSenChunk*& aChunk) = 0;
        
        
        
        inline virtual MSenMessageContext* MessageContextByTxnIdL(TInt /* aTxnId */, TInt& aError) 
            {
            aError = KErrNotSupported;
            return NULL; 
            }

        inline virtual void StateChanged(TInt /*aState*/) {}; 

        inline virtual TBool HasAuthenticationCallback() { return EFalse;};
        // Constantness on TInt return type has no meaning
        virtual TInt ConnectionId() { return 0; };
        virtual void FileProgress(TInt aTxnId, TBool aIncoming, TBool aIsSoap,
                const TDesC8& aSoapOrCid, TInt aProgress) = 0;
        virtual TInt ReauthenticationNeededL(CSenIdentityProvider*& /*aIdp*/) { return 0; };
        virtual void SetDataTrafficDetails( TSenDataTrafficDetails& aDetails) = 0; 	
        virtual TBool OnGetBrandIdL(  const TDesC8& /* aBrandIdListAsXmlSnippet */, RBuf8& /* aSelectedBrandId */){return EFalse;};
        virtual TBool HasCoBrandingCallback(){return EFalse;};
        virtual TSecureId SecureId( ) {return 0;};
        virtual TVendorId VendorId() { return 0; };
        };

#endif // M_SEN_REMOTE_SERVICE_CONSUMER_H


// End of file


