/*
* Copyright (c) 2007-2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/



/**
 * Test step definitions for the CallControl functional unit.
 * @internalTechnology
 */

#include "cctsyintegrationtestcallcontrol.h"
#include "cetelsessionmgr.h"
#include "cctsyinidata.h"
#include "tcallcontroltsytesthelper.h"
#include <pcktcs.h>
#include "rpsasciirqstdefs.h"
#include "rpsmaster.h"
#include <ctsy/serviceapi/gsmerror.h>
#include "rpsasciirqstdefs.h"
#include "rpsmaster.h"

	
CCTSYIntegrationTestCallControlBase::CCTSYIntegrationTestCallControlBase(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestSuiteStepBase(aEtelSessionMgr), iCallControlTestHelper(*this), iNetworkTestHelper(*this), iPacketServiceTestHelper(*this)
/**
 * Constructor
 */
	{
	}

CCTSYIntegrationTestCallControlBase::~CCTSYIntegrationTestCallControlBase()
/*
 * Destructor
 */
	{
	}
	
CCTSYIntegrationTestCallControl0001::CCTSYIntegrationTestCallControl0001(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0001::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0001::~CCTSYIntegrationTestCallControl0001()
/**
 * Destructor.
 */
	{
	}
	
	
TVerdict CCTSYIntegrationTestCallControl0001::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0001
 * @SYMFssID BA/CTSY/CCON-0001
 * @SYMTestCaseDesc Make an outgoing voice call that connects
 * @SYMTestPriority High
 * @SYMTestActions RPhone::EnumerateLines, RCall::Dial
 * @SYMTestExpectedResults Pass - MO call connects.  Phone status updates correctly.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify change in call state is reflected in RPhone.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);
		
	// Check phone supports KCapsVoice
	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone, 
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits, 
			_L("RLine::GetCaps returned wrong caps"));
	
	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL		
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Check RPhone::EnumerateLines returns 4 (CTSY hard-coded value)
	
	TInt count = 0;
	ASSERT_EQUALS(phone.EnumerateLines(count), KErrNone, 
			_L("RPhone::EnumerateLines did returned an error"));
	ASSERT_EQUALS(count, 4,  
			_L("RPhone::EnumerateLines did not return a count of four"));
	
	// Check RPhone::GetLineInfo returns iStatus of EStatusIdle
	RPhone::TLineInfo lineInfo;
	TInt dataLineIndex=0;
	ASSERT_EQUALS(phone.GetLineInfo(dataLineIndex, lineInfo), KErrNone,
			_L("RPhone::GetLineInfo returned an error"));
	ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusIdle, 
			_L("RPhone::GetLineInfo wrong iStatus, should be EStatusIdle"));
	
	// Check RPhone::GetLineInfo returns iLineCapsFlags of KCapsVoice
	ASSERT_BITS_SET(lineInfo.iLineCapsFlags, RLine::KCapsVoice, KNoUnwantedBits, 
			_L("RPhone::GetLineInfo returned wrong caps"));	

	// Check RPhone::GetLineInfo returns a valid line name
	ASSERT_TRUE(lineInfo.iName.Length() >0,  
			_L("RPhone::GetLineInfo wrong call name"));
	
	// Dial voice number that answers. 
	TPtrC number; 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,			  
			_L("CTestStep::GetStringFromConfig did not complete as expected"));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, 
			_L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
			_L("RCall::Dial returned with an error"));
	
	// Check RPhone::GetLineInfo returns iStatus of EStatusConnected
	ASSERT_EQUALS(phone.GetLineInfo(dataLineIndex, lineInfo), KErrNone,  
			_L("RPhone::GetLineInfo returned an error"));
	ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusConnected, 
			_L("RPhone::GetLineInfo wrong iStatus, should be EStatusConnected"));

	// Check RPhone::GetLineInfo returns iLineCapsFlags of KCapsVoice	
	ASSERT_BITS_SET(lineInfo.iLineCapsFlags, RLine::KCapsVoice, KNoUnwantedBits, 
			_L("RPhone::GetLineInfo returned wrong caps"));	

	// Check RPhone::GetLineInfo returns a valid line name
	ASSERT_TRUE(lineInfo.iName.Length() >0,  
			_L("RPhone::GetLineInfo wrong call name"));

	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();

    // hang up the active call
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium);	
	

	CleanupStack::PopAndDestroy(2,&dialStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0001::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0001");
	}



CCTSYIntegrationTestCallControl0002::CCTSYIntegrationTestCallControl0002(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0002::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0002::~CCTSYIntegrationTestCallControl0002()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0002::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0002
 * @SYMFssID BA/CTSY/CCON-0002
 * @SYMTestCaseDesc Make an outgoing voice call that connects
 * @SYMTestPriority High
 * @SYMTestActions RLine::NotifyStatusChange, RLine::GetStatus, RMobileLine::NotifyMobileLineStatusChange, RMobileLine::GetMobileLineStatus, RLine::GetInfo, RLine::GetCallInfo, RLine::EnumerateCall
 * @SYMTestExpectedResults Pass - Mo call connects.  Line status updates corectly.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify change in call state is reflected in RLine and RMobileLine
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Get phone
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
		
	// Check phone supports KCapsVoice
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// Check GetCaps returns iLineCapsFlags of KCapsVoice 
	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));
	
	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL		
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// ===  Check line caps ===

	// Check RLine::GetCaps supports caps in set of KCapsVoice.
	ASSERT_EQUALS(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	ASSERT_BITS_SET(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits, 
			_L("RLine::GetCaps returned wrong caps"));

	// ===  Check line status ===

	// Check RLine::GetStatus returns EStatusIdle.
	RCall::TStatus callStatus;
	ASSERT_EQUALS(voiceLine.GetStatus(callStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle, 
			_L("RLine::GetStatus wrong iStatus, should be EStatusIdle"));

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle.
	RMobileCall::TMobileCallStatus lineStatus;
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(lineStatus), KErrNone, 
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RMobileCall::EStatusIdle,
			_L("RMobileLine::GetMobileLineStatus did not return EStatusIdle as expected"));

	// ===  Check line info ===

	// Check RLine::GetCallInfo returns valid name.
	// Check RLine::GetCallInfo returns caps in set of KCapsVoice | KCapsDial.
	// Check RLine::GetCallInfo returns status of EStatusIdle.
	RLine::TCallInfo callInfo;
	TInt dataLineIndex=0;
	ASSERT_EQUALS(voiceLine.GetCallInfo(dataLineIndex, callInfo), KErrNone, 
			_L("RLine::GetCallInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() >0, 
			_L("RLine::GetCallInfo returned an invalid  name"));
	ASSERT_BITS_SET(callInfo.iCallCapsFlags, RCall::KCapsVoice | RCall::KCapsDial, KNoUnwantedBits , 
			_L("RLine::GetCallInfo returned wrong caps"));	
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusIdle, 
			_L("RLine::GetCallInfo wrong iStatus, should be EStatusIdle"));
	
	// Check RLine::GetInfo returns status of EStatusIdle.
	RLine::TLineInfo lineInfo;
	ASSERT_EQUALS(voiceLine.GetInfo(lineInfo),KErrNone, 
			_L("RLine::GetInfo returned an error")); 
	ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusIdle,
			 _L("RLine::GetInfo did not return EStatusIdle"));

	// Check RLine::EnumerateCall returns aCount of 4
	TInt count = 0;
	ASSERT_EQUALS(phone.EnumerateLines(count), KErrNone, 
			_L("RPhone::EnumerateLines did returned an error"));
	ASSERT_EQUALS(count, 4,  
			_L("RPhone::EnumerateLines did not return a count of four"));

	// post notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine,&RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,callStatus);

	// post a notifier for RMobileLine::NotifyMobileLineStatusChange
	RMobileCall::TMobileCallStatus mobileCallStatus;
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileCallStatus);

	// Dial a voice number that answers. 
	TPtrC number; 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,			  
			_L("CTestStep::GetStringFromConfig did not complete as expected"));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, 
			_L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
			_L("RCall::Dial returned with an error"));
		
	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusDialling ->
	TInt expectedStatus = KErrNone;  
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);

	// Check RLine::NotifyStatusChange completes with EStatusConnecting ->
	expectedCallStatus = RCall::EStatusConnecting;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
														 															 
	// Check RLine::NotifyStatusChange completes with EStatusConnected.
	expectedCallStatus = RCall::EStatusConnected;
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
														 
	// Check RLine::GetStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetStatus(callStatus), KErrNone, 
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected, 
			_L("RLine::GetStatus did not return EStatusConnected as expected"));
	
	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDialling ->
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
																		
	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusConnecting ->
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileCallStatus);
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusConnected.																		
	expectedMobileCallStatus = RMobileCall::EStatusConnected;
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileCallStatus);
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
																																					
	
	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileCallStatus), KErrNone, 
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, 
			_L("RMobileLine::GetMobileLineStatus did not set line status to EStatusConnected"));
	
	
	// ===  Check line info ===

	// Check RLine::GetCallInfo returns valid name.
	// Check RLine::GetCallInfo returns caps in set of KCapsHangUp.
	// Check RLine::GetCallInfo returns status of EStatusConnected.
	ASSERT_EQUALS(voiceLine.GetCallInfo(dataLineIndex, callInfo), KErrNone,  
			_L("RLine::GetCallInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() >0,  
			_L("RLine::GetCallInfo returned an invalid  name"));
	ASSERT_BITS_SET(callInfo.iCallCapsFlags, RCall::KCapsHangUp, KNoUnwantedBits,  
			_L("RLine::GetCallInfo returned wrong caps"));	
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected,  
			_L("RLine::GetCallInfo wrong iStatus, should be EStatusConnected"));

	// Check RLine::GetInfo returns status of EStatusConnected.
	ASSERT_EQUALS(voiceLine.GetInfo(lineInfo), KErrNone,  
			_L("RLine::GetInfo returned an error")); 
	ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusConnected, 
			_L("RLine::GetInfo did not return EStatusConnected"));

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
    
    // hang up the active call
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium);	
	
	// Pop 
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus
	// dialStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(4,&notifyStatusChangeStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0002::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return 	_L("CCTSYIntegrationTestCallControl0002");
	}



CCTSYIntegrationTestCallControl0003::CCTSYIntegrationTestCallControl0003(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0003::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0003::~CCTSYIntegrationTestCallControl0003()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0003::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0003
 * @SYMFssID BA/CTSY/CCON-0003
 * @SYMTestCaseDesc Make an outgoing voice call that connects
 * @SYMTestPriority High
 * @SYMTestActions RCall::GetInfo, RCall::GetStatus, RCall::NotifyCapsChange, RCall::NotifyStatusChange, RMobileCall::GetMobileCallCaps, RMobileCall::GetMobileCallInfo, RMobileCall::GetMobileCallStatus, RMobileCall::NotifyMobileCallCapsChange, RMobileCall::NotifyMobileCallStatusChange
 * @SYMTestExpectedResults Pass - Mo call connects.  Call status updates correctly.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify change in call state is reflected in RCall and RMobileCall.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	
	// Check phone supports KCapsVoice
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL		
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// ===  Check call caps ===

	// Check RCall::GetCaps supports KCapsDial | KCapsVoice.
	RCall::TCaps callCaps;
	TUint32 wantedCaps = RCall::KCapsDial | RCall::KCapsVoice;
	ASSERT_EQUALS(call1.GetCaps(callCaps),KErrNone,  
			_L("RCall::GetCaps returned an error"));
	ASSERT_BITS_SET(callCaps.iFlags, wantedCaps, KNoUnwantedBits,  
			_L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::GetMobileCallCaps returns iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 0.
	TUint32 wantedCallControlCaps = RCall::KCapsDial | RCall::KCapsVoice;
	TUint32 wantedCallEventCaps = 0;
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg capsPckg(mobileCallCaps);
	ASSERT_EQUALS(call1.GetMobileCallCaps(capsPckg), KErrNone,   
			_L("RMobileCall::GetMobileCallCaps returned an error"));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedCallControlCaps, KNoUnwantedBits,   
			_L("RMobileCall::GetMobileCallCaps returned wrong caps"));
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedCallEventCaps, KNoUnwantedBits,   
			_L("RMobileCall::GetMobileCallCaps returned wrong caps"));

	// ===  Check call status ===

	// Check RCall::GetStatus returns EStatusIdle.
	RCall::TStatus callStatus;
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
			_L("RCall::GetStatus returned an Error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus did not return EStatusIdle"));
	
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	RMobileCall::TMobileCallStatus mobileCallStatus;
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,    
			_L("RMobileCall::GetMobileCallStatus returned an Error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,    
			_L("RMobileCall::GetMobileCallStatus did not set the status to EStatusIdle"));
	
	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusIdle.
	// Check RCall::GetInfo returns call duration of 0.
	RCall::TCallInfo callInfo;
	ASSERT_EQUALS(call1.GetInfo(callInfo), KErrNone,  
			_L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() >0,  
			_L("RCall::GetInfo returned an invalid  name"));
	ASSERT_TRUE(callInfo.iLineName.Length() >0,  
			_L("RCall::GetInfo returned an invalid  Line name"));
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusIdle,    
			_L("RCall::GetInfo wrong iStatus, should be EStatusIdle"));
	ASSERT_EQUALS(callInfo.iDuration.Int(), 0,    
			_L("RCall::GetInfo wrong iDuration, should be 0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid with correct flags for returned parameters set.
	// Check RMobileCall::GetMobileCallInfo returns valid call name.
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	RMobileCall::TMobileCallInfoV1 mobileCallInfo;
	RMobileCall::TMobileCallInfoV1Pckg callInfoPckg(mobileCallInfo);
	RMobileCall::TMobileCallInfoV1 validCallInfo;
	validCallInfo.iValid = RMobileCall::KCallStartTime;
	ASSERT_EQUALS(call1.GetMobileCallInfo(callInfoPckg), KErrNone,    
			_L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_BITS_SET(mobileCallInfo.iValid, validCallInfo.iValid,KNoUnwantedBits,    
			_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));
	ASSERT_TRUE(mobileCallInfo.iCallName.Length() >0,    
			_L("RMobileCall::GetMobileCallInfo returned an invalid callName"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() >0,    
			_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));

	// post notifier for RCall::NotifyCapsChange
	TCoreEtelRequestStatus<RCall> notifyCapsChangeStatus (call1,&RCall::NotifyCapsChangeCancel);	
	CleanupStack::PushL(notifyCapsChangeStatus);
	call1.NotifyCapsChange(notifyCapsChangeStatus,callCaps);
	
	// post notifier for RMobileCall::NotifyMobileCallCapsChange
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus(call1, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus);
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus,capsPckg);

	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyStatusChangeStatus (call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	
	// post notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);

	// Dial a voice number. 
	TPtrC number; 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,			  
			_L("CTestStep::GetStringFromConfig did not complete as expected"));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, 
			_L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
			_L("RCall::Dial returned with an error"));
		
	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsHangUp.
	RCall::TCaps wantedCaps2, unwantedCaps2;
	wantedCaps2.iFlags = RCall::KCapsVoice | RCall::KCapsHangUp;
	unwantedCaps2.iFlags = 0;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyCapsChange(call1, 
													   notifyCapsChangeStatus,
													   callCaps,
													   wantedCaps2,
													   unwantedCaps2,
													   wantedStatus);
													   
	// Check RCall::GetCaps supports KCapsHangUp | KCapsVoice.
	wantedCaps = RCall::KCapsHangUp | RCall::KCapsVoice;
	ASSERT_EQUALS(call1.GetCaps(callCaps), KErrNone,  
			_L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(callCaps.iFlags, wantedCaps, KNoUnwantedBits,     
			_L("RCall::GetCaps returned unexpected Caps"));

	
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of 
	//			KCapsVoice | KCapsHold | KCapsHangUp | KCapsTransfer.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of 
	//			KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | 
	//			KCapsRemoteConferenceCreate.
	RMobileCall::TMobileCallCapsV1 wantedMobileCaps;
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | 
										RMobileCall::KCapsHold | 
										RMobileCall::KCapsHangUp;
										
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | 
									  RMobileCall::KCapsLocalTransfer | 
									  RMobileCall::KCapsRemoteHold | 
									  RMobileCall::KCapsRemoteTerminate | 
									  RMobileCall::KCapsRemoteConferenceCreate;
									  
	TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps,mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);
												
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of 
	//			KCapsVoice |KCapsHold | KCapsHangUp | KCapsTransfer.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 
	//			KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | 
	//			KCapsRemoteConferenceCreate.
	ASSERT_EQUALS(call1.GetMobileCallCaps(capsPckg), KErrNone, 
			_L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | 
											   RMobileCall::KCapsHold | 
											   RMobileCall::KCapsHangUp;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps,KNoUnwantedBits,
			 _L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));
	
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | 
											 RMobileCall::KCapsLocalTransfer |
											 RMobileCall::KCapsRemoteHold | 
											 RMobileCall::KCapsRemoteTerminate | 
											 RMobileCall::KCapsRemoteConferenceCreate;
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps,KNoUnwantedBits,
			 _L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));										   


	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling -> 
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::NotifyStatusChange completes with EStatusConnecting -> 	
	expectedCallStatus = RCall::EStatusConnecting;
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
													 notifyStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);

	// Check RCall::NotifyStatusChange completes with EStatusConnected.
	expectedCallStatus = RCall::EStatusConnected;
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
													 notifyStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);	
													 												 
	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected, 
			_L("RCall::GetStatus returned an unexpected call status"));
	
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling ->  
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusConnecting ->															
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusConnected.															
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnected;															
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
																														
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, 
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, 
			_L("RMobileCall::GetMobileStatus did not return a status EStatusConnected"));

	
	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusConnected.
	// Check RCall::GetInfo returns call duration of > 0.
	User::After(KOneSecond*1);
	ASSERT_EQUALS(call1.GetInfo(callInfo), KErrNone,  
			_L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() >0,  
			_L("RCall::GetInfo returned an invalid  name"));
	ASSERT_TRUE(callInfo.iLineName.Length() >0,  
			_L("RCall::GetInfo returned an invalid  Line name"));
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected, 
			_L("RCall::GetInfo wrong iStatus, should be EStatusConnected"));
	ASSERT_TRUE(callInfo.iDuration.Int() > 0,  
			_L("RCall::GetInfo wrong iDuration, should be >0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes marked as valid in iValid.
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	ASSERT_EQUALS(call1.GetMobileCallInfo(callInfoPckg), KErrNone, 
			_L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() >0, 
			_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0, 
			_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));

	iCallControlTestHelper.CheckForValidCallInfo(mobileCallInfo, number);
	
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
    
    // hang up the active call
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);
	CleanupStack::PushL(hangUpStatus);		
	call1.HangUp(hangUpStatus);
	WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium);	
	
	// Pop
	// notifyCapsChangeStatus
	// notifyMobileCallCapsChangeStatus
	// notifyStatusChangeStatus
	// notifyMobileCallStatusChangeStatus
	// dialStatus
	// hangUpStatus
	
	CleanupStack::PopAndDestroy(6,&notifyCapsChangeStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0003::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0003");
	}



CCTSYIntegrationTestCallControl0004::CCTSYIntegrationTestCallControl0004(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0004::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0004::~CCTSYIntegrationTestCallControl0004()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0004::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0004
 * @SYMFssID BA/CTSY/CCON-0004
 * @SYMTestCaseDesc Dial a call which remote party rejects.
 * @SYMTestPriority High
 * @SYMTestActions RLine::NotifyStatusChange, RMobileLine::NotifyMobileLineStatusChange, RMobileCall::GetMobileCallStatus, RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange, RLine::GetStatus, RMobileLine::GetMobileLineStatus, RCall::GetStatus
 * @SYMTestExpectedResults Pass - Dial completes with an error.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/rps
 *
 * Reason for test: Verify call and line status after call is rejected.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	
	// Check phone supports KCapsVoice
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL		
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// post a notifier for RLine::NotifyStatusChange
	RCall::TStatus lineStatus;
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine,&RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);

	// post a notifier for RMobileLine::NotifyMobileLineStatusChange
	RMobileCall::TMobileCallStatus mobileLineStatus;
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);

	// post notifier for RCall::NotifyStatusChange
	RCall::TStatus callStatus;
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);

	// post a notifier for RMobileCall::NotifyMobileCallStatusChange
	RMobileCall::TMobileCallStatus mobileCallStatus;
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// Dial RPS which will reject the call. 
	TPtrC number;
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);		
	RPSRejectNextCallL(EVoiceLine);
 	GetRPSNumber(EVoiceLine, number); // Voicemail should be deactivated for this number
	call1.Dial(dialStatus, number);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeVeryLong), KErrNone,  
			_L("RCall::Dial timed-out"));
	ASSERT_TRUE(dialStatus.Int() != KErrNone,  
			_L("RCall::Dial did not return an error"));

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusDialling -> EStatusHangingUp -> EStatusIdle
	RCall::TStatus expectedLineStatus = RCall::EStatusDialling;
	TInt expectedStatus = KErrNone;	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	

	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedLineStatus = RCall::EStatusHangingUp;
	ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10065);
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);	
	 
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedLineStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);	
														 													 
	// Check RLine::GetStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle,  
			_L("RLine::GetStatus did not return EStatusIdle as expected"));
	

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDisconnecting -> EStatusIdle
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusDisconnecting;
	ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10065);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);
																		
	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusIdle 																		
	expectedMobileLineStatus = RMobileCall::EStatusIdle;
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);																
	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle.
	RCall::TStatus expectedCallStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
														 
	expectedCallStatus = RCall::EStatusIdle;
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
			_L("RCall::GetStatus returned an Error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus did not return EStatusIdle"));
	
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);

	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);	


	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileCallStatus did not return EStatusIdle"));
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
    
    // hang up the active call
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium);	
    	
	// Pop
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus
	// notifyCallStatusChangeStatus
	// notifyMobileCallChangeStatus
	// dialStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(6,&notifyStatusChangeStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0004::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0004");
	}



CCTSYIntegrationTestCallControl0005::CCTSYIntegrationTestCallControl0005(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0005::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0005::~CCTSYIntegrationTestCallControl0005()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0005::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0005
 * @SYMFssID BA/CTSY/CCON-0005
 * @SYMTestCaseDesc Dial. Remote end doesn't pick up
 * @SYMTestPriority High
 * @SYMTestActions This requires a mobile SIM with voicemail deactivated. This test will only time out after 100seconds.
 * @SYMTestExpectedResults Pass - Error returned.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/manual
 *
 * Reason for test: Verify error is returned on attempt to dial.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);
	
	// Check phone supports KCapsVoice.
	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL		
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Dial a number which will not answer. 	
	TPtrC number;
	GetStringFromConfig(KIniVoiceNumSection,KIniVoiceNumDoesNotConnect,number);
	TCoreEtelRequestStatus<RMobileCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, number);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeVeryLong), KErrNone, 
                  _L("RCall::Dial timed-out"));	
    // Check Dial request completes with an error
	ASSERT_TRUE(dialStatus.Int() != KErrNone,			 
                _L("RCall::Dial did not return KErrNone"));
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	    
	// hang up the active call
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium);	

	//Pop	
	// dialStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(2,&dialStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0005::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0005");
	}



CCTSYIntegrationTestCallControl0006::CCTSYIntegrationTestCallControl0006(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0006::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0006::~CCTSYIntegrationTestCallControl0006()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0006::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0006
 * @SYMFssID BA/CTSY/CCON-0006
 * @SYMTestCaseDesc Dial when no network is present
 * @SYMTestPriority High
 * @SYMTestActions RCall::Dial
 * @SYMTestExpectedResults Pass - KErrGsmOfflineOpNotAllowed returned.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/manual
 *
 * Reason for test: Verify error is returned on attempt to dial.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	
	// Check phone supports KCapsVoice.
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);
	
	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits, 
			_L("RLine::GetCaps returned wrong caps"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
		
	// Remove aerial from phone. 

	// Check RMobilePhone::GetNetworkRegistrationStatus returns one of ENotRegisteredNoService | ENotRegisteredSearching
	RMobilePhone::TMobilePhoneRegistrationStatus registrationStatus;
	TExtEtelRequestStatus getNWRegistraionStatusStatus(phone,EMobilePhoneGetNetworkRegistrationStatus);
	CleanupStack::PushL(getNWRegistraionStatusStatus);
	phone.GetNetworkRegistrationStatus(getNWRegistraionStatusStatus,registrationStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(getNWRegistraionStatusStatus, ETimeMedium), KErrNone,  
			_L("RMobilePhone::GetNetworkRegistrationStatus timed out"));	
	ASSERT_EQUALS(getNWRegistraionStatusStatus.Int(), KErrNone,  
			_L("RMobilePhone::GetNetworkRegistrationStatus returned an error"));
	ASSERT_TRUE(((registrationStatus == RMobilePhone::ENotRegisteredNoService) || (registrationStatus ==RMobilePhone::ENotRegisteredSearching)),			 
			_L("RMobilePhone::GetNetworkRegistrationStatus did not set the registration status to ENotRegisteredNoService | ENotRegisteredSearching"));

	// Dial a number. 
	TCoreEtelRequestStatus<RMobileCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);		
	TPtrC number;
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,  
			_L("GetStringFromConfig did not complete as expected"));
	call1.Dial(dialStatus, number);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeLong), KErrNone,  
			_L("RCall::Dial timed-out"));

	// Check KErrGsmOfflineOpNotAllowed or KErrGsmNoService is returned.
	ASSERT_TRUE( ((dialStatus.Int() == KErrGsmOfflineOpNotAllowed) || (dialStatus.Int() == KErrGsmNoService) ),  
			_L("RCall::Dial did not return KErrGsmOfflineOpNotAllowed nor KErrGsmNoService"));

	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();

    // hang up the active call
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium);	
		
	// Pop
	// getNWRegistraionStatusStatus
	// dialStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(3, &getNWRegistraionStatusStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0006::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0006");
	}



CCTSYIntegrationTestCallControl0007::CCTSYIntegrationTestCallControl0007(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0007::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0007::~CCTSYIntegrationTestCallControl0007()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0007::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0007
 * @SYMFssID BA/CTSY/CCON-0007
 * @SYMTestCaseDesc Make a voice call to remote party that is engaged.
 * @SYMTestPriority High
 * @SYMTestActions RMobileLine::NotifyMobileLineStatusChange, RMobileCall::GetMobileCallStatus, RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange, RLine::GetStatus, RMobileLine::GetMobileLineStatus, RCall::GetStatus, RCall::Dial
 * @SYMTestExpectedResults Pass - Dialling to a busy number fails.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify dialling fails and line returns to idle.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL		
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// post notifier for RCall::NotifyStatusChange
	RCall::TStatus callStatus;
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);

	// post a notifier for RMobileCall::NotifyMobileCallStatusChange
	RMobileCall::TMobileCallStatus mobileCallStatus;
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// post a notifier for RLine::NotifyStatusChange
	RCall::TStatus lineStatus;
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine,&RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);

	// post a notifier for RMobileLine::NotifyMobileLineStatusChange
	RMobileCall::TMobileCallStatus mobileLineStatus;
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);

	// Set RPS to simulate an engaged remote party. 
	TPtrC number;
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,  
			_L("GetStringFromConfig did not complete as expected"));
	RPSDialNumberL(number,EVoiceLine);
	
	// Dial RPS. 
	TPtrC engagedNumber;
	GetRPSNumber(EVoiceLine,engagedNumber); //this will return KIniVoiceNumber2 if not using RPS, 
											 //This should be the phone which is engaged, if testing manually.
	TCoreEtelRequestStatus<RMobileCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);											 
	call1.Dial(dialStatus, engagedNumber);

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	const TInt expectedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
														 
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);


	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusDialling.
	RCall::TStatus expectedLineStatus = RCall::EStatusDialling;	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);

	// Check RLine::GetStatus returns EStatusDialling
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusDialling,  
			_L("RLine::GetStatus did not return EStatusDialling as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDialling .
	expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
																		
	// Check RMobileLine::GetMobileLineStatus returns EStatusDialling
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone, 
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusDialling,  
			_L("RMobileLine::GetMobileLineStatus did not set the status to EStatusDialling"));

	// Check dial fails because line is engaged.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeLong), KErrNone,  
			_L("RCall::Dial timed-out"));
	ASSERT_TRUE(dialStatus.Int() !=  KErrNone,  
			_L("RCall::Dial Should have failed because engaged"));

	// ===  Check line goes back to idle ===
	// post notifier for RLine::NotifyStatusChange
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	// Check RLine::NotifyStatusChange completes with RCall::EStatusIdle
	expectedLineStatus = RCall::EStatusIdle;	
	ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10065);
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);

	// Check RLine::GetStatus returns RCall::EStatusIdle
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle,  
			_L("RLine::GetStatus did not return EStatusIdle as expected"));
	
	// ===  Check call status goes back to idle ===

	// Check RCall::NotifyStatusChange completes with EStatusIdle.
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus did not return EStatusIdle"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusIdle.
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10066);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileCallStatus did not return EStatusIdle"));

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();

	// tell RPS to hang up after 0 seconds
	RPSHangupL(EVoiceLine,0);
	
	// Pop
	// notifyCallStatusChangeStatus
	// notifyMobileCallChangeStatus
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus
	// dialStatus
	CleanupStack::PopAndDestroy(5, &notifyCallStatusChangeStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0007::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0007");
	}



CCTSYIntegrationTestCallControl0008::CCTSYIntegrationTestCallControl0008(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0008::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0008::~CCTSYIntegrationTestCallControl0008()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0008::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0008
 * @SYMFssID BA/CTSY/CCON-0008
 * @SYMTestCaseDesc Make a call to an international number
 * @SYMTestPriority High
 * @SYMTestActions RLine::NotifyStatusChange, RLine::GetStatus, RMobileLine::NotifyMobileLineStatusChange, RMobileLine::GetMobileLineStatus, RCall::NotifyStatusChange, RCall::GetStatus, RMobileCall::NotifyMobileCallStatusChange, RMobileCall::GetMobileCallStatus, RCall::HangUp, RCall::GetInfo, RMobileCall::GetMobileCallInfo
 * @SYMTestExpectedResults Pass - Can dial international numbers
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify international number can be dialled and line and call statuses are correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// ===  Check call status ===

	// Check RCall::GetStatus returns EStatusIdle or EStatusUnknown.
	RCall::TStatus callStatus;
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_TRUE(callStatus == RCall::EStatusIdle || 
				callStatus == RCall::EStatusUnknown,  
			_L("RCall::GetStatus did not set call status EStatusIdle or EStatusUnknown as expected"));
	
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle or EStatusUnknown.
	RMobileCall::TMobileCallStatus mobileCallStatus;
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_TRUE(mobileCallStatus == RMobileCall::EStatusUnknown ||
		        mobileCallStatus == RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileCallStatus did not set call status EStatusIdle or EStatusUnknown as expected"));

	// ===  Check line status ===

	// Check RLine::GetStatus returns EStatusIdle or EStatusUnknown.
	ASSERT_EQUALS(voiceLine.GetStatus(callStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_TRUE(callStatus == RCall::EStatusUnknown || 
				callStatus == RCall::EStatusIdle,  
			_L("RLine::GetStatus did not set call status to EStatusIdle or EStatusUnknown as expected"));

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle or EStatusUnknown.
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileCallStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_TRUE(mobileCallStatus == RMobileCall::EStatusUnknown || 
				mobileCallStatus == RMobileCall::EStatusIdle,  
			_L("RMobileLine::GetMobileLineStatus did not set status to EStatusIdle or EStatusUnknown"));

	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);

	// post a notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	

	// post a notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine,&RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus lineStatus;
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);

	// post a notifier for RMobileLine::NotifyMobileLineStatusChange
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	RMobileCall::TMobileCallStatus mobileLineStatus;
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);

		
	// Dial a number with a + prefix where remote party answers. 
	TPtrC number;
	GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber2, number);
	TCoreEtelRequestStatus<RMobileCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);											 
	call1.Dial(dialStatus, number);	
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone,  
			_L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
			_L("RCall::Dial returned with an error"));

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	const TInt expectedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
														 
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnecting;	
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);	
														 
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnected;	
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);	
														 													 
	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected,  
			_L("RCall::GetStatus did not set call status EStatusConnected as expected"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnected;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
																																																							
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
			_L("RMobileCall::GetMobileCallStatus did not set call status EStatusConnected as expected"));

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedLineStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	expectedLineStatus = RCall::EStatusConnecting;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	expectedLineStatus = RCall::EStatusConnected;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
														 														 
	// Check RLine::GetStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetStatus(callStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected,  
			_L("RLine::GetStatus did not set call status to EStatusConnected as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);
																		
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);
																		
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);	
																																																							
	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileCallStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
			_L("RMobileLine::GetMobileLineStatus did not set status to EStatusConnected"));

	// ===  Check call info ===

    // Wait 3 seconds, so that the call duration will be more then 0 seconds
    User::After(3*KOneSecond);

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusConnected.
	// Check RCall::GetInfo returns call duration of > 0.
	RCall::TCallInfo callInfo;
	ASSERT_EQUALS(call1.GetInfo(callInfo), KErrNone,  
			_L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() >0,  
			_L("RCall::GetInfo returned an invalid  name"));
	ASSERT_TRUE(callInfo.iLineName.Length() >0,  
			_L("RCall::GetInfo returned an invalid  Line name"));
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected,  
			_L("RCall::GetInfo wrong iStatus, should be EStatusIdle"));
	ASSERT_TRUE(callInfo.iDuration.Int()>0,  
			_L("RCall::GetInfo wrong iDuration, should be > 0"));
	
	

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes marked as valid in iValid.
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	// Check RMobileCall::GetMobileCallInfo returns correct number for iDialledParty.iTelNumber
	// Check RMobileCall::GetMobileCallInfo returns iDialledParty.iTypeOfNumber of EInternationalNumber
	RMobileCall::TMobileCallInfoV1 mobileCallInfo;
	RMobileCall::TMobileCallInfoV1Pckg callInfoPckg(mobileCallInfo);
	ASSERT_EQUALS(call1.GetMobileCallInfo(callInfoPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0,  
			_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));
	ASSERT_TRUE(mobileCallInfo.iCallName.Length() >0,  
			_L("RMobileCall::GetMobileCallInfo returned an invalid callName"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() >0,  
			_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_EQUALS_DES16(mobileCallInfo.iDialledParty.iTelNumber, number,  
			_L("RMobileCall::GetMobileCallInfo returned incorrect number for iDialledParty.iTelNumber"));
	ASSERT_EQUALS(mobileCallInfo.iDialledParty.iTypeOfNumber, RMobilePhone::EInternationalNumber,  
			_L("RMobileCall::GetMobileCallInfo returned incorrect type for iDialledParty.iTypeOfNumber"));


	//------------ Post Notifiers ----------------------------
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);

    
	// Hang up. 
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone,  
			_L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone,  
			_L("RCall::HangUp returned an error"));
	
	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle.
	expectedCallStatus = RCall::EStatusHangingUp;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
													 notifyStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);
													 
	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle.
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// ===  Check line status ===

	// Check RMobileLine::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedLineStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
														 
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedLineStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
    voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	// Check RMobileLine::GetStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle,  
			_L("RLine::GetStatus did not return EStatusIdle as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDisconnecting -> EStatusIdle
	expectedMobileLineStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);
	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusIdle,  
			_L("RMobileLine::GetMobileLineStatus did not set the status to EStatusIdle"));

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop:
	//	hangUpStatus
	//	dialStatus
	//	notifyMobileLineChangeStatus
	//	notifyStatusChangeStatus
	//	notifyMobileCallChangeStatus
	//	notifyCallStatusChangeStatus
	CleanupStack::PopAndDestroy(6,&notifyCallStatusChangeStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0008::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0008");
	}



CCTSYIntegrationTestCallControl0009::CCTSYIntegrationTestCallControl0009(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0009::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0009::~CCTSYIntegrationTestCallControl0009()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0009::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0009
 * @SYMFssID BA/CTSY/CCON-0009
 * @SYMTestCaseDesc Dial and hang up a call specifying valid call parameters 01.
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyStatusChange, RLine::NotifyStatusChange, RMobileLine::GetMobileLineStatus, RMobileLine::NotifyMobileLineStatusChange, RLine::GetStatus, RMobileCall::GetMobileCallStatus, RCall::GetCallParams, RCall::GetStatus, RCall::GetCallParams, RCall::GetStatus, RCall::HangUp
 * @SYMTestExpectedResults Pass - Call connects and call parameters are correct.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call and line statuses and call params are correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////
	
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	
	// Check phone supports KCapsVoice

	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL		
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Populate RMobileCall::TMobileCallParamsV1 with  
	RMobileCall::TMobileCallParamsV1 mobileCallParams;
	// ?iSpeakerControl = EMonitorSpeakerControlAlwaysOff 
	mobileCallParams.iSpeakerControl = RCall::EMonitorSpeakerControlAlwaysOff;
	// ?iSpeakerVolume = EMonitorSpeakerVolumeOff 
	mobileCallParams.iSpeakerVolume = RCall::EMonitorSpeakerVolumeOff;
	// ?iInterval = 0x01 
	mobileCallParams.iInterval = 0x01;
	// ?iWaitForDialTone = EDialToneWait 
	mobileCallParams.iWaitForDialTone = RCall::EDialToneWait;
	// ?iIdRestrict = EIdRestrictDefault 
	mobileCallParams.iIdRestrict = RMobileCall::EIdRestrictDefault;	
	// ?iExplicitInvoke = TRUE 
	mobileCallParams.iCug.iExplicitInvoke = TRUE ;
	// ?iCugIndex = 0x0000 
	mobileCallParams.iCug.iCugIndex = 0x0000;
	// ?iSuppressOA = FALSE 
	mobileCallParams.iCug.iSuppressOA = FALSE;
	// ?iSuppressPrefCug = TRUE 
	mobileCallParams.iCug.iSuppressPrefCug = TRUE;
	// ?iAutoRedial = TRUE 
	mobileCallParams.iAutoRedial = TRUE;
	
	RMobileCall::TMobileCallParamsV1Pckg mobileCallParamsPkg(mobileCallParams);

	//=========Post Notifiers===============
		
	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	RCall::TStatus callStatus;
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);

	// post a notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// post a notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine,&RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus lineStatus;
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);

	// post a notifier for RMobileLine::NotifyMobileLineStatusChange
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	RMobileCall::TMobileCallStatus mobileLineStatus;
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	
	
	//======= Dial a number which answers using call params. 
	TCoreEtelRequestStatus<RMobileCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);		
	TPtrC number;
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,  
			_L("GetStringFromConfig did not complete as expected"));
	call1.Dial(dialStatus,mobileCallParamsPkg, number);
	// Wait for completion. 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone,  
			_L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
			_L("RCall::Dial returned an error"));
	
	const TInt expectedStatus = KErrNone;
	
	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedLineStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);

	expectedLineStatus = RCall::EStatusConnecting;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	
	expectedLineStatus = RCall::EStatusConnected;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	
	// Check RLine::GetStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusConnected,  
			_L("RLine::GetStatus did not set line status to EStatusConnected as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);	

	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusConnected,  
			_L("RMobileLine::GetMobileLineStatus did not set status to EStatusConnected"));
	
	// ===  Check call status ===
	
	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
	
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
	DEBUG_PRINTF1(_L("3"));
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);		
								 												 
	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(voiceLine.GetStatus(callStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected,  
			_L("RLine::GetStatus did not return EStatusConnected as expected"));
	DEBUG_PRINTF1(_L("5 check for mobile call dialling"));
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
	
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);

	expectedMobileCallStatus = RMobileCall::EStatusConnected;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
																	
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
			_L("RMobileCall::GetMobileCallStatus did not set call status EStatusConnected as expected"));

	
	// ===  Get call parameters. ===
	RMobileCall::TMobileCallParamsV1 checkParams;
	RMobileCall::TMobileCallParamsV1Pckg checkParamsPkg(checkParams);
	call1.GetCallParams(checkParamsPkg);
	
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iSpeakerControl as that used for Dial.
	ASSERT_EQUALS(checkParams.iSpeakerControl,  mobileCallParams.iSpeakerControl,  
			_L("RCall::GetCallParams did not return the same iSpeakerControl as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iSpeakerVolume as that used for Dial.
	ASSERT_EQUALS(checkParams.iSpeakerVolume, mobileCallParams.iSpeakerVolume,  
			_L("RCall::GetCallParams did not return the same iSpeakerVolume as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iInterval as that used for Dial.
	ASSERT_EQUALS(checkParams.iInterval, mobileCallParams.iInterval,  
			_L("RCall::GetCallParams did not return the same iInterval as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iWaitForDialTone as that used for Dial.
	ASSERT_EQUALS(checkParams.iWaitForDialTone, mobileCallParams.iWaitForDialTone,  
			_L("RCall::GetCallParams did not return the same iWaitForDialTone as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iIdRestrict as that used for Dial.
	ASSERT_EQUALS(checkParams.iIdRestrict, mobileCallParams.iIdRestrict,  
			_L("RCall::GetCallParams did not return the same iIdRestrict as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iExplicitInvoke as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iExplicitInvoke, mobileCallParams.iCug.iExplicitInvoke,  
			_L("RCall::GetCallParams did not return the same iCug.iExplicitInvoke as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iCugIndex as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iCugIndex, mobileCallParams.iCug.iCugIndex,  
			_L("RCall::GetCallParams did not return the same iCug.iCugIndex as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iSuppressPrefCug as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iSuppressPrefCug, mobileCallParams.iCug.iSuppressPrefCug,  
			_L("RCall::GetCallParams did not return the same iCug.iSuppressPrefCug as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iSuppressOA as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iSuppressOA, mobileCallParams.iCug.iSuppressOA,  
			_L("RCall::GetCallParams did not return the same iCug.iSuppressOA as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iAutoRedial as that used for Dial.
	ASSERT_EQUALS(checkParams.iAutoRedial, mobileCallParams.iAutoRedial,  
			_L("RCall::GetCallParams did not return the same iAutoRedial as that used for Dial"));

	
	//------------ Post Notifiers ----------------------------
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);	

	// Hang up call. 
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone,  
			_L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone,  
			_L("RCall::HangUp returned an error"));
	
	// ===  Check call status ===
		
	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedCallStatus = RCall::EStatusHangingUp;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
													 notifyStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);
	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus returned an unexpected call status"));
	
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
																
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
							
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// ===  Check line status ===
	
	// Check RLine::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	DEBUG_PRINTF1(_L("12"));
	expectedLineStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
															 
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedLineStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
													 
	// Check RLine::GetStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle,  
			_L("RLine::GetStatus did not return EStatusIdle as expected"));
	
	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDisconnecting -> EStatusIdle
	DEBUG_PRINTF1(_L("13"));
	expectedMobileLineStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);
	
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);
	
	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusIdle,  
			_L("RMobileLine::GetMobileLineStatus did not set the status to EStatusIdle"));

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
	// notifyCallStatusChangeStatus
	// notifyMobileCallChangeStatus
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus 
    // dialStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(6,&notifyCallStatusChangeStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0009::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0009");
	}



CCTSYIntegrationTestCallControl0010::CCTSYIntegrationTestCallControl0010(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0010::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0010::~CCTSYIntegrationTestCallControl0010()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0010::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0010
 * @SYMFssID BA/CTSY/CCON-0010
 * @SYMTestCaseDesc Dial and hang up a call specifying valid call parameters 02.
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyStatusChange, RLine::NotifyStatusChange, RMobileLine::GetMobileLineStatus, RMobileLine::NotifyMobileLineStatusChange, RLine::GetStatus, RMobileCall::GetMobileCallStatus, RCall::GetCallParams, RCall::GetStatus, RCall::GetCallParams, RCall::GetStatus, RCall::HangUp
 * @SYMTestExpectedResults Pass - Call connects and call parameters are correct.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call and line statuses and call params are correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	
	// Check phone supports KCapsVoice
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Populate RMobileCall::TMobileCallParamsV1 with  
	RMobileCall::TMobileCallParamsV1 mobileCallParams;
	RMobileCall::TMobileCallParamsV1Pckg mobileCallParamsPkg(mobileCallParams);
	// ?iSpeakerControl = EMonitorSpeakerControlAlwaysOff 
	mobileCallParams.iSpeakerControl = RCall::EMonitorSpeakerControlAlwaysOff;
	// ?iSpeakerVolume = EMonitorSpeakerVolumeHigh 
	mobileCallParams.iSpeakerVolume = RCall::EMonitorSpeakerVolumeHigh;
	// ?iInterval = 0x02 
	mobileCallParams.iInterval = 0x02;
	// ?iWaitForDialTone = EDialToneWait 
	mobileCallParams.iWaitForDialTone = RCall::EDialToneWait;
	// ?iIdRestrict = ESendMyId 
	mobileCallParams.iIdRestrict = RMobileCall::ESendMyId;	
	// ?iExplicitInvoke = FALSE 
	mobileCallParams.iCug.iExplicitInvoke = FALSE ;
	// ?iCugIndex = 0x0000 
	mobileCallParams.iCug.iCugIndex = 0x0000;
	// ?iSuppressOA = FALSE 
	mobileCallParams.iCug.iSuppressOA = FALSE;
	// ?iSuppressPrefCug = FALSE 
	mobileCallParams.iCug.iSuppressPrefCug = FALSE;
	// ?iAutoRedial = FALSE 
	mobileCallParams.iAutoRedial = FALSE;

	//=========Post Notifiers===============
		
	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	RCall::TStatus callStatus;
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);

	// post a notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// post a notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine,&RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus lineStatus;
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);

	// post a notifier for RMobileLine::NotifyMobileLineStatusChange
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	RMobileCall::TMobileCallStatus mobileLineStatus;
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
		
	// Dial a number which answers using call params. 
	TCoreEtelRequestStatus<RMobileCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);		
	TPtrC number;
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,  
			_L("GetStringFromConfig did not complete as expected"));
	call1.Dial(dialStatus,mobileCallParamsPkg, number);
	// Wait for completion. 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone,  
			_L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
			_L("RCall::Dial returned an error"));


	// ===  Check line status ===

	const TInt expectedStatus = KErrNone;
	
	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedLineStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);

	expectedLineStatus = RCall::EStatusConnecting;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	
	expectedLineStatus = RCall::EStatusConnected;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	
	// Check RLine::GetStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusConnected,  
			_L("RLine::GetStatus did not set line status to EStatusConnected as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);	

	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusConnected,  
			_L("RMobileLine::GetMobileLineStatus did not set status to EStatusConnected"));
	
	// ===  Check call status ===
	
	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
	
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);

	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);		
								 												 
	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(voiceLine.GetStatus(callStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected,  
			_L("RLine::GetStatus did not return EStatusConnected as expected"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
	
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);

	expectedMobileCallStatus = RMobileCall::EStatusConnected;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
																	
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
			_L("RMobileCall::GetMobileCallStatus did not set call status EStatusConnected as expected"));
	
	// ===  Get call parameters. ===
	RMobileCall::TMobileCallParamsV1 checkParams;
	RMobileCall::TMobileCallParamsV1Pckg checkParamsPkg(checkParams);
	call1.GetCallParams(checkParamsPkg);
	
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iSpeakerControl as that used for Dial.
	ASSERT_EQUALS(checkParams.iSpeakerControl,  mobileCallParams.iSpeakerControl,  
			_L("RCall::GetCallParams did not return the same iSpeakerControl as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iSpeakerVolume as that used for Dial.
	ASSERT_EQUALS(checkParams.iSpeakerVolume, mobileCallParams.iSpeakerVolume,  
			_L("RCall::GetCallParams did not return the same iSpeakerVolume as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iInterval as that used for Dial.
	ASSERT_EQUALS(checkParams.iInterval, mobileCallParams.iInterval,  
			_L("RCall::GetCallParams did not return the same iInterval as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iWaitForDialTone as that used for Dial.
	ASSERT_EQUALS(checkParams.iWaitForDialTone, mobileCallParams.iWaitForDialTone,  
			_L("RCall::GetCallParams did not return the same iWaitForDialTone as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iIdRestrict as that used for Dial.
	ASSERT_EQUALS(checkParams.iIdRestrict, mobileCallParams.iIdRestrict,  
			_L("RCall::GetCallParams did not return the same iIdRestrict as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iExplicitInvoke as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iExplicitInvoke, mobileCallParams.iCug.iExplicitInvoke,  
			_L("RCall::GetCallParams did not return the same iCug.iExplicitInvoke as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iCugIndex as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iCugIndex, mobileCallParams.iCug.iCugIndex,  
			_L("RCall::GetCallParams did not return the same iCug.iCugIndex as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iSuppressPrefCug as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iSuppressPrefCug, mobileCallParams.iCug.iSuppressPrefCug,  
			_L("RCall::GetCallParams did not return the same iCug.iSuppressPrefCug as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iSuppressOA as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iSuppressOA, mobileCallParams.iCug.iSuppressOA,  
			_L("RCall::GetCallParams did not return the same iCug.iSuppressOA as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iAutoRedial as that used for Dial.
	ASSERT_EQUALS(checkParams.iAutoRedial, mobileCallParams.iAutoRedial,  
			_L("RCall::GetCallParams did not return the same iAutoRedial as that used for Dial"));

	//------------ Post Notifiers ----------------------------
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);	

	// Hang up call. 
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone,  
			_L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone,  
			_L("RCall::HangUp returned an error"));

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedCallStatus = RCall::EStatusHangingUp;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
													 notifyStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);
	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedLineStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
														 
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedLineStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
														 
	// Check RLine::GetStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle,  
			_L("RLine::GetStatus did not return EStatusIdle as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDisconnecting -> EStatusIdle
	expectedMobileLineStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusIdle,  
			_L("RMobileLine::GetMobileLineStatus did not set the status to EStatusIdle"));

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
	// notifyCallStatusChangeStatus
	// notifyMobileCallChangeStatus
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus
    // dialStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(6,&notifyCallStatusChangeStatus);	
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0010::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0010");
	}



CCTSYIntegrationTestCallControl0011::CCTSYIntegrationTestCallControl0011(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0011::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0011::~CCTSYIntegrationTestCallControl0011()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0011::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0011
 * @SYMFssID BA/CTSY/CCON-0011
 * @SYMTestCaseDesc Dial and hang up a call specifying valid call parameters 03.
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyStatusChange, RLine::NotifyStatusChange, RMobileLine::GetMobileLineStatus, RMobileLine::NotifyMobileLineStatusChange, RLine::GetStatus, RMobileCall::GetMobileCallStatus, RCall::GetCallParams, RCall::GetStatus, RCall::GetCallParams, RCall::GetStatus, RCall::HangUp
 * @SYMTestExpectedResults Pass - Call connects and call parameters are correct.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call and line statuses and call params are correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	
	// Check phone supports KCapsVoice
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Populate RMobileCall::TMobileCallParamsV1 with  
	RMobileCall::TMobileCallParamsV1 mobileCallParams;
	RMobileCall::TMobileCallParamsV1Pckg mobileCallParamsPkg(mobileCallParams);
	// ?iSpeakerControl = EMonitorSpeakerControlUnknown 
	mobileCallParams.iSpeakerControl = RCall::EMonitorSpeakerControlUnknown;
	// ?iSpeakerVolume = EMonitorSpeakerVolumeUnknown 
	mobileCallParams.iSpeakerVolume = RCall::EMonitorSpeakerVolumeUnknown;
	// ?iInterval = 0x03 
	mobileCallParams.iInterval = 0x03;
	// ?iWaitForDialTone = EDialToneWait 
	mobileCallParams.iWaitForDialTone = RCall::EDialToneWait;
	// ?iIdRestrict = EDontSendMyId 
	mobileCallParams.iIdRestrict = RMobileCall::EDontSendMyId;
	// ?iExplicitInvoke = TRUE 
	mobileCallParams.iCug.iExplicitInvoke = TRUE;
	// ?iCugIndex = 0x9c40 
	mobileCallParams.iCug.iCugIndex = 0x9c40 ;
	// ?iSuppressOA = FALSE 
	mobileCallParams.iCug.iSuppressOA = FALSE;
	// ?iSuppressPrefCug = TRUE 
	mobileCallParams.iCug.iSuppressPrefCug = TRUE;
	// ?iAutoRedial = TRUE 
	mobileCallParams.iAutoRedial = TRUE;



	//=========Post Notifiers===============
		
	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	RCall::TStatus callStatus;
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);

	// post a notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// post a notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine,&RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus lineStatus;
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);

	// post a notifier for RMobileLine::NotifyMobileLineStatusChange
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	RMobileCall::TMobileCallStatus mobileLineStatus;
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
		
	// Dial a number which answers using call params. 
	TCoreEtelRequestStatus<RMobileCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);		
	TPtrC number;
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,  
			_L("GetStringFromConfig did not complete as expected"));
	call1.Dial(dialStatus,mobileCallParamsPkg, number);
	// Wait for completion. 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone,  
			_L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
			_L("RCall::Dial returned an error"));

	// ===  Check line status ===
	TInt expectedStatus = KErrNone;
	
	// Check RLine::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedLineStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);

	expectedLineStatus = RCall::EStatusConnecting;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	
	expectedLineStatus = RCall::EStatusConnected;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	
	// Check RLine::GetStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusConnected,  
			_L("RLine::GetStatus did not set line status to EStatusConnected as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);


	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);	

	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusConnected,  
			_L("RMobileLine::GetMobileLineStatus did not set status to EStatusConnected"));
	
	// ===  Check call status ===
	
	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;

	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
	
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);

	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);		
								 												 
	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(voiceLine.GetStatus(callStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected,  
			_L("RLine::GetStatus did not return EStatusConnected as expected"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
	
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);

	expectedMobileCallStatus = RMobileCall::EStatusConnected;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
																	
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
			_L("RMobileCall::GetMobileCallStatus did not set call status EStatusConnected as expected"));

	// ===  Get call parameters. ===
	RMobileCall::TMobileCallParamsV1 checkParams;
	RMobileCall::TMobileCallParamsV1Pckg checkParamsPkg(checkParams);
	call1.GetCallParams(checkParamsPkg);
	
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iSpeakerControl as that used for Dial.
	ASSERT_EQUALS(checkParams.iSpeakerControl,  mobileCallParams.iSpeakerControl,  
			_L("RCall::GetCallParams did not return the same iSpeakerControl as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iSpeakerVolume as that used for Dial.
	ASSERT_EQUALS(checkParams.iSpeakerVolume, mobileCallParams.iSpeakerVolume,  
			_L("RCall::GetCallParams did not return the same iSpeakerVolume as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iInterval as that used for Dial.
	ASSERT_EQUALS(checkParams.iInterval, mobileCallParams.iInterval,  
			_L("RCall::GetCallParams did not return the same iInterval as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iWaitForDialTone as that used for Dial.
	ASSERT_EQUALS(checkParams.iWaitForDialTone, mobileCallParams.iWaitForDialTone,  
			_L("RCall::GetCallParams did not return the same iWaitForDialTone as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iIdRestrict as that used for Dial.
	ASSERT_EQUALS(checkParams.iIdRestrict, mobileCallParams.iIdRestrict,  
			_L("RCall::GetCallParams did not return the same iIdRestrict as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iExplicitInvoke as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iExplicitInvoke, mobileCallParams.iCug.iExplicitInvoke,  
			_L("RCall::GetCallParams did not return the same iCug.iExplicitInvoke as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iCugIndex as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iCugIndex, mobileCallParams.iCug.iCugIndex,  
			_L("RCall::GetCallParams did not return the same iCug.iCugIndex as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iSuppressPrefCug as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iSuppressPrefCug, mobileCallParams.iCug.iSuppressPrefCug,  
			_L("RCall::GetCallParams did not return the same iCug.iSuppressPrefCug as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iSuppressOA as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iSuppressOA, mobileCallParams.iCug.iSuppressOA,  
			_L("RCall::GetCallParams did not return the same iCug.iSuppressOA as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iAutoRedial as that used for Dial.
	ASSERT_EQUALS(checkParams.iAutoRedial, mobileCallParams.iAutoRedial,  
			_L("RCall::GetCallParams did not return the same iAutoRedial as that used for Dial"));

	//------------ Post Notifiers ----------------------------
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);	

	// Hang up call. 
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone,  
			_L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone,  
			_L("RCall::HangUp returned an error"));

	// ===  Check call status ===
	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedCallStatus = RCall::EStatusHangingUp;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
													 notifyStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);
	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedLineStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
														 
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedLineStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
														 
	// Check RLine::GetStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle,  
			_L("RLine::GetStatus did not return EStatusIdle as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDisconnecting -> EStatusIdle
	expectedMobileLineStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusIdle,  
			_L("RMobileLine::GetMobileLineStatus did not set the status to EStatusIdle"));

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
	// notifyCallStatusChangeStatus
	// notifyMobileCallChangeStatus
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus 
    // dialStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(6,&notifyCallStatusChangeStatus);	
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0011::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0011");
	}



CCTSYIntegrationTestCallControl0012::CCTSYIntegrationTestCallControl0012(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0012::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0012::~CCTSYIntegrationTestCallControl0012()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0012::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0012
 * @SYMFssID BA/CTSY/CCON-0012
 * @SYMTestCaseDesc Dial and hang up a call specifying valid call parameters 04.
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyStatusChange, RLine::NotifyStatusChange, RMobileLine::GetMobileLineStatus, RMobileLine::NotifyMobileLineStatusChange, RLine::GetStatus, RMobileCall::GetMobileCallStatus, RCall::GetCallParams, RCall::GetStatus, RCall::GetCallParams, RCall::GetStatus, RCall::HangUp
 * @SYMTestExpectedResults Pass - Call connects and call parameters are correct.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call and line statuses and call params are correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	
	// Check phone supports KCapsVoice
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Populate RMobileCall::TMobileCallParamsV1 with  
	RMobileCall::TMobileCallParamsV1 mobileCallParams;
	RMobileCall::TMobileCallParamsV1Pckg mobileCallParamsPkg(mobileCallParams);

	// ?iSpeakerControl = EMonitorSpeakerControlOnExceptDuringDialling 
	mobileCallParams.iSpeakerControl = RCall::EMonitorSpeakerControlOnExceptDuringDialling;
	// ?iSpeakerVolume = EMonitorSpeakerVolumeUnknown 
	mobileCallParams.iSpeakerVolume = RCall::EMonitorSpeakerVolumeUnknown;
	// ?iInterval = 0x02 
	mobileCallParams.iInterval = 0x02;
	// ?iWaitForDialTone = EDialToneWait 
	mobileCallParams.iWaitForDialTone = RCall::EDialToneWait;
	// ?iIdRestrict = ESendMyId 
	mobileCallParams.iIdRestrict = RMobileCall::ESendMyId;	
	// ?iExplicitInvoke = FALSE 
	mobileCallParams.iCug.iExplicitInvoke = FALSE ;
	// ?iCugIndex = 0x00 
	mobileCallParams.iCug.iCugIndex = 0x0000;
	// ?iSuppressOA = FALSE 
	mobileCallParams.iCug.iSuppressOA = FALSE;
	// ?iSuppressPrefCug = FALSE 
	mobileCallParams.iCug.iSuppressPrefCug = FALSE;
	// ?iAutoRedial = FALSE 
	mobileCallParams.iAutoRedial = FALSE;

	//=========Post Notifiers===============
		
	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	RCall::TStatus callStatus;
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);

	// post a notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// post a notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine,&RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus lineStatus;
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);

	// post a notifier for RMobileLine::NotifyMobileLineStatusChange
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	RMobileCall::TMobileCallStatus mobileLineStatus;
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
		
	// Dial a number which answers using call params. 
	TCoreEtelRequestStatus<RMobileCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);		
	TPtrC number;
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,  
			_L("GetStringFromConfig did not complete as expected"));
	call1.Dial(dialStatus,mobileCallParamsPkg, number);
	// Wait for completion. 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone,  
			_L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
			_L("RCall::Dial returned an error"));

	// ===  Check line status ===

	TInt expectedStatus = KErrNone;
	
	// Check RLine::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedLineStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);

	expectedLineStatus = RCall::EStatusConnecting;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	
	expectedLineStatus = RCall::EStatusConnected;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	
	// Check RLine::GetStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusConnected,  
			_L("RLine::GetStatus did not set line status to EStatusConnected as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);	

	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusConnected,  
			_L("RMobileLine::GetMobileLineStatus did not set status to EStatusConnected"));
	
	// ===  Check call status ===
	
	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;

	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
	
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);

	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);		
								 												 
	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(voiceLine.GetStatus(callStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected,  
			_L("RLine::GetStatus did not return EStatusConnected as expected"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
	
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);

	expectedMobileCallStatus = RMobileCall::EStatusConnected;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
																	
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
			_L("RMobileCall::GetMobileCallStatus did not set call status EStatusConnected as expected"));

	// ===  Get call parameters. ===
	RMobileCall::TMobileCallParamsV1 checkParams;
	RMobileCall::TMobileCallParamsV1Pckg checkParamsPkg(checkParams);
	call1.GetCallParams(checkParamsPkg);
	
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iSpeakerControl as that used for Dial.
	ASSERT_EQUALS(checkParams.iSpeakerControl,  mobileCallParams.iSpeakerControl,  
			_L("RCall::GetCallParams did not return the same iSpeakerControl as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iSpeakerVolume as that used for Dial.
	ASSERT_EQUALS(checkParams.iSpeakerVolume, mobileCallParams.iSpeakerVolume,  
			_L("RCall::GetCallParams did not return the same iSpeakerVolume as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iInterval as that used for Dial.
	ASSERT_EQUALS(checkParams.iInterval, mobileCallParams.iInterval,  
			_L("RCall::GetCallParams did not return the same iInterval as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iWaitForDialTone as that used for Dial.
	ASSERT_EQUALS(checkParams.iWaitForDialTone, mobileCallParams.iWaitForDialTone,  
			_L("RCall::GetCallParams did not return the same iWaitForDialTone as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iIdRestrict as that used for Dial.
	ASSERT_EQUALS(checkParams.iIdRestrict, mobileCallParams.iIdRestrict,  
			_L("RCall::GetCallParams did not return the same iIdRestrict as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iExplicitInvoke as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iExplicitInvoke, mobileCallParams.iCug.iExplicitInvoke,  
			_L("RCall::GetCallParams did not return the same iCug.iExplicitInvoke as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iCugIndex as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iCugIndex, mobileCallParams.iCug.iCugIndex,  
			_L("RCall::GetCallParams did not return the same iCug.iCugIndex as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iSuppressPrefCug as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iSuppressPrefCug, mobileCallParams.iCug.iSuppressPrefCug,  
			_L("RCall::GetCallParams did not return the same iCug.iSuppressPrefCug as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iSuppressOA as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iSuppressOA, mobileCallParams.iCug.iSuppressOA,  
			_L("RCall::GetCallParams did not return the same iCug.iSuppressOA as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iAutoRedial as that used for Dial.
	ASSERT_EQUALS(checkParams.iAutoRedial, mobileCallParams.iAutoRedial,  
			_L("RCall::GetCallParams did not return the same iAutoRedial as that used for Dial"));

	//------------ Post Notifiers ----------------------------
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);	

	// Hang up call. 
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone,  
			_L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone,  
			_L("RCall::HangUp returned an error"));

	// ===  Check call status ===
	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedCallStatus = RCall::EStatusHangingUp;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
													 notifyStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);
	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedLineStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
														 
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedLineStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
														 
	// Check RLine::GetStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle,  
			_L("RLine::GetStatus did not return EStatusIdle as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDisconnecting -> EStatusIdle
	expectedMobileLineStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusIdle,  
			_L("RMobileLine::GetMobileLineStatus did not set the status to EStatusIdle"));


	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
	// notifyCallStatusChangeStatus
	// notifyMobileCallChangeStatus
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus 
    // dialStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(6,&notifyCallStatusChangeStatus);	
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0012::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0012");
	}



CCTSYIntegrationTestCallControl0013::CCTSYIntegrationTestCallControl0013(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0013::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0013::~CCTSYIntegrationTestCallControl0013()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0013::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0013
 * @SYMFssID BA/CTSY/CCON-0013
 * @SYMTestCaseDesc Dial and hang up a call specifying valid call parameters 05.
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyStatusChange, RLine::NotifyStatusChange, RMobileLine::GetMobileLineStatus, RMobileLine::NotifyMobileLineStatusChange, RLine::GetStatus, RMobileCall::GetMobileCallStatus, RCall::GetCallParams, RCall::GetStatus, RCall::GetCallParams, RCall::GetStatus, RCall::HangUp
 * @SYMTestExpectedResults Pass - Call connects and call parameters are correct.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call and line statuses and call params are correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	
	// Check phone supports KCapsVoice
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Populate RMobileCall::TMobileCallParamsV1 with  
	RMobileCall::TMobileCallParamsV1 mobileCallParams;
	RMobileCall::TMobileCallParamsV1Pckg mobileCallParamsPkg(mobileCallParams);

	// ?iSpeakerControl = EMonitorSpeakerControlUnknown 
	mobileCallParams.iSpeakerControl = RCall::EMonitorSpeakerControlUnknown;
	// ?iSpeakerVolume = EMonitorSpeakerVolumeHigh 
	mobileCallParams.iSpeakerVolume = RCall::EMonitorSpeakerVolumeHigh;
	// ?iInterval = 0x01 
	mobileCallParams.iInterval = 0x01;
	// ?iWaitForDialTone = EDialToneWait 
	mobileCallParams.iWaitForDialTone = RCall::EDialToneWait;
	// ?iIdRestrict = EIdRestrictDefault 
	mobileCallParams.iIdRestrict = RMobileCall::EIdRestrictDefault;	
	// ?iExplicitInvoke = FALSE 
	mobileCallParams.iCug.iExplicitInvoke = FALSE ;
	// ?iCugIndex = 0x00 
	mobileCallParams.iCug.iCugIndex = 0x00;
	// ?iSuppressOA = FALSE 
	mobileCallParams.iCug.iSuppressOA = FALSE;
	// ?iSuppressPrefCug = FALSE 
	mobileCallParams.iCug.iSuppressPrefCug = FALSE;
	// ?iAutoRedial = FALSE 
	mobileCallParams.iAutoRedial = FALSE;

	//=========Post Notifiers===============
		
	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	RCall::TStatus callStatus;
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);

	// post a notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// post a notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine,&RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus lineStatus;
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);

	// post a notifier for RMobileLine::NotifyMobileLineStatusChange
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	RMobileCall::TMobileCallStatus mobileLineStatus;
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
		
	// Dial a number which answers using call params. 
	TCoreEtelRequestStatus<RMobileCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);		
	TPtrC number;
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,  
			_L("GetStringFromConfig did not complete as expected"));
	call1.Dial(dialStatus,mobileCallParamsPkg, number);
	// Wait for completion. 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone,  
			_L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
			_L("RCall::Dial returned an error"));
	
	// ===  Check line status ===

	TInt expectedStatus = KErrNone;
	
	// Check RLine::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedLineStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);

	expectedLineStatus = RCall::EStatusConnecting;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	
	expectedLineStatus = RCall::EStatusConnected;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	
	// Check RLine::GetStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusConnected,  
			_L("RLine::GetStatus did not set line status to EStatusConnected as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);	

	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusConnected,  
			_L("RMobileLine::GetMobileLineStatus did not set status to EStatusConnected"));
	
	// ===  Check call status ===
	
	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;

	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
	
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);

	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);		
								 												 
	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(voiceLine.GetStatus(callStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected,  
			_L("RLine::GetStatus did not return EStatusConnected as expected"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
	
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);

	expectedMobileCallStatus = RMobileCall::EStatusConnected;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
																	
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
			_L("RMobileCall::GetMobileCallStatus did not set call status EStatusConnected as expected"));

	// ===  Get call parameters. ===
	RMobileCall::TMobileCallParamsV1 checkParams;
	RMobileCall::TMobileCallParamsV1Pckg checkParamsPkg(checkParams);
	call1.GetCallParams(checkParamsPkg);
	
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iSpeakerControl as that used for Dial.
	ASSERT_EQUALS(checkParams.iSpeakerControl,  mobileCallParams.iSpeakerControl,  
			_L("RCall::GetCallParams did not return the same iSpeakerControl as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iSpeakerVolume as that used for Dial.
	ASSERT_EQUALS(checkParams.iSpeakerVolume, mobileCallParams.iSpeakerVolume,  
			_L("RCall::GetCallParams did not return the same iSpeakerVolume as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iInterval as that used for Dial.
	ASSERT_EQUALS(checkParams.iInterval, mobileCallParams.iInterval,  
			_L("RCall::GetCallParams did not return the same iInterval as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iWaitForDialTone as that used for Dial.
	ASSERT_EQUALS(checkParams.iWaitForDialTone, mobileCallParams.iWaitForDialTone,  
			_L("RCall::GetCallParams did not return the same iWaitForDialTone as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iIdRestrict as that used for Dial.
	ASSERT_EQUALS(checkParams.iIdRestrict, mobileCallParams.iIdRestrict,  
			_L("RCall::GetCallParams did not return the same iIdRestrict as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iExplicitInvoke as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iExplicitInvoke, mobileCallParams.iCug.iExplicitInvoke,  
			_L("RCall::GetCallParams did not return the same iCug.iExplicitInvoke as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iCugIndex as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iCugIndex, mobileCallParams.iCug.iCugIndex,  
			_L("RCall::GetCallParams did not return the same iCug.iCugIndex as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iSuppressPrefCug as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iSuppressPrefCug, mobileCallParams.iCug.iSuppressPrefCug,  
			_L("RCall::GetCallParams did not return the same iCug.iSuppressPrefCug as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iSuppressOA as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iSuppressOA, mobileCallParams.iCug.iSuppressOA,  
			_L("RCall::GetCallParams did not return the same iCug.iSuppressOA as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iAutoRedial as that used for Dial.
	ASSERT_EQUALS(checkParams.iAutoRedial, mobileCallParams.iAutoRedial,  
			_L("RCall::GetCallParams did not return the same iAutoRedial as that used for Dial"));

	//------------ Post Notifiers ----------------------------
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);	

	// Hang up call. 
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone,  
			_L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone,  
			_L("RCall::HangUp returned an error"));

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedCallStatus = RCall::EStatusHangingUp;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
													 notifyStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);
	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedLineStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
														 
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedLineStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
														 
	// Check RLine::GetStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle,  
			_L("RLine::GetStatus did not return EStatusIdle as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDisconnecting -> EStatusIdle
	expectedMobileLineStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusIdle,  
			_L("RMobileLine::GetMobileLineStatus did not set the status to EStatusIdle"));

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
    
	// Pop
	// notifyCallStatusChangeStatus
	// notifyMobileCallChangeStatus
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus 
	// dialStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(6,&notifyCallStatusChangeStatus);	
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0013::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0013");
	}



CCTSYIntegrationTestCallControl0014::CCTSYIntegrationTestCallControl0014(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0014::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0014::~CCTSYIntegrationTestCallControl0014()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0014::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0014
 * @SYMFssID BA/CTSY/CCON-0014
 * @SYMTestCaseDesc Dial and hang up a call specifying valid call parameters 06.
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyStatusChange, RLine::NotifyStatusChange, RMobileLine::GetMobileLineStatus, RMobileLine::NotifyMobileLineStatusChange, RLine::GetStatus, RMobileCall::GetMobileCallStatus, RCall::GetCallParams, RCall::GetStatus, RCall::GetCallParams, RCall::GetStatus, RCall::HangUp
 * @SYMTestExpectedResults Pass - Call connects and call parameters are correct.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call and line statuses and call params are correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Check phone supports KCapsVoice
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Populate RMobileCall::TMobileCallParamsV1 with  
	RMobileCall::TMobileCallParamsV1 mobileCallParams;
	RMobileCall::TMobileCallParamsV1Pckg mobileCallParamsPkg(mobileCallParams);

	// ?iSpeakerControl = EMonitorSpeakerControlUnknown 
	mobileCallParams.iSpeakerControl = RCall::EMonitorSpeakerControlUnknown;
	// ?iSpeakerVolume = EMonitorSpeakerVolumeHigh 
	mobileCallParams.iSpeakerVolume = RCall::EMonitorSpeakerVolumeHigh;
	// ?iInterval = 0x01 
	mobileCallParams.iInterval = 0x01;
	// ?iWaitForDialTone = EDialToneWait 
	mobileCallParams.iWaitForDialTone = RCall::EDialToneWait;
	// ?iIdRestrict = EIdRestrictDefault 
	mobileCallParams.iIdRestrict = RMobileCall::EIdRestrictDefault;	
	// ?iExplicitInvoke = FALSE 
	mobileCallParams.iCug.iExplicitInvoke = FALSE ;
	// ?iCugIndex = 0xffff 
	mobileCallParams.iCug.iCugIndex = 0xffff;
	// ?iSuppressOA = FALSE 
	mobileCallParams.iCug.iSuppressOA = FALSE;
	// ?iSuppressPrefCug = FALSE 
	mobileCallParams.iCug.iSuppressPrefCug = FALSE;
	// ?iAutoRedial = FALSE 
	mobileCallParams.iAutoRedial = FALSE;

	//=========Post Notifiers===============
		
	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	RCall::TStatus callStatus;
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);

	// post a notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// post a notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine,&RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus lineStatus;
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);

	// post a notifier for RMobileLine::NotifyMobileLineStatusChange
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	RMobileCall::TMobileCallStatus mobileLineStatus;
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
		
	// Dial a number which answers using call params. 
	TCoreEtelRequestStatus<RMobileCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);		
	TPtrC number;
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,  
			_L("GetStringFromConfig did not complete as expected"));
	call1.Dial(dialStatus,mobileCallParamsPkg, number);
	// Wait for completion. 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone,  
			_L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
			_L("RCall::Dial returned an error"));

	// ===  Check line status ===

	TInt expectedStatus = KErrNone;
	
	// Check RLine::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedLineStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);

	expectedLineStatus = RCall::EStatusConnecting;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	
	expectedLineStatus = RCall::EStatusConnected;	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	
	// Check RLine::GetStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusConnected,  
			_L("RLine::GetStatus did not set line status to EStatusConnected as expected"));

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);	

	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusConnected,  
			_L("RMobileLine::GetMobileLineStatus did not set status to EStatusConnected"));
	
	// ===  Check call status ===
	
	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;

	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
	
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);

	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);		
								 												 
	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(voiceLine.GetStatus(callStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected,  
			_L("RLine::GetStatus did not return EStatusConnected as expected"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
	
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);

	expectedMobileCallStatus = RMobileCall::EStatusConnected;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		expectedStatus);
																	
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
			_L("RMobileCall::GetMobileCallStatus did not set call status EStatusConnected as expected"));

	// ===  Get call parameters. ===
	RMobileCall::TMobileCallParamsV1 checkParams;
	RMobileCall::TMobileCallParamsV1Pckg checkParamsPkg(checkParams);
	call1.GetCallParams(checkParamsPkg);
	
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iSpeakerControl as that used for Dial.
	ASSERT_EQUALS(checkParams.iSpeakerControl,  mobileCallParams.iSpeakerControl,  
			_L("RCall::GetCallParams did not return the same iSpeakerControl as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iSpeakerVolume as that used for Dial.
	ASSERT_EQUALS(checkParams.iSpeakerVolume, mobileCallParams.iSpeakerVolume,  
			_L("RCall::GetCallParams did not return the same iSpeakerVolume as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iInterval as that used for Dial.
	ASSERT_EQUALS(checkParams.iInterval, mobileCallParams.iInterval,  
			_L("RCall::GetCallParams did not return the same iInterval as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iWaitForDialTone as that used for Dial.
	ASSERT_EQUALS(checkParams.iWaitForDialTone, mobileCallParams.iWaitForDialTone,  
			_L("RCall::GetCallParams did not return the same iWaitForDialTone as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iIdRestrict as that used for Dial.
	ASSERT_EQUALS(checkParams.iIdRestrict, mobileCallParams.iIdRestrict,  
			_L("RCall::GetCallParams did not return the same iIdRestrict as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iExplicitInvoke as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iExplicitInvoke, mobileCallParams.iCug.iExplicitInvoke,  
			_L("RCall::GetCallParams did not return the same iCug.iExplicitInvoke as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iCugIndex as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iCugIndex, mobileCallParams.iCug.iCugIndex,  
			_L("RCall::GetCallParams did not return the same iCug.iCugIndex as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iSuppressPrefCug as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iSuppressPrefCug, mobileCallParams.iCug.iSuppressPrefCug,  
			_L("RCall::GetCallParams did not return the same iCug.iSuppressPrefCug as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iCug.iSuppressOA as that used for Dial.
	ASSERT_EQUALS(checkParams.iCug.iSuppressOA, mobileCallParams.iCug.iSuppressOA,  
			_L("RCall::GetCallParams did not return the same iCug.iSuppressOA as that used for Dial"));
	// Check RCall::GetCallParams with aParams as a packaged RMobileCall::TMobileCallParamsV1 returns same iAutoRedial as that used for Dial.
	ASSERT_EQUALS(checkParams.iAutoRedial, mobileCallParams.iAutoRedial,  
			_L("RCall::GetCallParams did not return the same iAutoRedial as that used for Dial"));

	//------------ Post Notifiers ----------------------------
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);	

	// Hang up call. 
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone,  
			_L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone,  
			_L("RCall::HangUp returned an error"));

	// ===  Check call status ===
	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedCallStatus = RCall::EStatusHangingUp;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
													 notifyStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);
	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedLineStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
														 
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedLineStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
														 
	// Check RLine::GetStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle,  
			_L("RLine::GetStatus did not return EStatusIdle as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDisconnecting -> EStatusIdle
	expectedMobileLineStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusIdle,  
			_L("RMobileLine::GetMobileLineStatus did not set the status to EStatusIdle"));


	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
	// notifyCallStatusChangeStatus
	// notifyMobileCallChangeStatus
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus 
	// dialStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(6,&notifyCallStatusChangeStatus);	
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0014::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0014");
	}



CCTSYIntegrationTestCallControl0015::CCTSYIntegrationTestCallControl0015(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0015::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0015::~CCTSYIntegrationTestCallControl0015()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0015::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0015
 * @SYMFssID BA/CTSY/CCON-0015
 * @SYMTestCaseDesc Hang up of call by remote user.
 * @SYMTestPriority High
 * @SYMTestActions RLine::NotifyStatusChange, RMobileLine::NotifyMobileLineStatusChange, RLine::GetCallInfo, RLine::GetStatus, RMobileLine::GetMobileLineStatus, RLine::GetInfo, RMobileCall::GetMobileCallStatus, RMobileCall::NotifyMobileCallCapsChange, RMobileCall::NotifyMobileCallStatusChange
 * @SYMTestExpectedResults Pass - Call hung up. Call info correct.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/manual
 *
 * Reason for test: Verify line status, hook status and line info is correctly reflected by RLine and RMobileLine
 *
 * This test tests that the line information is correct when the phone dials and the remote
 * user hangs up.
 * 
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	// Check phone supports KCapsVoice
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////

	// post notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine,&RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus lineStatus;
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);

	// post a notifier for RMobileLine::NotifyMobileLineStatusChange
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	RMobileCall::TMobileCallStatus mobileLineStatus;
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);

	DisplayUserInteractionPromptL(_L("To run this test correctly, you should have set your own phone number to voice number 1 in the ini file. After you press a key, the test will call your phone, answer the call."), ETimeLong);

	TPtrC number; 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,			  
			_L("CTestStep::GetStringFromConfig did not complete as expected"));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, 
			_L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
			_L("RCall::Dial returned with an error"));
	
	TEST_CHECK_POINT_L(_L("Couldn't dial a call, no point continuing."));
	
	// ===  Check line status ===
	// Check RLine::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	const TInt expectedStatus = KErrNone;
	RCall::TStatus expectedLineStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);

	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedLineStatus = RCall::EStatusConnecting;	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
														 															 
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedLineStatus = RCall::EStatusConnected;	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
														 
	// Check RLine::GetStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusConnected,  
			_L("RLine::GetStatus did not return EStatusConnected as expected"));
	
	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);
																		
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);
																		
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);
																																					
	
	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusConnected,  
			_L("RMobileLine::GetMobileLineStatus did not set line status to EStatusConnected"));

	// ===  Check line info ===

	// Check RLine::GetCallInfo returns valid name.
	// Check RLine::GetCallInfo returns caps in set of KCapsHangUp.
	// Check RLine::GetCallInfo returns status of EStatusConnected.
	RLine::TCallInfo callInfo;
	ASSERT_EQUALS(voiceLine.GetCallInfo(0, callInfo), KErrNone,  
			_L("RLine::GetCallInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() >0,  
			_L("RLine::GetCallInfo returned an invalid  name"));
	ASSERT_BITS_SET(callInfo.iCallCapsFlags, RCall::KCapsHangUp, KNoUnwantedBits,  
			_L("RLine::GetCallInfo returned wrong caps"));	
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected,  
			_L("RLine::GetCallInfo wrong iStatus, should be EStatusIdle"));
	
	// Check RLine::GetInfo returns status of EStatusConnected.
	RLine::TLineInfo lineInfo;
	ASSERT_EQUALS(voiceLine.GetInfo(lineInfo), KErrNone,  
			_L("RLine::GetInfo returned an error")); 
	ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusConnected, 
			_L("RLine::GetInfo did not return EStatusConnected"));

	//===== Post notifiers==
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);

	// Instruct user to hang up the call
	DisplayUserInteractionPromptL(_L("Hang up the call now"), ETimeMedium);
	
	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedLineStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);

	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedLineStatus = RCall::EStatusIdle;	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	// Check RLine::GetStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle,  
			_L("RLine::GetStatus did not return EStatusConnected as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDisconnecting -> EStatusIdle
	expectedMobileLineStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);
																		
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);
	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusIdle,  
			_L("RMobileLine::GetMobileLineStatus did not set line status to EStatusConnected"));

	// ===  Check line info ===

	// Check RLine::GetCallInfo returns valid name.
	// Check RLine::GetCallInfo returns caps in set of KCapsVoice | KCapsDial.
	// Check RLine::GetCallInfo returns status of EStatusIdle.
	ASSERT_EQUALS(voiceLine.GetCallInfo(0, callInfo), KErrNone,  
			_L("RLine::GetCallInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() >0,  
			_L("RLine::GetCallInfo returned an invalid  name"));
	ASSERT_BITS_SET(callInfo.iCallCapsFlags, RCall::KCapsVoice | RCall::KCapsDial, KNoUnwantedBits,  
			_L("RLine::GetCallInfo returned wrong caps"));	
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusIdle,  
			_L("RLine::GetCallInfo wrong iStatus, should be EStatusIdle"));

	// Check RLine::GetInfo returns status of EStatusIdle.
	ASSERT_EQUALS(voiceLine.GetInfo(lineInfo), KErrNone,  
			_L("RLine::GetInfo returned an error")); 
	ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusIdle, 
			_L("RLine::GetInfo did not return EStatusConnected"));

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
    
    // hang up the active call
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);
	CleanupStack::PushL(hangUpStatus);		
	call1.HangUp(hangUpStatus);
	WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium);	

	// Pop 
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus
	// dialStatus
	// hangUpStatus	
	CleanupStack::PopAndDestroy(4,&notifyStatusChangeStatus);
		
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0015::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0015");
	}



CCTSYIntegrationTestCallControl0016::CCTSYIntegrationTestCallControl0016(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0016::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0016::~CCTSYIntegrationTestCallControl0016()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0016::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0016
 * @SYMFssID BA/CTSY/CCON-0016
 * @SYMTestCaseDesc Hang up of call by remote user.
 * @SYMTestPriority High
 * @SYMTestActions RCall::GetCaps, RMobileCall::NotifyHookChange, RMobileCall::NotifyMobileCallCapsChange, RMobileCall::GetMobileCallStatus, RMobileCall::GetMobileCallInfo, RCall::GetInfo, RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyCapsChange, RCall::GetStatus, RMobileCall::GetMobileCallCaps
 * @SYMTestExpectedResults Pass - Call hung up. Line info correct.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call status, caps and call info is correctly reflected by RCall and RMobileCall
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	
	// Check phone supports KCapsVoice
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
				   
	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Post Notifier for RCall::NotifyCapsChange
	TCoreEtelRequestStatus<RCall> notifyCapsChangeStatus (call1,&RCall::NotifyCapsChangeCancel);	
	CleanupStack::PushL(notifyCapsChangeStatus);
	RCall::TCaps caps;
	call1.NotifyCapsChange(notifyCapsChangeStatus,caps);	

	// post a notifier for RMobileCall::NotifyMobileCallCapsChange
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus(call1, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus);
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg mobileCallCapsPckg(mobileCallCaps);
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);
	
	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	RCall::TStatus callStatus;
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);

	// post a notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	// Dial RPS which answers 
	TPtrC number;
	GetRPSNumber(EVoiceLine,number);
	RPSAnswerNextCallL(EVoiceLine);
	
	TCoreEtelRequestStatus<RMobileCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);											 
	call1.Dial(dialStatus, number);	
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone,  
			_L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
			_L("RCall::Dial Expected KErrNone, but an error returned"));

	// ===  Check call caps ===
	
	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsHangUp.
	RCall::TCaps wantedCaps, unwantedCaps;
	wantedCaps.iFlags = RCall::KCapsVoice | RCall::KCapsHangUp;
	unwantedCaps.iFlags = 0;
	const TInt wantedStatus = KErrNone;
	
	iCallControlTestHelper.WaitForCallNotifyCapsChange(call1,
													   notifyCapsChangeStatus,
													   caps,
													   wantedCaps,
													   unwantedCaps,
													   wantedStatus);

	// Check RCall::GetCaps supports KCapsHangUp | KCapsVoice.
	ASSERT_EQUALS(call1.GetCaps(caps), KErrNone,   
			_L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(caps.iFlags, RCall::KCapsHangUp | RCall::KCapsVoice, KNoUnwantedBits,  
			_L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	RMobileCall::TMobileCallCapsV1 wantedMobileCaps;
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsHold | RMobileCall::KCapsHangUp;
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | RMobileCall::KCapsLocalTransfer | RMobileCall::KCapsRemoteHold | RMobileCall::KCapsRemoteTerminate | RMobileCall::KCapsRemoteConferenceCreate;

	TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps, mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1,
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsHold | RMobileCall::KCapsHangUp;
	
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, KNoUnwantedBits,
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));	
	
	wantedMobileCaps.iCallEventCaps = 	RMobileCall::KCapsLocalHold | 
										RMobileCall::KCapsLocalTransfer |
										RMobileCall::KCapsRemoteHold | 
										RMobileCall::KCapsRemoteTerminate | 
										RMobileCall::KCapsRemoteConferenceCreate;

	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits,
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
													 notifyCallStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);

	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
													 notifyCallStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);	

	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnected;															
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusConnected"));

	// ===  Check call info ===

	User::After(2000000);	// Wait added for call duration

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
    // Check RCall::GetInfo returns call status of EStatusConnected.
	// Check RCall::GetInfo returns call duration of > 0.
	RCall::TCallInfo callInfo;
	ASSERT_EQUALS(call1.GetInfo(callInfo), KErrNone,  
			_L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() >0,  
			_L("RCall::GetInfo returned an invalid  name"));
	ASSERT_TRUE(callInfo.iLineName.Length() >0,  
			_L("RCall::GetInfo returned an invalid  Line name"));
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected,  
			_L("RCall::GetInfo wrong iStatus, should be EStatusConnected"));
	ASSERT_TRUE(callInfo.iDuration.Int() > 0,  
			_L("RCall::GetInfo wrong iDuration, should be >0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid.
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	RMobileCall::TMobileCallInfoV1 mobileCallInfo;
	RMobileCall::TMobileCallInfoV1Pckg mobileCallInfoPckg(mobileCallInfo);
	ASSERT_EQUALS(call1.GetMobileCallInfo(mobileCallInfoPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() >0,  
			_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0,  
			_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));

	iCallControlTestHelper.CheckForValidCallInfo(mobileCallInfo, number);

	//==== Post Notifiers ========
	call1.NotifyCapsChange(notifyCapsChangeStatus,caps);
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// RPS hangs up. 
	ASSERT_EQUALS(RPSHangupL(EVoiceLine,0), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSHangup returned an error"));
	
	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsDial.
	wantedCaps.iFlags = RCall::KCapsVoice | RCall::KCapsDial;
	unwantedCaps.iFlags  = KNoUnwantedBits;
	ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10023);
	iCallControlTestHelper.WaitForCallNotifyCapsChange(call1,
													   notifyCapsChangeStatus,
													   caps,
													   wantedCaps,
													   unwantedCaps,
													   wantedStatus);
													   
	// Check RCall::GetCaps supports KCapsVoice | KCapsDial.
	ASSERT_EQUALS(call1.GetCaps(caps), KErrNone,   
			_L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(caps.iFlags, RCall::KCapsVoice | RCall::KCapsDial, KNoUnwantedBits,  
			_L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of 0.
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
	wantedMobileCaps.iCallEventCaps = 0;		
	TCmpRMobileCallTMobileCallCaps mobileCapsComp2(wantedMobileCaps, mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1,
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp2,
																	   wantedStatus);

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 0.
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallCaps returned an error"));	
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;											   
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, KNoUnwantedBits,  
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));
	wantedMobileCaps.iCallEventCaps = 0;											 
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits, 
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));										   

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle.
	expectedCallStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
													 notifyCallStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);

	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle.
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
    // Check RCall::GetInfo returns call status of EStatusIdle.
	// Check RCall::GetInfo returns call duration of > 0.
	ASSERT_EQUALS(call1.GetInfo(callInfo), KErrNone,  
			_L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() >0,  
			_L("RCall::GetInfo returned an invalid  name"));
	ASSERT_TRUE(callInfo.iLineName.Length() >0,  
			_L("RCall::GetInfo returned an invalid  Line name"));
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusIdle,  
			_L("RCall::GetInfo wrong iStatus, should be EStatusIdle"));
	ASSERT_TRUE(callInfo.iDuration.Int() > 0,  
			_L("RCall::GetInfo wrong iDuration, should be >0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid.
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	ASSERT_EQUALS(call1.GetMobileCallInfo(mobileCallInfoPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() >0,  
			_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0,  
			_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));

//	iCallControlTestHelper.CheckForValidCallInfo(mobileCallInfo, number);
	// Note: not using TCallControlTsyTestHelper::CheckForValidCallInfo() as some checks would fail at this point
	ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10017);
	if(mobileCallInfo.iValid & RMobileCall::KCallRemoteParty)
		{
		ASSERT_TRUE(mobileCallInfo.iRemoteParty.iRemoteNumber.iTelNumber.Length() > 0,
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallRemoteParty to true, but iRemoteParty.iRemoteNumber.iTelNumber has invalid length"));
		}
	if(mobileCallInfo.iValid & RMobileCall::KCallDuration)
		{
		TTimeIntervalSeconds startTime = 0;
		TTimeIntervalSeconds durationTime(mobileCallInfo.iDuration);
		ASSERT_TRUE(durationTime > startTime,
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallDuration to true, but set iDuration to an invalid number"));
		}
		
	if(mobileCallInfo.iValid & RMobileCall::KCallId)
		{
		ASSERT_EQUALS( mobileCallInfo.iCallId, -1,
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallId to true, but set iCallId to an invalid number"));
		}
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();	
	
	// Pop 
	// notifyCapsChangeStatus 	
	// notifyMobileCallCapsChangeStatus
	// notifyCallStatusChangeStatus
	// notifyMobileCallChangeStatus
	// dialStatus
	CleanupStack::PopAndDestroy(5,&notifyCapsChangeStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0016::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0016");
	}



CCTSYIntegrationTestCallControl0017::CCTSYIntegrationTestCallControl0017(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0017::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0017::~CCTSYIntegrationTestCallControl0017()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0017::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0017
 * @SYMFssID BA/CTSY/CCON-0017
 * @SYMTestCaseDesc Rejection of an incoming call
 * @SYMTestPriority High
 * @SYMTestActions RMobileLine::NotifyMobileLineStatusChange, RCall::HangUp, RMobileCall::GetMobileCallStatus, RLine::NotifyIncomingCall, RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange, RMobileLine::GetMobileLineStatus, RLine::GetStatus, RLine::NotifyHookChange, RLine::GetHookStatus, RCall::GetStatus
 * @SYMTestExpectedResults Pass - Call, line and hook statuses return to idle.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call and line statuses return to
 * idle.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////
	
	// Check phone supports KCapsVoice
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
				   
	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// post notifier for RLine::NotifyIncomingCall
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus (voiceLine,&RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus);
	TName name;
	voiceLine.NotifyIncomingCall(notifyIncomingCallStatus,name);
		
	// Request incoming call from RPS. 
	RPSRequestIncomingCallL(EVoiceLine);

	// Check RLine::NotifyIncomingCall completes with call name.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus,ETimeMedium),KErrNone, 
			_L("RLine::NotifyIncomingCall did not complete without error"));
	ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone,  
			_L("RLine::NotifyIncomingCall set requestStatus to an error"));
	ASSERT_TRUE(name.Length() > 0,  
			_L("RLine::NotifyIncomingCall did not set a line name"));

	// Get the incoming call
	TCallId incomingCallId;
	call1 = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, name, incomingCallId);

	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	RCall::TStatus callStatus;
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);

	// post a notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// post notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine,&RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus lineStatus;
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	
	// post a notifier for RMobileLine::NotifyMobileLineStatusChange
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	RMobileCall::TMobileCallStatus mobileLineStatus;
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);

	// Reject call with RCall::HangUp 
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);
	CleanupStack::PushL(hangUpStatus);	
	call1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone,  
			_L("RCall::HangUp returned an error"));	
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone,  
			_L("RCall::HangUp returned an error"));

	const TInt expectedStatus = KErrNone;

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusIdle.
	RCall::TStatus expectedCallStatus = RCall::EStatusIdle;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusIdle.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusIdle
	RCall::TStatus expectedLineStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 expectedStatus);
	// Check RLine::GetStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone,  
			_L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle,  
			_L("RLine::GetStatus did not return EStatusIdle as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with EStatusIdle
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		expectedStatus);

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone,  
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusIdle,  
			_L("RMobileLine::GetMobileLineStatus did not set line status to EStatusIdle"));
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// PopAndDestroy
		// hangUpStatus
		// notifyMobileLineChangeStatus
		// notifyStatusChangeStatus
		// notifyMobileCallChangeStatus
		// notifyCallStatusChangeStatus
		// notifyIncomingCallStatus
	
	CleanupStack::PopAndDestroy(6,&notifyIncomingCallStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0017::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0017");
	}



CCTSYIntegrationTestCallControl0018::CCTSYIntegrationTestCallControl0018(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0018::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0018::~CCTSYIntegrationTestCallControl0018()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0018::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0018
 * @SYMFssID BA/CTSY/CCON-0018
 * @SYMTestCaseDesc Answer incoming call and hang up call.
 * @SYMTestPriority High
 * @SYMTestActions RCall::OpenExistingCall, RCall::AnswerIncomingCall, RCall::HangUp, RCall::NotifyStatusChange, RCall::GetStatus, RMobileCall::NotifyMobileCallStatusChange, RMobileCall::GetMobileCallStatus
 * @SYMTestExpectedResults Pass - Call answered and then hung up.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call can be answered with specified params and call status, info and caps are correct.
 *
 * @return - TVerdict code
 */
	{
	
	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////
	
	// Check phone supports KCapsVoice
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////

	// post notifier for RLine::NotifyIncomingCall
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus (voiceLine,&RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus);
	TName name;
	voiceLine.NotifyIncomingCall(notifyIncomingCallStatus,name);	

	// Request an incoming call from RPS. 
	RPSRequestIncomingCallL(EVoiceLine);

	// Check RLine::NotifyIncomingCall completes with valid call name.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus,ETimeMedium), KErrNone, 
			_L("RLine::NotifyIncomingCall did not complete without error"));
	ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone,  
			_L("RLine::NotifyIncomingCall set requestStatus to an error"));
	ASSERT_TRUE(name.Length() > 0,  
			_L("RLine::NotifyIncomingCall did not set the name"));

	TCallId incomingCallId;
	RMobileCall& incomingCall = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, name, incomingCallId);

	// ===  Check call caps ===

	// Check RCall::GetCaps supports caps in set of KCapsVoice | KCapsAnswer
	// Check RCall::GetCaps supports NOT in set of KCapsDial
	RCall::TCaps caps;
	ASSERT_EQUALS(incomingCall.GetCaps(caps), KErrNone,   
			_L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(caps.iFlags, RCall::KCapsVoice | RCall::KCapsAnswer, RCall::KCapsDial,  
			_L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDeflect | KCapsAnswer
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps NOT in set of KCapsDial
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg capsPckg(mobileCallCaps);
	RMobileCall::TMobileCallCapsV1 wantedMobileCaps, unWantedMobileCaps;
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDeflect | RMobileCall::KCapsAnswer;
	unWantedMobileCaps.iCallControlCaps = RMobileCall::KCapsDial;
	ASSERT_EQUALS(incomingCall.GetMobileCallCaps(capsPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallCaps returned an error"));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, unWantedMobileCaps.iCallControlCaps,
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));	

	// ===  Check call status ===

	// Check RCall::GetStatus returns EStatusRinging
	RCall::TStatus callStatus;
	ASSERT_EQUALS(incomingCall.GetStatus(callStatus), KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusRinging,  
			_L("RCall::GetStatus did not return EStatusRinging as expected"));

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusRinging
	RMobileCall::TMobileCallStatus mobileCallStatus;
	ASSERT_EQUALS(incomingCall.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusRinging,  
			_L("RMobileCall::GetMobileCallStatus did not set call status EStatusRinging as expected"));

	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusRinging.
	// Check RCall::GetInfo returns call duration of 0.
	RCall::TCallInfo callInfo;
	ASSERT_EQUALS(incomingCall.GetInfo(callInfo), KErrNone,  
			_L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() >0,  
			_L("RCall::GetInfo returned an invalid  name"));
	ASSERT_TRUE(callInfo.iLineName.Length() >0,  
			_L("RCall::GetInfo returned an invalid  Line name"));
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusRinging,  
			_L("RCall::GetInfo wrong iStatus, should be EStatusRinging"));
	ASSERT_EQUALS(callInfo.iDuration.Int(), 0,  
			_L("RCall::GetInfo wrong iDuration, should be 0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid.
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	RMobileCall::TMobileCallInfoV1 mobileCallInfo;
	RMobileCall::TMobileCallInfoV1Pckg mobileCallInfoPckg(mobileCallInfo);
	User::After(KOneSecond*2);  // Give timers enough time to increment
	ASSERT_EQUALS(incomingCall.GetMobileCallInfo(mobileCallInfoPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() > 0,  
			_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0,  
			_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));

	// Check RMobileCall::GetMobileCallInfo returns valid remote number.
	// Check RMobileCall::GetMobileCallInfo returns call duration=0
	// Check RMobileCall::GetMobileCallInfo returns valid callId
	// Note: not using TCallControlTsyTestHelper::CheckForValidCallInfo() as some checks would fail at this point
	if(mobileCallInfo.iValid & RMobileCall::KCallRemoteParty)
		{
		ASSERT_TRUE(mobileCallInfo.iRemoteParty.iRemoteNumber.iTelNumber.Length() > 0,
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallRemoteParty to true, but iRemoteParty.iRemoteNumber.iTelNumber has invalid length"))
		}
	if(mobileCallInfo.iValid & RMobileCall::KCallDuration)
		{
		TTimeIntervalSeconds startTime = 0;
		TTimeIntervalSeconds durationTime(mobileCallInfo.iDuration);
		ASSERT_EQUALS(durationTime.Int(), startTime.Int(),
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallDuration to true, but set iDuration to an invalid number"))
		}
	if(mobileCallInfo.iValid & RMobileCall::KCallId)
		{
		ASSERT_TRUE( mobileCallInfo.iCallId > -1,
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallId to true, but set iCallId to an invalid number"))
		DEBUG_PRINTF2(_L("call id=%d"), mobileCallInfo.iCallId);
		}

	// Populate a RMobileCall::TMobileCallParamsV1 with: 
	RMobileCall::TMobileCallParamsV1 mobileCallParams;
	// ?iSpeakerControl = EMonitorSpeakerControlAlwaysOff 
	mobileCallParams.iSpeakerControl = RCall::EMonitorSpeakerControlAlwaysOff;
	// ?iSpeakerVolume = EMonitorSpeakerVolumeOff 
	mobileCallParams.iSpeakerVolume = RCall::EMonitorSpeakerVolumeOff;
	// ?iInterval = 0x01 
	mobileCallParams.iInterval = 0x01;
	// ?iWaitForDialTone = EDialToneWait 
	mobileCallParams.iWaitForDialTone = RCall::EDialToneWait;
	// ?iIdRestrict = EIdRestrictDefault 
	mobileCallParams.iIdRestrict = RMobileCall::EIdRestrictDefault;
	// ?iExplicitInvoke = TRUE 
	mobileCallParams.iCug.iExplicitInvoke = TRUE ;
	// ?iCugIndex = 0x0000 
	mobileCallParams.iCug.iCugIndex = 0x0000;
	// ?iSuppressOA = FALSE 
	mobileCallParams.iCug.iSuppressOA = FALSE;
	// ?iSuppressPrefCug = FALSE 
	mobileCallParams.iCug.iSuppressPrefCug = FALSE;
	// ?iAutoRedial = FALSE 
	mobileCallParams.iAutoRedial = FALSE;
	
	RMobileCall::TMobileCallParamsV1Pckg mobileCallParamsPckg(mobileCallParams);

	// ==== Post Notifiers =====
	TCoreEtelRequestStatus<RCall> notifyCapsChangeStatus (incomingCall,&RCall::NotifyCapsChangeCancel);	
	CleanupStack::PushL(notifyCapsChangeStatus);
	incomingCall.NotifyCapsChange(notifyCapsChangeStatus,caps);
	
	// post notifier for RMobileCall::NotifyMobileCallCapsChange
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus(incomingCall, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus);	
	incomingCall.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, capsPckg);

	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (incomingCall, &RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	incomingCall.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);
	
	// post notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallChangeStatus(incomingCall, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	incomingCall.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
			
	// Answer incoming call by calling RCall::AnswerIncomingCall and using TMobileCallParamsV1 
	ASSERT_EQUALS(incomingCall.AnswerIncomingCall(mobileCallParamsPckg), KErrNone,
			_L("RCall::AnswerIncomingCall returned an error"));
	
	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsHangUp.
	RCall::TCaps wantedCaps, unwantedCaps;
	wantedCaps.iFlags  = RCall::KCapsVoice | RCall::KCapsHangUp;
	unwantedCaps.iFlags  = KNoUnwantedBits;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyCapsChange(incomingCall,
													   notifyCapsChangeStatus,
													   caps,
													   wantedCaps,
													   unwantedCaps,
													   wantedStatus);	
													   
	// Check RCall::GetCaps supports KCapsHangUp | KCapsVoice.
	ASSERT_EQUALS(incomingCall.GetCaps(caps), KErrNone,   
			_L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(caps.iFlags, RCall::KCapsHangUp | RCall::KCapsVoice, KNoUnwantedBits,  
			_L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsHold | RMobileCall::KCapsHangUp;
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | RMobileCall::KCapsLocalTransfer | RMobileCall::KCapsRemoteHold | RMobileCall::KCapsRemoteTerminate | RMobileCall::KCapsRemoteConferenceCreate;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps, mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(incomingCall,
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);


	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	ASSERT_EQUALS(incomingCall.GetMobileCallCaps(capsPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallCaps returned an error")); 
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsHold | RMobileCall::KCapsHangUp;											   
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, KNoUnwantedBits,
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));	
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | RMobileCall::KCapsLocalTransfer |RMobileCall::KCapsRemoteHold | RMobileCall::KCapsRemoteTerminate |  RMobileCall::KCapsRemoteConferenceCreate;											 
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits,
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));	

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusConnected
	RCall::TStatus expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(incomingCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	
	// Check RCall::GetStatus returns EStatusConnected
	ASSERT_EQUALS(incomingCall.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(incomingCall,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(incomingCall.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusConnected"));

	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusConnected.
	// Check RCall::GetInfo returns call duration of > 0.
	User::After(KOneSecond*2);  // Give timers enough time to increment
	ASSERT_EQUALS(incomingCall.GetInfo(callInfo), KErrNone,  
			_L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() > 0,  
			_L("RCall::GetInfo returned an invalid  name"));
	ASSERT_TRUE(callInfo.iLineName.Length() > 0,  
			_L("RCall::GetInfo returned an invalid  Line name"));	
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected,  
			_L("RCall::GetInfo wrong iStatus, should be EStatusConnected"));
	ASSERT_TRUE(callInfo.iDuration.Int() > 0,  
			_L("RCall::GetInfo wrong iDuration, should be > 0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid.
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	ASSERT_EQUALS(incomingCall.GetMobileCallInfo(mobileCallInfoPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() > 0,  
			_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0,  
			_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));

	iCallControlTestHelper.CheckForValidCallInfo(mobileCallInfo);

	//==== Post some notifiers ====
	incomingCall.NotifyCapsChange(notifyCapsChangeStatus,caps);
	incomingCall.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, capsPckg);
	incomingCall.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	incomingCall.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);	
	
	// Hang up the call 

	TCoreEtelRequestStatus<RCall> hangUpStatus (incomingCall,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	incomingCall.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone,  
			_L("RCall::HangUp returned an error"));		
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone,  
			_L("RCall::HangUp returned an error"));

	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsDial.
	wantedCaps.iFlags = RCall::KCapsVoice | RCall::KCapsDial;
	iCallControlTestHelper.WaitForCallNotifyCapsChange(incomingCall,
													   notifyCapsChangeStatus,
													   caps,
													   wantedCaps,
													   unwantedCaps,
													   wantedStatus);
													   
	// Check RCall::GetCaps supports KCapsVoice | KCapsDial.
	ASSERT_EQUALS(incomingCall.GetCaps(caps), KErrNone,   
			_L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(caps.iFlags, RCall::KCapsVoice | RCall::KCapsDial, KNoUnwantedBits,  
			_L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of 0.
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
	wantedMobileCaps.iCallEventCaps = 0;		
	TCmpRMobileCallTMobileCallCaps mobileCapsComp2(wantedMobileCaps, mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(incomingCall,
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp2,
																	   wantedStatus);

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 0.
	ASSERT_EQUALS(incomingCall.GetMobileCallCaps(capsPckg), KErrNone,
			_L("RMobileCall::GetMobileCallCaps returned an error"));	
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;											   
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps,KNoUnwantedBits,  
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));
	wantedMobileCaps.iCallEventCaps = 0;											 
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps,KNoUnwantedBits, 
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));										   

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle.
	expectedCallStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(incomingCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
										 
	incomingCall.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(incomingCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(incomingCall.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle.
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(incomingCall,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	incomingCall.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(incomingCall,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(incomingCall.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusIdle.
	// Check RCall::GetInfo returns call duration of > 0.
	ASSERT_EQUALS(incomingCall.GetInfo(callInfo), KErrNone,  
			_L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() > 0,  
			_L("RCall::GetInfo returned an invalid  name"));
	ASSERT_TRUE(callInfo.iLineName.Length() > 0,  
			_L("RCall::GetInfo returned an invalid  Line name"));
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusIdle,  
			_L("RCall::GetInfo wrong iStatus, should be EStatusIdle"));
	ASSERT_TRUE(callInfo.iDuration.Int() > 0,  
			_L("RCall::GetInfo wrong iDuration, should be >0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid.
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	ASSERT_EQUALS(incomingCall.GetMobileCallInfo(mobileCallInfoPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() >0,  
			_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0,  
			_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));
	
	// Note: not using TCallControlTsyTestHelper::CheckForValidCallInfo() as some checks would fail at this point
	if(mobileCallInfo.iValid & RMobileCall::KCallRemoteParty)
		{
		ASSERT_TRUE(mobileCallInfo.iRemoteParty.iRemoteNumber.iTelNumber.Length() > 0,
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallRemoteParty to true, but iRemoteParty.iRemoteNumber.iTelNumber has invalid length"));
		}
	if(mobileCallInfo.iValid & RMobileCall::KCallDuration)
		{
		TTimeIntervalSeconds startTime = 0;
		TTimeIntervalSeconds durationTime(mobileCallInfo.iDuration);
		ASSERT_TRUE(durationTime > startTime,
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallDuration to true, but set iDuration to an invalid number"));
		}
		
	if(mobileCallInfo.iValid & RMobileCall::KCallId)
		{
		ASSERT_EQUALS( mobileCallInfo.iCallId, -1,
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallId to true, but set iCallId to an invalid number"));
		DEBUG_PRINTF2(_L("RMobileCall::GetMobileCallInfo returns callId of: %d"), mobileCallInfo.iCallId);
		}
	if(mobileCallInfo.iValid & RMobileCall::KCallExitCode)
		{
		ASSERT_EQUALS( mobileCallInfo.iExitCode, KErrNone, _L("RMobileCall::GetMobileCallInfo set bitmask for KCallExitCode to true, but did not set iExitCode to KErrNone"))
		}
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	CleanupStack::PopAndDestroy(6,&notifyIncomingCallStatus);
						// notifyIncomingCallStatus
						// notifyCapsChangeStatus 	
						// notifyMobileCallCapsChangeStatus
						// notifyCallStatusChangeStatus
						// notifyMobileCallChangeStatus
						// hangUpStatus
						
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0018::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0018");
	}



CCTSYIntegrationTestCallControl0019::CCTSYIntegrationTestCallControl0019(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0019::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0019::~CCTSYIntegrationTestCallControl0019()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0019::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0019
 * @SYMFssID BA/CTSY/CCON-0019
 * @SYMTestCaseDesc Answer incoming call then have remote party hang up.
 * @SYMTestPriority High
 * @SYMTestActions RCall::OpenExistingCall, RCall::AnswerIncomingCall, RCall::HangUp, RCall::NotifyStatusChange, RCall::GetStatus, RMobileCall::NotifyMobileCallStatusChange, RMobileCall::GetMobileCallStatus
 * @SYMTestExpectedResults Pass - Call answered.  Mobile call status correct.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call can be answered with specified params and call status, info and caps are correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	
	// Check phone supports KCapsVoice

	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
				   
	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////

	// post notifier for RLine::NotifyIncomingCall
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus (voiceLine,&RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus);
	TName name;
	voiceLine.NotifyIncomingCall(notifyIncomingCallStatus,name);	

	// Request an incoming call from RPS. 
	RPSRequestIncomingCallL(EVoiceLine);
	
	// Check RLine::NotifyIncomingCall completes.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus,ETimeMedium),KErrNone, 
			_L("RLine::NotifyIncomingCall did not complete without error"));
	ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone,  
			_L("RLine::NotifyIncomingCall set requestStatus to an error"));
	ASSERT_TRUE(name.Length() > 0,  
			_L("RLine::NotifyIncomingCall did not set the name"));	

	TCallId incomingCallId;
	RMobileCall& incomingCall = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, name, incomingCallId);

	// ===  Check call caps ===
													   
	// Check RCall::GetCaps supports caps in set of KCapsVoice | KCapsAnswer
	// Check RCall::GetCaps supports NOT in set of KCapsDial
	RCall::TCaps caps;
	ASSERT_EQUALS(incomingCall.GetCaps(caps), KErrNone,   
			_L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(caps.iFlags, RCall::KCapsVoice | RCall::KCapsAnswer, RCall::KCapsDial,  
			_L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDeflect | KCapsAnswer
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps NOT in set of KCapsDial
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg capsPckg(mobileCallCaps);
	RMobileCall::TMobileCallCapsV1 wantedMobileCaps, unwantedMobileCaps;
	ASSERT_EQUALS(incomingCall.GetMobileCallCaps(capsPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDeflect | RMobileCall::KCapsAnswer;											   
	unwantedMobileCaps.iCallControlCaps = RMobileCall::KCapsDial;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps,unwantedMobileCaps.iCallControlCaps,  
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));

	// ===  Check call status ===

	// Check RCall::GetStatus returns EStatusRinging
	RCall::TStatus callStatus;
	ASSERT_EQUALS(incomingCall.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusRinging,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusRinging
	RMobileCall::TMobileCallStatus mobileCallStatus;
	ASSERT_EQUALS(incomingCall.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusRinging,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusConnected"));

	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusRinging.
	// Check RCall::GetInfo returns call duration of 0.
	RCall::TCallInfo callInfo;
	ASSERT_EQUALS(incomingCall.GetInfo(callInfo), KErrNone,  
			_L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() >0,  
			_L("RCall::GetInfo returned an invalid  name"));
	ASSERT_TRUE(callInfo.iLineName.Length() >0,  
			_L("RCall::GetInfo returned an invalid  Line name"));	
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusRinging,  
			_L("RCall::GetInfo wrong iStatus, should be EStatusRinging"));
	ASSERT_EQUALS(callInfo.iDuration.Int(), 0,  
			_L("RCall::GetInfo wrong iDuration, should be 0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid.
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	RMobileCall::TMobileCallInfoV1 mobileCallInfo;
	RMobileCall::TMobileCallInfoV1Pckg mobileCallInfoPckg(mobileCallInfo);
	User::After(KOneSecond*2);  // Give timers enough time to increment
	ASSERT_EQUALS(incomingCall.GetMobileCallInfo(mobileCallInfoPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() > 0,  
			_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0,  
			_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));
			
	// Check RMobileCall::GetMobileCallInfo returns valid remote number.
	// Check RMobileCall::GetMobileCallInfo returns call duration=0
	// Check RMobileCall::GetMobileCallInfo returns valid callId
	// Note: not using TCallControlTsyTestHelper::CheckForValidCallInfo() as some checks would fail at this point
	if(mobileCallInfo.iValid & RMobileCall::KCallRemoteParty)
		{
		ASSERT_TRUE(mobileCallInfo.iRemoteParty.iRemoteNumber.iTelNumber.Length() > 0,
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallRemoteParty to true, but iRemoteParty.iRemoteNumber.iTelNumber has invalid length"))
		}
	if(mobileCallInfo.iValid & RMobileCall::KCallDuration)
		{
		TTimeIntervalSeconds startTime = 0;
		TTimeIntervalSeconds durationTime(mobileCallInfo.iDuration);
		ASSERT_EQUALS(durationTime.Int(), startTime.Int(),
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallDuration to true, but set iDuration to an invalid number"))
		}
	if(mobileCallInfo.iValid & RMobileCall::KCallId)
		{
		ASSERT_TRUE( mobileCallInfo.iCallId > -1,
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallId to true, but set iCallId to an invalid number"))
		}

	// Populate a RMobileCall::TMobileCallParamsV1 with: 
	RMobileCall::TMobileCallParamsV1 mobileCallParams;
	// ?iSpeakerControl = EMonitorSpeakerControlAlwaysOff 
	mobileCallParams.iSpeakerControl = RCall::EMonitorSpeakerControlAlwaysOff;
	// ?iSpeakerVolume = EMonitorSpeakerVolumeOff 
	mobileCallParams.iSpeakerVolume = RCall::EMonitorSpeakerVolumeOff;
	// ?iInterval = 0x01 
	mobileCallParams.iInterval = 0x01;
	// ?iWaitForDialTone = EDialToneWait 
	mobileCallParams.iWaitForDialTone = RCall::EDialToneWait;
	// ?iIdRestrict = EIdRestrictDefault 
	mobileCallParams.iIdRestrict = RMobileCall::EIdRestrictDefault;
	// ?iExplicitInvoke = TRUE 
	mobileCallParams.iCug.iExplicitInvoke = TRUE ;
	// ?iCugIndex = 0x0000 
	mobileCallParams.iCug.iCugIndex = 0x0000;
	// ?iSuppressOA = FALSE 
	mobileCallParams.iCug.iSuppressOA = FALSE;
	// ?iSuppressPrefCug = FALSE 
	mobileCallParams.iCug.iSuppressPrefCug = FALSE;
	// ?iAutoRedial = FALSE 
	mobileCallParams.iAutoRedial = FALSE;

	RMobileCall::TMobileCallParamsV1Pckg mobileCallParamsPkg(mobileCallParams);

	// ==== Post Notifiers =====

	// post notifier for RCall::NotifyCapsChange
	TCoreEtelRequestStatus<RCall> notifyCapsChangeStatus (incomingCall,&RCall::NotifyCapsChangeCancel);	
	CleanupStack::PushL(notifyCapsChangeStatus);
	incomingCall.NotifyCapsChange(notifyCapsChangeStatus,caps);	

	// post notifier for RMobileCall::NotifyMobileCallCapsChange
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus(incomingCall, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus);
	incomingCall.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, capsPckg);

	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (incomingCall,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	incomingCall.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);

	// post notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallChangeStatus(incomingCall, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	incomingCall.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	// Answer incoming call with call params defined above 
	ASSERT_EQUALS(incomingCall.AnswerIncomingCall(mobileCallParamsPkg),KErrNone,
			_L("RCall::AnswerIncomingCall errored when answering with defined params"));
		
	// ===  Check call caps ===
	
	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsHangUp.
	RCall::TCaps wantedCaps, unwantedCaps;
	wantedCaps.iFlags = RCall::KCapsVoice | RCall::KCapsHangUp;
	unwantedCaps.iFlags = KNoUnwantedBits;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyCapsChange(incomingCall,
													   notifyCapsChangeStatus,
													   caps,
													   wantedCaps,
													   unwantedCaps,
													   wantedStatus);
													   
	// Check RCall::GetCaps supports KCapsHangUp | KCapsVoice.
	ASSERT_EQUALS(incomingCall.GetCaps(caps), KErrNone,   
			_L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(caps.iFlags, RCall::KCapsHangUp | RCall::KCapsVoice, KNoUnwantedBits,  
			_L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsHold | RMobileCall::KCapsHangUp;
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | RMobileCall::KCapsLocalTransfer | RMobileCall::KCapsRemoteHold | RMobileCall::KCapsRemoteTerminate | RMobileCall::KCapsRemoteConferenceCreate;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps, mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(incomingCall,
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	ASSERT_EQUALS(incomingCall.GetMobileCallCaps(capsPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsHold | RMobileCall::KCapsHangUp;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, KNoUnwantedBits,
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));	
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | RMobileCall::KCapsLocalTransfer |RMobileCall::KCapsRemoteHold | RMobileCall::KCapsRemoteTerminate |  RMobileCall::KCapsRemoteConferenceCreate;											 
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits,
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));										   

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusConnected
	RCall::TStatus expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(incomingCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
														 
	// Check RCall::GetStatus returns EStatusConnected
	ASSERT_EQUALS(incomingCall.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(incomingCall,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(incomingCall.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusConnected"));

	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusConnected.
	// Check RCall::GetInfo returns call duration of > 0.
	User::After(KOneSecond*2);  // Give timers enough time to increment
	ASSERT_EQUALS(incomingCall.GetInfo(callInfo), KErrNone,  
			_L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() > 0,  
			_L("RCall::GetInfo returned an invalid  name"));
	ASSERT_TRUE(callInfo.iLineName.Length() > 0,  
			_L("RCall::GetInfo returned an invalid  Line name"));	
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected,  
			_L("RCall::GetInfo wrong iStatus, should be EStatusConnected"));
	ASSERT_TRUE(callInfo.iDuration.Int() > 0,  
			_L("RCall::GetInfo wrong iDuration, should be > 0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid.
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	ASSERT_EQUALS(incomingCall.GetMobileCallInfo(mobileCallInfoPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() > 0,  
			_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0,  
			_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));

	iCallControlTestHelper.CheckForValidCallInfo(mobileCallInfo);
	
	//==== Post some notifiers ====
	incomingCall.NotifyCapsChange(notifyCapsChangeStatus,caps);
	incomingCall.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, capsPckg);
	incomingCall.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	incomingCall.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	// Post notifier for line status to indicate when hangup completes
	TExtEtelRequestStatus notifyMobileLineStatusChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineStatusChangeStatus);
	RMobileCall::TMobileCallStatus mobileLineStatus;
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineStatusChangeStatus, mobileLineStatus);	

	// RPS hangs up the call. 
	ASSERT_EQUALS(RPSHangupL(EVoiceLine,0), KErrNone,  
			_L("CCTSYIntegrationTestSuiteStepBase::RPSHangup returned an error"));
			
	// Wait for line status to be idle
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		 notifyMobileLineStatusChangeStatus,
																		 mobileLineStatus,
																		 RMobileCall::EStatusDisconnecting,
																		 KErrNone);	
	
	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsDial.
	wantedCaps.iFlags = RCall::KCapsVoice | RCall::KCapsDial;
	ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10023);
	iCallControlTestHelper.WaitForCallNotifyCapsChange(incomingCall,
													   notifyCapsChangeStatus,
													   caps,
													   wantedCaps,
													   unwantedCaps,
													   wantedStatus);

	// Check RCall::GetCaps supports KCapsVoice | KCapsDial.
	ASSERT_EQUALS(incomingCall.GetCaps(caps), KErrNone,   
			_L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(caps.iFlags, RCall::KCapsVoice | RCall::KCapsDial, KNoUnwantedBits,  
			_L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of 0.
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
	wantedMobileCaps.iCallEventCaps = 0;		
	TCmpRMobileCallTMobileCallCaps mobileCapsComp2(wantedMobileCaps, mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(incomingCall,
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp2,
																	   wantedStatus);

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 0.
	ASSERT_EQUALS(incomingCall.GetMobileCallCaps(capsPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallCaps returned an error"));	
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;											   
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps,KNoUnwantedBits,  
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));
	wantedMobileCaps.iCallEventCaps = 0;											 
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps,KNoUnwantedBits, 
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle.
	expectedCallStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(incomingCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
														 
	incomingCall.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(incomingCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
														 	
	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(incomingCall.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle.
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(incomingCall,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	incomingCall.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(incomingCall,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(incomingCall.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusIdle.
	// Check RCall::GetInfo returns call duration of > 0.
	ASSERT_EQUALS(incomingCall.GetInfo(callInfo), KErrNone,  
			_L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() > 0,  
			_L("RCall::GetInfo returned an invalid  name"));
	ASSERT_TRUE(callInfo.iLineName.Length() > 0,  
			_L("RCall::GetInfo returned an invalid  Line name"));	
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusIdle,  
			_L("RCall::GetInfo wrong iStatus, should be EStatusIdle"));
	ASSERT_TRUE(callInfo.iDuration.Int() > 0,  
			_L("RCall::GetInfo wrong iDuration, should be >0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid.
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	ASSERT_EQUALS(incomingCall.GetMobileCallInfo(mobileCallInfoPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() > 0,  
			_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0,  
			_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));

	// Note: not using TCallControlTsyTestHelper::CheckForValidCallInfo() as some checks would fail at this point
	if(mobileCallInfo.iValid & RMobileCall::KCallRemoteParty)
		{
		ASSERT_TRUE(mobileCallInfo.iRemoteParty.iRemoteNumber.iTelNumber.Length() > 0,
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallRemoteParty to true, but iRemoteParty.iRemoteNumber.iTelNumber has invalid length"));
		}
	if(mobileCallInfo.iValid & RMobileCall::KCallDuration)
		{
		TTimeIntervalSeconds startTime = 0;
		TTimeIntervalSeconds durationTime(mobileCallInfo.iDuration);
		ASSERT_TRUE(durationTime > startTime,
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallDuration to true, but set iDuration to an invalid number"));
		}
		
	ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10017);
	if(mobileCallInfo.iValid & RMobileCall::KCallId)
		{
		ASSERT_EQUALS( mobileCallInfo.iCallId, -1,
					_L("RMobileCall::GetMobileCallInfo set bitmask for KCallId to true, but set iCallId to an invalid number"));
		}
	if(mobileCallInfo.iValid & RMobileCall::KCallExitCode)
		{
		ASSERT_EQUALS( mobileCallInfo.iExitCode, KErrNone, _L("RMobileCall::GetMobileCallInfo set bitmask for KCallExitCode to true, but did not set iExitCode to KErrNone"))
		}

	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// PopAndDestroy 
	// notifyIncomingCallStatus
	// notifyCapsChangeStatus 	
	// notifyMobileCallCapsChangeStatus
	// notifyCallStatusChangeStatus
	// notifyMobileCallChangeStatus
	// notifyMobileLineStatusChangeStatus
	
	CleanupStack::PopAndDestroy(6,&notifyIncomingCallStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0019::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0019");
	}



CCTSYIntegrationTestCallControl0020::CCTSYIntegrationTestCallControl0020(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0020::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0020::~CCTSYIntegrationTestCallControl0020()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0020::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0020
 * @SYMFssID BA/CTSY/CCON-0020
 * @SYMTestCaseDesc Cancel dialling a call.
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::GetMobileCallStatus, RCall::Dial, RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange, RCall::GetStatus, RCall::DialCancel, RMobileCall::GetMobileCallCaps
 * @SYMTestExpectedResults Pass - KErrCancel returned on cancellation of dial.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify Dial can be cancelled at different periods of time into dialling and caps and status correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	
	// Check phone supports KCapsVoice

	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////

	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyStatusChangeStatus (call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus callStatus;
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);	

	// post notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);

	// post notifier for RMobileCall::NotifyMobileCallCapsChange
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus(call1, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus);
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg capsPckg(mobileCallCaps);
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus,capsPckg);
	
	// post notifier for RCall::NotifyCapsChange
	TCoreEtelRequestStatus<RCall> notifyCapsChangeStatus (call1,&RCall::NotifyCapsChangeCancel);	
	CleanupStack::PushL(notifyCapsChangeStatus);
	RCall::TCaps callCaps;
	call1.NotifyCapsChange(notifyCapsChangeStatus,callCaps);
			
	// ===  Dial then cancel after 3 seconds ===

	DisplayUserInteractionPromptL(
		_L("Ensure your own phone number has already been set in the ini file.\nAfter you press a key, the test will call this phone."), ETimeLong);

	// Dial RPS which won't answer.
	TPtrC RPSnumber;
	
	// Dialling own phone instead of the RPS
	/*
	ASSERT_EQUALS(RPSIgnoreNextCallL(EVoiceLine), KErrNone,  
			_L("cctsyintegraiontestsuitebase::RPSIgnoreNextCallL returned an error"));
	GetRPSNumber(EVoiceLine, RPSnumber);
	*/
	DEBUG_PRINTF1(_L("Voice mail must be switched off for this test to pass!"));
	
	ASSERT_TRUE(GetStringFromConfig(KIniOwnNumSection, KIniOwnVoiceNumber1, RPSnumber) != EFalse,			  
				_L("CTestStep::GetStringFromConfig did not complete as expected"));

	DEBUG_PRINTF1(_L("Board Now Dialling (1)"));
	TCoreEtelRequestStatus<RMobileCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, RPSnumber); 
		
	// Wait for 3 seconds. 
	User::After(3*KOneSecond);
		
	// ===  Check call status and caps ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusDialling.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusDialling,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusDialling
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusDialling,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusDialling"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps NOT in set of KCapsDial

	RMobileCall::TMobileCallCapsV1 wantedMobileCaps, unwantedMobileCaps;
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice;
	wantedMobileCaps.iCallEventCaps = KNoWantedBits;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps,mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);

	unwantedMobileCaps.iCallControlCaps = RMobileCall::KCapsDial;
	
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, unwantedMobileCaps.iCallControlCaps,  
			_L("RMobileCall::NotifyMobileCallCapsChange did not set expected iCallControlCaps"));
																	   
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in NOT set of KCapsDial
	ASSERT_EQUALS(call1.GetMobileCallCaps(capsPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice;
	unwantedMobileCaps.iCallControlCaps = RMobileCall::KCapsDial;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps,unwantedMobileCaps.iCallControlCaps, 
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));										   

	// === Post Notifiers ======
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus,capsPckg);
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);		
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
		
	// Cancel dialling with RCall::DialCancel 
	call1.DialCancel();

	// Check RCall::Dial request completes with KErrCancel
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeShort), KErrNone,
				  _L("RCall::DialCancel timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrCancel,  
			_L("RCall::Dial Request status was not set to KErrCancel"));

	// ===  Check call status and caps ===

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of 0.
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
	wantedMobileCaps.iCallEventCaps = 0;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp2(wantedMobileCaps,mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp2,
																	   wantedStatus);

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDial.
	ASSERT_EQUALS(call1.GetMobileCallCaps(capsPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps,KNoUnwantedBits, 
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));

	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 0.	
	wantedMobileCaps.iCallEventCaps = 0;	
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps,KNoUnwantedBits, 
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));										   

	// Check RCall::NotifyStatusChange completes with EStatusIdle.
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusIdle.
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// Wait for 2 seconds 
	User::After(2*KOneSecond);
	
	// Release call 1. 
	iEtelSessionMgr.ReleaseCall(KMainServer,KMainPhone,KVoiceLine,KCall1);
	
	// Get call 1. 
	call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// ===  Dial then cancel after 5 seconds ===

	// -- Post Notifiers ---
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus,capsPckg);
			
	// Dial RPS which won't answer.
	// Dialling own phone instead of the RPS
	/*
	ASSERT_EQUALS(RPSIgnoreNextCallL(EVoiceLine), KErrNone,  
			_L("cctsyintegraiontestsuitebase::RPSIgnoreNextCallL returned an error"));
	*/ 
	DEBUG_PRINTF1(_L("Board Now Dialling: "));
	call1.Dial(dialStatus, RPSnumber); 

	// Wait for 5 seconds. 
	User::After(5*KOneSecond);
	
	// ===  Check call status and caps ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling
	expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusDialling.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusDialling,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling
	expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusDialling
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusDialling,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusDialling"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps NOT in set of KCapsDial
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice;
	wantedMobileCaps.iCallEventCaps = KNoWantedBits;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);

	unwantedMobileCaps.iCallControlCaps = RMobileCall::KCapsDial;	
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, unwantedMobileCaps.iCallControlCaps,  
			_L("RMobileCall::NotifyMobileCallCapsChange did not set expected iCallControlCaps"));

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in NOT set of KCapsDial
	ASSERT_EQUALS(call1.GetMobileCallCaps(capsPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice;
	unwantedMobileCaps.iCallControlCaps = RMobileCall::KCapsDial;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps,unwantedMobileCaps.iCallControlCaps, 
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));										   

	// -- Post Notifiers ---
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus,capsPckg);
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
				
	// Cancel dialling with RCall::DialCancel 
	call1.DialCancel();
	
	// Check RCall::Dial request completes with KErrCancel
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeShort), KErrNone,
				  _L("RCall::DialCancel timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrCancel,  
			_L("RCall::Dial Request status was not set to KErrCancel"));
	
	// ===  Check call status and caps ===

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of 0.
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
	wantedMobileCaps.iCallEventCaps = 0;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp3(wantedMobileCaps,mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp3,
																	   wantedStatus);
	
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, KNoUnwantedBits,  
			_L("RMobileCall::NotifyMobileCallCapsChange did not set expected iCallControlCaps"));
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits,  
			_L("RMobileCall::NotifyMobileCallCapsChange did not set expected iCallEventCaps"));

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 0.
	ASSERT_EQUALS(call1.GetMobileCallCaps(capsPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice| RMobileCall::KCapsDial;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps,KNoUnwantedBits, 
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));										   
	wantedMobileCaps.iCallEventCaps = 0;
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps,KNoUnwantedBits, 
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));										   

	// Check RCall::NotifyStatusChange completes with EStatusIdle.
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusIdle.
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// Wait for 2 seconds 
	User::After(2*KOneSecond);
	
	// Release call 1. 
	iEtelSessionMgr.ReleaseCall(KMainServer,KMainPhone,KVoiceLine,KCall1);

	// Get call 1. 
	call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// ===  Dial then cancel after 15 seconds ===

	// -- Post Notifiers ---
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus,capsPckg);

	// Dial RPS which won't answer.
	// Dialling own phone instead of the RPS
	/*
	ASSERT_EQUALS(RPSIgnoreNextCallL(EVoiceLine), KErrNone,  
			_L("cctsyintegraiontestsuitebase::RPSIgnoreNextCallL returned an error"));
	*/
	DEBUG_PRINTF1(_L("Board Now Dialling"));
	call1.Dial(dialStatus, RPSnumber); 
	
	// Wait for 15 seconds. 
	User::After(15*KOneSecond);
	
	// ===  Check call status and caps ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling
	expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	// Check RCall::GetStatus returns EStatusDialling.
	ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10025);
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusDialling,
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling
	expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusDialling
	ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10025);
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusDialling,
			_L("RMobileCall::GetMobileStatus did not return a status EStatusDialling"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps NOT in set of KCapsDial
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice;
	wantedMobileCaps.iCallEventCaps = KNoWantedBits;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp4(wantedMobileCaps,mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp4,
																	   wantedStatus);

	unwantedMobileCaps.iCallControlCaps = RMobileCall::KCapsDial;	
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, unwantedMobileCaps.iCallControlCaps,  
			_L("RMobileCall::NotifyMobileCallCapsChange did not set expected iCallControlCaps"));

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in NOT set of KCapsDial
	ASSERT_EQUALS(call1.GetMobileCallCaps(capsPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice;
	unwantedMobileCaps.iCallControlCaps = RMobileCall::KCapsDial;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps,unwantedMobileCaps.iCallControlCaps, 
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));										   

	// -- Post Notifiers ---
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus,capsPckg);
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);

	// Cancel dialling with RCall::DialCancel 
	call1.DialCancel();
	
	// Check RCall::Dial request completes with KErrCancel
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeShort), KErrNone,
				  _L("RCall::DialCancel timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrCancel,  
			_L("RCall::Dial REequest status was not set to KErrCancel"));

	// ===  Check call status and caps ===

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of 0.
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;	
	wantedMobileCaps.iCallEventCaps = 0;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp5(wantedMobileCaps,mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp5,
																	   wantedStatus);
	
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, KNoUnwantedBits,  
			_L("RMobileCall::NotifyMobileCallCapsChange did not set expected iCallControlCaps"));
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits,  
			_L("RMobileCall::NotifyMobileCallCapsChange did not set expected iCallEventCaps"));

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 0.
	ASSERT_EQUALS(call1.GetMobileCallCaps(capsPckg), KErrNone,  
			_L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice| RMobileCall::KCapsDial;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps,KNoUnwantedBits, 
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));										   
	wantedMobileCaps.iCallEventCaps = 0;
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps,KNoUnwantedBits, 
			_L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));										   

	// Check RCall::NotifyStatusChange completes with EStatusIdle.
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
														 
	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone,  
			_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
			_L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusIdle.
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// PopAndDestroy
		// dialStatus
		// notifyCapsChangeStatus
		// notifyMobileCallCapsChangeStatus
		// notifyMobileCallStatusChangeStatus
		// notifyStatusChangeStatus

	CleanupStack::PopAndDestroy(5, &notifyStatusChangeStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0020::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0020");
	}



CCTSYIntegrationTestCallControl0021::CCTSYIntegrationTestCallControl0021(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0021::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0021::~CCTSYIntegrationTestCallControl0021()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0021::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0021
 * @SYMFssID BA/CTSY/CCON-0021
 * @SYMTestCaseDesc Hang up MO call before it gets connected.
 * @SYMTestPriority High
 * @SYMTestActions RCall::GetCaps, RMobileCall::NotifyMobileCallCapsChange, RMobileCall::GetMobileCallStatus, RMobileCall::GetMobileCallInfo, RLine::NotifyIncomingCall, RCall::GetInfo, RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange, RCall::OpenExistingCall, RCall::NotifyCapsChange, RCall::GetStatus, RMobileCall::GetMobileCallCaps
 * @SYMTestExpectedResults Pass - Call is hung up and call status returns to idle.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call caps and call status correct and call is hung up.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////
	
	// Check phone supports KCapsVoice

	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
				   _L("RMobileLine::GetCaps returned an error."));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
					 _L("RLine::GetCaps did not return KCapsVoice."));
					 
	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// Post notification for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyStatusChangeStatus(call1, &RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus callStatus;
	call1.NotifyStatusChange(notifyStatusChangeStatus, callStatus);

	// Post notification for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// Post notifier for RMobileCall::NotifyMobileCallCapsChange
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus(call1, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus);
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg mobileCallCapsPckg(mobileCallCaps);
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);

	// Dial RPS which will not answer.
	TPtrC rpsNumber;
	
	GetRPSNumber(EVoiceLine, rpsNumber);
	
	TCoreEtelRequestStatus<RMobileCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, rpsNumber);		

	// Wait for 3000ms. NB: Using 3000 microSeconds
	User::After(3000); 

	// ===  Check call status and caps ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusDialling.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
				  _L("RCall::GetStatus returned an error."));
	ASSERT_EQUALS(callStatus, RCall::EStatusDialling, 
				  _L("RCall::GetStatus did not return EStatusDialling."));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
	
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusDialling
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,
				  _L("RMobileCall::GetMobileCallStatus returned error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusDialling,
				  _L("RMobileCall::GetMobileCallStatus's status did not return EStatusDialling."));

	//*** NB: NotifyMobileCallCapsChange and GetMobileCallCaps not returning correct values on H2
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps NOT in set of KCapsDial
	RMobileCall::TMobileCallCapsV1 wantedMobileCaps, unwantedMobileCaps;
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice;
	wantedMobileCaps.iCallEventCaps = KNoWantedBits;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps, mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);

	unwantedMobileCaps.iCallControlCaps = RMobileCall::KCapsDial;
	
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, unwantedMobileCaps.iCallControlCaps,  
			_L("RMobileCall::NotifyMobileCallCapsChange did not set expected iCallControlCaps"));

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHangUp
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in NOT set of KCapsDial
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,
				  _L("RMobileCall::GetMobileCallCaps returned error."));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, RCall::KCapsVoice | RCall::KCapsHangUp, RCall::KCapsDial,
					_L("RMobileCall::GetMobileCallCaps returned wrong caps."));

	// Hang up call.

	// Post notifier for RMobileCall::NotifyMobileCallCapsChange
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);
	
	// Post notification for RCall::NotifyStatusChange
	call1.NotifyStatusChange(notifyStatusChangeStatus, callStatus);
	
	// Post notification for RMobileCall::NotifyMobileCallStatusChange
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	ASSERT_EQUALS(call1.HangUp(), KErrNone, _L("RMobileCall::HangUp returned error."));
	
//******** DO WE NEED TO WAIT FOR dialStatus TO change at this point ??  ************//

	// ===  Check call status and caps ===

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of 0.
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
	wantedMobileCaps.iCallEventCaps = KNoUnwantedBits;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp2(wantedMobileCaps,mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp2,
																	   wantedStatus);	

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 0.
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,
				  _L("RMobileCall::GetMobileCallCaps returned error."));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, RCall::KCapsVoice | RCall::KCapsDial, KNoUnwantedBits,
					_L("RMobileCall::GetMobileCallCaps returned wrong caps."));

	// Check RCall::NotifyStatusChange completes with EStatusIdle.
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);	

	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
				  _L("RCall::GetStatus returned an error."));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle, 
				  _L("RCall::GetStatus did not return EStatusIdle."));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusIdle.
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,
				  _L("RMobileCall::GetMobileCallStatus returned error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,
				  _L("RMobileCall::GetMobileCallStatus's status did not return EStatusIdle."));

	// Release call 1. 
	iEtelSessionMgr.ReleaseCall(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// Get call 1. 
	call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// Post notification for RCall::NotifyStatusChange
	call1.NotifyStatusChange(notifyStatusChangeStatus, callStatus);

	// Post notification for RMobileCall::NotifyMobileCallStatusChange
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// Post notifier for RMobileCall::NotifyMobileCallCapsChange
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);
	
	// Dial RPS which will not answer. 
	call1.Dial(dialStatus, rpsNumber);
	
	// Wait for 6000ms. 
	User::After(6000);
	
	// ===  Check call status and caps ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling
	expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusDialling.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
				  _L("RCall::GetStatus returned an error."));
	ASSERT_EQUALS(callStatus, RCall::EStatusDialling, 
				  _L("RCall::GetStatus did not return EStatusDialling."));
				  
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling
	expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusDialling
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,
				  _L("RMobileCall::GetMobileCallStatus returned error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusDialling,
				  _L("RMobileCall::GetMobileCallStatus's status did not return EStatusDialling."));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps NOT in set of KCapsDial
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice;
	wantedMobileCaps.iCallEventCaps = KNoWantedBits;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp1(wantedMobileCaps, mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp1,
																	   wantedStatus);

	unwantedMobileCaps.iCallControlCaps = RMobileCall::KCapsDial;
	
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, unwantedMobileCaps.iCallControlCaps,  
			_L("RMobileCall::NotifyMobileCallCapsChange did not set expected iCallControlCaps"));

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHangUp
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in NOT set of KCapsDial
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,
				  _L("RMobileCall::GetMobileCallCaps returned error."));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, RCall::KCapsVoice | RCall::KCapsHangUp, RCall::KCapsDial,
					_L("RMobileCall::GetMobileCallCaps returned wrong caps."));

	// Hang up call.
	
	// Post notifier for RMobileCall::NotifyMobileCallCapsChange
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);
	
	// Post notification for RCall::NotifyStatusChange
	call1.NotifyStatusChange(notifyStatusChangeStatus, callStatus);
	
	// Post notification for RMobileCall::NotifyMobileCallStatusChange
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	ASSERT_EQUALS(call1.HangUp(), KErrNone, _L("RMobileCall::HangUp returned error."));
	
	// ===  Check call status and caps ===

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of 0.
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
	wantedMobileCaps.iCallEventCaps = KNoUnwantedBits;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp3(wantedMobileCaps,mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp3,
																	   wantedStatus);

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 0.
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,
				  _L("RMobileCall::GetMobileCallCaps returned error."));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, RCall::KCapsVoice | RCall::KCapsDial, KNoUnwantedBits,
					_L("RMobileCall::GetMobileCallCaps returned wrong caps."));

	// Check RCall::NotifyStatusChange completes with EStatusIdle.
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);	

	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
				  _L("RCall::GetStatus returned an error."));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle, 
				  _L("RCall::GetStatus did not return EStatusIdle."));
	
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusIdle.
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,
				  _L("RMobileCall::GetMobileCallStatus returned error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,
				  _L("RMobileCall::GetMobileCallStatus's status did not return EStatusIdle."));

	// Release call 1. 
	iEtelSessionMgr.ReleaseCall(KMainServer, KMainPhone, KVoiceLine, KCall1);
	
	// Get call 1. 
	call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// Post notification for RCall::NotifyStatusChange
	call1.NotifyStatusChange(notifyStatusChangeStatus, callStatus);

	// Post notification for RMobileCall::NotifyMobileCallStatusChange
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// Post notifier for RMobileCall::NotifyMobileCallCapsChange
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);

	// Dial RPS which will not answer. 
	call1.Dial(dialStatus, rpsNumber);

	// Wait for 15000ms. 
	User::After(15000);
	
	// ===  Check call status and caps ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling
	expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

  	// Check RCall::GetStatus returns EStatusDialling.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
				  _L("RCall::GetStatus returned an error."));
	ASSERT_EQUALS(callStatus, RCall::EStatusDialling, 
				  _L("RCall::GetStatus did not return EStatusDialling."));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling
	expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusDialling
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,
				  _L("RMobileCall::GetMobileCallStatus returned error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusDialling,
				  _L("RMobileCall::GetMobileCallStatus's status did not return EStatusDialling."));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps NOT in set of KCapsDial
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice;
	wantedMobileCaps.iCallEventCaps = KNoWantedBits;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp4(wantedMobileCaps, mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp4,
																	   wantedStatus);

	unwantedMobileCaps.iCallControlCaps = RMobileCall::KCapsDial;
	
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, unwantedMobileCaps.iCallControlCaps,  
			_L("RMobileCall::NotifyMobileCallCapsChange did not set expected iCallControlCaps"));

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHangUp
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in NOT set of KCapsDial
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,
				  _L("RMobileCall::GetMobileCallCaps returned error."));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, RCall::KCapsVoice | RCall::KCapsHangUp, RCall::KCapsDial,
					_L("RMobileCall::GetMobileCallCaps returned wrong caps."));

	// Hang up call. 

	// Post notifier for RMobileCall::NotifyMobileCallCapsChange
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);
	
	// Post notification for RCall::NotifyStatusChange
	call1.NotifyStatusChange(notifyStatusChangeStatus, callStatus);
	
	// Post notification for RMobileCall::NotifyMobileCallStatusChange
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	ASSERT_EQUALS(call1.HangUp(), KErrNone, _L("RMobileCall::HangUp returned error."));
	
	// ===  Check call status and caps ===

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of 0.
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
	wantedMobileCaps.iCallEventCaps = KNoUnwantedBits;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp5(wantedMobileCaps,mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp5,
																	   wantedStatus);

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 0.
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,
				  _L("RMobileCall::GetMobileCallCaps returned error."));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, RCall::KCapsVoice | RCall::KCapsDial, KNoUnwantedBits,
					_L("RMobileCall::GetMobileCallCaps returned wrong caps."));

	// Check RCall::NotifyStatusChange completes with EStatusIdle.
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
				  _L("RCall::GetStatus returned an error."));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle, 
				  _L("RCall::GetStatus did not return EStatusIdle."));
	
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusIdle.
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,
				  _L("RMobileCall::GetMobileCallStatus returned error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,
				  _L("RMobileCall::GetMobileCallStatus's status did not return EStatusIdle."));

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	CleanupStack::PopAndDestroy(4);
									// dialStatus
									// notifyMobileCallCapsChangeStatus
									// notifyMobileCallChangeStatus
									// notifyStatusChangeStatus
								
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0021::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0021");
	}



CCTSYIntegrationTestCallControl0022::CCTSYIntegrationTestCallControl0022(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0022::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0022::~CCTSYIntegrationTestCallControl0022()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0022::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0022
 * @SYMFssID BA/CTSY/CCON-0022
 * @SYMTestCaseDesc Hang up MT call before it gets connected.
 * @SYMTestPriority High
 * @SYMTestActions RCall::GetCaps, RMobileCall::NotifyMobileCallCapsChange, RMobileCall::GetMobileCallStatus, RMobileCall::GetMobileCallInfo, RLine::NotifyIncomingCall, RCall::GetInfo, RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange, RCall::OpenExistingCall, RCall::NotifyCapsChange, RCall::GetStatus, RMobileCall::GetMobileCallCaps
 * @SYMTestExpectedResults Pass - Call hung up.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Create a mobile terminated call and hang it up 3000 ms, 5000 ms, and 10000 ms after the mobile terminated call notification.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Check phone supports KCapsVoice

	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
				   _L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
					 _L("RLine::GetCaps returned wrong caps"));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// Post notifier for RLine::NotifyIncomingCall
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus(voiceLine, &RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus);
	TName name;
	voiceLine.NotifyIncomingCall(notifyIncomingCallStatus, name);
	
	// Request for incoming call from RPS. 
	ASSERT_EQUALS(RPSRequestIncomingCallL(EVoiceLine), KErrNone, _L("RPSRequestIncomingCallL returned error."));
	
	// Check RLine::NotifyIncomingCall completes with valid call name.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus, ETimeMedium), KErrNone, 
				 _L("RLine::NotifyIncomingCall timed out."));
	ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone,  
				 _L("RLine::NotifyIncomingCall returned with error status."));
	ASSERT_TRUE(name.Length() > 0,  
				_L("RLine::NotifyIncomingCall did not set a line name"));

	// Get the incoming call
	TCallId incomingCallId;
	RMobileCall& incomingCall = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, name, incomingCallId);

	// ===  Check call caps ===

	/************************* NOTE ************************
	The following notifications will not be checked, since you
	can not post notifications on an unassigned call object.

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsAnswer.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsAnswer | KCapsTransfer.
	// Check RCall::NotifyStatusChange completes with EStatusRinging
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusRinging
	********************************************************/

	
	// Check RCall::GetCaps supports KCapsAnswer | KCapsVoice.
	//*** Note: H2 returns the KCapsHangUp bit as well as KCapsAnswer | KCapsVoice.
	RCall::TCaps callCaps;
	ASSERT_EQUALS(incomingCall.GetCaps(callCaps), KErrNone,
				  _L("RMobileCall::GetCaps returned error."));
	ASSERT_BITS_SET(callCaps.iFlags, RCall::KCapsAnswer | RCall::KCapsVoice, KNoUnwantedBits,
					_L("RCall::GetCaps returned wrong caps"));
	
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsAnswer | KCapsTransfer.
	TUint32 wantedCallControlCaps = RMobileCall::KCapsVoice | 
									RMobileCall::KCapsHold | 
									RMobileCall::KCapsAnswer | 
									RMobileCall::KCapsTransfer;
	TUint32 wantedCallEventCaps = 0;
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg mobileCallCapsPckg(mobileCallCaps);
	
	ASSERT_EQUALS(incomingCall.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,   
				  _L("RMobileCall::GetMobileCallCaps returned an error"));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedCallControlCaps, KNoUnwantedBits,   
					_L("RMobileCall::GetMobileCallCaps returned wrong caps"));
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedCallEventCaps, KNoUnwantedBits,   
					_L("RMobileCall::GetMobileCallCaps returned wrong caps"));

	// ===  Check call status ===

	// Check RCall::GetStatus returns EStatusRinging
	RCall::TStatus callStatus;
	ASSERT_EQUALS(incomingCall.GetStatus(callStatus), KErrNone,  
				  _L("RCall::GetStatus returned an error."));
	ASSERT_EQUALS(callStatus, RCall::EStatusRinging, 
				  _L("RCall::GetStatus did not return EStatusRinging."));

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusRinging
	RMobileCall::TMobileCallStatus  mobileCallStatus;
	ASSERT_EQUALS(incomingCall.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusRinging, _L("RMobileCall::GetMobileCallStatus returned error."));
	
	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusRinging.
	// Check RCall::GetInfo returns call duration of 0.
	RCall::TCallInfo callInfo;
	ASSERT_EQUALS(incomingCall.GetInfo(callInfo), KErrNone,  
				  _L("RCall::GetInfo returned an error."));
	ASSERT_TRUE(callInfo.iCallName.Length() >0,  
				_L("RCall::GetInfo returned an invalid Call name."));
	ASSERT_TRUE(callInfo.iLineName.Length() >0,  
				_L("RCall::GetInfo returned an invalid Line name."));
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusRinging,    
				  _L("RCall::GetInfo did not return iStatus of EStatusRinging."));
	ASSERT_EQUALS(callInfo.iDuration.Int(), 0,    
				  _L("RCall::GetInfo did not return iDuration of 0."));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid. ** How to do this? **
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	RMobileCall::TMobileCallInfoV1 mobileCallInfo;
	RMobileCall::TMobileCallInfoV1Pckg callInfoPckg(mobileCallInfo);
	ASSERT_EQUALS(incomingCall.GetMobileCallInfo(callInfoPckg), KErrNone, 
				  _L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() > 0, 
				_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0, 
				_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));
				
	iCallControlTestHelper.CheckForValidCallInfo(mobileCallInfo);

	// Wait for 3000ms. 
	User::After(3000);   // Note assuming microseconds, not milliseconds

	// Hang up call.
	
	// Post notification for RCall::NotifyCapsChange
	TCoreEtelRequestStatus<RCall> notifyCapsChangeStatus(incomingCall, &RCall::NotifyCapsChangeCancel);	
	CleanupStack::PushL(notifyCapsChangeStatus);
	RCall::TCaps caps;
	incomingCall.NotifyCapsChange(notifyCapsChangeStatus, caps);
	
	// Post notification for RMobileCall::NotifyMobileCallCapsChange
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus(incomingCall, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus);
	incomingCall.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);
	
	// Post notification for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus(incomingCall, &RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	incomingCall.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);
	
	// Post notification for RMobileCall::NotifyMobileCallStatusChange 
	TExtEtelRequestStatus notifyMobileCallChangeStatus(incomingCall, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	incomingCall.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	
	//*************** NOTE *******************
	// As we have not answered the call, I seem to recall TRP TSY does not allow you to hang up locally.
	// So (assuming the network hasn't answered the call yet) we need to request RPS to hang up.
	// Note: The new CTSY & board combo *may* allow you to hang up locally.
	//
/*	ASSERT_EQUALS(RPSHangupL(EVoiceLine, 0), KErrNone, _L("RPSHangupL returned an error")); */
	
	//*************** BUT *******************
	// Are WE supposed to hang-up the call? ie NOT Rps ?? If so have to see if CTSY allows us to use HangUp, or if we have to 
	// answer the call first before calling HangUp !!!
	//
	TCoreEtelRequestStatus<RCall> hangUpStatus(incomingCall, &RCall::HangUpCancel);  // If HangUp fails, try Answering the call first !!
	CleanupStack::PushL(hangUpStatus);
	incomingCall.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone,  
				  _L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone,  
				  _L("RCall::HangUp returned and error"));


	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsDial.
	RCall::TCaps wantedCaps, unwantedCaps;
	wantedCaps.iFlags = RCall::KCapsVoice | RCall::KCapsDial;
	unwantedCaps.iFlags = 0;
	const TInt wantedStatus = KErrNone;
	
	iCallControlTestHelper.WaitForCallNotifyCapsChange(incomingCall,
													   notifyCapsChangeStatus,
													   caps,
													   wantedCaps,
													   unwantedCaps,
													   wantedStatus);
													   
	// Check RCall::GetCaps supports KCapsVoice | KCapsHangUp.
	ASSERT_EQUALS(incomingCall.GetCaps(caps), KErrNone,   
				  _L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(caps.iFlags, RCall::KCapsHangUp | RCall::KCapsVoice, KNoUnwantedBits,  
					_L("RCall::GetCaps returned wrong caps"));
			
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of 0.
	RMobileCall::TMobileCallCapsV1 wantedMobileCaps;
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
	wantedMobileCaps.iCallEventCaps = 0;

	TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps, mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(incomingCall,
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);
																	   
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 0.
	ASSERT_EQUALS(incomingCall.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,  
				  _L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
						

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle.
	RCall::TStatus expectedCallStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(incomingCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	
	incomingCall.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(incomingCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(incomingCall.GetStatus(callStatus),KErrNone,  
				  _L("RCall::GetStatus returned an error."));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
				  _L("RCall::GetStatus did not return EStatusIdle."));
			
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(incomingCall,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		wantedStatus);
															
	incomingCall.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(incomingCall,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		wantedStatus);
															
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(incomingCall.GetMobileCallStatus(mobileCallStatus), KErrNone,  
				  _L("RMobileCall::GetMobileStatus returned an error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
				  _L("RMobileCall::GetMobileStatus did not return a status EStatusIdle."));

	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusConnected.  *** Is this correct ? should be EStatusIdle ***
	// Check RCall::GetInfo returns call duration of > 0.
	ASSERT_EQUALS(incomingCall.GetInfo(callInfo), KErrNone,  
				  _L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() > 0,  
				_L("RCall::GetInfo returned an invalid  name"));
	ASSERT_TRUE(callInfo.iLineName.Length() > 0,  
				_L("RCall::GetInfo returned an invalid  Line name"));
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected,  
				  _L("RCall::GetInfo wrong iStatus, should be EStatusConnected"));
	ASSERT_TRUE(callInfo.iDuration.Int() > 0,  
				_L("RCall::GetInfo wrong iDuration, should be >0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid.
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	RMobileCall::TMobileCallInfoV1Pckg mobileCallInfoPckg(mobileCallInfo);
	ASSERT_EQUALS(incomingCall.GetMobileCallInfo(mobileCallInfoPckg), KErrNone,  
				  _L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() > 0,  
				_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0,  
				_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));

	iCallControlTestHelper.CheckForValidCallInfo(mobileCallInfo);
	
	// Release call 1. *** No *** - Release the incoming call
	iEtelSessionMgr.ReleaseCall(KMainServer, KMainPhone, KVoiceLine, incomingCallId);

	// Get call 1. ** No need **
//	call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// Repeat test pausing for 5000ms and 10000ms instead. 

	// ===  Repeating test with 5000ms pause ===

	// Post notifier for RLine::NotifyIncomingCall
	voiceLine.NotifyIncomingCall(notifyIncomingCallStatus, name);
	
	// Request for incoming call from RPS. 
	ASSERT_EQUALS(RPSRequestIncomingCallL(EVoiceLine), KErrNone, _L("RPSRequestIncomingCallL returned error."));
	
	// Check RLine::NotifyIncomingCall completes with valid call name.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus, ETimeMedium), KErrNone, 
				 _L("RLine::NotifyIncomingCall timed out."));
	ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone,  
				 _L("RLine::NotifyIncomingCall returned with error status."));
	ASSERT_TRUE(name.Length() > 0,  
				_L("RLine::NotifyIncomingCall did not set a line name"));

	// Get the call
	incomingCall = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, name, incomingCallId);

	// ===  Check call caps ===

	/************************* NOTE ************************
	As commented above, notifications will not to checked.
	********************************************************/
	
	// Check RCall::GetCaps supports KCapsAnswer | KCapsVoice.
	//*** Note: H2 returns the KCapsHangUp bit as well as KCapsAnswer | KCapsVoice.
	ASSERT_EQUALS(incomingCall.GetCaps(callCaps), KErrNone,
				  _L("RMobileCall::GetCaps returned error."));
	ASSERT_BITS_SET(callCaps.iFlags, RCall::KCapsAnswer | RCall::KCapsVoice, KNoUnwantedBits,
					_L("RCall::GetCaps returned wrong caps"));
	 
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsAnswer | KCapsTransfer.
	wantedCallControlCaps = RMobileCall::KCapsVoice | 
									RMobileCall::KCapsHold | 
									RMobileCall::KCapsAnswer | 
									RMobileCall::KCapsTransfer;
	wantedCallEventCaps = 0;
	ASSERT_EQUALS(incomingCall.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,   
				  _L("RMobileCall::GetMobileCallCaps returned an error"));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedCallControlCaps, KNoUnwantedBits,   
					_L("RMobileCall::GetMobileCallCaps returned wrong caps"));
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedCallEventCaps, KNoUnwantedBits,   
					_L("RMobileCall::GetMobileCallCaps returned wrong caps"));

	// ===  Check call status ===

	// Check RCall::GetStatus returns EStatusRinging
	ASSERT_EQUALS(incomingCall.GetStatus(callStatus), KErrNone,  
				  _L("RCall::GetStatus returned an error."));
	ASSERT_EQUALS(callStatus, RCall::EStatusRinging, 
				  _L("RCall::GetStatus did not return EStatusRinging."));

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusRinging
	ASSERT_EQUALS(incomingCall.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusRinging, _L("RMobileCall::GetMobileCallStatus returned error."));
	
	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusRinging.
	// Check RCall::GetInfo returns call duration of 0.
	ASSERT_EQUALS(incomingCall.GetInfo(callInfo), KErrNone,  
				  _L("RCall::GetInfo returned an error."));
	ASSERT_TRUE(callInfo.iCallName.Length() >0,  
				_L("RCall::GetInfo returned an invalid Call name."));
	ASSERT_TRUE(callInfo.iLineName.Length() >0,  
				_L("RCall::GetInfo returned an invalid Line name."));
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusRinging,    
				  _L("RCall::GetInfo did not return iStatus of EStatusRinging."));
	ASSERT_EQUALS(callInfo.iDuration.Int(), 0,    
				  _L("RCall::GetInfo did not return iDuration of 0."));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid. ** How to do this? **
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	ASSERT_EQUALS(incomingCall.GetMobileCallInfo(callInfoPckg), KErrNone, 
				  _L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() > 0, 
				_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0, 
				_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));
				
	iCallControlTestHelper.CheckForValidCallInfo(mobileCallInfo);

	// Wait for 5000ms. 
	User::After(5000);   // Note assuming microseconds, not milliseconds

	// Hang up call.
	
	// Post notification for RCall::NotifyCapsChange
	incomingCall.NotifyCapsChange(notifyCapsChangeStatus, caps);
	
	// Post notification for RMobileCall::NotifyMobileCallCapsChange
	incomingCall.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);
	
	// Post notification for RCall::NotifyStatusChange
	incomingCall.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);
	
	// Post notification for RMobileCall::NotifyMobileCallStatusChange 
	incomingCall.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	

	
	//*************** NOTE *******************
	// As we have not answered the call, I seem to recall TRP TSY does not allow you to hang up locally.
	// So (assuming the network hasn't answered the call yet) we need to request RPS to hang up.
	// Note: The new CTSY board combo *may* allow you to hang up locally.
	//
/*	ASSERT_EQUALS(RPSHangupL(EVoiceLine, 0), KErrNone, _L("RPSHangupL returned an error")); */
	
	//*************** BUT *******************
	// Are WE supposed to hang-up the call? ie NOT Rps ?? If so have to see if CTSY allows us to use HangUp, or if we have to 
	// answer the call first before calling HangUp !!!
	//
	incomingCall.HangUp(hangUpStatus);   // If HangUp fails, try Answering the call first !!
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone,  
				  _L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone,  
				  _L("RCall::HangUp returned and error"));
				  

	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsDial.
	wantedCaps.iFlags = RCall::KCapsVoice | RCall::KCapsDial;
	unwantedCaps.iFlags = 0;
	
	iCallControlTestHelper.WaitForCallNotifyCapsChange(incomingCall,
													   notifyCapsChangeStatus,
													   caps,
													   wantedCaps,
													   unwantedCaps,
													   wantedStatus);
													   
	// Check RCall::GetCaps supports KCapsVoice | KCapsHangUp.
	ASSERT_EQUALS(incomingCall.GetCaps(caps), KErrNone,   
				  _L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(caps.iFlags, RCall::KCapsHangUp | RCall::KCapsVoice, KNoUnwantedBits,  
					_L("RCall::GetCaps returned wrong caps"));
			
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of 0.
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
	wantedMobileCaps.iCallEventCaps = 0;

	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(incomingCall,
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);
																	   
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 0.
	ASSERT_EQUALS(incomingCall.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,  
				  _L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle.
	expectedCallStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(incomingCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	
	incomingCall.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(incomingCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(incomingCall.GetStatus(callStatus),KErrNone,  
				  _L("RCall::GetStatus returned an error."));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
				  _L("RCall::GetStatus did not return EStatusIdle."));
			
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle.
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(incomingCall,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		wantedStatus);
															
	incomingCall.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(incomingCall,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		wantedStatus);
															
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(incomingCall.GetMobileCallStatus(mobileCallStatus), KErrNone,  
				  _L("RMobileCall::GetMobileStatus returned an error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
				  _L("RMobileCall::GetMobileStatus did not return a status EStatusIdle."));

	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusConnected.  *** Is this correct ? should be EStatusIdle ***
	// Check RCall::GetInfo returns call duration of > 0.
	ASSERT_EQUALS(incomingCall.GetInfo(callInfo), KErrNone,  
				  _L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() > 0,  
				_L("RCall::GetInfo returned an invalid  name"));
	ASSERT_TRUE(callInfo.iLineName.Length() > 0,  
				_L("RCall::GetInfo returned an invalid  Line name"));
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected,  
				  _L("RCall::GetInfo wrong iStatus, should be EStatusConnected"));
	ASSERT_TRUE(callInfo.iDuration.Int() > 0,  
				_L("RCall::GetInfo wrong iDuration, should be >0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid.
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	ASSERT_EQUALS(incomingCall.GetMobileCallInfo(mobileCallInfoPckg), KErrNone,  
				  _L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() > 0,  
				_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0,  
				_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));

	iCallControlTestHelper.CheckForValidCallInfo(mobileCallInfo);
	
	// Release call 1. *** No *** - Release the incoming call
	iEtelSessionMgr.ReleaseCall(KMainServer, KMainPhone, KVoiceLine, incomingCallId);

	// Get call 1. ** No need **
//	call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// ===  Repeating test with 10000ms pause ===

	// Post notifier for RLine::NotifyIncomingCall
	voiceLine.NotifyIncomingCall(notifyIncomingCallStatus, name);
	
	// Request for incoming call from RPS. 
	ASSERT_EQUALS(RPSRequestIncomingCallL(EVoiceLine), KErrNone, _L("RPSRequestIncomingCallL returned error."));
	
	// Check RLine::NotifyIncomingCall completes with valid call name.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus, ETimeMedium), KErrNone, 
				 _L("RLine::NotifyIncomingCall timed out."));
	ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone,  
				 _L("RLine::NotifyIncomingCall returned with error status."));
	ASSERT_TRUE(name.Length() > 0,  
				_L("RLine::NotifyIncomingCall did not set a line name"));

	// Get the call
	incomingCall = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, name, incomingCallId);
	
	// ===  Check call caps ===

	/************************* NOTE ************************
	As commented above, notifications will not to checked.
	********************************************************/
	
	// Check RCall::GetCaps supports KCapsAnswer | KCapsVoice.
	//*** Note: H2 returns the KCapsHangUp bit as well as KCapsAnswer | KCapsVoice.
	ASSERT_EQUALS(incomingCall.GetCaps(callCaps), KErrNone,
				  _L("RMobileCall::GetCaps returned error."));
	ASSERT_BITS_SET(callCaps.iFlags, RCall::KCapsAnswer | RCall::KCapsVoice, KNoUnwantedBits,
					_L("RCall::GetCaps returned wrong caps"));
	 
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsAnswer | KCapsTransfer.
	wantedCallControlCaps = RMobileCall::KCapsVoice | 
							RMobileCall::KCapsHold | 
							RMobileCall::KCapsAnswer | 
							RMobileCall::KCapsTransfer;
	wantedCallEventCaps = 0;
	ASSERT_EQUALS(incomingCall.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,   
				  _L("RMobileCall::GetMobileCallCaps returned an error"));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedCallControlCaps, KNoUnwantedBits,   
					_L("RMobileCall::GetMobileCallCaps returned wrong caps"));
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedCallEventCaps, KNoUnwantedBits,   
					_L("RMobileCall::GetMobileCallCaps returned wrong caps"));
	
	// ===  Check call status ===

	// Check RCall::GetStatus returns EStatusRinging
	ASSERT_EQUALS(incomingCall.GetStatus(callStatus), KErrNone,  
				  _L("RCall::GetStatus returned an error."));
	ASSERT_EQUALS(callStatus, RCall::EStatusRinging, 
				  _L("RCall::GetStatus did not return EStatusRinging."));

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusRinging
	ASSERT_EQUALS(incomingCall.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusRinging, _L("RMobileCall::GetMobileCallStatus returned error."));
	
	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusRinging.
	// Check RCall::GetInfo returns call duration of 0.
	ASSERT_EQUALS(incomingCall.GetInfo(callInfo), KErrNone,  
				  _L("RCall::GetInfo returned an error."));
	ASSERT_TRUE(callInfo.iCallName.Length() >0,  
				_L("RCall::GetInfo returned an invalid Call name."));
	ASSERT_TRUE(callInfo.iLineName.Length() >0,  
				_L("RCall::GetInfo returned an invalid Line name."));
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusRinging,    
				  _L("RCall::GetInfo did not return iStatus of EStatusRinging."));
	ASSERT_EQUALS(callInfo.iDuration.Int(), 0,    
				  _L("RCall::GetInfo did not return iDuration of 0.")); 

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid. ** How to do this? **
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	ASSERT_EQUALS(incomingCall.GetMobileCallInfo(callInfoPckg), KErrNone, 
				  _L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() > 0, 
				_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0, 
				_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));
				
	iCallControlTestHelper.CheckForValidCallInfo(mobileCallInfo);

	// Wait for 10000ms. 
	User::After(10000);   // Note assuming microseconds, not milliseconds

	// Hang up call.
	
	// Post notification for RCall::NotifyCapsChange
	incomingCall.NotifyCapsChange(notifyCapsChangeStatus, caps);
	
	// Post notification for RMobileCall::NotifyMobileCallCapsChange
	incomingCall.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);
	
	// Post notification for RCall::NotifyStatusChange
	incomingCall.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);
	
	// Post notification for RMobileCall::NotifyMobileCallStatusChange 
	incomingCall.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	//*************** NOTE *******************
	// As we have not answered the call, I seem to recall TRP TSY does not allow you to hang up locally.
	// So (assuming the network hasn't answered the call yet) we need to request RPS to hang up.
	// Note: The new CTSY & board combo *may* allow you to hang up locally.
	//
/*	ASSERT_EQUALS(RPSHangupL(EVoiceLine, 0), KErrNone, _L("RPSHangupL returned an error")); */
	
	//*************** BUT *******************
	// Are WE supposed to hang-up the call? ie NOT Rps ?? If so have to see if CTSY allows us to use HangUp, or if we have to 
	// answer the call first before calling HangUp !!!
	//
	incomingCall.HangUp(hangUpStatus);			// If HangUp fails, try Answering the call first !!
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone,  
				  _L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone,  
				  _L("RCall::HangUp returned and error"));
	

	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsDial.
	wantedCaps.iFlags = RCall::KCapsVoice | RCall::KCapsDial;
	unwantedCaps.iFlags = 0;
	
	iCallControlTestHelper.WaitForCallNotifyCapsChange(incomingCall,
													   notifyCapsChangeStatus,
													   caps,
													   wantedCaps,
													   unwantedCaps,
													   wantedStatus);
													   
	// Check RCall::GetCaps supports KCapsVoice | KCapsHangUp.
	ASSERT_EQUALS(incomingCall.GetCaps(caps), KErrNone,   
				  _L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(caps.iFlags, RCall::KCapsHangUp | RCall::KCapsVoice, KNoUnwantedBits,  
					_L("RCall::GetCaps returned wrong caps"));
			
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of 0.
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
	wantedMobileCaps.iCallEventCaps = 0;

	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(incomingCall,
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);
																	   
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 0.
	ASSERT_EQUALS(incomingCall.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,  
				  _L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle.
	expectedCallStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(incomingCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	
	incomingCall.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(incomingCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(incomingCall.GetStatus(callStatus),KErrNone,  
				  _L("RCall::GetStatus returned an error."));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
				  _L("RCall::GetStatus did not return EStatusIdle."));
			
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle.
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(incomingCall,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		wantedStatus);
															
	incomingCall.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(incomingCall,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		wantedStatus);
															
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(incomingCall.GetMobileCallStatus(mobileCallStatus), KErrNone,  
				  _L("RMobileCall::GetMobileStatus returned an error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
				  _L("RMobileCall::GetMobileStatus did not return a status EStatusIdle."));

	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusConnected.  *** Is this correct ? should be EStatusIdle ***
	// Check RCall::GetInfo returns call duration of > 0.
	ASSERT_EQUALS(incomingCall.GetInfo(callInfo), KErrNone,  
				  _L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() > 0,  
				_L("RCall::GetInfo returned an invalid  name"));
	ASSERT_TRUE(callInfo.iLineName.Length() > 0,  
				_L("RCall::GetInfo returned an invalid  Line name"));
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected,  
				  _L("RCall::GetInfo wrong iStatus, should be EStatusConnected"));
	ASSERT_TRUE(callInfo.iDuration.Int() > 0,  
				_L("RCall::GetInfo wrong iDuration, should be >0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid.
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	ASSERT_EQUALS(incomingCall.GetMobileCallInfo(mobileCallInfoPckg), KErrNone,  
				  _L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() > 0,  
				_L("RMobileCall::GetMobileCallInfo returned an invalid line name"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0,  
				_L("RMobileCall::GetMobileCallInfo returned unexpected flags in iValid"));

	iCallControlTestHelper.CheckForValidCallInfo(mobileCallInfo);
	
	// Release call 1. *** No *** - Release the incoming call
	iEtelSessionMgr.ReleaseCall(KMainServer, KMainPhone, KVoiceLine, incomingCallId);
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	CleanupStack::PopAndDestroy(6);
									// hangUpStatus
                                    // notifyMobileCallChangeStatus
									// notifyCallStatusChangeStatus
									// notifyMobileCallCapsChangeStatus
									// notifyCapsChangeStatus
									// notifyIncomingCallStatus
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0022::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0022");
	}



CCTSYIntegrationTestCallControl0023::CCTSYIntegrationTestCallControl0023(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0023::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0023::~CCTSYIntegrationTestCallControl0023()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0023::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0023
 * @SYMFssID BA/CTSY/CCON-0023
 * @SYMTestCaseDesc Hold a call then dial a second call.
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallStatusChange, RMobileCall::GetMobileCallStatus, RMobileCall::Hold, RCall::HangUp, RMobileCall::NotifyCallEvent, RCall::NotifyStatusChange, RCall::GetStatus
 * @SYMTestExpectedResults Pass - Call 2 is can be made when call 1 is held
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify second call can be made when first one is held and call statuses is correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	
	// Check phone supports KCapsVoice

	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
				 _L("RMobileLine::GetCaps returned an error."));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
					 _L("RLine::GetCaps did not return KCapsVoice."));

	// Get call 2
	RMobileCall& call2 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall2);

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// Post Notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyStatusChangeStatus(call1, &RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus callStatus;
	call1.NotifyStatusChange(notifyStatusChangeStatus, callStatus);
	
	// Post Notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	
	// Dial a number that answers with call 1.
	TPtrC number; 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,
				_L("GetStringFromConfig did not complete as expected"));
	DEBUG_PRINTF1(_L("Board Now Dialling: "));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone, _L("RCall::Dial returned with an error"));

	// Check RCall::NotifyStatusChange for call 1 completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	TInt expectedStatus = KErrNone;
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
														 
	call1.NotifyStatusChange(notifyStatusChangeStatus, callStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);

	call1.NotifyStatusChange(notifyStatusChangeStatus, callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
														 
	// Check RCall::GetStatus for call 1 returns EStatusConnected.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
				  _L("RCall::GetStatus returned an error."));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected, 
				  _L("RCall::GetStatus did not return EStatusConnected."));
				  
	// Check RMobileCall::NotifyMobileCallStatusChange for call 1 completes with EStatusDialling->EStatusConnecting->EStatusConnected
	const TInt wantedStatus = KErrNone;
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnected;															
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	// Check RMobileCall::GetMobileCallStatus for call 1 returns EStatusConnected
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, 
				  _L("RMobileCall::GetMobileStatus returned an error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, 
				  _L("RMobileCall::GetMobileStatus did not return a status EStatusConnected."));
			
			
	// Post notifier for RMobileCall::NotifyCallEvent
	TExtEtelRequestStatus notifyCallEventStatus(call1, EMobileCallNotifyCallEvent);
	CleanupStack::PushL(notifyCallEventStatus);
	RMobileCall::TMobileCallEvent event;
	call1.NotifyCallEvent(notifyCallEventStatus, event);
	
	// Post Notifier for RMobileCall::NotifyMobileCallStatusChange
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	
	// Hold call 1.
	TExtEtelRequestStatus holdStatus(call1, EMobileCallHold);
	CleanupStack::PushL(holdStatus);
	call1.Hold(holdStatus);
	
	// Wait for hold completion. 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(holdStatus, ETimeShort), KErrNone, 
				  _L("RMobileCall::Hold timed-out."));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
				  _L("RMobileCall::Hold problem holding the call."));

	// Check RMobileCall::NotifyCallEvent for call 1 completes with ELocalHold
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent( 
									call1,
									notifyCallEventStatus,
									event, 
									RMobileCall::ELocalHold,
									wantedStatus);

	// Check RMobileCall::NotifyMobileCallStatusChange for call 1 completes with EStatusHold
	expectedMobileCallStatus = RMobileCall::EStatusHold;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	// Check RMobileCall::GetMobileCallStatus for call 1 returns status of EStatusHold
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
				  _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusHold,  
				  _L("RMobileCall::GetMobileCallStatus did not return EStatusHold"));


	// Post Notifier for RCall::NotifyStatusChange for call2
	TCoreEtelRequestStatus<RCall> notifyStatusChangeStatus2(call2, &RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus2);
	call2.NotifyStatusChange(notifyStatusChangeStatus2, callStatus);
	
	// Post Notifier for RMobileCall::NotifyMobileCallStatusChange for call2
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus2(call2, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus2);
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus);
	
	// Dial a number that answers with call 2.
	DEBUG_PRINTF1(_L("Board Now Dialling: "));
	call2.Dial(dialStatus, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone, _L("RCall::Dial returned with an error"));
	
	// Check RCall::NotifyStatusChange for call 2 completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
														 notifyStatusChangeStatus2,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
														 
	call2.NotifyStatusChange(notifyStatusChangeStatus2, callStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
														 notifyStatusChangeStatus2,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);

	call2.NotifyStatusChange(notifyStatusChangeStatus2, callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
														 notifyStatusChangeStatus2,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
														 
	// Check RCall::GetStatus for call 2 returns EStatusConnected.
	ASSERT_EQUALS(call2.GetStatus(callStatus), KErrNone,  
				  _L("RCall::GetStatus returned an Error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected,  
				  _L("RCall::GetStatus did not return EStatusConnected"));

	// Check RMobileCall::NotifyMobileCallStatusChange for call 2 completes with EStatusDialling->EStatusConnecting->EStatusConnected
	expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
																		notifyMobileCallStatusChangeStatus2,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		wantedStatus);
															
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
																		notifyMobileCallStatusChangeStatus2,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		wantedStatus);

	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
																		notifyMobileCallStatusChangeStatus2,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		wantedStatus);
											
	// Check RMobileCall::GetMobileCallStatus for call 2 returns EStatusConnected
	ASSERT_EQUALS(call2.GetMobileCallStatus(mobileCallStatus), KErrNone, 
				  _L("RMobileCall::GetMobileStatus returned an error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, 
				  _L("RMobileCall::GetMobileStatus did not return a status EStatusConnected."));

	// Check RMobileCall::GetMobileCallStatus for call 1 returns status of EStatusHold
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
				  _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusHold,  
				  _L("RMobileCall::GetMobileCallStatus did not return EStatusHold"));


	// Post Notifier for RMobileCall::NotifyMobileCallStatusChange
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	
	// Hang up call 1.
	ASSERT_EQUALS(call1.HangUp(), KErrNone, _L("RMobileCall::HangUp returned error."));

	// Check RMobileCall::NotifyMobileCallStatusChange for call 1 completes with EStatusDisconnecting->EStatusIdle
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus for call 1 returns EStatusIdle
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
				  _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
				  _L("RMobileCall::GetMobileCallStatus did not return EStatusIdle"));

	// Check RMobileCall::GetMobileCallStatus for call 2 returns EStatusConnected
	ASSERT_EQUALS(call2.GetMobileCallStatus(mobileCallStatus), KErrNone,  
				  _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
				  _L("RMobileCall::GetMobileCallStatus did not return EStatusConnected"));


	// Post Notifier for RMobileCall::NotifyMobileCallStatusChange for call2
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus);

	// Hang up call 2. 
	ASSERT_EQUALS(call2.HangUp(), KErrNone, _L("RMobileCall::HangUp returned error."));
	
	// Check RMobileCall::NotifyMobileCallStatusChange for call 2 completes with EStatusDisconnecting->EStatusIdle
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
																		notifyMobileCallStatusChangeStatus2,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		wantedStatus);
															
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
																		notifyMobileCallStatusChangeStatus2,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		wantedStatus);
																		
	// Check RMobileCall::GetMobileCallStatus for call 2 returns EStatusIdle
	ASSERT_EQUALS(call2.GetMobileCallStatus(mobileCallStatus), KErrNone, 
				  _L("RMobileCall::GetMobileStatus returned an error."));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle, 
				  _L("RMobileCall::GetMobileStatus did not return a status EStatusIdle."));
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	CleanupStack::PopAndDestroy(7);
									// notifyMobileCallStatusChangeStatus2
									// notifyStatusChangeStatus2
									// holdStatus
									// notifyCallEventStatus
									// dialStatus
									// notifyMobileCallStatusChangeStatus
									// notifyStatusChangeStatus
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0023::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0023");
	}



CCTSYIntegrationTestCallControl0024::CCTSYIntegrationTestCallControl0024(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0024::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0024::~CCTSYIntegrationTestCallControl0024()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0024::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0024
 * @SYMFssID BA/CTSY/CCON-0024
 * @SYMTestCaseDesc Hold a call then resume it.
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallCapsChange, RMobileCall::NotifyCallEvent, RMobileCall::NotifyRemotePartyInfoChange, RCall::Dial, RMobileCall::GetMobileCallCaps, RMobileCall::Hold, RMobileCall::Resume, RMobileCall::GetMobileCallStatus, RMobilePhone::NotifyStopInDTMFString, RMobilePhone::NotifyDTMFCapsChange
 * @SYMTestExpectedResults Pass - Call held and resumed. Call event, caps and status correct.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call status, call event, call caps, remote party info and DTMF caps correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Check phone supports KCapsVoice

	// Get phone
	RMobilePhone& mobilePhone = iEtelSessionMgr.GetPhoneL(KMainServer, KMainPhone);

	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone,  
				 _L("RMobileLine::GetCaps returned an error."));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
					 _L("RLine::GetCaps did not return KCapsVoice."));

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// Post Notifier for RCall::NotifyCapsChange
	TCoreEtelRequestStatus<RCall> notifyCapsChangeStatus(call1, &RCall::NotifyCapsChangeCancel);	
	CleanupStack::PushL(notifyCapsChangeStatus);
	RCall::TCaps caps;
	call1.NotifyCapsChange(notifyCapsChangeStatus, caps);

	// post a notifier for RMobileCall::NotifyMobileCallCapsChange
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus(call1, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus);
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg mobileCallCapsPckg(mobileCallCaps);
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);
	
	// Post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (call1, &RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	RCall::TStatus callStatus;
	call1.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);
	
	// post a notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	// Post a notifier for RMobileCall::NotifyRemotePartyInfoChange
	TExtEtelRequestStatus notifyRemotePartyInfoChangeStatus(call1, EMobileCallNotifyRemotePartyInfoChange);
	CleanupStack::PushL(notifyRemotePartyInfoChangeStatus);
	RMobileCall::TMobileCallRemotePartyInfoV1 rpInfo;

	RMobileCall::TMobileCallRemotePartyInfoV1Pckg rpInfoPckg(rpInfo);
	call1.NotifyRemotePartyInfoChange(notifyRemotePartyInfoChangeStatus, rpInfoPckg);

	// Dial a number that answers 
	TPtrC number; 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,
				_L("GetStringFromConfig did not complete as expected"));
	DEBUG_PRINTF1(_L("Board Now Dialling: "));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone, _L("RCall::Dial returned with an error"));

	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsHangUp.
	RCall::TCaps wantedCaps, unwantedCaps;
	wantedCaps.iFlags = RCall::KCapsVoice | RCall::KCapsHangUp;
	unwantedCaps.iFlags = 0;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyCapsChange(call1,
													   notifyCapsChangeStatus,
													   caps,
													   wantedCaps,
													   unwantedCaps,
													   wantedStatus);
												   
	// Check RCall::GetCaps supports KCapsHangUp | KCapsVoice.
	ASSERT_EQUALS(call1.GetCaps(caps), KErrNone,   
				  _L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(caps.iFlags, RCall::KCapsHangUp | RCall::KCapsVoice, KNoUnwantedBits,  
					_L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of KCapsLocalHold | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	RMobileCall::TMobileCallCapsV1 wantedMobileCaps;
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsHold | RMobileCall::KCapsHangUp;
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | RMobileCall::KCapsRemoteHold | RMobileCall::KCapsRemoteTerminate | RMobileCall::KCapsRemoteConferenceCreate;

	TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps, mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1,
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of KCapsLocalHold | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,  
				  _L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | 
										RMobileCall::KCapsHold | 
										RMobileCall::KCapsHangUp;

	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, KNoUnwantedBits,
					_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));
	
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold |
									  RMobileCall::KCapsRemoteHold | 
									  RMobileCall::KCapsRemoteTerminate | 
									  RMobileCall::KCapsRemoteConferenceCreate;

	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits,
				 	_L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	
	call1.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
													 notifyCallStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);

	call1.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
													 notifyCallStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);

	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
				  _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected,  
				  _L("RCall::GetStatus returned an unexpected call status"));
			
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnected;															
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
				  _L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
				  _L("RMobileCall::GetMobileStatus did not return a status EStatusConnected"));

	// ===  Check remote party info ===

	// Check RMobileCall::NotifyRemotePartyInfoChange completes with direction of EMobileOriginated
	RMobileCall::TMobileCallRemotePartyInfoV1 wanted;
	wanted.iDirection = RMobileCall::EMobileOriginated;
	TCmpRMobileCallTMobileCallRemotePartyInfo rpInfoComp(wanted, rpInfo, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyRemotePartyInfoChange( 
														call1,
														notifyRemotePartyInfoChangeStatus,
														rpInfoComp,
														wantedStatus);

	// post a notifier for RMobileCall::NotifyMobileCallCapsChange
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);

	// Post a notifier for RMobileCall::NotifyMobileCallStatusChange
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	// Post notifier for RMobileCall::NotifyCallEvent
	TExtEtelRequestStatus notifyCallEventStatus(call1, EMobileCallNotifyCallEvent);
	CleanupStack::PushL(notifyCallEventStatus);
	RMobileCall::TMobileCallEvent event;
	call1.NotifyCallEvent(notifyCallEventStatus, event);

	// Post notification RMobilePhone::NotifyDTMFCapsChange
	TExtEtelRequestStatus notifyDTMFCapsChangeStatus(mobilePhone, EMobilePhoneNotifyDTMFCapsChange);	
	CleanupStack::PushL(notifyDTMFCapsChangeStatus);
	TUint32 dTMFcaps;
	mobilePhone.NotifyDTMFCapsChange(notifyDTMFCapsChangeStatus, dTMFcaps);

	// Hold the call
	TExtEtelRequestStatus holdStatus(call1, EMobileCallHold);
	CleanupStack::PushL(holdStatus);
	call1.Hold(holdStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(holdStatus, ETimeMedium), KErrNone,  
				  _L("RMobileCall::Hold timed-out"));
	ASSERT_EQUALS(holdStatus.Int(), KErrNone,  
				  _L("RMobileCall::Hold did not set status to KErrNone"));

	// ===  Check call caps ===

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsResume | KCapsHangUp
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps NOT in set of KCapsOneToOne | KCapsHold
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of KCapsLocalResume | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	TUint32 wantedMobCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsResume | RMobileCall::KCapsHangUp;
	TUint32 unWantedMobCallControlCaps = RMobileCall::KCapsOneToOne | RMobileCall::KCapsHold;
	TUint32 wantedMobCallEventCaps = RMobileCall::KCapsLocalResume | RMobileCall::KCapsRemoteHold | RMobileCall::KCapsRemoteTerminate | RMobileCall::KCapsRemoteConferenceCreate;
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyMobileCallCapsChangeStatus, ETimeShort), KErrNone, 
				  _L("RMobileCall::NotifyMobileCallCapsChange timed out."));
	ASSERT_EQUALS(notifyMobileCallCapsChangeStatus.Int(), KErrNone,
				  _L("RMobileCall::NotifyMobileCallCapsChange returned with error status."));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobCallControlCaps, unWantedMobCallControlCaps,
					_L("RMobileCall::NotifyMobileCallCapsChange returned wrong control caps."));
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobCallEventCaps, KNoUnwantedBits,
					_L("RMobileCall::NotifyMobileCallCapsChange returned wrong event caps."));

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsResume | KCapsHangUp
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps NOT in set of KCapsOneToOne | KCapsHold
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of KCapsLocalResume | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,  
				  _L("RMobileCall::GetMobileCallCaps returned an error"));

	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | 
										RMobileCall::KCapsResume | 
										RMobileCall::KCapsHangUp;
	RMobileCall::TMobileCallCapsV1 unWantedMobileCaps;
	unWantedMobileCaps.iCallControlCaps = RMobileCall::KCapsOneToOne |
										  RMobileCall::KCapsHold;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, unWantedMobileCaps.iCallControlCaps,
					_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));
	
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalResume |
									  RMobileCall::KCapsRemoteHold | 
									  RMobileCall::KCapsRemoteTerminate | 
									  RMobileCall::KCapsRemoteConferenceCreate;
											 
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits,
				    _L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));


	// ===  Check call status ===

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusHold
	expectedMobileCallStatus = RMobileCall::EStatusHold;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusHold
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
				  _L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusHold,  
				  _L("RMobileCall::GetMobileStatus did not return a status EStatusHold"));

	// ===  Check call event completes ===

	// Check RMobileCall::NotifyCallEvent completes with ELocalHold
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent(
									call1,
									notifyCallEventStatus,
									event, 
									RMobileCall::ELocalHold,
									wantedStatus);

	// ===  Check DTMF caps ===

	// Check RMobilePhone::NotifyDTMFCapsChange completes with of 0
	iCallControlTestHelper.WaitForMobilePhoneNotifyDTMFCapsChange(
										mobilePhone,
									  	notifyDTMFCapsChangeStatus,
									  	dTMFcaps, 
									  	KNoWantedBits,
									  	KNoUnwantedBits,
									  	wantedStatus);

	// Check RMobilePhone::GetDTMFCaps returns 0
    TUint32 dtmfCaps2;
	ASSERT_EQUALS(mobilePhone.GetDTMFCaps(dtmfCaps2), KErrNone, _L("RMobilePhone::GetDTMFCaps returned with an error"));
	ASSERT_BITS_SET(dtmfCaps2, KNoWantedBits, KNoUnwantedBits, _L("RMobilePhone::GetDTMFCaps returned wrong dynamic caps"));

	// post a notifier for RMobileCall::NotifyMobileCallCapsChange
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);

	// Post a notifier for RMobileCall::NotifyMobileCallStatusChange
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// Post notifier for RMobileCall::NotifyCallEvent
	call1.NotifyCallEvent(notifyCallEventStatus, event);

	// Post notification RMobilePhone::NotifyDTMFCapsChange
	mobilePhone.NotifyDTMFCapsChange(notifyDTMFCapsChangeStatus, dTMFcaps);
	// Resume the call 
	TExtEtelRequestStatus resumeStatus(call1, EMobileCallResume);
	CleanupStack::PushL(resumeStatus);
	call1.Resume(resumeStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(resumeStatus, ETimeMedium), KErrNone,  
				  _L("RMobileCall::Resume timed-out"));
	ASSERT_EQUALS(resumeStatus.Int(), KErrNone,  
				  _L("RMobileCall::Resume did not set status to KErrNone"));

	// ===  Check call caps ===

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of KCapsLocalHold | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	wantedMobCallControlCaps =  RMobileCall::KCapsVoice |
								RMobileCall::KCapsHold |
								RMobileCall::KCapsHangUp;
	wantedMobCallEventCaps = RMobileCall::KCapsLocalHold |
							 RMobileCall::KCapsRemoteHold |
							 RMobileCall::KCapsRemoteTerminate |
							 RMobileCall::KCapsRemoteConferenceCreate;
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyMobileCallCapsChangeStatus, ETimeShort), KErrNone, 
				  _L("RMobileCall::NotifyMobileCallCapsChange timed out."));
	ASSERT_EQUALS(notifyMobileCallCapsChangeStatus.Int(), KErrNone,
				  _L("RMobileCall::NotifyMobileCallCapsChange returned with error status."));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobCallControlCaps, KNoUnwantedBits,
					_L("RMobileCall::NotifyMobileCallCapsChange returned wrong control caps."));
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobCallEventCaps, KNoUnwantedBits,
					_L("RMobileCall::NotifyMobileCallCapsChange returned wrong event caps."));

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of KCapsLocalHold | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,  
				  _L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | 
										RMobileCall::KCapsHold | 
										RMobileCall::KCapsHangUp;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, KNoUnwantedBits,
					_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));
	
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold |
									  RMobileCall::KCapsRemoteHold | 
									  RMobileCall::KCapsRemoteTerminate | 
									  RMobileCall::KCapsRemoteConferenceCreate;
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits,
				    _L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusConnected.
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
				  _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected,  
				  _L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusConnected.
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															RMobileCall::EStatusConnected,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
				  _L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
				  _L("RMobileCall::GetMobileStatus did not return a status EStatusConnected"));

	// ===  Check call event completes ===

	// Check RMobileCall::NotifyCallEvent completes with ELocalResume
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent(
									call1,
									notifyCallEventStatus,
									event, 
									RMobileCall::ELocalResume,
									wantedStatus);

	// ===  Check DTMF caps ===

    ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10024);
	// Check RMobilePhone::NotifyDTMFCapsChange completes with caps in set of KCapsSendDTMFString | KCapsSendDTMFSingleTone
	TUint32 wantedDtmfCaps = RMobilePhone::KCapsSendDTMFString | RMobilePhone::KCapsSendDTMFSingleTone;
	iCallControlTestHelper.WaitForMobilePhoneNotifyDTMFCapsChange(
										mobilePhone,
									  	notifyDTMFCapsChangeStatus,
									  	dTMFcaps, 
									  	wantedDtmfCaps,
									  	KNoUnwantedBits,
									  	wantedStatus);

	// Check RMobilePhone::GetDTMFCaps returns KCapsSendDTMFString | KCapsSendDTMFSingleTone
	ASSERT_EQUALS(mobilePhone.GetDTMFCaps(dtmfCaps2), KErrNone, _L("RMobilePhone::GetDTMFCaps returned with an error"));
	ASSERT_BITS_SET(dtmfCaps2, wantedDtmfCaps, KNoUnwantedBits, _L("RMobilePhone::GetDTMFCaps returned wrong dynamic caps"));


	// Post Notifier for RCall::NotifyCapsChange
	call1.NotifyCapsChange(notifyCapsChangeStatus, caps);

	// post a notifier for RMobileCall::NotifyMobileCallCapsChange
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);

	// Post notifier for RCall::NotifyStatusChange
	call1.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);

	// Post a notifier for RMobileCall::NotifyMobileCallStatusChange
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	// Post notification RMobilePhone::NotifyDTMFCapsChange
	mobilePhone.NotifyDTMFCapsChange(notifyDTMFCapsChangeStatus, dTMFcaps);

	// Hang up call
	ASSERT_EQUALS(call1.HangUp(), KErrNone, _L("RMobileCall::HangUp returned error."));

	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsDial.
	wantedCaps.iFlags = RCall::KCapsVoice | RCall::KCapsDial;
	unwantedCaps.iFlags = 0;
	iCallControlTestHelper.WaitForCallNotifyCapsChange(call1,
													   notifyCapsChangeStatus,
													   caps,
													   wantedCaps,
													   unwantedCaps,
													   wantedStatus);

	// Check RCall::GetCaps supports KCapsVoice | KCapsDial.
	ASSERT_EQUALS(call1.GetCaps(caps), KErrNone,   
				  _L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(caps.iFlags, RCall::KCapsVoice | RCall::KCapsDial, KNoUnwantedBits, 
					_L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsDial.
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
	wantedMobileCaps.iCallEventCaps = 0;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp2(wantedMobileCaps, mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp2,
																	   KErrNone);

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsDial.
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone,  
				  _L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsDial;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, KNoUnwantedBits,
					_L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle.
	expectedCallStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
														 
	call1.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);
	expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone,  
				  _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle,  
				  _L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle.
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															RMobileCall::EStatusDisconnecting,
															wantedStatus);
	
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															RMobileCall::EStatusIdle,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
				  _L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
				  _L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// ===  Check DTMF caps ===

	// Check RMobilePhone::NotifyDTMFCapsChange completes with caps equal to 0
	iCallControlTestHelper.WaitForMobilePhoneNotifyDTMFCapsChange(
										mobilePhone,
									  	notifyDTMFCapsChangeStatus,
									  	dTMFcaps, 
									  	KNoWantedBits,
									  	KNoUnwantedBits,
									  	wantedStatus);

	// Check RMobilePhone::GetDTMFCaps returns caps of 0
	ASSERT_EQUALS(mobilePhone.GetDTMFCaps(dtmfCaps2), KErrNone, _L("RMobilePhone::GetDTMFCaps returned with an error"));
	ASSERT_BITS_SET(dtmfCaps2, KNoWantedBits, KNoUnwantedBits, _L("RMobilePhone::GetDTMFCaps returned wrong dynamic caps"));

	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	CleanupStack::PopAndDestroy(10);
									// resumeStatus
									// holdStatus
									// notifyDTMFCapsChangeStatus
									// notifyCallEventStatus
									// dialStatus
									// notifyRemotePartyInfoChangeStatus
									// notifyMobileCallChangeStatus
									// notifyCallStatusChangeStatus
									// notifyMobileCallCapsChangeStatus
									// notifyCapsChangeStatus

	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0024::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0024");
	}



CCTSYIntegrationTestCallControl0025::CCTSYIntegrationTestCallControl0025(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0025::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0025::~CCTSYIntegrationTestCallControl0025()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0025::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0025
 * @SYMFssID BA/CTSY/CCON-0025
 * @SYMTestCaseDesc Swap between an active call and a held call
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallCapsChange, RMobileCall::GetMobileCallStatus, RMobileCall::NotifyCallEvent, RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyCapsChange, RMobileCall::NotifyRemotePartyInfoChange, RCall::GetStatus,RMobileCall::GetMobileCallCaps, RCall::Dial, RCall::HangUp, RCall::GetCallDuration, RMobileCall::Swap
 * @SYMTestExpectedResults Pass - Active call goes on hold and held call becomes active.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call status, call event, call caps, remote party info , call duration and DTMF caps correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////
	
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer, KMainPhone);
	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL		
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				 	_L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Get Voice line 1 
	RMobileLine& voiceLine1 = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);
	
	// Check phone supports KCapsVoice
	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine1.GetCaps(lineCaps), KErrNone, _L("RMobileLine::GetCaps returned with an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, 0, _L("RLine::GetCaps returned wrong caps"));
		
	// Get call 2 
	RMobileCall& call2 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall2);
	
	// Dial a number that answers on call 1 
	TPtrC number1; 
	CHECK_TRUE_L(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number1) != EFalse, _L("GetStringFromConfig did not complete as expected"));
	DEBUG_PRINTF1(_L("Board Now Dialling: "));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, number1); 
	CHECK_EQUALS_L(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	CHECK_EQUALS_L(dialStatus.Int(), KErrNone, _L("RCall::Dial returned with an error"));
	
	// Hold call 1 
	TExtEtelRequestStatus holdStatus(call1, EMobileCallHold);
	CleanupStack::PushL(holdStatus);
	call1.Hold(holdStatus);
	CHECK_EQUALS_L(WaitForRequestWithTimeOut(holdStatus, ETimeMedium),KErrNone, _L("RMobileCall::Hold timed out"));
	CHECK_EQUALS_L(holdStatus.Int(), KErrNone, _L("RMobileCall::Hold returned with an error"));		

	// Ensure RMobileCall::GetMobileCallStatus for call 1 is EStatusHold 
	RMobileCall::TMobileCallStatus status;
	CHECK_EQUALS_L(call1.GetMobileCallStatus(status), KErrNone, _L("RMobileCall::GetMobileCallStatus returned with an error"));
	CHECK_EQUALS_L(status, RMobileCall::EStatusHold, _L("RMobileCall::GetMobileCallStatus did not return EStatusHold as expected"));

    ////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// Post notifier for RCall::NotifyCapsChange
	RCall::TCaps callCaps;
	TCoreEtelRequestStatus<RCall> notifyCapsChangeStatus (call2,&RCall::NotifyCapsChangeCancel);	
	CleanupStack::PushL(notifyCapsChangeStatus);
	call2.NotifyCapsChange(notifyCapsChangeStatus,callCaps);
	
	// Post notifier for RMobileCall::NotifyMobileCallCapsChange
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg mobileCallCapsPckg(mobileCallCaps);
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus(call2, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus);
	call2.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus,mobileCallCapsPckg);
		
	// Post notifier for RCall::NotifyStatusChange
	RCall::TStatus callStatus;
	TCoreEtelRequestStatus<RCall> notifyStatusChangeStatus (call2,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	call2.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	
	// Post notifier for RMobileCall::NotifyMobileCallStatusChange
	RMobileCall::TMobileCallStatus mobileCallStatus2;
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus2(call2, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus2);
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus2);
	
	// Post notifier for RMobileCall::NotifyRemotePartyInfoChange
	RMobileCall:: TMobileCallRemotePartyInfoV1  rpInfo;
    RMobileCall:: TMobileCallRemotePartyInfoV1Pckg  rpInfoPkg(rpInfo);
   	TExtEtelRequestStatus notifyRemotePartyInfoChangeStatus(call2, EMobileCallNotifyRemotePartyInfoChange);
	CleanupStack::PushL(notifyRemotePartyInfoChangeStatus);
	call2.NotifyRemotePartyInfoChange(notifyRemotePartyInfoChangeStatus, rpInfoPkg);
	
	// Dial a number that answers on call 2 
	TPtrC number2; 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number2) != EFalse, _L("GetStringFromConfig did not complete as expected"));
	DEBUG_PRINTF1(_L("Board Now Dialling Call 2: "));
	TCoreEtelRequestStatus<RCall> dialStatus2(call2, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus2);
	call2.Dial(dialStatus2, number2); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus2, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus2.Int(), KErrNone, _L("RCall::Dial returned with an error"));

	// ===  Check call caps ===
	
	// Check RCall::NotifyCapsChange on call 2 completes with caps in set of KCapsVoice | KCapsHangUp.
	RCall::TCaps wantedCallCaps, unwantedCallCaps;
	wantedCallCaps.iFlags = RCall::KCapsVoice | RCall::KCapsHangUp; 
	unwantedCallCaps.iFlags = 0;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyCapsChange(call2, 
													   notifyCapsChangeStatus,
													   callCaps,
													   wantedCallCaps,
													   unwantedCallCaps,
													   wantedStatus);
	
	// Check RCall::GetCaps on call 2 supports KCapsHangUp | KCapsVoice.
	ASSERT_EQUALS(call2.GetCaps(callCaps), KErrNone, _L("RCall::GetCaps returned an error"));
	ASSERT_BITS_SET(callCaps.iFlags, wantedCallCaps.iFlags, KNoUnwantedBits, _L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::NotifyMobileCallCapsChange on call 2 completes with iCallControlCaps in set of KCapsVoice | KCapsSwap | KCapsHangUp | KCapsTransfer | KCapsJoin.
	// Check RMobileCall::NotifyMobileCallCapsChange on call 2 completes with iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	RMobileCall::TMobileCallCapsV1 wantedMobileCaps;
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice |
										RMobileCall::KCapsSwap  |
										RMobileCall::KCapsHangUp |
										RMobileCall::KCapsTransfer |
										RMobileCall::KCapsJoin;
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold |
									  RMobileCall::KCapsLocalTransfer |
									  RMobileCall::KCapsRemoteHold |
									  RMobileCall::KCapsRemoteTerminate |
									  RMobileCall::KCapsRemoteConferenceCreate;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps,mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call2, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);
	

	// Check RMobileCall::GetMobileCallCaps on call 2 includes iCallControlCaps in set of KCapsVoice | KCapsSwap | KCapsHangUp | KCapsTransfer | KCapsJoin.
	// Check RMobileCall::GetMobileCallCaps on call 2 includes iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	ASSERT_EQUALS(call2.GetMobileCallCaps(mobileCallCapsPckg), KErrNone, _L("RMobileCall::GetMobileCallCaps returned with an error"))
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | 
										RMobileCall::KCapsSwap  |
								    	RMobileCall::KCapsHangUp |
										RMobileCall::KCapsTransfer|
										RMobileCall::KCapsJoin;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps,KNoUnwantedBits,
											   _L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));
	
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | 
									  RMobileCall::KCapsLocalTransfer |
									  RMobileCall::KCapsRemoteHold | 
									  RMobileCall::KCapsRemoteTerminate | 
									  RMobileCall::KCapsRemoteConferenceCreate;
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps,KNoUnwantedBits,
											 _L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"))										   

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange on call 2 completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	
	call2.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
													 notifyStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);

	call2.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
													 notifyStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);	
															
	// Check RCall::GetStatus on call 2 returns EStatusConnected.
	ASSERT_EQUALS(call2.GetStatus(callStatus),KErrNone, _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected, _L("RCall::GetStatus returned an unexpected call status"));
	
	
	// Check RMobileCall::NotifyMobileCallStatusChange on call 2 completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
															notifyMobileCallStatusChangeStatus2,
															mobileCallStatus2,
															expectedMobileCallStatus,
															wantedStatus);
															
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus2);
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
															notifyMobileCallStatusChangeStatus2,
															mobileCallStatus2,
															expectedMobileCallStatus,
															wantedStatus);
															
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus2);
	expectedMobileCallStatus = RMobileCall::EStatusConnected;															
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
															notifyMobileCallStatusChangeStatus2,
															mobileCallStatus2,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus on call 2 returns status of EStatusConnected.
	ASSERT_EQUALS(call2.GetMobileCallStatus(mobileCallStatus2), KErrNone, _L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus2, RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileStatus did not return a status EStatusConnected"));
	
	// ===  Check remote party info ===

	// Check RMobileCall::NotifyRemotePartyInfoChange on call 2 completes with direction of EMobileOriginated
	TPtrC remoteNumber;
	RMobileCall:: TMobileCallRemotePartyInfoV1 wantedRpInfo;
	wantedRpInfo.iDirection= RMobileCall::EMobileOriginated ;
	TCmpRMobileCallTMobileCallRemotePartyInfo rpInfoComp(wantedRpInfo,rpInfo, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyRemotePartyInfoChange(call2,
																		notifyRemotePartyInfoChangeStatus,
																		rpInfoComp,
																		wantedStatus);

	// Post notifier for Call2 RMobileCall::NotifyMobileCallStatusChange
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus2);
	
	// Post notifier for Call1 RMobileCall::NotifyMobileCallStatusChange
	RMobileCall::TMobileCallStatus mobileCallStatus;
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	
	// Post notifier for event2 RMobileCall::NotifyCallEvent
	RMobileCall::TMobileCallEvent event2;
	TExtEtelRequestStatus notifyCallEventStatus2(call2, EMobileCallNotifyCallEvent);
	CleanupStack::PushL(notifyCallEventStatus2);
	call2.NotifyCallEvent(notifyCallEventStatus2,event2);
	
	// Post notifier for event1 RMobileCall::NotifyCallEvent
	RMobileCall::TMobileCallEvent event;
	TExtEtelRequestStatus notifyCallEventStatus(call1, EMobileCallNotifyCallEvent);
	CleanupStack::PushL(notifyCallEventStatus);
	call1.NotifyCallEvent(notifyCallEventStatus,event);

	// Swap call 2 
	TExtEtelRequestStatus swapStatus(call2, EMobileCallSwap);
	CleanupStack::PushL(swapStatus);
	call2.Swap(swapStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(swapStatus, ETimeMedium),KErrNone, _L("RMobileCall::Swap timed out"));
	ASSERT_EQUALS(swapStatus.Int(), KErrNone, _L("RMobileCall::Swap returned with an error"));		
	
	// ===  Check call status for calls 1 and 2 ===

	// Check RMobileCall::NotifyMobileCallStatusChange on call 2 completes with EStatusHold
	expectedMobileCallStatus = RMobileCall::EStatusHold;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
															notifyMobileCallStatusChangeStatus2,
															mobileCallStatus2,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus on call 2 returns status of EStatusHold
	ASSERT_EQUALS(call2.GetMobileCallStatus(mobileCallStatus2), KErrNone, _L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus2, RMobileCall::EStatusHold, _L("RMobileCall::GetMobileStatus did not return a status EStatusHold"));

	// Check RMobileCall::NotifyMobileCallStatusChange on call 1 completes with EStatusResume
	expectedMobileCallStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus on call 1 returns status of EStatusResume
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileStatus returned an error"))
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileStatus did not return a status EStatusResume"))
	
	// ===  Check call event completes ===

	// Check RMobileCall::NotifyCallEvent on call 2 completes with ELocalHold
	RMobileCall::TMobileCallEvent expectedEvent= RMobileCall::ELocalHold;
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent(call2,
										                   notifyCallEventStatus2,
														   event2, 
														   expectedEvent,
														   wantedStatus);

	// Check RMobileCall::NotifyCallEvent on call 1 completes with ELocalResume
	expectedEvent= RMobileCall::ELocalResume;
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent(call1,
										                   notifyCallEventStatus,
														   event, 
														   expectedEvent,
														   wantedStatus);
    // Pause so that the call durations have time to increase from 0
    User::After(KOneSecond*2);

    // Get call duration of call 1 
	TTimeIntervalSeconds duration1;
	ASSERT_EQUALS(call1.GetCallDuration(duration1), KErrNone, _L("RCall::GetCallDuration returned with an error"));

	// Get call duration of call 2 
	TTimeIntervalSeconds duration2;
	ASSERT_EQUALS(call2.GetCallDuration(duration2), KErrNone, _L("RCall::GetCallDuration returned with an error"));

	// Check call duration of call 1 > duration of call 2
	ASSERT_TRUE(duration1.Int()>duration2.Int(), _L("RCall::GetCallDuration duration of call1 is not greater than the duration of call2"));
	
	// Hang up call 1 
	ASSERT_EQUALS(call1.HangUp(), KErrNone,_L("RMobileCall::HangUp returned with an error"));

	// Hang up call 2 
	ASSERT_EQUALS(call2.HangUp(), KErrNone,_L("RMobileCall::HangUp returned with an error"));

	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
    // Pop:
    // dialStatus
    // holdStatus
    // notifyCapsChangeStatus
    // notifyMobileCallCapsChangeStatus
    // notifyStatusChangeStatus
    // notifyMobileCallStatusChangeStatus2
    // notifyRemotePartyInfoChangeStatus
    // dialStatus2
    // notifyMobileCallStatusChangeStatus
    // notifyCallEventStatus2
    // notifyCallEventStatus
    // swapStatus
	CleanupStack::PopAndDestroy(12, &dialStatus);
	
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0025::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0025");
	}



CCTSYIntegrationTestCallControl0026::CCTSYIntegrationTestCallControl0026(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0026::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0026::~CCTSYIntegrationTestCallControl0026()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0026::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0026
 * @SYMFssID BA/CTSY/CCON-0026
 * @SYMTestCaseDesc Swap between a held call and an ongoing call
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallCapsChange, RMobileCall::GetMobileCallStatus, RMobileCall::NotifyCallEvent, RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange,RCall::NotifyCapsChange, RMobileCall::NotifyRemotePartyInfoChange, RCall::GetStatus,RMobileCall::GetMobileCallCaps, RCall::Dial, RCall::HangUp, RCall::GetCallDuration, RMobileCall::Swap
 * @SYMTestExpectedResults Pass - Active call goes on hold and held call becomes active.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call status, call event, call caps, remote party info , call duration and DTMF caps correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer, KMainPhone);
	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL		
	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	// Get Voice line 1 
	RMobileLine& voiceLine1 = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);
	
	// Check phone supports KCapsVoice
	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine1.GetCaps(lineCaps) , KErrNone, _L("RMobileLine::GetCaps returned with an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, 0, _L("RLine::GetCaps returned wrong caps"));
		
	// Get Voice line 2 
	RMobileLine& voiceLine2 = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	
	// Get call 2 
	RMobileCall& call2 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall2);
	
	// Dial a number that answers on call 1 
	TPtrC number1; 
	CHECK_TRUE_L(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number1) != EFalse, _L("GetStringFromConfig did not complete as expected"));
	DEBUG_PRINTF1(_L("Board Now Dialling: "));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, number1); 
	CHECK_EQUALS_L(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	CHECK_EQUALS_L(dialStatus.Int(), KErrNone, _L("RCall::Dial returned with an error"));

	// Hold call 1 
	TExtEtelRequestStatus holdStatus(call1, EMobileCallHold);
	CleanupStack::PushL(holdStatus);
	call1.Hold(holdStatus);
	CHECK_EQUALS_L(WaitForRequestWithTimeOut(holdStatus, ETimeMedium),KErrNone, _L("RMobileCall::Hold timed out"));
	CHECK_EQUALS_L(holdStatus.Int(), KErrNone, _L("RMobileCall::Hold returned with an error"));		

	// Ensure RMobileCall::GetMobileCallStatus for call 1 is EStatusHold 
	RMobileCall::TMobileCallStatus status;
	CHECK_EQUALS_L(call1.GetMobileCallStatus(status), KErrNone, _L("RMobileCall::GetMobileCallStatus returned with an error"));
	CHECK_EQUALS_L(status, RMobileCall::EStatusHold, _L("RMobileCall::GetMobileCallStatus did not return EStatusHold as expected"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Post notifier for RCall::NotifyCapsChange
	RCall::TCaps callCaps;
	TCoreEtelRequestStatus<RCall> notifyCapsChangeStatus (call2,&RCall::NotifyCapsChangeCancel);	
	CleanupStack::PushL(notifyCapsChangeStatus);
	call2.NotifyCapsChange(notifyCapsChangeStatus,callCaps);
	
	// Post notifier for RMobileCall::NotifyMobileCallCapsChange
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg mobileCallCapsPckg(mobileCallCaps);
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus(call2, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus);
	call2.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus,mobileCallCapsPckg);
		
	// Post notifier for RCall::NotifyStatusChange
	RCall::TStatus callStatus;
	TCoreEtelRequestStatus<RCall> notifyStatusChangeStatus (call2,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	call2.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	
	// Post notifier for RMobileCall::NotifyMobileCallStatusChange
	RMobileCall::TMobileCallStatus mobileCallStatus2;
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus2(call2, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus2);
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus2);
	
	// Post notifier for RMobileCall::NotifyRemotePartyInfoChange
	RMobileCall:: TMobileCallRemotePartyInfoV1  rpInfo;
    RMobileCall:: TMobileCallRemotePartyInfoV1Pckg  rpInfoPkg(rpInfo);
   	TExtEtelRequestStatus notifyRemotePartyInfoChangeStatus(call2, EMobileCallNotifyRemotePartyInfoChange);
	CleanupStack::PushL(notifyRemotePartyInfoChangeStatus);
	call2.NotifyRemotePartyInfoChange(notifyRemotePartyInfoChangeStatus, rpInfoPkg);
	
	// Dial a number that answers on call 2 
	TPtrC number2; 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number2) != EFalse, _L("GetStringFromConfig did not complete as expected"));
	DEBUG_PRINTF1(_L("Board Now Dialling: "));
	TCoreEtelRequestStatus<RCall> dialStatus2(call2, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus2);
	call2.Dial(dialStatus2, number2); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus2, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus2.Int(), KErrNone, _L("RCall::Dial returned with an error"));

	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange on call 2 completes with caps in set of KCapsVoice | KCapsHangUp.
	RCall::TCaps wantedCallCaps, unwantedCallCaps;
	wantedCallCaps.iFlags = RCall::KCapsVoice | RCall::KCapsHangUp; 
	unwantedCallCaps.iFlags = 0;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyCapsChange(call2, 
													   notifyCapsChangeStatus,
													   callCaps,
													   wantedCallCaps,
													   unwantedCallCaps,
													   wantedStatus);
	
	// Check RCall::GetCaps on call 2 supports KCapsHangUp | KCapsVoice.
	ASSERT_EQUALS(call2.GetCaps(callCaps), KErrNone, _L("RCall::GetCaps returned an error"));
	ASSERT_BITS_SET(callCaps.iFlags, wantedCallCaps.iFlags, KNoUnwantedBits, _L("RCall::GetCaps returned wrong caps"))

	// Check RMobileCall::NotifyMobileCallCapsChange on call 2 completes with iCallControlCaps in set of KCapsVoice | KCapsSwap | KCapsHangUp | KCapsTransfer | KCapsJoin.
	// Check RMobileCall::NotifyMobileCallCapsChange on call 2 completes with iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	RMobileCall::TMobileCallCapsV1 wantedMobileCaps;
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice |
										RMobileCall::KCapsSwap  |
										RMobileCall::KCapsHangUp |
										RMobileCall::KCapsTransfer |
										RMobileCall::KCapsJoin;
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold |
									  RMobileCall::KCapsLocalTransfer |
									  RMobileCall::KCapsRemoteHold |
									  RMobileCall::KCapsRemoteTerminate |
									  RMobileCall::KCapsRemoteConferenceCreate;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps,mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call2, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);
	
	// Check RMobileCall::GetMobileCallCaps on call 2 includes iCallControlCaps in set of KCapsVoice | KCapsSwap | KCapsHangUp | KCapsTransfer | KCapsJoin.
	// Check RMobileCall::GetMobileCallCaps on call 2 includes iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	ASSERT_EQUALS(call2.GetMobileCallCaps(mobileCallCapsPckg), KErrNone, _L("RMobileCall::GetMobileCallCaps returned with an error"))
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | 
										RMobileCall::KCapsSwap  |
								    	RMobileCall::KCapsHangUp |
										RMobileCall::KCapsTransfer|
										RMobileCall::KCapsJoin;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps,KNoUnwantedBits,
											   _L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"))
	
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | 
									  RMobileCall::KCapsLocalTransfer |
									  RMobileCall::KCapsRemoteHold | 
									  RMobileCall::KCapsRemoteTerminate | 
									  RMobileCall::KCapsRemoteConferenceCreate;
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps,KNoUnwantedBits,
											 _L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"))										   



	// ===  Check call status ===
	
	// Check RCall::NotifyStatusChange on call 2 completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	
	call2.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
													 notifyStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);
	
	call2.NotifyStatusChange(notifyStatusChangeStatus,callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
													 notifyStatusChangeStatus,
													 callStatus,
													 expectedCallStatus,
													 wantedStatus);	
															
	// Check RCall::GetStatus on call 2 returns EStatusConnected.
	ASSERT_EQUALS(call2.GetStatus(callStatus),KErrNone, _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected, _L("RCall::GetStatus did not return RCall::EStatusConnected"));
	
	// Check RMobileCall::NotifyMobileCallStatusChange on call 2 completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
															notifyMobileCallStatusChangeStatus2,
															mobileCallStatus2,
															expectedMobileCallStatus,
															wantedStatus);
															
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus2);
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
															notifyMobileCallStatusChangeStatus2,
															mobileCallStatus2,
															expectedMobileCallStatus,
															wantedStatus);
															
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus2);
	expectedMobileCallStatus = RMobileCall::EStatusConnected;															
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
															notifyMobileCallStatusChangeStatus2,
															mobileCallStatus2,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus on call 2 returns status of EStatusConnected.
	ASSERT_EQUALS(call2.GetMobileCallStatus(mobileCallStatus2), KErrNone, _L("RMobileCall::GetMobileStatus returned an error"))
	ASSERT_EQUALS(mobileCallStatus2, RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileStatus did not return a status EStatusConnected"))
	
	// ===  Check remote party info ===

	// Check RMobilePhone::NotifyRemotePartyInfoChange on call 2 completes with direction of EMobileOriginated
    TPtrC remoteNumber;
	RMobileCall:: TMobileCallRemotePartyInfoV1 wantedRpInfo;
	wantedRpInfo.iDirection= RMobileCall::EMobileOriginated;
	TCmpRMobileCallTMobileCallRemotePartyInfo rpInfoComp(wantedRpInfo,rpInfo, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyRemotePartyInfoChange(call2,
																		notifyRemotePartyInfoChangeStatus,
																		rpInfoComp,
																		wantedStatus);

	// Post notifier for Call2 RMobileCall::NotifyMobileCallStatusChange
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus2);
	
	// Post notifier for Call1 RMobileCall::NotifyMobileCallStatusChange
	RMobileCall::TMobileCallStatus mobileCallStatus;
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	
	// Post notifier for event2 RMobileCall::NotifyCallEvent
	RMobileCall::TMobileCallEvent event2;
	TExtEtelRequestStatus notifyCallEventStatus2(call2, EMobileCallNotifyCallEvent);
	CleanupStack::PushL(notifyCallEventStatus2);
	call2.NotifyCallEvent(notifyCallEventStatus2,event2);
	
	// Post notifier for event1 RMobileCall::NotifyCallEvent
	RMobileCall::TMobileCallEvent event;
	TExtEtelRequestStatus notifyCallEventStatus(call1, EMobileCallNotifyCallEvent);
	CleanupStack::PushL(notifyCallEventStatus);
	call1.NotifyCallEvent(notifyCallEventStatus,event);
	
	// Swap call 1 
	TExtEtelRequestStatus swapStatus(call1, EMobileCallSwap);
	CleanupStack::PushL(swapStatus);
	call1.Swap(swapStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(swapStatus, ETimeMedium),KErrNone, _L("RMobileCall::Swap timed out"));
	ASSERT_EQUALS(swapStatus.Int(), KErrNone, _L("RMobileCall::Swap returned with an error"));		
	
	// ===  Check call status for calls 1 and 2 ===

	// Check RMobileCall::NotifyMobileCallStatusChange on call 2 completes with EStatusHold
	expectedMobileCallStatus = RMobileCall::EStatusHold;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
															notifyMobileCallStatusChangeStatus2,
															mobileCallStatus2,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus on call 2 returns status of EStatusHold
	ASSERT_EQUALS(call2.GetMobileCallStatus(mobileCallStatus2), KErrNone, _L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus2, RMobileCall::EStatusHold, _L("RMobileCall::GetMobileStatus did not return a status EStatusHold"));
	
	// Check RMobileCall::NotifyMobileCallStatusChange on call 1 completes with EStatusResume
	expectedMobileCallStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus on call 1 returns status of EStatusResume
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileStatus did not return a status EStatusResume"));
	
	// ===  Check call event completes ===

	// Check RMobileCall::NotifyCallEvent on call 2 completes with ELocalHold
	RMobileCall::TMobileCallEvent expectedEvent= RMobileCall::ELocalHold;
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent(call2,
										                   notifyCallEventStatus2,
														   event2, 
														   expectedEvent,
														   wantedStatus);
	
	// Check RMobileCall::NotifyCallEvent on call 1 completes with ELocalResume
	expectedEvent= RMobileCall::ELocalResume;
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent(call1,
										                   notifyCallEventStatus,
														   event, 
														   expectedEvent,
														   wantedStatus);

    // Wait so that call duration increases
    User::After(KOneSecond * 2);

	// Get call duration of call 1 
	TTimeIntervalSeconds duration1;
	ASSERT_EQUALS(call1.GetCallDuration(duration1), KErrNone, _L("RCall::GetCallDuration returned with an error"));

	// Get call duration of call 2 
	TTimeIntervalSeconds duration2;
	ASSERT_EQUALS(call2.GetCallDuration(duration2), KErrNone, _L("RCall::GetCallDuration returned with an error"));

	// Check call duration of call 1 > duration of call 2
	ASSERT_TRUE(duration1.Int()>duration2.Int(), _L("RCall::GetCallDuration duration of call1 is not greater than the duration of call2"));
	
	// Hang up call 1 
	ASSERT_EQUALS(call1.HangUp(), KErrNone,_L("RMobileCall::HangUp returned with an error"));
	
	// Hang up call 2 
	ASSERT_EQUALS(call2.HangUp(), KErrNone,_L("RMobileCall::HangUp returned with an error"));
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop:
    // dialStatus
    // holdStatus
    // notifyCapsChangeStatus
    // notifyMobileCallCapsChangeStatus
    // notifyStatusChangeStatus
    // notifyMobileCallStatusChangeStatus2
    // notifyRemotePartyInfoChangeStatus
    // dialStatus2
    // notifyMobileCallStatusChangeStatus
    // notifyCallEventStatus2
    // notifyCallEventStatus
    // swapStatus
	CleanupStack::PopAndDestroy(12, &dialStatus);
		
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0026::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0026");
	}



CCTSYIntegrationTestCallControl0027::CCTSYIntegrationTestCallControl0027(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0027::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0027::~CCTSYIntegrationTestCallControl0027()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0027::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0027
 * @SYMFssID BA/CTSY/CCON-0027
 * @SYMTestCaseDesc Hold an MO call then answer an MT call.
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallCapsChange,
 *                 RMobileCall::GetMobileCallStatus,
 *                 RMobileCall::NotifyCallEvent, RCall::GetInfo,
 *                 RCall::NotifyStatusChange,
 *                 RCall::NotifyCapsChange,
 *                 RMobilePhone::NotifyDTMFCapsChange,
 *                 RMobileCall::GetMobileCallCaps,
 *                 RLine::NotifyStatusChange,
 *                 RMobileCall::GetMobileCallInfo,
 *                 RMobileCall::NotifyMobileCallStatusChange,
 *                 RMobilePhone::GetDTMFCaps
 * @SYMTestExpectedResults Pass - Second call is answered without affecting held call.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/manual
 *
 * Reason for test: Verify call  status, call caps, line status are correct.
 *
 * @return - TVerdict code
 */
	{
	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////
	
	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	// Check phone supports KCapsVoice
	RMobilePhone& mobilePhone=iEtelSessionMgr.GetPhoneL(KMainServer, KMainPhone);	
	RMobilePhone::TCaps caps;
	CHECK_EQUALS_L(mobilePhone.GetCaps(caps), KErrNone, _L("RMobilePhone::GetCaps return value is not KErrNone"));
	TUint32 expectedServiceCaps=RMobilePhone::KCapsVoice;
	CHECK_BITS_SET_L(caps.iFlags, expectedServiceCaps, KNoUnwantedBits, _L("RMobilePhone::GetCaps returned wrong caps"));
		
	// Get Voice line 1 
	RMobileLine& mobileLine1=iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1 
	RMobileCall& mobileCall1=iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);	
	
	// Dial a number that answers on call 1	
	TPtrC number; 
	CHECK_TRUE_L(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse, _L("GetStringFromConfig did not complete as expected"));
	DEBUG_PRINTF2(_L("Board Now Dialling: %S"), &number);
	TCoreEtelRequestStatus<RMobileCall> dialStatus(mobileCall1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	mobileCall1.Dial(dialStatus, number); 
	CHECK_EQUALS_L(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	CHECK_EQUALS_L(dialStatus.Int(), KErrNone, _L("RCall::Dial problem dialling"));

	// Hold call 1
	TExtEtelRequestStatus holdStatus(mobileCall1, EMobileCallHold);
	CleanupStack::PushL(holdStatus);
	mobileCall1.Hold(holdStatus);
	CHECK_EQUALS_L(WaitForRequestWithTimeOut(holdStatus, ETimeMedium), KErrNone, _L("RMobileCall::Hold timed-out"));
	CHECK_EQUALS_L(holdStatus.Int(), KErrNone, _L("RMobileCall::Hold problem holding call"));

	// Ensure RMobileCall::GetMobileCallStatus for call 1 is EStatusHold 	
	RMobileCall::TMobileCallStatus getMobileCallStatus;
	CHECK_EQUALS_L(mobileCall1.GetMobileCallStatus(getMobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus return code is not KErrNone"));
	CHECK_EQUALS_L(getMobileCallStatus, RMobileCall::EStatusHold, _L("RMobileCall::GetMobileCallStatus getMobileCallStatus incorrect error"));
	
	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////

	// Post notifier for RLine::NotifyIncomingCall
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus (mobileLine1,&RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus);
	TName name;
	mobileLine1.NotifyIncomingCall(notifyIncomingCallStatus,name);
		
	// Request incoming call from RPS. 
	RPSRequestIncomingCallL(EVoiceLine);

	// Check RLine::NotifyIncomingCall completes with call name.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus,ETimeMedium),KErrNone, 
			_L("RLine::NotifyIncomingCall did not complete without error"));
	ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone,  
			_L("RLine::NotifyIncomingCall set requestStatus to an error"));
	ASSERT_TRUE(name.Length() > 0,  
			_L("RLine::NotifyIncomingCall did not set a line name"));

	// ===  Check call caps ===

	// Get the incoming call
    TCallId incomingCallId;
    RMobileCall& incomingCall = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, name, incomingCallId);

    // Post notification RMobileCall::NotifyCapsChange for call 2
	TCoreEtelRequestStatus<RMobileCall> notifyCapsChangeStatus2(incomingCall, &RMobileCall::NotifyCapsChangeCancel);
	CleanupStack::PushL(notifyCapsChangeStatus2);
	RMobileCall::TCaps notifyCapsChangeCaps2;
	incomingCall.NotifyCapsChange(notifyCapsChangeStatus2, notifyCapsChangeCaps2);

    // Post notification RMobileCall::NotifyMobileCallCapsChange for call 2
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus2(incomingCall, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus2);
	RMobileCall::TMobileCallCapsV1 pkgType2;
	RMobileCall::TMobileCallCapsV1Pckg pkgArg2(pkgType2);
	incomingCall.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus2, pkgArg2);

    // Post notification RMobileCall::NotifyStatusChange for call 2
	TCoreEtelRequestStatus<RMobileCall> notifyStatusChangeStatus2(incomingCall, &RMobileCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus2);
	RCall::TStatus callStatus2;
	incomingCall.NotifyStatusChange(notifyStatusChangeStatus2, callStatus2);

    // Post notification RMobileCall::NotifyMobileCallStatusChange for call 2
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus2(incomingCall, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus2);
	RMobileCall::TMobileCallStatus mobileCallState2;
	incomingCall.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallState2);

	// Answer incoming call on call 2.
	TCoreEtelRequestStatus<RCall> answerIncomingStatus(incomingCall, &RCall::AnswerIncomingCallCancel);
	CleanupStack::PushL(answerIncomingStatus);	
	incomingCall.AnswerIncomingCall(answerIncomingStatus);
    ASSERT_EQUALS(WaitForRequestWithTimeOut(answerIncomingStatus, ETimeLong), KErrNone, _L("RCall::AnswerIncomingCall timed out"));
    ASSERT_EQUALS(answerIncomingStatus.Int(), KErrNone, _L("RCall::AnswerIncomingCall returned an error"));

	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange on call 2 completes with caps in set of KCapsVoice | KCapsHangUp.
	// Check RCall::NotifyCapsChange on call 2 completes with caps NOT in set of KCapsAnswer | KCapsDial.	
    RCall::TCaps wantedCaps;
    RCall::TCaps unwantedCaps;
    wantedCaps.iFlags=RCall::KCapsVoice | RCall::KCapsHangUp;
	unwantedCaps.iFlags=RCall::KCapsAnswer | RCall::KCapsDial;
	iCallControlTestHelper.WaitForCallNotifyCapsChange(incomingCall,
													   notifyCapsChangeStatus2,
													   notifyCapsChangeCaps2,
													   wantedCaps,
													   unwantedCaps,
													   KErrNone);
	
	// Check RCall::GetCaps on call 2 supports caps in set of KCapsHangUp | KCapsVoice.	
	// Check RCall::GetCaps on call 2 supports caps NOT in set of KCapsAnswer | KCapsDial.
    RCall::TCaps getcaps;
	TUint32 expectedGetCaps=RCall::KCapsHangUp | RCall::KCapsVoice;
	TUint32 unexpectedGetCaps=RCall::KCapsAnswer | RCall::KCapsDial;
	ASSERT_EQUALS(incomingCall.GetCaps(getcaps), KErrNone, _L("RCall::GetCaps did not return KErrNone"));	
	ASSERT_BITS_SET(getcaps.iFlags, expectedGetCaps, unexpectedGetCaps, _L("RMobilePhone::GetCaps returned wrong caps"));

	// Check RMobileCall::NotifyMobileCallCapsChange on call 2 completes with iCallControlCaps in set of KCapsVoice | KCapsHangUp | KCapsJoin.
	// Check RMobileCall::NotifyMobileCallCapsChange on call 2 completes with iCallEventCaps in set of KCapsLocalHold | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
    RMobileCall::TMobileCallCapsV1 expected;
    expected.iCallControlCaps=RMobileCall::KCapsVoice | RMobileCall::KCapsHangUp | RMobileCall::KCapsJoin;
	expected.iCallEventCaps=RMobileCall::KCapsLocalHold | RMobileCall::KCapsRemoteHold | RMobileCall::KCapsRemoteTerminate | RMobileCall::KCapsRemoteConferenceCreate;
    TCmpRMobileCallTMobileCallCaps aMobileCallCapsV1Call2(expected, pkgType2, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(incomingCall,
																	   notifyMobileCallCapsChangeStatus2,
																	   aMobileCallCapsV1Call2,
																	   KErrNone);
																	   
	// Check RMobileCall::GetMobileCallCaps on call 2 includes iCallControlCaps in set of KCapsVoice | KCapsHangUp | KCapsJoin.
    RMobileCall::TMobileCallCapsV1 getMobileCallCapsPkgType;
	RMobileCall::TMobileCallCapsV1Pckg getMobileCallCapsPkgArg(getMobileCallCapsPkgType);
	ASSERT_EQUALS(incomingCall.GetMobileCallCaps(getMobileCallCapsPkgArg), KErrNone, _L("RMobileCall::GetMobileCallCaps return code is not KErrNone"));
	TUint32 expectedCallCaps=RMobileCall::KCapsVoice | RMobileCall::KCapsJoin | RMobileCall::KCapsHangUp;
	ASSERT_BITS_SET(getMobileCallCapsPkgType.iCallControlCaps, expectedCallCaps, KNoUnwantedBits, _L("RMobilePhone::GetMobileCallCaps returned wrong caps"));

	// Check RMobileCall::GetMobileCallCaps on call 2 includes iCallEventCaps in set of KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	expectedCallCaps=RMobileCall::KCapsRemoteHold | RMobileCall::KCapsRemoteTerminate | RMobileCall::KCapsRemoteConferenceCreate;
	ASSERT_BITS_SET(getMobileCallCapsPkgType.iCallEventCaps, expectedCallCaps, KNoUnwantedBits, _L("RMobilePhone::GetMobileCallCaps returned wrong caps"));
	
	// ===  Check call status ===

	// Check RCall::NotifyStatusChange on call 2 completes with EStatusAnswering -> EStatusConnected.
    RCall::TStatus expectedCallStatus;
	expectedCallStatus=RCall::EStatusAnswering;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(incomingCall,
														 notifyStatusChangeStatus2,
														 callStatus2,
														 expectedCallStatus,
														 KErrNone);
	
	incomingCall.NotifyStatusChange(notifyStatusChangeStatus2, callStatus2);
	
	expectedCallStatus=RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(incomingCall,
														 notifyStatusChangeStatus2,
														 callStatus2,
														 expectedCallStatus,
														 KErrNone);
														 
	incomingCall.NotifyStatusChange(notifyStatusChangeStatus2, callStatus2);
	
	// Check RCall::GetStatus on call 2 returns EStatusConnected.
    RCall::TStatus getStatus;
	ASSERT_EQUALS(incomingCall.GetStatus(getStatus), KErrNone, _L("RMobileCall::GetStatus return code is not KErrNone"));
	ASSERT_EQUALS(getStatus, RCall::EStatusConnected, _L("RMobileCall::GetStatus getStatus incorrect error"));
	
	// Check RMobileCall::NotifyMobileCallStatusChange on call 2 completes with EStatusAnswering -> EStatusConnected.
    RMobileCall::TMobileCallStatus expectedMobileCallState;
	expectedMobileCallState=RMobileCall::EStatusAnswering;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(incomingCall,
																		 notifyMobileCallStatusChangeStatus2,
																		 mobileCallState2,
																		 expectedMobileCallState,
																		 KErrNone);
	
	incomingCall.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallState2);
	
	expectedMobileCallState=RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(incomingCall,
																		 notifyMobileCallStatusChangeStatus2,
																		 mobileCallState2,
																		 expectedMobileCallState,
																		 KErrNone);
	
	// Check RMobileCall::GetMobileCallStatus on call 2 returns status of EStatusConnected.
	ASSERT_EQUALS(incomingCall.GetMobileCallStatus(getMobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus return code is not KErrNone"));
	ASSERT_EQUALS(getMobileCallStatus,RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileCallStatus getMobileCallStatus incorrect error"));

	// Check RMobileCall::GetMobileCallStatus on call 1 returns status of EStatusHold.
	ASSERT_EQUALS(mobileCall1.GetMobileCallStatus(getMobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus return code is not KErrNone"));
	ASSERT_EQUALS(getMobileCallStatus, RMobileCall::EStatusHold, _L("RMobileCall::GetMobileCallStatus getMobileCallStatus incorrect error"));
	
	// ===  Check call info ===

	// Check RCall::GetInfo on call 2 returns valid call name.
    User::After(KOneSecond*2); // So that the call duration is not 0, check later that it has a value > 0
    RCall::TCallInfo callInfo;
	ASSERT_EQUALS(incomingCall.GetInfo(callInfo), KErrNone, _L("RMobileCall::GetInfo return code is not KErrNone"));
	ASSERT_TRUE(callInfo.iCallName.Length()>0, _L("RMobileCall::GetInfo iCallName.Length() not greater than 0"));
	
	// Check RCall::GetInfo on call 2 returns valid voice line name.
	ASSERT_TRUE(callInfo.iLineName.Length()>0, _L("RMobileCall::GetInfo iLineName.Length() not greater than 0"));

	// Check RCall::GetInfo on call 2 returns call status of EStatusConnected.
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected, _L("RMobileCall::GetInfo iStatus incorrect error"));
	
	// Check RCall::GetInfo on call 2 returns call duration of > 0.
	TTimeIntervalSeconds time = 0;
	ASSERT_TRUE(callInfo.iDuration>time, _L("RMobileCall::GetInfo iDuration incorrect error"));

	// Check RMobileCall::GetMobileCallInfo on call 2 returns iValid > 0.
    RMobileCall::TMobileCallInfoV1 getMobileCallInfoPkgType;
	RMobileCall::TMobileCallInfoV1Pckg getMobileCallInfoPkgArg(getMobileCallInfoPkgType);
	ASSERT_EQUALS(incomingCall.GetMobileCallInfo(getMobileCallInfoPkgArg), KErrNone, _L("RMobileCall::GetMobileCallInfo return code is not KErrNone"));
	
	// Check RMobileCall::GetMobileCallInfo on call 2 returns data for attributes makred as valid in iValid.
	ASSERT_TRUE(getMobileCallInfoPkgType.iValid>0, _L("RMobileCall::GetMobileCallInfo iValid is not > 0"));
	
	// Check RMobileCall::GetMobileCallInfo on call 2 returns valid line name.
	ASSERT_TRUE(getMobileCallInfoPkgType.iLineName.Length()>0, _L("RMobileCall::GetMobileCallInfo iLineName.Length() is not > 0"));

	// Hang up call 2. 
	ASSERT_EQUALS(incomingCall.HangUp(), KErrNone, _L("RMobileCall::HangUp return code is not KErrNone"));

	// Post notification RMobileCall::NotifyStatusChange
	TCoreEtelRequestStatus<RMobileCall> notifyStatusChangeStatus(mobileCall1, &RMobileCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus callStatus;
	mobileCall1.NotifyStatusChange(notifyStatusChangeStatus, callStatus);

    // Post notification RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus(mobileCall1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallState;
	mobileCall1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallState);

	// Post notification RMobileCall::NotifyCallEvent	
	TExtEtelRequestStatus notifyCallEventStatus(mobileCall1, EMobileCallNotifyCallEvent);
	CleanupStack::PushL(notifyCallEventStatus);
	RMobileCall::TMobileCallEvent mobileCallEvent;
	mobileCall1.NotifyCallEvent(notifyCallEventStatus, mobileCallEvent);
	
	// Post notification RMobilePhone::NotifyDTMFCapsChange
	TExtEtelRequestStatus notifyDTMFCapsChangeStatus(mobilePhone, EMobilePhoneNotifyDTMFCapsChange);
	CleanupStack::PushL(notifyDTMFCapsChangeStatus);
	TUint32 notifyDTMFCapsChangeCaps;
	mobilePhone.NotifyDTMFCapsChange(notifyDTMFCapsChangeStatus, notifyDTMFCapsChangeCaps);
		
	// Resume call 1.
	TExtEtelRequestStatus resumeStatus(mobileCall1, EMobileCallResume);
	CleanupStack::PushL(resumeStatus);

	mobileCall1.Resume(resumeStatus);
	
	ASSERT_EQUALS(WaitForRequestWithTimeOut(resumeStatus, ETimeMedium), KErrNone, _L("RMobileCall::Resume timed-out"));
	ASSERT_EQUALS(resumeStatus.Int(), KErrNone, _L("RMobileCall::Resume resumeStatus completed with incorrect error"));

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange on call 1 completes with EStatusConnected.
	expectedCallStatus=RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(mobileCall1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 KErrNone);
	
	// Check RCall::GetStatus on call 1 returns EStatusConnected.
	ASSERT_EQUALS(mobileCall1.GetStatus(getStatus), KErrNone, _L("RMobileCall::GetStatus return code is not KErrNone"));
	ASSERT_EQUALS(getStatus, RCall::EStatusConnected, _L("RMobileCall::GetStatus getStatus incorrect error"));

	// Check RMobileCall::NotifyMobileCallStatusChange on call 1 completes with EStatusConnected.
	expectedMobileCallState=RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(mobileCall1,
																		 notifyMobileCallStatusChangeStatus,
																		 mobileCallState,
																		 expectedMobileCallState,
																		 KErrNone);
	
	// Check RMobileCall::GetMobileCallStatus on call 1 returns status of EStatusConnected.
	ASSERT_EQUALS(mobileCall1.GetMobileCallStatus(getMobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus return code is not KErrNone"));
	ASSERT_EQUALS(getMobileCallStatus, RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileCallStatus getMobileCallStatus incorrect error"));

	// ===  Check call event and DTMF caps ===

	// Check RMobileCall::NotifyCallEvent on call 1 completes with ELocalResume
	RMobileCall::TMobileCallEvent expectedMobileCallEvent=RMobileCall::ELocalResume;
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent(mobileCall1,
															notifyCallEventStatus,
															mobileCallEvent,
															expectedMobileCallEvent,
															KErrNone);

	// Check RMobilePhone::NotifyDTMFCapsChange on call 1 completes with caps in set of KCapsSendDTMFString | KCapsSendDTMFSingleTone
	TUint32 notifyDTMFCapsChangeWantedCaps=RMobilePhone::KCapsSendDTMFString | RMobilePhone::KCapsSendDTMFSingleTone;
	iCallControlTestHelper.WaitForMobilePhoneNotifyDTMFCapsChange(mobilePhone,
																  notifyDTMFCapsChangeStatus,
																  notifyDTMFCapsChangeCaps,
																  notifyDTMFCapsChangeWantedCaps,
																  KNoUnwantedBits,
																  KErrNone);
																  
	// Check RMobilePhone::GetDTMFCaps on call 1 returns caps in set of KCapsSendDTMFString | KCapsSendDTMFSingleTone
	TUint32 getDTMFCaps;
	ASSERT_EQUALS(mobilePhone.GetDTMFCaps(getDTMFCaps), KErrNone, _L("RMobilePhone::GetDTMFCaps return code is not KErrNone"));
	ASSERT_BITS_SET(getDTMFCaps, notifyDTMFCapsChangeWantedCaps, KNoUnwantedBits, _L("RMobilePhone::GetDTMFCaps returned wrong caps"));

	// Hang up call 1
	ASSERT_EQUALS(mobileCall1.HangUp(), KErrNone, _L("RMobileCall::HangUp return code is not KErrNone"));
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();

    //     dialStatus
    //     holdStatus
    //     notifyIncomingCallStatus
    //     notifyCapsChangeStatus2
    //     notifyMobileCallCapsChangeStatus2
    //     notifyStatusChangeStatus2
    //     notifyMobileCallStatusChangeStatus2
    //     answerIncomingStatus
    //     notifyStatusChangeStatus
    //     notifyMobileCallStatusChangeStatus
    //     notifyCallEventStatus
    //     notifyDTMFCapsChangeStatus
    //     resumeStatus
	CleanupStack::PopAndDestroy(13, &dialStatus);

	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0027::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0027");
	}



CCTSYIntegrationTestCallControl0028::CCTSYIntegrationTestCallControl0028(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0028::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0028::~CCTSYIntegrationTestCallControl0028()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0028::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0028
 * @SYMFssID BA/CTSY/CCON-0028
 * @SYMTestCaseDesc Hold call which remote party then hangs up.
 * @SYMTestPriority High
 * @SYMTestActions RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange, RLine::NotifyStatusChange, RMobileLine::GetMobileLineStatus, RMobileLine::NotifyMobileLineStatusChange, RLine::GetStatus, RMobileCall::GetMobileCallStatus, RMobileCall::NotifyCallEvent, RCall::GetStatus
 * @SYMTestExpectedResults Pass - Calls can be held and resumed.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call and line status are correct and call event completes.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////


	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer, KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	// Check phone supports KCapsVoice.
	RMobilePhone::TCaps caps;
	CHECK_EQUALS_L(phone.GetCaps(caps), KErrNone, _L("RMobilePhone::GetCaps returned with an error."));
	CHECK_BITS_SET_L(caps.iFlags, RMobilePhone::KCapsVoice, KNoUnwantedBits, _L("RMobilePhone::GetCaps returned wrong caps."));

	// Get Voice line 1. 
	RMobileLine& mobileLine1=iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1.
	RMobileCall& mobileCall1=iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);	

	// Dial RPS which answers.  
	TCoreEtelRequestStatus<RMobileCall> dialStatus(mobileCall1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);											 
	TPtrC rpsNumber;
	GetRPSNumber(EVoiceLine, rpsNumber); 
	CHECK_EQUALS_L(RPSAnswerNextCallL(EVoiceLine), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSAnswerNextCallL returned with an error"));
	mobileCall1.Dial(dialStatus, rpsNumber);
	CHECK_EQUALS_L(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	CHECK_EQUALS_L(dialStatus.Int(), KErrNone, _L("RCall::Dial returned an error"));


	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////


	// Post notifier for RMobileCall::NotifyCallEvent
	TExtEtelRequestStatus notifyCallEventStatus(mobileCall1, EMobileCallNotifyCallEvent);
	CleanupStack::PushL(notifyCallEventStatus);
	RMobileCall::TMobileCallEvent mobileCallEvent;
	mobileCall1.NotifyCallEvent(notifyCallEventStatus, mobileCallEvent);
	
	// Post notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus(mobileCall1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	mobileCall1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	
	// Hold call 1. 
	TExtEtelRequestStatus holdStatus(mobileCall1, EMobileCallHold);
	CleanupStack::PushL(holdStatus);
	mobileCall1.Hold(holdStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(holdStatus, ETimeMedium),KErrNone, _L("RMobileCall::Hold timed out"));
	ASSERT_EQUALS(holdStatus.Int(), KErrNone, _L("RMobileCall::Hold returned with an error"));		

	// Check RMobileCall::NotifyCallEvent completes with ELocalHold
	TInt wantedStatus = KErrNone;
	RMobileCall::TMobileCallEvent expectedMobileCallEvent = RMobileCall::ELocalHold;
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent( 
									mobileCall1,
									notifyCallEventStatus,
									mobileCallEvent, 
									expectedMobileCallEvent,
									wantedStatus);

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusHold
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusHold;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(mobileCall1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	// Check RMobileCall::GetMobileCallStatus completes with EStatusHold
	ASSERT_EQUALS(mobileCall1.GetMobileCallStatus(mobileCallStatus), KErrNone,  _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusHold,  _L("RMobileCall::GetMobileCallStatus did not return EStatusHold as expected"));

	// Post notifier for RCall::NotifyStatusChange
	RCall::TStatus callStatus;
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus(mobileCall1, &RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	mobileCall1.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);	

	// Post notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus(mobileLine1, &RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus lineStatus; 
	mobileLine1.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);

    // Post notifier for RLine::NotifyMobileLineStatusChange
	TExtEtelRequestStatus notifyMobileLineChangeStatus(mobileLine1, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	RMobileCall::TMobileCallStatus mobileLineStatus;
	mobileLine1.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);

    // repost notifier for RMobileCall::NotifyCallEvent
	mobileCall1.NotifyCallEvent(notifyCallEventStatus, mobileCallEvent);

    // repost a notifier for RMobileCall::NotifyMobileCallStatusChange
	mobileCall1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);

	// RPS hangs up the call. 
	ASSERT_EQUALS(RPSHangupL(EVoiceLine, ETimeShort), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSHangup returned an error"));

	// Check RMobileCall::NotifyCallEvent completes with ERemoteTerminated
	expectedMobileCallEvent = RMobileCall::ERemoteTerminated;
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent( 
									mobileCall1,
									notifyCallEventStatus,
									mobileCallEvent, 
									expectedMobileCallEvent,
									wantedStatus);

	// Check RCall::NotifyStatusChange completes with EStatusIdle.
	RCall::TStatus expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(mobileCall1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(mobileCall1.GetStatus(callStatus),KErrNone, _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle, 	_L("RCall::GetStatus did not return EStatusIdle as expected"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusIdle
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(mobileCall1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus completes with EStatusIdle
	ASSERT_EQUALS(mobileCall1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle, _L("RMobileCall::GetMobileStatus did not return EStatusIdle as expected"));

	// Check RLine::NotifyStatusChange completes with EStatusIdle
	RCall::TStatus expectedLineStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(mobileLine1,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 wantedStatus);

	// Check RLine::GetStatus returns EStatusIdle
	ASSERT_EQUALS(mobileLine1.GetStatus(callStatus), KErrNone, _L("RLine::GetStatus returned with an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle, _L("RLine::GetStatus did not return EStatusIdle as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with EStatusIdle;
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(mobileLine1,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		wantedStatus);

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle
	ASSERT_EQUALS(mobileLine1.GetMobileLineStatus(mobileLineStatus), KErrNone, _L("RMobileLine::GetMobileLineStatus returned with an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusIdle, _L("RMobileLine::GetMobileLineStatus did not return EStatusIdle as expected"));


	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
    // dialStatus
    // notifyCallEventStatus
    // notifyMobileCallStatusChangeStatus
    // holdStatus
    // notifyCallStatusChangeStatus
    // notifyStatusChangeStatus
    // notifyMobileLineChangeStatus
	CleanupStack::PopAndDestroy(7, &dialStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0028::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0028");
	}



CCTSYIntegrationTestCallControl0029::CCTSYIntegrationTestCallControl0029(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0029::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0029::~CCTSYIntegrationTestCallControl0029()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0029::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0029
 * @SYMFssID BA/CTSY/CCON-0029
 * @SYMTestCaseDesc Resume held call but remote party hangs up before resume complete.
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallStatusChange, RLine::NotifyStatusChange, RMobileLine::GetMobileLineStatus, RMobileLine::NotifyMobileLineStatusChange, RLine::GetStatus, RMobileCall::GetMobileCallStatus, RMobileCall::NotifyCallEvent, RCall::GetStatus, RMobileCall::Hold, RMobileCall::Resume
 * @SYMTestExpectedResults Pass - Call ends when remote party hangs up.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/manual
 *
 * Reason for test: Verify call and line status are correct and call event completes.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	// Check phone supports KCapsVoice.
	RMobilePhone::TCaps caps;
	CHECK_EQUALS_L(phone.GetCaps(caps), KErrNone, _L("RMobilePhone::GetCaps return value is not KErrNone"));
	CHECK_BITS_SET_L(caps.iFlags, RMobilePhone::KCapsVoice, KNoUnwantedBits, _L("RMobilePhone::GetCaps returned wrong caps"));

	// Get Voice line 1. 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	
	// Get call 1. 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// Dial a number. Tester should answer the call. 
	TPtrC number; 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,
				_L("GetStringFromConfig did not complete as expected"));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	DEBUG_PRINTF1(_L("Board Now Dialling..."));
	call1.Dial(dialStatus, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone, _L("RCall::Dial returned with an error"));
			
 	// Post notifier for RMobileCall::NotifyCallEvent
	TExtEtelRequestStatus notifyCallEventStatus(call1, EMobileCallNotifyCallEvent);
	CleanupStack::PushL(notifyCallEventStatus);
	RMobileCall::TMobileCallEvent mobileCallEvent;
	call1.NotifyCallEvent(notifyCallEventStatus, mobileCallEvent);
	
	// post a notifier for RMobileCall::NotifyMobileCallStatusChange
	RMobileCall::TMobileCallStatus mobileCallStatus;
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	// Hold call 1
	TExtEtelRequestStatus holdStatus (call1,EMobileCallHold);
	CleanupStack::PushL(holdStatus);	
	call1.Hold(holdStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(holdStatus, ETimeMedium), KErrNone, _L("RMobileCall::Hold timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone, _L("RMobileCall::Hold returned an error"));
	
	// Check RMobileCall::NotifyCallEvent completes with ELocalHold
	RMobileCall::TMobileCallEvent expectedMobileCallEvent = RMobileCall::ELocalHold;
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent(
									call1,
									notifyCallEventStatus,
									mobileCallEvent, 
									expectedMobileCallEvent,
									KErrNone);

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusHold
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusHold;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(
															call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															KErrNone);

	// Check RMobileCall::GetMobileCallStatus completes with EStatusHold
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusHold, _L("RMobileCall::GetMobileCallStatus did not return EStatusHold"));
			
	// post notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine,&RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus lineStatus;
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	
	// post a notifier for RMobileLine::NotifyMobileLineStatusChange
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	RMobileCall::TMobileCallStatus mobileLineStatus;
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);

	// post notifier for RCall::NotifyStatusChange
	RCall::TStatus callStatus;
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	call1.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);

    // repost notifier for RMobileCall::NotifyCallEvent
   	call1.NotifyCallEvent(notifyCallEventStatus, mobileCallEvent);

    // repost a notifier for RMobileCall::NotifyMobileCallStatusChange
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

	// Resume call 1. Tester should hang up the call before Resume completes. 
	DisplayUserInteractionPromptL(_L("Remote party should hang up the call now."), ETimeLong);
	TExtEtelRequestStatus resumeStatus(call1, EMobileCallResume);
	CleanupStack::PushL(resumeStatus);
	call1.Resume(resumeStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(resumeStatus, ETimeMedium), KErrNone, _L("RMobileCall::Resume timed-out"));
	ASSERT_TRUE(resumeStatus.Int() != KErrNone, _L("RMobileCall::Resume did not return error code as expected."));

	// Check RMobileCall::NotifyCallEvent completes with ERemoteTerminated
	expectedMobileCallEvent = RMobileCall::ERemoteTerminated;
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent( 
									call1,
									notifyCallEventStatus,
									mobileCallEvent, 
									expectedMobileCallEvent,
									KErrNone);

	// Check RCall::NotifyStatusChange completes with EStatusIdle.
	RCall::TStatus expectedCallStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 KErrNone);

	// Check RCall::GetStatus returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone, _L("RCall::GetStatus returned an Error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle, _L("RCall::GetStatus did not return EStatusIdle"));
			
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusIdle
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		KErrNone);

	// Check RMobileCall::GetMobileCallStatus completes with EStatusIdle
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle, _L("RMobileCall::GetMobileCallStatus did not return EStatusIdle"));

	// Check RLine::NotifyStatusChange completes with EStatusIdle
	RCall::TStatus expectedLineStatus = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 KErrNone);

	// Check RLine::GetStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone, _L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle, _L("RLine::GetStatus did not return EStatusConnected as expected"));
			
	// Check RMobileLine::NotifyMobileLineStatusChange completes with EStatusIdle
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		KErrNone);

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone, _L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusIdle, _L("RMobileLine::GetMobileLineStatus did not set line status to EStatusIdle"));
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// dialStatus
	// notifyCallEventStatus
	// notifyCallStatusChangeStatus
	// notifyMobileCallChangeStatus
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus
	// holdStatus
	// resumeStatus
	CleanupStack::PopAndDestroy(8, &dialStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0029::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0029");
	}



CCTSYIntegrationTestCallControl0030::CCTSYIntegrationTestCallControl0030(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0030::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0030::~CCTSYIntegrationTestCallControl0030()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0030::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0030
 * @SYMFssID BA/CTSY/CCON-0030
 * @SYMTestCaseDesc Hold a call then make and hang up another call.
 * @SYMTestPriority High
 * @SYMTestActions RCall::NotifyStatusChange, RMobileCall::GetMobileCallStatus, RMobileCall::NotifyCallEvent, RCall::GetStatus, RCall::Dial, RCall::HangUp, RMobileCall::Resume
 * @SYMTestExpectedResults Pass - Call 1 resumed successfully.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call status and call event is correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////


	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Check phone supports KCapsVoice.
	RMobilePhone::TCaps caps;
	CHECK_EQUALS_L(phone.GetCaps(caps), KErrNone, _L("RMobilePhone::GetCaps return value is not KErrNone"));
	CHECK_BITS_SET_L(caps.iFlags, RMobilePhone::KCapsVoice, KNoUnwantedBits, _L("RMobilePhone::GetCaps returned wrong caps"));

	// Get Voice line 1. 
	RMobileLine& voiceLine=iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	
	// Get call 1. 
	RMobileCall& call1=iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);	
	
	// Dial a number that answers on call 1. 
	TPtrC number; 
	CHECK_TRUE_L(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse, _L("GetStringFromConfig did not complete as expected"));
	DEBUG_PRINTF1(_L("Board Now Dialling: "));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, number); 
	CHECK_EQUALS_L(WaitForRequestWithTimeOut(dialStatus, ETimeLong), KErrNone, _L("RCall::Dial timed-out"));
	CHECK_EQUALS_L(dialStatus.Int(), KErrNone, _L("RCall::Dial returned with an error"));

	// Hold call 1. 
	TExtEtelRequestStatus holdStatus(call1, EMobileCallHold);
	CleanupStack::PushL(holdStatus);
	call1.Hold(holdStatus);
	CHECK_EQUALS_L(WaitForRequestWithTimeOut(holdStatus, ETimeMedium),KErrNone, _L("RMobileCall::Hold timed out"));
	CHECK_EQUALS_L(holdStatus.Int(), KErrNone, _L("RMobileCall::Hold returned with an error"));		

	// Get call 2. 
	RMobileCall& call2 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall2);


	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////


	// Post notifier for RCall::NotifyStatusChange for call 2
	RCall::TStatus callStatus2;
	TCoreEtelRequestStatus<RCall> notifyStatusChangeStatus2(call2, &RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus2);
	call2.NotifyStatusChange(notifyStatusChangeStatus2, callStatus2);	
	
	// Post notification RMobileCall::NotifyMobileCallStatusChange for call 2
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus2(call2, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus2);
	RMobileCall::TMobileCallStatus mobileCallStatus2;
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus2);
	
	// Dial a RPS on call 2. 
	TCoreEtelRequestStatus<RMobileCall> dialStatus2(call2, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus2);											 
	TPtrC rpsNumber;
	GetRPSNumber(EVoiceLine, rpsNumber); 
	ASSERT_EQUALS(RPSAnswerNextCallL(EVoiceLine), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSAnswerNextCallL"));
	call2.Dial(dialStatus2, rpsNumber);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus2, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus2.Int(), KErrNone, _L("RCall::Dial returned an error"));
	
	// ===  Check call status ===

	// Check RCall::NotifyStatusChange for call 2 completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	const TInt wantedStatus = KErrNone;
	RCall::TStatus expectedCallStatus2 = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
														 notifyStatusChangeStatus2,
														 callStatus2,
														 expectedCallStatus2,
														 wantedStatus);
														 
	call2.NotifyStatusChange(notifyStatusChangeStatus2, callStatus2);													 
	expectedCallStatus2 = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
														 notifyStatusChangeStatus2,
														 callStatus2,
														 expectedCallStatus2,
														 wantedStatus);

	call2.NotifyStatusChange(notifyStatusChangeStatus2, callStatus2);
	expectedCallStatus2 = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
														 notifyStatusChangeStatus2,
														 callStatus2,
														 expectedCallStatus2,
														 wantedStatus);

	// Check RCall::GetStatus for call 2 returns EStatusConnected.
	ASSERT_EQUALS(call2.GetStatus(callStatus2), KErrNone, _L("RCall::GetStatus returned an Error"));
	ASSERT_EQUALS(callStatus2, RCall::EStatusConnected, _L("RCall::GetStatus did not return EStatusConnected"));

	// Check RMobileCall::NotifyMobileCallStatusChange for call 2 completes with EStatusDialling->EStatusConnecting->EStatusConnected
	RMobileCall::TMobileCallStatus expectedMobileCallStatus2 = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
																		notifyMobileCallStatusChangeStatus2,
																		mobileCallStatus2,
																		expectedMobileCallStatus2,
																		wantedStatus);

	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus2);
	expectedMobileCallStatus2 = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
																		notifyMobileCallStatusChangeStatus2,
																		mobileCallStatus2,
																		expectedMobileCallStatus2,
																		wantedStatus);

	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus2);
	expectedMobileCallStatus2 = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
																		notifyMobileCallStatusChangeStatus2,
																		mobileCallStatus2,
																		expectedMobileCallStatus2,
																		wantedStatus);

	// Check RMobileCall::GetMobileCallStatus for call 2 returns EStatusConnected
	ASSERT_EQUALS(call2.GetMobileCallStatus(mobileCallStatus2), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus2, RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileCallStatus did not return a status EStatusConnected"));

	// Post notifier for RMobileCall::NotifyCallEvent for call 2
	TExtEtelRequestStatus notifyCallEventStatus2(call2, EMobileCallNotifyCallEvent);
	CleanupStack::PushL(notifyCallEventStatus2);
	RMobileCall::TMobileCallEvent mobileCallEvent2;
	call2.NotifyCallEvent(notifyCallEventStatus2, mobileCallEvent2);

	// RPS hangs up call 2. 
	ASSERT_EQUALS(RPSHangupL(EVoiceLine,0), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSHangup returned an error"));

	// Check RMobileCall::NotifyCallEvent for call 2 completes with ERemoteTerminated
	RMobileCall::TMobileCallEvent expectedMobileCallEvent2 = RMobileCall::ERemoteTerminated;
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent( 
									call2,
									notifyCallEventStatus2,
									mobileCallEvent2, 
									expectedMobileCallEvent2,
									wantedStatus);

	// ===  Check call statuses ===

	// Check RCall::NotifyStatusChange for call 2 completes with EStatusIdle
	expectedCallStatus2 = RCall::EStatusIdle;
	call2.NotifyStatusChange(notifyStatusChangeStatus2, callStatus2);
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
														 notifyStatusChangeStatus2,
														 callStatus2,
														 expectedCallStatus2,
														 wantedStatus);

	// Check RCall::GetStatus for call 2 returns EStatusIdle
	ASSERT_EQUALS(call2.GetStatus(callStatus2), KErrNone, _L("RCall::GetStatus returned an Error"));
	ASSERT_EQUALS(callStatus2, RCall::EStatusIdle, _L("RCall::GetStatus did not return EStatusIdle"));

	// Check RMobileCall::NotifyMobileCallStatusChange for call 2 completes with EStatusIdle
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus2);
	expectedMobileCallStatus2 = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
																		notifyMobileCallStatusChangeStatus2,
																		mobileCallStatus2,
																		expectedMobileCallStatus2,
																		wantedStatus);

	// Check RMobileCall::GetMobileCallStatus for call 2 returns EStatusIdle
	ASSERT_EQUALS(call2.GetMobileCallStatus(mobileCallStatus2), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus2, RMobileCall::EStatusIdle, _L("RMobileCall::GetMobileCallStatus did not return a status EStatusIdle"));

	
	// Check RMobileCall::GetMobileCallStatus for call 1 returns EStatusHold
	RMobileCall::TMobileCallStatus mobileCallStatus;
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusHold, _L("RMobileCall::GetMobileCallStatus did not return a status EStatusHold"));

	// Post notifier for RMobileCall::NotifyCallEvent for call 1
	TExtEtelRequestStatus notifyCallEventStatus(call1, EMobileCallNotifyCallEvent);
	CleanupStack::PushL(notifyCallEventStatus);
	RMobileCall::TMobileCallEvent mobileCallEvent;
	call1.NotifyCallEvent(notifyCallEventStatus, mobileCallEvent);


	// Post notification RMobileCall::NotifyMobileCallStatusChange for call 1
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);

	// Resume call 1. 
	TExtEtelRequestStatus resumeStatus(call1, EMobileCallResume);
	CleanupStack::PushL(resumeStatus);
	call1.Resume(resumeStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(resumeStatus, ETimeMedium), KErrNone, _L("RMobileCall::Resume timed-out"));
	ASSERT_EQUALS(resumeStatus.Int(), KErrNone, _L("RMobileCall::Resume returned an error"));
	
	// Check RCall::NotifyCallEvent for call 1 completes with ELocalResume
	RMobileCall::TMobileCallEvent expectedMobileCallEvent = RMobileCall::ELocalResume;
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent( 
									call1,
									notifyCallEventStatus,
									mobileCallEvent, 
									expectedMobileCallEvent,
									wantedStatus);
	// ===  Check call status ===

	// Check RMobileCall::NotifyMobileCallStatusChange for call 1 completes with EStatusConnected
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		notifyMobileCallStatusChangeStatus,
																		mobileCallStatus,
																		expectedMobileCallStatus,
																		wantedStatus);

	// Check RMobileCall::GetMobileCallStatus for call 1 returns EStatusConnected
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileCallStatus did not return a status EStatusConnected"));

	// Hangup call 1.
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone, _L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone, _L("RCall::HangUp returned an error"));


	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
	// dialStatus
  	// holdStatus
  	// notifyStatusChangeStatus2
  	// notifyMobileCallStatusChangeStatus2
  	// dialStatus2
  	// notifyCallEventStatus2
   	// notifyCallEventStatus
 	// notifyMobileCallStatusChangeStatus
  	// resumeStatus
  	// hangUpStatus
  	CleanupStack::PopAndDestroy(10, &dialStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0030::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0030");
	}



CCTSYIntegrationTestCallControl0031::CCTSYIntegrationTestCallControl0031(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0031::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0031::~CCTSYIntegrationTestCallControl0031()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0031::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0031
 * @SYMFssID BA/CTSY/CCON-0031
 * @SYMTestCaseDesc Attempt to hold a call when there is already one on hold.
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallCapsChange, RMobileCall::GetMobileCallStatus, RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyCapsChange, RCall::GetStatus, RMobileCall::GetMobileCallCaps, RCall::Dial, RMobileCall::Hold
 * @SYMTestExpectedResults Pass - Error returned on attempt to hold a second call.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify error is returned on attempt to hold and call stays connected.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits,  _L("RPhone::GetCaps returned wrong caps"));

	// Get Voice line 1. 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// Dial a number that answers on call 1. 
	TPtrC number; 
	CHECK_TRUE_L(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse, _L("GetStringFromConfig did not complete as expected"));
	DEBUG_PRINTF1(_L("Board Now Dialling: "));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);

	call1.Dial(dialStatus, number); 
	CHECK_EQUALS_L(WaitForRequestWithTimeOut(dialStatus, ETimeLong), KErrNone, _L("RCall::Dial timed-out"));
	CHECK_EQUALS_L(dialStatus.Int(), KErrNone, _L("RCall::Dial returned with an error"));
	
	// Hold call 1. 
	TExtEtelRequestStatus holdStatus(call1, EMobileCallHold);
	CleanupStack::PushL(holdStatus);
	call1.Hold(holdStatus);
	CHECK_EQUALS_L(WaitForRequestWithTimeOut(holdStatus, ETimeMedium),KErrNone, _L("RMobileCall::Hold timed out"));
	CHECK_EQUALS_L(holdStatus.Int(), KErrNone, _L("RMobileCall::Hold returned with an error"));		

	// Ensure mobile call status of call 1 is EStatusHold 
	RMobileCall::TMobileCallStatus mobileCallStatus;
	CHECK_EQUALS_L(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned with an error"));
	CHECK_EQUALS_L(mobileCallStatus, RMobileCall::EStatusHold, _L("RMobileCall::GetMobileCallStatus did not return EStatusHold as expected"));
	
	// Get call 2. 
	RMobileCall& call2 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall2);


	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////

	// post notifier RCall::NotifyCapsChange for call 2
	RCall::TCaps callCaps;
	TCoreEtelRequestStatus<RCall> notifyCapsChangeStatus (call2, &RCall::NotifyCapsChangeCancel);	
	CleanupStack::PushL(notifyCapsChangeStatus);
	call2.NotifyCapsChange(notifyCapsChangeStatus,callCaps);
	
	// post a notifier RMobileCall::NotifyMobileCallCapsChange for call 2
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus(call2, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus);
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg mobileCallCapsPckg(mobileCallCaps);
	call2.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);
	
	// post notifier for RCall::NotifyStatusChange for call 2
	RCall::TStatus callStatus;
	TCoreEtelRequestStatus<RCall> notifyStatusChangeStatus(call2, &RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	call2.NotifyStatusChange(notifyStatusChangeStatus, callStatus);	
		
	// post notifier for RMobileCall::NotifyMobileCallStatusChange
	RMobileCall::TMobileCallStatus notifyMobileCallStatus;
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus(call2, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus);
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, notifyMobileCallStatus);
		
	// Dial a number that answers on call 2. 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber2, number) != EFalse, _L("GetStringFromConfig did not complete as expected"));
	DEBUG_PRINTF1(_L("Board Now Dialling: "));
	TCoreEtelRequestStatus<RCall> dialStatus2(call2, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus2);
	call2.Dial(dialStatus2, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus2, ETimeLong), KErrNone, _L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus2.Int(), KErrNone,  _L("RCall::Dial returned with an error"));
	
	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange for call 2 completes with caps in set of KCapsVoice | KCapsHangUp.
	RCall::TCaps wantedCaps;
	RCall::TCaps unwantedCaps;
	wantedCaps.iFlags = RCall::KCapsVoice | RCall::KCapsHangUp;
	unwantedCaps.iFlags = 0;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyCapsChange(call2, 
													   notifyCapsChangeStatus,
													   callCaps,
													   wantedCaps,
													   unwantedCaps,
													   wantedStatus);

	// Check RCall::GetCaps for call 2 supports KCapsHangUp | KCapsVoice.
	TUint32 wantedCaps2 = RCall::KCapsHangUp | RCall::KCapsVoice;
	ASSERT_EQUALS(call2.GetCaps(callCaps), KErrNone, _L("RCall::GetCaps returned an Error"));
	ASSERT_BITS_SET(callCaps.iFlags, wantedCaps2, KNoUnwantedBits, _L("RCall::GetCaps returned unexpected Caps"));
	
	// Check RMobileCall::NotifyMobileCallCapsChange for call 2 completes with iCallControlCaps in set of KCapsVoice | KCapsSwap | KCapsHangUp | KCapsJoin | KCapsTransfer
	// Check RMobileCall::NotifyMobileCallCapsChange for call 2 completes with iCallControlCaps NOT in set of KCapsHold
	// Check RMobileCall::NotifyMobileCallCapsChange for call 2 completes with iCallEventCaps in set of KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate
	RMobileCall::TMobileCallCapsV1 wantedMobileCaps;
	RMobileCall::TMobileCallCapsV1 unWantedMobileCaps;
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | 
										RMobileCall::KCapsSwap | 
										RMobileCall::KCapsHangUp | 
										RMobileCall::KCapsJoin|
										RMobileCall::KCapsTransfer;
										
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsRemoteHold | 
									  RMobileCall::KCapsRemoteTerminate | 
									  RMobileCall::KCapsRemoteConferenceCreate;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps,mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call2, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);																	   
	unWantedMobileCaps.iCallControlCaps = RMobileCall::KCapsHold;
	ASSERT_BITS_SET(wantedMobileCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, unWantedMobileCaps.iCallControlCaps,
			_L("RMobileCall::NotifyMobileCallCapsChange returned unexpected iCallControlCaps"));																	   

	// Check RMobileCall::GetMobileCallCaps for call 2 includes iCallControlCaps in set of KCapsVoice | KCapsSwap | KCapsHangUp | KCapsJoin | KCapsTransfer
	// Check RMobileCall::GetMobileCallCaps for call 2 includes iCallControlCaps NOT in set of KCapsHold
	// Check RMobileCall::GetMobileCallCaps for call 2 includes iCallEventCaps in set of KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	ASSERT_EQUALS(call2.GetMobileCallCaps(mobileCallCapsPckg), KErrNone, 
			_L("RMobileCall::GetMobileCallCaps returned an error"));
	wantedMobileCaps.iCallControlCaps =  RMobileCall::KCapsVoice | 
										RMobileCall::KCapsSwap | 
										RMobileCall::KCapsHangUp | 
										RMobileCall::KCapsJoin|
										RMobileCall::KCapsTransfer;
										
	unWantedMobileCaps.iCallControlCaps = RMobileCall::KCapsHold;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps,unWantedMobileCaps.iCallControlCaps,
			 _L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));
	
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsRemoteHold | 
									  RMobileCall::KCapsRemoteTerminate | 
									  RMobileCall::KCapsRemoteConferenceCreate;
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits,
			 _L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));	
	
	// ===  Check call status ===
	
	// Check RCall::NotifyStatusChange for call 2 completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	call2.NotifyStatusChange(notifyStatusChangeStatus, callStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	call2.NotifyStatusChange(notifyStatusChangeStatus, callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);
	// Check RCall::GetStatus for call 2 returns EStatusConnected.
	ASSERT_EQUALS(call2.GetStatus(callStatus),KErrNone, _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected, 	_L("RCall::GetStatus returned an unexpected call status"));


	// Check RMobileCall::NotifyMobileCallStatusChange for call 2  completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
															notifyMobileCallStatusChangeStatus,
															notifyMobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, notifyMobileCallStatus);																																												
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
															notifyMobileCallStatusChangeStatus,
															notifyMobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, notifyMobileCallStatus);																
	expectedMobileCallStatus = RMobileCall::EStatusConnected;															
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
															notifyMobileCallStatusChangeStatus,
															notifyMobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);																														
	// Check RMobileCall::GetMobileCallStatus for call 2  returns status of EStatusConnected.
	ASSERT_EQUALS(call2.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileStatus did not return a status EStatusConnected"));

	// ===  Attempt to hold call 2 when call 1 is already on hold ===

	// Hold call 2. 
	TExtEtelRequestStatus holdStatus2(call2, EMobileCallHold);
	CleanupStack::PushL(holdStatus2);
	call2.Hold(holdStatus2);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(holdStatus2, ETimeMedium),KErrNone, _L("RMobileCall::Hold timed out"));
	
	// Check error is returned.
	ASSERT_TRUE(holdStatus2.Int() != KErrNone, _L("RMobileCall::Hold returned KErrNone, should have returned an error"));		

	// ===  Check call 2 is still active and call 1 is still on hold ===

	// Check RMobileCall::GetMobileCallStatus for call 2 returns status of EStatusConnected.
	ASSERT_EQUALS(call2.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned with an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileCallStatus did not return EStatusConnected as expected"));
	
	// Check RMobileCall::GetMobileCallStatus for call 1 returns status of EStatusHold.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned with an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusHold, _L("RMobileCall::GetMobileCallStatus did not return EStatusHold as expected"));

	// Terminate both calls
	ASSERT_EQUALS(call1.HangUp(), KErrNone, _L("RMobileCall::HangUp returned with an error"));
	ASSERT_EQUALS(call2.HangUp(), KErrNone, _L("RMobileCall::HangUp returned with an error"));

	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
    
	
	// Pop
	// dialStatus
	// holdStatus
	// notifyCapsChangeStatus
	// notifyMobileCallCapsChangeStatus
	// notifyStatusChangeStatus
	// notifyMobileCallStatusChangeStatus
	// dialStatus2
	// holdStatus2
	CleanupStack::PopAndDestroy(8, &dialStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0031::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0031");
	}



CCTSYIntegrationTestCallControl0032::CCTSYIntegrationTestCallControl0032(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0032::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0032::~CCTSYIntegrationTestCallControl0032()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0032::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0032
 * @SYMFssID BA/CTSY/CCON-0032
 * @SYMTestCaseDesc Resume a call that is not on hold.
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallCapsChange, RMobileCall::GetMobileCallStatus, RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyCapsChange, RCall::GetStatus, RMobileCall::GetMobileCallCaps, RMobileCall::Resume, RCall::Dial
 * @SYMTestExpectedResults Pass - Error returned on attempt to resume a call that is not on hold.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify error is returned on attempt to resume and call stays connected.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////


	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits, _L("RPhone::GetCaps returned wrong caps"));

	// Get Voice line 1. 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);


	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////


	// Post notifier for RCall::NotifyCapsChange
	TCoreEtelRequestStatus<RCall> notifyCapsChangeStatus (call1, &RCall::NotifyCapsChangeCancel);	
	CleanupStack::PushL(notifyCapsChangeStatus);
	RCall::TCaps callCaps;
	call1.NotifyCapsChange(notifyCapsChangeStatus, callCaps);
	
	// Post notifier for RMobileCall::NotifyMobileCallCapsChange
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus(call1, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus);
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg mobileCallCapsPckg(mobileCallCaps);
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus,mobileCallCapsPckg);
	
	// Post notifier for RCall::NotifyStatusChange for call 1
	RCall::TStatus callStatus;
	TCoreEtelRequestStatus<RCall> notifyStatusChangeStatus(call1,&RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	call1.NotifyStatusChange(notifyStatusChangeStatus, callStatus);	
	
	// Post notifier for RMobileCall::NotifyMobileCallStatusChange for call 1
	RMobileCall::TMobileCallStatus mobileCallStatus;
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus);
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	
	// Dial a number that answers. 
	TPtrC number; 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse, _L("GetStringFromConfig did not complete as expected"));
	DEBUG_PRINTF1(_L("Board Now Dialling: "));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeLong), KErrNone, _L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone, _L("RCall::Dial returned with an error"));

	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsHangUp.
	RCall::TCaps wantedCaps, unwantedCaps;
	wantedCaps.iFlags = RCall::KCapsVoice | RCall::KCapsHangUp;
	unwantedCaps.iFlags = 0;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyCapsChange(call1, 
													   notifyCapsChangeStatus,
													   callCaps,
													   wantedCaps,
													   unwantedCaps,
													   wantedStatus);

	// Check RCall::GetCaps supports KCapsHangUp | KCapsVoice.
	ASSERT_EQUALS(call1.GetCaps(callCaps), KErrNone, _L("RCall::GetCaps returned an error"));
	ASSERT_BITS_SET(callCaps.iFlags, wantedCaps.iFlags, KNoUnwantedBits, _L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp.
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps NOT in set of KCapsResume
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	RMobileCall::TMobileCallCapsV1 wantedMobileCaps;
	TUint32 unWantedControlCaps = RMobileCall::KCapsResume;
	
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | 
										RMobileCall::KCapsHold | 
										RMobileCall::KCapsHangUp;
										
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | 
									  RMobileCall::KCapsLocalTransfer | 
									  RMobileCall::KCapsRemoteHold | 
									  RMobileCall::KCapsRemoteTerminate | 
									  RMobileCall::KCapsRemoteConferenceCreate;
					  				  
	TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps, mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);

	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, unWantedControlCaps, _L("RMobileCall::NotifyMobileCallCapsChange did not set expected iCallControlCaps"));
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits, _L("RMobileCall::NotifyMobileCallCapsChange did not set expected iCallControlCaps"));	

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp.
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps NOT in set of KCapsResume
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone, _L("RMobileCall::GetMobileCallCaps returned an error"));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, unWantedControlCaps, _L("RMobileCall::GetMobileCallCaps returned wrong caps"));
	
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits, _L("RMobileCall::GetMobileCallCaps returned wrong caps"));

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::NotifyStatusChange completes with EStatusConnecting	
	call1.NotifyStatusChange(notifyStatusChangeStatus, callStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::NotifyStatusChange completes with EStatusConnected.
	call1.NotifyStatusChange(notifyStatusChangeStatus, callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);	
													 												 
	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone, _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected, _L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusConnecting ->															
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusConnected.															
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnected;															
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallStatusChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
																														
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, 
			_L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, 
			_L("RMobileCall::GetMobileCallStatus did not return a status EStatusConnected"));

	// Resume call. 
	TExtEtelRequestStatus resumeStatus(call1, EMobileCallResume);
	CleanupStack::PushL(resumeStatus);
	call1.Resume(resumeStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(resumeStatus, ETimeMedium), KErrNone, _L("RMobileCall::Resume timed-out"));
				  
	// Check error is returned.
	ASSERT_TRUE(resumeStatus.Int() != KErrNone, _L("RMobileCall::Resume did not return error as expected"));
	
	// ===  Check call is still connected ===

	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(call1.GetStatus(callStatus),KErrNone, _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected, _L("RCall::GetStatus returned an unexpected call status"));

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileCallStatus did not return a status EStatusConnected"));

	// Hangup call 1.
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone, _L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone, _L("RCall::HangUp returned an error"));


	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
	// notifyCapsChangeStatus
	// notifyMobileCallCapsChangeStatus
	// notifyStatusChangeStatus
	// notifyMobileCallStatusChangeStatus
	// dialStatus
	// resumeStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(7, &notifyCapsChangeStatus);
	
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0032::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0032");
	}



CCTSYIntegrationTestCallControl0033::CCTSYIntegrationTestCallControl0033(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0033::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0033::~CCTSYIntegrationTestCallControl0033()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0033::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0033
 * @SYMFssID BA/CTSY/CCON-0033
 * @SYMTestCaseDesc Check that any client can hold or resume calls, not just owner
 * @SYMTestPriority High
 * @SYMTestActions RCall::OpenExistingCall, RMobileCall::Hold, RMobileCall::Resume, RCall::HangUp, RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyStatusChange, RMobileCall::GetMobileCallStatus, RMobileCall::NotifyCallEvent, RCall::GetStatus
 * @SYMTestExpectedResults Pass - Call held and resumed by any client.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call status is correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, 
 					_L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
 						
	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits, _L("RPhone::GetCaps returned wrong caps"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////

	// Get server 1.
	RTelServer& srv1 = iEtelSessionMgr.GetServerL(KMainServer); 
	
	// Get line 1 from server 1. 
	RMobileLine& line1 = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	
	// Get call 1 from line 1 and server 1. 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);
	
	// Get server 2. 
	RTelServer& srv2 = iEtelSessionMgr.GetServerL(KAltServer); 
	
	// Get line 2 from server 2. 
	RMobileLine& line2 = iEtelSessionMgr.GetLineL(KAltServer, KMainPhone, KVoiceLine);

	// Get call 1 from line 2 and server 2 (this call is now referred to as call 2 in the procedure below). 
	RMobileCall& call2 = iEtelSessionMgr.GetCallL(KAltServer, KMainPhone, KVoiceLine, KCall1);
	
	// Post notify for call 1 RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyStatusChangeCall1(call1, &RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeCall1);
	RCall::TStatus callStatusCall1;
	call1.NotifyStatusChange(notifyStatusChangeCall1, callStatusCall1);
	
	// Post notify for call 1 RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallStatusChangeCall1(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeCall1);
	RMobileCall::TMobileCallStatus mobileCallStatusCall1;
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeCall1, mobileCallStatusCall1);
	
	// Dial a number that answers on call 1. 	
	TPtrC number; 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,_L("GetStringFromConfig did not complete as expected"));	
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone, _L("RCall::Dial returned with an error"));
	
	// ===  Check status for call 1 and call 2 ===

	// Check RMobilCall::NotifyStatusChange for call 1 completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.	
	RCall::TStatus expectedCallStatusCall1 = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeCall1,
														 callStatusCall1,
														 expectedCallStatusCall1,
														 KErrNone);

	call1.NotifyStatusChange(notifyStatusChangeCall1, callStatusCall1);													 	
	expectedCallStatusCall1 = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeCall1,
														 callStatusCall1,
														 expectedCallStatusCall1,
														 KErrNone);

	call1.NotifyStatusChange(notifyStatusChangeCall1, callStatusCall1);	
	expectedCallStatusCall1 = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeCall1,
														 callStatusCall1,
														 expectedCallStatusCall1,
														 KErrNone);
	
	// Check RCall::GetStatus for call 1 returns EStatusConnected.		
	RCall::TStatus getStatusCall1;
	ASSERT_EQUALS(call1.GetStatus(getStatusCall1), KErrNone,_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(getStatusCall1, expectedCallStatusCall1, _L("RCall::GetStatus did not return EStatusConnected"));		
														 
	// Check RMobileCall::NotifyMobileCallStatusChange for call 1 completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatusCall1 = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(
														 call1,
														 notifyMobileCallStatusChangeCall1,
														 mobileCallStatusCall1,
														 expectedMobileCallStatusCall1,
														 KErrNone);

	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeCall1, mobileCallStatusCall1);
	expectedMobileCallStatusCall1 = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(
														 call1,
														 notifyMobileCallStatusChangeCall1,
														 mobileCallStatusCall1,
														 expectedMobileCallStatusCall1,  
														 KErrNone);

	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeCall1, mobileCallStatusCall1);
	expectedMobileCallStatusCall1 = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(
														 call1,
														 notifyMobileCallStatusChangeCall1,
														 mobileCallStatusCall1,
														 expectedMobileCallStatusCall1,
														 KErrNone);

	// Check RMobileCall::GetMobileCallStatus for call 1 returns status of EStatusConnected.
	RMobileCall::TMobileCallStatus getMobileCallStatusCall1;
	ASSERT_EQUALS(call1.GetMobileCallStatus(getMobileCallStatusCall1), KErrNone,_L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(getMobileCallStatusCall1, expectedMobileCallStatusCall1, _L("RMobileCall::GetMobileCallStatus did not return EStatusConnected"));
	
	// Post notifier for call 2 RMobileCall::NotifyCallEvent
	TExtEtelRequestStatus notifyCallEventCall2(call2, EMobileCallNotifyCallEvent);
	CleanupStack::PushL(notifyCallEventCall2);
	RMobileCall::TMobileCallEvent callEventCall2;
	call2.NotifyCallEvent(notifyCallEventCall2,callEventCall2);
	
	// Post notifier for call 2 RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallStatusChangeCall2(call2, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeCall2);
	RMobileCall::TMobileCallStatus mobileCallStatusCall2;
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeCall2, mobileCallStatusCall2);
	
	// Repost notifier for call 1 RMobileCall::NotifyMobileCallStatusChange
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeCall1, mobileCallStatusCall1);
		
	// Hold call using call 2 	
	TExtEtelRequestStatus holdRequestStatusCall2(call2, EMobileCallHold);
	CleanupStack::PushL(holdRequestStatusCall2);
	call2.Hold(holdRequestStatusCall2);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(holdRequestStatusCall2, ETimeMedium), KErrNone, _L("RMobileCall::Hold timed-out"));
	ASSERT_EQUALS(holdRequestStatusCall2.Int(), KErrNone, _L("RMobileCall::Hold returned error"));

	// ===  Check status for call 1 and call 2 ===
	
	// Check RMobileCall::NotifyCallEvent for call 2 completes with ELocalHold
	RMobileCall::TMobileCallEvent expectedCallEventCall2 = RMobileCall::ELocalHold;
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent( 
									call2,
									notifyCallEventCall2,
									callEventCall2, 
									expectedCallEventCall2,
									KErrNone);

	// Check RMobileCall::NotifyMobileCallStatusChange for call 2 completes with EStatusHold
	RMobileCall::TMobileCallStatus expectedMobileCallStatusCall2 = RMobileCall::EStatusHold;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(
														 call2,
														 notifyMobileCallStatusChangeCall2,
														 mobileCallStatusCall2,
														 expectedMobileCallStatusCall2,
														 KErrNone);

	// Check RMobileCall::GetMobileCallStatus for call 2 returns status of EStatusHold
	RMobileCall::TMobileCallStatus getMobileCallStatusCall2;
	ASSERT_EQUALS(call2.GetMobileCallStatus(getMobileCallStatusCall2), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(getMobileCallStatusCall2, expectedMobileCallStatusCall2, _L("RMobileCall::GetMobileCallStatus did not return EStatusHold"));

	// Check RMobileCall::NotifyMobileCallStatusChange for call 1 completes with EStatusHold
	expectedMobileCallStatusCall1 = RMobileCall::EStatusHold;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(
														 call1,
														 notifyMobileCallStatusChangeCall1,
														 mobileCallStatusCall1,
														 expectedMobileCallStatusCall1,
														 KErrNone);

	// Check RMobileCall::GetMobileCallStatus for call 1 returns status of EStatusHold
	ASSERT_EQUALS(call1.GetMobileCallStatus(getMobileCallStatusCall1), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(getMobileCallStatusCall1, expectedMobileCallStatusCall1, _L("RMobileCall::GetMobileCallStatus did not return EStatusHold"));

	// Repost notifier for call 2 RMobileCall::NotifyCallEvent
	call2.NotifyCallEvent(notifyCallEventCall2,callEventCall2);
	
	// Repost notifier for call 2 RMobileCall::NotifyMobileCallStatusChange
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeCall2, mobileCallStatusCall2);

	// Repost notifier for call 1 RMobileCall::NotifyMobileCallStatusChange
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeCall1, mobileCallStatusCall1);

	// Resume call using call 2 
	TExtEtelRequestStatus requestResumeCallStatus(call2,EMobileCallResume);
	CleanupStack::PushL(requestResumeCallStatus);
	call2.Resume(requestResumeCallStatus);	
	ASSERT_EQUALS(WaitForRequestWithTimeOut(requestResumeCallStatus, ETimeMedium), KErrNone, _L("RMobileCall::Resume timed-out"));
	ASSERT_EQUALS(requestResumeCallStatus.Int(), KErrNone, _L("RMobileCall::Resume returned error"));

	// ===  Check status for call 1 and call 2 ===

	// Check RMobileCall::NotifyCallEvent for call 2 completes with ELocalResume
    expectedCallEventCall2 = RMobileCall::ELocalResume;
	iCallControlTestHelper.WaitForMobileCallNotifyCallEvent(call2,
															notifyCallEventCall2,
															callEventCall2, 
															expectedCallEventCall2,
															KErrNone);
									
	// Check RMobileCall::NotifyMobileCallStatusChange for call 2 completes with EStatusConnected
    expectedMobileCallStatusCall2 = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(
														 call2,
														 notifyMobileCallStatusChangeCall2,
														 mobileCallStatusCall2,
														 expectedMobileCallStatusCall2,
														 KErrNone);
														 
	// Check RMobileCall::GetMobileCallStatus for call 2 returns status of EStatusConnected
	ASSERT_EQUALS(call2.GetMobileCallStatus(getMobileCallStatusCall2), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(getMobileCallStatusCall2, expectedMobileCallStatusCall2, _L("RMobileCall::GetMobileCallStatus did not return EStatusConnected"));

	// Check RMobileCall::NotifyMobileCallStatusChange for call 1 completes with EStatusConnected
	expectedMobileCallStatusCall1 = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(
														 call1,
														 notifyMobileCallStatusChangeCall1,
														 mobileCallStatusCall1,
														 expectedMobileCallStatusCall1,
														 KErrNone);

	// Check RMobileCall::GetMobileCallStatus for call 1 returns status of EStatusConnected
	ASSERT_EQUALS(call1.GetMobileCallStatus(getMobileCallStatusCall1), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(getMobileCallStatusCall1, expectedMobileCallStatusCall1, _L("RMobileCall::GetMobileCallStatus did not return EStatusConnected"));

	// Repost notifier for call 1 RCall::NotifyStatusChange
	call1.NotifyStatusChange(notifyStatusChangeCall1, callStatusCall1);
	
	// Repost notifier for call 1 RMobileCall::NotifyMobileCallStatusChange
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeCall1, mobileCallStatusCall1);
	
	// Post notifier for call 2 RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyStatusChangeCall2(call2, &RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeCall2);
	RCall::TStatus callStatusCall2;
	call2.NotifyStatusChange(notifyStatusChangeCall2, callStatusCall2);
	
	// Repost notifier for call 2 RMobileCall::NotifyMobileCallStatusChange
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeCall2, mobileCallStatusCall2);
	
	// Hang up call using call 1 	
	TCoreEtelRequestStatus<RCall>requestStatusHangUp(call1, &RCall::HangUpCancel);
	CleanupStack::PushL(requestStatusHangUp);
	call1.HangUp(requestStatusHangUp);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(requestStatusHangUp, ETimeMedium), KErrNone, _L("RMobileCall::HangUp timed-out"));
	ASSERT_EQUALS(requestStatusHangUp.Int(), KErrNone, _L("RMobileCall::HangUp returned error"));

	// ===  Check status for call 1 and call 2 ===
	
	// Check RCall::NotifyStatusChange for call 1 completes with EStatusHangingUp -> EStatusIdle.
	expectedCallStatusCall1 = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeCall1,
														 callStatusCall1,
														 expectedCallStatusCall1,
														 KErrNone);

	call1.NotifyStatusChange(notifyStatusChangeCall1, callStatusCall1);													 
	expectedCallStatusCall1 = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeCall1,
														 callStatusCall1,
														 expectedCallStatusCall1,
														 KErrNone);
														 	
	// Check RCall::GetStatus for call 1 returns EStatusIdle.
	ASSERT_EQUALS(call1.GetStatus(getStatusCall1), KErrNone,_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(getStatusCall1, RCall::EStatusIdle, _L("RCall::GetStatus did not return EStatusIdle"));	

	// Check RMobileCall::NotifyMobileCallStatusChange for call 1 completes with EStatusDisconnecting -> EStatusIdle.
	expectedMobileCallStatusCall1 = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(
														 call1,
														 notifyMobileCallStatusChangeCall1,
														 mobileCallStatusCall1,
														 expectedMobileCallStatusCall1,
														 KErrNone);
														 

	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeCall1, mobileCallStatusCall1);
	expectedMobileCallStatusCall1 = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(
														 call1,
														 notifyMobileCallStatusChangeCall1,
														 mobileCallStatusCall1,
														 expectedMobileCallStatusCall1,
														 KErrNone);

	// Check RMobileCall::GetMobileCallStatus for call 1 returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(getMobileCallStatusCall1), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(getMobileCallStatusCall1, expectedMobileCallStatusCall1, _L("RMobileCall::GetMobileCallStatus did not return EStatusIdle"));

	// Check RCall::NotifyStatusChange for call 2 completes with EStatusHangingUp ->EStatusIdle..
	RCall::TStatus expectedCallStatusCall2 = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
														 notifyStatusChangeCall2,
														 callStatusCall2,
														 expectedCallStatusCall2,
														 KErrNone);

	call2.NotifyStatusChange(notifyStatusChangeCall2, callStatusCall2);
	expectedCallStatusCall2 = RCall::EStatusIdle;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call2,
														 notifyStatusChangeCall2,
														 callStatusCall2,
														 expectedCallStatusCall2,
														 KErrNone);

	// Check RCall::GetStatus for call 2 returns EStatusIdle.
	RCall::TStatus getStatusCall2;
	ASSERT_EQUALS(call2.GetStatus(getStatusCall2), KErrNone,_L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(getStatusCall2, RCall::EStatusIdle, _L("RCall::GetStatus did not return EStatusIdle"));
	
	// Check RMobileCall::NotifyMobileCallStatusChange for call 2 completes with EStatusDisconnecting -> EStatusIdle.
	expectedMobileCallStatusCall2 = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(
														 call2,
														 notifyMobileCallStatusChangeCall2,
														 mobileCallStatusCall2,
														 expectedMobileCallStatusCall2,
														 KErrNone);
	
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeCall2, mobileCallStatusCall2);													 														 
	expectedMobileCallStatusCall2 = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(
														 call2,
														 notifyMobileCallStatusChangeCall2,
														 mobileCallStatusCall2,
														 expectedMobileCallStatusCall2,
														 KErrNone);

	// Check RMobileCall::GetMobileCallStatus for call 2 returns status of EStatusIdle.
	ASSERT_EQUALS(call2.GetMobileCallStatus(getMobileCallStatusCall2), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(getMobileCallStatusCall2, expectedMobileCallStatusCall2, _L("RMobileCall::GetMobileCallStatus did not return EStatusIdle"));
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
		
	// Pop
	// notifyStatusChangeCall1
	// notifyMobileCallStatusChangeCall1
	// dialStatus
	// notifyCallEventCall2
	// notifyMobileCallStatusChangeCall2
	// holdRequestStatusCall2
	// requestResumeCallStatus
	// notifyStatusChangeCall2
	// requestStatusHangUp
			
	CleanupStack::PopAndDestroy(9, &notifyStatusChangeCall1);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0033::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0033");
	}



CCTSYIntegrationTestCallControl0034::CCTSYIntegrationTestCallControl0034(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0034::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0034::~CCTSYIntegrationTestCallControl0034()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0034::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0034
 * @SYMFssID BA/CTSY/CCON-0034
 * @SYMTestCaseDesc Attempt to transfer a connected call when no other call is on hold
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::Transfer, RCall::GetCaps, RMobileCall::NotifyMobileCallCapsChange, RMobileCall::GetMobileCallStatus, RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyCapsChange, RCall::GetStatus, RMobileCall::GetMobileCallCaps
 * @SYMTestExpectedResults Pass - KErrNotReady? On attempt to transfer call when no other call is on hold.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify KErrNotReady returned on attempt to transfer and call stays connected.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RMobilePhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RMobilePhone::KCapsVoice, KNoUnwantedBits, _L("RMobilePhone::GetCaps did not return KCapsVoice as expected"));
	   
	// Get call.
    RMobileCall& mobileCall = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);
	
    // Get phone number
    TPtrC phoneNumber;
	CHECK_TRUE_L(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, phoneNumber) != EFalse, _L("GetStringFromConfig did not complete as expected"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// Post notifier for RCall::NotifyCapsChange
	RCall::TCaps callCaps;
	TCoreEtelRequestStatus<RCall> notifyCapsChangeStatus (mobileCall, &RCall::NotifyCapsChangeCancel);	
	CleanupStack::PushL(notifyCapsChangeStatus);
	mobileCall.NotifyCapsChange(notifyCapsChangeStatus, callCaps);
	
	// Post notifier for RMobileCall::NotifyMobileCallCapsChange
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg mobileCallCapsPckg(mobileCallCaps);
	TExtEtelRequestStatus notifyMobileCapsChangeStatus(mobileCall, EMobileCallNotifyMobileCallCapsChange);	
	CleanupStack::PushL(notifyMobileCapsChangeStatus);
	mobileCall.NotifyMobileCallCapsChange(notifyMobileCapsChangeStatus, mobileCallCapsPckg);
	
	// Post notifier RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus (mobileCall, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	mobileCall.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);	
	
	// Post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyCallStatusChangeStatus (mobileCall, &RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyCallStatusChangeStatus);
	RCall::TStatus callStatus;
	mobileCall.NotifyStatusChange(notifyCallStatusChangeStatus,callStatus);
	
	// Dial a number that answers. 
	TCoreEtelRequestStatus<RMobileCall> getDialStatus(mobileCall, &RMobileCall::DialCancel);
	CleanupStack::PushL(getDialStatus);
	DEBUG_PRINTF2(_L("Board Now Dialling: %S"), &phoneNumber);
	mobileCall.Dial(getDialStatus, phoneNumber); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(getDialStatus, ETimeLong), KErrNone, _L("RMobileCall::Dial timed-out"));
	ASSERT_EQUALS(getDialStatus.Int(), KErrNone, _L("RMobileCall::Dial returned error"));

	// ===  Check call status ===
	
	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	const TInt expectedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(mobileCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);
														 
	mobileCall.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);
	expectedCallStatus = RCall::EStatusConnecting;	
	iCallControlTestHelper.WaitForCallNotifyStatusChange(mobileCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);	
														 
	mobileCall.NotifyStatusChange(notifyCallStatusChangeStatus, callStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(mobileCall,
														 notifyCallStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 expectedStatus);	

	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(mobileCall.GetStatus(callStatus), KErrNone, _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected, _L("RCall::GetStatus did not return correct status."));

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(mobileCall,
														                notifyMobileCallStatusChangeStatus,
														                mobileCallStatus,
														                expectedMobileCallStatus,
														                expectedStatus);
														 
	mobileCall.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(mobileCall,
														                notifyMobileCallStatusChangeStatus,
														                mobileCallStatus,
														                expectedMobileCallStatus,
														                expectedStatus);	
														 
	mobileCall.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(mobileCall,
														                notifyMobileCallStatusChangeStatus,
														                mobileCallStatus,
														                expectedMobileCallStatus,
														                expectedStatus);	

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(mobileCall.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileCallStatus did not return EStatusConnected as expected."));

	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsHangUp.
	RCall::TCaps wantedCaps;
	RCall::TCaps unwantedCaps;
	const TInt wantedStatus = KErrNone;
	wantedCaps.iFlags = RCall::KCapsVoice | RCall::KCapsHangUp;
	unwantedCaps.iFlags = 0;
	iCallControlTestHelper.WaitForCallNotifyCapsChange(mobileCall, notifyCapsChangeStatus, callCaps, wantedCaps, unwantedCaps, wantedStatus);

	// Check RCall::GetCaps supports KCapsHangUp | KCapsVoice.
	ASSERT_EQUALS(mobileCall.GetCaps(callCaps),KErrNone, _L("RCall::GetCaps returned an error"));
	ASSERT_BITS_SET(callCaps.iFlags, wantedCaps.iFlags, KNoUnwantedBits, _L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp
    RMobileCall::TMobileCallCapsV1 wantedMobileCaps;
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsHold | RMobileCall::KCapsHangUp;
    TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps,mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(mobileCall, notifyMobileCapsChangeStatus, mobileCapsComp, wantedStatus);
	
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps NOT in set of KCapsTransfer
	RMobileCall::TMobileCallCapsV1 unwantedMobileCaps;
    unwantedMobileCaps.iCallControlCaps = RMobileCall::KCapsTransfer;
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, KNoWantedBits, unwantedMobileCaps.iCallControlCaps, _L("RMobileCall::NotifyMobileCallCapsChange contains unwanted caps KCapsTransfer"));
	
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | RMobileCall::KCapsLocalTransfer | 
	                                RMobileCall::KCapsRemoteHold | RMobileCall::KCapsRemoteTerminate |
	                                RMobileCall::KCapsRemoteConferenceCreate;
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits, _L("RMobileCall::NotifyMobileCallCapsChange returned unexpected iCallEventCaps"));
    
    // Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp
    // Check RMobileCall::GetMobileCallCaps includes iCallControlCaps NOT in set of KCapsTransfer
    ASSERT_EQUALS(mobileCall.GetMobileCallCaps(mobileCallCapsPckg), KErrNone, _L("RMobileCall::GetMobileCallCaps returned an error"))
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, unwantedMobileCaps.iCallControlCaps, _L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));
	
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits, _L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));

	// Transfer call. 
	TExtEtelRequestStatus getTransferStatus(mobileCall, EMobileCallTransfer);
	CleanupStack::PushL(getTransferStatus);
	mobileCall.Transfer(getTransferStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(getTransferStatus, ETimeLong), KErrNone, _L("RMobileCall::Transfer timed-out"));
	
	// Check KErrNotReady is returned.
	ASSERT_EQUALS(getTransferStatus.Int(), KErrNotReady, _L("RMobileCall::Transfer did not return KErrNotReady as expected"));

	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(mobileCall.GetStatus(callStatus), KErrNone, _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected, _L("RCall::GetStatus did not return EStatusConnected as expected"));
	
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(mobileCall.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileCallStatus did not return EStatusConnected as expected"));
    	
   	// Hangup call 1.
	TCoreEtelRequestStatus<RCall> hangUpStatus (mobileCall, &RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	mobileCall.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone, _L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone, _L("RCall::HangUp returned an error")); 	
    	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
	// notifyCapsChangeStatus
	// notifyMobileCapsChangeStatus
	// notifyMobileCallStatusChangeStatus
	// notifyCallStatusChangeStatus
	// getDialStatus
	// setTransferStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(7, &notifyCapsChangeStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0034::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0034");
	}



CCTSYIntegrationTestCallControl0035::CCTSYIntegrationTestCallControl0035(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0035::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0035::~CCTSYIntegrationTestCallControl0035()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0035::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0035
 * @SYMFssID BA/CTSY/CCON-0035
 * @SYMTestCaseDesc Attempt to transfer a held call when no other call is connected
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::Transfer, RMobileCall::GetMobileCallStatus, RCall::GetStatus, RMobileCall::GetMobileCallCaps
 * @SYMTestExpectedResults Pass - KErrNotReady? On attempt to transfer call when no other call is active.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify KErrNotReady returned on attempt to transfer and call stays held.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////


	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RMobilePhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RMobilePhone::KCapsVoice, KNoUnwantedBits, _L("RMobilePhone::GetCaps did not return KCapsVoice as expected"));

	// Get Voice line 1. 
    RMobileLine& mobileVoiceLine1 = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1. 
	RMobileCall& mobileCall1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);
    
	// Dial a number that answers on call 1.
	TPtrC phoneNumber;
	CHECK_TRUE_L(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, phoneNumber) != EFalse, _L("GetStringFromConfig did not complete as expected"));
	TCoreEtelRequestStatus<RMobileCall> getDialStatus(mobileCall1, &RMobileCall::DialCancel);
	CleanupStack::PushL(getDialStatus);
	DEBUG_PRINTF2(_L("Board Now Dialling: %S"), &phoneNumber);
	mobileCall1.Dial(getDialStatus, phoneNumber);
	CHECK_EQUALS_L(WaitForRequestWithTimeOut(getDialStatus, ETimeLong), KErrNone, _L("RMobileCall::Dial timed-out"));
	CHECK_EQUALS_L(getDialStatus.Int(), KErrNone, _L("RMobileCall::Dial returned error"));

	// Hold call 1. 
	TExtEtelRequestStatus getHoldStatus(mobileCall1, EMobileCallHold);
	CleanupStack::PushL(getHoldStatus);
	mobileCall1.Hold(getHoldStatus);
	CHECK_EQUALS_L(WaitForRequestWithTimeOut(getHoldStatus, ETimeLong), KErrNone, _L("RMobileCall::Hold timed-out"));
	CHECK_EQUALS_L(getHoldStatus.Int(), KErrNone, _L("RMobileCall::Hold returned error"));
	
	// Ensure mobile call status of call 1 is EStatusHold 
	RMobileCall::TMobileCallStatus mobileCallStatus;
	CHECK_EQUALS_L(mobileCall1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	CHECK_EQUALS_L(mobileCallStatus, RMobileCall::EStatusHold, _L("RMobileCall::GetMobileCallStatus did not return EStatusHold as expected"));
	
	
	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// ===  Check mobile call caps ===

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsResume | KCapsHangUp
	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps NOT in set of KCapsTransfer
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg mobileCallCapsPckg(mobileCallCaps);
    RMobileCall::TMobileCallCapsV1 wantedMobileCaps;
    wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | RMobileCall::KCapsResume | RMobileCall::KCapsHangUp;
   	RMobileCall::TMobileCallCapsV1 unwantedMobileCaps;
	unwantedMobileCaps.iCallControlCaps = RMobileCall::KCapsTransfer;
	
	ASSERT_EQUALS(mobileCall1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone, _L("RMobileCall::GetMobileCallCaps returned an error"));								
    ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, unwantedMobileCaps.iCallControlCaps , _L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));
	
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | RMobileCall::KCapsLocalTransfer | RMobileCall::KCapsRemoteHold | RMobileCall::KCapsRemoteTerminate | RMobileCall::KCapsRemoteConferenceCreate;
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits, _L("RMobileCall::GetMobileCallCaps returned unexpected iCallEventCaps"));

	// Transfer call. 
    TExtEtelRequestStatus getTransferStatus(mobileCall1, EMobileCallTransfer);
	CleanupStack::PushL(getTransferStatus);
	mobileCall1.Transfer(getTransferStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(getTransferStatus, ETimeLong), KErrNone, _L("RMobileCall::Transfer timed-out"));
	
	// Check KErrNotReady is returned.
	ASSERT_EQUALS(getTransferStatus.Int(), KErrNotReady, _L("RMobileCall::Transfer did not return KErrNotReady as expected"));

	// Check RCall::GetStatus returns EStatusConnected.
	RCall::TStatus callStatus;
	ASSERT_EQUALS(mobileCall1.GetStatus(callStatus), KErrNone, _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected, _L("RCall::GetStatus did not return EStatusConnected as expected"));

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusHold.
	ASSERT_EQUALS(mobileCall1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusHold, _L("RMobileCall::GetStatus did not return EStatusHold as expected"));

    // Hangup call 1.
	TCoreEtelRequestStatus<RCall> hangUpStatus (mobileCall1, &RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	mobileCall1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone, _L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone, _L("RCall::HangUp returned an error")); 
	
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
    
	// Pop:
 	// getDialStatus
	// getHoldStatus
	// getTransferStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(4, &getDialStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0035::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0035");
	}



CCTSYIntegrationTestCallControl0036::CCTSYIntegrationTestCallControl0036(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0036::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0036::~CCTSYIntegrationTestCallControl0036()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0036::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0036
 * @SYMFssID BA/CTSY/CCON-0036
 * @SYMTestCaseDesc Transfer a connected call and held call.
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::Transfer, RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyStatusChange, RMobileCall::GetMobileCallStatus, RCall::GetStatus, RMobileCall::GetMobileCallCaps
 * @SYMTestExpectedResults Pass - Call transferred successfully.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify transfer succeeds and calls 1 and 2 are idle after transfer.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits,
					 _L("RPhone::GetCaps returned wrong caps"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	TPtrC number1, number2; 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number1) != EFalse,
			_L("GetStringFromConfig did not complete as expected"));
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber2, number2) != EFalse,
			_L("GetStringFromConfig did not complete as expected"));
	
	// Loop for the two variations in this test.
	for(TInt i=0; i < 2; ++i)
		{
		// Get calls. 
		RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall3);
		RMobileCall& call2 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall4);
		
		// Dial a number that answers on call 1. 
		DEBUG_PRINTF1(_L("Board Now Dialling: "));
		TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
		CleanupStack::PushL(dialStatus);
		call1.Dial(dialStatus, number1); 
		CHECK_EQUALS_L(WaitForRequestWithTimeOut(dialStatus, ETimeLong), KErrNone, _L("RCall::Dial timed-out"));
		CHECK_EQUALS_L(dialStatus.Int(), KErrNone, _L("RCall::Dial returned with an error"));
		
		// Hold call 1. 
		TExtEtelRequestStatus holdStatus(call1, EMobileCallHold);
		CleanupStack::PushL(holdStatus);
		call1.Hold(holdStatus);
		CHECK_EQUALS_L(WaitForRequestWithTimeOut(holdStatus, ETimeMedium),KErrNone, _L("RMobileCall::Hold timed out"));
		CHECK_EQUALS_L(holdStatus.Int(), KErrNone, _L("RMobileCall::Hold returned with an error"));	
		
		// Ensure mobile call status of call 1 is EStatusHold 
		RMobileCall::TMobileCallStatus mobileCallStatus;
		CHECK_EQUALS_L(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned with an error"));
		CHECK_EQUALS_L(mobileCallStatus, RMobileCall::EStatusHold, _L("RMobileCall::GetMobileCallStatus did not return EStatusHold as expected"));
	
		// ===  Check that it is not possible to transfer call 1 yet ===
	
		// Check RMobileCall::GetMobileCallCaps for call 1 includes iCallControlCaps NOT in set of KCapsTransfer
		RMobileCall::TMobileCallCapsV1 unWantedMobileCaps;
		unWantedMobileCaps.iCallControlCaps = RMobileCall::KCapsTransfer;
		RMobileCall::TMobileCallCapsV1 mobileCallCaps;
		RMobileCall::TMobileCallCapsV1Pckg mobileCallCapsPckg(mobileCallCaps);
		ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone, 
				_L("RMobileCall::GetMobileCallCaps returned an error"));								
		ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, mobileCallCaps.iCallControlCaps, unWantedMobileCaps.iCallControlCaps,
				 _L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));
		
		// Dial a number that answers on call 2. 
		DEBUG_PRINTF1(_L("Board Now Dialling 2nd call: "));
		TCoreEtelRequestStatus<RCall> dialStatus2(call2, &RCall::DialCancel);
		CleanupStack::PushL(dialStatus2);
		call2.Dial(dialStatus2, number2);		
		ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus2, ETimeLong), KErrNone, _L("RCall::Dial timed-out"));
		ASSERT_EQUALS(dialStatus2.Int(), KErrNone,  _L("RCall::Dial returned with an error"));
		
		// ===  Check that it is possible to transfer call 1 and 2 now ===
	
		// Check RMobileCall::GetMobileCallCaps for call 1 includes iCallControlCaps in set of KCapsTransfer	
		ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone, _L("RMobileCall::GetMobileCallCaps returned an error"));								
		ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps,  RMobileCall::KCapsTransfer, KNoUnwantedBits,
				 _L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));
		
		// Check RMobileCall::GetMobileCallCaps for call 2 includes iCallControlCaps in set of KCapsTransfer
		// Note: In light of the defect found in CTSY, defect Id 10052: CTSY not able to transfer the unheld call;
		// it is not clear whether the unheld call (call2) should or should not have KCapsTransfer capability.
		// The current implementation of CTSY DOES give the unheld call KCapsTransfer capability, so this test remains for now. 
		ASSERT_EQUALS(call2.GetMobileCallCaps(mobileCallCapsPckg), KErrNone, _L("RMobileCall::GetMobileCallCaps returned an error"));								
		ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps,  RMobileCall::KCapsTransfer, KNoUnwantedBits,
				 _L("RMobileCall::GetMobileCallCaps returned unexpected iCallControlCaps"));

		RMobileCall* callToTransfer;
		if(i==0) 
			{
			// Transfer call 1
			// $CTSYProblem LTSY propagating error -4285(KErrGsmCCFacilityRejected) to CTSY, which is correclty returning it back to client
			// therefore error code does not indicate an error in the CTSY but rather that the LTSY/network is not supporting the requested operation.
			callToTransfer = &call1;
			}
		else
			{
			// Transfer call 2
			callToTransfer = &call2;
			}

		TExtEtelRequestStatus transferStatus(*callToTransfer, EMobileCallTransfer);
		CleanupStack::PushL(transferStatus);
		callToTransfer->Transfer(transferStatus);
		ASSERT_EQUALS(WaitForRequestWithTimeOut(transferStatus, ETimeLong), KErrNone, _L("RCall::Transfer timed-out"));

		if(callToTransfer == &call2)
			{
			// There is a Ctsy defect when attempting to transfer call2 (the unheld call), which causes the operation to time-out.
			ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10052);
			ASSERT_EQUALS(transferStatus.Int(), KErrNone, _L("RCall::Transfer of call2 returned with an error"));
			}
		else
			{
			ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10048);
			ASSERT_EQUALS(transferStatus.Int(), KErrGsmCCFacilityRejected, _L("RCall::Transfer returned an unexpected status"));
			}
		
		iEtelSessionMgr.ReleaseCall(KMainServer,KMainPhone,KVoiceLine,KCall3);
		iEtelSessionMgr.ReleaseCall(KMainServer,KMainPhone,KVoiceLine,KCall4);
	
		User::After(3000000);

		// PopAndDestroy
		// dialStatus
		// holdStatus
		// dialStatus2
		// transferStatus
		CleanupStack::PopAndDestroy(4, &dialStatus);
		}

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
		
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0036::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0036");
	}


CCTSYIntegrationTestCallControl0037::CCTSYIntegrationTestCallControl0037(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0037::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0037::~CCTSYIntegrationTestCallControl0037()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0037::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0037
 * @SYMFssID BA/CTSY/CCON-0037
 * @SYMTestCaseDesc Close the phone when incoming call is coming.
 * @SYMTestPriority High
 * @SYMTestActions RLine::Open, RPhone::Close, RLine::NotifyIncomingCall, RPhone::Open, RLine::Close, RPhone::GetLineInfo
 * @SYMTestExpectedResults Pass - Phone subsession closed cleanly.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify incoming call notification completes and phone and line can be closed.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Get line 1 
	RMobileLine& mobileLine= iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Register for notification of incoming call with RLine::NotifyIncomingCall 
	TName name;
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus (mobileLine,&RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus);
	mobileLine.NotifyIncomingCall(notifyIncomingCallStatus,name);
	
	// Request for incoming call from RPS. 
	ASSERT_EQUALS (RPSRequestIncomingCallL(EVoiceLine), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSRequestIncomingCallL returned with an error"));
	
	// Cancel notification of incoming call with RLine::NotifyIncomingCallCancel 
	notifyIncomingCallStatus.Cancel();
	
	// release phone. 
	iEtelSessionMgr.ReleaseLine(KMainServer, KMainPhone, KVoiceLine);
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	CleanupStack::PopAndDestroy(&notifyIncomingCallStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0037::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0037");
	}



CCTSYIntegrationTestCallControl0038::CCTSYIntegrationTestCallControl0038(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0038::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0038::~CCTSYIntegrationTestCallControl0038()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0038::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0038
 * @SYMFssID BA/CTSY/CCON-0038
 * @SYMTestCaseDesc Cancel transfer
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::Transfer, RMobileCall::Transfer
 * @SYMTestExpectedResults Pass - Transfer cancelled.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify transfer can be cancelled.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Get Voice line 1. 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	
	// Check phone supports KCapsVoice.
	RLine::TCaps lineCaps; 
	CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone, _L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits, _L("RLine::GetCaps returned wrong caps"));

	// Get call 1. 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);
	
	// Get call 2. 
	RMobileCall& call2 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall2);

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// Post notifier
	const TInt expectedStatus = KErrNone;
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus (call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	
	// Dial a number that answers. 
	TPtrC number; 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse, _L("CTestStep::GetStringFromConfig did not complete as expected"));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	call1.Dial(dialStatus, number); 			
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone, _L("RCall::Dial returned with an error"));
	
	// Wait for call to be connected. 
	RMobileCall::TMobileCallStatus expectedMobileCallStatus  = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
														                notifyMobileCallStatusChangeStatus,
														                mobileCallStatus,
														                expectedMobileCallStatus ,
														                expectedStatus);
														                
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileCallStatus did not set call status EStatusConnected as expected"));
		
	// Hold call 1. 
	TExtEtelRequestStatus getHoldStatus(call1, EMobileCallHold);
	CleanupStack::PushL(getHoldStatus);
	call1.Hold(getHoldStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(getHoldStatus, ETimeMedium), KErrNone, _L("RMobileCall::Hold timed-out."));
	ASSERT_EQUALS(getHoldStatus.Int(), KErrNone, _L("RMobileCall::Hold returned error."));
	
	// Post notifier
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus2 (call2, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus2);
	call2.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus2, mobileCallStatus);
	
	// Dial another number that answers. 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber2, number) != EFalse, _L("CTestStep::GetStringFromConfig did not complete as expected"));
	TCoreEtelRequestStatus<RCall> dialStatus2(call2, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus2);
	call2.Dial(dialStatus2, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus2, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus2.Int(), KErrNone, _L("RCall::Dial returned with an error"));
	
	// Wait for call to be connected.
	expectedMobileCallStatus  = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call2,
														                notifyMobileCallStatusChangeStatus2,
														                mobileCallStatus,
														                expectedMobileCallStatus ,
														                expectedStatus);
					
	// Transfer call 1.
	TExtEtelRequestStatus getTransferStatus(call1, EMobileCallTransfer);
	CleanupStack::PushL(getTransferStatus);
	call1.Transfer(getTransferStatus);
			
	// Cancel transfer. 
	phone.CancelAsyncRequest(EMobileCallTransfer);
	
	// Check KErrGsmCCFacilityRejected returned.
	// $CTSYProblem LTSY propagating error -4285(KErrGsmCCFacilityRejected) to CTSY, which is correctly returning it back to client
	// therefore error code does not indicate an error in the CTSY but rather that the LTSY / network is not supporting the requested operation.
	// Changed test to check if KErrGsmCCFacilityRejected is returned instead of KErrCancel | KErrNone.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(getTransferStatus, ETimeMedium), KErrNone, _L("RTelSubSessionBase::CancelAsyncRequest timed-out"));
	ASSERT_EQUALS(getTransferStatus.Int(), KErrGsmCCFacilityRejected, _L("RMobilePhone::CancelAsyncRequest returned with an incorrect status"));
	
	// Hang up call1. 
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone, _L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone,  _L("RCall::HangUp returned with an error"));

	// Hang up call2. 
	TCoreEtelRequestStatus<RCall> hangUpStatus2 (call2,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus2);
	call2.HangUp(hangUpStatus2);	
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus2, ETimeMedium), KErrNone, _L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus2.Int(), KErrNone,  _L("RCall::HangUp returned with an error"));
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
		    
	// Pop
	// notifyMobileCallStatusChangeStatus
	// dialStatus
	// getHoldStatus
	// notifyMobileCallStatusChangeStatus2
	// dialStatus2
	// getTransferStatus
	// hangUpStatus
	// hangUpStatus2
	CleanupStack::PopAndDestroy(8, &notifyMobileCallStatusChangeStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0038::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0038");
	}



CCTSYIntegrationTestCallControl0039::CCTSYIntegrationTestCallControl0039(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0039::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0039::~CCTSYIntegrationTestCallControl0039()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0039::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0039
 * @SYMFssID BA/CTSY/CCON-0039
 * @SYMTestCaseDesc Deflect incoming call
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::Deflect, RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyStatusChange, RLine::NotifyStatusChange, RMobileLine::GetMobileLineStatus, RMobileLine::NotifyMobileLineStatusChange, RLine::GetStatus, RMobileCall::GetMobileCallStatus, RCall::GetStatus, RLine::NotifyIncomingCall
 * @SYMTestExpectedResults Pass - Call deflected.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/manual
 *
 * Reason for test: Verify incoming call can be deflected and call and line return to idle.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
    RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
    CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits,  _L("RPhone::GetCaps returned wrong caps"));

	// Get Voice line 1. 
    RMobileLine& mobileLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
      

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////

	for (TInt callDeflectType = RMobileCall::EDeflectVoicemail; callDeflectType <= RMobileCall::EDeflectSuppliedNumber; ++callDeflectType )
		{
		// Get call 1. 
	    //RMobileCall& mobileCall = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

		// Post RLine::NotifyIncomingCall
	    TName callName;
	    TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus(mobileLine, &RLine::NotifyIncomingCallCancel);
	    CleanupStack::PushL(notifyIncomingCallStatus);
	    mobileLine.NotifyIncomingCall(notifyIncomingCallStatus, callName);
	    
		// Request incoming call from RPS.
		RPSRequestIncomingCallL(EVoiceLine);
		
		// Check RLine::NotifyIncomingCall completes with KErrNone
	    ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus, ETimeLong), KErrNone, _L("RLine::NotifyIncomingCall timed out"));
	    ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone, _L("RLine::NotifyIncomingCall returned with an error"));
	    
	    TCallId incomingCallId;
	    RMobileCall& mobileCall = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, callName, incomingCallId);
	    
	    // Post notifications
	    RCall::TStatus callStatus;
	    TCoreEtelRequestStatus<RMobileCall> notifyStatusChangeMCallStatus (mobileCall, &RMobileCall::NotifyStatusChangeCancel);
	    CleanupStack::PushL(notifyStatusChangeMCallStatus);
	    mobileCall.NotifyStatusChange(notifyStatusChangeMCallStatus, callStatus);
	    
	    // Post notify RLine::NotifyStatusChange
	    RCall::TStatus lineStatus;
		TCoreEtelRequestStatus<RLine> notifyStatusChangeMLineStatus (mobileLine, &RLine::NotifyStatusChangeCancel);
	    CleanupStack::PushL(notifyStatusChangeMLineStatus);
		mobileLine.NotifyStatusChange(notifyStatusChangeMLineStatus, lineStatus);
	
		// Post notifier RMobileCall::NotifyMobileCallStatusChange
		RMobileCall::TMobileCallStatus mobileCallStatus;
		TExtEtelRequestStatus notifyMobileCallStatusChangeStatus(mobileCall, EMobileCallNotifyMobileCallStatusChange);
		CleanupStack::PushL(notifyMobileCallStatusChangeStatus);
		mobileCall.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);
	
		// Post RMobileLine::NotifyMobileLineStatusChange
		RMobileCall::TMobileCallStatus mobileLineStatus;
		TExtEtelRequestStatus notifyMobileLineChangeStatus(mobileLine, EMobileLineNotifyMobileLineStatusChange);
		CleanupStack::PushL(notifyMobileLineChangeStatus);
		mobileLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);	
	
		// Deflect call to a voice mail number using RMobileCall::Deflect and aDeflectType = EDeflectVoicemail. 
		// $CTSYProblem CTSY is not supporting deflect type of RMobileCall::EDeflectVoicemail, and is returning KErrNotsupported
	    TExtEtelRequestStatus setDeflectStatus(mobileCall, EMobileCallDeflect);
	    CleanupStack::PushL(setDeflectStatus);
	    RMobilePhone::TMobileAddress destination;
	    TPtrC phoneNumber;
		ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber2, phoneNumber) != EFalse, _L("GetStringFromConfig did not complete as expected"));
	    destination.iTelNumber = phoneNumber;
	    destination.iTypeOfNumber = RMobilePhone::ENationalNumber;
	    destination.iNumberPlan = RMobilePhone::ENationalNumberPlan;
	    
	    mobileCall.Deflect(setDeflectStatus, (RMobileCall::TMobileCallDeflect)callDeflectType, destination);    
		ASSERT_EQUALS(WaitForRequestWithTimeOut(setDeflectStatus, ETimeLong), KErrNone, _L("RMobileCall::Deflect timed-out"));
	    ASSERT_EQUALS(setDeflectStatus.Int(), KErrNone, _L("RMobileCall::Deflect returned with an error"));
	    // ******** HERE - put eror code. Assign new code from xls ******* //
	        
		// ===  Check call status ===
	
		// Check RCall::NotifyStatusChange completes with EStatusIdle.
		RCall::TStatus expectedCallStatus = RCall::EStatusIdle;
	    TInt wantedStatus = KErrNone;
	    iCallControlTestHelper.WaitForCallNotifyStatusChange(mobileCall,
	    													 notifyStatusChangeMCallStatus,
	    													 callStatus,
	    													 expectedCallStatus,
	    													 wantedStatus);
	    
		// Check RCall::GetStatus returns EStatusIdle.
		ASSERT_EQUALS(mobileCall.GetStatus(callStatus), KErrNone, _L("RCall::GetStatus returned error"));
		ASSERT_EQUALS(callStatus, RCall::EStatusIdle, _L("RCall::GetStatus did not return call status EStatusIdle as expected"));
	
		// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusIdle.
		RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusIdle;
	    iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(mobileCall, 
	    																	 notifyMobileCallStatusChangeStatus,
	    																	 mobileCallStatus,
	    																	 expectedMobileCallStatus,
	    																	 wantedStatus);
	    
		// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
		ASSERT_EQUALS(mobileCall.GetStatus(callStatus), KErrNone, _L("RMobileCall::GetStatus returned error"));
		ASSERT_EQUALS(callStatus, RCall::EStatusIdle, _L("RMobileCall::GetStatus did not return call status EStatusIdle as expected"));
	
		// ===  Check line status ===
	
		// Check RLine::NotifyStatusChange completes with EStatusIdle
		iCallControlTestHelper.WaitForLineNotifyStatusChange(mobileLine, 
															 notifyStatusChangeMLineStatus,
															 lineStatus,
															 expectedCallStatus,
															 wantedStatus);
	
		// Check RLine::GetStatus returns EStatusIdle
		ASSERT_EQUALS(mobileLine.GetStatus(callStatus), KErrNone, _L("RLine::GetStatus returned error"));
		ASSERT_EQUALS(callStatus, RCall::EStatusIdle, _L("RLine::GetStatus did not return call status EStatusIdle as expected"));
	
		// Check RMobileLine::NotifyMobileLineStatusChange completes with EStatusIdle
		RMobileCall::TMobileCallStatus expectedLineStatus = RMobileCall::EStatusIdle;
		iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(mobileLine, 
																			 notifyMobileLineChangeStatus,
																			 mobileLineStatus,
																			 expectedLineStatus,
																			 wantedStatus);
	
		// Check RMobileLine::GetMobileLineStatus returns EStatusIdle
		ASSERT_EQUALS(mobileLine.GetStatus(callStatus), KErrNone, _L("RMobileLine::GetStatus returned error"));
		ASSERT_EQUALS(callStatus, RCall::EStatusIdle, _L("RMobileLine::GetStatus did not return call status EStatusIdle as expected"));
		
		iEtelSessionMgr.ReleaseCall(KMainServer,KMainPhone,KVoiceLine, KCall1);
		
		// Pop
		// notifyIncomingCallStatus
		// notifyStatusChangeMCallStatus
		// notifyStatusChangeMLineStatus
		// notifyMobileCallStatusChangeStatus
		// notifyMobileLineChangeStatus
		// setDeflectStatus
		CleanupStack::PopAndDestroy(6, &notifyIncomingCallStatus);
		}
	
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
   		
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0039::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0039");
	}


CCTSYIntegrationTestCallControl0040::CCTSYIntegrationTestCallControl0040(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0040::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0040::~CCTSYIntegrationTestCallControl0040()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0040::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0040
 * @SYMFssID BA/CTSY/CCON-0040
 * @SYMTestCaseDesc Cancel deflect call to registered number
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::Deflect
 * @SYMTestExpectedResults Pass - Deflect cancelled.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/manual
 *
 * Reason for test: Verify deflect is cancelled.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits,  _L("RPhone::GetCaps returned wrong caps"));

	// Get Voice line 1. 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	
	// Get call 1. 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Tester should dial the board. 
	DisplayUserInteractionPromptL(_L("Dial in to this phone after pressing Any key"), ETimeLong);
	
	// Check RLine::NotifyIncomingCall completes with KErrNone
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus(voiceLine, &RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus);
	TName incomingCallName;
	incomingCallName.Zero();
	voiceLine.NotifyIncomingCall(notifyIncomingCallStatus, incomingCallName);
	
	// Deflect call using aDeflectType = EDeflectRegisteredNumber and specifying a valid destination. 
	TExtEtelRequestStatus deflectStatus(call1, EMobileCallDeflect);
	CleanupStack::PushL(deflectStatus);
	RMobileCall::TMobileCallDeflect deflectType = RMobileCall::EDeflectRegisteredNumber;
	RMobilePhone::TMobileAddress mobileAddress; 
	call1.Deflect(deflectStatus, deflectType, mobileAddress);

	// Cancel deflect. 
	phone.CancelAsyncRequest(EMobileCallDeflect);

	// Check KErrNone or KErrCancel returned.
	// $CTSYProblem CTSY is not supporting deflect type of RMobileCall::EDeflectRegisteredNumber, and is returningn KErrNotsupported
	ASSERT_EQUALS(WaitForRequestWithTimeOut(deflectStatus, ETimeLong), KErrNone, _L("RCall::Deflect timed-out"));
	ASSERT_TRUE((deflectStatus.Int() == KErrNone) || (deflectStatus.Int() == KErrCancel), _L("RMobileCall::Deflect did not return KErrNone or KErrCancel"));

	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
	// notifyIncomingCallStatus
	// deflectStatus
	CleanupStack::PopAndDestroy(2, &notifyIncomingCallStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0040::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0040");
	}



CCTSYIntegrationTestCallControl0041::CCTSYIntegrationTestCallControl0041(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0041::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0041::~CCTSYIntegrationTestCallControl0041()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0041::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0041
 * @SYMFssID BA/CTSY/CCON-0041
 * @SYMTestCaseDesc Cancelled answer incoming before detection and during detection
 * @SYMTestPriority High
 * @SYMTestActions RCall::AnswerIncomingCall
 * @SYMTestExpectedResults Pass - Answer incoming call request cancelled.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify answering of incoming call can be cancelled.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits, _L("RPhone::GetCaps returned wrong caps"));

	// Get Voice line 1. 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////

	// Answer incoming call request cancelled with different delays. 
	AnswerIncomingCallCancelL(voiceLine, KOneSecond/100);
	AnswerIncomingCallCancelL(voiceLine, KOneSecond/10000);
	AnswerIncomingCallCancelL(voiceLine, 0);

	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0041::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0041");
	}

/**
 * Cancels an incoming call answer request after given delay.
 * @param aVoiceLine Line object.
 * @param aDelay Delay between answering and cancelling request.
 */
void CCTSYIntegrationTestCallControl0041::AnswerIncomingCallCancelL(
		RMobileLine& aVoiceLine,
		TInt aDelay)
	{
	// Post notify RLine::NotifyIncomingCall
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus(aVoiceLine, &RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus);
	TName incomingCallName;
	aVoiceLine.NotifyIncomingCall(notifyIncomingCallStatus, incomingCallName);

	// Request incoming call from RPS. 
	ASSERT_EQUALS (RPSRequestIncomingCallL(EVoiceLine), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSRequestIncomingCallL returned an error"));

	// Check RLine::NotifyIncomingCall completes.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus, ETimeMedium), KErrNone, _L("RLine::NotifyIncomingCall timed-out"));
	ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone, _L("RLine::NotifyIncomingCall returned an error"));

	// Get the incoming call
	TCallId incomingCallId;
	RMobileCall& call1 = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, incomingCallName, incomingCallId);

	// Call RCall::AnswerIncomingCall
	TCoreEtelRequestStatus<RCall> answerIncomingStatus(call1, &RCall::AnswerIncomingCallCancel);
	CleanupStack::PushL(answerIncomingStatus);	
	call1.AnswerIncomingCall(answerIncomingStatus);

	// Call RCall::AnswerIncomingCallCancel after a delay 
	if (aDelay > 0)
	    {
	    User::After(aDelay);
	    }
    call1.AnswerIncomingCallCancel();
	DEBUG_PRINTF2(_L("RCall::AnswerIncomingCallCancel called after %d microseconds delay"), aDelay);

	// Check answer incoming call cancelled.
    // $CTSYProblem CMmCallTsy::AnswerIncomingCallCancel
    // TSY has started a request and it is not possible to then cancel this request. 
    // The best thing for the TSY to do in this case is to call HangUp method to do this and set a flag so that we can know that AnswerIncomingCallCancel handling is going on.
    // Checking is changed from KErrCancel to KErrGsmCallRejected
	ASSERT_EQUALS(WaitForRequestWithTimeOut(answerIncomingStatus, ETimeMedium), KErrNone, _L("RMobileCall::AnswerIncomingCall timed-out"));
  	ASSERT_EQUALS(answerIncomingStatus.Int(), KErrGsmCallRejected, _L("RCall::AnswerIncomingCall was not cancelled correctly"));
	RCall::TStatus callStatus;
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone, _L("RCall::GetStatus returned an Error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle, _L("RCall::GetStatus did not return EStatusIdle"));

	// Release call
	iEtelSessionMgr.ReleaseCall(KMainServer, KMainPhone, KVoiceLine, incomingCallId);

	// Pop
	// notifyIncomingCallStatus
	// answerIncomingStatus
	CleanupStack::PopAndDestroy(2, &notifyIncomingCallStatus);
	}


CCTSYIntegrationTestCallControl0042::CCTSYIntegrationTestCallControl0042(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0042::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0042::~CCTSYIntegrationTestCallControl0042()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0042::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0042
 * @SYMFssID BA/CTSY/CCON-0042
 * @SYMTestCaseDesc Ensure that when in class C operation (PSD only), a voice or data call dial request completes with an error.
 * @SYMTestPriority High
 * @SYMTestActions 
 * @SYMTestExpectedResults Pass - KErrGsmOfflineOpNotAllowed returned.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify error is returned on attempt to dial.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Get the packet service. 
    RPacketService& packetService = iEtelSessionMgr.GetPacketServiceL(KMainServer, KMainPhone, KMainPacketService);
    
	// Set the MS class to EMSClassAlternateMode. 
    TExtEtelRequestStatus setMSClassStatus(packetService, EPacketSetMSClass);
	CleanupStack::PushL(setMSClassStatus);
    packetService.SetMSClass(setMSClassStatus, RPacketService::EMSClassAlternateMode);
    CHECK_EQUALS_L(WaitForRequestWithTimeOut(setMSClassStatus, ETimeLong), KErrNone, _L("RPacketService::SetMSClass timed out"));
    ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10050);
	CHECK_TRUE_L(EFalse, _L("This test has been made to leave intentionally as CTSY currently does not support the SetMSClass operation."));		
    CHECK_EQUALS_L(setMSClassStatus.Int(), KErrNone, _L("RPacketService::SetMSClass returned an error"));

	// Set the preferred bearer to EBearerPacketSwitched
	TExtEtelRequestStatus setPreferredBearerStatus(packetService, EPacketSetPrefBearer);
	CleanupStack::PushL(setPreferredBearerStatus);
    packetService.SetPreferredBearer(setPreferredBearerStatus, RPacketService::EBearerPacketSwitched);
	CHECK_EQUALS_L(WaitForRequestWithTimeOut(setPreferredBearerStatus, ETimeLong), KErrNone, _L("RPacketService::SetPreferredBearer timed out"));
    CHECK_EQUALS_L(setPreferredBearerStatus.Int(), KErrNone, _L("RPacketService::SetPreferredBearer returned an error"));

	// Ensure the packet service status is EStatusAttached. 
    RPacketService::TStatus packetStatus;
    CHECK_EQUALS_L(packetService.GetStatus(packetStatus), KErrNone, _L("RPacketService::GetStatus returned an error"));
    TExtEtelRequestStatus notifyServiceStatusChStatus(packetService, EPacketNotifyStatusChange);
    CleanupStack::PushL(notifyServiceStatusChStatus);
    RPacketService::TStatus packetServiceStatus;
    
    if (packetStatus != RPacketService::EStatusAttached)
        {
        RPacketService::TAttachMode attachMode;
        CHECK_EQUALS_L(packetService.GetAttachMode(attachMode), KErrNone, _L("RPacketService::GetAttachMode returned with an error."));
        packetService.NotifyStatusChange(notifyServiceStatusChStatus, packetServiceStatus);
        if(attachMode != RPacketService::EAttachWhenPossible)
    		{
    		CHECK_EQUALS_L(packetService.SetAttachMode(RPacketService::EAttachWhenPossible), KErrNone, _L("RPacketService::SetAttachMode returned with an error."));
    		}
        CHECK_EQUALS_L(packetService.GetAttachMode(attachMode), KErrNone, _L("RPacketService::GetAttachMode returned with an error."));
        CHECK_EQUALS_L(attachMode, RPacketService::EAttachWhenPossible, _L("RPacketService::GetAttachMode did not return EAttachWhenPossible."));

        // Ensure phone is attached to the packet service (RPacketService::GetStatus returns EStatusAttached).
    	CHECK_EQUALS_L(packetService.GetStatus(packetStatus), KErrNone, _L("RPacketService::GetStatus returned with an error"));
    	
    	// Wait for phone to attach to packet service if it is not attached.
    	if (packetStatus == RPacketService::EStatusUnattached)
    		{
            iPacketServiceTestHelper.WaitForPacketServiceNotifyStatusChange(
    				packetService,
    				notifyServiceStatusChStatus,
    				packetServiceStatus, 
    				RPacketService::EStatusAttached,
    				KErrNone);
            CHECK_EQUALS_L(packetService.GetStatus(packetStatus), KErrNone, _L("RPacketService::GetStatus returned with an error"));
            CHECK_EQUALS_L(packetStatus, RPacketService::EStatusAttached, _L("RPacketService::GetStatus did not return EStatusAttached"));
    		}
        }


	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Get voice line 1. 
    RLine& line = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1. 
    RCall& call = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// Dial a number with call 1. 
	TPtrC number;
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse, _L("GetStringFromConfig did not complete as expected"));
	TCoreEtelRequestStatus<RCall> dialStatus(call, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
    DEBUG_PRINTF1(_L("Dialling VoiceNumber1"));	
	call.Dial(dialStatus, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeLong), KErrNone, _L("RCall::Dial timed-out"));

	// Verify KErrGsmOfflineOpNotAllowed returned. 
	ASSERT_EQUALS(dialStatus.Int(), KErrGsmOfflineOpNotAllowed, _L("RCall::Dial did not return KErrGsmOfflineOpNotAllowed as expected."));
        	
	// Get data line 1.
    RLine& dataLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KDataLine);

	// Get call 1 with data line 1.
	call = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KDataLine, KCall1);

	// Dial a number with call 1. 
	DEBUG_PRINTF1(_L("Dialling VoiceNumber1"));
	call.Dial(dialStatus, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeLong), KErrNone, _L("RCall::Dial timed-out"));

	// Verify KErrGsmOfflineOpNotAllowed returned. 
	ASSERT_EQUALS(dialStatus.Int(), KErrGsmOfflineOpNotAllowed, _L("RCall::Dial did not return KErrGsmOfflineOpNotAllowed as expected."));
    
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
    
	// Pop
	// setMSClassStatus
	// setPreferredBearerStatus
	// notifyServiceStatusChStatus
	// dialStatus
	CleanupStack::Pop(4, &setMSClassStatus);

	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0042::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0042");
	}



CCTSYIntegrationTestCallControl0043::CCTSYIntegrationTestCallControl0043(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0043::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0043::~CCTSYIntegrationTestCallControl0043()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0043::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0043
 * @SYMFssID BA/CTSY/CCON-0043
 * @SYMTestCaseDesc Ensure that when in class C operation (PSD only), an incoming call does not trigger a NotifyIncomingCall request.
 * @SYMTestPriority High
 * @SYMTestActions 
 * @SYMTestExpectedResults Pass - Notify incoming call request does not complete.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify incoming call notification remains pending.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Get the packet service.  

	// Set the MS class to EMSClassAlternateMode. 

	// Set the preferred bearer to EBearerPacketSwitched 

	// Ensure the packet service status is EStatusAttached. 


	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Get voice line 1. 

	// Get call 1. 

	// Request incoming call notification with RLine::NotifyIncomingCall 

	// Request an incoming call from RPS. 

	// Wait for 2 mins. 

	// Check that RLine::NotifyIncomingCall notification is still KRequestPending.

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Put any required test clean up here, then remove this comment
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0043::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0043");
	}



CCTSYIntegrationTestCallControl0044::CCTSYIntegrationTestCallControl0044(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0044::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0044::~CCTSYIntegrationTestCallControl0044()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0044::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0044
 * @SYMFssID BA/CTSY/CCON-0044
 * @SYMTestCaseDesc Cancel hang up.
 * @SYMTestPriority High
 * @SYMTestActions RCall::NotifyStatusChange, RCall::GetStatus, RCall::HangUp, RCall::HangUpCancel, RLine::GetStatus
 * @SYMTestExpectedResults Pass - KErrNotSupported.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify hang up request can be cancelled.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
	         _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	// Get Voice line 1. 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1. 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone,_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits, _L("RPhone::GetCaps returned wrong caps"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////

	StartTest();

	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////

	// Dial a number that answers. 
	TPtrC number; 
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse, _L("GetStringFromConfig did not complete as expected"));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	DEBUG_PRINTF1(_L("Board Now Dialling: "));	
	call1.Dial(dialStatus, number); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, _L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone, _L("RCall::Dial returned with an error"));
	
	// Hang up.
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1, &RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);

	// Immediately cancel the hang up request with RCall::HangUpCancel.
	call1.HangUpCancel();
		
	// Check hang up is cancelled.
	ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 50007);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeShort), KErrNone, _L("RCall::HangUpCancel timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNotSupported, _L("RCall::HangUpCancel returned with an error"));

	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();

    // Pop    
   	// dialStatus
   	// hangUpStatus
    CleanupStack::PopAndDestroy(2, &dialStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0044::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0044");
	}



CCTSYIntegrationTestCallControl0045::CCTSYIntegrationTestCallControl0045(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0045::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0045::~CCTSYIntegrationTestCallControl0045()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0045::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0045
 * @SYMFssID BA/CTSY/CCON-0045
 * @SYMTestCaseDesc Terminate all calls when there are outgoing calls.
 * @SYMTestPriority High
 * @SYMTestActions RLine::NotifyStatusChange, RMobileLine::NotifyMobileLineStatusChange, RMobileCall::GetMobileCallStatus, RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange, RLine::GetStatus, RMobileLine::GetMobileLineStatus, RMobilePhone::TerminateAllCalls, RCall::GetStatus
 * @SYMTestExpectedResults Pass - KErrNotSupported.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call and line statuses.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Check phone supports KCapsVoice.
    RMobilePhone::TCaps lineCaps; 
	CHECK_EQUALS_L(phone.GetCaps(lineCaps), KErrNone, _L("RMobilePhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RMobilePhone::KCapsVoice, KNoUnwantedBits, _L("RMobilePhone::GetCaps did not return KCapsVoice as expected"));

	// Get Voice line 1. 
    RMobileLine& mobileLine1 = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1. 
    RMobileCall& mobileCall1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// Get Voice line 2. 
	RMobileLine& mobileLine2 = iEtelSessionMgr.GetLineL(KAltServer, KMainPhone, KVoiceLine);

	// Get call 2. 
	RMobileCall& mobileCall2 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall2);

    // Get phone numbers
    TPtrC callNumber;
	CHECK_TRUE_L(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, callNumber) != EFalse, _L("GetStringFromConfig did not complete as expected"));
    
    TPtrC callNumber2;
	CHECK_TRUE_L(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber2, callNumber2) != EFalse, _L("GetStringFromConfig did not complete as expected"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Dial a number that answers on call 1. 
	TCoreEtelRequestStatus<RMobileCall> getDialStatus(mobileCall1, &RMobileCall::DialCancel);
	CleanupStack::PushL(getDialStatus);
	
	mobileCall1.Dial(getDialStatus, callNumber); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(getDialStatus, ETimeLong), KErrNone, _L("RMobileCall::Dial timed-out"));
	ASSERT_EQUALS(getDialStatus.Int(), KErrNone, _L("RMobileCall::Dial returned error"));

	// Dial a number that answers on call 2. 
	TCoreEtelRequestStatus<RMobileCall> getDialStatus2(mobileCall2, &RMobileCall::DialCancel);
	CleanupStack::PushL(getDialStatus2);
	
	mobileCall2.Dial(getDialStatus2, callNumber2); 
	ASSERT_EQUALS(WaitForRequestWithTimeOut(getDialStatus2, ETimeLong), KErrNone, _L("RMobileCall::Dial timed-out"));
	ASSERT_EQUALS(getDialStatus2.Int(), KErrNone, _L("RMobileCall::Dial returned error"));

    // Post notifiers line
    RMobileCall::TMobileCallStatus mobileLineStatus;
	TExtEtelRequestStatus notifyMobileLineChangeStatus(mobileLine1, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	mobileLine1.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);

	RCall::TStatus lineStatus;
	TCoreEtelRequestStatus<RLine> notifyLineChangeStatus(mobileLine1, &RLine::NotifyStatusChangeCancel);
    CleanupStack::PushL(notifyLineChangeStatus);
	mobileLine1.NotifyStatusChange(notifyLineChangeStatus, lineStatus);

	RMobileCall::TMobileCallStatus mobileLineStatus2;
	TExtEtelRequestStatus notifyMobileLineChangeStatus2(mobileLine2, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus2);
	mobileLine2.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus2, mobileLineStatus2);	

	RCall::TStatus lineStatus2;
	TCoreEtelRequestStatus<RLine> notifyLineChangeStatus2(mobileLine2, &RLine::NotifyStatusChangeCancel);
    CleanupStack::PushL(notifyLineChangeStatus2);
	mobileLine2.NotifyStatusChange(notifyLineChangeStatus2, lineStatus2);	

	// Post notifiers call
    RMobileCall::TMobileCallStatus mobileCallStatus;
    TExtEtelRequestStatus notifyMobileCallChangeStatus(mobileCall1, EMobileCallNotifyMobileCallStatusChange);
    CleanupStack::PushL(notifyMobileCallChangeStatus);
    mobileCall1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

    RCall::TStatus callStatus;
    TCoreEtelRequestStatus<RCall> notifyCallChangeStatus(mobileCall1, &RCall::NotifyStatusChangeCancel);
    CleanupStack::PushL(notifyCallChangeStatus);
	mobileCall1.NotifyStatusChange(notifyCallChangeStatus, callStatus);
    
    RMobileCall::TMobileCallStatus mobileCallStatus2;
    TExtEtelRequestStatus notifyMobileCallChangeStatus2(mobileCall2, EMobileCallNotifyMobileCallStatusChange);
    CleanupStack::PushL(notifyMobileCallChangeStatus2);
    mobileCall2.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus2, mobileCallStatus2);	

    RCall::TStatus callStatus2;
    TCoreEtelRequestStatus<RCall> notifyCallChangeStatus2(mobileCall2, &RCall::NotifyStatusChangeCancel);
    CleanupStack::PushL(notifyCallChangeStatus2);
    mobileCall2.NotifyStatusChange(notifyCallChangeStatus2, callStatus2);

	// Terminate all calls with RMobilePhone::TerminateAllCalls 
	ERR_PRINTF1(_L("<font color=Orange>$CTSYProblem: RMobilePhone::TerminateAllCalls is not supported by CTSY, checked for KErrNotSupported instead of KErrNone.</font>"));
	TExtEtelRequestStatus getTerminateAllCallsStatus(phone, EMobilePhoneTerminateAllCallsCancel);
    CleanupStack::PushL(getTerminateAllCallsStatus);
	phone.TerminateAllCalls(getTerminateAllCallsStatus);
    ASSERT_EQUALS(WaitForRequestWithTimeOut(getTerminateAllCallsStatus, ETimeLong), KErrNone, _L("RMobilePhone::TerminateAllCalls timed-out"));
    ASSERT_EQUALS(getTerminateAllCallsStatus.Int(), KErrNotSupported, _L("RMobileCall::TerminateAllCalls returned with an error"));

	// ===  Check line status for calls 1 and 2 ===

	// Check RLine::NotifyStatusChange for call 1 completes with EStatusHangingUp -> EStatusIdle

	// Check RLine::GetStatus for call 1 returns EStatusIdle

	// Check RMobileLine::NotifyMobileLineStatusChange for call 1 completes with EStatusDisconnecting -> EStatusIdle

	// Check RMobileLine::GetMobileLineStatus for call 1 returns EStatusIdle

	// Check RLine::NotifyStatusChange for call 2 completes with EStatusHangingUp -> EStatusIdle

	// Check RLine::GetStatus for call 2 returns EStatusIdle

	// Check RMobileLine::NotifyMobileLineStatusChange for call 2 completes with EStatusDisconnecting -> EStatusIdle

	// Check RMobileLine::GetMobileLineStatus for call 2 returns EStatusIdle

	// ===  Check call status for calls 1 and 2 ===

	// Check RCall::NotifyStatusChange for call 1 completes with EStatusHangingUp -> EStatusIdle.

	// Check RCall::GetStatus for call 1 returns EStatusIdle.

	// Check RMobileCall::NotifyMobileCallStatusChange for call 1 completes with EStatusDisconnecting -> EStatusIdle.

	// Check RMobileCall::GetMobileCallStatus for call 1 returns status of EStatusIdle.

	// Check RCall::NotifyStatusChange for call 2 completes with EStatusHangingUp -> EStatusIdle.

	// Check RCall::GetStatus for call 2 returns EStatusIdle.

	// Check RMobileCall::NotifyMobileCallStatusChange for call 2 completes with EStatusDisconnecting -> EStatusIdle.

	// Check RMobileCall::GetMobileCallStatus for call 2 returns status of EStatusIdle.


	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Hangup calls
	mobileCall2.HangUp();
	mobileCall1.HangUp();
	
	// Pop
	// getDialStatus
	// getDialStatus2
	// notifyMobileLineChangeStatus
	// notifyLineChangeStatus
	// notifyMobileLineChangeStatus2
	// notifyLineChangeStatus2
	// notifyMobileCallChangeStatus
	// notifyCallChangeStatus
	// notifyMobileCallChangeStatus2
	// notifyCallChangeStatus2
	// getTerminateAllCallsStatus
	CleanupStack::Pop(11, &getDialStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0045::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0045");
	}



CCTSYIntegrationTestCallControl0046::CCTSYIntegrationTestCallControl0046(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0046::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0046::~CCTSYIntegrationTestCallControl0046()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0046::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0046
 * @SYMFssID BA/CTSY/CCON-0046
 * @SYMTestCaseDesc Terminate all calls where there are incoming calls.
 * @SYMTestPriority High
 * @SYMTestActions RCall::AnswerIncomingCall, RMobileCall::Hold, RLine::NotifyStatusChange, RMobileLine::NotifyMobileLineStatusChange, RMobileCall::GetMobileCallStatus, RCall::NotifyStatusChange, RMobileCall::NotifyMobileCallStatusChange, RLine::GetStatus, RMobileLine::GetMobileLineStatus, RMobilePhone::TerminateAllCalls, RCall::GetStatus
 * @SYMTestExpectedResults Pass - Calls terminated.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call and line statuses.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	// Check phone supports KCapsVoice.
	RMobilePhone::TCaps lineCaps; 
	CHECK_EQUALS_L(phone.GetCaps(lineCaps), KErrNone, _L("RMobilePhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RMobilePhone::KCapsVoice, KNoUnwantedBits, _L("RMobilePhone::GetCaps did not return KCapsVoice as expected"));

	// Get Voice line 1. 
	RMobileLine& mobileLine1 = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1. 
	RMobileCall& mobileCall1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	// Get Voice line 2. 
	RMobileLine& mobileLine2 = iEtelSessionMgr.GetLineL(KAltServer, KMainPhone, KVoiceLine);

	// Get call 2. 
	RMobileCall& mobileCall2 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall2);


	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////

	// Post notification RCall::NotifyIncomingCall for Line1
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus(mobileLine1, &RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus);
	TName name;
	mobileLine1.NotifyIncomingCall(notifyIncomingCallStatus, name);	
	
	// Request incoming call from RPS. 
	ASSERT_EQUALS(RPSRequestIncomingCallL(EVoiceLine), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSRequestIncomingCallL returned an error"));
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus,ETimeMedium),KErrNone, 
		_L("RLine::NotifyIncomingCall did not complete without error"));
	ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone,  
		_L("RLine::NotifyIncomingCall set requestStatus to an error"));
	
	// Get the incoming call
	TCallId incomingCallId;
	mobileCall1 = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, name, incomingCallId);

	// Answer call on call 1. 
	TCoreEtelRequestStatus<RMobileCall> answerIncomingMCallStatus1(mobileCall1, &RMobileCall::AnswerIncomingCallCancel);
	CleanupStack::PushL(answerIncomingMCallStatus1);
    mobileCall1.AnswerIncomingCall(answerIncomingMCallStatus1);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(answerIncomingMCallStatus1, ETimeMedium), KErrNone, _L("RMobileCall::AnswerIncomingCall timed-out"))
	ASSERT_EQUALS(answerIncomingMCallStatus1.Int(), KErrNone, _L("RMobileCall::AnswerIncomingCall returned with an error"))

	// Hold call 1. 
	TExtEtelRequestStatus getHoldStatus(mobileCall1, EMobileCallHold);
	CleanupStack::PushL(getHoldStatus);
	mobileCall1.Hold(getHoldStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(getHoldStatus, ETimeMedium), KErrNone, _L("RMobileCall::Hold timed-out"));
	ASSERT_EQUALS(getHoldStatus.Int(), KErrNone, _L("RMobileCall::Hold returned with error"));

	// Post notification RCall::NotifyIncomingCall for Line2
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus2(mobileLine2, &RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus2);
	TName name2;
	mobileLine2.NotifyIncomingCall(notifyIncomingCallStatus2, name2);	
	
	// Request another incoming call from RPS. 
	ASSERT_EQUALS(RPSRequestIncomingCallL(EVoiceLine), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSRequestIncomingCallL returned an error"));

	// Tester should have "Call waiting" activated on SIM. Otherwise will fail.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus2,ETimeLong),KErrNone, _L("RLine::NotifyIncomingCall did not complete without error"));
	ASSERT_EQUALS(notifyIncomingCallStatus2.Int(), KErrNone,  _L("RLine::NotifyIncomingCall set requestStatus to an error"));
	
	// Get the incoming call
	TCallId incomingCallId2;
	mobileCall2 = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, name2, incomingCallId2);

	// Answer call on call 2. 
	TCoreEtelRequestStatus<RMobileCall> answerIncomingMCallStatus2(mobileCall2, &RMobileCall::AnswerIncomingCallCancel);
	CleanupStack::PushL(answerIncomingMCallStatus2);
    mobileCall2.AnswerIncomingCall(answerIncomingMCallStatus2);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(answerIncomingMCallStatus2, ETimeMedium), KErrNone, _L("RMobileCall::AnswerIncomingCall timed-out"))
	ASSERT_EQUALS(answerIncomingMCallStatus2.Int(), KErrNone, _L("RMobileCall::AnswerIncomingCall returned with an error"))

    // Post notifiers line
    RMobileCall::TMobileCallStatus mobileLineStatus;
	TExtEtelRequestStatus notifyMobileLineChangeStatus(mobileLine1, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	mobileLine1.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);

	RCall::TStatus lineStatus;
	TCoreEtelRequestStatus<RLine> notifyLineChangeStatus(mobileLine1, &RLine::NotifyStatusChangeCancel);
    CleanupStack::PushL(notifyLineChangeStatus);
	mobileLine1.NotifyStatusChange(notifyLineChangeStatus, lineStatus);

	RMobileCall::TMobileCallStatus mobileLineStatus2;
	TExtEtelRequestStatus notifyMobileLineChangeStatus2(mobileLine2, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus2);
	mobileLine2.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus2, mobileLineStatus2);	

	RCall::TStatus lineStatus2;
	TCoreEtelRequestStatus<RLine> notifyLineChangeStatus2(mobileLine2, &RLine::NotifyStatusChangeCancel);
    CleanupStack::PushL(notifyLineChangeStatus2);
	mobileLine2.NotifyStatusChange(notifyLineChangeStatus2, lineStatus2);	

	// Post notifiers call
    RMobileCall::TMobileCallStatus mobileCallStatus;
    TExtEtelRequestStatus notifyMobileCallChangeStatus(mobileCall1, EMobileCallNotifyMobileCallStatusChange);
    CleanupStack::PushL(notifyMobileCallChangeStatus);
    mobileCall1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);

    RCall::TStatus callStatus;
    TCoreEtelRequestStatus<RCall> notifyCallChangeStatus(mobileCall1, &RCall::NotifyStatusChangeCancel);
    CleanupStack::PushL(notifyCallChangeStatus);
	mobileCall1.NotifyStatusChange(notifyCallChangeStatus, callStatus);
    
    RMobileCall::TMobileCallStatus mobileCallStatus2;
    TExtEtelRequestStatus notifyMobileCallChangeStatus2(mobileCall2, EMobileCallNotifyMobileCallStatusChange);
    CleanupStack::PushL(notifyMobileCallChangeStatus2);
    mobileCall2.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus2, mobileCallStatus2);	

    RCall::TStatus callStatus2;
    TCoreEtelRequestStatus<RCall> notifyCallChangeStatus2(mobileCall2, &RCall::NotifyStatusChangeCancel);
    CleanupStack::PushL(notifyCallChangeStatus2);
    mobileCall2.NotifyStatusChange(notifyCallChangeStatus2, callStatus2);

	// Terminate all calls with RMobilePhone::TerminateAllCalls 
	TExtEtelRequestStatus getTerminateAllCallsStatus(phone, EMobilePhoneTerminateAllCallsCancel);
    CleanupStack::PushL(getTerminateAllCallsStatus);
	phone.TerminateAllCalls(getTerminateAllCallsStatus);

	// CTSYProblem CTSY is not supporting EMobilePhoneTerminateAllCalls IPC and test returns -5(KErrNotsuppported)
	// Rest of test is not tested before EMobilePhoneTerminateAllCalls IPC support is added
    ASSERT_EQUALS(WaitForRequestWithTimeOut(getTerminateAllCallsStatus, ETimeLong), KErrNone, _L("RMobilePhone::TerminateAllCalls timed-out"));
    ASSERT_EQUALS(getTerminateAllCallsStatus.Int(), KErrNone, _L("RMobileCall::TerminateAllCalls returned with an error"))

	// ===  Check line status for calls 1 and 2 ===

	// Check RLine::NotifyStatusChange for call 1 completes with EStatusHangingUp -> EStatusIdle
	const TInt expectedStatus = KErrNone;
	RCall::TStatus expectedCallStatus = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(mobileLine1, notifyLineChangeStatus, lineStatus, expectedCallStatus, expectedStatus);
	expectedCallStatus = RCall::EStatusIdle;
	mobileLine1.NotifyStatusChange(notifyLineChangeStatus, lineStatus);	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(mobileLine1, notifyLineChangeStatus, lineStatus, expectedCallStatus, expectedStatus);

	// Check RLine::GetStatus for call 1 returns EStatusIdle
	ASSERT_EQUALS(mobileLine1.GetStatus(lineStatus), KErrNone, _L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle, _L("RLine::GetStatus did not EStatusIdle return as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange for call 1 completes with EStatusDisconnecting -> EStatusIdle
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(mobileLine1, notifyMobileLineChangeStatus, mobileLineStatus, expectedMobileCallStatus, expectedStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;	
	mobileLine1.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(mobileLine1, notifyMobileLineChangeStatus, mobileLineStatus, expectedMobileCallStatus, expectedStatus);

	// Check RMobileLine::GetMobileLineStatus for call 1 returns EStatusIdle
	ASSERT_EQUALS(mobileLine1.GetStatus(lineStatus), KErrNone, _L("RMobileLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle, _L("RMobileLine::GetStatus did not return EStatusIdle as expected"));

	// Check RLine::NotifyStatusChange for call 2 completes with EStatusHangingUp -> EStatusIdle
	RCall::TStatus expectedCallStatus2 = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(mobileLine2, notifyLineChangeStatus2, lineStatus2, expectedCallStatus2, expectedStatus);
	expectedCallStatus2 = RCall::EStatusIdle;	
	mobileLine2.NotifyStatusChange(notifyLineChangeStatus2, lineStatus2);	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(mobileLine2, notifyLineChangeStatus2, lineStatus2, expectedCallStatus2, expectedStatus);

	// Check RLine::GetStatus for call 2 returns EStatusIdle
	ASSERT_EQUALS(mobileLine2.GetStatus(lineStatus2), KErrNone, _L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus2, RCall::EStatusIdle, _L("RLine::GetStatus did not EStatusIdle return as expected"));

	// Check RMobileLine::NotifyMobileLineStatusChange for call 2 completes with EStatusDisconnecting -> EStatusIdle
	RMobileCall::TMobileCallStatus expectedMobileCallStatus2 = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(mobileLine2, notifyMobileLineChangeStatus2, mobileLineStatus2, expectedMobileCallStatus2, expectedStatus);
	expectedMobileCallStatus2 = RMobileCall::EStatusIdle;	
	mobileLine2.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus2, mobileLineStatus2);	
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(mobileLine2, notifyMobileLineChangeStatus2, mobileLineStatus2, expectedMobileCallStatus2, expectedStatus);

	// Check RMobileLine::GetMobileLineStatus for call 2 returns EStatusIdle
	ASSERT_EQUALS(mobileLine2.GetStatus(lineStatus2), KErrNone, _L("RMobileLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus2, RCall::EStatusIdle, _L("RMobileLine::GetStatus did not return EStatusIdle as expected"));

	// ===  Check call status for calls 1 and 2 ===

	// Check RCall::NotifyStatusChange for call 1 completes with EStatusHangingUp -> EStatusIdle.
	RCall::TStatus expectedCallStatus3 = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(mobileCall1, notifyCallChangeStatus, callStatus, expectedCallStatus3, expectedStatus);
	expectedCallStatus3 = RCall::EStatusIdle;	
	mobileCall1.NotifyStatusChange(notifyCallChangeStatus, callStatus);
	iCallControlTestHelper.WaitForCallNotifyStatusChange(mobileCall1, notifyCallChangeStatus, callStatus, expectedCallStatus3, expectedStatus);

	// Check RCall::GetStatus for call 1 returns EStatusIdle.
	ASSERT_EQUALS(mobileCall1.GetStatus(callStatus), KErrNone, _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle, _L("RCall::GetStatus did not EStatusIdle return as expected"));

	// Check RMobileCall::NotifyMobileCallStatusChange for call 1 completes with EStatusDisconnecting -> EStatusIdle.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus3 = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(mobileCall1, notifyMobileCallChangeStatus, mobileCallStatus, expectedMobileCallStatus3, expectedStatus);
	expectedMobileCallStatus3 = RMobileCall::EStatusIdle;
	mobileCall1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(mobileCall1, notifyMobileCallChangeStatus, mobileCallStatus, expectedMobileCallStatus3, expectedStatus);

	// Check RMobileCall::GetMobileCallStatus for call 1 returns status of EStatusIdle.
    ASSERT_EQUALS(mobileCall1.GetStatus(callStatus), KErrNone, _L("RMobileCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle, _L("RMobileCall::GetStatus did not return EStatusIdle as expected"));

	// Check RCall::NotifyStatusChange for call 2 completes with EStatusHangingUp -> EStatusIdle.
	RCall::TStatus expectedCallStatus4 = RCall::EStatusHangingUp;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(mobileCall2, notifyCallChangeStatus2, callStatus2, expectedCallStatus4, expectedStatus);
	expectedCallStatus4 = RCall::EStatusIdle;	
	mobileCall2.NotifyStatusChange(notifyCallChangeStatus2, callStatus2);
	iCallControlTestHelper.WaitForCallNotifyStatusChange(mobileCall2, notifyCallChangeStatus2, callStatus2, expectedCallStatus4, expectedStatus);

	// Check RCall::GetStatus for call 2 returns EStatusIdle.
	ASSERT_EQUALS(mobileCall2.GetStatus(callStatus2), KErrNone, _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus2, RCall::EStatusIdle, _L("RCall::GetStatus did not EStatusIdle return as expected"));

	// Check RMobileCall::NotifyMobileCallStatusChange for call 2 completes with EStatusDisconnecting -> EStatusIdle.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus4 = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(mobileCall2, notifyMobileCallChangeStatus2, mobileCallStatus2, expectedMobileCallStatus4, expectedStatus);
	expectedMobileCallStatus3 = RMobileCall::EStatusIdle;
	mobileCall2.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus2, mobileCallStatus2);	
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(mobileCall2, notifyMobileCallChangeStatus2, mobileCallStatus2, expectedMobileCallStatus4, expectedStatus);

	// Check RMobileCall::GetMobileCallStatus for call 2 returns status of EStatusIdle.
	ASSERT_EQUALS(mobileCall2.GetStatus(callStatus2), KErrNone, _L("RMobileCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus2, RCall::EStatusIdle, _L("RMobileCall::GetStatus did not return EStatusIdle as expected"));

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
   	
	// Pop
	// notifyIncomingCallStatus
	// answerIncomingMCallStatus1
	// getHoldStatus
	// notifyIncomingCallStatus2
	// answerIncomingMCallStatus2
	// notifyMobileLineChangeStatus
	// notifyLineChangeStatus
	// notifyMobileLineChangeStatus2
	// notifyLineChangeStatus2
	// notifyMobileCallChangeStatus
	// notifyCallChangeStatus
    // notifyMobileCallChangeStatus2
	// notifyCallChangeStatus2
	// getTerminateAllCallsStatus
	CleanupStack::PopAndDestroy(14, &notifyIncomingCallStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0046::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0046");
	}



CCTSYIntegrationTestCallControl0047::CCTSYIntegrationTestCallControl0047(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0047::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0047::~CCTSYIntegrationTestCallControl0047()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0047::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0047
 * @SYMFssID BA/CTSY/CCON-0047
 * @SYMTestCaseDesc Dial a call using RMobileCall::DialISV
 * @SYMTestPriority High
 * @SYMTestActions RLine::NotifyStatusChange,
 *                 RMobileLine::NotifyMobileLineStatusChange,
 *                 RLine::GetCallInfo, RLine::GetCaps,
 *                 RMobileCall::DialISV, RLine::GetStatus,
 *                 RMobileLine::GetMobileLineStatus,
 *                 RLine::GetInfo, RLine::EnumerateCall
 * @SYMTestExpectedResults Pass - Call connects and line status,
 *                         line caps correct.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify change in line state is reflected in RLine and RMobileLine
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits,  _L("RPhone::GetCaps returned wrong caps"));

	// Get Voice line 1. 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	
	// Get call 1. 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);


	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// ===  Check line caps ===

	// Check RLine::GetCaps supports caps in set of KCapsVoice.
	RLine::TCaps lineCaps; 
	ASSERT_EQUALS(voiceLine.GetCaps(lineCaps), KErrNone, _L("RLine::GetCaps returned an error"));
	ASSERT_BITS_SET(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  _L("RLine::GetCaps returned wrong caps"));

	// ===  Check line status ===

	// Check RLine::GetStatus returns EStatusIdle.
	RCall::TStatus lineStatus; 
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone, _L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle, _L("RLine::GetStatus returned wrong status"));

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle.
	RMobileCall::TMobileCallStatus mobilelineStatus;
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobilelineStatus), KErrNone, 
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobilelineStatus, RMobileCall::EStatusIdle, 
	        _L("RMobileLine::GetMobileLineStatus did not return EStatusIdle as expected"));

	// ===  Check line info ===

	// Check RLine::GetCallInfo returns valid name.
	RLine::TCallInfo callInfo;
	ASSERT_EQUALS(voiceLine.GetCallInfo( KCall1, callInfo), KErrNone, _L("RLine::GetCallInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() > 0, _L("RLine::GetCallInfo returned invalid iCallName"));
	
	// Check RLine::GetCallInfo returns caps in set of KCapsVoice | KCapsDial.
	// $CTSYProblem.  CTSY is not either completing CapsChanges or/and test suite does not get them correctly hence wrong caps are returned
	// Got 0xc , required 0x4c
	// KCapsVoice=0x00000004 and KCapsDial=0x00000008 are OK but KCapsAnswer=0x00000040 is missing.
	// Changed original test step to check RLine::GetCallInfo returns caps in set of KCapsVoice | KCapsDial instead of KCapsVoice | KCapsDial | KCapsAnswer.
	TUint expectedCallCapsFlags = RCall::KCapsVoice | RCall::KCapsDial;
	ASSERT_BITS_SET(callInfo.iCallCapsFlags, expectedCallCapsFlags, KNoUnwantedBits, _L("RLine::GetCallInfo returned wrong caps"));	
			
	// Check RLine::GetCallInfo returns status of EStatusIdle.
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusIdle, _L("RLine::GetCallInfo wrong iStatus, should be EStatusIdle"));

	// Check RLine::GetInfo returns status of EStatusIdle.
	RLine::TLineInfo lineInfo;
	ASSERT_EQUALS(voiceLine.GetInfo(lineInfo),KErrNone, _L("RLine::GetInfo returned an error")); 
	ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusIdle, _L("RLine::GetInfo did not return iStatus EStatusIdle"));

	// Post RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus(voiceLine, &RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	
	// Post RLine::NotifyMobileLineStatusChange
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);	
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobilelineStatus);
	
	// Dial a number that answers using RMobileCall::DialISV
	TPtrC number;
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse, _L("CTestStep::GetStringFromConfig did not complete as expected"));
	TExtEtelRequestStatus dialStatus(call1, EMobileCallDialISV);
	CleanupStack::PushL(dialStatus);	
	RMobileCall::TEtel3rdPartyMobileCallParamsV1 callParams;
	RMobileCall::TEtel3rdPartyMobileCallParamsV1Pckg callParamsPckg(callParams);
	DEBUG_PRINTF1(_L("Board Now Dialling... "));	
	call1.DialISV(dialStatus, callParamsPckg, number);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, _L("RMobileCall::DialISV timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone, _L("RMobileCall::DialISV returned with an error"));
	
	// ===  Check line status ===
	
	// Check RLine::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	TInt wantedStatus = KErrNone;
	RCall::TStatus expectedLineStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 wantedStatus);

    voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedLineStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 wantedStatus);
														 
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedLineStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 wantedStatus);

	// Check RLine::GetStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone, _L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusConnected, _L("RLine::GetStatus did not return EStatusConnected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobilelineStatus,
																		expectedMobileLineStatus,
																		wantedStatus);
																		
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobilelineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobilelineStatus,
																		expectedMobileLineStatus,
																		wantedStatus);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobilelineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobilelineStatus,
																		expectedMobileLineStatus,
																		wantedStatus);
	
	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobilelineStatus), KErrNone, 
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobilelineStatus, RMobileCall::EStatusConnected, 
			_L("RMobileLine::GetMobileLineStatus did not set line status to EStatusConnected"));

	// ===  Check line info ===

	// Check RLine::GetCallInfo returns valid name.
	ASSERT_EQUALS(voiceLine.GetCallInfo( KCall1, callInfo), KErrNone, _L("RLine::GetCallInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length()>0, _L("RLine::GetCallInfo returned invalid iCallName"));	

	// Check RLine::GetCallInfo returns caps in set of KCapsHangUp.
	expectedCallCapsFlags = RCall::KCapsHangUp;
	ASSERT_BITS_SET(callInfo.iCallCapsFlags, expectedCallCapsFlags, KNoUnwantedBits, _L("RLine::GetCallInfo returned wrong caps"));		
	
	// Check RLine::GetCallInfo returns status of EStatusConnected.
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected, _L("RLine::GetCallInfo returned wrong iStatus, should be EStatusConnected"));

	// Check RLine::GetInfo returns status of EStatusConnected.
	ASSERT_EQUALS(voiceLine.GetInfo(lineInfo),KErrNone, _L("RLine::GetInfo returned an error")); 
	ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusConnected, _L("RLine::GetInfo did not return EStatusConnected"));
	
	// Check RLine::EnumerateCall returns 2.
	TInt numberOfCalls = 0;
	TInt wantedNumberOfCalls = 2;
	ASSERT_EQUALS(voiceLine.EnumerateCall(numberOfCalls), KErrNone, _L("RLine::EnumerateCall returned an error.")); 
	ASSERT_EQUALS(numberOfCalls, wantedNumberOfCalls, _L("RLine::EnumerateCall returned wrong number of calls."));
	
	// Hang up call 1 
	TCoreEtelRequestStatus<RCall>hangupStatus(call1, &RCall::HangUpCancel);
	CleanupStack::PushL(hangupStatus);
	call1.HangUp(hangupStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangupStatus, ETimeMedium), KErrNone, _L("RMobileCall::HangUp timed-out"));
	ASSERT_EQUALS(hangupStatus.Int(), KErrNone, _L("RMobileCall::HangUp returned error"));

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus
	// dialStatus
	// hangupStatus
	CleanupStack::PopAndDestroy(4, &notifyStatusChangeStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0047::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0047");
	}



CCTSYIntegrationTestCallControl0048::CCTSYIntegrationTestCallControl0048(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0048::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0048::~CCTSYIntegrationTestCallControl0048()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0048::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0048
 * @SYMFssID BA/CTSY/CCON-0048
 * @SYMTestCaseDesc Dial a call using RMobileCall::DialISV
 * @SYMTestPriority High
 * @SYMTestActions RCall::GetCaps,
 *                 RMobileCall::NotifyMobileCallCapsChange,
 *                 RMobileCall::GetMobileCallStatus,
 *                 RMobileCall::GetMobileCallInfo,
 *                 RMobileCall::NotifyMobileCallStatusChange,
 *                 RCall::NotifyStatusChange, RCall::GetInfo,
 *                 RMobileCall::DialISV,
 *                 RCall::NotifyCapsChange, RCall::GetStatus,
 *                 RMobileCall::GetMobileCallCaps
 * @SYMTestExpectedResults Pass - Call connects and call status, caps and info correct.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify change in call state is reflected in RCall and RMobileCall
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////


	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits,  _L("RPhone::GetCaps returned wrong caps"));

	// Get Voice line 1. 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1. 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);


	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// ===  Check call caps ===

	// Check RCall::GetCaps supports KCapsDial | KCapsVoice.
	RCall::TCaps callCaps;
	TUint32 wantedCaps = RCall::KCapsDial | RCall::KCapsVoice;
	ASSERT_EQUALS(call1.GetCaps(callCaps), KErrNone, _L("RCall::GetCaps returned an error"));
	ASSERT_BITS_SET(callCaps.iFlags, wantedCaps, KNoUnwantedBits, _L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::GetMobileCallCaps returns iCallControlCaps in set of KCapsVoice | KCapsDial.
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of 0.
	TUint32 wantedCallControlCaps = RCall::KCapsDial | RCall::KCapsVoice;
	TUint32 wantedCallEventCaps = 0;
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg capsPckg(mobileCallCaps);
	ASSERT_EQUALS(call1.GetMobileCallCaps(capsPckg), KErrNone, _L("RMobileCall::GetMobileCallCaps returned an error"));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedCallControlCaps, KNoUnwantedBits, _L("RMobileCall::GetMobileCallCaps returned wrong caps"));
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedCallEventCaps, KNoUnwantedBits, _L("RMobileCall::GetMobileCallCaps returned wrong caps"));

	// ===  Check call status ===

	// Check RCall::GetStatus returns EStatusIdle.
	RCall::TStatus callStatus;
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone, _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusIdle, _L("RCall::GetStatus did not return EStatusIdle"));
	
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	RMobileCall::TMobileCallStatus mobileCallStatus;
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle, _L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));

	// ===  Check call info ===

	// Check RCall::GetInfo returns valid call name.
	// Check RCall::GetInfo returns valid voice line name.
	// Check RCall::GetInfo returns call status of EStatusIdle.
	// Check RCall::GetInfo returns call duration of 0.
	RCall::TCallInfo callInfo;
	ASSERT_EQUALS(call1.GetInfo(callInfo), KErrNone, _L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() > 0, _L("RCall::GetInfo returned an invalid call name"));
	ASSERT_TRUE(callInfo.iLineName.Length() > 0,_L("RCall::GetInfo returned an invalid  line name"));
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusIdle, _L("RCall::GetInfo returned wrong status, should be EStatusIdle"));
	ASSERT_EQUALS(callInfo.iDuration.Int(), 0, _L("RCall::GetInfo returned a duration other than 0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid with correct flags for returned parameters set.
	RMobileCall::TMobileCallInfoV1 mobileCallInfo;
	RMobileCall::TMobileCallInfoV1Pckg callInfoPckg(mobileCallInfo);
	ASSERT_EQUALS(call1.GetMobileCallInfo(callInfoPckg), KErrNone, _L("RMobileCall::GetMobileCallInfo returned an error"));
	iCallControlTestHelper.CheckForValidCallInfo(mobileCallInfo, KErrNone, EFalse);

	// Check RMobileCall::GetMobileCallInfo returns valid call name.
	ASSERT_TRUE(mobileCallInfo.iCallName.Length() > 0, _L("RMobileCall::GetMobileCallInfo returned an invalid call name"));
	
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() > 0, _L("RMobileCall::GetMobileCallInfo returned an invalid line name"));

	// post notifier RCall::NotifyCapsChange for call1
	TCoreEtelRequestStatus<RCall> notifyCapsChangeStatus (call1, &RCall::NotifyCapsChangeCancel);	
	CleanupStack::PushL(notifyCapsChangeStatus);
	call1.NotifyCapsChange(notifyCapsChangeStatus, callCaps);

	// post notifier for RMobileCall::NotifyMobileCallCapsChange
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus(call1, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus);
	RMobileCall::TMobileCallCapsV1 notifyMobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg notifymobileCallCapsPckg(notifyMobileCallCaps);
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, notifymobileCallCapsPckg);
	
	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyStatusChangeStatus (call1, &RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus notifyCallStatus;
	call1.NotifyStatusChange(notifyStatusChangeStatus, notifyCallStatus);
	
	// Post notifiers call
    RMobileCall::TMobileCallStatus notifyMobileCallStatus;
    TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
    CleanupStack::PushL(notifyMobileCallChangeStatus);
    call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, notifyMobileCallStatus);
	
	// Dial a number that answers using RMobileCall::DialISV 
	TExtEtelRequestStatus dialStatus(call1, EMobileCallDialISV);
	CleanupStack::PushL(dialStatus);
	TPtrC number;
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse, _L("CTestStep::GetStringFromConfig did not complete as expected"));	
	RMobileCall::TEtel3rdPartyMobileCallParamsV1 callParams;
	RMobileCall::TEtel3rdPartyMobileCallParamsV1Pckg callParamsPckg(callParams);
	call1.DialISV(dialStatus, callParamsPckg, number);
	DEBUG_PRINTF1(_L("Board Now Dialling... "));
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, _L("RMobileCall::DialISV timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone, _L("RMobileCall::DialISV returned with an error"));	

	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsHangUp.
	RCall::TCaps wantedNotifyCaps, unwantedNotifyCaps;
	wantedNotifyCaps.iFlags = RCall::KCapsVoice | RCall::KCapsHangUp;
	unwantedNotifyCaps.iFlags = 0;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyCapsChange(call1, 
													   notifyCapsChangeStatus,
													   callCaps,
													   wantedNotifyCaps,
													   unwantedNotifyCaps,
													   wantedStatus);

	// Check RCall::GetCaps supports KCapsHangUp | KCapsVoice.
	TUint32 wantedCallCaps = RCall::KCapsHangUp | RCall::KCapsVoice;
	ASSERT_EQUALS(call1.GetCaps(callCaps),KErrNone, _L("RCall::GetCaps returned an error"));
	ASSERT_BITS_SET(callCaps.iFlags, wantedCallCaps, KNoUnwantedBits, _L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp | KCapsTransfer.
	RMobileCall::TMobileCallCapsV1 wantedMobileCaps;
	TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps,mobileCallCaps, *this);								
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | 
										RMobileCall::KCapsHold | 
										RMobileCall::KCapsHangUp | 
										RMobileCall::KCapsTransfer;
        
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
   	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | 
									  RMobileCall::KCapsLocalTransfer | 
									  RMobileCall::KCapsRemoteHold | 
									  RMobileCall::KCapsRemoteTerminate | 
									  RMobileCall::KCapsRemoteConferenceCreate;

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp
  	RMobileCall::TMobileCallCapsV1Pckg mobileCallCapsPckg(mobileCallCaps);	
    TUint32 wantedMobileCallCaps = RMobileCall::KCapsVoice |
	    							RMobileCall::KCapsHold |
									RMobileCall::KCapsHangUp; 
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone, _L("RMobileCall::GetMobileCallCaps returned an error"));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCallCaps, KNoUnwantedBits, _L("RMobileCall::GetMobileCallCaps returned wrong caps"));
	
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	TUint32 wantedMobileCallEventCaps = RMobileCall::KCapsLocalHold |
								  RMobileCall::KCapsLocalTransfer |
								  RMobileCall::KCapsRemoteHold | 
								  RMobileCall::KCapsRemoteTerminate |
								  RMobileCall::KCapsRemoteConferenceCreate;
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCallEventCaps, KNoUnwantedBits,   
			_L("RMobileCall::GetMobileCallCaps returned wrong caps"));

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RCall::TStatus expectedCallStatus = RCall::EStatusDialling;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 notifyCallStatus,
														 expectedCallStatus,
														 wantedStatus);
														 
	call1.NotifyStatusChange(notifyStatusChangeStatus, notifyCallStatus);
	expectedCallStatus = RCall::EStatusConnecting;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 notifyCallStatus,
														 expectedCallStatus,
														 wantedStatus);
														 
	call1.NotifyStatusChange(notifyStatusChangeStatus, notifyCallStatus);
	expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 notifyCallStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusConnected.
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone, _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected, _L("RCall::GetStatus did not return EStatusConnected"));
	
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		 notifyMobileCallChangeStatus,
																		 notifyMobileCallStatus,
																		 expectedMobileCallStatus,
																	  	 wantedStatus);
														 
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, notifyMobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
    iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		 notifyMobileCallChangeStatus,
																		 notifyMobileCallStatus,
																		 expectedMobileCallStatus,
																	  	 wantedStatus);
														 
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, notifyMobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		 notifyMobileCallChangeStatus,
																		 notifyMobileCallStatus,
																		 expectedMobileCallStatus,
																	  	 wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, _L("RMobileCall::GetMobileCallStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, _L("RMobileCall::GetMobileCallStatus did not return a status EStatusConnected"));

	// ===  Check call info ===

	User::After(KOneSecond*2);	// Wait added for call duration

	// Check RCall::GetInfo returns valid call name.
	ASSERT_EQUALS(call1.GetInfo(callInfo), KErrNone, _L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() > 0, _L("RCall::GetInfo returned an invalid call name"));
	
	// Check RCall::GetInfo returns valid voice line name.
	ASSERT_TRUE(callInfo.iLineName.Length() > 0 ,_L("RCall::GetInfo returned an invalid  line name"));
	
	// Check RCall::GetInfo returns call status of EStatusConnected.
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected, _L("RCall::GetInfo returned wrong status, should be EStatusConnected"));
	
	// Check RCall::GetInfo returns call duration of > 0.
	ASSERT_TRUE(callInfo.iDuration.Int() > 0, _L("RCall::GetInfo returned a duration other than > 0"));
	
	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	ASSERT_EQUALS(call1.GetMobileCallInfo(callInfoPckg), KErrNone, _L("RMobileCall::GetMobileCallInfo returned an error"));
    // $CTSYProblem CTSY initialises iAlternatingCall to EAlternatingModeUnspecified, which should be updated via EMobileCallGetMobileCallInfo from LTSY
    // This problem is inside CheckForValidCallInfo() helper method.
	iCallControlTestHelper.CheckForValidCallInfo(mobileCallInfo);
	
	// Check RMobileCall::GetMobileCallInfo returns data for attributes marked as valid in iValid.
	ASSERT_TRUE(mobileCallInfo.iCallName.Length() > 0, _L("RMobileCall::GetMobileCallInfo returned an invalid call name"));
	
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() > 0, _L("RMobileCall::GetMobileCallInfo returned an invalid line name"));


	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
    
    // Hangup call
    call1.HangUp();
		
	// Pop
	// notifyCapsChangeStatus
	// notifyMobileCallCapsChangeStatus
	// notifyStatusChangeStatus
	// notifyMobileCallChangeStatus
	// dialStatus
	CleanupStack::PopAndDestroy(5, &notifyCapsChangeStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0048::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0048");
	}



CCTSYIntegrationTestCallControl0049::CCTSYIntegrationTestCallControl0049(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0049::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0049::~CCTSYIntegrationTestCallControl0049()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0049::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0049
 * @SYMFssID BA/CTSY/CCON-0049
 * @SYMTestCaseDesc Answer a call using RMobileCall::AnswerIncomingCallISV
 * @SYMTestPriority High
 * @SYMTestActions RMobileCall::NotifyMobileCallCapsChange,
 *                 RMobileCall::GetMobileCallStatus,
 *                 RMobileCall::GetMobileCallInfo,
 *                 RLine::NotifyIncomingCall, RCall::GetInfo,
 *                 RCall::NotifyStatusChange,
 *                 RMobileCall::NotifyMobileCallStatusChange,
 *                 RCall::NotifyCapsChange, RCall::GetStatus,
 *                 RMobileCall::AnswerIncomingCallISV,
 *                 RMobileCall::GetMobileCallCaps
 * @SYMTestExpectedResults Pass - Call answered. 
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify change in call state is reflected in RCall and RMobileCall
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////


	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits,  _L("RPhone::GetCaps returned wrong caps"));

	// Get Voice line 1. 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);


	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////


	// post notification RLine::NotifyIncomingCall
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus(voiceLine, &RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus);
	TName incomingCallName;
	incomingCallName.Zero();
	voiceLine.NotifyIncomingCall(notifyIncomingCallStatus, incomingCallName);
	
	// Request incoming call from RPS. 
	ASSERT_EQUALS (RPSRequestIncomingCallL(EVoiceLine), KErrNone, 
				_L("CCTSYIntegrationTestSuiteStepBase::RPSRequestIncomingCallL returned an error"));

	// Check RLine::NotifyIncomingCall completes with call name.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus, ETimeMedium),KErrNone, _L("RLine::NotifyIncomingCall timed out"));
	ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone, _L("RLine::NotifyIncomingCall returned with an error"));
	ASSERT_TRUE(incomingCallName.Length() > 0, _L("RLine::NotifyIncomingCall completed with invalid call name"));

	// Get the incoming call
	TCallId incomingCallId;
	RMobileCall& call1 = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, incomingCallName, incomingCallId);

	// post notifier for RCall::NotifyCapsChange
	TCoreEtelRequestStatus<RCall> notifyCapsChangeStatus (call1, &RCall::NotifyCapsChangeCancel);	
	CleanupStack::PushL(notifyCapsChangeStatus);
	RCall::TCaps callCaps;
	call1.NotifyCapsChange(notifyCapsChangeStatus, callCaps);
	
	// post notifier for RMobileCall::NotifyMobileCallCapsChange
	TExtEtelRequestStatus notifyMobileCallCapsChangeStatus(call1, EMobileCallNotifyMobileCallCapsChange);
	CleanupStack::PushL(notifyMobileCallCapsChangeStatus);
	RMobileCall::TMobileCallCapsV1 mobileCallCaps;
	RMobileCall::TMobileCallCapsV1Pckg mobileCallCapsPckg(mobileCallCaps);
	call1.NotifyMobileCallCapsChange(notifyMobileCallCapsChangeStatus, mobileCallCapsPckg);

	// post notifier for RCall::NotifyStatusChange
	TCoreEtelRequestStatus<RCall> notifyStatusChangeStatus (call1, &RCall::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus callStatus;
	call1.NotifyStatusChange(notifyStatusChangeStatus,callStatus);

	// post notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallStatusChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallStatusChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallStatusChangeStatus, mobileCallStatus);

	// Answer incoming call with RMobileCall::AnswerIncomingCallISV 
	TExtEtelRequestStatus answerIncomingCallStatus(call1, EMobileCallAnswerISV);
	CleanupStack::PushL(answerIncomingCallStatus);
	RMobileCall::TEtel3rdPartyMobileCallParamsV1 callParams;
	RMobileCall::TEtel3rdPartyMobileCallParamsV1Pckg callParamsPckg(callParams);
	call1.AnswerIncomingCallISV(answerIncomingCallStatus, callParamsPckg);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(answerIncomingCallStatus,ETimeMedium),KErrNone,_L("RMobileCall::AnswerIncomingCallISV timed out"));
	ASSERT_EQUALS(answerIncomingCallStatus.Int(), KErrNone, _L("RMobileCall::AnswerIncomingCallISV returned with an error"));
	
	// ===  Check call caps ===

	// Check RCall::NotifyCapsChange completes with caps in set of KCapsVoice | KCapsHangUp.
	RCall::TCaps wantedCaps, unwantedCaps;
	wantedCaps.iFlags = RCall::KCapsVoice | RCall::KCapsHangUp;
	unwantedCaps.iFlags = 0;
	const TInt wantedStatus = KErrNone;
	iCallControlTestHelper.WaitForCallNotifyCapsChange(call1, 
													   notifyCapsChangeStatus,
													   callCaps,
													   wantedCaps,
													   unwantedCaps,
													   wantedStatus);

	// Check RCall::GetCaps supports KCapsHangUp | KCapsVoice.
	TUint32 wantedCallCaps = RCall::KCapsHangUp | RCall::KCapsVoice;
	ASSERT_EQUALS(call1.GetCaps(callCaps),KErrNone, _L("RCall::GetCaps returned an error"));
	ASSERT_BITS_SET(callCaps.iFlags, wantedCallCaps, KNoUnwantedBits, _L("RCall::GetCaps returned wrong caps"));

	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp 
	// Check RMobileCall::NotifyMobileCallCapsChange completes with iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.
	RMobileCall::TMobileCallCapsV1 wantedMobileCaps;
	wantedMobileCaps.iCallControlCaps = RMobileCall::KCapsVoice | 
										RMobileCall::KCapsHold | 
										RMobileCall::KCapsHangUp;
										
	wantedMobileCaps.iCallEventCaps = RMobileCall::KCapsLocalHold | 
									  RMobileCall::KCapsLocalTransfer | 
									  RMobileCall::KCapsRemoteHold | 
									  RMobileCall::KCapsRemoteTerminate | 
									  RMobileCall::KCapsRemoteConferenceCreate;
									  
	TCmpRMobileCallTMobileCallCaps mobileCapsComp(wantedMobileCaps,mobileCallCaps, *this);
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallCapsChange(call1, 
																	   notifyMobileCallCapsChangeStatus,
																	   mobileCapsComp,
																	   wantedStatus);

	// Check RMobileCall::GetMobileCallCaps includes iCallControlCaps in set of KCapsVoice | KCapsHold | KCapsHangUp.
	ASSERT_EQUALS(call1.GetMobileCallCaps(mobileCallCapsPckg), KErrNone, _L("RMobileCall::GetMobileCallCaps returned an error"));
	ASSERT_BITS_SET(mobileCallCaps.iCallControlCaps, wantedMobileCaps.iCallControlCaps, KNoUnwantedBits, _L("RMobileCall::GetMobileCallCaps returned wrong caps"));
			
	// Check RMobileCall::GetMobileCallCaps includes iCallEventCaps in set of KCapsLocalHold | KCapsLocalTransfer | KCapsRemoteHold | KCapsRemoteTerminate | KCapsRemoteConferenceCreate.			
	ASSERT_BITS_SET(mobileCallCaps.iCallEventCaps, wantedMobileCaps.iCallEventCaps, KNoUnwantedBits, _L("RMobileCall::GetMobileCallCaps returned wrong caps"));

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusConnected
	RCall::TStatus expectedCallStatus = RCall::EStatusConnected;
	iCallControlTestHelper.WaitForCallNotifyStatusChange(call1,
														 notifyStatusChangeStatus,
														 callStatus,
														 expectedCallStatus,
														 wantedStatus);

	// Check RCall::GetStatus returns EStatusConnected
	ASSERT_EQUALS(call1.GetStatus(callStatus), KErrNone, _L("RCall::GetStatus returned an error"));
	ASSERT_EQUALS(callStatus, RCall::EStatusConnected, _L("RCall::GetStatus did not return EStatusConnected"));
	
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
																		 notifyMobileCallStatusChangeStatus,
																		 mobileCallStatus,
																		 expectedMobileCallStatus,
																	  	 wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone, 
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected, 
			_L("RMobileCall::GetMobileStatus did not return a status EStatusConnected"));

	// ===  Check call info ===

	User::After(KOneSecond*2);	// Wait added for call duration

	// Check RCall::GetInfo returns valid call name.
	RCall::TCallInfo callInfo;
	ASSERT_EQUALS(call1.GetInfo(callInfo), KErrNone, _L("RCall::GetInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() > 0, _L("RCall::GetInfo returned an invalid call name"));
	
	// Check RCall::GetInfo returns valid voice line name.	
	ASSERT_TRUE(callInfo.iLineName.Length() > 0,_L("RCall::GetInfo returned an invalid  line name"));
	
	// Check RCall::GetInfo returns call status of EStatusConnected.
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected, _L("RCall::GetInfo returned wrong status, should be EStatusConnected"));
	
	// Check RCall::GetInfo returns call duration of > 0.
	ASSERT_TRUE(callInfo.iDuration.Int() > 0, _L("RCall::GetInfo returned duration <= 0, should > 0"));

	// Check RMobileCall::GetMobileCallInfo returns iValid > 0.
	RMobileCall::TMobileCallInfoV1 mobileCallInfo;
	RMobileCall::TMobileCallInfoV1Pckg callInfoPckg(mobileCallInfo);
	ASSERT_EQUALS(call1.GetMobileCallInfo(callInfoPckg), KErrNone, _L("RMobileCall::GetMobileCallInfo returned an error"));
	ASSERT_TRUE(mobileCallInfo.iValid > 0, _L("RMobileCall::GetMobileCallInfo returned iValid <= 0 flags, should be > 0"));
	
	// Check RMobileCall::GetMobileCallInfo returns data for attributes makred as valid in iValid.
	iCallControlTestHelper.CheckForValidCallInfo(mobileCallInfo);
	
	// Check RMobileCall::GetMobileCallInfo returns valid line name.
	ASSERT_TRUE(mobileCallInfo.iLineName.Length() > 0, _L("RMobileCall::GetMobileCallInfo returned an invalid line name"));

    // Hangup call
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone, _L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone, _L("RCall::HangUp returned an error"));


	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
		
	// Pop
	// notifyIncomingCallStatus
	// notifyCapsChangeStatus
	// notifyMobileCallCapsChangeStatus
	// notifyStatusChangeStatus
	// notifyMobileCallStatusChangeStatus
	// answerIncomingCallStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(7, &notifyIncomingCallStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0049::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0049");
	}



CCTSYIntegrationTestCallControl0050::CCTSYIntegrationTestCallControl0050(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0050::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0050::~CCTSYIntegrationTestCallControl0050()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0050::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0050
 * @SYMFssID BA/CTSY/CCON-0050
 * @SYMTestCaseDesc Answer a call using RMobileCall::AnswerIncomingCallISV
 * @SYMTestPriority High
 * @SYMTestActions RMobileLine::NotifyMobileLineStatusChange,
 *                 RLine::GetCallInfo,
 *                 RLine::NotifyIncomingCall, RLine::GetStatus,
 *                 RMobileLine::GetMobileLineStatus,
 *                 RLine::GetInfo,
 *                 RMobileCall::AnswerIncomingCallISV
 * @SYMTestExpectedResults Pass - Call answered. 
 * @SYMTestType CIT
 * @SYMTestCaseDependencies RPS/automatic
 *
 * Reason for test: Verify change in line state is reflected in RLine and RMobileLine
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
    CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits, _L("RPhone::GetCaps returned wrong caps"));

	// Get Voice line 1. 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

    // Get Call 1.
    RMobileCall& mobileCall1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// Post notification RLine::NotifyIncomingCall
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus(voiceLine, &RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus);
	TName incomingCallName;
	incomingCallName.Zero();
	voiceLine.NotifyIncomingCall(notifyIncomingCallStatus, incomingCallName);

	// Post notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine, &RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus lineStatus;
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);
	
	// Post a notifier for RMobileLine::NotifyMobileLineStatusChange
	RMobileCall::TMobileCallStatus mobileLineStatus;
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);

	// Request incoming call from RPS. 
	ASSERT_EQUALS (RPSRequestIncomingCallL(EVoiceLine), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSRequestIncomingCallL returned an error"));

	// Check RLine::NotifyIncomingCall completes with call name.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus, ETimeMedium), KErrNone, _L("RLine::NotifyIncomingCall timed out"));
	ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone, _L("RLine::NotifyIncomingCall returned with an error"));
	ASSERT_TRUE(incomingCallName.Length() > 0, _L("RLine::NotifyIncomingCall completed with an invalid call name"));

	// Get the incoming call
	TCallId incomingCallId;
	mobileCall1 = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, incomingCallName, incomingCallId);

	// Answer incoming call with RMobileCall::AnswerIncomingCallISV 
	TExtEtelRequestStatus answerIncomingCallStatus(mobileCall1, EMobileCallAnswerISV);
	CleanupStack::PushL(answerIncomingCallStatus);
	RMobileCall::TEtel3rdPartyMobileCallParamsV1 callParams;
	RMobileCall::TEtel3rdPartyMobileCallParamsV1Pckg callParamsPckg(callParams);
	mobileCall1.AnswerIncomingCallISV(answerIncomingCallStatus, callParamsPckg);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(answerIncomingCallStatus,ETimeMedium),KErrNone,_L("RMobileCall::AnswerIncomingCallISV timed out"));
	ASSERT_EQUALS(answerIncomingCallStatus.Int(), KErrNone, _L("RMobileCall::AnswerIncomingCallISV returned with an error"));

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusAnswering -> EStatusConnected.
	RCall::TStatus expectedLineStatus = RCall::EStatusAnswering;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 KErrNone);

	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);
	expectedLineStatus = RCall::EStatusConnected;	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 KErrNone);

	// Check RLine::GetStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone, _L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, expectedLineStatus, _L("RLine::GetStatus did not return EStatusConnected as expected"));
	
	// Check RMobileLine::NotifyMobileLineStatusChange completes with EStatusAnswering -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusAnswering;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		KErrNone);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		KErrNone);

	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone, _L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusConnected, _L("RMobileLine::GetMobileLineStatus did not return EStatusConnected as expected"));

	// ===  Check line info ===

	// Check RLine::GetCallInfo returns valid name.
	RLine::TCallInfo callInfo;
	ASSERT_EQUALS(voiceLine.GetCallInfo(incomingCallId, callInfo), KErrNone, _L("RLine::GetCallInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() > 0, _L("RLine::GetCallInfo returned an invalid iCallName"));

	// Check RLine::GetCallInfo returns caps in set of KCapsHangUp.
	ASSERT_BITS_SET(callInfo.iCallCapsFlags, RCall::KCapsHangUp, KNoUnwantedBits , _L("RLine::GetCallInfo returned wrong caps"));	

	// Check RLine::GetCallInfo returns status of EStatusConnected.
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected, _L("RLine::GetCallInfo did not return EStatusConnected as expected"));

	// Check RLine::GetInfo returns status of EStatusConnected.
	RLine::TLineInfo lineInfo;
	ASSERT_EQUALS(voiceLine.GetInfo(lineInfo),KErrNone, _L("RLine::GetInfo returned an error")); 
	ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusConnected, _L("RLine::GetInfo did not return EStatusConnected as expected"));

	// Hang up the call
	TCoreEtelRequestStatus<RCall> hangUpStatus (mobileCall1, &RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	mobileCall1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone, _L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone, _L("RCall::HangUp returned an error")); 	

	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();

	// Pop
	// notifyIncomingCallStatus
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus
	// answerIncomingCallStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(5, &notifyIncomingCallStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0050::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0050");
	}



CCTSYIntegrationTestCallControl0051::CCTSYIntegrationTestCallControl0051(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0051::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0051::~CCTSYIntegrationTestCallControl0051()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0051::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0051
 * @SYMFssID BA/CTSY/CCON-0051
 * @SYMTestCaseDesc Get the call duration of a call.
 * @SYMTestPriority High
 * @SYMTestActions RCall::NotifyCallDurationChange, RCall::GetCallDuration, RCall::HangUp
 * @SYMTestExpectedResults Pass - Call duration reported correctly during call.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify notification of call duration advances during call each second.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits,  _L("RPhone::GetCaps returned wrong caps"));
	
	// Get Voice line 1. 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1. 
	RCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);


	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// Check RCall::GetCallDuration returns KErrEtelCallNotActive
	// $CTSYProblem.  RCall::GetCallDuration returns KErrNone although there is no active call
	// Got 0, Expected -2007, (KErrEtelCoreBase = -2000 and KErrEtelCallNotActive=KErrEtelCoreBase-7) 
	TTimeIntervalSeconds duration;
	ERR_PRINTF2(_L("<font color=Orange>$CTSYKnownFailure: defect id = %d</font>"), 10055);
	ASSERT_EQUALS(call1.GetCallDuration(duration), KErrEtelCallNotActive, 
			_L("RCall::GetCallDuration returned wrong error code, should be KErrEtelCallNotActive"));

	// post RCall::NotifyCallDurationChange
	TCoreEtelRequestStatus<RCall> notifyCallDurationChangeStatus(call1, &RCall::NotifyCallDurationChangeCancel);
	CleanupStack::PushL(notifyCallDurationChangeStatus);
	TTimeIntervalSeconds notifyDuration;
	call1.NotifyCallDurationChange(notifyCallDurationChangeStatus, notifyDuration);
	
	// Dial a number that answers. 
	TPtrC number;
	ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse, _L("GetStringFromConfig did not complete as expected"));
	TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);
	DEBUG_PRINTF1(_L("Board Now Dialling... "));
	call1.Dial(dialStatus, number);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeLong), KErrNone, _L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  _L("RCall::Dial returned with an error"));
	
	// Check completion of RCall::NotifyCallDurationChange
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyCallDurationChangeStatus, ETimeShort), KErrNone, _L("RCall::NotifyCallDurationChange timed-out"));
	ASSERT_EQUALS(notifyCallDurationChangeStatus.Int(), KErrNone,  _L("RCall::NotifyCallDurationChange returned with an error"));
	
	for(TInt i = 0; i < 10; ++i)
		{
		TTimeIntervalSeconds prevNotifyDuration = notifyDuration;
		
		// post RCall::NotifyCallDurationChange
		call1.NotifyCallDurationChange(notifyCallDurationChangeStatus, notifyDuration);
		
		// Check notification of call duration from RCall::NotifyCallDurationChange completes with call duration which has advanced from previous notification.
		ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyCallDurationChangeStatus, ETimeShort), KErrNone, _L("RCall::NotifyCallDurationChange timed-out"));
		ASSERT_EQUALS(notifyCallDurationChangeStatus.Int(), KErrNone,  _L("RCall::NotifyCallDurationChange returned with an error"));
		
		ASSERT_TRUE(notifyDuration.Int() > prevNotifyDuration.Int(), _L("RCall::NotifyCallDurationChange completed with duration less than expected"));
		
		// Check RCall::GetCallDuration returns call duration >= previous call duration.
		TTimeIntervalSeconds durationGet, prevdurationGet=0;
		ASSERT_EQUALS(call1.GetCallDuration(durationGet), KErrNone, _L("RCall::GetCallDuration returned with an error"));
		ASSERT_TRUE(durationGet.Int() >= prevdurationGet.Int(), _L("RCall::GetCallDuration returned with duration less than expected"));
		prevdurationGet = durationGet;
		}
	
	// hang up the call
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium), KErrNone, _L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone,  _L("RCall::HangUp returned with an error"));

	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();	
	
	// Pop
	// notifyCallDurationChangeStatus
	// dialStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(3, &notifyCallDurationChangeStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0051::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0051");
	}



CCTSYIntegrationTestCallControl0052::CCTSYIntegrationTestCallControl0052(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0052::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0052::~CCTSYIntegrationTestCallControl0052()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0052::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0052
 * @SYMFssID BA/CTSY/CCON-0052
 * @SYMTestCaseDesc Cancel call duration notifications.
 * @SYMTestPriority High
 * @SYMTestActions RCall::NotifyCallDurationChange, RCall::NotifyCallDurationChangeCancel
 * @SYMTestExpectedResults Pass - Call duration cancelled.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify notification of call duration cancelled.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
    CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
    CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits, _L("RPhone::GetCaps returned wrong caps"));

	// Get Voice line 1. 
    RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1. 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Register for notification of call duration with RCall::NotifyCallDurationChange 
    TCoreEtelRequestStatus<RCall> notifyCallDurationChangeStatus(call1, &RCall::NotifyCallDurationChangeCancel);
    CleanupStack::PushL(notifyCallDurationChangeStatus);
    TTimeIntervalSeconds notifyDuration;
    call1.NotifyCallDurationChange(notifyCallDurationChangeStatus, notifyDuration);

	// Cancel notification 
    call1.NotifyCallDurationChangeCancel();

	// Check status is KErrCancel 
    ASSERT_EQUALS(notifyCallDurationChangeStatus.Int(), KErrCancel, _L("RCall::NotifyCallDurationChange is not KErrCancel"));
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
	// notifyCallDurationChangeStatus
    CleanupStack::PopAndDestroy(&notifyCallDurationChangeStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0052::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0052");
	}



CCTSYIntegrationTestCallControl0053::CCTSYIntegrationTestCallControl0053(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0053::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0053::~CCTSYIntegrationTestCallControl0053()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0053::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0053
 * @SYMFssID BA/CTSY/CCON-0053
 * @SYMTestCaseDesc Close the phone when incoming call is coming (with 2 clients).
 * @SYMTestPriority High
 * @SYMTestActions RTelServer::LoadPhoneModule, RTelServer::Close, RLine::Open, RLine::NotifyIncomingCall, RPhone::Open, RLine::Close, RTelServer::Connect, RCall::OpenNewCall, RCall::Close, RPhone::Close
 * @SYMTestExpectedResults Pass - Incoming call notification received. Subsessions closed successfully.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify incoming call notification completes and phone and line can be closed.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));	

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// Get voice line 1 on main phone. This is the first client. 
	RMobileLine& mobileLine= iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get voice line 1 on alt phone. This is the second client. 
	RMobileLine& mobileLine2= iEtelSessionMgr.GetLineL(KAltServer, KMainPhone, KVoiceLine);
	
	// Register for notification of incoming call1 with RLine::NotifyIncomingCall 
	TName name;
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus (mobileLine,&RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus);
	mobileLine.NotifyIncomingCall(notifyIncomingCallStatus,name);
	
	// Register for notification of incoming call2 with RLine::NotifyIncomingCall
	TName name2;
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus2 (mobileLine2,&RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus2);
	mobileLine2.NotifyIncomingCall(notifyIncomingCallStatus2,name2);
		
	// Request an incoming call from RPS 
	ASSERT_EQUALS (RPSRequestIncomingCallL(EVoiceLine), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSRequestIncomingCallL returned an error"));

	// Check RLine::NotifyIncomingCall completes with KErrNone on both clients.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus,ETimeMedium),KErrNone,_L("RLine::NotifyIncomingCall (1) timed out"));
	ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone, _L("RLine::NotifyIncomingCall (1) returned with an error"));
	
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus2,ETimeMedium),KErrNone,_L("RLine::NotifyIncomingCall (2) timed out"));
	ASSERT_EQUALS(notifyIncomingCallStatus2.Int(), KErrNone, _L("RLine::NotifyIncomingCall (2) returned with an error"));

	// Release main phone. 
	iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	
	// Release alt phone. 
	iEtelSessionMgr.GetLineL(KAltServer, KMainPhone, KVoiceLine);

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
	// notifyIncomingCallStatus
	// notifyIncomingCallStatus2
	
	CleanupStack::PopAndDestroy(2,&notifyIncomingCallStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0053::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0053");
	}



CCTSYIntegrationTestCallControl0054::CCTSYIntegrationTestCallControl0054(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0054::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0054::~CCTSYIntegrationTestCallControl0054()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0054::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0054
 * @SYMFssID BA/CTSY/CCON-0054
 * @SYMTestCaseDesc Answer incoming call and hang up call.
 * @SYMTestPriority High
 * @SYMTestActions RMobileLine::NotifyMobileLineStatusChange,
 *                 RLine::GetCallInfo,
 *                 RLine::NotifyIncomingCall,
 *                 RCall::OpenExistingCall, RLine::GetStatus,
 *                 RCall::AnswerIncomingCall,
 *                 RMobileLine::GetMobileLineStatus,
 *                 RLine::GetInfo
 * @SYMTestExpectedResults Pass - Call can be answered and line status is correct.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test: Verify call can be answered with specified
 * params and line status, and line info correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	// Check phone supports KCapsVoice.
	RPhone::TCaps phoneCaps; 
	CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
	CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits,  _L("RPhone::GetCaps returned wrong caps, shouydl be KCapsVoice"));
	
	// Get Voice line 1. 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1. 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// post notify RLine::NotifyIncomingCall
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus (voiceLine, &RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus);
	TName incomingCallName;
	voiceLine.NotifyIncomingCall(notifyIncomingCallStatus, incomingCallName);
	
	// post notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine, &RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus lineStatus;
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);
	
	// Request an incoming call from RPS. 
	ASSERT_EQUALS(RPSRequestIncomingCallL(EVoiceLine), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSRequestIncomingCallL returned an error"));

	// Check RLine::NotifyIncomingCall completes.
	ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus, ETimeMedium), KErrNone, 
			_L("RLine::NotifyIncomingCall did not complete without error"));
	ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone, _L("RLine::NotifyIncomingCall returned an error"));

	// Get the incoming call
	TCallId incomingCallId;
	call1 = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, incomingCallName, incomingCallId);

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusRinging
	RCall::TStatus expectedCallStatus = RCall::EStatusRinging;
	TInt expectedStatus = KErrNone;  	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedCallStatus,
														 expectedStatus);

	// Check RLine::GetStatus returns EStatusRinging
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus),KErrNone, _L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusRinging, _L("RLine::GetStatus returned wrong status, should be EStatusRinging"));
	
	// ===  Check line info ===

	// Check RLine::GetCallInfo returns correct call name.
	// Get the latest created call id. Call indexing starts from 0, so decrease it with one.
	TInt numberOfCalls;
	voiceLine.EnumerateCall(numberOfCalls);
	numberOfCalls-=1;
	RLine::TCallInfo callInfo;
	ASSERT_EQUALS(voiceLine.GetCallInfo(numberOfCalls, callInfo), KErrNone, _L("RLine::GetCallInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() > 0, _L("RLine::GetCallInfo returned an invalid  name"));

	// Check RLine::GetCallInfo returns caps in set of KCapsVoice | KCapsAnswer.
	ASSERT_BITS_SET(callInfo.iCallCapsFlags, RCall::KCapsVoice | RCall::KCapsAnswer, KNoUnwantedBits , 
			_L("RLine::GetCallInfo returned wrong caps"));	
	// Check RLine::GetCallInfo returns status of EStatusRinging
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusRinging, _L("RLine::GetCallInfo wrong iStatus, should be EStatusRinging"));

	// Populate a RMobileCall::TMobileCallParamsV1 with: 
	RMobileCall::TMobileCallParamsV1 mobileCallParams;
	RMobileCall::TMobileCallParamsV1Pckg mobileCallParamsPckg(mobileCallParams);

	// ? iSpeakerControl = EMonitorSpeakerControlAlwaysOff 
	mobileCallParams.iSpeakerControl = RCall::EMonitorSpeakerControlAlwaysOff;
	
	// ?iSpeakerVolume = EMonitorSpeakerVolumeOff 
	mobileCallParams.iSpeakerVolume = RCall::EMonitorSpeakerVolumeOff;
	
	// ?iInterval = 0x01 
	mobileCallParams.iInterval = 0x01;
	
	// ?iWaitForDialTone = EDialToneWait 
	mobileCallParams.iWaitForDialTone = RCall::EDialToneWait;
	
	// ?iIdRestrict = EIdRestrictDefault 
	mobileCallParams.iIdRestrict = RMobileCall::EIdRestrictDefault;
	
	// ?iExplicitInvoke = TRUE 
	mobileCallParams.iCug.iExplicitInvoke = TRUE;
	
	// ?iCugIndex = 0x0000 
	mobileCallParams.iCug.iCugIndex = 0x0000;

	// ?iSuppressOA = FALSE 
	mobileCallParams.iCug.iSuppressOA = FALSE;

	// ?iSuppressPrefCug = FALSE 
	mobileCallParams.iCug.iSuppressPrefCug = FALSE;

	// ?iAutoRedial = FALSE 
	mobileCallParams.iAutoRedial = FALSE;

	// post a notifier for RMobileLine::NotifyMobileLineStatusChange
	RMobileCall::TMobileCallStatus mobileLineStatus;
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);

	// post notifier for RLine::NotifyStatusChange
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);

	// Answer incoming call by calling RCall::AnswerIncomingCall and using TMobileCallParamsV1 
	ASSERT_EQUALS(call1.AnswerIncomingCall(mobileCallParamsPckg), KErrNone, _L("RCall::AnswerIncomingCall returned an error"));

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusAnswering -> EStatusConnected.
	expectedCallStatus = RCall::EStatusAnswering;
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedCallStatus,
														 expectedStatus);

	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedCallStatus = RCall::EStatusConnected;	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedCallStatus,
														 expectedStatus);

	// Check RLine::GetStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus),KErrNone, _L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusConnected, _L("RLine::GetStatus returned wrong status, should be EStatusConnected"));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusAnswering -> EStatusConnected.
	TInt wantedStatus = KErrNone;
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusAnswering;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		wantedStatus);
	
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);	
	expectedMobileLineStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		wantedStatus);
	
	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone, 
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusConnected,
			_L("RMobileLine::GetMobileLineStatus did not return EStatusConnected as expected"));

	// ===  Check line info ===

	// Check RLine::GetCallInfo returns valid name.
	// Check RLine::GetCallInfo returns caps in set of KCapsHangUp.
	// Check RLine::GetCallInfo returns status of EStatusConnected.
	ASSERT_EQUALS(voiceLine.GetCallInfo(numberOfCalls, callInfo), KErrNone, _L("RLine::GetCallInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length()>0, _L("RLine::GetCallInfo returned an invalid  name"));
	ASSERT_BITS_SET(callInfo.iCallCapsFlags, RCall::KCapsHangUp, KNoUnwantedBits , 
			_L("RLine::GetCallInfo returned wrong caps"));	
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusConnected, _L("RLine::GetCallInfo wrong iStatus, should be EStatusConnected"));

	// Check RLine::GetInfo returns status of EStatusConnected.
	RLine::TLineInfo lineInfo;
	ASSERT_EQUALS(voiceLine.GetInfo(lineInfo),KErrNone, _L("RLine::GetInfo returned an error")); 
	ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusConnected, _L("RLine::GetInfo did not return EStatusConnected"));

	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);	

	// Hang up the call 
	TCoreEtelRequestStatus<RCall> hangUpStatus (call1, &RCall::HangUpCancel);	
	CleanupStack::PushL(hangUpStatus);
	call1.HangUp(hangUpStatus);
	ASSERT_EQUALS(WaitForRequestWithTimeOut(hangUpStatus, ETimeLong), KErrNone, _L("RCall::HangUp timed-out"));
	ASSERT_EQUALS(hangUpStatus.Int(), KErrNone, _L("RCall::HangUp returned an error"));	

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedCallStatus = RCall::EStatusHangingUp;	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedCallStatus,
														 expectedStatus);

	voiceLine.NotifyStatusChange(notifyStatusChangeStatus,lineStatus);
	expectedCallStatus = RCall::EStatusIdle;	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedCallStatus,
														 expectedStatus);

	// Check RLine::GetStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus),KErrNone, _L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle, _L("RLine::GetStatus returned wrong status, should be EStatusIdle"));
	
	// Check RMobileLine::NotifyMobileLineStatusChange completes with EStatusDisconnecting -> EStatusIdle
	expectedMobileLineStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		wantedStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);	
	expectedMobileLineStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		notifyMobileLineChangeStatus,
																		mobileLineStatus,
																		expectedMobileLineStatus,
																		wantedStatus);

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone, 
			_L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusIdle,
			_L("RMobileLine::GetMobileLineStatus did not return EStatusIdle as expected"));

	// ===  Check line info ===

	// Check RLine::GetCallInfo returns valid name.
	// Check RLine::GetCallInfo returns caps in set of KCapsVoice | KCapsDial.
	// Check RLine::GetCallInfo returns status of EStatusIdle.
	ASSERT_EQUALS(voiceLine.GetCallInfo(numberOfCalls, callInfo), KErrNone, _L("RLine::GetCallInfo returned an error"));
	ASSERT_TRUE(callInfo.iCallName.Length() > 0, _L("RLine::GetCallInfo returned an invalid  name"));
	ASSERT_BITS_SET(callInfo.iCallCapsFlags, RCall::KCapsVoice | RCall::KCapsDial, KNoUnwantedBits , 
			_L("RLine::GetCallInfo returned wrong caps"));	
	ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusIdle, _L("RLine::GetCallInfo wrong iStatus, should be EStatusIdle"));

	// Check RLine::GetInfo returns status of EStatusIdle.
	ASSERT_EQUALS(voiceLine.GetInfo(lineInfo), KErrNone, _L("RLine::GetInfo returned an error")); 
	ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusIdle,	_L("RLine::GetInfo did not return EStatusIdle"));

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
	// notifyIncomingCallStatus
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus
	// hangUpStatus
	CleanupStack::PopAndDestroy(4, &notifyIncomingCallStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0054::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0054");
	}



CCTSYIntegrationTestCallControl0055::CCTSYIntegrationTestCallControl0055(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0055::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0055::~CCTSYIntegrationTestCallControl0055()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0055::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0055
 * @SYMFssID BA/CTSY/CCON-0055
 * @SYMTestCaseDesc Answer incoming call then have remote party hang up.
 * @SYMTestPriority High
 * @SYMTestActions RMobileLine::NotifyMobileLineStatusChange,
 *                 RLine::GetCallInfo,
 *                 RLine::NotifyIncomingCall,
 *                 RCall::OpenExistingCall, RLine::GetStatus,
 *                 RCall::AnswerIncomingCall,
 *                 RMobileLine::GetMobileLineStatus,
 *                 RLine::GetInfo
 * @SYMTestExpectedResults Pass - Line status correct after remote party hangs up.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies rps/automatic
 *
 * Reason for test: Verify call can be answered with specified
 * params and line status, and line info correct.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Check phone supports KCapsVoice
   	RPhone::TCaps phoneCaps;
    CHECK_EQUALS_L(phone.GetCaps(phoneCaps), KErrNone, _L("RPhone::GetCaps returned an error"));
    CHECK_BITS_SET_L(phoneCaps.iFlags, RPhone::KCapsVoice, KNoUnwantedBits, _L("RPhone::GetCaps returned wrong caps"));

	// Get Voice line 1 
    RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

	// Get call 1. 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// Post notification RLine::NotifyIncomingCall
	TCoreEtelRequestStatus<RLine> notifyIncomingCallStatus(voiceLine, &RLine::NotifyIncomingCallCancel);
	CleanupStack::PushL(notifyIncomingCallStatus);
	TName incomingCallName;
	incomingCallName.Zero();
	voiceLine.NotifyIncomingCall(notifyIncomingCallStatus, incomingCallName);

	// Post notifier for RLine::NotifyStatusChange
	TCoreEtelRequestStatus<RLine> notifyStatusChangeStatus (voiceLine, &RLine::NotifyStatusChangeCancel);
	CleanupStack::PushL(notifyStatusChangeStatus);
	RCall::TStatus lineStatus;
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);

	// Request an incoming call from RPS. 
	ASSERT_EQUALS(RPSRequestIncomingCallL(EVoiceLine), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSRequestIncomingCallL returned an error"));

	// Check RLine::NotifyIncomingCall completes.
    ASSERT_EQUALS(WaitForRequestWithTimeOut(notifyIncomingCallStatus, ETimeMedium), KErrNone, 
                  _L("RLine::NotifyIncomingCall timed-out."));
    ASSERT_EQUALS(notifyIncomingCallStatus.Int(), KErrNone,
                   _L( "RLine::NotifyIncomingCall returned with an error."));
    ASSERT_TRUE(incomingCallName.Length() > 0,  
                _L("RLine::NotifyIncomingCall completed with invalid call name."));	

	// Get the incoming call
	TCallId incomingCallId;
	call1 = iEtelSessionMgr.GetIncomingCallL(KMainServer, KMainPhone, KVoiceLine, incomingCallName, incomingCallId);

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusRinging
    RCall::TStatus expectedLineStatus = RCall::EStatusRinging;	
    iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
                                                         notifyStatusChangeStatus,
                                                         lineStatus,
                                                         expectedLineStatus,
                                                         KErrNone);

	// Check RLine::GetStatus returns EStatusRinging
    ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone, _L("RLine::GetStatus returned an error."));
    ASSERT_EQUALS(lineStatus, RCall::EStatusRinging, _L("RLine::GetStatus did not return EStatusRinging as expected."));

	// ===  Check line info ===

	// Check RLine::GetCallInfo returns correct call name.
    RLine::TCallInfo callInfo;
    ASSERT_EQUALS(voiceLine.GetCallInfo(incomingCallId, callInfo), KErrNone, _L( "RLine::GetCallInfo returned an error"));
    ASSERT_TRUE(callInfo.iCallName.Length() > 0, _L("RLine::GetCallInfo returned an invalid name"));
	
	// Check RLine::GetCallInfo returns caps in set of KCapsVoice | KCapsAnswer.
	// $CTSYProblem RLine::GetCallInfo returns wrong bits set : Got 0x44 , required 0x64
	// KCapsVoice=0x00000004 and KCapsAnswer=0x00000040 are OK but KCapsHangUp=0x00000020 is missing.
    // Changed original test step to check RLine::GetCallinfo returns caps in set KCapsVoice | KCapsAnswer instead of KCapsVoice | KCapsAnswer | KCapsHangUp.
    ASSERT_BITS_SET(callInfo.iCallCapsFlags, RCall::KCapsVoice | RCall::KCapsAnswer, KNoUnwantedBits, _L( "RLine::GetCallInfo returned wrong caps"));
	
	// Check RLine::GetCallInfo returns status of EStatusRinging
    ASSERT_EQUALS(callInfo.iStatus, RCall::EStatusRinging, _L( "RLine::GetCallInfo did not return EStatusRinging as expected."));

	// Populate a RMobileCall::TMobileCallParamsV1 with: 
    RMobileCall::TMobileCallParamsV1 mobileCallParams;
    RMobileCall::TMobileCallParamsV1Pckg mobileCallParamsPckg(mobileCallParams);

	// ?iSpeakerControl = EMonitorSpeakerControlAlwaysOff 
	mobileCallParams.iSpeakerControl = RCall::EMonitorSpeakerControlAlwaysOff;

	// ?iSpeakerVolume = EMonitorSpeakerVolumeOff 
	mobileCallParams.iSpeakerVolume = RCall::EMonitorSpeakerVolumeOff;

	// ?iInterval = 0x01 
	mobileCallParams.iInterval = 0x01;

	// ?iWaitForDialTone = EDialToneWait 
	mobileCallParams.iWaitForDialTone = RCall::EDialToneWait;

	// ?iIdRestrict = EIdRestrictDefault 
	mobileCallParams.iIdRestrict = RMobileCall::EIdRestrictDefault;

	// ?iExplicitInvoke = TRUE 
	mobileCallParams.iCug.iExplicitInvoke = TRUE;

	// ?iCugIndex = 0x0000 
	mobileCallParams.iCug.iCugIndex = 0x0000;

	// ?iSuppressOA = FALSE 
	mobileCallParams.iCug.iSuppressOA = FALSE;

	// ?iSuppressPrefCug = FALSE 
	mobileCallParams.iCug.iSuppressPrefCug = FALSE;

	// ?iAutoRedial = FALSE 
	mobileCallParams.iAutoRedial = FALSE;

	// Post a notifier for RMobileLine::NotifyMobileLineStatusChange
	RMobileCall::TMobileCallStatus mobileLineStatus;
	TExtEtelRequestStatus notifyMobileLineChangeStatus(voiceLine, EMobileLineNotifyMobileLineStatusChange);
	CleanupStack::PushL(notifyMobileLineChangeStatus);
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	
	// Repost notifier for RLine::NotifyStatusChange
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);
	
	// Answer incoming call by calling RCall::AnswerIncomingCall and using TMobileCallParamsV1 
	ASSERT_EQUALS(call1.AnswerIncomingCall(mobileCallParamsPckg), KErrNone,
	              _L( "RCall::AnswerIncomingCall returned an error"));

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusAnswering -> EStatusConnected.
	expectedLineStatus = RCall::EStatusAnswering;	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 KErrNone);
	
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);
	expectedLineStatus = RCall::EStatusConnected;	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 KErrNone);

	// Check RLine::GetStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone, _L("RLine::GetStatus returned an error."));
	ASSERT_EQUALS(lineStatus, RCall::EStatusConnected, _L("RLine::GetStatus did not return EStatusConnected as expected."));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusAnswering -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileLineStatus = RMobileCall::EStatusAnswering;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		 notifyMobileLineChangeStatus,
																		 mobileLineStatus,
																		 expectedMobileLineStatus,
																		 KErrNone);

	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);																	
	expectedMobileLineStatus = RMobileCall::EStatusConnected;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		 notifyMobileLineChangeStatus,
																		 mobileLineStatus,
																		 expectedMobileLineStatus,
																		 KErrNone);

	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone, 
			      _L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusConnected,
			      _L("RMobileLine::GetMobileLineStatus did not return EStatusConnected as expected"));

	// ===  Check line info ===

	// Check RLine::GetCallInfo returns valid name.
    RLine::TCallInfo callInfo2;
	ASSERT_EQUALS(voiceLine.GetCallInfo(incomingCallId, callInfo2), KErrNone, _L("RLine::GetCallInfo returned an error"));
	ASSERT_TRUE(callInfo2.iCallName.Length()>0, _L("RLine::GetCallInfo returned an invalid  name"));
	
	// Check RLine::GetCallInfo returns caps in set of KCapsHangUp.
	ASSERT_BITS_SET(callInfo2.iCallCapsFlags, RCall::KCapsHangUp, KNoUnwantedBits, _L("RLine::GetCallInfo returned wrong caps"));	
	
	// Check RLine::GetCallInfo returns status of EStatusConnected.
	ASSERT_EQUALS(callInfo2.iStatus, RCall::EStatusConnected, _L("RLine::GetCallInfo did not return EStatusConnected as expected."));

	// Check RLine::GetInfo returns status of EStatusConnected.
	RLine::TLineInfo lineInfo;
	ASSERT_EQUALS(voiceLine.GetInfo(lineInfo), KErrNone, _L("RLine::GetInfo returned an error")); 
	ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusConnected, _L("RLine::GetInfo did not return EStatusConnected as expected."));

    // Repost notifier for RLine::NotifyStatusChange
    voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);
    
    // Repost notifer for RMobileLine::NotifyMobileLineStatusChange
    voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);

	// RPS hangs up the call 
	ASSERT_EQUALS(RPSHangupL(EVoiceLine, 0), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSHangup returned an error"));

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle
	expectedLineStatus = RCall::EStatusHangingUp;	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 KErrNone);
														 
	voiceLine.NotifyStatusChange(notifyStatusChangeStatus, lineStatus);
	expectedLineStatus = RCall::EStatusIdle;	
	iCallControlTestHelper.WaitForLineNotifyStatusChange(voiceLine,
														 notifyStatusChangeStatus,
														 lineStatus,
														 expectedLineStatus,
														 KErrNone);

	// Check RLine::GetStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetStatus(lineStatus), KErrNone, _L("RLine::GetStatus returned an error"));
	ASSERT_EQUALS(lineStatus, RCall::EStatusIdle, _L("RLine::GetStatus did not return EStatusIdle as expected."));

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDisconnecting -> EStatusIdle
	expectedMobileLineStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		 notifyMobileLineChangeStatus,
																		 mobileLineStatus,
																		 expectedMobileLineStatus,
																		 KErrNone);
																		 
	voiceLine.NotifyMobileLineStatusChange(notifyMobileLineChangeStatus, mobileLineStatus);
	expectedMobileLineStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileLineNotifyMobileLineStatusChange(voiceLine,
																		 notifyMobileLineChangeStatus,
																		 mobileLineStatus,
																		 expectedMobileLineStatus,
																		 KErrNone);

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle
	ASSERT_EQUALS(voiceLine.GetMobileLineStatus(mobileLineStatus), KErrNone, 
			      _L("RMobileLine::GetMobileLineStatus returned an error"));
	ASSERT_EQUALS(mobileLineStatus, RMobileCall::EStatusIdle,
			      _L("RMobileLine::GetMobileLineStatus did not return EStatusIdle as expected"));

	// ===  Check line info ===

	// Check RLine::GetCallInfo returns valid name.
	RLine::TCallInfo callInfo3;
	ASSERT_EQUALS(voiceLine.GetCallInfo(incomingCallId, callInfo3), KErrNone, _L("RLine::GetCallInfo returned an error"));
	ASSERT_TRUE(callInfo3.iCallName.Length() > 0, _L("RLine::GetCallInfo returned an invalid  name"));
	
	// Check RLine::GetCallInfo returns caps in set of KCapsVoice | KCapsDial.
	TUint expectedCallCapsFlags = RCall::KCapsVoice | RCall::KCapsDial;
	ASSERT_BITS_SET(callInfo3.iCallCapsFlags, expectedCallCapsFlags, KNoUnwantedBits, _L("RLine::GetCallInfo returned wrong caps"));	
	
	// Check RLine::GetCallInfo returns status of EStatusIdle.
	ASSERT_EQUALS(callInfo3.iStatus, RCall::EStatusIdle,
	              _L("RLine::GetCallInfo did not return EStatusIdle as expected."));

	// Check RLine::GetInfo returns status of EStatusIdle.
	ASSERT_EQUALS(voiceLine.GetInfo(lineInfo), KErrNone, _L("RLine::GetInfo returned an error")); 
	ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusIdle,	_L("RLine::GetInfo did not return EStatusIdle as expected."));
    
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Pop
	// notifyIncomingCallStatus
	// notifyStatusChangeStatus
	// notifyMobileLineChangeStatus
	CleanupStack::PopAndDestroy(3, &notifyIncomingCallStatus);
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0055::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0055");
	}



CCTSYIntegrationTestCallControl0056::CCTSYIntegrationTestCallControl0056(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0056::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0056::~CCTSYIntegrationTestCallControl0056()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0056::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0056
 * @SYMFssID BA/CTSY/CCON-0056
 * @SYMTestCaseDesc Remove SIM during call
 * @SYMTestPriority High
 * @SYMTestActions RMobilePhone::GetNetworkRegistrationStatus, RLine::NotifyStatusChange, RLine::GetStatus, RMobileLine::NotifyMobileLineStatusChange, RMobileLine::GetMobileLineStatus, RCall::NotifyStatusChange, RCall::GetStatus, RMobileCall::NotifyMobileCallStatusChange, RMobileCall::GetMobileCallStatus
 * @SYMTestExpectedResults Pass - Phone is not registered on network after 35s of SIM removal.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/manual
 *
 * Reason for test: Verify network registration status, call and line statuses are correct
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	
	// Get Voice Line 1 

	// Get Call 1 

	// Dial a number that answers 

	// Ensure call is connected before starting test 


	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Check RMobilePhone::GetNetworkRegistrationStatus returns ERegisteredOnHomeNetwork

	// Remove SIM. 

	// Wait for 35 seconds. 

	// Check RMobilePhone::NotifyNetworkRegistrationStatusChange completes with one of ENotRegisteredSearching | ENotRegisteredEmergencyOnly

	// Check RMobilePhone::GetNetworkRegistrationStatus returns one of ENotRegisteredSearching | ENotRegisteredEmergencyOnly

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusIdle

	// Check RLine::GetStatus returns EStatusIdle

	// Check RMobileLine::NotifyMobileLineStatusChange completes with EStatusIdle

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusIdle

	// Check RCall::GetStatus returns EStatusIdle

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusIdle

	// Check RMobileCall::GetMobileCallStatus returns EStatusIdle

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Put any required test clean up here, then remove this comment
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0056::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0056");
	}



CCTSYIntegrationTestCallControl0057::CCTSYIntegrationTestCallControl0057(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0057::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0057::~CCTSYIntegrationTestCallControl0057()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0057::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0057
 * @SYMFssID BA/CTSY/CCON-0057
 * @SYMTestCaseDesc Remove SIM during idle mode
 * @SYMTestPriority High
 * @SYMTestActions RMobileLine::NotifyMobileLineStatusChange, RMobileCall::GetMobileCallStatus, RCall::Dial, RMobilePhone::NotifyNetworkRegistrationStatusChange, RMobileCall::GetMobileCallInfo, RMobileCall::NotifyMobileCallStatusChange, RCall::NotifyStatusChange, RLine::NotifyStatusChange, RLine::GetStatus, RLine::GetStatus, RMobileLine::GetMobileLineStatus, RMobilePhone::GetNetworkRegistrationStatus, RMobileCall::DialEmergencyCall, RCall::GetStatus
 * @SYMTestExpectedResults Pass - Only emergency numbers can be dialled without SIM.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies simulated/manual
 *
 * Reason for test: Verify only emergency calls can be made without a SIM.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	// Ensure phone is camped on simulated network. 

	// Get Voice Line 1 

	// Get Call 1 


	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Remove SIM. 

	// Check RMobilePhone::NotifyNetworkRegistrationStatusChange completes with one of ENotRegisteredSearching | ENotRegisteredEmergencyOnly

	// Check RMobilePhone::GetNetworkRegistrationStatus returns one of ENotRegisteredSearching | ENotRegisteredEmergencyOnly

	// ===  Check line status and call status ===

	// Check RLine::GetStatus returns EStatusIdle.

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle.

	// Check RCall::GetStatus returns EStatusIdle.

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.

	// ===  Attempt to dial a non-emergency number ===

	// Dial a non-emergency number with RCall::Dial 

	// Wait for completion 

	// Check error is returned.

	// ===  Check line status and call status ===

	// Check RLine::GetStatus returns EStatusIdle.

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle.

	// Check RCall::GetStatus returns EStatusIdle.

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.

	// ===  Attempt to dial the international emergency number, simulate answering ===

	// Dial emergency number with RCall::DialEmergencyCall 

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.

	// Check RCall::GetStatus returns EStatusConnected.

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.

	// Check RLine::GetStatus returns EStatusConnected

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDialling -> EStatusConnecting -> EStatusConnected.

	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected

	// ===  Check call info ===

	// Check RMobileCall::GetMobileCallInfo returns valid call name
	// Check RMobileCall::GetMobileCallInfo returns valid line name
	// Check RMobileCall::GetMobileCallInfo returns correct number in iDialledParty.iTelNumber
	// Check RMobileCall::GetMobileCallInfo returns iEmergency == ETrue
	// Check RMobileCall::GetMobileCallInfo returns iStatus of EStatusConnected
	// Check RMobileCall::GetMobileCallInfo returns correct iRemoteNumber and iDirection in iRemoteParty
	// Check RMobileCall::GetMobileCallInfo returns correct iValid for returned parameters

	// Hang up. 

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle.

	// Check RCall::GetStatus returns EStatusIdle.

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle.

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.

	// ===  Check line status ===

	// Check RMobileLine::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle

	// Check RMobileLine::GetStatus returns EStatusIdle

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDisconnecting -> EStatusIdle

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle

	// ===  Attempt to dial national emergency number ===

	// Dial emergency number with RCall::DialEmergencyCall 

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.

	// Check RCall::GetStatus returns EStatusConnected.

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.

	// Check RLine::GetStatus returns EStatusConnected

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDialling -> EStatusConnecting -> EStatusConnected.

	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected

	// ===  Check call info ===

	// Check RMobileCall::GetMobileCallInfo returns valid call name
	// Check RMobileCall::GetMobileCallInfo returns valid line name
	// Check RMobileCall::GetMobileCallInfo returns correct number in iDialledParty.iTelNumber
	// Check RMobileCall::GetMobileCallInfo returns iEmergency == ETrue
	// Check RMobileCall::GetMobileCallInfo returns iStatus of EStatusConnected
	// Check RMobileCall::GetMobileCallInfo returns correct iRemoteNumber and iDirection in iRemoteParty
	// Check RMobileCall::GetMobileCallInfo returns correct iValid for returned parameters

	// Hang up. 

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle.

	// Check RCall::GetStatus returns EStatusIdle.

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle.

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.

	// ===  Check line status ===

	// Check RMobileLine::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle

	// Check RMobileLine::GetStatus returns EStatusIdle

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDisconnecting -> EStatusIdle

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Put any required test clean up here, then remove this comment
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0057::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0057");
	}



CCTSYIntegrationTestCallControl0058::CCTSYIntegrationTestCallControl0058(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0058::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0058::~CCTSYIntegrationTestCallControl0058()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0058::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0058
 * @SYMFssID BA/CTSY/CCON-0058
 * @SYMTestCaseDesc Remove SIM and replace with another SIM.
 * @SYMTestPriority High
 * @SYMTestActions RMobilePhone::GetNetworkRegistrationStatus, RCall::Dial, RCall::HangUp, RLine::NotifyStatusChange, RLine::GetStatus, RMobileLine::NotifyMobileLineStatusChange, RMobileLine::GetMobileLineStatus, RCall::NotifyStatusChange, RCall::GetStatus, RMobileCall::NotifyMobileCallStatusChange, RMobileCall::GetMobileCallStatus
 * @SYMTestExpectedResults Pass - Phone uses new SIM when SIM replaced.
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/manual
 *
 * Reason for test: Verify remote party receives call from new SIM phone number.
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////

	// Ensure phone is camped on network. 
	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	
	// Remove SIM. 

	// Replace with another SIM. 

	// Reinitialise the TSY? 

	// Check RMobilePhone::GetNetworkRegistrationStatus returns one of ERegisteredOnHomeNetwork

	// Get call 1. 

	// Get voice line 1. 

	// Dial outgoing call to RPS which answers. 

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.

	// Check RCall::GetStatus returns EStatusConnected.

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.

	// ===  Check line status ===

	// Check RLine::NotifyStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.

	// Check RLine::GetStatus returns EStatusConnected

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDialling -> EStatusConnecting -> EStatusConnected.

	// Check RMobileLine::GetMobileLineStatus returns EStatusConnected

	// RPS returns MO number as being from the new SIM. 

	// Hang up. 

	// ===  Check call status ===

	// Check RCall::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle.

	// Check RCall::GetStatus returns EStatusIdle.

	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle.

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.

	// ===  Check line status ===

	// Check RMobileLine::NotifyStatusChange completes with EStatusHangingUp -> EStatusIdle

	// Check RMobileLine::GetStatus returns EStatusIdle

	// Check RMobileLine::NotifyMobileLineStatusChange completes with with EStatusDisconnecting -> EStatusIdle

	// Check RMobileLine::GetMobileLineStatus returns EStatusIdle

	// RPS dials old SIM number. 

	// Verify phone does not respond. 

	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Put any required test clean up here, then remove this comment
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0058::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0058");
	}

CCTSYIntegrationTestCallControl0059::CCTSYIntegrationTestCallControl0059(CEtelSessionMgr& aEtelSessionMgr)
	: CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
	{
	SetTestStepName(CCTSYIntegrationTestCallControl0059::GetTestStepName());
	}

CCTSYIntegrationTestCallControl0059::~CCTSYIntegrationTestCallControl0059()
/**
 * Destructor.
 */
	{
	}

TVerdict CCTSYIntegrationTestCallControl0059::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0059
 * @SYMFssID BA/CTSY/CCON-0059
 * @SYMTestCaseDesc Update life time parameter with call duration
 * @SYMTestPriority High
 * @SYMTestActions
 * @SYMTestExpectedResults Pass - Life time param updated after call executed
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test
 *
 * @return - TVerdict code
 */
	{

	////////////////////////////////////////////////////////////////
	// SET UP
	////////////////////////////////////////////////////////////////
	
	// Check phone supports KCapsVoice
	// Get Voice line 1 
	RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);
	// Get call 1 
	RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);

	RLine::TCaps lineCaps; 
	CHECK_TRUE_L(voiceLine.GetCaps(lineCaps) == KErrNone,  
			_L("RMobileLine::GetCaps returned an error"));
	CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits,  
			_L("RLine::GetCaps returned wrong caps"));	

	// Ensure phone is camped on network. 
	// Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL
	RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
 	CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone,
				   _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
	RMmCustomAPI& customApi = iEtelSessionMgr.GetCustomApiL(KMainServer, KMainPhone, KMainCustomApi);					   

	////////////////////////////////////////////////////////////////
	// SET UP END
	////////////////////////////////////////////////////////////////
	
	StartTest();
	
	////////////////////////////////////////////////////////////////
	// TEST START
	////////////////////////////////////////////////////////////////
	
	// calling RMmCustomAPI::GetLifeTime() to retrieve current LTSY value for life time param before the call:
    TExtEtelRequestStatus getLifeTimeStatus(customApi, ECustomGetLifeTimeIPC);    
	CleanupStack::PushL(getLifeTimeStatus);	
    RMmCustomAPI::TLifeTimeData ltData;
    TPckg<RMmCustomAPI::TLifeTimeData> ltPckg(ltData);
    customApi.GetLifeTime(getLifeTimeStatus, ltPckg);    
    ASSERT_EQUALS(WaitForRequestWithTimeOut(getLifeTimeStatus, ETimeLong), KErrNone, _L("RMmCustomAPI::GetLifeTime timed out"));
    ASSERT_EQUALS(getLifeTimeStatus.Int(), KErrNone, _L("RMmCustomAPI::GetLifeTime returned an error"));	
	DEBUG_PRINTF3(_L("Life Time param before the call: hours=%d, min=%d"), ltData.iHours, ltData.iMinutes);
    
			
	// post a notifier for RMobileCall::NotifyMobileCallStatusChange
	TExtEtelRequestStatus notifyMobileCallChangeStatus(call1, EMobileCallNotifyMobileCallStatusChange);
	CleanupStack::PushL(notifyMobileCallChangeStatus);
	RMobileCall::TMobileCallStatus mobileCallStatus;
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	// Dial RPS which answers 
	TPtrC number;
	GetRPSNumber(EVoiceLine,number);
	RPSAnswerNextCallL(EVoiceLine);
	
	TCoreEtelRequestStatus<RMobileCall> dialStatus(call1, &RCall::DialCancel);
	CleanupStack::PushL(dialStatus);											 
	call1.Dial(dialStatus, number);	
	ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone,  
			_L("RCall::Dial timed-out"));
	ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
			_L("RCall::Dial Expected KErrNone, but an error returned"));
			
	// ===  Check call status ===
	
	const TInt wantedStatus = KErrNone;	
	
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDialling -> EStatusConnecting -> EStatusConnected.
	RMobileCall::TMobileCallStatus expectedMobileCallStatus = RMobileCall::EStatusDialling;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusConnected;															
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	// Check RMobileCall::GetMobileCallStatus returns status of EStatusConnected.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusConnected,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusConnected"));
			
	User::After(180000000);	// Wait added for call duration of 3min
	
	//==== Post Notifiers ========
	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	
	// RPS hangs up. 
	ASSERT_EQUALS(RPSHangupL(EVoiceLine,0), KErrNone, _L("CCTSYIntegrationTestSuiteStepBase::RPSHangup returned an error"));
	
	// Check RMobileCall::NotifyMobileCallStatusChange completes with EStatusDisconnecting -> EStatusIdle.
	expectedMobileCallStatus = RMobileCall::EStatusDisconnecting;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);

	call1.NotifyMobileCallStatusChange(notifyMobileCallChangeStatus, mobileCallStatus);
	expectedMobileCallStatus = RMobileCall::EStatusIdle;
	iCallControlTestHelper.WaitForMobileCallNotifyMobileCallStatusChange(call1,
															notifyMobileCallChangeStatus,
															mobileCallStatus,
															expectedMobileCallStatus,
															wantedStatus);
															
	// Check RMobileCall::GetMobileCallStatus returns status of EStatusIdle.
	ASSERT_EQUALS(call1.GetMobileCallStatus(mobileCallStatus), KErrNone,  
			_L("RMobileCall::GetMobileStatus returned an error"));
	ASSERT_EQUALS(mobileCallStatus, RMobileCall::EStatusIdle,  
			_L("RMobileCall::GetMobileStatus did not return a status EStatusIdle"));
			
	// calling RMmCustomAPI::GetLifeTime() to retrieve current LTSY value for life time param after the call:
    customApi.GetLifeTime(getLifeTimeStatus, ltPckg);    
    ASSERT_EQUALS(WaitForRequestWithTimeOut(getLifeTimeStatus, ETimeLong), KErrNone, _L("RMmCustomAPI::GetLifeTime timed out"));
    ASSERT_EQUALS(getLifeTimeStatus.Int(), KErrNone, _L("RMmCustomAPI::GetLifeTime returned an error"));	
	DEBUG_PRINTF3(_L("Life Time param after the call: hours=%d, min=%d"), ltData.iHours, ltData.iMinutes);											
	
	////////////////////////////////////////////////////////////////
	// TEST END
	////////////////////////////////////////////////////////////////

    StartCleanup();
	
	// Put any required test clean up here, then remove this comment
	
	CleanupStack::PopAndDestroy(3,&getLifeTimeStatus);	
	
	return TestStepResult();
	}

TPtrC CCTSYIntegrationTestCallControl0059::GetTestStepName()
/**
 * @return The test step name.
 */
	{
	return  _L("CCTSYIntegrationTestCallControl0059");
	}



CCTSYIntegrationTestCallControl0060::CCTSYIntegrationTestCallControl0060(CEtelSessionMgr& aEtelSessionMgr)
    : CCTSYIntegrationTestCallControlBase(aEtelSessionMgr)
/**
 * Constructor.
 */
    {
    SetTestStepName(CCTSYIntegrationTestCallControl0060::GetTestStepName());
    }

CCTSYIntegrationTestCallControl0060::~CCTSYIntegrationTestCallControl0060()
/**
 * Destructor.
 */
    {
    }

TVerdict CCTSYIntegrationTestCallControl0060::doTestStepL()
/**
 * @SYMTestCaseID BA-CTSY-INT-CCON-0060
 * @SYMFssID BA/CTSY/CCON-0060
 * @SYMTestCaseDesc Update life time parameter with call duration
 * @SYMTestPriority High
 * @SYMTestActions
 * @SYMTestExpectedResults Pass - Life time param updated after call executed
 * @SYMTestType CIT
 * @SYMTestCaseDependencies live/automatic
 *
 * Reason for test
 *
 * @return - TVerdict code
 */
    {
    ////////////////////////////////////////////////////////////////
    // SET UP
    ////////////////////////////////////////////////////////////////
    RMobilePhone& phone = iEtelSessionMgr.GetPhoneL(KMainServer,KMainPhone);
    
    // Get Voice line 1 
    RMobileLine& voiceLine = iEtelSessionMgr.GetLineL(KMainServer, KMainPhone, KVoiceLine);

    // Get call 1 
    RMobileCall& call1 = iEtelSessionMgr.GetCallL(KMainServer, KMainPhone, KVoiceLine, KCall1);
        
    // Check phone supports KCapsVoice
    RLine::TCaps lineCaps; 
    CHECK_EQUALS_L(voiceLine.GetCaps(lineCaps), KErrNone, 
            _L("RMobileLine::GetCaps returned an error"));
    CHECK_BITS_SET_L(lineCaps.iFlags, RLine::KCapsVoice, KNoUnwantedBits, 
            _L("RLine::GetCaps returned wrong caps"));
    
    // Call TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL      
    CHECK_EQUALS_L(iNetworkTestHelper.WaitForRegisteredOnHomeNetworkL(phone), KErrNone, _L("TNetworkTsyTestHelper::WaitForRegisteredOnHomeNetworkL returned with an error"));
    RMmCustomAPI& customApi = iEtelSessionMgr.GetCustomApiL(KMainServer, KMainPhone, KMainCustomApi);     
    
    ////////////////////////////////////////////////////////////////
    // SET UP END
    ////////////////////////////////////////////////////////////////
    
    StartTest();
    
    ////////////////////////////////////////////////////////////////
    // TEST START
    ////////////////////////////////////////////////////////////////
    
    // calling RMmCustomAPI::GetLifeTime() to retrieve current LTSY value for life time param before the call:
    TExtEtelRequestStatus getLifeTimeStatus(customApi, ECustomGetLifeTimeIPC);    
    CleanupStack::PushL(getLifeTimeStatus); 
    
    RMmCustomAPI::TLifeTimeData lifeTimeData;
    lifeTimeData.iHours = 0;
    lifeTimeData.iMinutes = 0;  
    TPckg<RMmCustomAPI::TLifeTimeData> lifeTimePckg(lifeTimeData);
    
    customApi.GetLifeTime(getLifeTimeStatus, lifeTimePckg);    
    ASSERT_EQUALS(WaitForRequestWithTimeOut(getLifeTimeStatus, ETimeLong), KErrNone, _L("RMmCustomAPI::GetLifeTime timed out"));
    ASSERT_EQUALS(getLifeTimeStatus.Int(), KErrNone, _L("RMmCustomAPI::GetLifeTime returned an error"));    
    DEBUG_PRINTF3(_L("Life Time param before the call: hours=%d, min=%d"), lifeTimeData.iHours, lifeTimeData.iMinutes);
    
    TUint8 minutes = lifeTimeData.iMinutes ;
    
    // Check RPhone::GetLineInfo returns iStatus of EStatusIdle
    RPhone::TLineInfo lineInfo;
    TInt lineIndex=0;
    ASSERT_EQUALS(phone.GetLineInfo(lineIndex, lineInfo), KErrNone,
            _L("RPhone::GetLineInfo returned an error"));
    ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusIdle, 
            _L("RPhone::GetLineInfo wrong iStatus, should be EStatusIdle"));
    
    // Check RPhone::GetLineInfo returns iLineCapsFlags of KCapsVoice
    ASSERT_BITS_SET(lineInfo.iLineCapsFlags, RLine::KCapsVoice, KNoUnwantedBits, 
            _L("RPhone::GetLineInfo returned wrong caps")); 

    // Check RPhone::GetLineInfo returns a valid line name
    ASSERT_TRUE(lineInfo.iName.Length() >0,  
            _L("RPhone::GetLineInfo wrong call name"));
    
    // Get the voice number that answers.
    TPtrC number; 
    ASSERT_TRUE(GetStringFromConfig(KIniVoiceNumSection, KIniVoiceNumber1, number) != EFalse,             
            _L("CTestStep::GetStringFromConfig did not complete as expected"));
    
    TCoreEtelRequestStatus<RCall> dialStatus(call1, &RCall::DialCancel);
    CleanupStack::PushL(dialStatus);
    
    // make 3 calls 70 seconds each and check if Life Timer is increased by at least a minute each time
    TInt callCount = 3;
    
    for (TInt i = 0; i < callCount; i++)
        {
        call1.Dial(dialStatus, number); 
        ASSERT_EQUALS(WaitForRequestWithTimeOut(dialStatus, ETimeMedium), KErrNone, 
                _L("RCall::Dial timed-out"));
        ASSERT_EQUALS(dialStatus.Int(), KErrNone,  
                _L("RCall::Dial returned with an error"));

        // Check RPhone::GetLineInfo returns iStatus of EStatusConnected
        ASSERT_EQUALS(phone.GetLineInfo(lineIndex, lineInfo), KErrNone,  
                _L("RPhone::GetLineInfo returned an error"));
        ASSERT_EQUALS(lineInfo.iStatus, RCall::EStatusConnected, 
                _L("RPhone::GetLineInfo wrong iStatus, should be EStatusConnected"));

        // Check RPhone::GetLineInfo returns a valid line name
        ASSERT_TRUE(lineInfo.iName.Length() >0,  
                _L("RPhone::GetLineInfo wrong call name"));
        
        User::After(70*KOneSecond);   // Wait added for call duration of just over a minute
     
        // hang up the active call
        TCoreEtelRequestStatus<RCall> hangUpStatus (call1,&RCall::HangUpCancel);    
        CleanupStack::PushL(hangUpStatus);
        call1.HangUp(hangUpStatus);
        WaitForRequestWithTimeOut(hangUpStatus, ETimeMedium);   
        
        // calling RMmCustomAPI::GetLifeTime() to retrieve current LTSY value for life time param after the call:
        customApi.GetLifeTime(getLifeTimeStatus, lifeTimePckg);

        ASSERT_EQUALS(WaitForRequestWithTimeOut(getLifeTimeStatus, ETimeLong), KErrNone, _L("RMmCustomAPI::GetLifeTime timed out"));
        ASSERT_EQUALS(getLifeTimeStatus.Int(), KErrNone, _L("RMmCustomAPI::GetLifeTime returned an error"));    
        DEBUG_PRINTF3(_L("Life Time param after the call: hours=%d, min=%d"), lifeTimeData.iHours, lifeTimeData.iMinutes);   
        
        minutes++;
        ASSERT_TRUE( minutes <= lifeTimeData.iMinutes, _L("Life Time was not updated properly") );
        }

    ////////////////////////////////////////////////////////////////
    // TEST END
    ////////////////////////////////////////////////////////////////

    StartCleanup();
    CleanupStack::PopAndDestroy(3,&getLifeTimeStatus);
    return TestStepResult();
    }

TPtrC CCTSYIntegrationTestCallControl0060::GetTestStepName()
/**
 * @return The test step name.
 */
    {
    return  _L("CCTSYIntegrationTestCallControl0060");
    }
