// Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include "Te_SimCallOpenTest.h"

CSimCallOpenTest::CSimCallOpenTest() 
	{ 
	SetTestStepName(_L("CallOpenTest"));
	}

TVerdict CSimCallOpenTest::doTestStepL()
	{
	INFO_PRINTF1(_L("BeginCallOpenTest"));

 	CreateConfigFileL(_L("c:\\config3.txt"));
 	SetTestNumberL(0);

	TInt ret = iPhone.Open(iTelServer,KPhoneName); 
	INFO_PRINTF2(_L("Result: %d"),ret); 
	TESTL(ret == KErrNone); 
	INFO_PRINTF1(_L("Opened phone object"));

	TESTL(iPhone.Initialise()==KErrNone);
	INFO_PRINTF1(_L("Opened phone object"));

	TESTL(iLine.Open(iPhone,KVoiceLineName)==KErrNone);
	INFO_PRINTF1(_L("Opened Line object"));

	INFO_PRINTF1(_L("Testing openning two voice call objects in sequence"));
	TName callName;
	TName callName2;
	TESTL(iCall.OpenNewCall(iLine,callName)==KErrNone);
	iCall.Close();
	TESTL(iCall2.OpenNewCall(iLine,callName2)==KErrNone);
	iCall2.Close();

	INFO_PRINTF1(_L("Testing openning two voice call objects in parallel"));
	TESTL(iCall.OpenNewCall(iLine,callName)==KErrNone);
	TESTL(iCall2.OpenNewCall(iLine,callName2)==KErrNone);
	iCall.Close();
	iCall2.Close();

	INFO_PRINTF1(_L("Testing posting Answering Incoming Call, Cancelling and then Simulating an Incoming Call."));
	TESTL(iCall.OpenNewCall(iLine,callName)==KErrNone);
	TRequestStatus stat0;
	iCall.AnswerIncomingCall(stat0);
	User::After(1000000L);
	iCall.AnswerIncomingCallCancel();
	User::WaitForRequest(stat0);
	TESTL(stat0==KErrCancel);

	TName incomingCallName;
	iLine.NotifyIncomingCall(stat0,incomingCallName);
	
	TInt state = 998;
	RProperty::Set(KUidPSSimTsyCategory, KPSSimTsyIncomingVoiceCall, state);
	User::WaitForRequest(stat0);
	TESTL(stat0==0);
	TESTL(iCall2.OpenExistingCall(iLine,incomingCallName)==KErrNone);
	INFO_PRINTF1(_L("\t...Answering Call"));
	iCall2.AnswerIncomingCall(stat0);
	User::WaitForRequest(stat0);
	TESTL(stat0==KErrNone);
	INFO_PRINTF1(_L("\t...HangingUp Call"));
	TESTL(iCall2.HangUp()==KErrNone);
	iCall2.Close();
	iCall.Close();

	iLine.Close();
	iPhone.Close();
	ASSERT(RThread().RequestCount()==0);

	return TestStepResult();
	}

