// Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Helpers to get the referencies to the  specification
// 
//



/**
 @file
*/

#ifndef __TE_SIM_CONSTANTS__
#define __TE_SIM_CONSTANTS__

_LIT(KSimPrimaryPacketContextName,"PRIMARY");

#if defined(_UNICODE)
#define	CHP_SRVS_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_CNTXT_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_QOS_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_VOICE_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_DATA_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_SMS_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_NTWK_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_PHBK_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_APPS_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_SECURITY_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define CHP_IMS_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#else
#define	CHP_SRVS_CASE(the_case) (TPtrC((const TText *)("Case: " the_case)))
#define	CHP_CNTXT_CASE(the_case) (TPtrC((const TText *)("Case: " the_case)))
#define	CHP_QOS_CASE(the_case) (TPtrC((const TText *)("Case: " the_case)))
#define	CHP_VOICE_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_DATA_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_SMS_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_NTWK_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_PHBK_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_APPS_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define	CHP_SECURITY_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#define CHP_IMS_CASE(the_case) (TPtrC((const TText *)(L"Case: " L##the_case)))
#endif

// Authorisation token and flow identifier constants
#define SIMTSY_AUTH_TOKEN_TEST_1      (_L8("Test1"))
#define SIMTSY_COMP_NUMBER1_TEST_1    (1)
#define SIMTSY_IPFLOW_NUMBER1_TEST_1  (2)
#define SIMTSY_COMP_NUMBER2_TEST_1    (3)
#define SIMTSY_IPFLOW_NUMBER2_TEST_1  (4)

#define SIMTSY_AUTH_TOKEN_TEST_2      (_L8("Test2"))
#define SIMTSY_COMP_NUMBER1_TEST_2    (5)
#define SIMTSY_IPFLOW_NUMBER1_TEST_2  (6)
#define SIMTSY_COMP_NUMBER2_TEST_2    (7)
#define SIMTSY_IPFLOW_NUMBER2_TEST_2  (8)
#define SIMTSY_ICON_ID		      	  0

typedef TBuf8<200> TSmsPdu;

TInt StartNTRasSimulation(void);

_LIT(KSmsStoreName, "S14");

_LIT(KTelephoneNumber,"+1234");
_LIT(KTelephoneNumber2,"1234");

const TUint8 KTestPduA[]= { 0x01, 0xa0 };
_LIT(KScaNumberA,"01632960000");
const TUint8 KTestPduB[]= { 0x01, 0xa1 };
_LIT(KScaNumberB,"01632960000");

const TUint8 KTestPduRx1[]= { 0x01, 0xa0 };
_LIT(KScaNumber1,"01632960000");
const TUint8 KTestPduRx2[]= { 0x02, 0xa0 };
_LIT(KScaNumber2,"01632960000");
const TUint8 KTestPduRx3[]= { 0x03, 0xa1 };
_LIT(KScaNumber3,"01632960000");


const TUint8 KTestPduC[]= { 0x12, 0x34 };
const TUint KCallCaps=(RCall::KCapsVoice | RCall::KCapsDial | RCall::KCapsAnswer);
const TUint KLineCaps=(RLine::KCapsVoice | RLine::KCapsEventIncomingCall);
const TUint32 KIndicatorActionCaps=(RMobilePhone::KCapsGetIndicator |	RMobilePhone::KCapsNotifyIndicatorChange);
const TUint32 KIndicatorIndCaps=(RMobilePhone::KIndChargerConnected |	RMobilePhone::KIndNetworkAvailable | RMobilePhone::KIndCallInProgress);

const TUint32 KBatteryChargerCaps=(RMobilePhone::KCapsGetBatteryInfo |	RMobilePhone::KCapsNotifyBatteryInfoChange);

_LIT(KVodafoneSca,"+4441632960000");
_LIT(KOrangeSca,"01632960000");

const TUint8 KTestPhonebookA[]= { 
    0xA0, 0xC0, 0x01, 0x00, 0x00, 0xC1, 0x12, 0x00, 0x41, 0x00, 
    0x6E, 0x00, 0x64, 0x00, 0x79, 0x00, 0x4c, 0x00, 0x6f, 0x00, 
    0x63, 0x00, 0x61, 0x00, 0x6c, 0x00, 0xC3, 0x81, 0x00, 0xC2, 
    0x16, 0x00, 0x30, 0x00, 0x31, 0x00, 0x36, 0x00, 0x33, 0x00, 
    0x32, 0x00, 0x39, 0x00, 0x36, 0x00,	0x30, 0x00, 0x30, 0x00, 
    0x30, 0x00, 0x30, 0x00};


const TUint8 KTestPhonebookB[]= { 0xA0, 0xC2, 0x16, 0x00, 0x30, 0x00, 0x37, 0x00, 0x37, 0x00,
	0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x36, 0x00, 0x35, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36,
	0x00, 0xC3, 0x91, 0x00, 0xC1, 0x08, 0x00,
	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00};

const TUint8 KTestUSimPhonebookA[]= {
	0xa0,0xc0,0x01,0x00,0x00,0xc1,0x08,0x00,0x4d,0x00,0x69,
	0x00,0x6b,0x00,0x65,0x00,0xc3,0x81,0x00,0x00,0x00,0xc2,
	0x06,0x00,0x35,0x00,0x31,0x00,0x33,0x00,0x00,0x00,0x00,
	0xc6,0x0e,0x00,0x4e,0x00,0x69,0x00,0x6b,0x00,0x69,0x00,
	0x74,0x00,0x61,0x00,0x73,0x00,0xc5,0x00,0x00,0xc1,0x0c,
	0x00,0x4d,0x00,0x6f,0x00,0x62,0x00,0x69,0x00,0x6c,0x00,
	0x65,0x00,0x00,0xc2,0x16,0x00,0x30,0x00,0x31,0x00,0x36,
	0x00,0x33,0x00,0x32,0x00,0x39,0x00,0x36,0x00,0x30,0x00,
	0x30,0x00,0x30,0x00,0x30,0x00,0xc3,0x81,0x00,0xc8,0x26,
	0x00,0x61,0x00,0x6e,0x00,0x69,0x00,0x6b,0x00,0x69,0x00,
	0x74,0x00,0x61,0x00,0x73,0x00,0x40,0x00,0x65,0x00,0x78,
	0x00,0x63,0x00,0x69,0x00,0x74,0x00,0x65,0x00,0x2e,0x00,
	0x63,0x00,0x6f,0x00,0x6d,0x00,0x00,0x00,0x00,0xc7,0x08,
	0x00,0x57,0x00,0x6f,0x00,0x72,0x00,0x6b,0x00,0xca,0x00};

const TUint8 KTestUSimPhonebookB[]= {
	0xa0,0x00,0x00,0xc1,0x08,0x00,0x4d,0x00,0x69,0x00,0x6b,
	0x00,0x65,0x00,0xc3,0x81,0x00,0x00,0x00,0xc2,0x06,0x00,
	0x35,0x00,0x31,0x00,0x33,0x00,0x00,0x00,0x00,0xc6,0x0e,
	0x00,0x4e,0x00,0x69,0x00,0x6b,0x00,0x69,0x00,0x74,0x00,
	0x61,0x00,0x73,0x00,0xc5,0x01,0x00,0xc1,0x0c,0x00,0x4d,
	0x00,0x6f,0x00,0x62,0x00,0x69,0x00,0x6c,0x00,0x65,0x00,
	0xc3,0x81,0x00,0x00,0x00,0xc2,0x16,0x00,0x30,0x00,0x37,
	0x00,0x39,0x00,0x37,0x00,0x34,0x00,0x39,0x00,0x34,0x00,
	0x33,0x00,0x38,0x00,0x37,0x00,0x31,0x00,0x00,0x00,0x00,
	0xc8,0x26,0x00,0x61,0x00,0x6e,0x00,0x69,0x00,0x6b,0x00,
	0x69,0x00,0x74,0x00,0x61,0x00,0x73,0x00,0x40,0x00,0x65,
	0x00,0x78,0x00,0x63,0x00,0x69,0x00,0x74,0x00,0x65,0x00,
	0x2e,0x00,0x63,0x00,0x6f,0x00,0x6d,0x00,0x00,0x00,0x00,
	0xc7,0x08,0x00,0x57,0x00,0x6f,0x00,0x72,0x00,0x6b,0x00,
	0xca,0x00};

const TUint8 KTestUSimPhonebookC[]= {
	0xa0,0xc0,0x05,0x00,0x00,0xc1,0x08,0x00,0x41,0x00,0x6c, 
	0x00,0x65,0x00,0x78,0x00,0xc3,0x81,0x00,0x00,0x00,0xc2, 
	0x0e,0x00,0x35,0x00,0x31,0x00,0x33,0x00,0x33,0x00,0x34,
	0x00,0x35,0x00,0x36,0x00,0x00,0x00,0x00,0xc6,0x0e,0x00, 
	0x4e,0x00,0x69,0x00,0x6b,0x00,0x69,0x00,0x74,0x00,0x61, 
	0x00,0x73,0x00,0xc5,0x00,0x00,0xc1,0x0c,0x00,0x4d,0x00, 
	0x6f,0x00,0x62,0x00,0x69,0x00,0x6c,0x00,0x65,0x00,0x00, 
	0xc2,0x16,0x00,0x30,0x00,0x31,0x00,0x36,0x00,0x33,0x00, 
	0x32,0x00,0x39,0x00,0x36,0x00,0x30,0x00,0x30,0x00,0x30, 
	0x00,0x30,0x00,0xc3,0x81,0x00,0xc8,0x00,0x00,0x00,0xc7,
	0x00,0x00,0xca,0x00};

const TUint8 KTestPhonebookBigName[]= { 0xA0, 0xC2, 0x16, 0x00, 
	0x30, 0x00, 0x37, 0x00, 0x37, 0x00,
	0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x36, 0x00, 0x35, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00, 
	0xC3, 0x91, 0x00, 0xC1, 0x90, 0x00,
	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,
	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,
	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,
	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,
	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,
	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,
	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,
	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,
	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00,};

const TUint8 KTestPhonebookBigNumber[]= { 0xA0, 0xC2, 0x84, 0x00, 
	0x30, 0x00, 0x37, 0x00, 0x37, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x36, 0x00, 0x35, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00,
	0x30, 0x00, 0x37, 0x00, 0x37, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x36, 0x00, 0x35, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00,
	0x30, 0x00, 0x37, 0x00, 0x37, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x36, 0x00, 0x35, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00,
	0x30, 0x00, 0x37, 0x00, 0x37, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x36, 0x00, 0x35, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00,
	0x30, 0x00, 0x37, 0x00, 0x37, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x36, 0x00, 0x35, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00,
	0x30, 0x00, 0x37, 0x00, 0x37, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x36, 0x00, 0x35, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00,
	0x30, 0x00, 0x37, 0x00, 0x37, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x36, 0x00, 0x35, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00,
	0x30, 0x00, 0x37, 0x00, 0x37, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x36, 0x00, 0x35, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00,
	0x30, 0x00, 0x37, 0x00, 0x37, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x36, 0x00, 0x35, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00,
	0x30, 0x00, 0x37, 0x00, 0x37, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x36, 0x00, 0x35, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00,
	0x30, 0x00, 0x37, 0x00, 0x37, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x36, 0x00, 0x35, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00,
	0x30, 0x00, 0x37, 0x00, 0x37, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x36, 0x00, 0x35, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00,
	0xC3, 0x91, 0x00, 0xC1, 0x08, 0x00,
	0x41, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x79, 0x00};


const TUint8 KTestPhonebookC[]= { 
	0xA0, 0xC0, 0x05, 0x00, 0x00, 0xC1, 0x18, 0x00, 0x41, 0x00, 
	0x6E, 0x00, 0x64, 0x00, 0x79, 0x00, 0x49, 0x00,	0x6E, 0x00, 
	0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 0x6E, 0x00, 0x61, 0x00, 
	0x74, 0x00, 0xC3, 0x91, 0x00, 0x00,	0x00, 0xC2,	0x18, 0x00, 
	0x34, 0x00, 0x34, 0x00, 0x31, 0x00, 0x36, 0x00, 0x33, 0x00, 
	0x32, 0x00, 0x39, 0x00,	0x36, 0x00,	0x30, 0x00, 0x30, 0x00, 
	0x30, 0x00, 0x30, 0x00};


const TUint32 KSmsMessagingCaps = (TUint32)(RMobileSmsMessaging::KCapsReceiveUnstoredClientAck 
								| RMobileSmsMessaging::KCapsReceiveUnstoredPhoneAck 
								| RMobileSmsMessaging::KCapsReceiveStored
								| RMobileSmsMessaging::KCapsSendWithAck
								| RMobileSmsMessaging::KCapsGetSmspList
								| RMobileSmsMessaging::KCapsSetSmspList);
	
	
const TUint32 KSmsStoreCaps = (TUint32)(RMobilePhoneStore::KCapsWholeStore 
									  | RMobilePhoneStore::KCapsIndividualEntry
									  | RMobilePhoneStore::KCapsReadAccess
									  | RMobilePhoneStore::KCapsWriteAccess
									  | RMobilePhoneStore::KCapsDeleteAll
									  | RMobilePhoneStore::KCapsNotifyEvent
									| RMobileSmsStore::KCapsUnreadMessages
									| RMobileSmsStore::KCapsReadMessages
									| RMobileSmsStore::KCapsUnsentMessages
									| RMobileSmsStore::KCapsGsmMessages);
									  
									  
									  
							


const TUint32 KPhBkStoreCaps = (TUint32)(RMobilePhoneStore::KCapsWholeStore 
										| RMobilePhoneStore::KCapsIndividualEntry
										| RMobilePhoneStore::KCapsReadAccess
										| RMobilePhoneStore::KCapsWriteAccess
										| RMobilePhoneStore::KCapsDeleteAll
										| RMobilePhoneStore::KCapsNotifyEvent);

const TUint8 KTestSendPduA[]=	{ 0x01, 0xa0, 0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,
									0x01, 0xa0, 0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,
									0x01, 0xa0, 0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,
									0x01, 0xa0, 0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,
									0x01, 0xa0, 0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,
									0x01, 0xa0, 0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,
									0x01, 0xa0, 0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,
									0x01, 0xa0, 0x01, 0xa0,0x01, 0xa0,0x01, 0xa0,0x01, 0xa0 };
const TUint8 KTestSendPduB[]= { 0x01, 0xa0};

 
const TUint8 KTestSubmitReport[]= { 0x01, 0xa0 };
_LIT8(KTestDeliveryReport, "\x02\xb0");


_LIT(KTestSubscriberId,"5601632960000");

// Context Configuration
#define DPCKTTSY_PDP_TYPE1				RPacketContext::EPdpTypePPP
#define DPCKTTSY_ACCESS_POINT1			_L8("ACME INTERNET PROVIDERS LTD")
#define DPCKTTSY_PDP_ADDRESS1			_L8("i-MODE GATEWAY")
#define DPCKTTSY_COMPRESSION1			RPacketContext::KPdpDataCompression
#define DPCKTTSY_ANONYMOUS_ACCESS1		RPacketContext::ENotRequired
#define DPCKTTSY_EGPRS_REQUIRED			TRUE		

#define DPCKTTSY_CSY					_L("LOOPBACK.CSY")
#define DPCKTTSY_PORT					_L("LOOPBACK::0")

#define SIM_PACKET_SERVICE_CAPS (RPacketService::KCapsSuspendSupported | RPacketService::KCapsMSClassSupported |\
				RPacketService::KCapsCDMA2000HighSpeedDataSupported |\
				RPacketService::KCapsNetworkAvailabilitySupported | RPacketService::KCapsProtocolPPPSupported |\
				RPacketService::KCapsHSDPASupported | RPacketService::KCapsEGPRSSupported |\
				RPacketService::KCapsHSUPASupported)
#define SIM_PACKET_SERVICE_CAPS1 (RPacketService::KCapsSuspendSupported | RPacketService::KCapsNetworkAvailabilitySupported |\
								 RPacketService::KCapsProtocolPPPSupported | RPacketService::KCapsHSDPASupported |\
								 RPacketService::KCapsEGPRSSupported | RPacketService::KCapsHSUPASupported )
#define SIM_PACKET_SERVICE_CAPS2 (RPacketService::KCapsSuspendSupported | RPacketService::KCapsMSClassSupported |\
								 RPacketService::KCapsNetworkAvailabilitySupported | RPacketService::KCapsProtocolPPPSupported |\
								 RPacketService::KCapsHSDPASupported | RPacketService::KCapsEGPRSSupported |\
								 RPacketService::KCapsHSUPASupported )
#define SIM_PACKET_SERVICE_OPTION	RPacketContext::KHighSpeedCDMA2000Data
#define SIM_PACKET_PROTOCOL			RPacketContext::EPdpTypePPP
#define SIM_DEFAULT_PARAM			RPacketContext::KHighSpeedCDMA2000Data

// CHAP authentication
#define SIM_PACKET_CONTEXT_PROTOCOL1 RPacketContext::EProtocolCHAP
#define SIM_PACKET_CONTEXT_USERNAME1 _L8("USER1")
#define SIM_PACKET_CONTEXT_PASSWORD1 _L8("PASSWORD1")
#define SIM_PACKET_CONTEXT_CHALLENGE1 _L8("CHALLENGE1")
#define SIM_PACKET_CONTEXT_RESPONSE1 _L8("RESPONSE1")
#define SIM_PACKET_CONTEXT_PRIMARYSERVER1 _L8("PRIMARYSERVER1")
#define SIM_PACKET_CONTEXT_SECONDARYSERVER1 _L8("SECONDARYSERVER1")
#define SIM_PACKET_CONTEXT_ID1 1
#define SIM_PACKET_CONTEXT_PCO_ID 4

// PAP authentication 
#define SIM_PACKET_CONTEXT_PROTOCOL2 RPacketContext::EProtocolPAP
#define SIM_PACKET_CONTEXT_USERNAME2 _L8("USER2")
#define SIM_PACKET_CONTEXT_PASSWORD2 _L8("PASSWORD2")
#define SIM_PACKET_CONTEXT_CHALLENGE2 _L8("NULL")
#define SIM_PACKET_CONTEXT_RESPONSE2 _L8("NULL")
#define SIM_PACKET_CONTEXT_PRIMARYSERVER2 _L8("PRIMARYSERVER2")
#define SIM_PACKET_CONTEXT_SECONDARYSERVER2 _L8("SECONDARYSERVER2")
#define SIM_PACKET_CONTEXT_ID2 2

// GPRS Context Configuration
#define GPRS_PACKET_CONTEXT_PCO_ID 5
#define GPRS_CONTEXT_ADDITIONAL_PARAM_LEN	16		
#define GPRS_PACKET_CONTEXT_ADDITIONAL_PARAM	_L8("ADDITIONALPARAM3")

// R99_R4 Context Configuration
#define R99_R4_PACKET_CONTEXT_PCO_ID 6
#define R99_R4_CONTEXT_ADDITIONAL_PARAM_LEN	16		
#define R99_R4_PACKET_CONTEXT_ADDITIONAL_PARAM	_L8("ADDITIONALPARAM4")

//R5 Context Configuration 1
#define R5_CONTEXT_PROTOCOL		RPacketContext::EPdpTypeIPv4
#define R5_CONTEXT_GGSN			_L8("SYMBIAN INTERNET PROVIDER")
#define R5_CONTEXT_PDP_ADDRESS	_L8("PROTOCOL ADDRESS")
#define R5_CONTEXT_USE_EDGE		FALSE
#define R5_CONTEXT_AUTH_PROT	RPacketContext::EProtocolCHAP
#define R5_CONTEXT_USERNAME		_L8("USER3")
#define R5_CONTEXT_PASSWORD		_L8("PASSWORD3")
#define R5_CONTEXT_CHALLENGE	_L8("CHALLENGE3")
#define R5_CONTEXT_RESPONSE		_L8("RESPONSE3")
#define R5_CONTEXT_DNS1			_L8("PRIMARYSERVER3")
#define R5_CONTEXT_DNS2			_L8("SECONDARYSERVER3")
#define R5_CONTEXT_ID			3
#define R5_CONTEXT_HEADER_COMPRESSION	RPacketContext::ERfc1144
#define R5_CONTEXT_DATA_COMPRESSION		RPacketContext::EManufacturerDefaultDataCompression
#define R5_CONTEXT_PCO_ID				4
#define R5_CONTEXT_ADDITIONAL_PARAM_LEN	16		
#define R5_CONTEXT_ADDITIONAL_PARAM		_L8("ADDITIONALPARAM1")

//R5 Context Configuration 2
#define R5_CONTEXT_PROTOCOL2		RPacketContext::EPdpTypePPP
#define R5_CONTEXT_GGSN2			_L8("EASYNET ISP")
#define R5_CONTEXT_PDP_ADDRESS2		_L8("PROT. ADDRESS")
#define R5_CONTEXT_USE_EDGE2		TRUE
#define R5_CONTEXT_AUTH_PROT2		RPacketContext::EProtocolCHAP
#define R5_CONTEXT_USERNAME2		_L8("USER4")
#define R5_CONTEXT_PASSWORD2		_L8("PASSWORD4")
#define R5_CONTEXT_CHALLENGE2		_L8("CHALLENGE4")
#define R5_CONTEXT_RESPONSE2		_L8("RESPONSE4")
#define R5_CONTEXT_DNS1_2			_L8("PRIMARYSERVER4")
#define R5_CONTEXT_DNS2_2			_L8("SECONDARYSERVER4")
#define R5_CONTEXT_ID2				4
#define R5_CONTEXT_HEADER_COMPRESSION2	RPacketContext::ERfc2507
#define R5_CONTEXT_DATA_COMPRESSION2	RPacketContext::ENoDataCompression
#define R5_CONTEXT_PCO_ID2			4
#define R5_CONTEXT_ADDITIONAL_PARAM_LEN2	16		
#define R5_CONTEXT_ADDITIONAL_PARAM2	_L8("ADDITIONALPARAM2")

//Packet Filter Info - V3 Type 1
#define V3_PCKT_FILTER_ID									(1)
#define V3_PCKT_FILTER_EVALUATION_PRECEDENCE_INDEX			(0)
#define V3_PCKT_FILTER_PROTOCOLNUMBER_OR_NEXTHEADER			(6)
#define V3_PCKT_FILTER_MINIMUM_SOURCE_PORT_NUMBER			(2)
#define V3_PCKT_FILTER_MAXIMUM_SOURCE_PORT_NUMBER			(65000)
#define V3_PCKT_FILTER_MINIMUM_DESTINATION_PORT_NUMBER		(8)
#define V3_PCKT_FILTER_MAXIMUM_DESTINATION_PORT_NUMBER		(65100)
#define V3_PCKT_FILTER_TYPE_OF_SERVICE_OR_TRAFFIC_CLASS		(0x3F8C)

//for RSat
#define SIMTSY_REFRESH_TYPE1			RSat::EFileChangeNotification
#define SIMTSY_REFRESH_TYPE2			RSat::ESimInitFullFileChangeNotification
#define SIMTSY_REFRESH_TYPE3			RSat::ESimReset
#define SIMTSY_REFRESH_FILE1			RSat::KAdnEf
#define SIMTSY_REFRESH_FILE2			RSat::KFdnEf
#define SIMTSY_REFRESH_RESULT_SUCCESS   RSat::KSuccess
#define SIMTSY_REFRESH_RESULT_FAIL		RSat::KMeUnableToProcessCmd
#define SIMTSY_REFRESH_RSP_NO_INFO		RSat::KNoAdditionalInfo
#define SIMTSY_REFRESH_NULL_BUF			_L("")
#define SIMTSY_MM_ELEM_FILE1			RSat::KMmlEf
#define SIMTSY_MM_ELEM_FILE2			RSat::KMmdfEf

#define SIMTSY_MMMSG_REF_TAG			106
#define SIMTSY_MMMSG_REF_LENGTH			3

#define SIMTSY_RCPTION_FILE_TAG			18
#define SIMTSY_RCPTION_LENGTH			2
#define SIMTSY_RCPTION_NUM_FILES		1

#define SIMTSY_MMCONTENT_ID_TAG			110
#define SIMTSY_MMCONTENT_ID_LEN			3

#define SIMTSY_MMMSG_ID_TAG			107
#define SIMTSY_MMMSG_ID_LEN			1

#define SIMTSY_TXT_ATTR_TAG			80
#define SIMTSY_TXT_ATTR_LEN			4
#define SIMTSY_TXT_ATTR_FORMAT			_L("0000")

#define SIMTSY_DEVICEID_ME				RSat::KME
#define SIMTSY_DEVICEID_NETWORK			RSat::KNetwork
#define SIMTSY_ALPHAID_STATUS 			RSat::EAlphaIdProvided
#define SIMTSY_ALPHAID_BUF				_L("\xABC")
#define SIMTSY_ICONID_QLFR				RSat::ENoIconId
#define SIMTSY_ICONID_ID				SIMTSY_ICON_ID
#define SIMTSY_MMMSG_REF_FILES			_L("\x1063\x0ABC")
#define SIMTSY_RCPTION_FILES			_L("\x1821\x3F00\x2FE2")
#define SIMTSY_SUBMISSION_FILES			_L("\x1821\x3F00\x2FE2")
#define SIMTSY_MMCONTENT_ID_DATA		_L("\x1103\xABC")
#define SIMTSY_MMMSG_ID_DATA			_L("\x1071")
#define SIMTSY_MMMSG_ID_DATA_2			_L("\x1072")
#define SIMTSY_TXT_ATTR_STATUS			(RSat::ETextAttributeProvided)
#define SIMTSY_FRAME_IDENTIFIER			0
#define SIMTSY_DEF_FRAME_IDENTIFIER		0
#define SIMTSY_FRAME_LAYOUT_BUFFER		_L("\xABCD") 
#define SIMTSY_USSD_DCS					0x12
#define SIMTSY_USSD_STR					_L("\xA0A1")
#define SIMTSY_NOTFN_DNLD				_L("\xA0A2")
#define SIMTSY_LAUNCH_BROWSER_FRM_ID	0x12

_LIT8(SIMTSY_TXT_ATTR_DATA,"\x00A");

//IMS Authorization
#define IMS_AUTH_IMPI				_L8("IMPI")
#define IMS_AUTH_IMPU_COUNT			(4)
#define IMS_AUTH_IMPU_VALUE1		_L8("IMPU-1")
#define IMS_AUTH_IMPU_VALUE2		_L8("IMPU-2")
#define IMS_AUTH_IMPU_VALUE3		_L8("IMPU-3")
#define IMS_AUTH_IMPU_VALUE4		_L8("IMPU-4")
#define IMS_AUTH_HNDN				_L8("HNDN")
#define IMS_AUTH_DATASOURCE			RMobilePhone::EFromISIM

#define IMS_AUTH_IMPI2				_L8("IMPI2")
#define IMS_AUTH_IMPU2_COUNT		(2)
#define IMS_AUTH_IMPU2_VALUE1		_L8("IMPU2-1")
#define IMS_AUTH_IMPU2_VALUE2		_L8("IMPU2-2")
#define IMS_AUTH_HNDN2				_L8("HNDN2")
#define IMS_AUTH_DATASOURCE2		RMobilePhone::EFromUSIM

//IMS Authentication
#define IMS_AUTH_AUTN_IN1 (_L8("AUTN_IN"))
#define IMS_AUTH_RAND_IN1 (_L8("RAND_IN"))
#define IMS_AUTH_RES_OUT1  (_L8("2345678912345601"))
#define IMS_AUTH_IK_OUT1  (_L8("345601632960000"))		
#define IMS_AUTH_CK_OUT1 (_L8("45601632960000"))
#define IMS_AUTH_AUTS_OUT1 (_L8(""))

#define IMS_AUTH_AUTN_IN2 (_L8("AUTN_IN2"))
#define IMS_AUTH_RAND_IN2 (_L8("RAND_IN2"))
#define IMS_AUTH_RES_OUT2  (_L8(""))
#define IMS_AUTH_IK_OUT2  (_L8(""))		
#define IMS_AUTH_CK_OUT2 (_L8(""))
#define IMS_AUTH_AUTS_OUT2 (_L8("601632960000"))
#define IMS_AUTH_ERR (-3214)

//USIM R6 support
#define SIMTSY_GBA_NAFLIST_COUNT (3)
#define SIMTSY_MBMS_MSKLIST_COUNT (3)

#endif // __TE_SIM_CONSTANTS__
