/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.commdb.data;

import com.symbian.commdb.data.DatabaseException;
import com.symbian.commdb.data.EnumerationType;
import com.symbian.commdb.xml.XMLUtility;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TableTemplate {
    private String m_tableTemplateName = new String("");
    private Vector m_tableParameters = new Vector();
    private Vector m_mustExist = new Vector();
    private Vector m_isTableEntryLink = new Vector();
    private Vector m_parameterTypes = new Vector();
    private Vector m_parameterEnumerations = new Vector();
    private int m_maxEntriesAllowed = 0;

    public String GetTableTemplateName() {
        return new String(this.m_tableTemplateName);
    }

    public int GetNumberOfParameters() {
        return this.m_tableParameters.size();
    }

    public int GetNumberOfEnumerationTypes() {
        return this.m_parameterEnumerations.size();
    }

    public int GetMaxNumberOfEntriesAllowed() {
        return this.m_maxEntriesAllowed;
    }

    public Vector GetEnumerationTypeFlags() {
        Vector<Boolean> vector = new Vector<Boolean>(this.m_parameterTypes.size());
        for (int i = 0; i < this.m_parameterTypes.size(); ++i) {
            String string = (String)this.m_parameterTypes.elementAt(i);
            int n = this.GetEnumerationTypeIndex(string);
            if (n == -1) {
                vector.add(new Boolean(false));
                continue;
            }
            vector.add(new Boolean(true));
        }
        return vector;
    }

    public String GetParameter(int n) {
        return new String((String)this.m_tableParameters.elementAt(n));
    }

    public boolean GetParameterMustExist(int n) {
        return (Boolean)this.m_mustExist.elementAt(n);
    }

    public boolean GetIsTableEntryLink(int n) {
        return (Boolean)this.m_isTableEntryLink.elementAt(n);
    }

    public boolean GetParameterMustExist(String string) {
        return this.GetParameterMustExist(this.GetParameterIndex(string));
    }

    public boolean GetIsTableEntryLink(String string) {
        return this.GetIsTableEntryLink(this.GetParameterIndex(string));
    }

    public String GetParameterType(int n) {
        return new String((String)this.m_parameterTypes.elementAt(n));
    }

    public EnumerationType GetEnumerationType(int n) {
        return (EnumerationType)this.m_parameterEnumerations.elementAt(n);
    }

    public EnumerationType GetEnumerationType(String string) {
        EnumerationType enumerationType = null;
        for (int i = 0; i < this.m_parameterEnumerations.size(); ++i) {
            EnumerationType enumerationType2 = (EnumerationType)this.m_parameterEnumerations.elementAt(i);
            String string2 = enumerationType2.GetEnumerationName();
            if (!string2.equals(string)) continue;
            enumerationType = enumerationType2;
            break;
        }
        return enumerationType;
    }

    public int GetParameterIndex(String string) {
        int n = this.m_tableParameters.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.m_tableParameters.elementAt(i);
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int GetEnumerationTypeIndex(String string) {
        int n = this.m_parameterEnumerations.size();
        for (int i = 0; i < n; ++i) {
            EnumerationType enumerationType = (EnumerationType)this.m_parameterEnumerations.elementAt(i);
            String string2 = enumerationType.GetEnumerationName();
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void SetTableTemplateName(String string) {
        this.m_tableTemplateName = new String(string);
    }

    public void AddParameter(String string, boolean bl, String string2) {
        this.m_tableParameters.add(new String(string));
        this.m_mustExist.add(new Boolean(bl));
        this.m_parameterTypes.add(new String(string2));
    }

    public boolean RemoveParameter(int n) {
        try {
            this.m_tableParameters.removeElementAt(n);
            this.m_mustExist.removeElementAt(n);
            this.m_parameterTypes.removeElementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        return true;
    }

    public boolean RemoveParameter(String string) {
        for (int i = 0; i < this.m_tableParameters.size(); ++i) {
            String string2 = (String)this.m_tableParameters.elementAt(i);
            if (!string2.equals(string)) continue;
            this.m_tableParameters.removeElementAt(i);
            this.m_mustExist.removeElementAt(i);
            this.m_parameterTypes.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void RemoveAllParameters() {
        this.m_tableParameters.clear();
        this.m_mustExist.clear();
        this.m_isTableEntryLink.clear();
        this.m_parameterTypes.clear();
        this.m_parameterEnumerations.clear();
    }

    public void ImportParameters(String string, String string2) throws DatabaseException {
        Object object;
        this.SetTableTemplateName(string2);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringComments(true);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DatabaseException("com.symbian.commdb.data.TableTemplate.ImportParameters()", "Creation of an XML DOM parser", parserConfigurationException.getMessage());
        }
        File file = new File(string);
        Document document = null;
        try {
            document = documentBuilder.parse(file);
        }
        catch (SAXException sAXException) {
            throw new DatabaseException("com.symbian.commdb.data.TableTemplate.ImportParameters()", "Parser exception during parsing file " + string, sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new DatabaseException("com.symbian.commdb.data.TableTemplate.ImportParameters()", "I/O exception during parsing file " + string, iOException.getMessage());
        }
        Vector vector = new Vector();
        XMLUtility.LocateNodesFromAttribute(document.getDocumentElement(), "ref", string2, vector);
        if (vector.size() != 1) {
            throw new DatabaseException("com.symbian.commdb.data.TableTemplate.ImportParameters()", "Locating node which refers to " + string2 + " after parsing file " + string, vector.size() + " found when only one was expected");
        }
        Node node = (Node)vector.elementAt(0);
        Node node2 = node.getAttributes().getNamedItem("maxOccurs");
        this.m_maxEntriesAllowed = node2 != null ? (((String)(object = node2.getNodeValue())).equals("unbounded") ? Integer.MAX_VALUE : Integer.parseInt((String)object)) : Integer.MAX_VALUE;
        vector = new Vector();
        XMLUtility.LocateNodesFromAttribute(document.getDocumentElement(), "name", string2, vector);
        if (vector.size() != 1) {
            throw new DatabaseException("com.symbian.commdb.data.TableTemplate.ImportParameters()", "Locating node " + string2 + " after parsing file " + string, vector.size() + " found when only one was expected");
        }
        object = new Vector();
        XMLUtility.VectoriseChildrenNodes((Node)vector.elementAt(0), (Vector)object);
        this.RemoveAllParameters();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            Node node3 = (Node)((Vector)object).elementAt(i);
            if (!node3.getNodeName().equals("xsd:element") || !node3.hasAttributes()) continue;
            NamedNodeMap namedNodeMap = node3.getAttributes();
            boolean bl = false;
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Node node4 = namedNodeMap.item(j);
                String string3 = node4.getNodeName();
                if (string3.equals("name")) {
                    this.m_tableParameters.add(new String(node4.getNodeValue()));
                    continue;
                }
                if (string3.equals("minOccurs")) {
                    bl = true;
                    if (node4.getNodeValue().equals("1")) {
                        this.m_mustExist.add(new Boolean(true));
                        continue;
                    }
                    this.m_mustExist.add(new Boolean(false));
                    continue;
                }
                if (!string3.equals("type")) continue;
                String string4 = new String(node4.getNodeValue());
                this.m_parameterTypes.add(string4);
                if (string4.equals("TableEntryNameType")) {
                    this.m_isTableEntryLink.add(new Boolean(true));
                    continue;
                }
                this.m_isTableEntryLink.add(new Boolean(false));
            }
            if (bl) continue;
            this.m_mustExist.add(new Boolean(false));
        }
        if (this.m_tableParameters.size() == 0 || this.m_parameterTypes.size() == 0) {
            throw new DatabaseException("com.symbian.commdb.data.TableTemplate.ImportParameters()", "After processing the parsed file " + string, "No table parameters and/or types were found");
        }
    }

    public void ImportEnumerations(String string) throws DatabaseException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringComments(true);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DatabaseException("com.symbian.commdb.data.TableTemplate.ImportEnumerations()", "Creation of an XML DOM parser", parserConfigurationException.getMessage());
        }
        File file = new File(string);
        Document document = null;
        try {
            document = documentBuilder.parse(file);
        }
        catch (SAXException sAXException) {
            throw new DatabaseException("com.symbian.commdb.data.TableTemplate.ImportEnumerations()", "Parser exception during parsing file " + string, sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new DatabaseException("com.symbian.commdb.data.TableTemplate.ImportEnumerations()", "I/O exception during parsing file " + string, iOException.getMessage());
        }
        Vector vector = new Vector();
        XMLUtility.VectoriseChildrenNodes(document.getDocumentElement(), vector);
        for (int i = 0; i < vector.size(); ++i) {
            Node node = (Node)vector.elementAt(i);
            if (!node.getNodeName().equals("xsd:simpleType")) continue;
            String string2 = node.getAttributes().getNamedItem("name").getNodeValue();
            Node node2 = (Node)vector.elementAt(i + 2);
            if (!node2.getNodeName().equals("xsd:restriction")) continue;
            int n = node2.getChildNodes().getLength();
            EnumerationType enumerationType = new EnumerationType(string2);
            for (int j = i + 3; j < i + n + 2; ++j) {
                node2 = (Node)vector.elementAt(j);
                if (!node2.getNodeName().equals("xsd:enumeration")) continue;
                String string3 = node2.getAttributes().getNamedItem("value").getNodeValue();
                enumerationType.AddEnumeration(string3);
            }
            if (enumerationType.GetNumberEnumerations() <= 0) continue;
            this.m_parameterEnumerations.add(enumerationType);
        }
        EnumerationType enumerationType = new EnumerationType("TBool");
        enumerationType.AddEnumeration("TRUE");
        enumerationType.AddEnumeration("FALSE");
        this.m_parameterEnumerations.add(enumerationType);
    }

    public Vector CreateJComboBoxes() {
        Vector<JComboBox> vector = new Vector<JComboBox>();
        for (int i = 0; i < this.m_parameterEnumerations.size(); ++i) {
            EnumerationType enumerationType = (EnumerationType)this.m_parameterEnumerations.elementAt(i);
            vector.add(enumerationType.CreateJComboBox());
        }
        return vector;
    }
}

