#
# Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
# All rights reserved.
# This component and the accompanying materials are made available
# under the terms of "Eclipse Public License v1.0"
# which accompanies this distribution, and is available
# at the URL "http://www.eclipse.org/legal/epl-v10.html".
#
# Initial Contributors:
# Nokia Corporation - initial contribution.
#
# Contributors:
#
# Description: 
#
# ============================================================================
#  Name     : gen_localization_iby.pl
#  Part of  : generate iby fole to select correct localised resources for ROM
#  Origin   : S60,NMP
#  Created  : Tue May 26 11:32:47 2007
#  Description:
#	

use strict;
use File::Find;     # for finding
use File::Basename; # for fileparse
use Getopt::Long;

#
# Variables...
#
my $version = "V0.1";
my $outputfile = "localized_resources.iby"; # exclude file for cenrep
my $input; # inputfile
my @lang_ids;

my %macro_definitions = (	
		"RESOURCE_FILES_LOCALIZED" => "data\=DATAZ_\\RESOURCE_FILES_DIR\\\#\# NAME \#\# .r \#\# ID   RESOURCE_FILES_DIR\\\#\# NAME \#\# .r \#\# ID",
		"APP_RESOURCE_LOCALIZED" => "data\=DATAZ_\\APP_RESOURCE_DIR\\\#\# NAME \#\# .r \#\# ID   APP_RESOURCE_DIR\\\#\# NAME \#\# .r \#\# ID",
		"ECOM_RESOURCE_LOCALIZED" => "data\=DATAZ_\\ECOM_RESOURCE_DIR\\\#\# NAME \#\# .r \#\# ID   ECOM_RESOURCE_DIR\\\#\# NAME \#\# .r \#\# ID",
		"MTM_RESOURCE_LOCALIZED" => "data\=DATAZ_\\MTM_RESOURCE_DIR\\\#\# NAME \#\# .r \#\# ID   MTM_RESOURCE_DIR\\\#\# NAME \#\# .r \#\# ID",
		"MTM_INFO_FILE_LOCALIZED" => "data\=DATAZ_\\MTM_INFO_FILE_DIR\\\#\# NAME \#\# .r \#\# ID   MTM_INFO_FILE_DIR\\\#\# NAME \#\# .r \#\# ID",
		"CONTACTS_RESOURCE_LOCALIZED" => "data\=DATAZ_\\CONTACTS_RESOURCE_DIR\\\#\# NAME \#\# .r \#\# ID   CONTACTS_RESOURCE_DIR\\\#\# NAME \#\# .r \#\# ID",
		"FEP_RESOURCES_LOCALIZED" => "data\=DATAZ_\\FEP_RESOURCES_DIR\\\#\# NAME \#\# .r \#\# ID   FEP_RESOURCES_DIR\\\#\# NAME \#\# .r \#\# ID",
		"UIKLAF_RESOURCE_LOCALIZED" => "data\=DATAZ_\\UIKLAF_RESOURCE_DIR\\\#\# NAME \#\# .r \#\# ID   UIKLAF_RESOURCE_DIR\\\#\# NAME \#\# .r \#\# ID",
		"HELP_FILE_LOCALIZED" => "data\=DATAZ_\\HELP_FILE_DIR\\\#\# NAME \#\# .r \#\# ID   HELP_FILE_DIR\\\#\# NAME \#\# .r \#\# ID"
   	);
# END Variation Table


my $result = GetOptions('i=s' => \$input);	
		
if (!$result){die("Required Argument(s) are missing or wrong");}

if ($input eq "") {	
	my $given_cmd=$0;
	$given_cmd =~ s/.*\\(\w+\.\w+)$/$1/;

	print "This is localization_resource.iby generator\n";
	print "This generate localization_resource.iby base on language ids.\n";
	print "\tUsed language ids can given in input file where all ids are listed\n";
	print "\tor input can be a path where all langage ids are listed as folder\n";
	print "Usage :\n";
	print "Usage : $given_cmd -i <input file>\n";
	print "Usage : $given_cmd -i <input folder>\n";
	exit 0;
}

if (!get_lang_ids()){die("No input file or folder exists!");}

open (OUTPUT,">$outputfile") or die("Cannot open $outputfile");

create_iby();
close OUTPUT;

sub create_iby {
	usage();
	macros();
	language_switch();
}

sub usage {
	my $given_command=$0;
	$given_command =~ s/.*\\(\w+\.\w+)$/$1/;
	print OUTPUT "\/*\n";
	print OUTPUT "* This has generated by $given_command. Do not edit manually.\n*\n";

	print OUTPUT "* This file selected correct localised resources for ROM image base on languages\n";
	print OUTPUT "* This file should be used only for localised resources\n*\n";
	
	print OUTPUT "* Define user localized macro to get correct localized resources to ROM image\n";
	print OUTPUT "* All paltform supported languages are included by default\n";
	print OUTPUT "* Macros LANGUAGE_<id> or NO_LANGUAGE_<id> can be used to change supported component languages\n";
	print OUTPUT "* First define used macro and after macro definition should include this file\n";
	print OUTPUT "* All user defined macros are undefineded end of this file\n";

	print OUTPUT "*\n* Usage in iby file:\n";
	print OUTPUT "*  \#define \[user localized macro\] \[resource file name\]\n";
	print OUTPUT "*  \#include \<Variant\/localized_resources.iby\>\n";

	print OUTPUT "*\n* How to include correct localised 'example' resources in 'example_variant.iby':\n";
	print OUTPUT "*  \#define USER_APP_RESOURCE_LOCALIZED example\n";
	print OUTPUT "*  \#include \<Variant\/localized_resources.iby\>\n";

	print OUTPUT "*\n* How to specify languages that component support\n";
	print OUTPUT "*  \#define USER_APP_RESOURCE_LOCALIZED example\n";
	print OUTPUT "*  \#define LANGUAGE_01\n";
	print OUTPUT "*  \#define LANGUAGE_02\n";
	print OUTPUT "*  \#include \<Variant\/localized_resources.iby\>\n";


	print OUTPUT "*\n* How to exclude languages that component do not support\n";
	print OUTPUT "*  \#define USER_APP_RESOURCE_LOCALIZED example\n";
	print OUTPUT "*  \#define NO_LANGUAGE_29\n";
	print OUTPUT "*  \#define NO_LANGUAGE_159\n";
	print OUTPUT "*  \#include \<Variant\/localized_resources.iby\>\n";

	print OUTPUT "*\n* Supported user localized macros (source=<path in environment>,target=<path in ROM image>):\n";

	foreach my $macro (sort keys %macro_definitions) {
    my $paths = $macro_definitions{$macro};
    $paths =~ s/^data=//i;

    my $src = $paths;
    $src =~ s/\#.*//i;
    $paths =~ s/.*ID\s+//i;

    my $trg = $paths;
    $trg =~ s/\#.*//i;
    
  	print OUTPUT "*  USER_${macro}\t(source=$src,target=$trg)\n";
	}

	print OUTPUT "*\/\n\n";
}

sub macros {
  my $postfix = "_INTERNAL";
  
	print OUTPUT "\n\/\/ Define macros used in this file\n";

	foreach my $macro (sort keys %macro_definitions) {
  	print OUTPUT "\#define ${macro}${postfix}(NAME,ID)  $macro_definitions{$macro}\n";
  	print OUTPUT "\#define ${macro}(NAME,ID)  ${macro}${postfix}(NAME,ID)\n";
	}

	print OUTPUT "\n";
}

sub language_switch {
	my $use_selected_macro = "USE_SELECTED_LANGUAGES";
	my $locales = "__LOCALES_%ID%_IBY__"; #
	my $lang = "LANGUAGE_"; # + id
	my $no_lang = "NO_LANGUAGE_"; # + id


#check if only some languages should include

	print OUTPUT "\n\/\/ Check is only some languages in use\n";

	my $counter = 0;
	foreach my $id (@lang_ids) {
		if (!$counter) {
			print OUTPUT "\#if defined(${lang}${id})";
		}
		else {
			print OUTPUT "\ || defined(${lang}${id})";
		}
		$counter++;
	}

	print OUTPUT "\n \#define ${use_selected_macro}\n\#endif\n\n";

#define macros by language
  print OUTPUT "\/\/ Selectors for language macros\n";
	foreach my $id (@lang_ids) {
		my $line = "\#if defined(${locales}) && (!defined(${use_selected_macro}) || defined(${lang}${id}))  && !defined(${no_lang}${id})\n";
		$line =~ s/%ID%/${id}/;
		print OUTPUT "$line";
	  
	  my $predef = " \#if defined";
  	foreach my $macro (sort keys %macro_definitions) {
     	print OUTPUT "${predef} USER_${macro}\n";
  	  $predef = " \#elif defined";
  		print OUTPUT "  ${macro}(USER_${macro}, ". lc $id .")\n";
  	}
# end macro definition
 	  print OUTPUT " \#endif\n";

# end language definition
	  print OUTPUT "\#endif\n";
	  print OUTPUT "\#undef ${no_lang}${id}\n";
	  print OUTPUT "\#undef ${lang}${id}\n\n";
	}



  print OUTPUT "\/\/ Undefine user macros\n";
#  print OUTPUT "\n\#endif\n\n";
	foreach my $macro (sort keys %macro_definitions) {
  	print OUTPUT "\#undef USER_${macro}\n";
	}

  print OUTPUT "\#undef ${use_selected_macro}\n";
}

sub get_lang_ids {
	if (-f $input) {
		open (INPUT,"$input") or die("Cannot open file $input");
	  while (<INPUT>) {
		  chomp; #Remove line feed and carriage return  
		  next if (/^\/\//); # Skip comment lines
		  next if (/^#/); # Skip comment lines
		  next if (/^ *$/); # Skip empty lines 
  		
  		$_ =~ s/\s//gi; # remove white spaces
  		
	    push (@lang_ids,uc $_); # for zipping
	  }
		
		close INPUT;
		return 1;
	}
	elsif (-d $input) {
	  opendir(SDIR, $input) or die("can not read folder $input\n");
		my @folders = grep !/^\.\.?$/, readdir SDIR;
	  closedir(SDIR);
	  
    push (@lang_ids,"SC"); 

	  foreach (@folders) {
	  	next if (!/^\d+$/);

	    push (@lang_ids,uc $_); 
	  }
	  return 1;
	}
	
	return 0;
}