#!perl
# os_version_h.PL
# 
# Copyright (c) 2010 Accenture. All rights reserved.
# This component and the accompanying materials are made available
# under the terms of the "Eclipse Public License v1.0"
# which accompanies this distribution, and is available
# at the URL "http://www.eclipse.org/legal/epl-v10.html".
# 
# Initial Contributors:
# Accenture - Initial contribution
#

use strict;
die "Error: not running on Win32; Win32Conole must be updated/replaced for this OS: $^O\n" unless $^O =~ m|Win32|;
require Win32;

my @ver = Win32::GetOSVersion();
my ($string, $major, $minor, $build, $id) = @ver;

my $ver = sprintf("%02x%02s", $major, $minor);

print <<__EOS__;
// os_version.h
// This header is automatically generated by os_version_h.PL; do not edit it directly, edit
// win_version_h.PL instead.

#ifndef __OS_VERSION_H__
#define __OS_VERSION_H__

#define _WIN32_WINNT 0x$ver

#endif // __OS_VERSION_H__
__EOS__
