#ifndef __DESCRIPTORS_RAW_DATA_H
#define __DESCRIPTORS_RAW_DATA_H

/*
* Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
* @file descriptorsRawData.h
* @internalComponent
* 
*
*/



namespace NUnitTesting_USBDI
	{

_LIT8(KDeviceDescriptorData, "\
\x12\x01\x00\x02\xff\xff\xff\x40\x22\x0e\x40\x00\x05\x03\x01\x02\x03\x01"); // ok

_LIT8(KConfigurationDescriptorInsufficientDataTestCase1, "\
\x09\x02\x50\x00\x02\x01\x04\xe0\x00\x09\x04\x00\x00\x00\xff\xff\xff\x06\x09\
\x04\x01\x00\x02\xff\xff\xff\x07\x07\x05\x01\x02\x40\x00\x00\x07\x05\x84\x02\
\x40\x00\x00\x09\x04\x01\x01\x03\xff\xff\xff\x08\x07\x05\x81\x03\x08\x00\x40\
\x07\x05\x01\x02\x40\x00\x00\x07\x05\x84\x02\x40\x00\x00"); // wTotalLength > real size

_LIT8(KConfigurationDescriptorInsufficientDataTestCase2, "\
\x09\x02\x45\x00\x02\x01\x04\xe0\x00\x09\x04\x00\x00\x00\xff\xff\xff\x06\x09\
\x04\x01\x00\x02\xff\xff\xff\x07\x07\x05\x01\x02\x40\x00\x00\x07\x05\x84\x02\
\x40\x00\x00\x09\x04\x01\x01\x03\xff\xff\xff\x08\x07\x05\x81\x03\x08\x00\x40\
\x07\x05\x01\x02\x40\x00\x00\x07\x05\x84\x02\x40");// last EP descriptor incomplete

_LIT8(KConfigurationDescriptorUnexpectedLengthTestCase3, "\
\x09\x02\x49\x00\x02\x01\x04\xe0\x00\x09\x04\x00\x00\x00\xff\xff\xff\x06\x09\
\x04\x01\x00\x02\xff\xff\xff\x07\x07\x05\x01\x02\x40\x00\x00\x07\x05\x84\x02\
\x40\x00\x00\x09\x04\x01\x01\x03\xff\xff\xff\x08\x07\x05\x81\x03\x08\x00\x40\
\x07\x05\x01\x02\x40\x00\x00\x09\x05\x84\x02\x40\x00\x00\x00\x00"); // last EP defined as 9 bytes(usb Audio class...), instead of 7(USB Spec.)


// nominal case
// IF0-IF1-IAD0(2,2)-IF2.0-IF2.1-IF4-IF3
_LIT8(KConfigurationDescriptorWithIADTestCase1, "\
\x09\x02\x6A\x00\x05\x01\x04\xe0\x00\
\x09\x04\x00\x00\x00\xff\xff\xff\x06\x09\x04\x01\x00\x02\xff\xff\xff\x07\x07\x05\x01\x02\x40\x00\x00\x07\x05\x84\x02\x40\x00\x00\
\x08\x0B\x02\x02\xff\xff\xff\x02\x09\x04\x02\x00\x03\xff\xff\xff\x08\x07\x05\x81\x03\x08\x00\x40\x07\x05\x01\
\x02\x40\x00\x00\x07\x05\x84\x02\x40\x00\x00\
\x09\x04\x02\x01\x00\xff\xff\xff\x06\
\x09\x04\x04\x00\x00\xff\xff\xff\x06\
\x09\x04\x03\x00\x00\xff\xff\xff\x06"); // IF0---IF1--IAD0(2,2) --IF4
										//			   |
										//             |__IF2.0-IF2.1-IF3   

 
// inconsistency, bFirstInterface doesn't exist and bInterfaceCount too big
// IF0-IF1-IF3-IAD0(2,2)-IAD1(6,4)-IF2.0-IF2.1-IF4-IF5-IF7-IF8
_LIT8(KConfigurationDescriptorWithIADTestCase2, "\
\x09\x02\x8D\x00\x08\x01\x04\xe0\x00\
\x09\x04\x00\x00\x00\xff\xff\xff\x06\x09\x04\x01\x00\x02\xff\xff\xff\x07\x07\x05\x01\x02\x40\x00\x00\x07\x05\x84\x02\x40\x00\x00\
\x09\x04\x03\x00\x00\xff\xff\xff\x06\
\x08\x0B\x02\x02\xff\xff\xff\x02\
\x08\x0B\x06\x04\xff\xff\xff\x02\x09\x04\x02\x00\x03\xff\xff\xff\x08\x07\x05\x81\x03\x08\x00\x40\x07\x05\x01\x02\x40\x00\x00\x07\x05\x84\x02\x40\x00\x00\
\x09\x04\x02\x01\x00\xff\xff\xff\x06\
\x09\x04\x04\x00\x00\xff\xff\xff\x06\
\x09\x04\x05\x00\x00\xff\xff\xff\x06\
\x09\x04\x07\x00\x00\xff\xff\xff\x06\
\x09\x04\x08\x00\x00\xff\xff\xff\x06");// IF0--IF1--IF3--IAD0(2,2)--------------IAD1(6,4)--IF4--IF5
										//			      |						 |
										//                |__IF2.0-IF2.1         |__IF7--IF8
										

// inconsistency, overlapping , IF3 is shared by 2 differents IADs
// IF0-IF1-IAD0(2,2)-IAD1(3,3)-IF2.0-IF2.1-IF4-IF3-IF5-IF6              
_LIT8(KConfigurationDescriptorWithIADTestCase3, "\
\x09\x02\x84\x00\x07\x01\x04\xe0\x00\
\x09\x04\x00\x00\x00\xff\xff\xff\x06\x09\x04\x01\x00\x02\xff\xff\xff\x07\x07\x05\x01\x02\x40\x00\x00\x07\x05\x84\x02\x40\x00\x00\
\x08\x0B\x02\x02\xff\xff\xff\x02\
\x08\x0B\x03\x03\xff\xff\xff\x02\x09\x04\x02\x00\x03\xff\xff\xff\x08\x07\x05\x81\x03\x08\x00\x40\x07\x05\x01\x02\x40\x00\x00\x07\x05\x84\x02\x40\x00\x00\
\x09\x04\x02\x01\x00\xff\xff\xff\x06\
\x09\x04\x04\x00\x00\xff\xff\xff\x06\
\x09\x04\x03\x00\x00\xff\xff\xff\x06\
\x09\x04\x05\x00\x00\xff\xff\xff\x06\
\x09\x04\x06\x00\x00\xff\xff\xff\x06"); // IF0---IF1--IAD0(2,2)-------------IAD1(3,3)--IF6
										//			   | 						|
										//             |__IF2.0-IF2.1      		|__IF4-IF3-IF5							
										
	
	
/**
Some data from a Bluetooth USB dongle.  Which previously
caused a panic in the parser.
*/
_LIT8(KBtDongleDescriptorTestCase4,
	"\x09\x04\x01\x00\x02\xe0\x01\x01\x00"
		"\x07\x05\x03\x01\x00\x00\x01"
		"\x07\x05\x83\x01\x00\x00\x01"
	"\x09\x04\x01\x01\x02\xe0\x01\x01\x00"
		"\x07\x05\x03\x01\x09\x00\x01"
		"\x07\x05\x83\x01\x09\x00\x01"
	"\x09\x04\x01\x02\x02\xe0\x01\x01\x00"
		"\x07\x05\x03\x01\x11\x00\x01"
		"\x07\x05\x83\x01\x11\x00\x01"
	"\x09\x04\x01\x03\x02\xe0\x01\x01\x00"
		"\x07\x05\x03\x01\x19\x00\x01"
		"\x07\x05\x83\x01\x19\x00\x01"
	"\x09\x04\x01\x04\x02\xe0\x01\x01\x00"
		"\x07\x05\x03\x01\x21\x00\x01"
		"\x07\x05\x83\x01\x21\x00\x01"
	"\x09\x04\x01\x05\x02\xe0\x01\x01\x00"
		"\x07\x05\x03\x01\x31\x00\x01"
		"\x07\x05\x83\x01\x31\x00\x01"
	);

/**
Basic IAD test.  An IAD preceding 4 in-order interface descriptors.
*/
_LIT8(KConfigurationDescriptorWithIADTestCase5,
	"\x09\x02\x51\x00\x04\x03\x04\x05\x06"
		"\x08\x0b\x00\x04\x02\x03\x04\x05"
			"\x09\x04\x00\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x00\x01\x02\x03\x04"
			"\x09\x04\x01\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x01\x01\x02\x03\x04"
			"\x09\x04\x02\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x02\x01\x02\x03\x04"
			"\x09\x04\x03\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x03\x01\x02\x03\x04"
	);

/**
IAD test where IAD precedes all 4 descriptors but doesn't include
the last one.
*/
_LIT8(KConfigurationDescriptorWithIADTestCase6,
	"\x09\x02\x51\x00\x04\x03\x04\x05\x06"
		"\x08\x0b\x00\x03\x02\x03\x04\x05"
			"\x09\x04\x00\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x00\x01\x02\x03\x04"
			"\x09\x04\x01\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x01\x01\x02\x03\x04"
			"\x09\x04\x02\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x02\x01\x02\x03\x04"
			"\x09\x04\x03\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x03\x01\x02\x03\x04"
	);
	
/**
IAD test where IAD precedes all 4 descriptors but doesn't include
the first one.
*/
_LIT8(KConfigurationDescriptorWithIADTestCase7,
	"\x09\x02\x51\x00\x04\x03\x04\x05\x06"
		"\x08\x0b\x01\x03\x02\x03\x04\x05"
			"\x09\x04\x00\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x00\x01\x02\x03\x04"
			"\x09\x04\x01\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x01\x01\x02\x03\x04"
			"\x09\x04\x02\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x02\x01\x02\x03\x04"
			"\x09\x04\x03\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x03\x01\x02\x03\x04"
	);
	
/**
IAD test where IAD precedes all 4 descriptors but the interfaces
are in reverse numerial order.
*/
_LIT8(KConfigurationDescriptorWithIADTestCase8,
	"\x09\x02\x51\x00\x04\x03\x04\x05\x06"
		"\x08\x0b\x00\x04\x02\x03\x04\x05"
			"\x09\x04\x03\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x00\x01\x02\x03\x04"
			"\x09\x04\x02\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x01\x01\x02\x03\x04"
			"\x09\x04\x01\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x02\x01\x02\x03\x04"
			"\x09\x04\x00\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x03\x01\x02\x03\x04"
	);
	
/**
IAD test where IAD precedes all 4 descriptors but the interfaces
are in a random order.
*/
_LIT8(KConfigurationDescriptorWithIADTestCase9,
	"\x09\x02\x51\x00\x04\x03\x04\x05\x06"
		"\x08\x0b\x00\x04\x02\x03\x04\x05"
			"\x09\x04\x00\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x00\x01\x02\x03\x04"
			"\x09\x04\x03\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x01\x01\x02\x03\x04"
			"\x09\x04\x01\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x02\x01\x02\x03\x04"
			"\x09\x04\x02\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x03\x01\x02\x03\x04"
	);
	
/**
IAD test where IAD precedes all 4 descriptors only three are included
and an excluded one splits the included (from a data stream pov).
*/
_LIT8(KConfigurationDescriptorWithIADTestCase10,
	"\x09\x02\x51\x00\x04\x03\x04\x05\x06"
		"\x08\x0b\x01\x03\x02\x03\x04\x05"
			"\x09\x04\x03\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x00\x01\x02\x03\x04"
			"\x09\x04\x01\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x01\x01\x02\x03\x04"
			"\x09\x04\x00\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x02\x01\x02\x03\x04"
			"\x09\x04\x02\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x03\x01\x02\x03\x04"
	);									// 	 IAD0(1,3)---IF0
										//	   | 						
										//     |__IF3--IF1--IF2
	
	
/**
IAD test where IAD is preceded by another interface
*/
_LIT8(KConfigurationDescriptorWithIADTestCase11,
	"\x09\x02\x61\x00\x04\x03\x04\x05\x06"
		"\x09\x04\x04\x00\x01\x03\x04\x05\x06"
			"\x07\x05\x04\x01\x02\x03\x04"
		"\x08\x0b\x01\x03\x02\x03\x04\x05"
			"\x09\x04\x03\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x00\x01\x02\x03\x04"
			"\x09\x04\x01\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x01\x01\x02\x03\x04"
			"\x09\x04\x00\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x02\x01\x02\x03\x04"
			"\x09\x04\x02\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x03\x01\x02\x03\x04"
	);									// 	 IF4---IAD0(1,3)---IF0
										//	         | 						
										//           |__IF3--IF1--IF2    
	
/**
IAD test where there are two IADs followed by interfaces
some they own, some they don't.
*/
_LIT8(KConfigurationDescriptorWithIADTestCase12,
	"\x09\x02\x61\x00\x04\x03\x04\x05\x06"
		"\x09\x04\x04\x00\x01\x03\x04\x05\x06"
			"\x07\x05\x04\x01\x02\x03\x04"
		"\x08\x0b\x01\x03\x02\x03\x04\x05"
		"\x08\x0b\x05\x02\x02\x03\x04\x05"
			"\x09\x04\x03\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x00\x01\x02\x03\x04"
			"\x09\x04\x01\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x01\x01\x02\x03\x04"
			"\x09\x04\x05\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x06\x01\x02\x03\x04"
			"\x09\x04\x06\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x05\x01\x02\x03\x04"
			"\x09\x04\x00\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x02\x01\x02\x03\x04"
			"\x09\x04\x02\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x03\x01\x02\x03\x04"
	);									// 	 IF4---IAD0(1,3)--------------IAD0(5,2)--IF0
										//	         |						| 						
										//           |__IF3--IF1--IF2		|__IF5--IF6 
	
/**
IAD test where there are two IADs followed by interfaces
some they own, some they don't.  With overlapping.
*/
_LIT8(KConfigurationDescriptorWithIADTestCase13,
	"\x09\x02\x61\x00\x04\x03\x04\x05\x06"
		"\x09\x04\x10\x00\x01\x03\x04\x05\x06"
			"\x07\x05\x09\x01\x02\x03\x04"
		"\x08\x0b\x01\x04\x02\x03\x04\x05"
		"\x08\x0b\x04\x03\x02\x03\x04\x05"
			"\x09\x04\x03\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x00\x01\x02\x03\x04"
			"\x09\x04\x01\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x01\x01\x02\x03\x04"
			"\x09\x04\x05\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x06\x01\x02\x03\x04"
			"\x09\x04\x06\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x05\x01\x02\x03\x04"
			"\x09\x04\x00\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x02\x01\x02\x03\x04"
			"\x09\x04\x02\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x03\x01\x02\x03\x04"
			"\x09\x04\x04\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x04\x01\x02\x03\x04"
	);									// 	 IF16---IAD0(1,4)-----------------IAD0(4,3)--IF0
										//	         |							| 						
										//           |__IF3--IF1--IF2--IF4		|__IF5--IF6 
	
/** 
IAD test where there are two IADs followed by interfaces
some they own, some they don't.  With overlapping and an
independant interface before a descriptor which can live
in either IAD (because the IAD is malformed).
*/
_LIT8(KConfigurationDescriptorWithIADTestCase14,
	"\x09\x02\x61\x00\x04\x03\x04\x05\x06"
		"\x08\x0b\x01\x04\x02\x03\x04\x05"
		"\x08\x0b\x04\x03\x02\x03\x04\x05"
			"\x09\x04\x03\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x00\x01\x02\x03\x04"
			"\x09\x04\x01\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x01\x01\x02\x03\x04"
			"\x09\x04\x05\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x06\x01\x02\x03\x04"
			"\x09\x04\x06\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x05\x01\x02\x03\x04"
			"\x09\x04\x00\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x02\x01\x02\x03\x04"
			"\x09\x04\x02\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x03\x01\x02\x03\x04"
		"\x09\x04\x10\x00\x01\x03\x04\x05\x06"
			"\x07\x05\x09\x01\x02\x03\x04"
			"\x09\x04\x04\x00\x01\x03\x04\x05\x06"
				"\x07\x05\x04\x01\x02\x03\x04"
	);									// 	 IAD0(1,4)-----------------IAD0(4,3)--IF0--IFA
										//	    |							| 						
										//      |__IF3--IF1--IF2			|__IF5--IF6--IF4
	
	}

#endif // __DESCRIPTORS_RAW_DATA_H