// Copyright (c) 1998-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// template\template_assp\interrupts.cpp
// Template ASSP interrupt control and dispatch
// 
//

#include <template_assp_priv.h>

SInterruptHandler TemplateInterrupt::Handlers[KNumTemplateInts];

void TemplateInterrupt::DisableAndClearAll()
	{
	//
	// TO DO: (mandatory)
	//
	// Disable and clear all Hardware Interrupt sources
	//
	}

void TemplateInterrupt::Init1()
	{
	//
	// need to hook the ARM IRQ and FIQ handlers as early as possible and disable and clear all interrupt sources
	//
	__KTRACE_OPT(KBOOT,Kern::Printf("TemplateInterrupt::Init1()"));
	TInt i;
	for (i=0; i<KNumTemplateInts; i++)
		{
		Handlers[i].iPtr=(TAny*)i;
		Handlers[i].iIsr=Spurious;
		}
	DisableAndClearAll();
	Arm::SetIrqHandler((TLinAddr)TemplateInterrupt::IrqDispatch);
	Arm::SetFiqHandler((TLinAddr)TemplateInterrupt::FiqDispatch);
	}

void TemplateInterrupt::Init3()
	{
	//
	// TO DO: (optional)
	//
	// Any further initialisation of the Hardware Interrupt Controller
	//
	}

void TemplateInterrupt::Spurious(TAny* anId)
	{
	//
	// TO DO: (mandatory)
	//
	// handle an unexpected interrupt
	//
	Kern::Fault("SpuriousInt", (TInt)anId);		// EXAMPLE ONLY
	}

//
// The APIs below assume ther is a second level Interrupt controller located at Variant level which handles
// interrupts generated by hardware at that level.
//

EXPORT_C TInt Interrupt::Bind(TInt anId, TIsr anIsr, TAny* aPtr)
	{
	__KTRACE_OPT(KEXTENSION,Kern::Printf("Interrupt::Bind id=%d func=%08x ptr=%08x",anId,anIsr,aPtr));
	TInt r=KErrNone;
	// if ID indicates a chained interrupt, call variant...
	if (anId<0 && ((((TUint)anId)>>16)&0x7fff)<(TUint)KNumTemplateInts)
		r=TemplateAssp::Variant->InterruptBind(anId,anIsr,aPtr);
	else if ((TUint)anId >= (TUint)KNumTemplateInts)
		r=KErrArgument;
	else
		{
		SInterruptHandler& h=TemplateInterrupt::Handlers[anId];
		TInt irq=NKern::DisableAllInterrupts();
		if (h.iIsr != TemplateInterrupt::Spurious)
			r=KErrInUse;
		else
			{
			h.iPtr=aPtr;
			h.iIsr=anIsr;
			}
		NKern::RestoreInterrupts(irq);
		}
	return r;
	}

EXPORT_C TInt Interrupt::Unbind(TInt anId)
	{
	__KTRACE_OPT(KEXTENSION,Kern::Printf("Interrupt::Unbind id=%d",anId));
	TInt r=KErrNone;
	// if ID indicates a chained interrupt, call variant...
	if (anId<0 && ((((TUint)anId)>>16)&0x7fff)<(TUint)KNumTemplateInts)
		r=TemplateAssp::Variant->InterruptUnbind(anId);
	else if ((TUint)anId >= (TUint)KNumTemplateInts)
		r=KErrArgument;
	else
		{
		SInterruptHandler& h=TemplateInterrupt::Handlers[anId];
		TInt irq=NKern::DisableAllInterrupts();
		if (h.iIsr == TemplateInterrupt::Spurious)
			r=KErrGeneral;
		else
			{
			h.iPtr=(TAny*)anId;
			h.iIsr=TemplateInterrupt::Spurious;
			//
			// TO DO: (mandatory)
			//
			// Disable the corresponding Hardware Interrupt source
			//
			}
		NKern::RestoreInterrupts(irq);
		}
	return r;
	}

EXPORT_C TInt Interrupt::Enable(TInt anId)
	{
	__KTRACE_OPT(KEXTENSION,Kern::Printf("Interrupt::Enable id=%d",anId));
	TInt r=KErrNone;
	// if ID indicates a chained interrupt, call variant...
	if (anId<0 && ((((TUint)anId)>>16)&0x7fff)<(TUint)KNumTemplateInts)
		r=TemplateAssp::Variant->InterruptEnable(anId);
	else if ((TUint)anId>=(TUint)KNumTemplateInts)
		r=KErrArgument;
	else if (TemplateInterrupt::Handlers[anId].iIsr==TemplateInterrupt::Spurious)
		r=KErrNotReady;
	else
		{
		//
		// TO DO: (mandatory)
		//
		// Enable the corresponding Hardware Interrupt source
		//
		}
	return r;
	}

EXPORT_C TInt Interrupt::Disable(TInt anId)
	{
	__KTRACE_OPT(KEXTENSION,Kern::Printf("Interrupt::Disable id=%d",anId));
	TInt r=KErrNone;
	// if ID indicates a chained interrupt, call variant...
	if (anId<0 && ((((TUint)anId)>>16)&0x7fff)<(TUint)KNumTemplateInts)
		r=TemplateAssp::Variant->InterruptDisable(anId);
	else if ((TUint)anId>=(TUint)KNumTemplateInts)
		r=KErrArgument;
	else
		{
		//
		// TO DO: (mandatory)
		//
		// Disable the corresponding Hardware Interrupt source
		//
		}
	return r;
	}

EXPORT_C TInt Interrupt::Clear(TInt anId)
	{
	__KTRACE_OPT(KEXTENSION,Kern::Printf("Interrupt::Clear id=%d",anId));
	TInt r=KErrNone;
	// if ID indicates a chained interrupt, call variant...
	if (anId<0 && ((((TUint)anId)>>16)&0x7fff)<(TUint)KNumTemplateInts)
		r=TemplateAssp::Variant->InterruptClear(anId);
	else if ((TUint)anId>=(TUint)KNumTemplateInts)
		r=KErrArgument;
	else
		{
		//
		// TO DO: (mandatory)
		//
		// Clear the corresponding Hardware Interrupt source
		//
		}
	return r;
	}

EXPORT_C TInt Interrupt::SetPriority(TInt /*anId*/, TInt /*aPriority*/)
	{
	//
	// If Interrupt priorities are supported the dispatchers need to take this in consideration
	// (IrqDispatch/FiqDispatch)
	//
	return KErrNotSupported;
	}
