// Copyright (c) 1997-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// WD_TEMPLATE.CPP
// Screen Driver for Text Window Server
// TO DO: (mandatory)
// This is the screen driver for the simple text Window Server supplied as part of
// E32. It is required to run the text shell, E32 & F32 tests etc.
// This is a working generic implementation which you shouldn't need to alter, but
// you may customise it if required. e.g. Change the default display mode or colors.
// ASSUMPTIONS MADE BY THIS IMPLEMENTATION
// * The start of each character on the display is byte aligned.
// 
//

#include "ws_std.h"
#include <e32twin.h>
#include <hal.h>
#include "u32std.h"
#include <videodriver.h>

#if 0
#define __DEBUG_PRINT(a) RDebug::Print(a)
#define __DEBUG_PRINT2(a,b) RDebug::Print(a,b)
#else
#define __DEBUG_PRINT(a)
#define __DEBUG_PRINT2(a,b)
#endif

#ifdef __X86__
extern CScreenDriver* NewScreenDriverVgaText();
#endif

const TUint32 KHwAccBlockFill=1;
const TUint32 KHwAccBlockCopy=2;

inline TInt HwBlockFill(SRectOpInfo &a)
	{
	return UserSvr::HalFunction(EHalGroupDisplay, EDisplayHalBlockFill, &a, NULL);
	}

inline TInt HwBlockCopy(SRectOpInfo &a)
	{
	return UserSvr::HalFunction(EHalGroupDisplay, EDisplayHalBlockCopy, &a, NULL);
	}

/**
 * Main screen driver implementation class.
 *
 * TO DO: (optional)
 *
 * The public API of this class is defined by the CScreenDriver class.
 * You may want to add some private definitions to this.
 */
class CScreenDriverTemplate : public CScreenDriver
	{
public:
	CScreenDriverTemplate();
	virtual void Init(TSize &aScreenSize,TSize &aFontSize);
	virtual void Blit(const TText *aBuffer,TInt aLength,const TPoint &aPosition);
	virtual TBool ScrollUp(const TRect& aRect);
	virtual void Clear(const TRect& aRect);

	virtual void SetPixel(const TPoint& aPoint,TUint8 aColour);
	virtual TInt GetPixel(const TPoint& aPoint);
	virtual void SetWord(const TPoint& aPoint,TInt aWord);
	virtual TInt GetWord(const TPoint& aPoint);
	virtual void SetLine(const TPoint& aPoint,const TPixelLine& aPixelLine);
	virtual void GetLine(const TPoint& aPoint,TPixelLine& aPixelLine);

	virtual void SetPaletteEntry(TColorIndex anIndex,TUint8 aRed,TUint8 aGreen,TUint8 aBlue);
	virtual void GetPaletteEntry(TColorIndex anIndex,TUint8 &aRed,TUint8 &aGreen,TUint8 &aBlue);
	virtual void SetForegroundColor(TColorIndex anIndex);
	virtual void SetBackgroundColor(TColorIndex anIndex);
	virtual void GetAttributeColors(TColorIndex* anArray);
	virtual TInt SetMode(TVideoMode aMode);
private:
	TUint8* CharPosToScreenAddress(const TPoint& aCharPos);
	TInt ColorToPixel(TInt aColorRgb);
	void CalcColorMode();
private:
	TInt iDisplayMode;
	TInt iMode;
	TInt iScreenAddress;
	TInt iScreenWidth;
	TInt iScreenHeight;
	TInt iScreenOffsetBetweenLines;
	TInt iBitsPerPixel;
	TInt iIsMono;
	TInt iIsPalettized;
	TInt iPixelSize;
	TInt iBackgroundPixel;
	TInt iTextPixel;
	TUint32 iBackgroundFill;
	TUint32 iTextFill;
	TUint32 iHwAcc;
	static const TUint8 Reverse[256];
	static const TUint8 Font[256][10];
	friend class CScreenDriver;
	};


/**
 * Table used to reverse the bits in a byte
 *
 * For example, index 0x03 (= 0000 0011 binary)
 * returns 0xC0 (= 1100 0000 binary)
 */
const TUint8 CScreenDriverTemplate::Reverse[256] =
	{
	0x00,0x80,0x40,0xC0,0x20,0xA0,0x60,0xE0,0x10,0x90,0x50,0xD0,0x30,0xB0,0x70,0xF0,
	0x08,0x88,0x48,0xC8,0x28,0xA8,0x68,0xE8,0x18,0x98,0x58,0xD8,0x38,0xB8,0x78,0xF8,
	0x04,0x84,0x44,0xC4,0x24,0xA4,0x64,0xE4,0x14,0x94,0x54,0xD4,0x34,0xB4,0x74,0xF4,
	0x0C,0x8C,0x4C,0xCC,0x2C,0xAC,0x6C,0xEC,0x1C,0x9C,0x5C,0xDC,0x3C,0xBC,0x7C,0xFC,
	0x02,0x82,0x42,0xC2,0x22,0xA2,0x62,0xE2,0x12,0x92,0x52,0xD2,0x32,0xB2,0x72,0xF2,
	0x0A,0x8A,0x4A,0xCA,0x2A,0xAA,0x6A,0xEA,0x1A,0x9A,0x5A,0xDA,0x3A,0xBA,0x7A,0xFA,
	0x06,0x86,0x46,0xC6,0x26,0xA6,0x66,0xE6,0x16,0x96,0x56,0xD6,0x36,0xB6,0x76,0xF6,
	0x0E,0x8E,0x4E,0xCE,0x2E,0xAE,0x6E,0xEE,0x1E,0x9E,0x5E,0xDE,0x3E,0xBE,0x7E,0xFE,
	0x01,0x81,0x41,0xC1,0x21,0xA1,0x61,0xE1,0x11,0x91,0x51,0xD1,0x31,0xB1,0x71,0xF1,
	0x09,0x89,0x49,0xC9,0x29,0xA9,0x69,0xE9,0x19,0x99,0x59,0xD9,0x39,0xB9,0x79,0xF9,
	0x05,0x85,0x45,0xC5,0x25,0xA5,0x65,0xE5,0x15,0x95,0x55,0xD5,0x35,0xB5,0x75,0xF5,
	0x0D,0x8D,0x4D,0xCD,0x2D,0xAD,0x6D,0xED,0x1D,0x9D,0x5D,0xDD,0x3D,0xBD,0x7D,0xFD,
	0x03,0x83,0x43,0xC3,0x23,0xA3,0x63,0xE3,0x13,0x93,0x53,0xD3,0x33,0xB3,0x73,0xF3,
	0x0B,0x8B,0x4B,0xCB,0x2B,0xAB,0x6B,0xEB,0x1B,0x9B,0x5B,0xDB,0x3B,0xBB,0x7B,0xFB,
	0x07,0x87,0x47,0xC7,0x27,0xA7,0x67,0xE7,0x17,0x97,0x57,0xD7,0x37,0xB7,0x77,0xF7,
	0x0F,0x8F,0x4F,0xCF,0x2F,0xAF,0x6F,0xEF,0x1F,0x9F,0x5F,0xDF,0x3F,0xBF,0x7F,0xFF
	};



/**
 * Define a font to be used
 * This is an 8x10 Font taken from the MISA driver
 * 
 * TO DO: (mandatory)
 */
const TInt KPixelsPerChar = 8;	// character width in pixels
const TInt KLinesPerChar = 10;	// character height in pixels

const TUint8 CScreenDriverTemplate::Font[256][10] =
 	{
		{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x7E,0x81,0xA5,0x81,0xBD,0x99,0x81,0x7E,0x00,0x00},
		{0x7E,0xFF,0xDB,0xFF,0xC3,0xE7,0xFF,0x7E,0x00,0x00},
		{0x6C,0xFE,0xFE,0xFE,0x7C,0x38,0x10,0x00,0x00,0x00},
		{0x10,0x38,0x7C,0xFE,0x7C,0x38,0x10,0x00,0x00,0x00},
		{0x38,0x7C,0x38,0xFE,0xFE,0x7C,0x38,0x7C,0x00,0x00},
		{0x10,0x10,0x38,0x7C,0xFE,0x7C,0x38,0x7C,0x00,0x00},
		{0x00,0x00,0x18,0x3C,0x3C,0x18,0x00,0x00,0x00,0x00},
		{0xFF,0xFF,0xE7,0xC3,0xC3,0xE7,0xFF,0xFF,0x00,0x00},
		{0x00,0x3C,0x66,0x42,0x42,0x66,0x3C,0x00,0x00,0x00},
		{0xFF,0xC3,0x99,0xBD,0xBD,0x99,0xC3,0xFF,0x00,0x00},
		{0x0F,0x07,0x0F,0x7D,0xCC,0xCC,0xCC,0x78,0x00,0x00},
		{0x3C,0x66,0x66,0x66,0x3C,0x18,0x7E,0x18,0x00,0x00},
		{0x3F,0x33,0x3F,0x30,0x30,0x70,0xF0,0xE0,0x00,0x00},
		{0x7F,0x63,0x7F,0x63,0x63,0x67,0xE6,0xC0,0x00,0x00},
		{0x99,0x5A,0x3C,0xE7,0xE7,0x3C,0x5A,0x99,0x00,0x00},

		{0x80,0xE0,0xF8,0xFE,0xF8,0xE0,0x80,0x00,0x00,0x00},
		{0x02,0x0E,0x3E,0xFE,0x3E,0x0E,0x02,0x00,0x00,0x00},
		{0x18,0x3C,0x7E,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00},
		{0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x00,0x00,0x00},
		{0x7F,0xDB,0xDB,0x7B,0x1B,0x1B,0x1B,0x00,0x00,0x00},
		{0x3E,0x63,0x38,0x6C,0x6C,0x38,0xCC,0x78,0x00,0x00},
		{0x00,0x00,0x00,0x00,0x7E,0x7E,0x7E,0x00,0x00,0x00},
		{0x18,0x3C,0x7E,0x18,0x7E,0x3C,0x18,0xFF,0x00,0x00},
		{0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x00,0x00,0x00},
		{0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00,0x00},
		{0x00,0x18,0x0C,0xFE,0x0C,0x18,0x00,0x00,0x00,0x00},
		{0x00,0x30,0x60,0xFE,0x60,0x30,0x00,0x00,0x00,0x00},
		{0x00,0x00,0xC0,0xC0,0xC0,0xFE,0x00,0x00,0x00,0x00},
		{0x00,0x24,0x66,0xFF,0x66,0x24,0x00,0x00,0x00,0x00},
		{0x00,0x18,0x3C,0x7E,0xFF,0xFF,0x00,0x00,0x00,0x00},
		{0x00,0xFF,0xFF,0x7E,0x3C,0x18,0x00,0x00,0x00,0x00},

		{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x30,0x78,0x78,0x78,0x30,0x00,0x30,0x00,0x00,0x00},	// !
		{0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x6C,0x6C,0xFE,0x6C,0xFE,0x6C,0x6C,0x00,0x00,0x00},	//#
		{0x30,0x7C,0xC0,0x78,0x0C,0xF8,0x30,0x00,0x00,0x00},	//$
		{0x00,0xC6,0xCC,0x18,0x30,0x66,0xC6,0x00,0x00,0x00},
		{0x38,0x6C,0x38,0x76,0xDC,0xCC,0x76,0x00,0x00,0x00},
		{0x60,0x60,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x18,0x30,0x60,0x60,0x60,0x30,0x18,0x00,0x00,0x00},
		{0x60,0x30,0x18,0x18,0x18,0x30,0x60,0x00,0x00,0x00},
		{0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00,0x00,0x00},
		{0x00,0x30,0x30,0xFC,0x30,0x30,0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x60,0x00,0x00},
		{0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00},	//-
		{0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00},	//.
		{0x06,0x0C,0x18,0x30,0x60,0xC0,0x80,0x00,0x00,0x00},	///

		{0x7C,0xC6,0xCE,0xDE,0xF6,0xE6,0x7C,0x00,0x00,0x00},	//0
		{0x30,0x70,0x30,0x30,0x30,0x30,0xFC,0x00,0x00,0x00},
		{0x78,0xCC,0x0C,0x38,0x60,0xCC,0xFC,0x00,0x00,0x00},
		{0x78,0xCC,0x0C,0x38,0x0C,0xCC,0x78,0x00,0x00,0x00},
		{0x1C,0x3C,0x6C,0xCC,0xFE,0x0C,0x1E,0x00,0x00,0x00},
		{0xFC,0xC0,0xF8,0x0C,0x0C,0xCC,0x78,0x00,0x00,0x00},
		{0x38,0x60,0xC0,0xF8,0xCC,0xCC,0x78,0x00,0x00,0x00},
		{0xFC,0xCC,0x0C,0x18,0x30,0x30,0x30,0x00,0x00,0x00},
		{0x78,0xCC,0xCC,0x78,0xCC,0xCC,0x78,0x00,0x00,0x00},
		{0x78,0xCC,0xCC,0x7C,0x0C,0x18,0x70,0x00,0x00,0x00},	//9
		{0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x00,0x00,0x00},	//:
		{0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x60,0x00,0x00},	//;
		{0x18,0x30,0x60,0xC0,0x60,0x30,0x18,0x00,0x00,0x00},	//<
		{0x00,0x00,0xFC,0x00,0x00,0xFC,0x00,0x00,0x00,0x00},	//=
		{0x60,0x30,0x18,0x0C,0x18,0x30,0x60,0x00,0x00,0x00},	//>
		{0x78,0xCC,0x0C,0x18,0x30,0x00,0x30,0x00,0x00,0x00},	//?

		{0x7C,0xC6,0xDE,0xDE,0xDE,0xC0,0x78,0x00,0x00,0x00},	//@
		{0x30,0x78,0xCC,0xCC,0xFC,0xCC,0xCC,0x00,0x00,0x00},	//A
		{0xFC,0x66,0x66,0x7C,0x66,0x66,0xFC,0x00,0x00,0x00},	//B
		{0x3C,0x66,0xC0,0xC0,0xC0,0x66,0x3C,0x00,0x00,0x00},	//C
		{0xF8,0x6C,0x66,0x66,0x66,0x6C,0xF8,0x00,0x00,0x00},	//D
		{0x7E,0x60,0x60,0x78,0x60,0x60,0x7E,0x00,0x00,0x00},	//E
		{0x7E,0x60,0x60,0x78,0x60,0x60,0x60,0x00,0x00,0x00},	//F
		{0x3C,0x66,0xC0,0xC0,0xCE,0x66,0x3E,0x00,0x00,0x00},	//G
		{0xCC,0xCC,0xCC,0xFC,0xCC,0xCC,0xCC,0x00,0x00,0x00},	//H
		{0x78,0x30,0x30,0x30,0x30,0x30,0x78,0x00,0x00,0x00},	//I
		{0x1E,0x0C,0x0C,0x0C,0xCC,0xCC,0x78,0x00,0x00,0x00},	//J
		{0xE6,0x66,0x6C,0x78,0x6C,0x66,0xE6,0x00,0x00,0x00},	//K
		{0x60,0x60,0x60,0x60,0x60,0x60,0x7E,0x00,0x00,0x00},	//L
		{0xC6,0xEE,0xFE,0xFE,0xD6,0xC6,0xC6,0x00,0x00,0x00},	//M
		{0xC6,0xE6,0xF6,0xDE,0xCE,0xC6,0xC6,0x00,0x00,0x00},	//N
		{0x38,0x6C,0xC6,0xC6,0xC6,0x6C,0x38,0x00,0x00,0x00},	//O

		{0xFC,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00,0x00,0x00},	//P
		{0x78,0xCC,0xCC,0xCC,0xDC,0x78,0x1C,0x00,0x00,0x00},	//Q
		{0xFC,0x66,0x66,0x7C,0x6C,0x66,0xE6,0x00,0x00,0x00},	//R
		{0x78,0xCC,0xE0,0x70,0x1C,0xCC,0x78,0x00,0x00,0x00},	//S
		{0xFC,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00},	//T
		{0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xFC,0x00,0x00,0x00},	//U
		{0xCC,0xCC,0xCC,0xCC,0xCC,0x78,0x30,0x00,0x00,0x00},	//V
		{0xC6,0xC6,0xC6,0xD6,0xFE,0xEE,0xC6,0x00,0x00,0x00},	//W
		{0xC6,0xC6,0x6C,0x38,0x38,0x6C,0xC6,0x00,0x00,0x00},	//X
		{0xCC,0xCC,0xCC,0x78,0x30,0x30,0x78,0x00,0x00,0x00},	//Y
		{0xFE,0x06,0x0C,0x18,0x30,0x60,0xFE,0x00,0x00,0x00},	//Z
		{0x78,0x60,0x60,0x60,0x60,0x60,0x78,0x00,0x00,0x00},
		{0xC0,0x60,0x30,0x18,0x0C,0x06,0x02,0x00,0x00,0x00},
		{0x78,0x18,0x18,0x18,0x18,0x18,0x78,0x00,0x00,0x00},
		{0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00},

		{0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x00,0x00,0x78,0x0C,0x7C,0xCC,0x76,0x00,0x00,0x00},
		{0xE0,0x60,0x60,0x7C,0x66,0x66,0xDC,0x00,0x00,0x00},
		{0x00,0x00,0x78,0xCC,0xC0,0xCC,0x78,0x00,0x00,0x00},
		{0x1C,0x0C,0x0C,0x7C,0xCC,0xCC,0x76,0x00,0x00,0x00},
		{0x00,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00,0x00,0x00},
		{0x38,0x6C,0x60,0xF0,0x60,0x60,0xF0,0x00,0x00,0x00},
		{0x00,0x00,0x76,0xCC,0xCC,0x7C,0x0C,0xF8,0x00,0x00},
		{0xE0,0x60,0x6C,0x76,0x66,0x66,0xE6,0x00,0x00,0x00},
		{0x30,0x00,0x70,0x30,0x30,0x30,0x78,0x00,0x00,0x00},
		{0x0C,0x00,0x0C,0x0C,0x0C,0xCC,0xCC,0x78,0x00,0x00},
		{0xE0,0x60,0x66,0x6C,0x78,0x6C,0xE6,0x00,0x00,0x00},
		{0x70,0x30,0x30,0x30,0x30,0x30,0x78,0x00,0x00,0x00},
		{0x00,0x00,0xCC,0xFE,0xFE,0xD6,0xC6,0x00,0x00,0x00},
		{0x00,0x00,0xF8,0xCC,0xCC,0xCC,0xCC,0x00,0x00,0x00},
		{0x00,0x00,0x78,0xCC,0xCC,0xCC,0x78,0x00,0x00,0x00},

		{0x00,0x00,0xDC,0x66,0x66,0x7C,0x60,0xF0,0x00,0x00},
		{0x00,0x00,0x76,0xCC,0xCC,0x7C,0x0C,0x1E,0x00,0x00},
		{0x00,0x00,0xDC,0x76,0x66,0x60,0xF0,0x00,0x00,0x00},
		{0x00,0x00,0x7C,0xC0,0x78,0x0C,0xF8,0x00,0x00,0x00},
		{0x10,0x30,0x7C,0x30,0x30,0x34,0x18,0x00,0x00,0x00},
		{0x00,0x00,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00},
		{0x00,0x00,0xCC,0xCC,0xCC,0x78,0x30,0x00,0x00,0x00},
		{0x00,0x00,0xC6,0xD6,0xFE,0xFE,0x6C,0x00,0x00,0x00},
		{0x00,0x00,0xC6,0x6C,0x38,0x6C,0xC6,0x00,0x00,0x00},
		{0x00,0x00,0xCC,0xCC,0xCC,0x7C,0x0C,0xF8,0x00,0x00},
		{0x00,0x00,0xFC,0x98,0x30,0x64,0xFC,0x00,0x00,0x00},
		{0x1C,0x30,0x30,0xE0,0x30,0x30,0x1C,0x00,0x00,0x00},
		{0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00,0x00,0x00},
		{0xE0,0x30,0x30,0x1C,0x30,0x30,0xE0,0x00,0x00,0x00},
		{0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0x00,0x00,0x00},

		{0x3C,0x66,0x60,0x66,0x3C,0x0C,0x06,0x3C,0x00,0x00},
		{0x00,0x66,0x00,0x66,0x66,0x66,0x3F,0x00,0x00,0x00},
		{0x0E,0x00,0x3C,0x66,0x7E,0x60,0x3C,0x00,0x00,0x00},
		{0x7E,0xC3,0x3C,0x06,0x3E,0x66,0x3F,0x00,0x00,0x00},
		{0x66,0x00,0x3C,0x06,0x3E,0x66,0x3F,0x00,0x00,0x00},
		{0x70,0x00,0x3C,0x06,0x3E,0x66,0x3F,0x00,0x00,0x00},
		{0x18,0x18,0x3C,0x06,0x3E,0x66,0x3F,0x00,0x00,0x00},
		{0x00,0x00,0x3C,0x60,0x60,0x3C,0x06,0x1C,0x00,0x00},
		{0x7E,0xC3,0x3C,0x66,0x7E,0x60,0x3C,0x00,0x00,0x00},
		{0x66,0x00,0x3C,0x66,0x7E,0x60,0x3C,0x00,0x00,0x00},
		{0x70,0x00,0x3C,0x66,0x7E,0x60,0x3C,0x00,0x00,0x00},
		{0x66,0x00,0x38,0x18,0x18,0x18,0x3C,0x00,0x00,0x00},
		{0x7C,0xC6,0x38,0x18,0x18,0x18,0x3C,0x00,0x00,0x00},
		{0x70,0x00,0x38,0x18,0x18,0x18,0x3C,0x00,0x00,0x00},
		{0x63,0x1C,0x36,0x63,0x7F,0x63,0x63,0x00,0x00,0x00},
		{0x18,0x18,0x00,0x3C,0x66,0x7E,0x66,0x00,0x00,0x00},

		{0x0E,0x00,0x7E,0x30,0x3C,0x30,0x7E,0x00,0x00,0x00},
		{0x00,0x00,0x7F,0x0C,0x7F,0xCC,0x7F,0x00,0x00,0x00},
		{0x1F,0x36,0x66,0x7F,0x66,0x66,0x67,0x00,0x00,0x00},
		{0x3C,0x66,0x00,0x3C,0x66,0x66,0x3C,0x00,0x00,0x00},
		{0x00,0x66,0x00,0x3C,0x66,0x66,0x3C,0x00,0x00,0x00},
		{0x00,0x70,0x00,0x3C,0x66,0x66,0x3C,0x00,0x00,0x00},
		{0x3C,0x66,0x00,0x66,0x66,0x66,0x3F,0x00,0x00,0x00},
		{0x00,0x70,0x00,0x66,0x66,0x66,0x3F,0x00,0x00,0x00},
		{0x00,0x66,0x00,0x66,0x66,0x3E,0x06,0x7C,0x00,0x00},
		{0xC3,0x18,0x3C,0x66,0x66,0x3C,0x18,0x00,0x00,0x00},
		{0x66,0x00,0x66,0x66,0x66,0x66,0x3C,0x00,0x00,0x00},
		{0x18,0x18,0x7E,0xC0,0xC0,0x7E,0x18,0x18,0x00,0x00},
		{0x1C,0x36,0x32,0x78,0x30,0x73,0x7E,0x00,0x00,0x00},	//
		{0x66,0x66,0x3C,0x7E,0x18,0x7E,0x18,0x18,0x00,0x00},
		{0xF8,0xCC,0xCC,0xFA,0xC6,0xCF,0xC6,0xC7,0x00,0x00},
		{0x0E,0x1B,0x18,0x3C,0x18,0x18,0xD8,0x70,0x00,0x00},

		{0x0E,0x00,0x3C,0x06,0x3E,0x66,0x3F,0x00,0x00,0x00},
		{0x1C,0x00,0x38,0x18,0x18,0x18,0x3C,0x00,0x00,0x00},
		{0x00,0x0E,0x00,0x3C,0x66,0x66,0x3C,0x00,0x00,0x00},
		{0x00,0x0E,0x00,0x66,0x66,0x66,0x3F,0x00,0x00,0x00},
		{0x00,0x7C,0x00,0x7C,0x66,0x66,0x66,0x00,0x00,0x00},
		{0x7E,0x00,0x66,0x76,0x7E,0x6E,0x66,0x00,0x00,0x00},
		{0x3C,0x6C,0x6C,0x3E,0x00,0x7E,0x00,0x00,0x00,0x00},
		{0x38,0x6C,0x6C,0x38,0x00,0x7C,0x00,0x00,0x00,0x00},
		{0x18,0x00,0x18,0x30,0x60,0x66,0x3C,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x7E,0x60,0x60,0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x7E,0x06,0x06,0x00,0x00,0x00,0x00},
		{0xC3,0xC6,0xCC,0xDE,0x33,0x66,0xCC,0x0F,0x00,0x00},
		{0xC3,0xC6,0xCC,0xDB,0x37,0x6F,0xCF,0x03,0x00,0x00},
		{0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x00,0x00,0x00},
		{0x00,0x33,0x66,0xCC,0x66,0x33,0x00,0x00,0x00,0x00},
		{0x00,0xCC,0x66,0x33,0x66,0xCC,0x00,0x00,0x00,0x00},

		{0x22,0x88,0x22,0x88,0x22,0x88,0x22,0x88,0x00,0x00},
		{0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA},
		{0xDB,0x77,0xDB,0xEE,0xDB,0x77,0xDB,0xEE,0xDB,0x77},
		{0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
		{0x18,0x18,0x18,0x18,0xF8,0x18,0x18,0x18,0x18,0x18},
		{0x18,0x18,0xF8,0x18,0xF8,0x18,0x18,0x18,0x18,0x18},
		{0x36,0x36,0x36,0x36,0xF6,0x36,0x36,0x36,0x36,0x36},
		{0x00,0x00,0x00,0x00,0xFE,0x36,0x36,0x36,0x36,0x36},
		{0x00,0x00,0xF8,0x18,0xF8,0x18,0x18,0x18,0x18,0x18},
		{0x36,0x36,0xF6,0x06,0xF6,0x36,0x36,0x36,0x36,0x36},
		{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},
		{0x00,0x00,0xFE,0x06,0xF6,0x36,0x36,0x36,0x36,0x36},
		{0x36,0x36,0xF6,0x06,0xFE,0x00,0x00,0x00,0x00,0x00},
		{0x36,0x36,0x36,0x36,0xFE,0x00,0x00,0x00,0x00,0x00},
		{0x18,0x18,0xF8,0x18,0xF8,0x00,0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18,0x18,0x18},

		{0x18,0x18,0x18,0x18,0x1F,0x00,0x00,0x00,0x00,0x00},
		{0x18,0x18,0x18,0x18,0xFF,0x00,0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00,0xFF,0x18,0x18,0x18,0x18,0x18},
		{0x18,0x18,0x18,0x18,0x1F,0x18,0x18,0x18,0x18,0x18},
		{0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00},
		{0x18,0x18,0x18,0x18,0xFF,0x18,0x18,0x18,0x18,0x18},
		{0x18,0x18,0x1F,0x18,0x1F,0x18,0x18,0x18,0x18,0x18},
		{0x36,0x36,0x36,0x36,0x37,0x36,0x36,0x36,0x36,0x36},
		{0x36,0x36,0x37,0x30,0x3F,0x00,0x00,0x00,0x00,0x00},
		{0x00,0x00,0x3F,0x30,0x37,0x36,0x36,0x36,0x36,0x36},
		{0x36,0x36,0xF7,0x00,0xFF,0x00,0x00,0x00,0x00,0x00},
		{0x00,0x00,0xFF,0x00,0xF7,0x36,0x36,0x36,0x36,0x36},
		{0x36,0x36,0x37,0x30,0x37,0x36,0x36,0x36,0x36,0x36},
		{0x00,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00},
		{0x36,0x36,0xF7,0x00,0xF7,0x36,0x36,0x36,0x36,0x36},
		{0x18,0x18,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00},

		{0x36,0x36,0x36,0x36,0xFF,0x00,0x00,0x00,0x00,0x00},
		{0x00,0x00,0xFF,0x00,0xFF,0x18,0x18,0x18,0x18,0x18},
		{0x00,0x00,0x00,0x00,0xFF,0x36,0x36,0x36,0x36,0x36},
		{0x36,0x36,0x36,0x36,0x3F,0x00,0x00,0x00,0x00,0x00},
		{0x18,0x18,0x1F,0x18,0x1F,0x00,0x00,0x00,0x00,0x00},
		{0x00,0x00,0x1F,0x18,0x1F,0x18,0x18,0x18,0x18,0x18},
		{0x00,0x00,0x00,0x00,0x3F,0x36,0x36,0x36,0x36,0x36},
		{0x36,0x36,0x36,0x36,0xFF,0x36,0x36,0x36,0x36,0x36},
		{0x18,0x18,0xFF,0x18,0xFF,0x18,0x18,0x18,0x18,0x18},
		{0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00,0x1F,0x18,0x18,0x18,0x18,0x18},
		{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00},
		{0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00},
		{0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x00,0x00},
		{0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,0x00},
		{0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00},

		{0x00,0x00,0x3B,0x6E,0x64,0x6E,0x3B,0x00,0x00,0x00},
		{0x00,0x3C,0x66,0x7C,0x66,0x7C,0x60,0x60,0x00,0x00},
		{0x00,0x7E,0x66,0x60,0x60,0x60,0x60,0x00,0x00,0x00},
		{0x00,0x7F,0x36,0x36,0x36,0x36,0x36,0x00,0x00,0x00},
		{0x7E,0x66,0x30,0x18,0x30,0x66,0x7E,0x00,0x00,0x00},
		{0x00,0x00,0x3F,0x6C,0x6C,0x6C,0x38,0x00,0x00,0x00},
		{0x00,0x33,0x33,0x33,0x33,0x3E,0x30,0x60,0x00,0x00},
		{0x00,0x3B,0x6E,0x0C,0x0C,0x0C,0x0C,0x00,0x00,0x00},
		{0x7E,0x18,0x3C,0x66,0x66,0x3C,0x18,0x7E,0x00,0x00},
		{0x1C,0x36,0x63,0x7F,0x63,0x36,0x1C,0x00,0x00,0x00},
		{0x1C,0x36,0x63,0x63,0x36,0x36,0x77,0x00,0x00,0x00},
		{0x0E,0x18,0x0C,0x3E,0x66,0x66,0x3C,0x00,0x00,0x00},
		{0x00,0x00,0x7E,0xDB,0xDB,0x7E,0x00,0x00,0x00,0x00},
		{0x06,0x0C,0x7E,0xDB,0xDB,0x7E,0x60,0xC0,0x00,0x00},
		{0x1C,0x60,0xC0,0xFC,0xC0,0x60,0x1C,0x00,0x00,0x00},
		{0x3C,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00},

		{0x00,0x7E,0x00,0x7E,0x00,0x7E,0x00,0x00,0x00,0x00},
		{0x18,0x18,0x7E,0x18,0x18,0x00,0x7E,0x00,0x00,0x00},
		{0x30,0x18,0x0C,0x18,0x30,0x00,0x7E,0x00,0x00,0x00},
		{0x0C,0x18,0x30,0x18,0x0C,0x00,0x7E,0x00,0x00,0x00},
		{0x0E,0x1B,0x1B,0x18,0x18,0x18,0x18,0x18,0x00,0x00},
		{0x18,0x18,0x18,0x18,0x18,0xD8,0xD8,0x70,0x00,0x00},
		{0x18,0x18,0x00,0x7E,0x00,0x18,0x18,0x00,0x00,0x00},
		{0x00,0x76,0xDC,0x00,0x76,0xDC,0x00,0x00,0x00,0x00},
		{0x38,0x6C,0x6C,0x38,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00},
		{0x0F,0x0C,0x0C,0x0C,0xEC,0x6C,0x3C,0x1C,0x00,0x00},
		{0x78,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00},
		{0x70,0x18,0x30,0x60,0x78,0x00,0x00,0x00,0x00,0x00},
		{0x00,0x00,0x3C,0x3C,0x3C,0x3C,0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
	};



/**
 * A copy of the standard 256 color palette used by the SymbianOS.
 * Each value is in the format 00000000bbbbbbbbggggggggrrrrrrrr
 */
const TUint32 Palette256[256] =
	{
	0x00000000,	0x00000033,	0x00000066,	0x00000099,	0x000000cc,	0x000000ff,
	0x00003300,	0x00003333,	0x00003366,	0x00003399,	0x000033cc,	0x000033ff,
	0x00006600,	0x00006633,	0x00006666,	0x00006699,	0x000066cc,	0x000066ff,
	0x00009900,	0x00009933,	0x00009966,	0x00009999,	0x000099cc,	0x000099ff,
	0x0000cc00,	0x0000cc33,	0x0000cc66,	0x0000cc99,	0x0000cccc,	0x0000ccff,
	0x0000ff00,	0x0000ff33,	0x0000ff66,	0x0000ff99,	0x0000ffcc,	0x0000ffff,

	0x00330000,	0x00330033,	0x00330066,	0x00330099,	0x003300cc,	0x003300ff,
	0x00333300,	0x00333333,	0x00333366,	0x00333399,	0x003333cc,	0x003333ff,
	0x00336600,	0x00336633,	0x00336666,	0x00336699,	0x003366cc,	0x003366ff,
	0x00339900,	0x00339933,	0x00339966,	0x00339999,	0x003399cc,	0x003399ff,
	0x0033cc00,	0x0033cc33,	0x0033cc66,	0x0033cc99,	0x0033cccc,	0x0033ccff,
	0x0033ff00,	0x0033ff33,	0x0033ff66,	0x0033ff99,	0x0033ffcc,	0x0033ffff,

	0x00660000,	0x00660033,	0x00660066,	0x00660099,	0x006600cc,	0x006600ff,
	0x00663300,	0x00663333,	0x00663366,	0x00663399,	0x006633cc,	0x006633ff,
	0x00666600,	0x00666633,	0x00666666,	0x00666699,	0x006666cc,	0x006666ff,
	0x00669900,	0x00669933,	0x00669966,	0x00669999,	0x006699cc,	0x006699ff,
	0x0066cc00,	0x0066cc33,	0x0066cc66,	0x0066cc99,	0x0066cccc,	0x0066ccff,
	0x0066ff00,	0x0066ff33,	0x0066ff66,	0x0066ff99,	0x0066ffcc,	0x0066ffff,

	0x00111111, 0x00222222, 0x00444444, 0x00555555, 0x00777777,
	0x00000011, 0x00000022, 0x00000044, 0x00000055, 0x00000077,
	0x00001100,	0x00002200,	0x00004400,	0x00005500,	0x00007700,
	0x00110000,	0x00220000,	0x00440000,	0x00550000,	0x00770000,

	0x00880000,	0x00aa0000,	0x00bb0000,	0x00dd0000,	0x00ee0000,
	0x00008800,	0x0000aa00,	0x0000bb00,	0x0000dd00,	0x0000ee00,
	0x00000088,	0x000000aa,	0x000000bb,	0x000000dd,	0x000000ee,
	0x00888888, 0x00aaaaaa, 0x00bbbbbb, 0x00dddddd, 0x00eeeeee,

	0x00990000,	0x00990033,	0x00990066,	0x00990099,	0x009900cc,	0x009900ff,
	0x00993300,	0x00993333,	0x00993366,	0x00993399,	0x009933cc,	0x009933ff,
	0x00996600,	0x00996633,	0x00996666,	0x00996699,	0x009966cc,	0x009966ff,
	0x00999900,	0x00999933,	0x00999966,	0x00999999,	0x009999cc,	0x009999ff,
	0x0099cc00,	0x0099cc33,	0x0099cc66,	0x0099cc99,	0x0099cccc,	0x0099ccff,
	0x0099ff00,	0x0099ff33,	0x0099ff66,	0x0099ff99,	0x0099ffcc,	0x0099ffff,

	0x00cc0000,	0x00cc0033,	0x00cc0066,	0x00cc0099,	0x00cc00cc,	0x00cc00ff,
	0x00cc3300,	0x00cc3333,	0x00cc3366,	0x00cc3399,	0x00cc33cc,	0x00cc33ff,
	0x00cc6600,	0x00cc6633,	0x00cc6666,	0x00cc6699,	0x00cc66cc,	0x00cc66ff,
	0x00cc9900,	0x00cc9933,	0x00cc9966,	0x00cc9999,	0x00cc99cc,	0x00cc99ff,
	0x00cccc00,	0x00cccc33,	0x00cccc66,	0x00cccc99,	0x00cccccc,	0x00ccccff,
	0x00ccff00,	0x00ccff33,	0x00ccff66,	0x00ccff99,	0x00ccffcc,	0x00ccffff,

	0x00ff0000,	0x00ff0033,	0x00ff0066,	0x00ff0099,	0x00ff00cc,	0x00ff00ff,
	0x00ff3300,	0x00ff3333,	0x00ff3366,	0x00ff3399,	0x00ff33cc,	0x00ff33ff,
	0x00ff6600,	0x00ff6633,	0x00ff6666,	0x00ff6699,	0x00ff66cc,	0x00ff66ff,
	0x00ff9900,	0x00ff9933,	0x00ff9966,	0x00ff9999,	0x00ff99cc,	0x00ff99ff,
	0x00ffcc00,	0x00ffcc33,	0x00ffcc66,	0x00ffcc99,	0x00ffcccc,	0x00ffccff,
	0x00ffff00,	0x00ffff33,	0x00ffff66,	0x00ffff99,	0x00ffffcc,	0x00ffffff
	};

/**
 * Construct and return the new screen driver
 */
EXPORT_C CScreenDriver* CScreenDriver::New()
	{
	__DEBUG_PRINT(_L("CSD::New"));

#ifdef __X86__
	TInt mode=0;
	HAL::Get(HAL::EDisplayMode, mode);
	if (mode==0)
		return NewScreenDriverVgaText();
#endif
	CScreenDriverTemplate *pS=new CScreenDriverTemplate;
	if (pS->iScreenAddress)
		{
		return(pS);
		}
	delete pS;
	return(NULL);
	}



/**
 * Implementation of the screen driver
 * Constructor
 */

CScreenDriverTemplate::CScreenDriverTemplate()
	{

	__DEBUG_PRINT(_L("CSD::Ctor"));
	
	//
	// Start in default mode the display driver is in
	//
	TInt offset;
	TInt r = HAL::Get(HAL::EDisplayMode, iDisplayMode);
	if(r!=KErrNone)
		goto fail;
	__DEBUG_PRINT2(_L("EDisplayMode %d"), iDisplayMode);
	
	iBitsPerPixel = iDisplayMode; //getbpp needs the current mode as its param
	r = HAL::Get(HAL::EDisplayBitsPerPixel,iBitsPerPixel);	
	if(r!=KErrNone)
		goto fail;
	__DEBUG_PRINT2(_L("EDisplayBitsPerPixel %d"), iBitsPerPixel);

	iIsPalettized = iDisplayMode; //ispalettized needs the current mode as its param
	r = HAL::Get(HAL::EDisplayIsPalettized,iIsPalettized);	
	if(r!=KErrNone)
		goto fail;
	__DEBUG_PRINT2(_L("EDisplayIsPalettized %d"),iIsPalettized);

	iIsMono = iDisplayMode; //ispalettized needs the current mode as its param
	r = HAL::Get(HAL::EDisplayIsMono, iIsMono);	
	if(r!=KErrNone)
		goto fail;
	__DEBUG_PRINT2(_L("EDisplayIsMono  %d"), iIsMono);

	
	CalcColorMode();

	__DEBUG_PRINT2(_L("iMode is %d"),iMode);
	//
	// Obtain the screen info from HAL
	//
	r = HAL::Get(HAL::EDisplayMemoryAddress,iScreenAddress);
	if(r!=KErrNone)
		goto fail;
	__DEBUG_PRINT2(_L("EDisplayMemoryAddress 0x%x"), iScreenAddress);
	
	offset = iDisplayMode;
	r = HAL::Get(HAL::EDisplayOffsetToFirstPixel,offset);
	if(r!=KErrNone)
		goto fail;
	__DEBUG_PRINT2(_L("EDisplayOffsetToFirstPixel  %d"),offset);
	iScreenAddress += offset;

	iScreenOffsetBetweenLines = iDisplayMode;
	r = HAL::Get(HAL::EDisplayOffsetBetweenLines,iScreenOffsetBetweenLines);
	if(r!=KErrNone)
		goto fail;
	__DEBUG_PRINT2(_L("EDisplayOffsetBetweenLines  %d"), iScreenOffsetBetweenLines);
	
	r = HAL::Get(HAL::EDisplayXPixels,iScreenWidth);
	if(r!=KErrNone)
		goto fail;
	__DEBUG_PRINT2(_L("EDisplayXPixels  %d"),iScreenWidth);
	
	r = HAL::Get(HAL::EDisplayYPixels,iScreenHeight);
	if(r!=KErrNone)
		goto fail;
	__DEBUG_PRINT2(_L("EDisplayYPixels  %d"), iScreenHeight);

	if(iMode==EColor256)
		{
		// Setup palette (this is the standard SymbianOS 256 colour palette)
		for(TInt i=0; i<256; i++)
			{
			TInt entry = Palette256[i]+(i<<24);
			HAL::Set(HAL::EDisplayPaletteEntry,entry); // Ignore error
			}
	__DEBUG_PRINT(_L("EColor256"));
		}
	else if(iMode==EGray16)
		{
		// Setup palette
		for(TInt i=0; i<16; i++)
			{
			TInt entry = i|(i<<4);
			entry |= entry<<8;
			entry |= entry<<12;
			HAL::Set(HAL::EDisplayPaletteEntry,entry); // Ignore error
			}
	__DEBUG_PRINT(_L("EGray16"));
		}
	else if(iMode==EGray4)
		{
		// Setup palette
		for(TInt i=0; i<4; i++)
			{
			TInt entry = i|(i<<2);
			entry |= entry<<4;
			entry |= entry<<8;
			entry |= entry<<10;
			HAL::Set(HAL::EDisplayPaletteEntry,entry); // Ignore error
			}
	__DEBUG_PRINT(_L("EGray4"));
		}
	else if(iMode==EMono)
		{
		// Setup palette
		TInt entry = 0;
		HAL::Set(HAL::EDisplayPaletteEntry,entry); // Ignore error
		entry = 0x01FFFFFF;
		HAL::Set(HAL::EDisplayPaletteEntry,entry); // Ignore error
	__DEBUG_PRINT(_L("EMono"));
		}
	else
		{
		__DEBUG_PRINT(_L("unknown mode"));

		}

	//
	// Initialise values used for drawing
	//
	if(iBitsPerPixel==12)
		iPixelSize = 16;
	else
		iPixelSize = iBitsPerPixel;

	{
	TInt KBackgroundColor = 0xff0000; // color in format 0xbbggrr
	TInt KTextColor = 0xffffff;		// color in format 0xbbggrr

	if (( iBitsPerPixel == 24 ) || ( iBitsPerPixel == 32 ) )
		{
		iPixelSize = 32;
//		KTextColor = 0x00FFFF;//Text color yellow when 24ubpp
		}

	if(iPixelSize<8)
		{
		KBackgroundColor = 0xffffff; // color in format 0xbbggrr
		KTextColor = 0x000000;		// color in format 0xbbggrr
		}

	iBackgroundPixel = ColorToPixel(KBackgroundColor);
	iBackgroundFill = iBackgroundPixel;
	{
	TInt shift = iPixelSize;
	while(shift<32)
		{
		iBackgroundFill |= iBackgroundFill<<shift;
		shift <<= 1;
		}
	}

	iTextPixel = ColorToPixel(KTextColor);
	iTextFill = iTextPixel;
	{
	TInt shift = iPixelSize;
	while(shift<32)
		{
		iTextFill |= iTextFill<<shift;
		shift <<= 1;
		}
	}
	}

	SRectOpInfo roi;
	Mem::FillZ(&roi, sizeof(roi));
	if (HwBlockFill(roi)==KErrNone)
		iHwAcc |= KHwAccBlockFill;
	if (HwBlockCopy(roi)==KErrNone)
		iHwAcc |= KHwAccBlockCopy;

	//
	// Done
	//
	__DEBUG_PRINT(_L("CSD::Ctor done"));
	return;

fail:

	iScreenAddress = NULL;
	__DEBUG_PRINT2(_L("CSD::Ctor failed r=%d"),r);
	}


void CScreenDriverTemplate::Init(TSize &aScreenSize,TSize &aFontSize)
//
// Initialise the screen driver and report screen information
//
	{

	__DEBUG_PRINT(_L("CSD::Init"));

	aFontSize=TSize(KPixelsPerChar,KLinesPerChar);
	aScreenSize.iWidth=iScreenWidth/KPixelsPerChar;
	aScreenSize.iHeight=iScreenHeight/KLinesPerChar;

	Clear(aScreenSize);
	}


TInt CScreenDriverTemplate::SetMode(TVideoMode aMode)
	{
	/**
	 * TO DO: (optional)
	 *
	 * If you support multiple video modes then implement video mode switching
	 * here. After the mode switch the screen contents should appear as before.
	 * The current mode should be stored in iMode, and other member data updated
	 * as appropriate. I.e. iScreenAddress, iScreenWidth, iScreenHeight, 
	 * iScreenOffsetBetweenLines, iBitsPerPixel and iPixelSize (See ctor code.)
	 */

	__DEBUG_PRINT(_L("CSD::SetMode"));
	return(aMode==iMode ? KErrNone : KErrNotSupported);
	}


TUint8* CScreenDriverTemplate::CharPosToScreenAddress(const TPoint& aCharPos)
//
// Returns the screen address for the given character position 
//
	{
	return (TUint8*)iScreenAddress +
		aCharPos.iY * iScreenOffsetBetweenLines * KLinesPerChar +
		((aCharPos.iX * KPixelsPerChar * iPixelSize) >> 3);
	}

void CScreenDriverTemplate::CalcColorMode()
	{
	iMode = 0;
	//calculate the color mode
	if (iIsPalettized)
		{
		if (iIsMono)
			{
			if (1 == iBitsPerPixel)
				iMode = EMono;
			else if (2 == iBitsPerPixel)
				iMode = EGray4;
			else if (4 == iBitsPerPixel)
				iMode = EGray16;
			}
		else
			{
			if (8 == iBitsPerPixel)
				iMode = EColor256;
			else if (4 == iBitsPerPixel)
				iMode = EGray16;			//we are color but color16 is not supported
			}
		}
	else
		{
		if (!iIsMono)
			{
			if (12 == iBitsPerPixel)
				iMode = EColor4K;
			else if (16 == iBitsPerPixel)
				iMode = EColor64K;
			else if (24 == iBitsPerPixel)
				iMode = EColor16M;
			else if (32 == iBitsPerPixel)
				iMode = EColor16M;			
			}
		}

	}

TInt CScreenDriverTemplate::ColorToPixel(TInt aColorRgb)
//
// Returns the pixel value which is closest to the given RGB value
//
	{
	TInt r = aColorRgb&0xFF;
	TInt g = (aColorRgb>>8)&0xFF;
	TInt b = (aColorRgb>>16)&0xFF;

	switch(iMode)
		{
	case EColor16M:
		return (r<<16)+(g<<8)+b;

	case EColor64K:
		return ((r>>3)<<11)+((g>>2)<<5)+(b>>3);

	case EColor4K:
		return ((r>>4)<<8)+((g>>4)<<4)+(b>>4);

	case EColor256:
		{
		TInt best = 0;
		TInt bestDif = KMaxTInt;
		for(TInt i=0; i<256; i++)
			{
			TInt value = Palette256[i];
			TInt dr = (value&0xFF)-r;
			TInt dg = ((value>>8)&0xFF)-g;
			TInt db = ((value>>16)&0xFF)-b;
			TInt dif = dr*dr + dg*dg + db*db;
			if(dif<bestDif)
				{
				bestDif = dif;
				best = i;
				}
			}
		return best;
		}

	case EGray16:
		return (r*2+g*4+b)>>7;

	case EGray4:
		return (r*2+g*4+b)>>9;

	case EMono:
		return (r*2+g*4+b)>>10;
		}

	return 0;
	}


void CScreenDriverTemplate::Blit(const TText *aBuffer, TInt aLength, const TPoint &aPosition)
//
// Write contiguous block of characters to some segment of a line on the display
//
	{
	//
	// ASSUMPTION:
	//
	// The start of each character on the display is byte aligned.
	// i.e. KPixelsPerChar*iPixelSize%8 == 0

	// Clip text to screen width
	if(aLength+aPosition.iX > iScreenWidth/KPixelsPerChar)
		aLength = iScreenWidth/KPixelsPerChar-aPosition.iX;

	TUint8* screenPtr = CharPosToScreenAddress(aPosition);
	TInt lineAddon = iScreenOffsetBetweenLines-((iPixelSize*KPixelsPerChar)>>3);
	TInt bgPixel = iBackgroundPixel;
	TInt textPixel = iTextPixel;

	while(aLength-->0)
		{
		TUint8* pixelPtr = screenPtr;
		screenPtr += (iPixelSize*KPixelsPerChar)>>3;
		TInt character = (*aBuffer++)&0xff;
		TInt y;

		switch(iPixelSize)
			{

		case 1:
			for(y=0; y<KLinesPerChar; y++)
				{
				TInt bitData = Font[character][y];
				TInt bitMask = 1<<(KPixelsPerChar-1);
				TInt pixelShift = 0;
				TInt byte = 0;
				do
					{
					if(bitData & bitMask)
						byte |= textPixel<<pixelShift;
					else
						byte |= bgPixel<<pixelShift;
					if(pixelShift<7)
						pixelShift++;
					else
						{
						*pixelPtr++ = (TUint8)byte;
						byte = 0;
						pixelShift = 0;
						}
					bitMask >>= 1;
					}
				while(bitMask);
				pixelPtr += lineAddon;
				}
			break;

		case 2:
			for(y=0; y<KLinesPerChar; y++)
				{
				TInt bitData = Font[character][y];
				TInt bitMask = 1<<(KPixelsPerChar-1);
				do
					{
					TInt byte;
					if(bitData & bitMask)
						byte = textPixel;
					else
						byte = bgPixel;
					bitMask >>= 1;

					if(bitData & bitMask)
						byte |= textPixel<<2;
					else
						byte |= bgPixel<<2;
					bitMask >>= 1;

					if(bitData & bitMask)
						byte |= textPixel<<4;
					else
						byte |= bgPixel<<4;
					bitMask >>= 1;

					if(bitData & bitMask)
						byte |= textPixel<<6;
					else
						byte |= bgPixel<<6;
					*pixelPtr++ = (TUint8)byte;
					bitMask >>= 1;
					}
				while(bitMask);
				pixelPtr += lineAddon;
				}
			break;

		case 4:
			for(y=0; y<KLinesPerChar; y++)
				{
				TInt bitData = Font[character][y];
				TInt bitMask = 1<<(KPixelsPerChar-1);
				do
					{
					TInt byte;
					if(bitData & bitMask)
						byte = textPixel;
					else
						byte = bgPixel;
					bitMask >>= 1;

					if(bitData & bitMask)
						byte |= textPixel<<4;
					else
						byte |= bgPixel<<4;
					*pixelPtr++ = (TUint8)byte;
					bitMask >>= 1;
					}
				while(bitMask);
				pixelPtr += lineAddon;
				}
			break;

		case 8:
			for(y=0; y<KLinesPerChar; y++)
				{
				TInt bitData = Font[character][y];
				TInt bitMask = 1<<(KPixelsPerChar-1);
				do
					{
					if(bitData & bitMask)
						*pixelPtr++ = (TUint8)textPixel;
					else
						*pixelPtr++ = (TUint8)bgPixel;
					bitMask >>= 1;
					}
				while(bitMask);
				pixelPtr += lineAddon;
				}
			break;

		case 16:
			for(y=0; y<KLinesPerChar; y++)
				{
				TInt bitData = Font[character][y];
				TInt bitMask = 1<<(KPixelsPerChar-1);
				do
					{
					if(bitData & bitMask)
						{
						*pixelPtr++ = (TUint8)textPixel;
						*pixelPtr++ = (TUint8)(textPixel>>8);
						}
					else
						{
						*pixelPtr++ = (TUint8)bgPixel;
						*pixelPtr++ = (TUint8)(bgPixel>>8);
						}
					bitMask >>= 1;
					}
				while(bitMask);
				pixelPtr += lineAddon;
				}
			break;

		case 24:
			for(y=0; y<KLinesPerChar; y++)
				{
				TInt bitData = Font[character][y];
				TInt bitMask = 1<<(KPixelsPerChar-1);
				do
					{
					if(bitData & bitMask)
						{
						*pixelPtr++ = (TUint8)textPixel;
						*pixelPtr++ = (TUint8)(textPixel>>8);
						*pixelPtr++ = (TUint8)(textPixel>>16);
						}
					else
						{
						*pixelPtr++ = (TUint8)bgPixel;
						*pixelPtr++ = (TUint8)(bgPixel>>8);
						*pixelPtr++ = (TUint8)(bgPixel>>16);
						}
					bitMask >>= 1;
					}
				while(bitMask);
				pixelPtr += lineAddon;
				}
			break;

		case 32:
			for(y=0; y<KLinesPerChar; y++)
				{
				TInt bitData = Font[character][y];
				TInt bitMask = 1<<(KPixelsPerChar-1);
				do
					{
					if(bitData & bitMask)
						{
						*pixelPtr++ = (TUint8)textPixel;//Blue
						*pixelPtr++ = (TUint8)(textPixel>>8);//Green
						*pixelPtr++ = (TUint8)(textPixel>>16);//Red
                        ++pixelPtr;
						}
					else
						{
						*pixelPtr++ = (TUint8)bgPixel;//Blue
						*pixelPtr++ = (TUint8)(bgPixel>>8);//Green
						*pixelPtr++ = (TUint8)(bgPixel>>16);//Red
                        ++pixelPtr;
						}
					bitMask >>= 1;
					}
				while(bitMask);
				pixelPtr += lineAddon;
				}
			break;

			}
		}
	}


TBool CScreenDriverTemplate::ScrollUp(const TRect& aRect)
//
// Scroll a rectangle of the screen up one character, don't update bottom line
//
	{
	__DEBUG_PRINT(_L("CSD::ScrollUp"));

	if (iHwAcc & KHwAccBlockCopy)
		{
		SRectOpInfo roi;
		roi.iX = KPixelsPerChar*aRect.iTl.iX;
		roi.iY = KLinesPerChar*aRect.iTl.iY;
		roi.iWidth = aRect.Width()*KPixelsPerChar;
		roi.iHeight = (aRect.Height()-1) * KLinesPerChar;
		roi.iSrcX = roi.iX;
		roi.iSrcY = roi.iY + KLinesPerChar;
		HwBlockCopy(roi);
		return ETrue;
		}
	TUint8* dstAddress = CharPosToScreenAddress(aRect.iTl);
	TUint8* srcAddress = dstAddress + iScreenOffsetBetweenLines * KLinesPerChar;
	TInt lines = (aRect.Height()-1) * KLinesPerChar;
	TInt bytesPerLine = (aRect.Width() * KPixelsPerChar * iPixelSize)>>3;

	while(lines>0)
		{
        Mem::Copy(dstAddress,srcAddress,bytesPerLine);
		srcAddress += iScreenOffsetBetweenLines;
		dstAddress += iScreenOffsetBetweenLines;
		--lines;
		}

	return ETrue;
	}


void CScreenDriverTemplate::Clear(const TRect& aRect)
//
// Clears a rectangular region with the background colour
//
	{
	__DEBUG_PRINT(_L("CSD::Clear"));

	if (iHwAcc & KHwAccBlockFill)
		{
		SRectOpInfo roi;
		roi.iX = KPixelsPerChar*aRect.iTl.iX;
		roi.iY = KLinesPerChar*aRect.iTl.iY;
		roi.iWidth = aRect.Width()*KPixelsPerChar;
		roi.iHeight = aRect.Height() * KLinesPerChar;
		roi.iSrcX = roi.iX;
		roi.iSrcY = roi.iY;
		roi.iColor = iBackgroundFill;
		HwBlockCopy(roi);
		return;
		}

	TUint8* dstAddress = CharPosToScreenAddress(aRect.iTl);
	TInt lines = aRect.Height() * KLinesPerChar;
	TInt bytesPerLine = (aRect.Width() * KPixelsPerChar * iPixelSize)>>3;

	switch(iPixelSize)
		{
	case 32:
		while(lines>0)
			{
			TUint32 fillValue = iBackgroundFill;
			TUint8* ptr = dstAddress;
			TUint8* ptrLimit = ptr+bytesPerLine;
			while(ptr<ptrLimit)
				{
				*ptr++ = (TUint8)fillValue;//Blue
				*ptr++ = (TUint8)(fillValue<<8);//Green
				*ptr++ = (TUint8)(fillValue<<16);//Red
                ++ptr;
				}
			dstAddress += iScreenOffsetBetweenLines;
			--lines;
			}
		break;

	case 24:
		while(lines>0)
			{
			TUint32 fillValue = iBackgroundFill;
			TUint8* ptr = dstAddress;
			TUint8* ptrLimit = ptr+bytesPerLine;
			while(ptr<ptrLimit)
				{
				*ptr++ = (TUint8)fillValue;
				*ptr++ = (TUint8)(fillValue<<8);
				*ptr++ = (TUint8)(fillValue<<16);
				}
			dstAddress += iScreenOffsetBetweenLines;
			--lines;
			}
		break;

	case 16:
		while(lines>0)
			{
			TUint32 fillValue = iBackgroundFill;
			TUint8* ptr = dstAddress;
			TUint8* ptrLimit = ptr+bytesPerLine;
			while(ptr<ptrLimit)
				{
				*ptr++ = (TUint8)fillValue;
				*ptr++ = (TUint8)(fillValue<<8);
				}
			dstAddress += iScreenOffsetBetweenLines;
			--lines;
			}
		break;

	default:
		while(lines>0)
			{
			Mem::Fill(dstAddress,bytesPerLine,iBackgroundFill);
			dstAddress += iScreenOffsetBetweenLines;
			--lines;
			}
		break;
		}
	}



/**
 * You don't need to implement this function.
 */
void CScreenDriverTemplate::SetPixel(const TPoint& /*aPoint*/,TUint8 /*aColour*/)
	{
	__DEBUG_PRINT(_L("CSD::SetPix"));
	}


/**
 * You don't need to implement this function.
 */
TInt CScreenDriverTemplate::GetPixel(const TPoint& /*aPoint*/)
	{
	__DEBUG_PRINT(_L("CSD::GetPix"));
	return 0;
	}


/**
 * You don't need to implement this function.
 */
void CScreenDriverTemplate::SetWord(const TPoint& /*aPoint*/,TInt /*aWord*/)
	{
	__DEBUG_PRINT(_L("CSD::SetWord"));
	}


/**
 * You don't need to implement this function.
 */
TInt CScreenDriverTemplate::GetWord(const TPoint& /*aPoint*/)
	{
	__DEBUG_PRINT(_L("CSD::GetWord"));
	return 0;
	}


// You don't need to implement the following functions

/**
 * You don't need to implement this function.
 */
void CScreenDriverTemplate::SetLine(const TPoint& /*aPoint*/,const TPixelLine& /*aPixelLine*/)
	{
	__DEBUG_PRINT(_L("CSD::SetLine"));
	}


/**
 * You don't need to implement this function.
 */
void CScreenDriverTemplate::GetLine(const TPoint& /*aPoint*/,TPixelLine& /*aPixelLine*/)
	{
	__DEBUG_PRINT(_L("CSD::GetLine"));
	}


/**
 * You don't need to implement this function.
 */
void CScreenDriverTemplate::SetPaletteEntry(TColorIndex /*anIndex*/,TUint8 /*aRed*/,TUint8 /*aGreen*/,TUint8 /*aBlue*/)
	{
	}


/**
 * You don't need to implement this function.
 */
void CScreenDriverTemplate::GetPaletteEntry(TColorIndex /*anIndex*/,TUint8& /*aRed*/,TUint8& /*aGreen*/,TUint8& /*aBlue*/)
	{
	}


/**
 * You don't need to implement this function.
 */
void CScreenDriverTemplate::SetForegroundColor(TColorIndex /*anIndex*/)
	{
	}


/**
 * You don't need to implement this function.
 */
void CScreenDriverTemplate::SetBackgroundColor(TColorIndex /*anIndex*/)
	{
	}


/**
 * You don't need to implement this function.
 */
void CScreenDriverTemplate::GetAttributeColors(TColorIndex* /*anArray*/)
	{
	}

