/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  
*
*/


#ifndef GENERALS_CONFIG_H
#define GENERALS_CONFIG_H


	// change this to reflect the ISA task amount
	#define PROFILER_ISA_OS_TASK_AMOUNT	50	

	// don't change these definitions
	#define	PROFILER_DEFINE_ISA_TASK_NAME_ARRAY 			TBuf8<64> isaTaskNames[PROFILER_ISA_OS_TASK_AMOUNT];
	#define PROFILER_DEFINE_ISA_TASK_NAME(name,number)	isaTaskNames[number].Append(_L8(name));										

	// change these to reflect the real ISA task names and numbers
	// the last number must be PROFILER_ISA_OS_TASK_AMOUNT-1

	#define PROFILER_ISA_TASK_NAMES		PROFILER_DEFINE_ISA_TASK_NAME("SRVSCKT_TASK",0)\
		PROFILER_DEFINE_ISA_TASK_NAME("CSD_SRV_TASK",1)						\
		PROFILER_DEFINE_ISA_TASK_NAME("CSD_NTB_TASK",2)						\
		PROFILER_DEFINE_ISA_TASK_NAME("CSD_WTB_TASK",3)						\
		PROFILER_DEFINE_ISA_TASK_NAME("PH_TASK",4)						\
		PROFILER_DEFINE_ISA_TASK_NAME("L2_TASK",5)						\
		PROFILER_DEFINE_ISA_TASK_NAME("RR_TASK",6)						\
		PROFILER_DEFINE_ISA_TASK_NAME("GPRS_RLC_TASK",7)						\
		PROFILER_DEFINE_ISA_TASK_NAME("GPRS_MAC_TASK",8)						\
		PROFILER_DEFINE_ISA_TASK_NAME("RANC_TASK",9)						\
		PROFILER_DEFINE_ISA_TASK_NAME("MM_TASK",10)						\
		PROFILER_DEFINE_ISA_TASK_NAME("CC_TASK",11)						\
		PROFILER_DEFINE_ISA_TASK_NAME("SMS_TASK",12)						\
		PROFILER_DEFINE_ISA_TASK_NAME("RM_CONTROL_TASK",13)						\
		PROFILER_DEFINE_ISA_TASK_NAME("GSS_SERVER_TASK",14)						\
		PROFILER_DEFINE_ISA_TASK_NAME("CS_MAIN_TASK",15)						\
		PROFILER_DEFINE_ISA_TASK_NAME("GPRS_TASK",16)						\
		PROFILER_DEFINE_ISA_TASK_NAME("WMAC_TASK",17)						\
		PROFILER_DEFINE_ISA_TASK_NAME("WMHS_TASK",18)						\
		PROFILER_DEFINE_ISA_TASK_NAME("WRRC_TASK",19)						\
		PROFILER_DEFINE_ISA_TASK_NAME("WRLC_UL_TASK",20)						\
		PROFILER_DEFINE_ISA_TASK_NAME("WRLC_DL_TASK",21)						\
		PROFILER_DEFINE_ISA_TASK_NAME("WPH_TASK",22)						\
		PROFILER_DEFINE_ISA_TASK_NAME("WRAN_TASK",23)						\
		PROFILER_DEFINE_ISA_TASK_NAME("SSOM_TASK",24)						\
		PROFILER_DEFINE_ISA_TASK_NAME("ACCESSORY_TASK",25)						\
		PROFILER_DEFINE_ISA_TASK_NAME("ADL_TASK",26)						\
		PROFILER_DEFINE_ISA_TASK_NAME("AUDIO_TASK",27)						\
		PROFILER_DEFINE_ISA_TASK_NAME("PN_TASK",28)						\
		PROFILER_DEFINE_ISA_TASK_NAME("CORE_HI_TASK",29)						\
		PROFILER_DEFINE_ISA_TASK_NAME("CORE_LO_TASK",30)						\
		PROFILER_DEFINE_ISA_TASK_NAME("ENERGY_TASK",31)						\
		PROFILER_DEFINE_ISA_TASK_NAME("FBUS_TASK",32)						\
		PROFILER_DEFINE_ISA_TASK_NAME("PMM_FILE2_TASK",33)						\
		PROFILER_DEFINE_ISA_TASK_NAME("MDI_RCV_TASK",34)						\
		PROFILER_DEFINE_ISA_TASK_NAME("MDI_SEND_TASK",35)						\
		PROFILER_DEFINE_ISA_TASK_NAME("MONITOR_TASK",36)						\
		PROFILER_DEFINE_ISA_TASK_NAME("MTC_CTRL_TASK",37)						\
		PROFILER_DEFINE_ISA_TASK_NAME("MTC_WD_TASK",38)						\
		PROFILER_DEFINE_ISA_TASK_NAME("OBEX_TASK",39)						\
		PROFILER_DEFINE_ISA_TASK_NAME("APDU_SERVER_TASK",40)						\
		PROFILER_DEFINE_ISA_TASK_NAME("SIMSON_SERVER_TASK",41)						\
		PROFILER_DEFINE_ISA_TASK_NAME("SIMLOCK_TASK",42)						\
		PROFILER_DEFINE_ISA_TASK_NAME("SOS_USB_MM_TASK",43)						\
		PROFILER_DEFINE_ISA_TASK_NAME("SOS_PROXY_AUX_TASK",44)						\
		PROFILER_DEFINE_ISA_TASK_NAME("TERMINAL_ADAPTER_TASK",45)						\
		PROFILER_DEFINE_ISA_TASK_NAME("XTI_RECEIVE_TASK",46)						\
		PROFILER_DEFINE_ISA_TASK_NAME("XTI_SEND_TASK",47)						\
		PROFILER_DEFINE_ISA_TASK_NAME("STARTUP_AND_BACKGROUND_TASK",48)						\
		PROFILER_DEFINE_ISA_TASK_NAME("OS_IDLE_TASK",49)	

	// old definitions
	#define 	PROFILER_GENERALS_SAMPLER_ID		100
	#define		PROFILER_GPP_SAMPLER_ID			1
	#define		PROFILER_GFC_SAMPLER_ID			2
	#define		PROFILER_ITT_SAMPLER_ID			3
	#define		PROFILER_MEM_SAMPLER_ID			4
	#define		PROFILER_PRI_SAMPLER_ID			5

	#define		PROFILER_GPP_SAMPLER_NAME _L("GPP")
	#define		PROFILER_GFC_SAMPLER_NAME _L("GFC")
	#define		PROFILER_ITT_SAMPLER_NAME _L("ITT")
	#define		PROFILER_MEM_SAMPLER_NAME _L("MEM")
	#define		PROFILER_PRI_SAMPLER_NAME _L("PRI")

	
#endif
