/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 51 "parse.y"

#include "sqliteInt.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 242
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 59
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  ExprList* yy44;
  int yy124;
  TriggerStep* yy137;
  SrcList* yy149;
  Expr* yy162;
  struct LikeOp yy168;
  struct LimitVal yy278;
  Select* yy313;
  struct {int value; int mask;} yy317;
  IdList* yy326;
  struct TrigEvent yy412;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 569
#define YYNRULE 301
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor;

/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   284,  871,  131,  568,  397,  172,    2,  406,   82,   82,
 /*    10 */    82,   82,  506,   70,   70,   70,   70,   79,   79,   80,
 /*    20 */    80,   80,   76,  204,  255,  301,  413,  419,   77,   70,
 /*    30 */    70,   70,   70,   79,   79,   80,   80,   80,   76,  204,
 /*    40 */   439,  437,  334,  162,   58,   87,  295,  423,  424,  420,
 /*    50 */   420,   66,   66,   82,   82,   82,   82,  175,   70,   70,
 /*    60 */    70,   70,   79,   79,   80,   80,   80,   76,  204,  284,
 /*    70 */   477,  301,  406,  558,  408,   93,  414,  415,  534,  481,
 /*    80 */    70,   70,   70,   70,   79,   79,   80,   80,   80,   76,
 /*    90 */   204,  557,  556,  209,  321,  413,  419,  417,  418,   90,
 /*   100 */   118,  266,  366,  272,  373,  160,  410,  410,  410,  340,
 /*   110 */   430,  431,  276,   58,   87,  295,  423,  424,  420,  420,
 /*   120 */    66,   66,   82,   82,   82,   82,  416,   70,   70,   70,
 /*   130 */    70,   79,   79,   80,   80,   80,   76,  204,  284,  209,
 /*   140 */   387,  388,  389,   88,  504,  197,  118,  266,  366,  272,
 /*   150 */   373,  160,  221,  553,  205,  352,  518,  492,  276,   73,
 /*   160 */   192,   60,  152,  517,  413,  419,   79,   79,   80,   80,
 /*   170 */    80,   76,  204,  205,  377,  481,  440,  402,   47,  296,
 /*   180 */   560,  284,   58,   87,  295,  423,  424,  420,  420,   66,
 /*   190 */    66,   82,   82,   82,   82,  530,   70,   70,   70,   70,
 /*   200 */    79,   79,   80,   80,   80,   76,  204,  413,  419,   86,
 /*   210 */    80,   80,   80,   76,  204,  384,  605,  354,  212,   68,
 /*   220 */    22,  166,  275,  398,  406,   58,   87,  295,  423,  424,
 /*   230 */   420,  420,   66,   66,   82,   82,   82,   82,  210,   70,
 /*   240 */    70,   70,   70,   79,   79,   80,   80,   80,   76,  204,
 /*   250 */   284,  314,    1,  603,  472,  403,  384,  444,  439,    6,
 /*   260 */   353,  380,  313,  352,  426,  426,  214,  201,  156,  445,
 /*   270 */   435,  217,  343,  169,  396,  509,  413,  419,  148,  147,
 /*   280 */   385,  386,  446,  506,  376,  402,   40,  229,  477,  406,
 /*   290 */   554,  555,  408,  284,   58,   87,  295,  423,  424,  420,
 /*   300 */   420,   66,   66,   82,   82,   82,   82,  403,   70,   70,
 /*   310 */    70,   70,   79,   79,   80,   80,   80,   76,  204,  413,
 /*   320 */   419,  385,  386,  351,  410,  410,  410,  358,  367,  371,
 /*   330 */   283,  306,  345,  437,  510,  162,  284,   58,   87,  295,
 /*   340 */   423,  424,  420,  420,   66,   66,   82,   82,   82,   82,
 /*   350 */   384,   70,   70,   70,   70,   79,   79,   80,   80,   80,
 /*   360 */    76,  204,  413,  419,  196,  229,  149,  335,  341,  364,
 /*   370 */   531,  462,   73,  243,   60,  152,  435,  217,  316,  363,
 /*   380 */    58,   87,  295,  423,  424,  420,  420,   66,   66,   82,
 /*   390 */    82,   82,   82,  462,   70,   70,   70,   70,   79,   79,
 /*   400 */    80,   80,   80,   76,  204,  421,  543,  537,   75,  284,
 /*   410 */   468,  247,  452,  245,  113,  385,  386,  196,  352,  453,
 /*   420 */   335,  341,  364,   73,  450,   60,  152,   73,   72,   60,
 /*   430 */   152,  316,  261,  504,  196,  413,  419,  335,  341,  364,
 /*   440 */   402,   33,  384,  479,  384,  536,  533,  313,  316,  426,
 /*   450 */   426,   61,  399,   58,   87,  295,  423,  424,  420,  420,
 /*   460 */    66,   66,   82,   82,   82,   82,  191,   70,   70,   70,
 /*   470 */    70,   79,   79,   80,   80,   80,   76,  204,  284,  511,
 /*   480 */   427,  511,  491,  494,  384,  805,  299,  222,  395,   21,
 /*   490 */   521,   21,  246,  352,  327,  312,  239,  238,  287,  470,
 /*   500 */   403,  151,  496,  495,  413,  419,  210,  385,  386,  385,
 /*   510 */   386,  274,  146,  520,    9,  402,   40,  406,  384,  466,
 /*   520 */   223,  184,   58,   87,  295,  423,  424,  420,  420,   66,
 /*   530 */    66,   82,   82,   82,   82,  403,   70,   70,   70,   70,
 /*   540 */    79,   79,   80,   80,   80,   76,  204,  284,  352,  385,
 /*   550 */   386,  279,  444,  384,  457,   18,  155,  358,  227,  471,
 /*   560 */   225,  319,  359,  352,  445,  352,  313,  384,  426,  426,
 /*   570 */   402,   26,  330,  413,  419,  458,  286,  446,  326,  482,
 /*   580 */   292,  276,  406,  385,  386,  402,   33,  402,   40,  483,
 /*   590 */   403,   58,   87,  295,  423,  424,  420,  420,   66,   66,
 /*   600 */    82,   82,   82,   82,    8,   70,   70,   70,   70,   79,
 /*   610 */    79,   80,   80,   80,   76,  204,  284,  558,  385,  386,
 /*   620 */   475,  158,  435,  290,  430,  431,  202,  352,  511,  348,
 /*   630 */   352,  288,  385,  386,  342,  557,  236,  565,   21,  569,
 /*   640 */   379,  361,  413,  419,  459,  313,  457,  426,  426,  402,
 /*   650 */    47,  229,  402,   37,  504,  564,  402,    3,  504,  284,
 /*   660 */    58,   87,  295,  423,  424,  420,  420,   66,   66,   82,
 /*   670 */    82,   82,   82,  352,   70,   70,   70,   70,   79,   79,
 /*   680 */    80,   80,   80,   76,  204,  413,  419,  205,  378,  289,
 /*   690 */   211,    2,  545,  302,   64,  402,   23,  372,  205,  504,
 /*   700 */   513,  182,  284,   58,   87,  295,  423,  424,  420,  420,
 /*   710 */    66,   66,   82,   82,   82,   82,  352,   70,   70,   70,
 /*   720 */    70,   79,   79,   80,   80,   80,   76,  204,  413,  419,
 /*   730 */   433,  433,  275,  229,  213,  403,  275,  462,  402,  115,
 /*   740 */   504,  527,  333,  527,  229,  284,   58,   62,  295,  423,
 /*   750 */   424,  420,  420,   66,   66,   82,   82,   82,   82,  317,
 /*   760 */    70,   70,   70,   70,   79,   79,   80,   80,   80,   76,
 /*   770 */   204,  413,  419,  163,  546,  298,  263,  275,  194,  177,
 /*   780 */   179,  278,  323,  138,  138,  547,  135,  229,  284,  347,
 /*   790 */    87,  295,  423,  424,  420,  420,   66,   66,   82,   82,
 /*   800 */    82,   82,  200,   70,   70,   70,   70,   79,   79,   80,
 /*   810 */    80,   80,   76,  204,  413,  419,  401,  529,  275,  466,
 /*   820 */   400,  528,  193,  172,  532,  406,  138,  355,  248,  138,
 /*   830 */   119,  188,  229,  331,  295,  423,  424,  420,  420,   66,
 /*   840 */    66,   82,   82,   82,   82,  352,   70,   70,   70,   70,
 /*   850 */    79,   79,   80,   80,   80,   76,  204,   84,  325,  489,
 /*   860 */     4,  466,  229,  352,  293,  403,  319,  402,   52,  352,
 /*   870 */   455,  352,  324,  307,  229,  352,  541,   19,   63,  141,
 /*   880 */   300,   84,  325,  352,    4,  402,   35,  352,  293,  303,
 /*   890 */   406,  402,   29,  402,   39,  352,  324,  402,   38,  439,
 /*   900 */   268,   69,  352,  250,  352,  402,   97,  187,  153,  402,
 /*   910 */    34,  269,  352,  303,  224,  231,  352,  402,   45,   57,
 /*   920 */    92,  469,  332,  439,  402,   31,  402,   96,   85,  315,
 /*   930 */   318,  208,  269,  408,  402,   51,  352,  244,  402,   25,
 /*   940 */   352,  403,  403,   57,   92,  304,   65,  464,   81,  167,
 /*   950 */   320,  173,   85,  315,  318,  184,  497,  408,  402,   44,
 /*   960 */   352,  145,  402,  101,  210,  410,  410,  410,  411,  412,
 /*   970 */    12,   84,  325,  207,    4,  210,  498,  305,  293,  111,
 /*   980 */    55,  107,  402,   32,  352,  403,  324,  176,  156,  410,
 /*   990 */   410,  410,  411,  412,   12,  550,  352,   63,  352,  501,
 /*  1000 */   352,  138,  352,  303,  352,  549,  402,   49,  456,  168,
 /*  1010 */   286,   76,  204,  439,  258,  265,  220,  109,  402,   16,
 /*  1020 */   402,   42,  402,   36,  402,  114,  402,   99,  294,  407,
 /*  1030 */   189,  505,  252,   57,   92,  428,  352,   20,  432,  253,
 /*  1040 */   352,  503,   85,  315,  318,  352,  539,  408,  486,  487,
 /*  1050 */   352,  161,  352,  536,  352,  379,  361,  165,  402,   24,
 /*  1060 */   186,  401,  402,  102,  352,  400,  352,  402,  112,  352,
 /*  1070 */   230,  352,  402,   98,  402,   46,  402,   53,  352,  410,
 /*  1080 */   410,  410,  411,  412,   12,  352,  402,  117,  402,   41,
 /*  1090 */   507,  402,   54,  402,   10,  540,  339,  167,  393,  144,
 /*  1100 */   402,   28,  451,  308,  249,  238,  352,  402,   50,  285,
 /*  1110 */   352,  454,  270,  352,  210,  310,  434,  352,  502,  352,
 /*  1120 */   492,  159,  392,  210,  404,    7,  369,  309,  402,   43,
 /*  1130 */   171,  198,  402,  116,  522,  402,   48,  174,  370,  402,
 /*  1140 */    30,  402,   27,  362,  170,   69,  199,  524,  338,  232,
 /*  1150 */   233,   91,  349,  525,   67,  357,  234,  164,  120,  329,
 /*  1160 */   235,  535,  241,  123,  140,  190,   56,  405,  542,  311,
 /*  1170 */   124,  126,   78,  215,  127,  128,  133,  297,  561,  548,
 /*  1180 */   562,  122,   89,  563,   83,  566,  390,   71,  105,  449,
 /*  1190 */   382,  344,  356,  262,  264,  125,  391,  480,  106,  291,
 /*  1200 */   206,  463,  467,  281,  484,  489,  485,  271,  216,  508,
 /*  1210 */    95,  488,  195,  143,  256,  100,  490,  360,  447,  567,
 /*  1220 */   514,  280,  515,  516,  218,  203,  538,   74,  219,  142,
 /*  1230 */   103,   17,  121,  185,    5,   14,  381,  178,  139,  180,
 /*  1240 */    13,  474,  460,  473,  204,  519,  282,  442,  478,  476,
 /*  1250 */   512,  183,  350,  443,  257,   94,  375,  559,  422,  108,
 /*  1260 */   368,  260,  129,  523,  365,  346,  157,  383,  273,  132,
 /*  1270 */   154,  251,  551,  436,  150,  104,  328,  237,  552,   15,
 /*  1280 */   465,  429,  277,  136,  259,  134,  337,  130,  228,  448,
 /*  1290 */   461,  526,  394,  226,  110,  240,  441,  336,  544,  438,
 /*  1300 */   499,  181,  409,   59,  500,  242,  425,   11,  137,  604,
 /*  1310 */   374,  167,  493,  322,  267,  254,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  139,  140,  141,  168,   21,  144,   23,   69,   70,
 /*    10 */    71,   72,  176,   74,   75,   76,   77,   78,   79,   80,
 /*    20 */    81,   82,   83,   84,  147,   16,   42,   43,   73,   74,
 /*    30 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    40 */    58,  161,  162,  163,   60,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,  122,   74,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */    88,   16,   88,  147,   92,   22,   42,   43,  185,  186,
 /*    80 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    90 */    84,  165,  166,   84,  147,   42,   43,   63,   64,   46,
 /*   100 */    91,   92,   93,   94,   95,   96,  124,  125,  126,  164,
 /*   110 */   165,  166,  103,   60,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,   92,   74,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   16,   84,
 /*   140 */     7,    8,    9,   21,  147,   90,   91,   92,   93,   94,
 /*   150 */    95,   96,  190,  227,  228,  147,  176,  177,  103,  217,
 /*   160 */    19,  219,  220,  183,   42,   43,   78,   79,   80,   81,
 /*   170 */    82,   83,   84,  228,  185,  186,   20,  169,  170,  182,
 /*   180 */   238,   16,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   190 */    68,   69,   70,   71,   72,   45,   74,   75,   76,   77,
 /*   200 */    78,   79,   80,   81,   82,   83,   84,   42,   43,   44,
 /*   210 */    80,   81,   82,   83,   84,   23,  112,  209,  210,   19,
 /*   220 */    19,  155,  225,   23,   23,   60,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,  110,   74,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    16,  123,   19,  112,   20,  189,   23,   12,   58,  191,
 /*   260 */   142,  143,  106,  147,  108,  109,  148,  201,  202,   24,
 /*   270 */    78,   79,  206,  155,  167,  168,   42,   43,   78,   79,
 /*   280 */    88,   89,   37,  176,   39,  169,  170,  147,   88,   88,
 /*   290 */    98,   99,   92,   16,   60,   61,   62,   63,   64,   65,
 /*   300 */    66,   67,   68,   69,   70,   71,   72,  189,   74,   75,
 /*   310 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   42,
 /*   320 */    43,   88,   89,  233,  124,  125,  126,  211,  188,   16,
 /*   330 */   158,  213,  216,  161,  162,  163,   16,   60,   61,   62,
 /*   340 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   350 */    23,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   360 */    83,   84,   42,   43,   90,  147,   22,   93,   94,   95,
 /*   370 */    18,  161,  217,   14,  219,  220,   78,   79,  104,  239,
 /*   380 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   390 */    70,   71,   72,  161,   74,   75,   76,   77,   78,   79,
 /*   400 */    80,   81,   82,   83,   84,   92,  188,   11,  131,   16,
 /*   410 */   200,   52,   27,   54,   21,   88,   89,   90,  147,   34,
 /*   420 */    93,   94,   95,  217,  218,  219,  220,  217,   68,  219,
 /*   430 */   220,  104,  200,  147,   90,   42,   43,   93,   94,   95,
 /*   440 */   169,  170,   23,  160,   23,   49,   94,  106,  104,  108,
 /*   450 */   109,  131,  169,   60,   61,   62,   63,   64,   65,   66,
 /*   460 */    67,   68,   69,   70,   71,   72,  155,   74,   75,   76,
 /*   470 */    77,   78,   79,   80,   81,   82,   83,   84,   16,  147,
 /*   480 */    20,  147,   20,  178,   23,  133,  215,  153,  156,  157,
 /*   490 */   156,  157,  133,  147,   16,   99,  100,  101,  150,   80,
 /*   500 */   189,  155,   91,   92,   42,   43,  110,   88,   89,   88,
 /*   510 */    89,  225,  180,  181,   19,  169,  170,   23,   23,  147,
 /*   520 */    14,   43,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   530 */    68,   69,   70,   71,   72,  189,   74,   75,   76,   77,
 /*   540 */    78,   79,   80,   81,   82,   83,   84,   16,  147,   88,
 /*   550 */    89,   20,   12,   23,   22,   19,  155,  211,   52,   20,
 /*   560 */    54,  147,  216,  147,   24,  147,  106,   23,  108,  109,
 /*   570 */   169,  170,  224,   42,   43,  114,   98,   37,  230,   39,
 /*   580 */   208,  103,   88,   88,   89,  169,  170,  169,  170,   49,
 /*   590 */   189,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   600 */    69,   70,   71,   72,   68,   74,   75,   76,   77,   78,
 /*   610 */    79,   80,   81,   82,   83,   84,   16,  147,   88,   89,
 /*   620 */    20,   89,   78,  164,  165,  166,  212,  147,  147,  211,
 /*   630 */   147,  215,   88,   89,  147,  165,  133,  156,  157,    0,
 /*   640 */     1,    2,   42,   43,  114,  106,  114,  108,  109,  169,
 /*   650 */   170,  147,  169,  170,  147,  147,  169,  170,  147,   16,
 /*   660 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   670 */    70,   71,   72,  147,   74,   75,   76,   77,   78,   79,
 /*   680 */    80,   81,   82,   83,   84,   42,   43,  228,  141,  182,
 /*   690 */   210,  144,  188,  182,   68,  169,  170,  227,  228,  147,
 /*   700 */   147,  155,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   710 */    67,   68,   69,   70,   71,   72,  147,   74,   75,   76,
 /*   720 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   730 */   124,  125,  225,  147,  182,  189,  225,  161,  169,  170,
 /*   740 */   147,   99,  100,  101,  147,   16,   60,   61,   62,   63,
 /*   750 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  213,
 /*   760 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   770 */    84,   42,   43,   98,  188,  182,  200,  225,   99,  100,
 /*   780 */   101,   20,  236,   22,   22,  188,  102,  147,   16,   80,
 /*   790 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   800 */    71,   72,   22,   74,   75,   76,   77,   78,   79,   80,
 /*   810 */    81,   82,   83,   84,   42,   43,  107,   25,  225,  147,
 /*   820 */   111,   29,  232,   21,   20,   23,   22,   20,  188,   22,
 /*   830 */   147,  155,  147,   41,   62,   63,   64,   65,   66,   67,
 /*   840 */    68,   69,   70,   71,   72,  147,   74,   75,   76,   77,
 /*   850 */    78,   79,   80,   81,   82,   83,   84,   16,   17,   97,
 /*   860 */    19,  147,  147,  147,   23,  189,  147,  169,  170,  147,
 /*   870 */    22,  147,   31,  188,  147,  147,   20,   19,   22,   21,
 /*   880 */   208,   16,   17,  147,   19,  169,  170,  147,   23,   48,
 /*   890 */    88,  169,  170,  169,  170,  147,   31,  169,  170,   58,
 /*   900 */    92,  121,  147,  188,  147,  169,  170,  155,  155,  169,
 /*   910 */   170,  103,  147,   48,  147,  188,  147,  169,  170,   78,
 /*   920 */    79,   80,  208,   58,  169,  170,  169,  170,   87,   88,
 /*   930 */    89,  212,  103,   92,  169,  170,  147,  221,  169,  170,
 /*   940 */   147,  189,  189,   78,   79,   91,  130,   20,  132,   22,
 /*   950 */   147,  155,   87,   88,   89,   43,   30,   92,  169,  170,
 /*   960 */   147,  113,  169,  170,  110,  124,  125,  126,  127,  128,
 /*   970 */   129,   16,   17,  192,   19,  110,   50,  123,   23,   19,
 /*   980 */   199,   19,  169,  170,  147,  189,   31,  201,  202,  124,
 /*   990 */   125,  126,  127,  128,  129,   20,  147,   22,  147,   20,
 /*  1000 */   147,   22,  147,   48,  147,  194,  169,  170,  203,    5,
 /*  1010 */    98,   83,   84,   58,   10,   11,   12,   13,  169,  170,
 /*  1020 */   169,  170,  169,  170,  169,  170,  169,  170,  102,  161,
 /*  1030 */    26,  172,   28,   78,   79,   20,  147,   22,  229,   35,
 /*  1040 */   147,  161,   87,   88,   89,  147,  194,   92,    7,    8,
 /*  1050 */   147,   47,  147,   49,  147,    1,    2,   53,  169,  170,
 /*  1060 */    56,  107,  169,  170,  147,  111,  147,  169,  170,  147,
 /*  1070 */   193,  147,  169,  170,  169,  170,  169,  170,  147,  124,
 /*  1080 */   125,  126,  127,  128,  129,  147,  169,  170,  169,  170,
 /*  1090 */   161,  169,  170,  169,  170,   20,  173,   22,  149,  191,
 /*  1100 */   169,  170,  172,   99,  100,  101,  147,  169,  170,  105,
 /*  1110 */   147,  172,  172,  147,  110,  223,  229,  147,  172,  147,
 /*  1120 */   177,    6,  146,  110,  189,   22,   15,  154,  169,  170,
 /*  1130 */   112,  151,  169,  170,  152,  169,  170,  151,  134,  169,
 /*  1140 */   170,  169,  170,  152,  151,  121,  152,  152,   38,  234,
 /*  1150 */   194,  130,  118,  235,  119,  116,  195,  151,   60,  152,
 /*  1160 */   196,  184,  197,   19,  214,  184,  120,  198,  194,   15,
 /*  1170 */   187,  187,  130,  222,  187,  187,  184,  152,   33,  194,
 /*  1180 */   152,  214,  237,  152,  237,  137,  146,   98,  240,  152,
 /*  1190 */   146,  115,   98,  204,  204,  152,  146,  171,   19,   40,
 /*  1200 */    84,  205,  205,  174,  171,   97,  179,  171,   44,  179,
 /*  1210 */    19,  173,  135,   21,  136,  159,  171,    3,   20,    4,
 /*  1220 */   171,  174,  171,  171,  226,  226,    1,   22,  175,   19,
 /*  1230 */   175,  231,   32,   96,  117,   22,    1,  112,   98,  112,
 /*  1240 */   117,   20,  114,   20,   84,  181,    5,   20,  169,  169,
 /*  1250 */   181,   22,  147,   20,  147,   19,  186,   20,   92,   14,
 /*  1260 */    16,  147,   19,   17,   57,  147,  147,  147,  147,   20,
 /*  1270 */    19,  147,  123,  161,  112,   19,  147,  147,  147,   19,
 /*  1280 */   147,   20,   20,  122,  145,  102,   36,  113,  147,  147,
 /*  1290 */   147,   51,   20,  147,   19,  147,   11,   44,   17,   20,
 /*  1300 */   178,  113,  147,   19,  178,  147,  107,   19,   45,  112,
 /*  1310 */   147,   22,  147,   44,  147,  147,
};
#define YY_SHIFT_USE_DFLT (-66)
#define YY_SHIFT_MAX 376
static const short yy_shift_ofst[] = {
 /*     0 */  1054,  865, 1004,  -16,  865,  955,  955,  327,  192, 1013,
 /*    10 */   165,  955,  955,  955,  955,  955,  -45,  396,  544,  421,
 /*    20 */   298,  494,  298,   53,  277,  600,  234,  531,  122,  393,
 /*    30 */   462,  320,  643,  643,  643,  643,  643,  643,  643,  686,
 /*    40 */   643,  643,  643,  643,  643,  643,  643,  643,  643,  643,
 /*    50 */   643,  643,  729,  772,  772,  841,  955,  955,  955,  955,
 /*    60 */   955,  955,  955,  955,  955,  955,  955,  955,  955,  955,
 /*    70 */   955,  955,  955,  955,  955,  955,  955,  955,  955,  955,
 /*    80 */   955,  955,  955,  955,  955,  955,  955,  955,  955,  955,
 /*    90 */   955,  955,  955,  955,  955,  955,  -61,  -61,    6,    6,
 /*   100 */    55,   88,  130,  478,  421,  421,  421,  421,  421,  352,
 /*   110 */   421,  421,  928,  494, 1160,  -66,  -66,  -66,  200,    9,
 /*   120 */   540,  540,  854,  421,  421,  802,  421,  421,  421,  421,
 /*   130 */   421,  639,  802,  421,  421,  421,  421,  421,  421,  421,
 /*   140 */   128, 1013, 1013, 1013,  -66,  -66,  344,  -18,  -18,  274,
 /*   150 */   419,  460,  233,  156,  245,  539,  495,  530,  461,  421,
 /*   160 */   421,  421,  201,  421,  421,  421,  341,  421,  133,  341,
 /*   170 */   421,  421,  421,  341,  421,  421,  532,  926,  421,  926,
 /*   180 */   421,  421,  341,  421,  421,  421,  421,  341,  341,  421,
 /*   190 */   421,  341,  709,  642,  926,  421,  421,  421,  421,  792,
 /*   200 */   421,  532,  780,  385,  494,  606,  494,  848,  780,  494,
 /*   210 */   954,  385,  385,  762,  858,  816,  385,  606,  385,  912,
 /*   220 */  1115, 1013, 1103, 1111, 1018, 1111, 1018, 1111, 1018, 1018,
 /*   230 */  1024, 1110, 1021, 1034, 1035, 1039, 1111, 1018, 1098, 1098,
 /*   240 */  1144, 1046, 1024, 1154, 1042, 1154, 1154, 1154, 1024, 1098,
 /*   250 */  1144, 1018, 1145, 1145, 1018, 1018, 1048, 1018, 1115, 1115,
 /*   260 */  1018, 1089, 1076, 1089, 1076, 1115, 1094, 1179, 1094, 1159,
 /*   270 */  1094, 1108, 1094, 1179, 1116, 1116, 1159, 1094, 1094, 1094,
 /*   280 */   -66,  -66,  -66,  -66,   34,  359,  679,  506,  975,  979,
 /*   290 */  1015, 1041, 1075,  141,  411,  313,  761,  536,  807,  856,
 /*   300 */   927,  808,  804, 1251, 1149, 1260, 1161, 1183, 1174, 1272,
 /*   310 */  1285, 1281, 1188, 1199, 1288, 1197, 1269,  -65,  104,  360,
 /*   320 */   626,  684,  960, 1225, 1284, 1210, 1241,  829,  962,  675,
 /*   330 */   503,  150, 1289, 1263, 1279, 1253, 1275, 1240, 1250, 1262,
 /*   340 */  1261, 1256, 1162, 1249, 1243, 1223, 1128, 1221, 1205, 1123,
 /*   350 */  1127, 1140, 1125, 1235, 1213, 1137, 1200, 1117, 1205, 1198,
 /*   360 */  1215, 1214, 1192, 1078, 1191, 1077, 1164, 1207, 1246, 1244,
 /*   370 */  1245, 1166, 1237, 1236, 1233, 1229, 1227,
};
#define YY_REDUCE_USE_DFLT (-165)
#define YY_REDUCE_MAX 283
static const short yy_reduce_ofst[] = {
 /*     0 */  -138,  346,  118,  210,  401,    8,  116,  332,  -74,   66,
 /*    10 */   -58,  271,  716,  418,  480,  416,  206,  546,  470,  334,
 /*    20 */   -55,  172,  459,  155,  155,  155,  155,  155,  155,  155,
 /*    30 */   155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
 /*    40 */   155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
 /*    50 */   155,  155,  155,  155,  155,  487,  526,  569,  698,  722,
 /*    60 */   724,  728,  736,  740,  748,  755,  757,  765,  769,  789,
 /*    70 */   793,  813,  837,  849,  851,  853,  855,  857,  889,  893,
 /*    80 */   898,  483,  903,  905,  907,  917,  919,  922,  924,  931,
 /*    90 */   938,  959,  963,  966,  970,  972,  155,  155,  155,  155,
 /*   100 */   107,  155,  155,  -20,   -3,  481,  507,  511,  140,  348,
 /*   110 */   552,  593,  155, -120,  155,  155,  155,  155,  283, -164,
 /*   120 */  -107,  -11,  311,  372,  218,  232,  504,  586,  597,  672,
 /*   130 */   640,  547,  576,  685,  414,  719,  715,  714,  286,  727,
 /*   140 */   676,  752,  753,  796,  781,  786, 1064, 1079, 1080, 1069,
 /*   150 */  1105,  -38, 1107,  -38, 1070,  -38, 1114, 1118, 1119, 1120,
 /*   160 */  1121, 1124, 1112, 1129, 1130, 1131,  -38, 1133, 1139,  -38,
 /*   170 */  1141, 1142, 1143,  -38, 1146, 1148,  805, 1122, 1105, 1126,
 /*   180 */  1155, 1158,  -38, 1163, 1165, 1167, 1168,  -38,  -38, -123,
 /*   190 */   -53,  -38,   68,   90,  305,  508,  553,  683,  767,  590,
 /*   200 */   803,  805,  811,  859,  868,  809,  880,  877,  852,  929,
 /*   210 */   908,  930,  939,  923,  949,  892,  940,  887,  946,  943,
 /*   220 */   976,  935,  973,  980,  982,  986,  991,  993,  994,  995,
 /*   230 */   956,  915,  918,  961,  964,  965, 1006, 1007,  977,  981,
 /*   240 */   950,  969,  974,  983,  951,  984,  987,  988,  985,  992,
 /*   250 */   967, 1025,  945,  947, 1028, 1031,  948, 1037, 1040, 1044,
 /*   260 */  1043,  989,  996,  990,  997, 1050, 1026, 1029, 1033, 1027,
 /*   270 */  1036, 1038, 1045, 1047,  998,  999, 1030, 1049, 1051, 1052,
 /*   280 */  1053, 1055, 1000, 1056,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   575,  800,  870,  690,  870,  870,  800,  870,  828,  694,
 /*    10 */   857,  870,  798,  870,  870,  870,  772,  870,  828,  870,
 /*    20 */   828,  606,  828,  723,  870,  870,  870,  870,  870,  870,
 /*    30 */   870,  870,  706,  738,  737,  797,  794,  795,  793,  870,
 /*    40 */   802,  858,  801,  841,  728,  730,  856,  714,  725,  731,
 /*    50 */   724,  721,  760,  778,  759,  870,  870,  870,  870,  870,
 /*    60 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*    70 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*    80 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*    90 */   870,  870,  870,  870,  870,  870,  762,  784,  761,  771,
 /*   100 */   599,  763,  764,  659,  870,  870,  870,  870,  870,  594,
 /*   110 */   870,  870,  765,  870,  766,  781,  780,  779,  870,  870,
 /*   120 */   870,  870,  870,  870,  870,  690,  870,  870,  870,  870,
 /*   130 */   870,  575,  690,  870,  870,  870,  870,  870,  870,  870,
 /*   140 */   870,  870,  870,  870,  684,  694,  650,  870,  870,  870,
 /*   150 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  580,
 /*   160 */   870,  870,  608,  870,  870,  814,  697,  870,  582,  673,
 /*   170 */   870,  870,  870,  671,  870,  870,  692,  870,  870,  870,
 /*   180 */   870,  870,  848,  870,  870,  870,  861,  596,  846,  863,
 /*   190 */   870,  733,  682,  870,  870,  870,  870,  870,  870,  834,
 /*   200 */   870,  698,  727,  717,  870,  870,  870,  691,  727,  870,
 /*   210 */   682,  717,  717,  632,  870,  796,  717,  870,  717,  629,
 /*   220 */   579,  870,  649,  591,  699,  591,  699,  591,  699,  699,
 /*   230 */   727,  838,  840,  718,  720,  710,  591,  699,  663,  663,
 /*   240 */   739,  722,  727,  670,  870,  670,  670,  670,  727,  663,
 /*   250 */   739,  699,  860,  860,  699,  699,  868,  699,  579,  579,
 /*   260 */   699,  707,  709,  707,  709,  579,  661,  806,  661,  646,
 /*   270 */   661,  632,  661,  806,  811,  811,  646,  661,  661,  661,
 /*   280 */   634,  634,  843,  616,  870,  870,  870,  870,  870,  870,
 /*   290 */   870,  870,  870,  746,  870,  870,  870,  821,  870,  870,
 /*   300 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*   310 */   870,  870,  870,  676,  870,  751,  870,  870,  747,  870,
 /*   320 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*   330 */   870,  870,  837,  836,  870,  870,  870,  870,  870,  870,
 /*   340 */   870,  870,  870,  870,  870,  870,  870,  870,  719,  870,
 /*   350 */   748,  870,  870,  870,  711,  870,  870,  870,  799,  870,
 /*   360 */   870,  576,  870,  870,  870,  870,  870,  867,  870,  870,
 /*   370 */   870,  870,  870,  870,  870,  870,  870,  662,  570,  573,
 /*   380 */   572,  574,  578,  581,  603,  604,  605,  583,  584,  585,
 /*   390 */   586,  587,  588,  589,  595,  597,  615,  617,  601,  619,
 /*   400 */   680,  681,  743,  674,  675,  679,  602,  754,  745,  749,
 /*   410 */   750,  752,  753,  767,  768,  770,  776,  783,  786,  769,
 /*   420 */   774,  775,  777,  782,  785,  677,  678,  789,  609,  610,
 /*   430 */   613,  614,  824,  826,  825,  827,  612,  611,  755,  758,
 /*   440 */   791,  792,  849,  850,  851,  852,  853,  787,  700,  790,
 /*   450 */   773,  712,  715,  716,  713,  683,  693,  702,  703,  704,
 /*   460 */   705,  688,  689,  695,  708,  741,  742,  696,  685,  686,
 /*   470 */   687,  788,  744,  756,  757,  620,  621,  751,  622,  623,
 /*   480 */   624,  665,  666,  667,  625,  644,  647,  648,  626,  633,
 /*   490 */   627,  628,  635,  636,  637,  640,  641,  642,  643,  638,
 /*   500 */   639,  807,  808,  812,  810,  809,  630,  631,  645,  618,
 /*   510 */   607,  600,  651,  654,  655,  656,  657,  658,  660,  652,
 /*   520 */   653,  598,  590,  592,  701,  830,  839,  835,  831,  832,
 /*   530 */   833,  593,  803,  804,  664,  735,  736,  829,  842,  844,
 /*   540 */   740,  845,  847,  668,  669,  672,  813,  854,  726,  729,
 /*   550 */   732,  734,  815,  816,  817,  818,  819,  822,  823,  820,
 /*   560 */   855,  859,  862,  864,  865,  866,  869,  577,  571,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "TRIGGER",       "VACUUM",        "VIEW",          "VIRTUAL",     
  "REINDEX",       "RENAME",        "CTIME_KW",      "ANY",         
  "OR",            "AND",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "AUTOINCR",      "ON",            "DELETE",      
  "UPDATE",        "INSERT",        "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "SELECT",        "DISTINCT",    
  "DOT",           "FROM",          "JOIN",          "USING",       
  "ORDER",         "BY",            "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "INTO",          "VALUES",      
  "INTEGER",       "FLOAT",         "BLOB",          "REGISTER",    
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "ALTER",         "TO",          
  "ADD",           "COLUMNKW",      "error",         "input",       
  "cmdlist",       "ecmd",          "cmdx",          "cmd",         
  "explain",       "transtype",     "trans_opt",     "nm",          
  "create_table",  "create_table_args",  "temp",          "ifnotexists", 
  "dbnm",          "columnlist",    "conslist_opt",  "select",      
  "column",        "columnid",      "type",          "carglist",    
  "id",            "ids",           "typetoken",     "typename",    
  "signed",        "plus_num",      "minus_num",     "carg",        
  "ccons",         "term",          "expr",          "onconf",      
  "sortorder",     "autoinc",       "idxlist_opt",   "refargs",     
  "defer_subclause",  "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tcons",         "idxlist",       "defer_subclause_opt",
  "orconf",        "resolvetype",   "raisetype",     "ifexists",    
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "on_opt",        "using_opt",     "seltablist_paren",  "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "nexprlist",   
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "exprlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "uniqueflag",    "idxitem",       "collate",       "nmnum",       
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "ccons ::= DEFAULT term",
 /*  51 */ "ccons ::= DEFAULT LP expr RP",
 /*  52 */ "ccons ::= DEFAULT PLUS term",
 /*  53 */ "ccons ::= DEFAULT MINUS term",
 /*  54 */ "ccons ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE ids",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 144 */ "sortlist ::= sortitem sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "groupby_opt ::=",
 /* 150 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 151 */ "having_opt ::=",
 /* 152 */ "having_opt ::= HAVING expr",
 /* 153 */ "limit_opt ::=",
 /* 154 */ "limit_opt ::= LIMIT expr",
 /* 155 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 156 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 157 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 158 */ "where_opt ::=",
 /* 159 */ "where_opt ::= WHERE expr",
 /* 160 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 161 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 162 */ "setlist ::= nm EQ expr",
 /* 163 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 164 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 166 */ "insert_cmd ::= INSERT orconf",
 /* 167 */ "insert_cmd ::= REPLACE",
 /* 168 */ "itemlist ::= itemlist COMMA expr",
 /* 169 */ "itemlist ::= expr",
 /* 170 */ "inscollist_opt ::=",
 /* 171 */ "inscollist_opt ::= LP inscollist RP",
 /* 172 */ "inscollist ::= inscollist COMMA nm",
 /* 173 */ "inscollist ::= nm",
 /* 174 */ "expr ::= term",
 /* 175 */ "expr ::= LP expr RP",
 /* 176 */ "term ::= NULL",
 /* 177 */ "expr ::= ID",
 /* 178 */ "expr ::= JOIN_KW",
 /* 179 */ "expr ::= nm DOT nm",
 /* 180 */ "expr ::= nm DOT nm DOT nm",
 /* 181 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 182 */ "term ::= STRING",
 /* 183 */ "expr ::= REGISTER",
 /* 184 */ "expr ::= VARIABLE",
 /* 185 */ "expr ::= expr COLLATE ids",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "likeop ::= MATCH",
 /* 201 */ "likeop ::= NOT MATCH",
 /* 202 */ "escape ::= ESCAPE expr",
 /* 203 */ "escape ::=",
 /* 204 */ "expr ::= expr likeop expr escape",
 /* 205 */ "expr ::= expr ISNULL|NOTNULL",
 /* 206 */ "expr ::= expr IS NULL",
 /* 207 */ "expr ::= expr NOT NULL",
 /* 208 */ "expr ::= expr IS NOT NULL",
 /* 209 */ "expr ::= NOT expr",
 /* 210 */ "expr ::= BITNOT expr",
 /* 211 */ "expr ::= MINUS expr",
 /* 212 */ "expr ::= PLUS expr",
 /* 213 */ "between_op ::= BETWEEN",
 /* 214 */ "between_op ::= NOT BETWEEN",
 /* 215 */ "expr ::= expr between_op expr AND expr",
 /* 216 */ "in_op ::= IN",
 /* 217 */ "in_op ::= NOT IN",
 /* 218 */ "expr ::= expr in_op LP exprlist RP",
 /* 219 */ "expr ::= LP select RP",
 /* 220 */ "expr ::= expr in_op LP select RP",
 /* 221 */ "expr ::= expr in_op nm dbnm",
 /* 222 */ "expr ::= EXISTS LP select RP",
 /* 223 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 224 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 225 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 226 */ "case_else ::= ELSE expr",
 /* 227 */ "case_else ::=",
 /* 228 */ "case_operand ::= expr",
 /* 229 */ "case_operand ::=",
 /* 230 */ "exprlist ::= nexprlist",
 /* 231 */ "exprlist ::=",
 /* 232 */ "nexprlist ::= nexprlist COMMA expr",
 /* 233 */ "nexprlist ::= expr",
 /* 234 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 235 */ "uniqueflag ::= UNIQUE",
 /* 236 */ "uniqueflag ::=",
 /* 237 */ "idxlist_opt ::=",
 /* 238 */ "idxlist_opt ::= LP idxlist RP",
 /* 239 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 240 */ "idxlist ::= idxitem collate sortorder",
 /* 241 */ "idxitem ::= nm",
 /* 242 */ "collate ::=",
 /* 243 */ "collate ::= COLLATE ids",
 /* 244 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 245 */ "cmd ::= VACUUM",
 /* 246 */ "cmd ::= VACUUM nm",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 249 */ "cmd ::= PRAGMA nm dbnm EQ DELETE",
 /* 250 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 251 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 252 */ "cmd ::= PRAGMA nm dbnm",
 /* 253 */ "nmnum ::= plus_num",
 /* 254 */ "nmnum ::= nm",
 /* 255 */ "plus_num ::= plus_opt number",
 /* 256 */ "minus_num ::= MINUS number",
 /* 257 */ "number ::= INTEGER|FLOAT",
 /* 258 */ "plus_opt ::= PLUS",
 /* 259 */ "plus_opt ::=",
 /* 260 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 261 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 262 */ "trigger_time ::= BEFORE",
 /* 263 */ "trigger_time ::= AFTER",
 /* 264 */ "trigger_time ::= INSTEAD OF",
 /* 265 */ "trigger_time ::=",
 /* 266 */ "trigger_event ::= DELETE|INSERT",
 /* 267 */ "trigger_event ::= UPDATE",
 /* 268 */ "trigger_event ::= UPDATE OF inscollist",
 /* 269 */ "foreach_clause ::=",
 /* 270 */ "foreach_clause ::= FOR EACH ROW",
 /* 271 */ "when_clause ::=",
 /* 272 */ "when_clause ::= WHEN expr",
 /* 273 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 274 */ "trigger_cmd_list ::=",
 /* 275 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 276 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 277 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 278 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 279 */ "trigger_cmd ::= select",
 /* 280 */ "expr ::= RAISE LP IGNORE RP",
 /* 281 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 282 */ "raisetype ::= ROLLBACK",
 /* 283 */ "raisetype ::= ABORT",
 /* 284 */ "raisetype ::= FAIL",
 /* 285 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 286 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 287 */ "cmd ::= DETACH database_kw_opt expr",
 /* 288 */ "key_opt ::=",
 /* 289 */ "key_opt ::= KEY expr",
 /* 290 */ "database_kw_opt ::= DATABASE",
 /* 291 */ "database_kw_opt ::=",
 /* 292 */ "cmd ::= REINDEX",
 /* 293 */ "cmd ::= REINDEX nm dbnm",
 /* 294 */ "cmd ::= ANALYZE",
 /* 295 */ "cmd ::= ANALYZE nm dbnm",
 /* 296 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 297 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 298 */ "add_column_fullname ::= fullname",
 /* 299 */ "kwcolumn_opt ::=",
 /* 300 */ "kwcolumn_opt ::= COLUMNKW",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3ParserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 155: /* select */
    case 189: /* oneselect */
    case 206: /* seltablist_paren */
{
#line 369 "parse.y"
sqlite3SelectDelete(pParse->db, (yypminor->yy313));
#line 1266 "parse.c"
}
      break;
    case 169: /* term */
    case 170: /* expr */
    case 194: /* where_opt */
    case 196: /* having_opt */
    case 204: /* on_opt */
    case 210: /* sortitem */
    case 218: /* escape */
    case 221: /* case_operand */
    case 223: /* case_else */
    case 235: /* when_clause */
    case 238: /* key_opt */
{
#line 629 "parse.y"
sqlite3ExprDelete(pParse->db, (yypminor->yy162));
#line 1283 "parse.c"
}
      break;
    case 174: /* idxlist_opt */
    case 182: /* idxlist */
    case 192: /* selcollist */
    case 195: /* groupby_opt */
    case 197: /* orderby_opt */
    case 199: /* sclp */
    case 209: /* sortlist */
    case 211: /* nexprlist */
    case 212: /* setlist */
    case 215: /* itemlist */
    case 216: /* exprlist */
    case 222: /* case_exprlist */
{
#line 887 "parse.y"
sqlite3ExprListDelete(pParse->db, (yypminor->yy44));
#line 1301 "parse.c"
}
      break;
    case 188: /* fullname */
    case 193: /* from */
    case 201: /* seltablist */
    case 202: /* stl_prefix */
{
#line 486 "parse.y"
sqlite3SrcListDelete(pParse->db, (yypminor->yy149));
#line 1311 "parse.c"
}
      break;
    case 205: /* using_opt */
    case 208: /* inscollist */
    case 214: /* inscollist_opt */
{
#line 503 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy326));
#line 1320 "parse.c"
}
      break;
    case 231: /* trigger_cmd_list */
    case 236: /* trigger_cmd */
{
#line 993 "parse.y"
sqlite3DeleteTriggerStep(pParse->db, (yypminor->yy137));
#line 1328 "parse.c"
}
      break;
    case 233: /* trigger_event */
{
#line 979 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy412).b);
#line 1335 "parse.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3ParserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_MAX ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_MAX );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_SZ_ACTTAB );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3ParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 39 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1513 "parse.c"
   sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 139, 1 },
  { 140, 2 },
  { 140, 1 },
  { 142, 1 },
  { 141, 1 },
  { 141, 3 },
  { 144, 0 },
  { 144, 1 },
  { 144, 3 },
  { 143, 3 },
  { 146, 0 },
  { 146, 1 },
  { 146, 2 },
  { 145, 0 },
  { 145, 1 },
  { 145, 1 },
  { 145, 1 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 148, 6 },
  { 151, 0 },
  { 151, 3 },
  { 150, 1 },
  { 150, 0 },
  { 149, 4 },
  { 149, 2 },
  { 153, 3 },
  { 153, 1 },
  { 156, 3 },
  { 157, 1 },
  { 160, 1 },
  { 161, 1 },
  { 147, 1 },
  { 147, 1 },
  { 147, 1 },
  { 158, 0 },
  { 158, 1 },
  { 162, 1 },
  { 162, 4 },
  { 162, 6 },
  { 163, 1 },
  { 163, 2 },
  { 164, 1 },
  { 164, 1 },
  { 159, 2 },
  { 159, 0 },
  { 167, 3 },
  { 167, 1 },
  { 168, 2 },
  { 168, 4 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 168, 2 },
  { 168, 3 },
  { 168, 5 },
  { 168, 2 },
  { 168, 4 },
  { 168, 4 },
  { 168, 1 },
  { 168, 2 },
  { 173, 0 },
  { 173, 1 },
  { 175, 0 },
  { 175, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 178, 2 },
  { 178, 2 },
  { 178, 1 },
  { 178, 1 },
  { 176, 3 },
  { 176, 2 },
  { 179, 0 },
  { 179, 2 },
  { 179, 2 },
  { 154, 0 },
  { 154, 2 },
  { 180, 3 },
  { 180, 2 },
  { 180, 1 },
  { 181, 2 },
  { 181, 7 },
  { 181, 5 },
  { 181, 5 },
  { 181, 10 },
  { 183, 0 },
  { 183, 1 },
  { 171, 0 },
  { 171, 3 },
  { 184, 0 },
  { 184, 2 },
  { 185, 1 },
  { 185, 1 },
  { 185, 1 },
  { 143, 4 },
  { 187, 2 },
  { 187, 0 },
  { 143, 8 },
  { 143, 4 },
  { 143, 1 },
  { 155, 1 },
  { 155, 3 },
  { 190, 1 },
  { 190, 2 },
  { 190, 1 },
  { 189, 9 },
  { 191, 1 },
  { 191, 1 },
  { 191, 0 },
  { 199, 2 },
  { 199, 0 },
  { 192, 3 },
  { 192, 2 },
  { 192, 4 },
  { 200, 2 },
  { 200, 1 },
  { 200, 0 },
  { 193, 0 },
  { 193, 2 },
  { 202, 2 },
  { 202, 0 },
  { 201, 6 },
  { 201, 7 },
  { 206, 1 },
  { 206, 1 },
  { 152, 0 },
  { 152, 2 },
  { 188, 2 },
  { 203, 1 },
  { 203, 2 },
  { 203, 3 },
  { 203, 4 },
  { 204, 2 },
  { 204, 0 },
  { 205, 4 },
  { 205, 0 },
  { 197, 0 },
  { 197, 3 },
  { 209, 4 },
  { 209, 2 },
  { 210, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 0 },
  { 195, 0 },
  { 195, 3 },
  { 196, 0 },
  { 196, 2 },
  { 198, 0 },
  { 198, 2 },
  { 198, 4 },
  { 198, 4 },
  { 143, 4 },
  { 194, 0 },
  { 194, 2 },
  { 143, 6 },
  { 212, 5 },
  { 212, 3 },
  { 143, 8 },
  { 143, 5 },
  { 143, 6 },
  { 213, 2 },
  { 213, 1 },
  { 215, 3 },
  { 215, 1 },
  { 214, 0 },
  { 214, 3 },
  { 208, 3 },
  { 208, 1 },
  { 170, 1 },
  { 170, 3 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 5 },
  { 169, 1 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 6 },
  { 170, 5 },
  { 170, 4 },
  { 169, 1 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 217, 1 },
  { 217, 2 },
  { 217, 1 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 170, 4 },
  { 170, 2 },
  { 170, 3 },
  { 170, 3 },
  { 170, 4 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 219, 1 },
  { 219, 2 },
  { 170, 5 },
  { 220, 1 },
  { 220, 2 },
  { 170, 5 },
  { 170, 3 },
  { 170, 5 },
  { 170, 4 },
  { 170, 4 },
  { 170, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 216, 1 },
  { 216, 0 },
  { 211, 3 },
  { 211, 1 },
  { 143, 11 },
  { 224, 1 },
  { 224, 0 },
  { 174, 0 },
  { 174, 3 },
  { 182, 5 },
  { 182, 3 },
  { 225, 1 },
  { 226, 0 },
  { 226, 2 },
  { 143, 4 },
  { 143, 1 },
  { 143, 2 },
  { 143, 5 },
  { 143, 5 },
  { 143, 5 },
  { 143, 5 },
  { 143, 6 },
  { 143, 3 },
  { 227, 1 },
  { 227, 1 },
  { 165, 2 },
  { 166, 2 },
  { 229, 1 },
  { 228, 1 },
  { 228, 0 },
  { 143, 5 },
  { 230, 11 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 232, 0 },
  { 233, 1 },
  { 233, 1 },
  { 233, 3 },
  { 234, 0 },
  { 234, 3 },
  { 235, 0 },
  { 235, 2 },
  { 231, 3 },
  { 231, 0 },
  { 236, 6 },
  { 236, 8 },
  { 236, 5 },
  { 236, 4 },
  { 236, 1 },
  { 170, 4 },
  { 170, 6 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 143, 4 },
  { 143, 6 },
  { 143, 3 },
  { 238, 0 },
  { 238, 2 },
  { 237, 1 },
  { 237, 0 },
  { 143, 1 },
  { 143, 3 },
  { 143, 1 },
  { 143, 3 },
  { 143, 6 },
  { 143, 6 },
  { 239, 1 },
  { 240, 0 },
  { 240, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* input ::= cmdlist */
      case 1: /* cmdlist ::= cmdlist ecmd */
      case 2: /* cmdlist ::= ecmd */
      case 4: /* ecmd ::= SEMI */
      case 5: /* ecmd ::= explain cmdx SEMI */
      case 10: /* trans_opt ::= */
      case 11: /* trans_opt ::= TRANSACTION */
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 20: /* cmd ::= create_table create_table_args */
      case 28: /* columnlist ::= columnlist COMMA column */
      case 29: /* columnlist ::= column */
      case 37: /* type ::= */
      case 44: /* signed ::= plus_num */
      case 45: /* signed ::= minus_num */
      case 46: /* carglist ::= carglist carg */
      case 47: /* carglist ::= */
      case 48: /* carg ::= CONSTRAINT nm ccons */
      case 49: /* carg ::= ccons */
      case 55: /* ccons ::= NULL onconf */
      case 82: /* conslist ::= conslist COMMA tcons */
      case 83: /* conslist ::= conslist tcons */
      case 84: /* conslist ::= tcons */
      case 85: /* tcons ::= CONSTRAINT nm */
      case 258: /* plus_opt ::= PLUS */
      case 259: /* plus_opt ::= */
      case 269: /* foreach_clause ::= */
      case 270: /* foreach_clause ::= FOR EACH ROW */
      case 290: /* database_kw_opt ::= DATABASE */
      case 291: /* database_kw_opt ::= */
      case 299: /* kwcolumn_opt ::= */
      case 300: /* kwcolumn_opt ::= COLUMNKW */
#line 91 "parse.y"
{
}
#line 1959 "parse.c"
        break;
      case 3: /* cmdx ::= cmd */
#line 94 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1964 "parse.c"
        break;
      case 6: /* explain ::= */
#line 97 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1969 "parse.c"
        break;
      case 7: /* explain ::= EXPLAIN */
#line 99 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1974 "parse.c"
        break;
      case 8: /* explain ::= EXPLAIN QUERY PLAN */
#line 100 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1979 "parse.c"
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
#line 106 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy124);}
#line 1984 "parse.c"
        break;
      case 13: /* transtype ::= */
#line 111 "parse.y"
{yygotominor.yy124 = TK_DEFERRED;}
#line 1989 "parse.c"
        break;
      case 14: /* transtype ::= DEFERRED */
      case 15: /* transtype ::= IMMEDIATE */
      case 16: /* transtype ::= EXCLUSIVE */
      case 107: /* multiselect_op ::= UNION */
      case 109: /* multiselect_op ::= EXCEPT|INTERSECT */
#line 112 "parse.y"
{yygotominor.yy124 = yymsp[0].major;}
#line 1998 "parse.c"
        break;
      case 17: /* cmd ::= COMMIT trans_opt */
      case 18: /* cmd ::= END trans_opt */
#line 115 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 2004 "parse.c"
        break;
      case 19: /* cmd ::= ROLLBACK trans_opt */
#line 117 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 2009 "parse.c"
        break;
      case 21: /* create_table ::= CREATE temp TABLE ifnotexists nm dbnm */
#line 122 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,yymsp[-4].minor.yy124,0,0,yymsp[-2].minor.yy124);
}
#line 2016 "parse.c"
        break;
      case 22: /* ifnotexists ::= */
      case 25: /* temp ::= */
      case 63: /* autoinc ::= */
      case 77: /* init_deferred_pred_opt ::= */
      case 79: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
      case 90: /* defer_subclause_opt ::= */
      case 101: /* ifexists ::= */
      case 112: /* distinct ::= ALL */
      case 113: /* distinct ::= */
      case 213: /* between_op ::= BETWEEN */
      case 216: /* in_op ::= IN */
#line 126 "parse.y"
{yygotominor.yy124 = 0;}
#line 2031 "parse.c"
        break;
      case 23: /* ifnotexists ::= IF NOT EXISTS */
      case 24: /* temp ::= TEMP */
      case 64: /* autoinc ::= AUTOINCR */
      case 78: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
      case 100: /* ifexists ::= IF EXISTS */
      case 111: /* distinct ::= DISTINCT */
      case 214: /* between_op ::= NOT BETWEEN */
      case 217: /* in_op ::= NOT IN */
#line 127 "parse.y"
{yygotominor.yy124 = 1;}
#line 2043 "parse.c"
        break;
      case 26: /* create_table_args ::= LP columnlist conslist_opt RP */
#line 133 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0);
}
#line 2050 "parse.c"
        break;
      case 27: /* create_table_args ::= AS select */
#line 136 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy313);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy313);
}
#line 2058 "parse.c"
        break;
      case 30: /* column ::= columnid type carglist */
#line 148 "parse.y"
{
  yygotominor.yy0.z = yymsp[-2].minor.yy0.z;
  yygotominor.yy0.n = (pParse->sLastToken.z-yymsp[-2].minor.yy0.z) + pParse->sLastToken.n;
}
#line 2066 "parse.c"
        break;
      case 31: /* columnid ::= nm */
#line 152 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy0);
  yygotominor.yy0 = yymsp[0].minor.yy0;
}
#line 2074 "parse.c"
        break;
      case 32: /* id ::= ID */
      case 33: /* ids ::= ID|STRING */
      case 34: /* nm ::= ID */
      case 35: /* nm ::= STRING */
      case 36: /* nm ::= JOIN_KW */
      case 39: /* typetoken ::= typename */
      case 42: /* typename ::= ids */
      case 119: /* as ::= AS nm */
      case 120: /* as ::= ids */
      case 131: /* dbnm ::= DOT nm */
      case 241: /* idxitem ::= nm */
      case 243: /* collate ::= COLLATE ids */
      case 253: /* nmnum ::= plus_num */
      case 254: /* nmnum ::= nm */
      case 255: /* plus_num ::= plus_opt number */
      case 256: /* minus_num ::= MINUS number */
      case 257: /* number ::= INTEGER|FLOAT */
#line 162 "parse.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;}
#line 2095 "parse.c"
        break;
      case 38: /* type ::= typetoken */
#line 223 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy0);}
#line 2100 "parse.c"
        break;
      case 40: /* typetoken ::= typename LP signed RP */
#line 225 "parse.y"
{
  yygotominor.yy0.z = yymsp[-3].minor.yy0.z;
  yygotominor.yy0.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy0.z;
}
#line 2108 "parse.c"
        break;
      case 41: /* typetoken ::= typename LP signed COMMA signed RP */
#line 229 "parse.y"
{
  yygotominor.yy0.z = yymsp[-5].minor.yy0.z;
  yygotominor.yy0.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy0.z;
}
#line 2116 "parse.c"
        break;
      case 43: /* typename ::= typename ids */
#line 235 "parse.y"
{yygotominor.yy0.z=yymsp[-1].minor.yy0.z; yygotominor.yy0.n=yymsp[0].minor.yy0.n+(yymsp[0].minor.yy0.z-yymsp[-1].minor.yy0.z);}
#line 2121 "parse.c"
        break;
      case 50: /* ccons ::= DEFAULT term */
      case 52: /* ccons ::= DEFAULT PLUS term */
#line 246 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy162);}
#line 2127 "parse.c"
        break;
      case 51: /* ccons ::= DEFAULT LP expr RP */
#line 247 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy162);}
#line 2132 "parse.c"
        break;
      case 53: /* ccons ::= DEFAULT MINUS term */
#line 249 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy162, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2140 "parse.c"
        break;
      case 54: /* ccons ::= DEFAULT id */
#line 253 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_STRING, 0, 0, &yymsp[0].minor.yy0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2148 "parse.c"
        break;
      case 56: /* ccons ::= NOT NULL onconf */
#line 262 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy124);}
#line 2153 "parse.c"
        break;
      case 57: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
#line 264 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy124,yymsp[0].minor.yy124,yymsp[-2].minor.yy124);}
#line 2158 "parse.c"
        break;
      case 58: /* ccons ::= UNIQUE onconf */
#line 265 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy124,0,0,0,0);}
#line 2163 "parse.c"
        break;
      case 59: /* ccons ::= CHECK LP expr RP */
#line 266 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy162);}
#line 2168 "parse.c"
        break;
      case 60: /* ccons ::= REFERENCES nm idxlist_opt refargs */
#line 268 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy0,yymsp[-1].minor.yy44,yymsp[0].minor.yy124);}
#line 2173 "parse.c"
        break;
      case 61: /* ccons ::= defer_subclause */
#line 269 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy124);}
#line 2178 "parse.c"
        break;
      case 62: /* ccons ::= COLLATE ids */
#line 270 "parse.y"
{sqlite3AddCollateType(pParse, &yymsp[0].minor.yy0);}
#line 2183 "parse.c"
        break;
      case 65: /* refargs ::= */
#line 283 "parse.y"
{ yygotominor.yy124 = OE_Restrict * 0x010101; }
#line 2188 "parse.c"
        break;
      case 66: /* refargs ::= refargs refarg */
#line 284 "parse.y"
{ yygotominor.yy124 = (yymsp[-1].minor.yy124 & yymsp[0].minor.yy317.mask) | yymsp[0].minor.yy317.value; }
#line 2193 "parse.c"
        break;
      case 67: /* refarg ::= MATCH nm */
#line 286 "parse.y"
{ yygotominor.yy317.value = 0;     yygotominor.yy317.mask = 0x000000; }
#line 2198 "parse.c"
        break;
      case 68: /* refarg ::= ON DELETE refact */
#line 287 "parse.y"
{ yygotominor.yy317.value = yymsp[0].minor.yy124;     yygotominor.yy317.mask = 0x0000ff; }
#line 2203 "parse.c"
        break;
      case 69: /* refarg ::= ON UPDATE refact */
#line 288 "parse.y"
{ yygotominor.yy317.value = yymsp[0].minor.yy124<<8;  yygotominor.yy317.mask = 0x00ff00; }
#line 2208 "parse.c"
        break;
      case 70: /* refarg ::= ON INSERT refact */
#line 289 "parse.y"
{ yygotominor.yy317.value = yymsp[0].minor.yy124<<16; yygotominor.yy317.mask = 0xff0000; }
#line 2213 "parse.c"
        break;
      case 71: /* refact ::= SET NULL */
#line 291 "parse.y"
{ yygotominor.yy124 = OE_SetNull; }
#line 2218 "parse.c"
        break;
      case 72: /* refact ::= SET DEFAULT */
#line 292 "parse.y"
{ yygotominor.yy124 = OE_SetDflt; }
#line 2223 "parse.c"
        break;
      case 73: /* refact ::= CASCADE */
#line 293 "parse.y"
{ yygotominor.yy124 = OE_Cascade; }
#line 2228 "parse.c"
        break;
      case 74: /* refact ::= RESTRICT */
#line 294 "parse.y"
{ yygotominor.yy124 = OE_Restrict; }
#line 2233 "parse.c"
        break;
      case 75: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
      case 76: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
      case 91: /* defer_subclause_opt ::= defer_subclause */
      case 93: /* onconf ::= ON CONFLICT resolvetype */
      case 95: /* orconf ::= OR resolvetype */
      case 96: /* resolvetype ::= raisetype */
      case 166: /* insert_cmd ::= INSERT orconf */
#line 296 "parse.y"
{yygotominor.yy124 = yymsp[0].minor.yy124;}
#line 2244 "parse.c"
        break;
      case 80: /* conslist_opt ::= */
#line 306 "parse.y"
{yygotominor.yy0.n = 0; yygotominor.yy0.z = 0;}
#line 2249 "parse.c"
        break;
      case 81: /* conslist_opt ::= COMMA conslist */
#line 307 "parse.y"
{yygotominor.yy0 = yymsp[-1].minor.yy0;}
#line 2254 "parse.c"
        break;
      case 86: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
#line 313 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy44,yymsp[0].minor.yy124,yymsp[-2].minor.yy124,0);}
#line 2259 "parse.c"
        break;
      case 87: /* tcons ::= UNIQUE LP idxlist RP onconf */
#line 315 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy44,yymsp[0].minor.yy124,0,0,0,0);}
#line 2264 "parse.c"
        break;
      case 88: /* tcons ::= CHECK LP expr RP onconf */
#line 316 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy162);}
#line 2269 "parse.c"
        break;
      case 89: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
#line 318 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy44, &yymsp[-3].minor.yy0, yymsp[-2].minor.yy44, yymsp[-1].minor.yy124);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy124);
}
#line 2277 "parse.c"
        break;
      case 92: /* onconf ::= */
      case 94: /* orconf ::= */
#line 332 "parse.y"
{yygotominor.yy124 = OE_Default;}
#line 2283 "parse.c"
        break;
      case 97: /* resolvetype ::= IGNORE */
#line 337 "parse.y"
{yygotominor.yy124 = OE_Ignore;}
#line 2288 "parse.c"
        break;
      case 98: /* resolvetype ::= REPLACE */
      case 167: /* insert_cmd ::= REPLACE */
#line 338 "parse.y"
{yygotominor.yy124 = OE_Replace;}
#line 2294 "parse.c"
        break;
      case 99: /* cmd ::= DROP TABLE ifexists fullname */
#line 342 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy149, 0, yymsp[-1].minor.yy124);
}
#line 2301 "parse.c"
        break;
      case 102: /* cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select */
#line 352 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy0, &yymsp[-2].minor.yy0, yymsp[0].minor.yy313, yymsp[-6].minor.yy124, yymsp[-4].minor.yy124);
}
#line 2308 "parse.c"
        break;
      case 103: /* cmd ::= DROP VIEW ifexists fullname */
#line 355 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy149, 1, yymsp[-1].minor.yy124);
}
#line 2315 "parse.c"
        break;
      case 104: /* cmd ::= select */
#line 362 "parse.y"
{
  SelectDest dest = {SRT_Callback, 0, 0, 0, 0};
  sqlite3Select(pParse, yymsp[0].minor.yy313, &dest, 0, 0, 0);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy313);
}
#line 2324 "parse.c"
        break;
      case 105: /* select ::= oneselect */
      case 128: /* seltablist_paren ::= select */
#line 373 "parse.y"
{yygotominor.yy313 = yymsp[0].minor.yy313;}
#line 2330 "parse.c"
        break;
      case 106: /* select ::= select multiselect_op oneselect */
#line 375 "parse.y"
{
  if( yymsp[0].minor.yy313 ){
    yymsp[0].minor.yy313->op = yymsp[-1].minor.yy124;
    yymsp[0].minor.yy313->pPrior = yymsp[-2].minor.yy313;
  }else{
    sqlite3SelectDelete(pParse->db, yymsp[-2].minor.yy313);
  }
  yygotominor.yy313 = yymsp[0].minor.yy313;
}
#line 2343 "parse.c"
        break;
      case 108: /* multiselect_op ::= UNION ALL */
#line 386 "parse.y"
{yygotominor.yy124 = TK_ALL;}
#line 2348 "parse.c"
        break;
      case 110: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 390 "parse.y"
{
  yygotominor.yy313 = sqlite3SelectNew(pParse,yymsp[-6].minor.yy44,yymsp[-5].minor.yy149,yymsp[-4].minor.yy162,yymsp[-3].minor.yy44,yymsp[-2].minor.yy162,yymsp[-1].minor.yy44,yymsp[-7].minor.yy124,yymsp[0].minor.yy278.pLimit,yymsp[0].minor.yy278.pOffset);
}
#line 2355 "parse.c"
        break;
      case 114: /* sclp ::= selcollist COMMA */
      case 238: /* idxlist_opt ::= LP idxlist RP */
#line 411 "parse.y"
{yygotominor.yy44 = yymsp[-1].minor.yy44;}
#line 2361 "parse.c"
        break;
      case 115: /* sclp ::= */
      case 141: /* orderby_opt ::= */
      case 149: /* groupby_opt ::= */
      case 231: /* exprlist ::= */
      case 237: /* idxlist_opt ::= */
#line 412 "parse.y"
{yygotominor.yy44 = 0;}
#line 2370 "parse.c"
        break;
      case 116: /* selcollist ::= sclp expr as */
#line 413 "parse.y"
{
   yygotominor.yy44 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy44,yymsp[-1].minor.yy162,yymsp[0].minor.yy0.n?&yymsp[0].minor.yy0:0);
}
#line 2377 "parse.c"
        break;
      case 117: /* selcollist ::= sclp STAR */
#line 416 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_ALL, 0, 0, 0);
  yygotominor.yy44 = sqlite3ExprListAppend(pParse, yymsp[-1].minor.yy44, p, 0);
}
#line 2385 "parse.c"
        break;
      case 118: /* selcollist ::= sclp nm DOT STAR */
#line 420 "parse.y"
{
  Expr *pRight = sqlite3PExpr(pParse, TK_ALL, 0, 0, &yymsp[0].minor.yy0);
  Expr *pLeft = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *pDot = sqlite3PExpr(pParse, TK_DOT, pLeft, pRight, 0);
  yygotominor.yy44 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy44, pDot, 0);
}
#line 2395 "parse.c"
        break;
      case 121: /* as ::= */
#line 433 "parse.y"
{yygotominor.yy0.n = 0;}
#line 2400 "parse.c"
        break;
      case 122: /* from ::= */
#line 445 "parse.y"
{yygotominor.yy149 = sqlite3DbMallocZero(pParse->db, sizeof(*yygotominor.yy149));}
#line 2405 "parse.c"
        break;
      case 123: /* from ::= FROM seltablist */
#line 446 "parse.y"
{
  yygotominor.yy149 = yymsp[0].minor.yy149;
  sqlite3SrcListShiftJoinType(yygotominor.yy149);
}
#line 2413 "parse.c"
        break;
      case 124: /* stl_prefix ::= seltablist joinop */
#line 454 "parse.y"
{
   yygotominor.yy149 = yymsp[-1].minor.yy149;
   if( yygotominor.yy149 && yygotominor.yy149->nSrc>0 ) yygotominor.yy149->a[yygotominor.yy149->nSrc-1].jointype = yymsp[0].minor.yy124;
}
#line 2421 "parse.c"
        break;
      case 125: /* stl_prefix ::= */
#line 458 "parse.y"
{yygotominor.yy149 = 0;}
#line 2426 "parse.c"
        break;
      case 126: /* seltablist ::= stl_prefix nm dbnm as on_opt using_opt */
#line 459 "parse.y"
{
  yygotominor.yy149 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-5].minor.yy149,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,0,yymsp[-1].minor.yy162,yymsp[0].minor.yy326);
}
#line 2433 "parse.c"
        break;
      case 127: /* seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt */
#line 464 "parse.y"
{
    yygotominor.yy149 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy149,0,0,&yymsp[-2].minor.yy0,yymsp[-4].minor.yy313,yymsp[-1].minor.yy162,yymsp[0].minor.yy326);
  }
#line 2440 "parse.c"
        break;
      case 129: /* seltablist_paren ::= seltablist */
#line 475 "parse.y"
{
     sqlite3SrcListShiftJoinType(yymsp[0].minor.yy149);
     yygotominor.yy313 = sqlite3SelectNew(pParse,0,yymsp[0].minor.yy149,0,0,0,0,0,0,0);
  }
#line 2448 "parse.c"
        break;
      case 130: /* dbnm ::= */
#line 482 "parse.y"
{yygotominor.yy0.z=0; yygotominor.yy0.n=0;}
#line 2453 "parse.c"
        break;
      case 132: /* fullname ::= nm dbnm */
#line 487 "parse.y"
{yygotominor.yy149 = sqlite3SrcListAppend(pParse->db,0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);}
#line 2458 "parse.c"
        break;
      case 133: /* joinop ::= COMMA|JOIN */
#line 491 "parse.y"
{ yygotominor.yy124 = JT_INNER; }
#line 2463 "parse.c"
        break;
      case 134: /* joinop ::= JOIN_KW JOIN */
#line 492 "parse.y"
{ yygotominor.yy124 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2468 "parse.c"
        break;
      case 135: /* joinop ::= JOIN_KW nm JOIN */
#line 493 "parse.y"
{ yygotominor.yy124 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0,0); }
#line 2473 "parse.c"
        break;
      case 136: /* joinop ::= JOIN_KW nm nm JOIN */
#line 495 "parse.y"
{ yygotominor.yy124 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0); }
#line 2478 "parse.c"
        break;
      case 137: /* on_opt ::= ON expr */
      case 145: /* sortitem ::= expr */
      case 152: /* having_opt ::= HAVING expr */
      case 159: /* where_opt ::= WHERE expr */
      case 174: /* expr ::= term */
      case 202: /* escape ::= ESCAPE expr */
      case 226: /* case_else ::= ELSE expr */
      case 228: /* case_operand ::= expr */
#line 499 "parse.y"
{yygotominor.yy162 = yymsp[0].minor.yy162;}
#line 2490 "parse.c"
        break;
      case 138: /* on_opt ::= */
      case 151: /* having_opt ::= */
      case 158: /* where_opt ::= */
      case 203: /* escape ::= */
      case 227: /* case_else ::= */
      case 229: /* case_operand ::= */
#line 500 "parse.y"
{yygotominor.yy162 = 0;}
#line 2500 "parse.c"
        break;
      case 139: /* using_opt ::= USING LP inscollist RP */
      case 171: /* inscollist_opt ::= LP inscollist RP */
#line 504 "parse.y"
{yygotominor.yy326 = yymsp[-1].minor.yy326;}
#line 2506 "parse.c"
        break;
      case 140: /* using_opt ::= */
      case 170: /* inscollist_opt ::= */
#line 505 "parse.y"
{yygotominor.yy326 = 0;}
#line 2512 "parse.c"
        break;
      case 142: /* orderby_opt ::= ORDER BY sortlist */
      case 150: /* groupby_opt ::= GROUP BY nexprlist */
      case 230: /* exprlist ::= nexprlist */
#line 516 "parse.y"
{yygotominor.yy44 = yymsp[0].minor.yy44;}
#line 2519 "parse.c"
        break;
      case 143: /* sortlist ::= sortlist COMMA sortitem sortorder */
#line 517 "parse.y"
{
  yygotominor.yy44 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy44,yymsp[-1].minor.yy162,0);
  if( yygotominor.yy44 ) yygotominor.yy44->a[yygotominor.yy44->nExpr-1].sortOrder = yymsp[0].minor.yy124;
}
#line 2527 "parse.c"
        break;
      case 144: /* sortlist ::= sortitem sortorder */
#line 521 "parse.y"
{
  yygotominor.yy44 = sqlite3ExprListAppend(pParse,0,yymsp[-1].minor.yy162,0);
  if( yygotominor.yy44 && yygotominor.yy44->a ) yygotominor.yy44->a[0].sortOrder = yymsp[0].minor.yy124;
}
#line 2535 "parse.c"
        break;
      case 146: /* sortorder ::= ASC */
      case 148: /* sortorder ::= */
#line 529 "parse.y"
{yygotominor.yy124 = SQLITE_SO_ASC;}
#line 2541 "parse.c"
        break;
      case 147: /* sortorder ::= DESC */
#line 530 "parse.y"
{yygotominor.yy124 = SQLITE_SO_DESC;}
#line 2546 "parse.c"
        break;
      case 153: /* limit_opt ::= */
#line 556 "parse.y"
{yygotominor.yy278.pLimit = 0; yygotominor.yy278.pOffset = 0;}
#line 2551 "parse.c"
        break;
      case 154: /* limit_opt ::= LIMIT expr */
#line 557 "parse.y"
{yygotominor.yy278.pLimit = yymsp[0].minor.yy162; yygotominor.yy278.pOffset = 0;}
#line 2556 "parse.c"
        break;
      case 155: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 559 "parse.y"
{yygotominor.yy278.pLimit = yymsp[-2].minor.yy162; yygotominor.yy278.pOffset = yymsp[0].minor.yy162;}
#line 2561 "parse.c"
        break;
      case 156: /* limit_opt ::= LIMIT expr COMMA expr */
#line 561 "parse.y"
{yygotominor.yy278.pOffset = yymsp[-2].minor.yy162; yygotominor.yy278.pLimit = yymsp[0].minor.yy162;}
#line 2566 "parse.c"
        break;
      case 157: /* cmd ::= DELETE FROM fullname where_opt */
#line 565 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy149,yymsp[0].minor.yy162);}
#line 2571 "parse.c"
        break;
      case 160: /* cmd ::= UPDATE orconf fullname SET setlist where_opt */
#line 575 "parse.y"
{
  sqlite3ExprListCheckLength(pParse,yymsp[-1].minor.yy44,"set list"); 
  sqlite3Update(pParse,yymsp[-3].minor.yy149,yymsp[-1].minor.yy44,yymsp[0].minor.yy162,yymsp[-4].minor.yy124);
}
#line 2579 "parse.c"
        break;
      case 161: /* setlist ::= setlist COMMA nm EQ expr */
#line 584 "parse.y"
{yygotominor.yy44 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy44,yymsp[0].minor.yy162,&yymsp[-2].minor.yy0);}
#line 2584 "parse.c"
        break;
      case 162: /* setlist ::= nm EQ expr */
#line 586 "parse.y"
{yygotominor.yy44 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy162,&yymsp[-2].minor.yy0);}
#line 2589 "parse.c"
        break;
      case 163: /* cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP */
#line 592 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy149, yymsp[-1].minor.yy44, 0, yymsp[-4].minor.yy326, yymsp[-7].minor.yy124);}
#line 2594 "parse.c"
        break;
      case 164: /* cmd ::= insert_cmd INTO fullname inscollist_opt select */
#line 594 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy149, 0, yymsp[0].minor.yy313, yymsp[-1].minor.yy326, yymsp[-4].minor.yy124);}
#line 2599 "parse.c"
        break;
      case 165: /* cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES */
#line 596 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy149, 0, 0, yymsp[-2].minor.yy326, yymsp[-5].minor.yy124);}
#line 2604 "parse.c"
        break;
      case 168: /* itemlist ::= itemlist COMMA expr */
      case 232: /* nexprlist ::= nexprlist COMMA expr */
#line 607 "parse.y"
{yygotominor.yy44 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy44,yymsp[0].minor.yy162,0);}
#line 2610 "parse.c"
        break;
      case 169: /* itemlist ::= expr */
      case 233: /* nexprlist ::= expr */
#line 609 "parse.y"
{yygotominor.yy44 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy162,0);}
#line 2616 "parse.c"
        break;
      case 172: /* inscollist ::= inscollist COMMA nm */
#line 619 "parse.y"
{yygotominor.yy326 = sqlite3IdListAppend(pParse->db,yymsp[-2].minor.yy326,&yymsp[0].minor.yy0);}
#line 2621 "parse.c"
        break;
      case 173: /* inscollist ::= nm */
#line 621 "parse.y"
{yygotominor.yy326 = sqlite3IdListAppend(pParse->db,0,&yymsp[0].minor.yy0);}
#line 2626 "parse.c"
        break;
      case 175: /* expr ::= LP expr RP */
#line 632 "parse.y"
{yygotominor.yy162 = yymsp[-1].minor.yy162; sqlite3ExprSpan(yygotominor.yy162,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2631 "parse.c"
        break;
      case 176: /* term ::= NULL */
      case 181: /* term ::= INTEGER|FLOAT|BLOB */
      case 182: /* term ::= STRING */
#line 633 "parse.y"
{yygotominor.yy162 = sqlite3PExpr(pParse, yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2638 "parse.c"
        break;
      case 177: /* expr ::= ID */
      case 178: /* expr ::= JOIN_KW */
#line 634 "parse.y"
{yygotominor.yy162 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2644 "parse.c"
        break;
      case 179: /* expr ::= nm DOT nm */
#line 636 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  yygotominor.yy162 = sqlite3PExpr(pParse, TK_DOT, temp1, temp2, 0);
}
#line 2653 "parse.c"
        break;
      case 180: /* expr ::= nm DOT nm DOT nm */
#line 641 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-4].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp3 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  Expr *temp4 = sqlite3PExpr(pParse, TK_DOT, temp2, temp3, 0);
  yygotominor.yy162 = sqlite3PExpr(pParse, TK_DOT, temp1, temp4, 0);
}
#line 2664 "parse.c"
        break;
      case 183: /* expr ::= REGISTER */
#line 650 "parse.y"
{yygotominor.yy162 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2669 "parse.c"
        break;
      case 184: /* expr ::= VARIABLE */
#line 651 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy162 = sqlite3PExpr(pParse, TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2678 "parse.c"
        break;
      case 185: /* expr ::= expr COLLATE ids */
#line 656 "parse.y"
{
  yygotominor.yy162 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy162, &yymsp[0].minor.yy0);
}
#line 2685 "parse.c"
        break;
      case 186: /* expr ::= CAST LP expr AS typetoken RP */
#line 660 "parse.y"
{
  yygotominor.yy162 = sqlite3PExpr(pParse, TK_CAST, yymsp[-3].minor.yy162, 0, &yymsp[-1].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2693 "parse.c"
        break;
      case 187: /* expr ::= ID LP distinct exprlist RP */
#line 665 "parse.y"
{
  if( yymsp[-1].minor.yy44 && yymsp[-1].minor.yy44->nExpr>SQLITE_MAX_FUNCTION_ARG ){
    sqlite3ErrorMsg(pParse, "too many arguments on function %T", &yymsp[-4].minor.yy0);
  }
  yygotominor.yy162 = sqlite3ExprFunction(pParse, yymsp[-1].minor.yy44, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy124 && yygotominor.yy162 ){
    yygotominor.yy162->flags |= EP_Distinct;
  }
}
#line 2707 "parse.c"
        break;
      case 188: /* expr ::= ID LP STAR RP */
#line 675 "parse.y"
{
  yygotominor.yy162 = sqlite3ExprFunction(pParse, 0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2715 "parse.c"
        break;
      case 189: /* term ::= CTIME_KW */
#line 679 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy162 = sqlite3ExprFunction(pParse, 0,&yymsp[0].minor.yy0);
  if( yygotominor.yy162 ){
    yygotominor.yy162->op = TK_CONST_FUNC;  
    yygotominor.yy162->span = yymsp[0].minor.yy0;
  }
}
#line 2728 "parse.c"
        break;
      case 190: /* expr ::= expr AND expr */
      case 191: /* expr ::= expr OR expr */
      case 192: /* expr ::= expr LT|GT|GE|LE expr */
      case 193: /* expr ::= expr EQ|NE expr */
      case 194: /* expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */
      case 195: /* expr ::= expr PLUS|MINUS expr */
      case 196: /* expr ::= expr STAR|SLASH|REM expr */
      case 197: /* expr ::= expr CONCAT expr */
#line 688 "parse.y"
{yygotominor.yy162 = sqlite3PExpr(pParse,yymsp[-1].major,yymsp[-2].minor.yy162,yymsp[0].minor.yy162,0);}
#line 2740 "parse.c"
        break;
      case 198: /* likeop ::= LIKE_KW */
      case 200: /* likeop ::= MATCH */
#line 700 "parse.y"
{yygotominor.yy168.eOperator = yymsp[0].minor.yy0; yygotominor.yy168.not = 0;}
#line 2746 "parse.c"
        break;
      case 199: /* likeop ::= NOT LIKE_KW */
      case 201: /* likeop ::= NOT MATCH */
#line 701 "parse.y"
{yygotominor.yy168.eOperator = yymsp[0].minor.yy0; yygotominor.yy168.not = 1;}
#line 2752 "parse.c"
        break;
      case 204: /* expr ::= expr likeop expr escape */
#line 708 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(pParse,0, yymsp[-1].minor.yy162, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[-3].minor.yy162, 0);
  if( yymsp[0].minor.yy162 ){
    pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy162, 0);
  }
  yygotominor.yy162 = sqlite3ExprFunction(pParse, pList, &yymsp[-2].minor.yy168.eOperator);
  if( yymsp[-2].minor.yy168.not ) yygotominor.yy162 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162, &yymsp[-3].minor.yy162->span, &yymsp[-1].minor.yy162->span);
  if( yygotominor.yy162 ) yygotominor.yy162->flags |= EP_InfixFunc;
}
#line 2768 "parse.c"
        break;
      case 205: /* expr ::= expr ISNULL|NOTNULL */
#line 721 "parse.y"
{
  yygotominor.yy162 = sqlite3PExpr(pParse, yymsp[0].major, yymsp[-1].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-1].minor.yy162->span,&yymsp[0].minor.yy0);
}
#line 2776 "parse.c"
        break;
      case 206: /* expr ::= expr IS NULL */
#line 725 "parse.y"
{
  yygotominor.yy162 = sqlite3PExpr(pParse, TK_ISNULL, yymsp[-2].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-2].minor.yy162->span,&yymsp[0].minor.yy0);
}
#line 2784 "parse.c"
        break;
      case 207: /* expr ::= expr NOT NULL */
#line 729 "parse.y"
{
  yygotominor.yy162 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-2].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-2].minor.yy162->span,&yymsp[0].minor.yy0);
}
#line 2792 "parse.c"
        break;
      case 208: /* expr ::= expr IS NOT NULL */
#line 733 "parse.y"
{
  yygotominor.yy162 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-3].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-3].minor.yy162->span,&yymsp[0].minor.yy0);
}
#line 2800 "parse.c"
        break;
      case 209: /* expr ::= NOT expr */
      case 210: /* expr ::= BITNOT expr */
#line 737 "parse.y"
{
  yygotominor.yy162 = sqlite3PExpr(pParse, yymsp[-1].major, yymsp[0].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy162->span);
}
#line 2809 "parse.c"
        break;
      case 211: /* expr ::= MINUS expr */
#line 745 "parse.y"
{
  yygotominor.yy162 = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy162->span);
}
#line 2817 "parse.c"
        break;
      case 212: /* expr ::= PLUS expr */
#line 749 "parse.y"
{
  yygotominor.yy162 = sqlite3PExpr(pParse, TK_UPLUS, yymsp[0].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy162->span);
}
#line 2825 "parse.c"
        break;
      case 215: /* expr ::= expr between_op expr AND expr */
#line 756 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy162, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy162, 0);
  yygotominor.yy162 = sqlite3PExpr(pParse, TK_BETWEEN, yymsp[-4].minor.yy162, 0, 0);
  if( yygotominor.yy162 ){
    yygotominor.yy162->pList = pList;
  }else{
    sqlite3ExprListDelete(pParse->db, pList);
  } 
  if( yymsp[-3].minor.yy124 ) yygotominor.yy162 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-4].minor.yy162->span,&yymsp[0].minor.yy162->span);
}
#line 2841 "parse.c"
        break;
      case 218: /* expr ::= expr in_op LP exprlist RP */
#line 772 "parse.y"
{
    yygotominor.yy162 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy162, 0, 0);
    if( yygotominor.yy162 ){
      yygotominor.yy162->pList = yymsp[-1].minor.yy44;
      sqlite3ExprSetHeight(pParse, yygotominor.yy162);
    }else{
      sqlite3ExprListDelete(pParse->db, yymsp[-1].minor.yy44);
    }
    if( yymsp[-3].minor.yy124 ) yygotominor.yy162 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy162, 0, 0);
    sqlite3ExprSpan(yygotominor.yy162,&yymsp[-4].minor.yy162->span,&yymsp[0].minor.yy0);
  }
#line 2856 "parse.c"
        break;
      case 219: /* expr ::= LP select RP */
#line 783 "parse.y"
{
    yygotominor.yy162 = sqlite3PExpr(pParse, TK_SELECT, 0, 0, 0);
    if( yygotominor.yy162 ){
      yygotominor.yy162->pSelect = yymsp[-1].minor.yy313;
      sqlite3ExprSetHeight(pParse, yygotominor.yy162);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy313);
    }
    sqlite3ExprSpan(yygotominor.yy162,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2870 "parse.c"
        break;
      case 220: /* expr ::= expr in_op LP select RP */
#line 793 "parse.y"
{
    yygotominor.yy162 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy162, 0, 0);
    if( yygotominor.yy162 ){
      yygotominor.yy162->pSelect = yymsp[-1].minor.yy313;
      sqlite3ExprSetHeight(pParse, yygotominor.yy162);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy313);
    }
    if( yymsp[-3].minor.yy124 ) yygotominor.yy162 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy162, 0, 0);
    sqlite3ExprSpan(yygotominor.yy162,&yymsp[-4].minor.yy162->span,&yymsp[0].minor.yy0);
  }
#line 2885 "parse.c"
        break;
      case 221: /* expr ::= expr in_op nm dbnm */
#line 804 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(pParse->db, 0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);
    yygotominor.yy162 = sqlite3PExpr(pParse, TK_IN, yymsp[-3].minor.yy162, 0, 0);
    if( yygotominor.yy162 ){
      yygotominor.yy162->pSelect = sqlite3SelectNew(pParse, 0,pSrc,0,0,0,0,0,0,0);
      sqlite3ExprSetHeight(pParse, yygotominor.yy162);
    }else{
      sqlite3SrcListDelete(pParse->db, pSrc);
    }
    if( yymsp[-2].minor.yy124 ) yygotominor.yy162 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy162, 0, 0);
    sqlite3ExprSpan(yygotominor.yy162,&yymsp[-3].minor.yy162->span,yymsp[0].minor.yy0.z?&yymsp[0].minor.yy0:&yymsp[-1].minor.yy0);
  }
#line 2901 "parse.c"
        break;
      case 222: /* expr ::= EXISTS LP select RP */
#line 816 "parse.y"
{
    Expr *p = yygotominor.yy162 = sqlite3PExpr(pParse, TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy313;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
      sqlite3ExprSetHeight(pParse, yygotominor.yy162);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy313);
    }
  }
#line 2915 "parse.c"
        break;
      case 223: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 829 "parse.y"
{
  yygotominor.yy162 = sqlite3PExpr(pParse, TK_CASE, yymsp[-3].minor.yy162, yymsp[-1].minor.yy162, 0);
  if( yygotominor.yy162 ){
    yygotominor.yy162->pList = yymsp[-2].minor.yy44;
    sqlite3ExprSetHeight(pParse, yygotominor.yy162);
  }else{
    sqlite3ExprListDelete(pParse->db, yymsp[-2].minor.yy44);
  }
  sqlite3ExprSpan(yygotominor.yy162, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2929 "parse.c"
        break;
      case 224: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 841 "parse.y"
{
  yygotominor.yy44 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy44, yymsp[-2].minor.yy162, 0);
  yygotominor.yy44 = sqlite3ExprListAppend(pParse,yygotominor.yy44, yymsp[0].minor.yy162, 0);
}
#line 2937 "parse.c"
        break;
      case 225: /* case_exprlist ::= WHEN expr THEN expr */
#line 845 "parse.y"
{
  yygotominor.yy44 = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy162, 0);
  yygotominor.yy44 = sqlite3ExprListAppend(pParse,yygotominor.yy44, yymsp[0].minor.yy162, 0);
}
#line 2945 "parse.c"
        break;
      case 234: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP */
#line 874 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy0, &yymsp[-5].minor.yy0, 
                     sqlite3SrcListAppend(pParse->db,0,&yymsp[-3].minor.yy0,0), yymsp[-1].minor.yy44, yymsp[-9].minor.yy124,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy124);
}
#line 2954 "parse.c"
        break;
      case 235: /* uniqueflag ::= UNIQUE */
      case 283: /* raisetype ::= ABORT */
#line 881 "parse.y"
{yygotominor.yy124 = OE_Abort;}
#line 2960 "parse.c"
        break;
      case 236: /* uniqueflag ::= */
#line 882 "parse.y"
{yygotominor.yy124 = OE_None;}
#line 2965 "parse.c"
        break;
      case 239: /* idxlist ::= idxlist COMMA idxitem collate sortorder */
#line 892 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy44 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy44, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy44, "index");
  if( yygotominor.yy44 ) yygotominor.yy44->a[yygotominor.yy44->nExpr-1].sortOrder = yymsp[0].minor.yy124;
}
#line 2979 "parse.c"
        break;
      case 240: /* idxlist ::= idxitem collate sortorder */
#line 902 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy44 = sqlite3ExprListAppend(pParse,0, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy44, "index");
  if( yygotominor.yy44 ) yygotominor.yy44->a[yygotominor.yy44->nExpr-1].sortOrder = yymsp[0].minor.yy124;
}
#line 2993 "parse.c"
        break;
      case 242: /* collate ::= */
#line 915 "parse.y"
{yygotominor.yy0.z = 0; yygotominor.yy0.n = 0;}
#line 2998 "parse.c"
        break;
      case 244: /* cmd ::= DROP INDEX ifexists fullname */
#line 921 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy149, yymsp[-1].minor.yy124);}
#line 3003 "parse.c"
        break;
      case 245: /* cmd ::= VACUUM */
      case 246: /* cmd ::= VACUUM nm */
#line 927 "parse.y"
{sqlite3Vacuum(pParse);}
#line 3009 "parse.c"
        break;
      case 247: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 248: /* cmd ::= PRAGMA nm dbnm EQ ON */
      case 249: /* cmd ::= PRAGMA nm dbnm EQ DELETE */
#line 936 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,0);}
#line 3016 "parse.c"
        break;
      case 250: /* cmd ::= PRAGMA nm dbnm EQ minus_num */
#line 939 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,1);
}
#line 3023 "parse.c"
        break;
      case 251: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
#line 942 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,&yymsp[-1].minor.yy0,0);}
#line 3028 "parse.c"
        break;
      case 252: /* cmd ::= PRAGMA nm dbnm */
#line 943 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0,0);}
#line 3033 "parse.c"
        break;
      case 260: /* cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END */
#line 958 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy0.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy0.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy137, &all);
}
#line 3043 "parse.c"
        break;
      case 261: /* trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause */
#line 967 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy0, &yymsp[-6].minor.yy0, yymsp[-5].minor.yy124, yymsp[-4].minor.yy412.a, yymsp[-4].minor.yy412.b, yymsp[-2].minor.yy149, yymsp[0].minor.yy162, yymsp[-10].minor.yy124, yymsp[-8].minor.yy124);
  yygotominor.yy0 = (yymsp[-6].minor.yy0.n==0?yymsp[-7].minor.yy0:yymsp[-6].minor.yy0);
}
#line 3051 "parse.c"
        break;
      case 262: /* trigger_time ::= BEFORE */
      case 265: /* trigger_time ::= */
#line 973 "parse.y"
{ yygotominor.yy124 = TK_BEFORE; }
#line 3057 "parse.c"
        break;
      case 263: /* trigger_time ::= AFTER */
#line 974 "parse.y"
{ yygotominor.yy124 = TK_AFTER;  }
#line 3062 "parse.c"
        break;
      case 264: /* trigger_time ::= INSTEAD OF */
#line 975 "parse.y"
{ yygotominor.yy124 = TK_INSTEAD;}
#line 3067 "parse.c"
        break;
      case 266: /* trigger_event ::= DELETE|INSERT */
      case 267: /* trigger_event ::= UPDATE */
#line 980 "parse.y"
{yygotominor.yy412.a = yymsp[0].major; yygotominor.yy412.b = 0;}
#line 3073 "parse.c"
        break;
      case 268: /* trigger_event ::= UPDATE OF inscollist */
#line 982 "parse.y"
{yygotominor.yy412.a = TK_UPDATE; yygotominor.yy412.b = yymsp[0].minor.yy326;}
#line 3078 "parse.c"
        break;
      case 271: /* when_clause ::= */
      case 288: /* key_opt ::= */
#line 989 "parse.y"
{ yygotominor.yy162 = 0; }
#line 3084 "parse.c"
        break;
      case 272: /* when_clause ::= WHEN expr */
      case 289: /* key_opt ::= KEY expr */
#line 990 "parse.y"
{ yygotominor.yy162 = yymsp[0].minor.yy162; }
#line 3090 "parse.c"
        break;
      case 273: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
#line 994 "parse.y"
{
  if( yymsp[-2].minor.yy137 ){
    yymsp[-2].minor.yy137->pLast->pNext = yymsp[-1].minor.yy137;
  }else{
    yymsp[-2].minor.yy137 = yymsp[-1].minor.yy137;
  }
  yymsp[-2].minor.yy137->pLast = yymsp[-1].minor.yy137;
  yygotominor.yy137 = yymsp[-2].minor.yy137;
}
#line 3103 "parse.c"
        break;
      case 274: /* trigger_cmd_list ::= */
#line 1003 "parse.y"
{ yygotominor.yy137 = 0; }
#line 3108 "parse.c"
        break;
      case 275: /* trigger_cmd ::= UPDATE orconf nm SET setlist where_opt */
#line 1009 "parse.y"
{ yygotominor.yy137 = sqlite3TriggerUpdateStep(pParse->db, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy44, yymsp[0].minor.yy162, yymsp[-4].minor.yy124); }
#line 3113 "parse.c"
        break;
      case 276: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP */
#line 1014 "parse.y"
{yygotominor.yy137 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-5].minor.yy0, yymsp[-4].minor.yy326, yymsp[-1].minor.yy44, 0, yymsp[-7].minor.yy124);}
#line 3118 "parse.c"
        break;
      case 277: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt select */
#line 1017 "parse.y"
{yygotominor.yy137 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-2].minor.yy0, yymsp[-1].minor.yy326, 0, yymsp[0].minor.yy313, yymsp[-4].minor.yy124);}
#line 3123 "parse.c"
        break;
      case 278: /* trigger_cmd ::= DELETE FROM nm where_opt */
#line 1021 "parse.y"
{yygotominor.yy137 = sqlite3TriggerDeleteStep(pParse->db, &yymsp[-1].minor.yy0, yymsp[0].minor.yy162);}
#line 3128 "parse.c"
        break;
      case 279: /* trigger_cmd ::= select */
#line 1024 "parse.y"
{yygotominor.yy137 = sqlite3TriggerSelectStep(pParse->db, yymsp[0].minor.yy313); }
#line 3133 "parse.c"
        break;
      case 280: /* expr ::= RAISE LP IGNORE RP */
#line 1027 "parse.y"
{
  yygotominor.yy162 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy162 ){
    yygotominor.yy162->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy162, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3144 "parse.c"
        break;
      case 281: /* expr ::= RAISE LP raisetype COMMA nm RP */
#line 1034 "parse.y"
{
  yygotominor.yy162 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, &yymsp[-1].minor.yy0); 
  if( yygotominor.yy162 ) {
    yygotominor.yy162->iColumn = yymsp[-3].minor.yy124;
    sqlite3ExprSpan(yygotominor.yy162, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3155 "parse.c"
        break;
      case 282: /* raisetype ::= ROLLBACK */
#line 1044 "parse.y"
{yygotominor.yy124 = OE_Rollback;}
#line 3160 "parse.c"
        break;
      case 284: /* raisetype ::= FAIL */
#line 1046 "parse.y"
{yygotominor.yy124 = OE_Fail;}
#line 3165 "parse.c"
        break;
      case 285: /* cmd ::= DROP TRIGGER ifexists fullname */
#line 1051 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy149,yymsp[-1].minor.yy124);
}
#line 3172 "parse.c"
        break;
      case 286: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
#line 1058 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy162, yymsp[-1].minor.yy162, yymsp[0].minor.yy162);
}
#line 3179 "parse.c"
        break;
      case 287: /* cmd ::= DETACH database_kw_opt expr */
#line 1061 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy162);
}
#line 3186 "parse.c"
        break;
      case 292: /* cmd ::= REINDEX */
#line 1076 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3191 "parse.c"
        break;
      case 293: /* cmd ::= REINDEX nm dbnm */
#line 1077 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3196 "parse.c"
        break;
      case 294: /* cmd ::= ANALYZE */
#line 1082 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3201 "parse.c"
        break;
      case 295: /* cmd ::= ANALYZE nm dbnm */
#line 1083 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3206 "parse.c"
        break;
      case 296: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
#line 1088 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy149,&yymsp[0].minor.yy0);
}
#line 3213 "parse.c"
        break;
      case 297: /* cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column */
#line 1091 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy0);
}
#line 3220 "parse.c"
        break;
      case 298: /* add_column_fullname ::= fullname */
#line 1094 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy149);
}
#line 3227 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  assert( TOKEN.z[0] );  /* The tokenizer always gives us a token */
  sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
  pParse->parseError = 1;
#line 3292 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
