/*
* Copyright (c) 2006-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
* Asymmetric cipher abstract interface
*
*/


/**
 @file
 @publishedPartner
 @released
*/

#ifndef __CRYPTOAPI_ASYMMETRICCIPHER_H__
#define __CRYPTOAPI_ASYMMETRICCIPHER_H__

#include <cryptospi/cryptoplugin.h>

namespace CryptoSpi
	{
	/**
	The Asymmetric Cipher Base definition. Intended to allow plug-ins
	to implement extensible Asymmetric cipher functionality, and to work with all
	known existing Asymmetric algorithms, e.g. RSA DSA etc
	*/
	class MAsymmetricCipherBase : public MPlugin
		{
	public:
		
		/**
		Set the public key of this cipher. Reset() is called to reinitialise the cipher.
		@param aKey	The public key.
		*/
		virtual void SetKeyL(const CKey& aKey) = 0;

		/**
		Set the crypto mode of this cipher. Reset() is called to reinitialise the cipher.
		@param aCryptoMode	The crypto mode
		*/
		virtual void SetCryptoModeL(TUid aCryptoMode) = 0;

		/**
		Set padding Mode of this cipher. Reset() is called to reinitialise the cipher.
		@param aPaddingMode	The padding mode
		*/
		virtual void SetPaddingModeL(TUid aPaddingMode) = 0;

		/**
		Gets the maximum size of input accepted by this object.	
		@return The maximum input length allowed in bytes.
		*/	 
		virtual TInt GetMaximumInputLengthL() const = 0;

		/**
		Gets the maximum size of output that can be generated by this object.
		@return The maximum output length in bytes.
		 */	 
		virtual TInt GetMaximumOutputLengthL() const = 0;
		};

	class MAsymmetricCipher : public MAsymmetricCipherBase
		{
	public:
		/**
		Encrypts or decrypts aInput and appends the result to aOutput.
		@param aInput	The input data to be processed.
		@param aOutput	The resulting processed data appended to aOutput.
		*/
		virtual void ProcessL(const TDesC8& aInput, TDes8& aOutput) = 0;
		};

	class MAsyncAsymmetricCipher : public MAsymmetricCipherBase
		{
	public:

		/**
		Encrypts or decrypts aInput and appends the result to aOutput asynchronously
		@param aInput	The input data to be processed.
		@param aOutput	The resulting processed data appended to aOutput.
		@param aRequestStatus
		*/
		virtual void ProcessL(const TDesC8& aInput, TDes8& aOutput, TRequestStatus& aRequestStatus) = 0;

		/**
		Cancel the outstanding request
		*/
		virtual void Cancel() = 0;
		};
	}

#endif //__CRYPTOAPI_ASYMMETRICCIPHER_H__
