/*
* Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
* CTransientKey declaration
*
*/


/**
 @file 
 @released
 @internalComponent
*/

#ifndef TRANSIENTKEY_H
#define TRANSIENTKEY_H

#include <pbe.h>
#include "authserver_client.h"
#include "encryptedprotectionkey.h"

namespace AuthServer
{

/**
 * CTransientKey is a cryptographic key that is generated on the fly and never
 * stored on the device.  Transient keys are used to encrypt and decrypt
 * protection keys, they are generated by the AuthServer using data gathered
 * from CAuthPlugin derived classes.
 */
class CTransientKey : public CBase
	{
public:
	
	/**
	 * Creates a new transient key, passing in the plugin data from which to
	 * derive it.
	 *
	 * @param aEncryptor encryption element to use as the key. Ownership
	 * passes to this object.
	 **/
	static CTransientKey* NewL(CPBEncryptElement* aEncryptor);

	/**
	 * Creates a new transient key, passing in the plugin data from which to
	 * derive it.
	 *
	 * @param aEncryptor encryption element to use as the key. Ownership
	 * passes to this object.
	 **/
	static CTransientKey* NewLC(CPBEncryptElement* aEncryptor);

	~CTransientKey();

	/**
	 * Create an version of the provided protection key encrypted by this
	 * key. Ownership of the returned object is passed to the caller.
	 *
	 * @param aKey the protection key to encrypt.
	 *
	 * @return an protection key encrypted by this key.
	 **/
	CEncryptedProtectionKey* EncryptL(const CProtectionKey& aKey) const;

	/**
	 * Decrypts an CEncryptedProtectionKey created by this transient
	 * key. Ownership of the returned object is passed to the caller.
	 *
	 * @param aKey the encrypted protection key to decrypt.
	 *
	 * @return a protection key
	 **/
	CProtectionKey* DecryptL(const CEncryptedProtectionKey& aKey) const;

		
private:
	void ConstructL(CPBEncryptElement* aEncryptor);
	
	CPBEncryptElement* iPbeElement;
    };
}

#endif // TRANSIENTKEY_H
