/*
* Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
* Classes used for communication between the reference dialog creator
* and the reference notifier implementations.
*
*/


/**
 @file
 @internalTechnology 
 @test
*/

#ifndef UPSNOTIFIERUTIL_H
#define UPSNOTIFIERUTIL_H

#include <e32base.h>
#include <e32cmn.h>
#include <s32strm.h>
#include <ups/policy.h>
#include <ups/upsconst.h>
#include <ups/upstypes.h>

namespace UserPromptService
	{
	/**
	Enum for bitmask that influences visual style or behavior of dialog.
	*/
	typedef enum 
		{
		ETrustedClient	= 0x0001,		///< Client SID is protected so client name is trusted
		EBuiltInApp	= 0x0002		///< Built-in application ... exe loaded for Z drive.
		} TUpsDialogFlags;
				
	/**
	Contains the data needed to display a prompt.
	*/
	NONSHARABLE_CLASS(CPromptData) : public CBase
		{
	public:		
		IMPORT_C static CPromptData* NewL();
		IMPORT_C void InternalizeL(RReadStream& aStream);
		IMPORT_C void ExternalizeL(RWriteStream& aStream) const;
		~CPromptData();
	private:
		CPromptData();
		void Reset();
	public:
		RBuf iClientName;                    ///< From AppArc, SIS registry or process filename
		RBuf iVendorName;                    ///< Vendor name
		TSecureId iClientSid;                ///< SID of client application requesting the service
		TSecureId iServerSid;                ///< Needed to lookup localized text for service
		TServiceId iServiceId;               ///< ID of the requested service
		RBuf iDestination;                   ///< The destination of the request
		RBuf8 iOpaqueData;                   ///< The Opaque data
		RPointerArray<HBufC> iDescriptions;  ///< Array of fingerprint descriptions
		TUint32 iOptions;                    ///< A bit field containing the set of allowed responses (CPolicy::TOptions)
		TUint32 iFlags;                      ///< Dialog style e.g. whether client identity is trusted
		};
			
	class TPromptResult
		{
	public: 
		TPromptResult();
		CPolicy::TOptions iSelected;    ///< The button that was pressed
		TInt iDestination;              ///< The destination selected if applicable.
		};
	
	inline TPromptResult::TPromptResult() : 
		iSelected(CPolicy::ENo), iDestination(0) 
		{
		}		
	}
#endif // UPSNOTIFIERUTIL_H
