/*
* Copyright (c) 2002-2006 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   Declaration of the WlanWsaSetPsMode class.
*
*/

/*
* %version: 8 %
*/

#ifndef WLANWSASETPSMODE_H
#define WLANWSASETPSMODE_H

#include "UmacWsaCommand.h"

/**
*  Encapsulates the execution of SetBssParameters WHA command.
*
*  @lib wlanumac.lib
*  @since S60 v3.1
*/
class WlanWsaSetPsMode : public WlanWsaCommand
    {
    
public:

    /**
    * C++ default constructor.
    */
    WlanWsaSetPsMode() : 
        iPsMode( static_cast<WHA::TPsMode>(0) ) {};

    /**
    * Destructor.
    */
    virtual ~WlanWsaSetPsMode() {};

    inline void Set( 
        WlanContextImpl& aCtxImpl, 
        WHA::TPsMode aPsMode );

private:

    virtual void Entry( WlanContextImpl& aCtxImpl );
#ifndef NDEBUG 
    virtual const TInt8* GetStateName( TUint8& aLength ) const;
#endif // !NDEBUG 

    virtual void CommandResponse( 
        WlanContextImpl& aCtxImpl, 
        WHA::TCommandId aCommandId, 
        WHA::TStatus aStatus,
        const WHA::UCommandResponseParams& aCommandResponseParams );

    // Prohibit copy constructor.
    WlanWsaSetPsMode( const WlanWsaSetPsMode& );
    // Prohibit assigment operator.
    WlanWsaSetPsMode& operator= ( const WlanWsaSetPsMode& );

private:    // Data

#ifndef NDEBUG 
    static const TInt8  iName[];
#endif

    WHA::TPsMode        iPsMode;
    };

#include "UmacWsaSetPsMode.inl"

#endif      // WLANWSASETPSMODE_H
