// BaCompileAssert.h
//
// Copyright (c) 2003 Symbian Ltd.  All rights reserved.
//

#ifndef __BACOMPILEASSERT_H__
#define __BACOMPILEASSERT_H__

template<TBool> class __CompileTimeAssert 
	{
	public: 
		inline static void Dummy() 
			{
			}
	};

TEMPLATE_SPECIALIZATION class __CompileTimeAssert<0> 
	{
	private: 
		inline static void Dummy() 
			{
			}
	};

#define COMPILE_TIME_ASSERT(aCondition)		\
	{										\
	__CompileTimeAssert<(aCondition)>::Dummy();\
	}

#endif// __BACOMPILEASSERT_H__
