/*
* Copyright (c) 2002 - 2007 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  ?Description
*
*/



// INCLUDE FILES
#include <Stiftestinterface.h>
#include "MTPbkContactItem.h"
#include <SettingServerClient.h>
#include <CPbkContactItem.h>
#include <CPbkContactEngine.h>
#include <CPbkFieldInfo.h>
#include <CPbkFieldsInfo.h>

// The name of the contact database used in these tests
_LIT(KTestDBName,"c:MT_CPbkContactItem.cdb");
// the string which will be set to textfields in FillContactFieldsL
_LIT(KFillText, "TESTDATA");
// some defined phonenumbers
_LIT(KNumber1,"5005001");
_LIT(KNumber2,"6005001");
_LIT(KNumber3,"7105001");
// panic text
_LIT(KPanicText,"TE_CPbkContactItem");

// size of CPbkContactItem class
const TInt KClassSize = 40;
// lenght of phone number
const TInt KPhoneNumberLenght = 10;

//maximum lenghts of fields
const TInt KNameFieldMaxLenght = 50;
const TInt KEmailFieldMaxLenght = 150;
const TInt KAddressFieldMaxLenght = 250;
const TInt KAddressSubfieldFieldMaxLenght = 50;
const TInt KPostalCodeFieldMaxLenght = 20;
const TInt KURLFieldMaxLenght = 1000;
const TInt KDTMFFieldMaxLenght = 60;
const TInt KNoteFieldMaxLenght = 1000;
const TInt KFileNameFieldMaxLenght = 256;
const TInt KVOIPFieldMaxLenght = 100;
const TInt KIdSuffixMaxLenght = 10;

enum TPanicCodes
    {
    KPanicUnsupportedFieldType = 1
    };


// EXTERNAL DATA STRUCTURES
//extern  ?external_data;

// EXTERNAL FUNCTION PROTOTYPES  
//extern ?external_function( ?arg_type,?arg_type );

// CONSTANTS
//const ?type ?constant_var = ?constant;

// MACROS
//#define ?macro ?macro_def

// LOCAL CONSTANTS AND MACROS
//const ?type ?constant_var = ?constant;
//#define ?macro_name ?macro_def

// MODULE DATA STRUCTURES
//enum ?declaration
//typedef ?declaration

// LOCAL FUNCTION PROTOTYPES
//?type ?function_name( ?arg_type, ?arg_type );

// FORWARD DECLARATIONS
//class ?FORWARD_CLASSNAME;

// ============================= LOCAL FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// ?function_name ?description.
// ?description
// Returns: ?value_1: ?description
//          ?value_n: ?description_line1
//                    ?description_line2
// -----------------------------------------------------------------------------
//
/*
?type ?function_name(
    ?arg_type arg,  // ?description
    ?arg_type arg)  // ?description
    {

    ?code  // ?comment

    // ?comment
    ?code
    }
*/

// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CMTPbkContactItem::CMTPbkContactItem
// C++ default constructor can NOT contain any code, that
// might leave.
// -----------------------------------------------------------------------------
//
CMTPbkContactItem::CMTPbkContactItem( 
    CTestModuleIf& aTestModuleIf ):
        CScriptBase( aTestModuleIf )
    {
    }

// -----------------------------------------------------------------------------
// CMTPbkContactItem::ConstructL
// Symbian 2nd phase constructor can leave.
// -----------------------------------------------------------------------------
//
void CMTPbkContactItem::ConstructL()
    {
    //Read logger settings to check whether test case name is to be
    //appended to log file name.
    RSettingServer settingServer;
    TInt ret = settingServer.Connect();
    if(ret != KErrNone)
        {
        User::Leave(ret);
        }
    // Struct to StifLogger settigs.
    TLoggerSettings loggerSettings; 
    // Parse StifLogger defaults from STIF initialization file.
    ret = settingServer.GetLoggerSettings(loggerSettings);
    if(ret != KErrNone)
        {
        User::Leave(ret);
        } 
    // Close Setting server session
    settingServer.Close();

    TFileName logFileName;
    
    if(loggerSettings.iAddTestCaseTitle)
        {
        TName title;
        TestModuleIf().GetTestCaseTitleL(title);
        logFileName.Format(KMTPbkContactItemLogFileWithTitle, &title);
        }
    else
        {
        logFileName.Copy(KMTPbkContactItemLogFile);
        }

    iLog = CStifLogger::NewL( KMTPbkContactItemLogPath, 
                          logFileName,
                          CStifLogger::ETxt,
                          CStifLogger::EFile,
                          EFalse );
    
    SendTestClassVersion();
    iContactEngine = CPbkContactEngine::NewL(KTestDBName,ETrue);        
    // Initialize SindHandler. Otherwise leaks can occur.
    CPbkContactItem* item = iContactEngine->CreateEmptyContactL();
    TPbkContactItemField* field = item->VoiceTagField();
    delete item;
    
    REComSession::FinalClose();    
    
    }

// -----------------------------------------------------------------------------
// CMTPbkContactItem::NewL
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CMTPbkContactItem* CMTPbkContactItem::NewL( 
    CTestModuleIf& aTestModuleIf )
    {
    CMTPbkContactItem* self = new (ELeave) CMTPbkContactItem( aTestModuleIf );

    CleanupStack::PushL( self );
    self->ConstructL();
    CleanupStack::Pop();

    return self;

    }

// Destructor
CMTPbkContactItem::~CMTPbkContactItem()
    { 

    // Delete resources allocated from test methods
    Delete();

    // Delete logger
    delete iLog; 
    delete iContactEngine;
    }

//-----------------------------------------------------------------------------
// CMTPbkContactItem::SendTestClassVersion
// Method used to send version of test class
//-----------------------------------------------------------------------------
//
void CMTPbkContactItem::SendTestClassVersion()
	{
	TVersion moduleVersion;
	moduleVersion.iMajor = TEST_CLASS_VERSION_MAJOR;
	moduleVersion.iMinor = TEST_CLASS_VERSION_MINOR;
	moduleVersion.iBuild = TEST_CLASS_VERSION_BUILD;
	
	TFileName moduleName;
	moduleName = _L("MTPbkContactItem.dll");

	TBool newVersionOfMethod = ETrue;
	TestModuleIf().SendTestModuleVersion(moduleVersion, moduleName, newVersionOfMethod);
	}

// ========================== OTHER EXPORTED FUNCTIONS =========================

// -----------------------------------------------------------------------------
// LibEntryL is a polymorphic Dll entry point.
// Returns: CScriptBase: New CScriptBase derived object
// -----------------------------------------------------------------------------
//
EXPORT_C CScriptBase* LibEntryL( 
    CTestModuleIf& aTestModuleIf ) // Backpointer to STIF Test Framework
    {

    return ( CScriptBase* ) CMTPbkContactItem::NewL( aTestModuleIf );

    }


//  End of File
