/*
* Copyright (c) 2002 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Avkon DocAndInit test app
*
*/


// INCLUDE FILES
#include "BCTestDocAndInitApp.h"
#include "BCTestDocAndInitDocument.h"
#include <eikstart.h>

// ================= MEMBER FUNCTIONS =========================================

// ----------------------------------------------------------------------------
// TUid CBCTestDocAndInitApp::AppDllUid()
// Returns application UID.
// ----------------------------------------------------------------------------
//
TUid CBCTestDocAndInitApp::AppDllUid() const
    {
    return KUidBCTestDocAndInit;
    }

// ----------------------------------------------------------------------------
// CApaDocument* CBCTestDocAndInitApp::CreateDocumentL()
// Creates CBCTestDocAndInitDocument object.
// ----------------------------------------------------------------------------
//
CApaDocument* CBCTestDocAndInitApp::CreateDocumentL()
    {
    return CBCTestDocAndInitDocument::NewL( *this );
    }

// ================= OTHER EXPORTED FUNCTIONS =================================
//
// ----------------------------------------------------------------------------
// CApaApplication* NewApplication()
// Constructs CBCTestDocAndInitApp.
// Returns: CApaDocument*: created application object
// ----------------------------------------------------------------------------
//
LOCAL_C CApaApplication* NewApplication()
    {
    return new CBCTestDocAndInitApp;
    }

GLDEF_C TInt E32Main()
    {
    return EikStart::RunApplication(NewApplication);
    }

// End of File
