/*
* Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Filters an XML-report generated by HeaderAnalyser or OrdinalChecker,
*                using an XML-file with statuses of known issues.
*
*/


#ifndef __MAIN_H__
#define __MAIN_H__

#include <sys/stat.h>

#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/framework/LocalFileFormatTarget.hpp>
#include <sstream>
#include <iostream>
#include <fstream>
// Which environment we're compiling for
#if defined(_WIN32) || defined(WIN32)
  #define __WINDOWS__
  #define XMLCHAR XMLCh
  #define XMLLITERAL(a) (const XMLCh*)a 
#else
  #define __UNIX__
  #define XMLCHAR char
  #define XMLLITERAL(a) a
#endif

#ifdef __WINDOWS__
  #pragma warning(disable:4786)
  #pragma warning(disable:4503)
  #include <windows.h>
#else
  #define _MAX_PATH MAXPATHLEN
#endif

#ifdef WIN32
  #define DIR_SEPARATOR "\\"
#else
  #define DIR_SEPARATOR "/"
#endif

#ifdef _MSC_VER
  #include <direct.h>
  #define S_ISDIR(m)  ((m) & S_IFDIR)
#else
  #include <dirent.h>
#endif

#if (_MSC_VER >= 1300) && (WINVER < 0x0500)
  //VC7 or later, building with pre-VC7 runtime libraries
  extern "C" long _ftol( double ); //defined by VC6 C libs
  extern "C" inline long _ftol2( double dblSource ) { return _ftol( dblSource ); }
#endif

#define _X(s) XMLString::transcode(s)
#define _XX(s) XMLString::release(&s)

using namespace std;

XERCES_CPP_NAMESPACE_USE

namespace XmlTools
{
  // initialization
  int initialiseDOM();
  void uninitialiseDOM();
  
  // I/O
  XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* readFile( const char* aFilename );
  int writeFile( const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* aDocument, const char* aFilename );
  
  // extract chunks of info from XML
  void getReportDirs( const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* aReport );
  int getHeaderAttributes(const XERCES_CPP_NAMESPACE_QUALIFIER DOMElement* aHeaderNode, char* aFilename, char* aChecksum );
  XERCES_CPP_NAMESPACE_QUALIFIER DOMElement* getIssueNode( const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* aIssuesDoc, const char* aFilename, const char* aChecksum, bool &exactMatch );
  XERCES_CPP_NAMESPACE_QUALIFIER DOMElement* getIssueNode( const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* aIssuesDoc, const char* aLibname, const DOMElement* aNewFuncPos );
  
  // utility functions for getting tag nodes and values
  XERCES_CPP_NAMESPACE_QUALIFIER DOMElement* getTagNode(const XERCES_CPP_NAMESPACE_QUALIFIER DOMElement* aParentNode, const char* aTagName );
  int getTagValue(const XERCES_CPP_NAMESPACE_QUALIFIER DOMElement* aParentNode, const char* aTagName, char* aTagValue, int minLen, int maxLen );
  wstring StringToWString(const string& s);

  //SAX parser Implementation
  void parseFilesWithSAX(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* aReportDoc,const string& aissuefile);
  void parseFilesWithDOM(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* aReportDoc,const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* aIssueDoc);

  
  DOMBuilder* iParser = NULL;
  char iBaselineDir[1024];
  char iCurrentDir[1024];
 
}

class ReportFilterException 
{
public:
    /**
    * Set error message to member variable    
    * @param message error message to set
    */ 
    ReportFilterException(string message);

    /**
    * Return error message previously set
    * @return error message
    */ 
    string errorMessage();

private:
    //! Severity level of the error
    int     iSeverity;
    //! Error message to return
    string  iErrorMessage;
};

class DOMPrintErrorHandler : public DOMErrorHandler
{
public:

  DOMPrintErrorHandler(){};
  ~DOMPrintErrorHandler(){};

  //The error handler interface
  bool handleError(const DOMError& domError);
  void resetErrors(){};

private :
  // Unimplemented constructors and operators
  DOMPrintErrorHandler(const DOMErrorHandler&);
  void operator=(const DOMErrorHandler&);

};

#endif
