/*
* Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   
* THIS FILE IS AUTOGENERATED. Do not modify the contents of this file directly
* as changes will be lost
* Wed Nov 12 15:31:59 2003
* System Includes
*
*/




#include <assert.h>


/****************************************************************************************
 * 
 * Local Includes
 * 
 ***************************************************************************************/
#include "CSvcHacontroller.h"
#include "CSHacontroller.h"
#include "CComponentManager.h"


/****************************************************************************************
 * 
 * Static Variables
 * 
 ***************************************************************************************/
static CComponentManager<CSHacontroller> *iComponentManager;


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: ss_startuprpcservice
 * 
 ***************************************************************************************/
int *ss_startuprpcservice_8( TStartupInfo *aArgs, CLIENT *aDutout )
{
	static int rv;

	// if the service is already started then return an error
	if( iComponentManager != NULL ) {
		rv = ERR_SERVICE_ALREADY_STARTED;
		return &rv;
	}

	// create the component manager
	iComponentManager = new CComponentManager<CSHacontroller>( INFO_MAXIMUM_OBJECTS );
	if( iComponentManager == NULL ) {
		rv = ERR_FAILED_TO_CREATE_COMPONENT_MANAGER;
		return &rv;
	}

	// call the custom service manager
	rv = CSvcHacontroller::StartRPCService( iComponentManager, aArgs );
	if( rv != ERR_NONE ) {
		delete iComponentManager;
		iComponentManager = NULL;
		return &rv;
	}

	// success
	rv = ERR_NONE;
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: sc_shutdownrpcservice
 * 
 ***************************************************************************************/
int *sc_shutdownrpcservice_8( int *aArgs, CLIENT *aDutout )
{
	static int rv;
	int instance_count;
	int err;

	// check that the service is started
	if( iComponentManager == NULL ) {
		rv = ERR_SERVICE_NOT_RUNNING;
		return &rv;
	}

	// if there are active sessions and the force flag isn't set then return an error
	instance_count = iComponentManager->GetInstanceCount();
	if( (instance_count > 0) && (*aArgs == 0) ) {
		rv = ERR_ACTIVE_USER_SESSIONS;
		return &rv;
	};

	// if the force flag IS set then reset all active connections
	instance_count = iComponentManager->GetInstanceCount();
	if( instance_count > 0 ) {
		err = iComponentManager->DeleteAllInstances();
		if( err != 0 ) {
			rv = ERR_FAILED_TO_REMOVE_ACTIVE_SESSIONS;
			return &rv;
		}
	}

	// call the custom service manager
	rv = CSvcHacontroller::StopRPCService();
	if( rv != ERR_NONE ) {
		return &rv;
	}

	// delete the component manager
	delete iComponentManager;
	iComponentManager = NULL;

	// success
	rv = ERR_NONE;
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: list_devices
 * 
 ***************************************************************************************/
TComponentList *list_devices_8( void *aArgs, CLIENT *aDutout )
{
	static TComponentList rv;
	int i, valid_count, component_instance_count;

	//free any allocated memory
	if( rv.TComponentList_val != NULL ) {
		free( rv.TComponentList_val );
		rv.TComponentList_val = NULL;
		rv.TComponentList_len = 0;
	}

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHacontroller::SetError( LIST_DEVICES, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHacontroller::SetError( LIST_DEVICES, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the number of active component instances
	component_instance_count = iComponentManager->GetInstanceCount();

	// if there are one or more instances then allocate the memory
	if( component_instance_count > 0 ) {
		rv.TComponentList_val = (int*)malloc( sizeof(int) * component_instance_count );
		assert( rv.TComponentList_val != NULL );
		rv.TComponentList_len = component_instance_count;
	}

	// store all the currently active IDs in the list
	for( i = 0, valid_count = 0; i < INFO_MAXIMUM_OBJECTS; i++ ) {
		if( iComponentManager->IsValidKey(i) != 0 ) {
			assert( valid_count < component_instance_count );
			(rv.TComponentList_val)[valid_count++] = i;
		}
	}

	// ok return everything
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: cstr_createagent
 * 
 ***************************************************************************************/
TResult *cstr_createagent_8( void *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int result;
	int internal_err;
	int instance_key;
	CSHacontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHacontroller::SetError( CSTR_CREATEAGENT, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// create a new component instance
	instance_key = iComponentManager->CreateInstance();
	if( instance_key < 0 ) {
		CSvcHacontroller::SetError( CSTR_CREATEAGENT, (void*)&rv, instance_key );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->cstr_createagent();
	result = CSvcHacontroller::GetError( CSTR_CREATEAGENT, (void*)&rv );

	// if the method fails then we cleanup the instance -- otherwise we set the instance key
	// as the return value
	if( result != ERR_NONE ) {
		internal_err = iComponentManager->DeleteInstance( instance_key );
		assert( internal_err == 0 );
	} else { 
		CSvcHacontroller::SetError( CSTR_CREATEAGENT, (void*)&rv, instance_key );
	}

	// done
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: dstr_removeagent
 * 
 ***************************************************************************************/
TResult *dstr_removeagent_8( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int result;
	int internal_err;
	int instance_key;
	int should_delete = 1;
	CSHacontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHacontroller::SetError( DSTR_REMOVEAGENT, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// get the key for the instance from the args
	instance_key = CSvcHacontroller::GetInstanceKeyFromArgs( DSTR_REMOVEAGENT, (void*)aArgs );
	if( instance_key < 0 ) {
		CSvcHacontroller::SetError( DSTR_REMOVEAGENT, (void*)&rv, instance_key );
		return &rv;
	}
	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHacontroller::SetError( DSTR_REMOVEAGENT, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->dstr_removeagent( *aArgs, &should_delete );

	result = CSvcHacontroller::GetError( DSTR_REMOVEAGENT, (void*)&rv );

	// it is illegal for the method to succeed but not delete the instance
	assert( (result != ERR_NONE) || (should_delete == 1) );

	// delete the instance if requested
	if( should_delete != 0 ) {
		internal_err = iComponentManager->DeleteInstance( instance_key );
		assert( internal_err == ERR_NONE );
	}

	// done
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: startmobileagent
 * 
 ***************************************************************************************/
TResult *startmobileagent_8( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSHacontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHacontroller::SetError( STARTMOBILEAGENT, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHacontroller::SetError( STARTMOBILEAGENT, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHacontroller::GetInstanceKeyFromArgs( STARTMOBILEAGENT, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHacontroller::SetError( STARTMOBILEAGENT, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->startmobileagent( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: stopmobileagent
 * 
 ***************************************************************************************/
TResult *stopmobileagent_8( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSHacontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHacontroller::SetError( STOPMOBILEAGENT, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHacontroller::SetError( STOPMOBILEAGENT, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHacontroller::GetInstanceKeyFromArgs( STOPMOBILEAGENT, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHacontroller::SetError( STOPMOBILEAGENT, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->stopmobileagent( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: getmobileagentstatus
 * 
 ***************************************************************************************/
TResult *getmobileagentstatus_8( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSHacontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHacontroller::SetError( GETMOBILEAGENTSTATUS, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHacontroller::SetError( GETMOBILEAGENTSTATUS, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHacontroller::GetInstanceKeyFromArgs( GETMOBILEAGENTSTATUS, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHacontroller::SetError( GETMOBILEAGENTSTATUS, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->getmobileagentstatus( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: setsingleoption
 * 
 ***************************************************************************************/
TResult *setsingleoption_8( TOptionDesc *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSHacontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHacontroller::SetError( SETSINGLEOPTION, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHacontroller::SetError( SETSINGLEOPTION, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHacontroller::GetInstanceKeyFromArgs( SETSINGLEOPTION, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHacontroller::SetError( SETSINGLEOPTION, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->setsingleoption( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: removesingleoption
 * 
 ***************************************************************************************/
TResult *removesingleoption_8( TOptionDesc *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSHacontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHacontroller::SetError( REMOVESINGLEOPTION, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHacontroller::SetError( REMOVESINGLEOPTION, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHacontroller::GetInstanceKeyFromArgs( REMOVESINGLEOPTION, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHacontroller::SetError( REMOVESINGLEOPTION, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->removesingleoption( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: addlistoption
 * 
 ***************************************************************************************/
TResult *addlistoption_8( TOptionDesc *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSHacontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHacontroller::SetError( ADDLISTOPTION, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHacontroller::SetError( ADDLISTOPTION, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHacontroller::GetInstanceKeyFromArgs( ADDLISTOPTION, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHacontroller::SetError( ADDLISTOPTION, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->addlistoption( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: removelistoption
 * 
 ***************************************************************************************/
TResult *removelistoption_8( TOptionDesc *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSHacontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHacontroller::SetError( REMOVELISTOPTION, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHacontroller::SetError( REMOVELISTOPTION, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHacontroller::GetInstanceKeyFromArgs( REMOVELISTOPTION, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHacontroller::SetError( REMOVELISTOPTION, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->removelistoption( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: getstatus
 * 
 ***************************************************************************************/
THaStatus *getstatus_8( int *aArgs, CLIENT *aDutout )
{
	static THaStatus rv;
	int instance_key;
	CSHacontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHacontroller::SetError( GETSTATUS, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHacontroller::SetError( GETSTATUS, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHacontroller::GetInstanceKeyFromArgs( GETSTATUS, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHacontroller::SetError( GETSTATUS, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->getstatus( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: destroytunnelid
 * 
 ***************************************************************************************/
TResult *destroytunnelid_8( THaTunnelID *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSHacontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHacontroller::SetError( DESTROYTUNNELID, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHacontroller::SetError( DESTROYTUNNELID, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHacontroller::GetInstanceKeyFromArgs( DESTROYTUNNELID, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHacontroller::SetError( DESTROYTUNNELID, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->destroytunnelid( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: listtunnels
 * 
 ***************************************************************************************/
THaTunnelList *listtunnels_8( int *aArgs, CLIENT *aDutout )
{
	static THaTunnelList rv;
	int instance_key;
	CSHacontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHacontroller::SetError( LISTTUNNELS, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHacontroller::SetError( LISTTUNNELS, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHacontroller::GetInstanceKeyFromArgs( LISTTUNNELS, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHacontroller::SetError( LISTTUNNELS, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->listtunnels( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: gettunnelinfo
 * 
 ***************************************************************************************/
THaTunnelInfo *gettunnelinfo_8( TGetTunnelRequest *aArgs, CLIENT *aDutout )
{
	static THaTunnelInfo rv;
	int instance_key;
	CSHacontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHacontroller::SetError( GETTUNNELINFO, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHacontroller::SetError( GETTUNNELINFO, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHacontroller::GetInstanceKeyFromArgs( GETTUNNELINFO, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHacontroller::SetError( GETTUNNELINFO, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->gettunnelinfo( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: settimeout
 * 
 ***************************************************************************************/
void *settimeout_8( TTimeoutRequest *aArgs, CLIENT *aDutout )
{
	static int rv;
	int instance_key;
	CSHacontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		rv = ERR_SERVICE_NOT_RUNNING;
		return &rv;
	}

	// set the return value to generic error
	rv = ERR_FAILED_TO_RETRIEVE_KEY;

	// get the key for the instance from the args
	instance_key = CSvcHacontroller::GetInstanceKeyFromArgs( SETTIMEOUT, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		rv = ERR_INSTANCE_DOES_NOT_EXIST;
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = ERR_NONE;
	session->settimeout( *aArgs );
	return &rv;
}
