/*
* Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   
* This file was autogenerated by rpcgen, but should be modified by the developer.
* Make sure you don't use the -component_mod flag in future or this file will be overwritten.
* Wed Nov 05 16:06:20 2003
*
*/




#ifndef __CSVCUUINTERFACE_H__
#define __CSVCUUINTERFACE_H__


/****************************************************************************************
 * 
 * Local Includes
 * 
 ***************************************************************************************/
#include "uuinterface.h"
#include "CSUuinterface.h"
#include "CComponentManager.h"

/****************************************************************************************
 * 
 * Defines
 * 
 ***************************************************************************************/
#define MAX_COMMANDLINE			256	
#define TOTAL_MAX_ADDRESS_LEN	128
#define MAX_PORT_VAL			65535
#define MIN_PORT_VAL			0

 /****************************************************************************************
 * 
 * Definition: CSvcUuinterface
 * 
 ***************************************************************************************/
class CSvcUuinterface
{
public:
	/* standard methods */
	static int GetInstanceKeyFromArgs( int aMethod, void *aArgs );
	static int SetError( int aMethod, void *aArgs, int aError );
	static int GetError( int aMethod, void *aArgs );
	static int StartRPCService( CComponentManager<CSUuinterface> *aComponentManager, TStartupInfo *aArg );
	static int StopRPCService();

	/* custom methods */
	static TResult st_setdelay( TConfigValue aArgs );
	static TResult st_setdroppercentage( TConfigValue aArgs );
	static TResult st_setduplicatepercentage( TConfigValue aArgs );
	static TResult st_setbandwidth( TConfigValue aArgs );
	static TResult st_setdrd( TConfigValue aArgs );
	static TResult st_clearsettings( TConfigValue aArgs );
	static TResult st_stopservice( void );
	static TResult st_reset( void );

private:
	static int execute(const char* aCommandLine, TResult* rv);
	
	// Methods to validate args
	static int CheckDRDs( const int aDRDMinInt, const int aDRDMinFrac, const int aDRDMaxInt, const int aDRDMaxFrac, const int aDRDCongestInt, const int aDRDCongestFrac );
	static int CheckPercentage(const int aPercentage);
	static int CheckCorrelation( int aIntegerPart, int aFractionPart );
	static int CheckPositive( int aIntegerPart, int aFractionPart );
	static int CheckPorts( int aSrcPort, int DestPort );
	static int CheckProt( int aProtocol );
	static int GetSrcDstStrings( char* aSrc, char* aDst, 
								int aSrcProt,
								int aSrcPort,int aDstPort,
								char* finalSrc, char* finalDst );
	static int CheckConfigValue( TConfigValue aConfigValue, char* aFinalSrc, char* aFinalDst);

};

#endif
