/*
* Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   
* This file was autogenerated by rpcgen, but should be modified by the developer.
* Make sure you don't use the -component_mod flag in future or this file will be overwritten.
* Wed Oct 01 17:43:02 2003
* System Includes
*
*/




#include <stdio.h>


/****************************************************************************************
 * 
 * Local Includes
 * 
 ***************************************************************************************/
#include "CSvcMncontroller.h"
#include "mncontroller.h"
#include "standard_service_manager.h"


/****************************************************************************************
 * 
 * File-scope variables
 * 
 ***************************************************************************************/
static CComponentManager<CSMncontroller> *iComponentManager;


/****************************************************************************************
 * 
 * Implementation
 * 
 ***************************************************************************************/


/****************************************************************************************
 * 
 * PUBLIC: GetInstanceKeyFromArgs
 * 
 ***************************************************************************************/
int CSvcMncontroller::GetInstanceKeyFromArgs( int aMethod, void *aArgs )
{
	int rv;
	int *integer_ik;
	TOptionDesc *option_ik;
	TTunnelingModeDesc *tunnel_mode_ik;
	TPolicyRequest *policy_ik;
	TTimeoutRequest *timeout_ik;
	TForeignAgentInfoRequest *fa_info_ik;
	THomeAddressDesc *home_address_desc_ik;

	switch( aMethod ) {

	// Handle cases where there is an integer argument that is the instance key
	case DSTR_REMOVEAGENT:
	case STARTMOBILEAGENT:
	case STOPMOBILEAGENT:
	case GETMOBILEAGENTSTATUS:
	case GETCAREOFADDRESS:
	case DISCONNECT:
	case CONFIRM:
	case RESCANINTERFACES:
	case GETFAPOLICY:
	case GETSTATUS:
	case LISTFOREIGNAGENTS:
		integer_ik = (int*)aArgs;
		rv = *integer_ik;
		break;

	// Handle options
	case SETSINGLEOPTION:
	case REMOVESINGLEOPTION:
	case ADDLISTOPTION:
	case REMOVELISTOPTION:
		option_ik = (TOptionDesc*)aArgs;
		rv = option_ik->iAgentID;
		break;

	// THomeAddressDesc
	case SETHOMEADDRESS:
		home_address_desc_ik = (THomeAddressDesc*)aArgs;
		rv = home_address_desc_ik->iAgentID;
		break;

	// TForeignAgentInfoRequest
	case GETFOREIGNAGENTINFO:
		fa_info_ik = (TForeignAgentInfoRequest*)aArgs;
		rv = fa_info_ik->iAgentID;
		break;

	// Connect
	case CONNECT:
		tunnel_mode_ik = (TTunnelingModeDesc*)aArgs;
		rv = tunnel_mode_ik->iAgentID;
		break;

	// Policy
	case SETFAPOLICY:
		policy_ik = (TPolicyRequest*)aArgs;
		rv = policy_ik->iAgentID;
		break;

	// Timeout
	case SETTIMEOUT:
		timeout_ik = (TTimeoutRequest*)aArgs;
		rv = timeout_ik->iAgentID;
		break;

	// Default
	default:
		rv = ERR_INVALID_METHOD;
		break;
	}
	return rv;
}


/****************************************************************************************
 * 
 * PUBLIC: SetError
 * 
 ***************************************************************************************/
int CSvcMncontroller::SetError( int aMethod, void *aArgs, int aError )
{
	int rv = ERR_NONE;
	TResult *result_rv;
	TComponentList *result_cl;
	TForeignAgentList *result_fal;
	TForeignAgentInfo *result_fai;
	TMobileNodeStatus *result_status;

	switch( aMethod ) {

	// Handle the TResult case
	case CSTR_CREATEAGENT:
	case STARTMOBILEAGENT:
	case STOPMOBILEAGENT:
	case GETMOBILEAGENTSTATUS:
	case SETSINGLEOPTION:
	case REMOVESINGLEOPTION:
	case ADDLISTOPTION:
	case REMOVELISTOPTION:
	case SETHOMEADDRESS:
	case SETFAPOLICY:
	case GETFAPOLICY:
	case CONNECT:
	case DISCONNECT:
	case CONFIRM:
	case RESCANINTERFACES:
	case GETCAREOFADDRESS:
		SET_ERROR_CODE( TResult, iServiceResult, result_rv );
		break;

	// Handle TMobileNodeStatus
	case GETSTATUS:
		result_status = (TMobileNodeStatus*)aArgs;
		memset( result_status, 0, sizeof(*result_status) );
		(result_status->iCallResult).iServiceResult = aError;
		break;

	// Handle ListDevices
	case LIST_DEVICES:
	    SET_LIST_ERROR_CODE( TComponentList, result_cl );
		break;

	// List Foreign Agents	
	case LISTFOREIGNAGENTS:
	    SET_LIST_ERROR_CODE( TForeignAgentList, result_fal );
		break;

	// Foreign agent info
	case GETFOREIGNAGENTINFO:
		result_fai = (TForeignAgentInfo*)aArgs;
		memset( result_fai, 0, sizeof(*result_fai) );
		(result_fai->iCallResult).iServiceResult = aError;
		break;

	// Default
	default:
		rv = ERR_INVALID_METHOD;
		break;
	}
	return rv;
}


/****************************************************************************************
 * 
 * PUBLIC: GetError
 * 
 ***************************************************************************************/
int CSvcMncontroller::GetError( int aMethod, void *aArgs )
{
	TResult *result;

	// check assumption
	assert( aMethod == CSTR_CREATEAGENT );

	// return error code
	result = (TResult*)aArgs;
	return result->iServiceResult;
}


/****************************************************************************************
 * 
 * PUBLIC: StartRPCService
 * 
 ***************************************************************************************/
int CSvcMncontroller::StartRPCService( CComponentManager<CSMncontroller> *aComponentManager, void *aArg )
{
	assert( iComponentManager == NULL );
	iComponentManager = aComponentManager;
	return ERR_NONE;
}


/****************************************************************************************
 * 
 * PUBLIC: StopRPCService
 * 
 ***************************************************************************************/
int CSvcMncontroller::StopRPCService()
{
	iComponentManager = NULL;
	return ERR_NONE;
}
